/*! \file pio_meta.h
 *
 * Meta information for libpio which can be used by other packages which
 * depend on libpio.
 *
 * This file is automatically generated by the build system
 * at configure time, and contains information related to
 * how libpio was built.  It will not be required to
 * include this file unless you want to probe the capabilities
 * of libpio. This should ideally only happen when configuring
 * a project which depends on libpio.  At configure time,
 * the dependent project can set its own macros which can be used
 * in conditionals.
 *
 * Ed Hartnett, 7/14/20 Happy Bastille Day!
 */

#ifndef PIO_META_H
#define PIO_META_H

#define PIO_VERSION_MAJOR 2 /*!< pio-c major version. */
#define PIO_VERSION_MINOR 5 /*!< pio-c minor version. */
#define PIO_VERSION_PATCH 4 /*!< pio-c patch version. */
#define PIO_VERSION       "2.5.4"

#define PIO_HAS_SZIP_WRITE  0  /*!< szip write support */
#define PIO_HAS_PNETCDF     1     /*!< PnetCDF support. */
#define PIO_HAS_PAR_FILTERS 1 /*!< NetCDF supports parallel I/O with filters. */
#define PIO_HAS_NETCDF4     1     /*!< NetCDF-4 supported. */
#define PIO_HAS_NETCDF4_PAR 1 /*!< NetCDF-4 parallel I/O supported. */
#define PIO_HAS_NETCDF_INTEGRATION 1 /*!< NetCDF integration supported. */
#define PIO_HAS_LOGGING     @PIO_HAS_LOGGING@     /*!< PIO logging turned on. */

#endif
