!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../scripts/genf90.pl
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ 'piodarray'
#include "config.h"
!>
!! @file
!! Read and write routines for decomposed data.
!>
!! @defgroup PIO_write_darray Write from Distributed Arrays
!! The overloaded PIO_write_darray writes a distributed array to
!! disk in Fortran.
!!
!! @defgroup PIO_read_darray Read to Distributed Arrays
!! The overloaded PIO_read_darray function reads a distributed array
!! from disk in Fortran.
!<
module piodarray
  use pio_types, only : file_desc_t, io_desc_t, var_desc_t
  use pio_kinds, only : i2, i4, r4, r8, pio_offset_kind
  use pio_support, only : piodie
  use iso_c_binding
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf   !_EXTERNAL
#endif
  implicit none

  private
  public :: pio_read_darray, pio_write_darray, pio_set_buffer_size_limit

# 28 "piodarray.F90.in"
  interface PIO_write_darray
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_1d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_2d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_3d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_4d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_5d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_6d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_7d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_1d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_2d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_3d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_4d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_5d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_6d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_7d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_1d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_2d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_3d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_4d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_5d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_6d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_7d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_1d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_2d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_3d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_4d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_5d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_6d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure write_darray_7d_short
! TYPE real,int,double,short
     module procedure write_darray_multi_1d_real
! TYPE real,int,double,short
     module procedure write_darray_multi_1d_int
! TYPE real,int,double,short
     module procedure write_darray_multi_1d_double
! TYPE real,int,double,short
     module procedure write_darray_multi_1d_short
  end interface

# 36 "piodarray.F90.in"
  interface PIO_read_darray
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_1d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_2d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_3d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_4d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_5d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_6d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_7d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_1d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_2d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_3d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_4d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_5d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_6d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_7d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_1d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_2d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_3d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_4d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_5d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_6d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_7d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_1d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_2d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_3d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_4d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_5d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_6d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
     module procedure read_darray_7d_short
  end interface


  character(len=*), parameter, private  :: modName='piodarray'

# 45 "piodarray.F90.in"
interface
# 46 "piodarray.F90.in"
   integer(C_INT) function PIOc_write_darray(ncid, vid, ioid, arraylen, array, fillvalue) &
        bind(C,name="PIOc_write_darray")
     use iso_c_binding
     integer(C_INT), value :: ncid
     integer(C_INT), value :: vid
     integer(C_INT), value :: ioid
     integer(C_SIZE_T), value :: arraylen
     type(c_ptr), value :: array
     type(C_PTR), value :: fillvalue
# 55 "piodarray.F90.in"
   end function PIOc_write_darray
end interface

# 58 "piodarray.F90.in"
interface
# 59 "piodarray.F90.in"
   integer(C_INT) function PIOc_write_darray_multi(ncid, vid, ioid, nvars, arraylen, array, fillvalue) &
        bind(C,name="PIOc_write_darray_multi")
     use iso_c_binding
     integer(C_INT), value :: ncid
     integer(C_INT), value :: nvars
     integer(C_INT) :: vid(nvars)
     integer(C_INT), value :: ioid
     integer(C_SIZE_T), value :: arraylen
     type(c_ptr), value :: array
     type(C_PTR), value :: fillvalue
# 69 "piodarray.F90.in"
   end function PIOc_write_darray_multi
end interface

# 72 "piodarray.F90.in"
interface
# 73 "piodarray.F90.in"
   integer(C_INT) function PIOc_read_darray(ncid, vid, ioid, arraylen, array) &
        bind(C,name="PIOc_read_darray")
     use iso_c_binding
     integer(C_INT), value :: ncid
     integer(C_INT), value :: vid
     integer(C_INT), value :: ioid
     integer(C_SIZE_T), value :: arraylen
     type(C_PTR), value :: array
# 81 "piodarray.F90.in"
   end function PIOc_read_darray
end interface


# 85 "piodarray.F90.in"
contains
  !> Set buffer size limit.
# 87 "piodarray.F90.in"
  subroutine pio_set_buffer_size_limit(limit)
    integer(PIO_OFFSET_KIND), intent(in) :: limit
    integer(PIO_OFFSET_KIND) :: oldval
# 90 "piodarray.F90.in"
    interface
# 91 "piodarray.F90.in"
       integer(C_LONG_LONG) function PIOc_set_buffer_size_limit(limit) &
            bind(C,name="PIOc_set_buffer_size_limit")
         use iso_c_binding
         integer(C_LONG_LONG), value :: limit
# 95 "piodarray.F90.in"
       end function PIOc_set_buffer_size_limit
    end interface
    if(limit<0) then
       call piodie(__PIO_FILE__,__LINE__,' bad value to buffer_size_limit: ',int(limit))
    end if
    oldval = PIOc_set_buffer_size_limit(limit)

# 102 "piodarray.F90.in"
  end subroutine pio_set_buffer_size_limit

! TYPE real,int,double,short
  !> 1D write_darray for type real. Writes a 2-d slab of TYPE to a
  !! netcdf file.
  !<
# 108 "piodarray.F90.in"
  subroutine write_darray_1d_cinterface_real (File,varDesc,ioDesc, arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), dimension(*), target, intent(in) ::  &
         array                 ! array to be written

    real(r4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    carraylen = int(arraylen,C_SIZE_T)
    cptr = C_LOC(array)
#ifdef TIMING
    call t_startf("PIO:write_darray_real")
#endif
    if(present(fillval)) then
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen, cptr, C_NULL_PTR)
    endif
#ifdef TIMING
    call t_stopf("PIO:write_darray_real")
#endif
# 141 "piodarray.F90.in"
  end subroutine write_darray_1d_cinterface_real
! TYPE real,int,double,short
  !> 1D write_darray for type int. Writes a 2-d slab of TYPE to a
  !! netcdf file.
  !<
# 108 "piodarray.F90.in"
  subroutine write_darray_1d_cinterface_int (File,varDesc,ioDesc, arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), dimension(*), target, intent(in) ::  &
         array                 ! array to be written

    integer(i4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    carraylen = int(arraylen,C_SIZE_T)
    cptr = C_LOC(array)
#ifdef TIMING
    call t_startf("PIO:write_darray_int")
#endif
    if(present(fillval)) then
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen, cptr, C_NULL_PTR)
    endif
#ifdef TIMING
    call t_stopf("PIO:write_darray_int")
#endif
# 141 "piodarray.F90.in"
  end subroutine write_darray_1d_cinterface_int
! TYPE real,int,double,short
  !> 1D write_darray for type double. Writes a 2-d slab of TYPE to a
  !! netcdf file.
  !<
# 108 "piodarray.F90.in"
  subroutine write_darray_1d_cinterface_double (File,varDesc,ioDesc, arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), dimension(*), target, intent(in) ::  &
         array                 ! array to be written

    real(r8), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    carraylen = int(arraylen,C_SIZE_T)
    cptr = C_LOC(array)
#ifdef TIMING
    call t_startf("PIO:write_darray_double")
#endif
    if(present(fillval)) then
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen, cptr, C_NULL_PTR)
    endif
#ifdef TIMING
    call t_stopf("PIO:write_darray_double")
#endif
# 141 "piodarray.F90.in"
  end subroutine write_darray_1d_cinterface_double
! TYPE real,int,double,short
  !> 1D write_darray for type short. Writes a 2-d slab of TYPE to a
  !! netcdf file.
  !<
# 108 "piodarray.F90.in"
  subroutine write_darray_1d_cinterface_short (File,varDesc,ioDesc, arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), dimension(*), target, intent(in) ::  &
         array                 ! array to be written

    integer(i2), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    carraylen = int(arraylen,C_SIZE_T)
    cptr = C_LOC(array)
#ifdef TIMING
    call t_startf("PIO:write_darray_short")
#endif
    if(present(fillval)) then
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray(file%fh, varDesc%varid-1, iodesc%ioid, carraylen, cptr, C_NULL_PTR)
    endif
#ifdef TIMING
    call t_stopf("PIO:write_darray_short")
#endif
# 141 "piodarray.F90.in"
  end subroutine write_darray_1d_cinterface_short

! TYPE real,int,double,short
  !> 1D write_darray_multi for type real. Writes a 2-d slab of TYPE to a netcdf file.
# 145 "piodarray.F90.in"
  subroutine write_darray_multi_1d_cinterface_real (File,varDesc,ioDesc,nvars,arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer, intent(in) :: nvars

    real(r4), dimension(*), target, intent(in) ::  array                ! array to be written

    real(r4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_INT) :: varid(nvars)
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    integer :: i
    carraylen = int(arraylen,C_SIZE_T)

    cptr = C_LOC(array)
    do i=1,nvars
       varid(i) = vardesc(i)%varid-1
    end do

    if(present(fillval)) then
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen, cptr, C_NULL_PTR)
    endif

# 181 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_cinterface_real
! TYPE real,int,double,short
  !> 1D write_darray_multi for type int. Writes a 2-d slab of TYPE to a netcdf file.
# 145 "piodarray.F90.in"
  subroutine write_darray_multi_1d_cinterface_int (File,varDesc,ioDesc,nvars,arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer, intent(in) :: nvars

    integer(i4), dimension(*), target, intent(in) ::  array                ! array to be written

    integer(i4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_INT) :: varid(nvars)
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    integer :: i
    carraylen = int(arraylen,C_SIZE_T)

    cptr = C_LOC(array)
    do i=1,nvars
       varid(i) = vardesc(i)%varid-1
    end do

    if(present(fillval)) then
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen, cptr, C_NULL_PTR)
    endif

# 181 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_cinterface_int
! TYPE real,int,double,short
  !> 1D write_darray_multi for type double. Writes a 2-d slab of TYPE to a netcdf file.
# 145 "piodarray.F90.in"
  subroutine write_darray_multi_1d_cinterface_double (File,varDesc,ioDesc,nvars,arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer, intent(in) :: nvars

    real(r8), dimension(*), target, intent(in) ::  array                ! array to be written

    real(r8), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_INT) :: varid(nvars)
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    integer :: i
    carraylen = int(arraylen,C_SIZE_T)

    cptr = C_LOC(array)
    do i=1,nvars
       varid(i) = vardesc(i)%varid-1
    end do

    if(present(fillval)) then
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen, cptr, C_NULL_PTR)
    endif

# 181 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_cinterface_double
! TYPE real,int,double,short
  !> 1D write_darray_multi for type short. Writes a 2-d slab of TYPE to a netcdf file.
# 145 "piodarray.F90.in"
  subroutine write_darray_multi_1d_cinterface_short (File,varDesc,ioDesc,nvars,arraylen, array, iostat, fillval)
    use iso_c_binding
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer, intent(in) :: nvars

    integer(i2), dimension(*), target, intent(in) ::  array                ! array to be written

    integer(i2), optional, target, intent(in) :: fillval    ! rearrange receiver fill value

    integer,intent(in) :: arraylen
    integer(i4), intent(out) :: iostat
    integer(C_INT) :: varid(nvars)
    integer(C_SIZE_T) :: carraylen
    type(C_PTR) :: cptr
    integer :: i
    carraylen = int(arraylen,C_SIZE_T)

    cptr = C_LOC(array)
    do i=1,nvars
       varid(i) = vardesc(i)%varid-1
    end do

    if(present(fillval)) then
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen,cptr, C_LOC(fillval))
    else
       iostat = PIOc_write_darray_multi(file%fh, varid, iodesc%ioid, nvars, carraylen, cptr, C_NULL_PTR)
    endif

# 181 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_cinterface_short

! TYPE real,int,double,short
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 1D array of type real. Writes a block of TYPE to a netcdf file.
  !!
  !! @param File    \ref file_desc_t
  !! @param varDesc \ref var_desc_t
  !! @param ioDesc  \ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 196 "piodarray.F90.in"
  subroutine write_darray_multi_1d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    real(r4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_real'
    integer :: nvars

    nvars = size(vardesc)

    call write_darray_multi_1d_cinterface_real (file, varDesc, iodesc, nvars, size(array), array, iostat, fillval)

# 219 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_real
! TYPE real,int,double,short
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 1D array of type int. Writes a block of TYPE to a netcdf file.
  !!
  !! @param File    \ref file_desc_t
  !! @param varDesc \ref var_desc_t
  !! @param ioDesc  \ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 196 "piodarray.F90.in"
  subroutine write_darray_multi_1d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    integer(i4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_int'
    integer :: nvars

    nvars = size(vardesc)

    call write_darray_multi_1d_cinterface_int (file, varDesc, iodesc, nvars, size(array), array, iostat, fillval)

# 219 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_int
! TYPE real,int,double,short
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 1D array of type double. Writes a block of TYPE to a netcdf file.
  !!
  !! @param File    \ref file_desc_t
  !! @param varDesc \ref var_desc_t
  !! @param ioDesc  \ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 196 "piodarray.F90.in"
  subroutine write_darray_multi_1d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    real(r8), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_double'
    integer :: nvars

    nvars = size(vardesc)

    call write_darray_multi_1d_cinterface_double (file, varDesc, iodesc, nvars, size(array), array, iostat, fillval)

# 219 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_double
! TYPE real,int,double,short
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 1D array of type short. Writes a block of TYPE to a netcdf file.
  !!
  !! @param File    \ref file_desc_t
  !! @param varDesc \ref var_desc_t
  !! @param ioDesc  \ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 196 "piodarray.F90.in"
  subroutine write_darray_multi_1d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc(:)                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    integer(i2), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_short'
    integer :: nvars

    nvars = size(vardesc)

    call write_darray_multi_1d_cinterface_short (file, varDesc, iodesc, nvars, size(array), array, iostat, fillval)

# 219 "piodarray.F90.in"
  end subroutine write_darray_multi_1d_short

! TYPE real,int,double,short
  !> Writes a block of TYPE to a netcdf file.
# 223 "piodarray.F90.in"
  subroutine write_darray_1d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    real(r4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_real'

    call write_darray_1d_cinterface_real (file, varDesc, iodesc, size(array), array, iostat, fillval)

# 243 "piodarray.F90.in"
  end subroutine write_darray_1d_real
! TYPE real,int,double,short
  !> Writes a block of TYPE to a netcdf file.
# 223 "piodarray.F90.in"
  subroutine write_darray_1d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    integer(i4), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_int'

    call write_darray_1d_cinterface_int (file, varDesc, iodesc, size(array), array, iostat, fillval)

# 243 "piodarray.F90.in"
  end subroutine write_darray_1d_int
! TYPE real,int,double,short
  !> Writes a block of TYPE to a netcdf file.
# 223 "piodarray.F90.in"
  subroutine write_darray_1d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    real(r8), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_double'

    call write_darray_1d_cinterface_double (file, varDesc, iodesc, size(array), array, iostat, fillval)

# 243 "piodarray.F90.in"
  end subroutine write_darray_1d_double
! TYPE real,int,double,short
  !> Writes a block of TYPE to a netcdf file.
# 223 "piodarray.F90.in"
  subroutine write_darray_1d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), dimension(:), target, intent(in) ::  &
         array                 ! array to be written

    integer(i2), optional, target, intent(in) :: fillval    ! rearrange receiver fill value
    integer(i4), intent(out) :: iostat

    character(len=*), parameter :: subName=modName//'::write_darray_short'

    call write_darray_1d_cinterface_short (file, varDesc, iodesc, size(array), array, iostat, fillval)

# 243 "piodarray.F90.in"
  end subroutine write_darray_1d_short

! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 2D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_2d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_2d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 3D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_3d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_3d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 4D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_4d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:,:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_4d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 5D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_5d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:,:,:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_5d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 6D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_6d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:,:,:,:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_6d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 7D array of type real.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_7d_real (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r4), intent(in) ::  &
         array(:,:,:,:,:,:,:)                 ! array to be written

    real(r4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_real (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_real (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_real (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_7d_real
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 2D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_2d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_2d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 3D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_3d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_3d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 4D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_4d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:,:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_4d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 5D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_5d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:,:,:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_5d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 6D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_6d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:,:,:,:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_6d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 7D array of type int.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_7d_int (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i4), intent(in) ::  &
         array(:,:,:,:,:,:,:)                 ! array to be written

    integer(i4), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i4) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i4), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_int (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_int (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_int (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_7d_int
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 2D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_2d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_2d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 3D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_3d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_3d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 4D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_4d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:,:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_4d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 5D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_5d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:,:,:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_5d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 6D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_6d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:,:,:,:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_6d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 7D array of type double.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_7d_double (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    real(r8), intent(in) ::  &
         array(:,:,:,:,:,:,:)                 ! array to be written

    real(r8), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    real(r8) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    real(r8), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_double (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_double (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_double (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_7d_double
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 2D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_2d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_2d_short
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 3D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_3d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_3d_short
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 4D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_4d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:,:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_4d_short
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 5D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_5d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:,:,:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_5d_short
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 6D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_6d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:,:,:,:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_6d_short
! TYPE real,int,double,short
! DIMS 2,3,4,5,6,7
  !>
  !! @ingroup PIO_write_darray
  !! Writes a 7D array of type short.
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc  @ref io_desc_t
  !! @param array  : The data to be written
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @param fillval : An optional fill value to fill holes in the data written
  !! @author Jim Edwards
  !<
# 259 "piodarray.F90.in"
  subroutine write_darray_7d_short (File,varDesc,ioDesc, array, iostat, fillval)
    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! variable descriptor

    integer(i2), intent(in) ::  &
         array(:,:,:,:,:,:,:)                 ! array to be written

    integer(i2), optional, intent(in) :: fillval    ! rearrange receiver fill value

    integer(i4), intent(out) :: iostat
    integer(i2) :: transvar(1), dumbvar(0)

! This code is required due to a bug in gfortran 4.7.2
#if (__GFORTRAN__) &&  (__GNUC__ == 4) && (__GNUC_MINOR__ < 8)
    integer(i2), allocatable :: acopy(:)
    integer :: isize

    isize= size(array)
    allocate(acopy(isize))
    acopy = reshape(array,(/isize/))
    call write_darray_1d_short (File, varDesc, iodesc, acopy, iostat, fillval)
    deallocate(acopy)
    return
#else
! cannot call transfer function with a 0 sized array
    if(size(array)==0) then
       call write_darray_1d_short (File, varDesc, iodesc, dumbvar, iostat)
    else
       call write_darray_1d_short (File, varDesc, iodesc, transfer(array,transvar), iostat, fillval)
    end if
#endif
# 296 "piodarray.F90.in"
  end subroutine write_darray_7d_short

! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 1 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_1d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_1d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 2 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_2d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_2d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 3 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_3d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_3d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 4 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_4d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_4d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 5 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_5d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_5d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 6 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_6d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_6d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type real from a netCDF variable of 7 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_7d_real (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r4), intent(out) ::  array(:,:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_real (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_7d_real
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 1 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_1d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_1d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 2 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_2d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_2d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 3 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_3d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_3d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 4 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_4d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_4d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 5 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_5d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_5d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 6 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_6d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_6d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type int from a netCDF variable of 7 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_7d_int (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i4), intent(out) ::  array(:,:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_int (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_7d_int
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 1 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_1d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_1d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 2 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_2d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_2d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 3 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_3d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_3d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 4 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_4d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_4d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 5 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_5d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_5d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 6 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_6d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_6d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type double from a netCDF variable of 7 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_7d_double (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    real(r8), intent(out) ::  array(:,:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_double (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_7d_double
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 1 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_1d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_1d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 2 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_2d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_2d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 3 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_3d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_3d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 4 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_4d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_4d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 5 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_5d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_5d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 6 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_6d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_6d_short
! TYPE real,int,double,short
! DIMS 1,2,3,4,5,6,7
  !>
  !! @ingroup PIO_read_darray
  !! Read distributed array of type short from a netCDF variable of 7 dimension(s).
  !!
  !! @param File @ref file_desc_t
  !! @param varDesc @ref var_desc_t
  !! @param ioDesc @ref io_desc_t
  !! @param array  : The read data
  !! @param iostat : The status returned from this routine (see \ref PIO_seterrorhandling for details)
  !! @author Jim Edwards
  !<
# 311 "piodarray.F90.in"
  subroutine read_darray_7d_short (File,varDesc, ioDesc, array, iostat)
    use iso_c_binding

    type (File_desc_t), intent(inout) :: &
         File                   ! file information

    type (var_desc_t), intent(inout) :: &
         varDesc                      ! variable descriptor

    type (io_desc_t), intent(inout) :: &
         ioDesc                      ! iodecomp descriptor

    integer(i2), intent(out) ::  array(:,:,:,:,:,:,:)                 ! array to be read

    integer(i4), intent(out) :: iostat
    integer(C_SIZE_T) :: tlen

    tlen = size(array)
    ! array is intent out but may not be fully filled by read_darray
    array = 0
    call read_darray_internal_short (File%fh, vardesc%varid, iodesc%ioid, tlen, array, iostat)

# 333 "piodarray.F90.in"
  end subroutine read_darray_7d_short

! TYPE real,int,double,short
  !> Internal read_darray for type real
# 337 "piodarray.F90.in"
  subroutine read_darray_internal_real (ncid, varid, ioid, alen, array, iostat)
    use iso_c_binding
    integer, intent(in) :: ncid, varid, ioid
    integer(C_SIZE_T), intent(in) :: alen

    real(r4), target ::  array(*)                 ! array to be read

    integer(i4), intent(out) :: iostat
    type(C_PTR) :: cptr
    character(len=*), parameter :: subName=modName//'::read_darray_real'

    cptr = C_LOC(array)
    iostat = PIOc_read_darray(ncid, varid-1, ioid, alen, cptr)

# 351 "piodarray.F90.in"
  end subroutine read_darray_internal_real
! TYPE real,int,double,short
  !> Internal read_darray for type int
# 337 "piodarray.F90.in"
  subroutine read_darray_internal_int (ncid, varid, ioid, alen, array, iostat)
    use iso_c_binding
    integer, intent(in) :: ncid, varid, ioid
    integer(C_SIZE_T), intent(in) :: alen

    integer(i4), target ::  array(*)                 ! array to be read

    integer(i4), intent(out) :: iostat
    type(C_PTR) :: cptr
    character(len=*), parameter :: subName=modName//'::read_darray_int'

    cptr = C_LOC(array)
    iostat = PIOc_read_darray(ncid, varid-1, ioid, alen, cptr)

# 351 "piodarray.F90.in"
  end subroutine read_darray_internal_int
! TYPE real,int,double,short
  !> Internal read_darray for type double
# 337 "piodarray.F90.in"
  subroutine read_darray_internal_double (ncid, varid, ioid, alen, array, iostat)
    use iso_c_binding
    integer, intent(in) :: ncid, varid, ioid
    integer(C_SIZE_T), intent(in) :: alen

    real(r8), target ::  array(*)                 ! array to be read

    integer(i4), intent(out) :: iostat
    type(C_PTR) :: cptr
    character(len=*), parameter :: subName=modName//'::read_darray_double'

    cptr = C_LOC(array)
    iostat = PIOc_read_darray(ncid, varid-1, ioid, alen, cptr)

# 351 "piodarray.F90.in"
  end subroutine read_darray_internal_double
! TYPE real,int,double,short
  !> Internal read_darray for type short
# 337 "piodarray.F90.in"
  subroutine read_darray_internal_short (ncid, varid, ioid, alen, array, iostat)
    use iso_c_binding
    integer, intent(in) :: ncid, varid, ioid
    integer(C_SIZE_T), intent(in) :: alen

    integer(i2), target ::  array(*)                 ! array to be read

    integer(i4), intent(out) :: iostat
    type(C_PTR) :: cptr
    character(len=*), parameter :: subName=modName//'::read_darray_short'

    cptr = C_LOC(array)
    iostat = PIOc_read_darray(ncid, varid-1, ioid, alen, cptr)

# 351 "piodarray.F90.in"
  end subroutine read_darray_internal_short

end module piodarray
