!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../scripts/genf90.pl
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ "pionfatt_mod.F90"
#include "config.h"
!>
!! @file
!! @brief NetCDF attribute interface to PIO
!<
!>
!!  @defgroup PIO_put_att Write Attributes
!!  Writes an attribute to a file in Fortran.
!<
!>
!! @defgroup PIO_get_att Read Attributes
!! Reads an attribute from a file in Fortran.
!<

module pionfatt_mod
  use pio_kinds, only : r4, r8, i4, i2, pio_offset_kind
  use pio_types
  use pio_support, only : replace_c_null
  use iso_c_binding
  implicit none


  !>
  !! @private
  !<
  public :: put_att
# 28 "pionfatt_mod.F90.in"
  interface put_att
     module procedure put_att_id_text, put_att_desc_text, put_att_vid_text
     module procedure put_att_id_real, put_att_desc_real, put_att_vid_real
     module procedure put_att_id_double, put_att_desc_double, put_att_vid_double
     module procedure put_att_id_int, put_att_desc_int, put_att_vid_int
     module procedure put_att_id_short, put_att_desc_short, put_att_vid_short
     ! TYPE real,int,double,short
     module procedure put_att_1d_id_real
     ! TYPE real,int,double,short
     module procedure put_att_1d_id_int
     ! TYPE real,int,double,short
     module procedure put_att_1d_id_double
     ! TYPE real,int,double,short
     module procedure put_att_1d_id_short
     ! TYPE real,int,double,short
     module procedure put_att_1d_desc_real
     ! TYPE real,int,double,short
     module procedure put_att_1d_desc_int
     ! TYPE real,int,double,short
     module procedure put_att_1d_desc_double
     ! TYPE real,int,double,short
     module procedure put_att_1d_desc_short
     ! TYPE real,int,double,short
     module procedure put_att_1d_vid_real
     ! TYPE real,int,double,short
     module procedure put_att_1d_vid_int
     ! TYPE real,int,double,short
     module procedure put_att_1d_vid_double
     ! TYPE real,int,double,short
     module procedure put_att_1d_vid_short
  end interface

  !>
  !! @private
  !<
  public :: get_att
# 42 "pionfatt_mod.F90.in"
  interface get_att
     module procedure get_att_text, get_att_desc_text, get_att_id_text
     module procedure get_att_real, get_att_desc_real, get_att_id_real
     module procedure get_att_double, get_att_desc_double, get_att_id_double
     module procedure get_att_int, get_att_desc_int, get_att_id_int
     module procedure get_att_short, get_att_desc_short, get_att_id_short
     ! TYPE real,int,double,short
     module procedure get_att_1d_real, get_att_desc_1d_real, get_att_1d_id_real
     ! TYPE real,int,double,short
     module procedure get_att_1d_int, get_att_desc_1d_int, get_att_1d_id_int
     ! TYPE real,int,double,short
     module procedure get_att_1d_double, get_att_desc_1d_double, get_att_1d_id_double
     ! TYPE real,int,double,short
     module procedure get_att_1d_short, get_att_desc_1d_short, get_att_1d_id_short
  end interface

  !>
  !! @private
  !<
  public :: inq_var_fill
# 52 "pionfatt_mod.F90.in"
  interface inq_var_fill
     ! TYPE double,int,short,real
     module procedure inq_var_fill_double
     ! TYPE double,int,short,real
     module procedure inq_var_fill_int
     ! TYPE double,int,short,real
     module procedure inq_var_fill_short
     ! TYPE double,int,short,real
     module procedure inq_var_fill_real
  end interface inq_var_fill

  !> @cond doxygen_cant_handle_so_exclude
  private :: modName
  character(len=*), parameter :: modName='pionfatt_mod'
# 60 "pionfatt_mod.F90.in"
  interface
# 61 "pionfatt_mod.F90.in"
     integer(C_INT) function PIOc_put_att_text (ncid, varid, name, len, op) &
          bind(C,name="PIOc_put_att_text")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       integer(C_SIZE_T), value :: len
       character(C_char)        :: op
# 69 "pionfatt_mod.F90.in"
     end function PIOc_put_att_text
  end interface
# 71 "pionfatt_mod.F90.in"
  interface
# 72 "pionfatt_mod.F90.in"
     integer(C_INT) function PIOc_get_att_text (ncid, varid, name, op) &
          bind(C,name="PIOc_get_att_text")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       character(C_char)        :: op(*)
# 79 "pionfatt_mod.F90.in"
     end function PIOc_get_att_text
  end interface

# 82 "pionfatt_mod.F90.in"
  interface
# 84 "pionfatt_mod.F90.in"
     ! TYPE int,double,short
     integer(C_INT) function PIOc_put_att_int (ncid, varid, name, xtype, len, op) &
          bind(C,name="PIOc_put_att_int")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       integer(C_INT), value    :: xtype
       integer(C_SIZE_T), value :: len
       integer(C_INT)                  :: op
# 93 "pionfatt_mod.F90.in"
     end function PIOc_put_att_int
     ! TYPE int,double,short
     integer(C_INT) function PIOc_put_att_double (ncid, varid, name, xtype, len, op) &
          bind(C,name="PIOc_put_att_double")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       integer(C_INT), value    :: xtype
       integer(C_SIZE_T), value :: len
       real(C_DOUBLE)                  :: op
# 93 "pionfatt_mod.F90.in"
     end function PIOc_put_att_double
     ! TYPE int,double,short
     integer(C_INT) function PIOc_put_att_short (ncid, varid, name, xtype, len, op) &
          bind(C,name="PIOc_put_att_short")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       integer(C_INT), value    :: xtype
       integer(C_SIZE_T), value :: len
       integer(C_SHORT)                  :: op
# 93 "pionfatt_mod.F90.in"
     end function PIOc_put_att_short
  end interface
# 95 "pionfatt_mod.F90.in"
  interface
# 97 "pionfatt_mod.F90.in"
     ! TYPE int,double,short
     integer(C_INT) function PIOc_get_att_int (ncid, varid, name, op) &
          bind(C,name="PIOc_get_att_int")
       use iso_c_binding
       integer(C_INT), value         :: ncid
       integer(C_INT), value         :: varid
       character(C_CHAR)             :: name(*)
       integer(C_INT),        intent(out)   :: op
# 104 "pionfatt_mod.F90.in"
     end function PIOc_get_att_int
     ! TYPE int,double,short
     integer(C_INT) function PIOc_get_att_double (ncid, varid, name, op) &
          bind(C,name="PIOc_get_att_double")
       use iso_c_binding
       integer(C_INT), value         :: ncid
       integer(C_INT), value         :: varid
       character(C_CHAR)             :: name(*)
       real(C_DOUBLE),        intent(out)   :: op
# 104 "pionfatt_mod.F90.in"
     end function PIOc_get_att_double
     ! TYPE int,double,short
     integer(C_INT) function PIOc_get_att_short (ncid, varid, name, op) &
          bind(C,name="PIOc_get_att_short")
       use iso_c_binding
       integer(C_INT), value         :: ncid
       integer(C_INT), value         :: varid
       character(C_CHAR)             :: name(*)
       integer(C_SHORT),        intent(out)   :: op
# 104 "pionfatt_mod.F90.in"
     end function PIOc_get_att_short
  end interface
# 106 "pionfatt_mod.F90.in"
  interface
# 107 "pionfatt_mod.F90.in"
     integer(C_INT) function PIOc_put_att_float (ncid, varid, name, xtype, len, op) &
          bind(C,name="PIOc_put_att_float")
       use iso_c_binding
       integer(C_INT), value    :: ncid
       integer(C_INT), value    :: varid
       character(C_CHAR)        :: name(*)
       integer(C_INT), value    :: xtype
       integer(C_SIZE_T), value :: len
       real(C_FLOAT)            :: op
# 116 "pionfatt_mod.F90.in"
     end function PIOc_put_att_float
  end interface
# 118 "pionfatt_mod.F90.in"
  interface
# 119 "pionfatt_mod.F90.in"
      integer(C_INT) function PIOc_get_att_float (ncid, varid, name, op) &
          bind(C,name="PIOc_get_att_float")
       use iso_c_binding
       integer(C_INT), value         :: ncid
       integer(C_INT), value         :: varid
       character(C_CHAR)             :: name(*)
       real(C_FLOAT),        intent(out)   :: op
# 126 "pionfatt_mod.F90.in"
     end function PIOc_get_att_float
  end interface
# 128 "pionfatt_mod.F90.in"
  interface
# 129 "pionfatt_mod.F90.in"
     integer(C_INT) function PIOc_inq_var_fill (ncid, varid, no_fill, fillvalue) &
          bind(C, name="PIOc_inq_var_fill")
       use iso_c_binding
       integer(C_INT), value       :: ncid
       integer(C_INT), value       :: varid
       integer(C_INT), intent(out) :: no_fill
       type(C_PTR), value          :: fillvalue
# 136 "pionfatt_mod.F90.in"
     end function PIOc_inq_var_fill
  end interface
  !> @endcond

# 140 "pionfatt_mod.F90.in"
contains
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_inq_var_fill
  !! @brief Inquires about var fill value
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param vdesc : The netcdf variable descriptor
  !! @param no_fill : whether this variable has no_fill enabled
  !! @param fillvalue : the fillvalue used for this variable, returns default if not set.
  !! @retval ierr @copydoc error_return
  !<
# 154 "pionfatt_mod.F90.in"
  integer function inq_var_fill_real (File, vdesc, no_fill, fillvalue) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    ! fillvalue needs to not be optional to avoid ambiguity
    integer, intent(out) :: no_fill
    real(r4), target, intent(out) :: fillvalue

    ierr = PIOc_inq_var_fill (File%fh, vdesc%varid-1, no_fill, C_LOC(fillvalue))

# 163 "pionfatt_mod.F90.in"
  end function inq_var_fill_real
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_inq_var_fill
  !! @brief Inquires about var fill value
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param vdesc : The netcdf variable descriptor
  !! @param no_fill : whether this variable has no_fill enabled
  !! @param fillvalue : the fillvalue used for this variable, returns default if not set.
  !! @retval ierr @copydoc error_return
  !<
# 154 "pionfatt_mod.F90.in"
  integer function inq_var_fill_double (File, vdesc, no_fill, fillvalue) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    ! fillvalue needs to not be optional to avoid ambiguity
    integer, intent(out) :: no_fill
    real(r8), target, intent(out) :: fillvalue

    ierr = PIOc_inq_var_fill (File%fh, vdesc%varid-1, no_fill, C_LOC(fillvalue))

# 163 "pionfatt_mod.F90.in"
  end function inq_var_fill_double
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_inq_var_fill
  !! @brief Inquires about var fill value
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param vdesc : The netcdf variable descriptor
  !! @param no_fill : whether this variable has no_fill enabled
  !! @param fillvalue : the fillvalue used for this variable, returns default if not set.
  !! @retval ierr @copydoc error_return
  !<
# 154 "pionfatt_mod.F90.in"
  integer function inq_var_fill_int (File, vdesc, no_fill, fillvalue) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    ! fillvalue needs to not be optional to avoid ambiguity
    integer, intent(out) :: no_fill
    integer(i4), target, intent(out) :: fillvalue

    ierr = PIOc_inq_var_fill (File%fh, vdesc%varid-1, no_fill, C_LOC(fillvalue))

# 163 "pionfatt_mod.F90.in"
  end function inq_var_fill_int
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_inq_var_fill
  !! @brief Inquires about var fill value
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param vdesc : The netcdf variable descriptor
  !! @param no_fill : whether this variable has no_fill enabled
  !! @param fillvalue : the fillvalue used for this variable, returns default if not set.
  !! @retval ierr @copydoc error_return
  !<
# 154 "pionfatt_mod.F90.in"
  integer function inq_var_fill_short (File, vdesc, no_fill, fillvalue) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    ! fillvalue needs to not be optional to avoid ambiguity
    integer, intent(out) :: no_fill
    integer(i2), target, intent(out) :: fillvalue

    ierr = PIOc_inq_var_fill (File%fh, vdesc%varid-1, no_fill, C_LOC(fillvalue))

# 163 "pionfatt_mod.F90.in"
  end function inq_var_fill_short

  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param vdesc : The netcdf variable descriptor
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 176 "pionfatt_mod.F90.in"
  integer function put_att_desc_text (File, vdesc, name, values) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    character(len=*), intent(in)  :: name
    character(len=*), intent(in) :: values

    ierr = put_att_id_text (File%fh,vdesc%varid,name,values)

# 184 "pionfatt_mod.F90.in"
  end function put_att_desc_text
# 176 "pionfatt_mod.F90.in"
  integer function put_att_desc_real (File, vdesc, name, values) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    character(len=*), intent(in)  :: name
    real(r4), intent(in) :: values

    ierr = put_att_id_real (File%fh,vdesc%varid,name,values)

# 184 "pionfatt_mod.F90.in"
  end function put_att_desc_real
# 176 "pionfatt_mod.F90.in"
  integer function put_att_desc_double (File, vdesc, name, values) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    character(len=*), intent(in)  :: name
    real(r8), intent(in) :: values

    ierr = put_att_id_double (File%fh,vdesc%varid,name,values)

# 184 "pionfatt_mod.F90.in"
  end function put_att_desc_double
# 176 "pionfatt_mod.F90.in"
  integer function put_att_desc_int (File, vdesc, name, values) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    character(len=*), intent(in)  :: name
    integer(i4), intent(in) :: values

    ierr = put_att_id_int (File%fh,vdesc%varid,name,values)

# 184 "pionfatt_mod.F90.in"
  end function put_att_desc_int
# 176 "pionfatt_mod.F90.in"
  integer function put_att_desc_short (File, vdesc, name, values) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in)  :: vdesc
    character(len=*), intent(in)  :: name
    integer(i2), intent(in) :: values

    ierr = put_att_id_short (File%fh,vdesc%varid,name,values)

# 184 "pionfatt_mod.F90.in"
  end function put_att_desc_short
# 185 "pionfatt_mod.F90.in"
  integer function put_att_vid_text (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: value

    ierr = put_att_id_text (File%fh,varid,name,value)

# 193 "pionfatt_mod.F90.in"
  end function put_att_vid_text
# 185 "pionfatt_mod.F90.in"
  integer function put_att_vid_real (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(in) :: value

    ierr = put_att_id_real (File%fh,varid,name,value)

# 193 "pionfatt_mod.F90.in"
  end function put_att_vid_real
# 185 "pionfatt_mod.F90.in"
  integer function put_att_vid_double (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(in) :: value

    ierr = put_att_id_double (File%fh,varid,name,value)

# 193 "pionfatt_mod.F90.in"
  end function put_att_vid_double
# 185 "pionfatt_mod.F90.in"
  integer function put_att_vid_int (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(in) :: value

    ierr = put_att_id_int (File%fh,varid,name,value)

# 193 "pionfatt_mod.F90.in"
  end function put_att_vid_int
# 185 "pionfatt_mod.F90.in"
  integer function put_att_vid_short (File, varid, name, value) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i2), intent(in) :: value

    ierr = put_att_id_short (File%fh,varid,name,value)

# 193 "pionfatt_mod.F90.in"
  end function put_att_vid_short
  ! TYPE int,real,double,short
# 195 "pionfatt_mod.F90.in"
  integer function put_att_id_int (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(in) :: values


    ierr = PIOc_put_att_int (ncid,varid-1,trim(name)//C_NULL_CHAR, PIO_int, 1_C_SIZE_T, values)

# 205 "pionfatt_mod.F90.in"
  end function put_att_id_int
  ! TYPE int,real,double,short
# 195 "pionfatt_mod.F90.in"
  integer function put_att_id_real (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(in) :: values


    ierr = PIOc_put_att_float (ncid,varid-1,trim(name)//C_NULL_CHAR, PIO_real, 1_C_SIZE_T, values)

# 205 "pionfatt_mod.F90.in"
  end function put_att_id_real
  ! TYPE int,real,double,short
# 195 "pionfatt_mod.F90.in"
  integer function put_att_id_double (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(in) :: values


    ierr = PIOc_put_att_double (ncid,varid-1,trim(name)//C_NULL_CHAR, PIO_double, 1_C_SIZE_T, values)

# 205 "pionfatt_mod.F90.in"
  end function put_att_id_double
  ! TYPE int,real,double,short
# 195 "pionfatt_mod.F90.in"
  integer function put_att_id_short (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i2), intent(in) :: values


    ierr = PIOc_put_att_short (ncid,varid-1,trim(name)//C_NULL_CHAR, PIO_short, 1_C_SIZE_T, values)

# 205 "pionfatt_mod.F90.in"
  end function put_att_id_short
# 206 "pionfatt_mod.F90.in"
  integer function put_att_id_text (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: values
    character(c_char), allocatable :: cvar(:)
    integer(C_SIZE_T) :: clen
    integer :: i

    clen = len_trim(values)
    allocate(cvar(clen+1))
    cvar = C_NULL_CHAR
    do i=1,int(clen)
       cvar(i) = values(i:i)
    end do
    ierr = PIOc_put_att_text (ncid,varid-1,trim(name)//C_NULL_CHAR, clen, cvar(1))
    deallocate(cvar)
# 224 "pionfatt_mod.F90.in"
  end function put_att_id_text

# 226 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_text (ncid, varid, name, value) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    character(len=*), intent(in) :: value(:)
    character, allocatable :: nvalue(:)
    integer :: slen, alen, i, j, k

    slen = len(value(1))
    alen = size(value)
    allocate(nvalue(slen*alen))

    do i=1,alen
       j= len_trim(value(i))
       do k=1,j
          nvalue(k+(i-1)*slen) = value(i)(k:k)
       end do
       nvalue(j+1+(i-1)*slen) = C_NULL_CHAR
    end do
    ierr =  put_att_1d_id_text_internal (ncid, varid, name, slen*alen, nvalue)

    deallocate(nvalue)

# 250 "pionfatt_mod.F90.in"
  end function put_att_1d_id_text


# 253 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_text_internal (ncid, varid, name, arrlen, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer, intent(in) :: arrlen
    character(len=*), intent(in) :: values(arrlen)


    ierr = PIOc_put_att_text (ncid,varid-1,trim(name)//C_NULL_CHAR, int(arrlen,C_SIZE_T),values(1))


# 265 "pionfatt_mod.F90.in"
  end function put_att_1d_id_text_internal



# 269 "pionfatt_mod.F90.in"
  integer function get_att_id_text (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    character(len=*), intent(out) :: values

    values = ' '
    ierr = PIOc_get_att_text (ncid,varid-1,trim(name)//C_NULL_CHAR, values)
    call replace_c_null(values)
# 279 "pionfatt_mod.F90.in"
  end function get_att_id_text

  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param ncid @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 294 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_real (ncid, varid, name, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(in) :: values(:)
    integer(PIO_OFFSET_KIND) :: len

    len = size(values)
    ierr = put_att_1d_id_internal_real (ncid, varid, name, len, values)

# 304 "pionfatt_mod.F90.in"
  end function put_att_1d_id_real
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param ncid @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 294 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_double (ncid, varid, name, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(in) :: values(:)
    integer(PIO_OFFSET_KIND) :: len

    len = size(values)
    ierr = put_att_1d_id_internal_double (ncid, varid, name, len, values)

# 304 "pionfatt_mod.F90.in"
  end function put_att_1d_id_double
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param ncid @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 294 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_int (ncid, varid, name, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(in) :: values(:)
    integer(PIO_OFFSET_KIND) :: len

    len = size(values)
    ierr = put_att_1d_id_internal_int (ncid, varid, name, len, values)

# 304 "pionfatt_mod.F90.in"
  end function put_att_1d_id_int
  ! TYPE real,double,int,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param ncid @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 294 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_short (ncid, varid, name, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i2), intent(in) :: values(:)
    integer(PIO_OFFSET_KIND) :: len

    len = size(values)
    ierr = put_att_1d_id_internal_short (ncid, varid, name, len, values)

# 304 "pionfatt_mod.F90.in"
  end function put_att_1d_id_short

  ! TYPE real,double,int,short
# 307 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_internal_real (ncid, varid, name, len, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(PIO_OFFSET_KIND), intent(in) :: len
    character(len=*), intent(in) :: name
    real(r4), intent(in), target :: values(*)


    ierr = PIOc_put_att_float (ncid, varid-1, trim(name)//C_NULL_CHAR, PIO_real , len, values(1))

# 317 "pionfatt_mod.F90.in"
  end function put_att_1d_id_internal_real
  ! TYPE real,double,int,short
# 307 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_internal_double (ncid, varid, name, len, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(PIO_OFFSET_KIND), intent(in) :: len
    character(len=*), intent(in) :: name
    real(r8), intent(in), target :: values(*)


    ierr = PIOc_put_att_double (ncid, varid-1, trim(name)//C_NULL_CHAR, PIO_double , len, values(1))

# 317 "pionfatt_mod.F90.in"
  end function put_att_1d_id_internal_double
  ! TYPE real,double,int,short
# 307 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_internal_int (ncid, varid, name, len, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(PIO_OFFSET_KIND), intent(in) :: len
    character(len=*), intent(in) :: name
    integer(i4), intent(in), target :: values(*)


    ierr = PIOc_put_att_int (ncid, varid-1, trim(name)//C_NULL_CHAR, PIO_int , len, values(1))

# 317 "pionfatt_mod.F90.in"
  end function put_att_1d_id_internal_int
  ! TYPE real,double,int,short
# 307 "pionfatt_mod.F90.in"
  integer function put_att_1d_id_internal_short (ncid, varid, name, len, values) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(PIO_OFFSET_KIND), intent(in) :: len
    character(len=*), intent(in) :: name
    integer(i2), intent(in), target :: values(*)


    ierr = PIOc_put_att_short (ncid, varid-1, trim(name)//C_NULL_CHAR, PIO_short , len, values(1))

# 317 "pionfatt_mod.F90.in"
  end function put_att_1d_id_internal_short


  ! TYPE real,int,double,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 332 "pionfatt_mod.F90.in"
  integer function put_att_1d_desc_real (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(in)      :: values(:)

    ierr = put_att_1d_id_real (File%fh,varDesc%varid,name,values)

# 341 "pionfatt_mod.F90.in"
  end function put_att_1d_desc_real
  ! TYPE real,int,double,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 332 "pionfatt_mod.F90.in"
  integer function put_att_1d_desc_int (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(in)      :: values(:)

    ierr = put_att_1d_id_int (File%fh,varDesc%varid,name,values)

# 341 "pionfatt_mod.F90.in"
  end function put_att_1d_desc_int
  ! TYPE real,int,double,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 332 "pionfatt_mod.F90.in"
  integer function put_att_1d_desc_double (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(in)      :: values(:)

    ierr = put_att_1d_id_double (File%fh,varDesc%varid,name,values)

# 341 "pionfatt_mod.F90.in"
  end function put_att_1d_desc_double
  ! TYPE real,int,double,short
  !>
  !! @public
  !! @ingroup PIO_put_att
  !! @brief Writes an netcdf attribute to a file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to add
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 332 "pionfatt_mod.F90.in"
  integer function put_att_1d_desc_short (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i2), intent(in)      :: values(:)

    ierr = put_att_1d_id_short (File%fh,varDesc%varid,name,values)

# 341 "pionfatt_mod.F90.in"
  end function put_att_1d_desc_short

# 343 "pionfatt_mod.F90.in"
  integer function put_att_1d_vid_text (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    integer, intent(in) :: varid
    character(len=*), intent(in)      :: name
    character(len=*), intent(in)      :: value(:)

    ierr = put_att_1d_id_text (File%fh,varid,name,value)

# 352 "pionfatt_mod.F90.in"
  end function put_att_1d_vid_text
# 343 "pionfatt_mod.F90.in"
  integer function put_att_1d_vid_real (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    integer, intent(in) :: varid
    character(len=*), intent(in)      :: name
    real(r4), intent(in)      :: value(:)

    ierr = put_att_1d_id_real (File%fh,varid,name,value)

# 352 "pionfatt_mod.F90.in"
  end function put_att_1d_vid_real
# 343 "pionfatt_mod.F90.in"
  integer function put_att_1d_vid_double (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    integer, intent(in) :: varid
    character(len=*), intent(in)      :: name
    real(r8), intent(in)      :: value(:)

    ierr = put_att_1d_id_double (File%fh,varid,name,value)

# 352 "pionfatt_mod.F90.in"
  end function put_att_1d_vid_double
# 343 "pionfatt_mod.F90.in"
  integer function put_att_1d_vid_int (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    integer, intent(in) :: varid
    character(len=*), intent(in)      :: name
    integer(i4), intent(in)      :: value(:)

    ierr = put_att_1d_id_int (File%fh,varid,name,value)

# 352 "pionfatt_mod.F90.in"
  end function put_att_1d_vid_int
# 343 "pionfatt_mod.F90.in"
  integer function put_att_1d_vid_short (File,varid,name,value) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    integer, intent(in) :: varid
    character(len=*), intent(in)      :: name
    integer(i2), intent(in)      :: value(:)

    ierr = put_att_1d_id_short (File%fh,varid,name,value)

# 352 "pionfatt_mod.F90.in"
  end function put_att_1d_vid_short

  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 365 "pionfatt_mod.F90.in"
  integer function get_att_desc_text (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    character(len=*), intent(out)      :: values

    ierr = get_att_text (File,varDesc%varid,name,values)

# 374 "pionfatt_mod.F90.in"
  end function get_att_desc_text
# 365 "pionfatt_mod.F90.in"
  integer function get_att_desc_real (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(out)      :: values

    ierr = get_att_real (File,varDesc%varid,name,values)

# 374 "pionfatt_mod.F90.in"
  end function get_att_desc_real
# 365 "pionfatt_mod.F90.in"
  integer function get_att_desc_double (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(out)      :: values

    ierr = get_att_double (File,varDesc%varid,name,values)

# 374 "pionfatt_mod.F90.in"
  end function get_att_desc_double
# 365 "pionfatt_mod.F90.in"
  integer function get_att_desc_int (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(out)      :: values

    ierr = get_att_int (File,varDesc%varid,name,values)

# 374 "pionfatt_mod.F90.in"
  end function get_att_desc_int
# 365 "pionfatt_mod.F90.in"
  integer function get_att_desc_short (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i2), intent(out)      :: values

    ierr = get_att_short (File,varDesc%varid,name,values)

# 374 "pionfatt_mod.F90.in"
  end function get_att_desc_short

  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varDesc @copydoc var_desc_t
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
  ! TYPE int,real,double,short
# 388 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_int (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i4), intent(out)      :: values(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_int'

    ierr = get_att_1d_id_int (File%fh,varDesc%varid,name,values)

# 399 "pionfatt_mod.F90.in"
  end function get_att_desc_1d_int
  ! TYPE int,real,double,short
# 388 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_real (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r4), intent(out)      :: values(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_real'

    ierr = get_att_1d_id_real (File%fh,varDesc%varid,name,values)

# 399 "pionfatt_mod.F90.in"
  end function get_att_desc_1d_real
  ! TYPE int,real,double,short
# 388 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_double (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    real(r8), intent(out)      :: values(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_double'

    ierr = get_att_1d_id_double (File%fh,varDesc%varid,name,values)

# 399 "pionfatt_mod.F90.in"
  end function get_att_desc_1d_double
  ! TYPE int,real,double,short
# 388 "pionfatt_mod.F90.in"
  integer function get_att_desc_1d_short (File,varDesc,name,values) result(ierr)

    type (File_desc_t), intent(inout) , target :: File
    type (VAR_desc_t), intent(in)     :: varDesc
    character(len=*), intent(in)      :: name
    integer(i2), intent(out)      :: values(:)

    character(len=*), parameter :: subName=modName//'::get_att_desc_1d_short'

    ierr = get_att_1d_id_short (File%fh,varDesc%varid,name,values)

# 399 "pionfatt_mod.F90.in"
  end function get_att_desc_1d_short

  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param ncid : The netcdf file ID
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
  ! TYPE int,real,double,short
# 413 "pionfatt_mod.F90.in"
  integer function get_att_id_int (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i4), intent(out), target :: values


    ierr = PIOc_get_att_int (ncid,varid-1,trim(name)//C_NULL_CHAR, values)

# 423 "pionfatt_mod.F90.in"
  end function get_att_id_int
  ! TYPE int,real,double,short
# 413 "pionfatt_mod.F90.in"
  integer function get_att_id_real (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r4), intent(out), target :: values


    ierr = PIOc_get_att_float (ncid,varid-1,trim(name)//C_NULL_CHAR, values)

# 423 "pionfatt_mod.F90.in"
  end function get_att_id_real
  ! TYPE int,real,double,short
# 413 "pionfatt_mod.F90.in"
  integer function get_att_id_double (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    real(r8), intent(out), target :: values


    ierr = PIOc_get_att_double (ncid,varid-1,trim(name)//C_NULL_CHAR, values)

# 423 "pionfatt_mod.F90.in"
  end function get_att_id_double
  ! TYPE int,real,double,short
# 413 "pionfatt_mod.F90.in"
  integer function get_att_id_short (ncid, varid, name, values) result(ierr)
    use iso_c_binding
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    character(len=*), intent(in) :: name
    integer(i2), intent(out), target :: values


    ierr = PIOc_get_att_short (ncid,varid-1,trim(name)//C_NULL_CHAR, values)

# 423 "pionfatt_mod.F90.in"
  end function get_att_id_short



# 427 "pionfatt_mod.F90.in"
  integer function get_att_text (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    character(len=*), intent(out)          :: values


    ierr = get_att_id_text (file%fh, varid, name, values)


# 437 "pionfatt_mod.F90.in"
  end function get_att_text
# 427 "pionfatt_mod.F90.in"
  integer function get_att_real (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r4), intent(out)          :: values


    ierr = get_att_id_real (file%fh, varid, name, values)


# 437 "pionfatt_mod.F90.in"
  end function get_att_real
# 427 "pionfatt_mod.F90.in"
  integer function get_att_double (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r8), intent(out)          :: values


    ierr = get_att_id_double (file%fh, varid, name, values)


# 437 "pionfatt_mod.F90.in"
  end function get_att_double
# 427 "pionfatt_mod.F90.in"
  integer function get_att_int (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i4), intent(out)          :: values


    ierr = get_att_id_int (file%fh, varid, name, values)


# 437 "pionfatt_mod.F90.in"
  end function get_att_int
# 427 "pionfatt_mod.F90.in"
  integer function get_att_short (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i2), intent(out)          :: values


    ierr = get_att_id_short (file%fh, varid, name, values)


# 437 "pionfatt_mod.F90.in"
  end function get_att_short

  ! TYPE real,int,short,double
  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 451 "pionfatt_mod.F90.in"
  integer function get_att_1d_real (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r4), intent(out)          :: values(:)

    ierr = get_att_1d_id_real (file%fh, varid, name, values)

# 459 "pionfatt_mod.F90.in"
  end function get_att_1d_real
  ! TYPE real,int,short,double
  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 451 "pionfatt_mod.F90.in"
  integer function get_att_1d_int (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i4), intent(out)          :: values(:)

    ierr = get_att_1d_id_int (file%fh, varid, name, values)

# 459 "pionfatt_mod.F90.in"
  end function get_att_1d_int
  ! TYPE real,int,short,double
  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 451 "pionfatt_mod.F90.in"
  integer function get_att_1d_short (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i2), intent(out)          :: values(:)

    ierr = get_att_1d_id_short (file%fh, varid, name, values)

# 459 "pionfatt_mod.F90.in"
  end function get_att_1d_short
  ! TYPE real,int,short,double
  !>
  !! @public
  !! @ingroup PIO_get_att
  !! @brief Reads an netcdf attribute from a  file
  !! @details
  !! @param File @copydoc file_desc_t
  !! @param varid : The netcdf variable identifier
  !! @param name : name of the attribute to get
  !! @param values : The value for the netcdf attribute
  !! @retval ierr @copydoc error_return
  !<
# 451 "pionfatt_mod.F90.in"
  integer function get_att_1d_double (File,varid,name,values) result(ierr)
    type (File_desc_t), intent(in) , target :: File
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r8), intent(out)          :: values(:)

    ierr = get_att_1d_id_double (file%fh, varid, name, values)

# 459 "pionfatt_mod.F90.in"
  end function get_att_1d_double


  ! TYPE real,int,short,double
# 463 "pionfatt_mod.F90.in"
  integer function get_att_1d_id_real (ncid,varid,name,values) result(ierr)
    integer, intent(in) :: ncid
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r4), intent(out) , target         :: values(*)

    ierr = PIOc_get_att_float (ncid, varid-1, trim(name)//C_NULL_CHAR, values(1))


# 472 "pionfatt_mod.F90.in"
  end function get_att_1d_id_real
  ! TYPE real,int,short,double
# 463 "pionfatt_mod.F90.in"
  integer function get_att_1d_id_int (ncid,varid,name,values) result(ierr)
    integer, intent(in) :: ncid
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i4), intent(out) , target         :: values(*)

    ierr = PIOc_get_att_int (ncid, varid-1, trim(name)//C_NULL_CHAR, values(1))


# 472 "pionfatt_mod.F90.in"
  end function get_att_1d_id_int
  ! TYPE real,int,short,double
# 463 "pionfatt_mod.F90.in"
  integer function get_att_1d_id_short (ncid,varid,name,values) result(ierr)
    integer, intent(in) :: ncid
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    integer(i2), intent(out) , target         :: values(*)

    ierr = PIOc_get_att_short (ncid, varid-1, trim(name)//C_NULL_CHAR, values(1))


# 472 "pionfatt_mod.F90.in"
  end function get_att_1d_id_short
  ! TYPE real,int,short,double
# 463 "pionfatt_mod.F90.in"
  integer function get_att_1d_id_double (ncid,varid,name,values) result(ierr)
    integer, intent(in) :: ncid
    integer(i4), intent(in)        :: varid
    character(len=*), intent(in)   :: name
    real(r8), intent(out) , target         :: values(*)

    ierr = PIOc_get_att_double (ncid, varid-1, trim(name)//C_NULL_CHAR, values(1))


# 472 "pionfatt_mod.F90.in"
  end function get_att_1d_id_double


end module pionfatt_mod
