!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../scripts/genf90.pl
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ "pionfget_mod.F90"
#include "config.h"
!>
!! @file
!! @brief Read Routines for non-decomposed NetCDF data.
!<
!>
!! @defgroup PIO_get_var Read Non-Decomposed Data
!! Reads non-decomposed data from a NetCDF file in Fortran.  The
!! get_var interface is provided as a simplified interface to read
!! variables from a NetCDF format file. The variable is read on the
!! root IO task and broadcast in its entirety to all tasks.
!<
module pionfget_mod
  use iso_c_binding
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf      ! _EXTERNAL
#endif
  use pio_kinds, only: i2,i4,r4,r8, pio_offset_kind
  use pio_types, only : file_desc_t, var_desc_t
  use pio_support, only : replace_c_null
  implicit none
  private
  public :: get_var
# 25 "pionfget_mod.F90.in"
  interface get_var
     module procedure get_var_0d_text, get_var_vdesc_0d_text
     module procedure get_var_1d_text, get_var_vdesc_1d_text
     module procedure get_var_2d_text, get_var_vdesc_2d_text
     module procedure get_var_3d_text, get_var_vdesc_3d_text
     module procedure get_var_4d_text, get_var_vdesc_4d_text
     module procedure get_var_5d_text, get_var_vdesc_5d_text
     module procedure get_var_0d_real, get_var_vdesc_0d_real
     module procedure get_var_1d_real, get_var_vdesc_1d_real
     module procedure get_var_2d_real, get_var_vdesc_2d_real
     module procedure get_var_3d_real, get_var_vdesc_3d_real
     module procedure get_var_4d_real, get_var_vdesc_4d_real
     module procedure get_var_5d_real, get_var_vdesc_5d_real
     module procedure get_var_0d_double, get_var_vdesc_0d_double
     module procedure get_var_1d_double, get_var_vdesc_1d_double
     module procedure get_var_2d_double, get_var_vdesc_2d_double
     module procedure get_var_3d_double, get_var_vdesc_3d_double
     module procedure get_var_4d_double, get_var_vdesc_4d_double
     module procedure get_var_5d_double, get_var_vdesc_5d_double
     module procedure get_var_0d_int, get_var_vdesc_0d_int
     module procedure get_var_1d_int, get_var_vdesc_1d_int
     module procedure get_var_2d_int, get_var_vdesc_2d_int
     module procedure get_var_3d_int, get_var_vdesc_3d_int
     module procedure get_var_4d_int, get_var_vdesc_4d_int
     module procedure get_var_5d_int, get_var_vdesc_5d_int
     module procedure get_var_0d_short, get_var_vdesc_0d_short
     module procedure get_var_1d_short, get_var_vdesc_1d_short
     module procedure get_var_2d_short, get_var_vdesc_2d_short
     module procedure get_var_3d_short, get_var_vdesc_3d_short
     module procedure get_var_4d_short, get_var_vdesc_4d_short
     module procedure get_var_5d_short, get_var_vdesc_5d_short
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_text, get_vara_vdesc_1d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_text, get_vara_vdesc_2d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_text, get_vara_vdesc_3d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_text, get_vara_vdesc_4d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_text, get_vara_vdesc_5d_text
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_real, get_vara_vdesc_1d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_real, get_vara_vdesc_2d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_real, get_vara_vdesc_3d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_real, get_vara_vdesc_4d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_real, get_vara_vdesc_5d_real
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_double, get_vara_vdesc_1d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_double, get_vara_vdesc_2d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_double, get_vara_vdesc_3d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_double, get_vara_vdesc_4d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_double, get_vara_vdesc_5d_double
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_int, get_vara_vdesc_1d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_int, get_vara_vdesc_2d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_int, get_vara_vdesc_3d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_int, get_vara_vdesc_4d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_int, get_vara_vdesc_5d_int
     !  DIMS 1,2,3,4,5
     module procedure get_vara_1d_short, get_vara_vdesc_1d_short
     !  DIMS 1,2,3,4,5
     module procedure get_vara_2d_short, get_vara_vdesc_2d_short
     !  DIMS 1,2,3,4,5
     module procedure get_vara_3d_short, get_vara_vdesc_3d_short
     !  DIMS 1,2,3,4,5
     module procedure get_vara_4d_short, get_vara_vdesc_4d_short
     !  DIMS 1,2,3,4,5
     module procedure get_vara_5d_short, get_vara_vdesc_5d_short
     module procedure get_var1_text, get_var1_vdesc_text
     module procedure get_var1_real, get_var1_vdesc_real
     module procedure get_var1_double, get_var1_vdesc_double
     module procedure get_var1_int, get_var1_vdesc_int
     module procedure get_var1_short, get_var1_vdesc_short
  end interface

 character(len=*), parameter :: modName='pionfget_mod'

# 34 "pionfget_mod.F90.in"
 interface
# 35 "pionfget_mod.F90.in"
    integer(C_INT) function PIOc_get_var_float (ncid, varid, ival) &
         bind(C,name="PIOc_get_var_float")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      real(C_float) :: ival(*)
# 41 "pionfget_mod.F90.in"
    end function PIOc_get_var_float
 end interface
# 43 "pionfget_mod.F90.in"
 interface
# 45 "pionfget_mod.F90.in"
    ! TYPE text,double,short,int
    integer(C_INT) function PIOc_get_var_text (ncid, varid, ival) &
         bind(C,name="PIOc_get_var_text")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      character(C_CHAR) :: ival(*)
# 51 "pionfget_mod.F90.in"
    end function PIOc_get_var_text
    ! TYPE text,double,short,int
    integer(C_INT) function PIOc_get_var_double (ncid, varid, ival) &
         bind(C,name="PIOc_get_var_double")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      real(C_DOUBLE) :: ival(*)
# 51 "pionfget_mod.F90.in"
    end function PIOc_get_var_double
    ! TYPE text,double,short,int
    integer(C_INT) function PIOc_get_var_short (ncid, varid, ival) &
         bind(C,name="PIOc_get_var_short")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SHORT) :: ival(*)
# 51 "pionfget_mod.F90.in"
    end function PIOc_get_var_short
    ! TYPE text,double,short,int
    integer(C_INT) function PIOc_get_var_int (ncid, varid, ival) &
         bind(C,name="PIOc_get_var_int")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_INT) :: ival(*)
# 51 "pionfget_mod.F90.in"
    end function PIOc_get_var_int
 end interface


# 55 "pionfget_mod.F90.in"
 interface
# 57 "pionfget_mod.F90.in"
    !TYPE int,double,short,text
    integer(C_INT) function PIOc_get_vara_int (ncid, varid, start, count, ival) &
         bind(C,name="PIOc_get_vara_int")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SIZE_T)  :: start(*)
      integer(C_SIZE_T)  :: count(*)
      integer(C_INT)  :: ival(*)
# 65 "pionfget_mod.F90.in"
    end function PIOc_get_vara_int
    !TYPE int,double,short,text
    integer(C_INT) function PIOc_get_vara_double (ncid, varid, start, count, ival) &
         bind(C,name="PIOc_get_vara_double")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SIZE_T)  :: start(*)
      integer(C_SIZE_T)  :: count(*)
      real(C_DOUBLE)  :: ival(*)
# 65 "pionfget_mod.F90.in"
    end function PIOc_get_vara_double
    !TYPE int,double,short,text
    integer(C_INT) function PIOc_get_vara_short (ncid, varid, start, count, ival) &
         bind(C,name="PIOc_get_vara_short")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SIZE_T)  :: start(*)
      integer(C_SIZE_T)  :: count(*)
      integer(C_SHORT)  :: ival(*)
# 65 "pionfget_mod.F90.in"
    end function PIOc_get_vara_short
    !TYPE int,double,short,text
    integer(C_INT) function PIOc_get_vara_text (ncid, varid, start, count, ival) &
         bind(C,name="PIOc_get_vara_text")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SIZE_T)  :: start(*)
      integer(C_SIZE_T)  :: count(*)
      character(C_CHAR)  :: ival(*)
# 65 "pionfget_mod.F90.in"
    end function PIOc_get_vara_text
 end interface
# 67 "pionfget_mod.F90.in"
 interface
# 68 "pionfget_mod.F90.in"
    integer(C_INT) function PIOc_get_vara_float (ncid, varid, start, count, ival) &
         bind(C,name="PIOc_get_vara_float")
      use iso_c_binding
      integer(C_INT), value :: ncid
      integer(C_INT), value :: varid
      integer(C_SIZE_T)  :: start(*)
      integer(C_SIZE_T)  :: count(*)
      real(C_FLOAT)  :: ival(*)
# 76 "pionfget_mod.F90.in"
    end function PIOc_get_vara_float
 end interface

# 79 "pionfget_mod.F90.in"
CONTAINS

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Reads non-decomposed fields from a NetCDF file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :  a multidimensional index that specifies which value to get
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 92 "pionfget_mod.F90.in"
  integer function get_var1_text (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(out) :: ival

    ierr = get_var1_id_text (file%fh, varid, index, ival)

# 99 "pionfget_mod.F90.in"
  end function get_var1_text
# 92 "pionfget_mod.F90.in"
  integer function get_var1_real (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    real(r4), intent(out) :: ival

    ierr = get_var1_id_real (file%fh, varid, index, ival)

# 99 "pionfget_mod.F90.in"
  end function get_var1_real
# 92 "pionfget_mod.F90.in"
  integer function get_var1_double (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    real(r8), intent(out) :: ival

    ierr = get_var1_id_double (file%fh, varid, index, ival)

# 99 "pionfget_mod.F90.in"
  end function get_var1_double
# 92 "pionfget_mod.F90.in"
  integer function get_var1_int (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(out) :: ival

    ierr = get_var1_id_int (file%fh, varid, index, ival)

# 99 "pionfget_mod.F90.in"
  end function get_var1_int
# 92 "pionfget_mod.F90.in"
  integer function get_var1_short (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, index(:)
    integer(i2), intent(out) :: ival

    ierr = get_var1_id_short (file%fh, varid, index, ival)

# 99 "pionfget_mod.F90.in"
  end function get_var1_short
! TYPE int,real,double,short
# 101 "pionfget_mod.F90.in"
  integer function get_var1_id_int (ncid,varid, index, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(out) :: ival
    integer(C_SIZE_T), allocatable :: cindex(:)
    integer :: i, clen
# 107 "pionfget_mod.F90.in"
    interface
# 108 "pionfget_mod.F90.in"
       integer(C_INT) function PIOc_get_var1_int (ncid, varid, index, ival) &
            bind(C,name="PIOc_get_var1_int")
         use iso_c_binding
         integer(C_INT), value :: ncid
         integer(C_INT), value :: varid
         integer(C_SIZE_T) :: index(*)
         integer(C_INT) :: ival
# 115 "pionfget_mod.F90.in"
       end function PIOc_get_var1_int
    end interface

#ifdef TIMING
    call t_startf("PIO:get_var1_int")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i)=index(clen-i+1)-1
    end do

    ierr = PIOc_get_var1_int (ncid, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:get_var1_int")
#endif
# 132 "pionfget_mod.F90.in"
  end function get_var1_id_int
! TYPE int,real,double,short
# 101 "pionfget_mod.F90.in"
  integer function get_var1_id_real (ncid,varid, index, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid, index(:)
    real(r4), intent(out) :: ival
    integer(C_SIZE_T), allocatable :: cindex(:)
    integer :: i, clen
# 107 "pionfget_mod.F90.in"
    interface
# 108 "pionfget_mod.F90.in"
       integer(C_INT) function PIOc_get_var1_float (ncid, varid, index, ival) &
            bind(C,name="PIOc_get_var1_float")
         use iso_c_binding
         integer(C_INT), value :: ncid
         integer(C_INT), value :: varid
         integer(C_SIZE_T) :: index(*)
         real(C_FLOAT) :: ival
# 115 "pionfget_mod.F90.in"
       end function PIOc_get_var1_float
    end interface

#ifdef TIMING
    call t_startf("PIO:get_var1_real")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i)=index(clen-i+1)-1
    end do

    ierr = PIOc_get_var1_float (ncid, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:get_var1_real")
#endif
# 132 "pionfget_mod.F90.in"
  end function get_var1_id_real
! TYPE int,real,double,short
# 101 "pionfget_mod.F90.in"
  integer function get_var1_id_double (ncid,varid, index, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid, index(:)
    real(r8), intent(out) :: ival
    integer(C_SIZE_T), allocatable :: cindex(:)
    integer :: i, clen
# 107 "pionfget_mod.F90.in"
    interface
# 108 "pionfget_mod.F90.in"
       integer(C_INT) function PIOc_get_var1_double (ncid, varid, index, ival) &
            bind(C,name="PIOc_get_var1_double")
         use iso_c_binding
         integer(C_INT), value :: ncid
         integer(C_INT), value :: varid
         integer(C_SIZE_T) :: index(*)
         real(C_DOUBLE) :: ival
# 115 "pionfget_mod.F90.in"
       end function PIOc_get_var1_double
    end interface

#ifdef TIMING
    call t_startf("PIO:get_var1_double")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i)=index(clen-i+1)-1
    end do

    ierr = PIOc_get_var1_double (ncid, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:get_var1_double")
#endif
# 132 "pionfget_mod.F90.in"
  end function get_var1_id_double
! TYPE int,real,double,short
# 101 "pionfget_mod.F90.in"
  integer function get_var1_id_short (ncid,varid, index, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid, index(:)
    integer(i2), intent(out) :: ival
    integer(C_SIZE_T), allocatable :: cindex(:)
    integer :: i, clen
# 107 "pionfget_mod.F90.in"
    interface
# 108 "pionfget_mod.F90.in"
       integer(C_INT) function PIOc_get_var1_short (ncid, varid, index, ival) &
            bind(C,name="PIOc_get_var1_short")
         use iso_c_binding
         integer(C_INT), value :: ncid
         integer(C_INT), value :: varid
         integer(C_SIZE_T) :: index(*)
         integer(C_SHORT) :: ival
# 115 "pionfget_mod.F90.in"
       end function PIOc_get_var1_short
    end interface

#ifdef TIMING
    call t_startf("PIO:get_var1_short")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i)=index(clen-i+1)-1
    end do

    ierr = PIOc_get_var1_short (ncid, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:get_var1_short")
#endif
# 132 "pionfget_mod.F90.in"
  end function get_var1_id_short

# 134 "pionfget_mod.F90.in"
  integer function get_var1_id_text (ncid,varid, index, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(out) :: ival
    integer :: i, ndims
    integer(kind=C_SIZE_T), allocatable :: lindex(:), count(:)

#ifdef TIMING
    call t_startf("PIO:get_var1_text")
#endif
    ndims = size(index)
    allocate(lindex(ndims), count(ndims))
    do i=1,ndims
       lindex(ndims-i+1) = index(i) - 1
    enddo
    count = 1
    count(ndims) = len(ival)

    ierr = PIOc_get_vara_text(ncid, varid-1, lindex, count, ival)
#ifdef TIMING
    call t_stopf("PIO:get_var1_text")
#endif
# 156 "pionfget_mod.F90.in"
  end function get_var1_id_text



!>
!! @public
!! @ingroup PIO_get_var
!! @brief Writes data to a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param index :  a multidimensional index that specifies which value to get
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 171 "pionfget_mod.F90.in"
  integer function get_var1_vdesc_text (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    character(len=*), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_text'

    ierr = get_var1_text (File, vardesc%varid, index, ival)

# 181 "pionfget_mod.F90.in"
  end function get_var1_vdesc_text
# 171 "pionfget_mod.F90.in"
  integer function get_var1_vdesc_real (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    real(r4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_real'

    ierr = get_var1_real (File, vardesc%varid, index, ival)

# 181 "pionfget_mod.F90.in"
  end function get_var1_vdesc_real
# 171 "pionfget_mod.F90.in"
  integer function get_var1_vdesc_double (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    real(r8), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_double'

    ierr = get_var1_double (File, vardesc%varid, index, ival)

# 181 "pionfget_mod.F90.in"
  end function get_var1_vdesc_double
# 171 "pionfget_mod.F90.in"
  integer function get_var1_vdesc_int (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    integer(i4), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_int'

    ierr = get_var1_int (File, vardesc%varid, index, ival)

# 181 "pionfget_mod.F90.in"
  end function get_var1_vdesc_int
# 171 "pionfget_mod.F90.in"
  integer function get_var1_vdesc_short (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: index(:)
    integer(i2), intent(out) :: ival

    character(len=*), parameter :: subName=modName//'::get_var1_vdesc_short'

    ierr = get_var1_short (File, vardesc%varid, index, ival)

# 181 "pionfget_mod.F90.in"
  end function get_var1_vdesc_short


! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_1d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:)

    ierr = get_vara_int_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_1d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_2d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:)

    ierr = get_vara_int_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_2d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_3d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:)

    ierr = get_vara_int_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_3d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_4d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:)

    ierr = get_vara_int_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_4d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_5d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_vara_int_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_5d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_1d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:)

    ierr = get_vara_real_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_1d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_2d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:)

    ierr = get_vara_real_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_2d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_3d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:)

    ierr = get_vara_real_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_3d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_4d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:)

    ierr = get_vara_real_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_4d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_5d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_vara_real_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_5d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_1d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:)

    ierr = get_vara_double_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_1d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_2d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:)

    ierr = get_vara_double_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_2d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_3d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:)

    ierr = get_vara_double_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_3d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_4d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:)

    ierr = get_vara_double_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_4d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_5d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:,:)

    ierr = get_vara_double_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_5d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_1d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i2), intent(out) :: ival(:)

    ierr = get_vara_short_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_1d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_2d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i2), intent(out) :: ival(:,:)

    ierr = get_vara_short_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_2d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_3d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:)

    ierr = get_vara_short_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_3d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_4d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:,:)

    ierr = get_vara_short_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_4d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 214 "pionfget_mod.F90.in"
  integer function get_vara_5d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:,:,:)

    ierr = get_vara_short_internal (File%fh, varid, start, count, ival)

# 221 "pionfget_mod.F90.in"
  end function get_vara_5d_short

! DIMS 1,2,3,4,5
# 224 "pionfget_mod.F90.in"
  integer function get_vara_1d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:)
    ival = ' '
    ierr = get_vara_text_internal (File%fh, varid, start, count, size(ival), ival)

# 231 "pionfget_mod.F90.in"
  end function get_vara_1d_text
! DIMS 1,2,3,4,5
# 224 "pionfget_mod.F90.in"
  integer function get_vara_2d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:)
    ival = ' '
    ierr = get_vara_text_internal (File%fh, varid, start, count, size(ival), ival)

# 231 "pionfget_mod.F90.in"
  end function get_vara_2d_text
! DIMS 1,2,3,4,5
# 224 "pionfget_mod.F90.in"
  integer function get_vara_3d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:)
    ival = ' '
    ierr = get_vara_text_internal (File%fh, varid, start, count, size(ival), ival)

# 231 "pionfget_mod.F90.in"
  end function get_vara_3d_text
! DIMS 1,2,3,4,5
# 224 "pionfget_mod.F90.in"
  integer function get_vara_4d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:)
    ival = ' '
    ierr = get_vara_text_internal (File%fh, varid, start, count, size(ival), ival)

# 231 "pionfget_mod.F90.in"
  end function get_vara_4d_text
! DIMS 1,2,3,4,5
# 224 "pionfget_mod.F90.in"
  integer function get_vara_5d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:,:)
    ival = ' '
    ierr = get_vara_text_internal (File%fh, varid, start, count, size(ival), ival)

# 231 "pionfget_mod.F90.in"
  end function get_vara_5d_text

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_1d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_text'

    ierr = get_vara_1d_text (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_1d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_2d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_text'

    ierr = get_vara_2d_text (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_2d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_3d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_text'

    ierr = get_vara_3d_text (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_3d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_4d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_text'

    ierr = get_vara_4d_text (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_4d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_5d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    character(len=*), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_text'

    ierr = get_vara_5d_text (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_5d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_1d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_real'

    ierr = get_vara_1d_real (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_1d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_2d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_real'

    ierr = get_vara_2d_real (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_2d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_3d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_real'

    ierr = get_vara_3d_real (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_3d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_4d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_real'

    ierr = get_vara_4d_real (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_4d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_5d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_real'

    ierr = get_vara_5d_real (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_5d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_1d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_double'

    ierr = get_vara_1d_double (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_1d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_2d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_double'

    ierr = get_vara_2d_double (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_2d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_3d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_double'

    ierr = get_vara_3d_double (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_3d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_4d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_double'

    ierr = get_vara_4d_double (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_4d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_5d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    real(r8), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_double'

    ierr = get_vara_5d_double (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_5d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_1d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_int'

    ierr = get_vara_1d_int (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_1d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_2d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_int'

    ierr = get_vara_2d_int (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_2d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_3d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_int'

    ierr = get_vara_3d_int (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_3d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_4d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_int'

    ierr = get_vara_4d_int (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_4d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_5d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_int'

    ierr = get_vara_5d_int (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_5d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_1d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i2), intent(out) :: ival(:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_1d_short'

    ierr = get_vara_1d_short (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_1d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_2d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i2), intent(out) :: ival(:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_2d_short'

    ierr = get_vara_2d_short (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_2d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_3d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_3d_short'

    ierr = get_vara_3d_short (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_3d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_4d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_4d_short'

    ierr = get_vara_4d_short (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_4d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param start : A vector of size_t integers specifying the index in
!!   the variable where the first of the data values will be read. The
!!   indices are relative to 0, so for example, the first data value of
!!   a variable would have index (0, 0, ... , 0). The length of start
!!   must be the same as the number of dimensions of the specified
!!   variable. The elements of start correspond, in order, to the
!!   variable's dimensions. Hence, if the variable is a record variable,
!!   the first index would correspond to the starting record number for
!!   reading the data values.
!! @param count : A vector of size_t integers specifying the edge
!!   lengths along each dimension of the block of data values to be
!!   read. To read a single value, for example, specify count as (1, 1,
!!   ... , 1). The length of count is the number of dimensions of the
!!   specified variable. The elements of count correspond, in order, to
!!   the variable's dimensions. Hence, if the variable is a record
!!   variable, the first element of count corresponds to a count of the
!!   number of records to read.
!! Note: setting any element of the count array to zero causes the function to exit without error, and without doing anything.
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 262 "pionfget_mod.F90.in"
  integer function get_vara_vdesc_5d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) :: start(:), count(:)
    integer(i2), intent(out) :: ival(:,:,:,:,:)

    character(len=*), parameter :: subName=modName//'::get_vara_vdesc_5d_short'

    ierr = get_vara_5d_short (File, vardesc%varid, start, count, ival)

# 272 "pionfget_mod.F90.in"
  end function get_vara_vdesc_5d_short

!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 284 "pionfget_mod.F90.in"
  integer function get_var_0d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival


    ival =C_NULL_CHAR
    ierr = PIOc_get_var_text(File%fh, varid-1, ival)
    call replace_c_null(ival)
!    print *,__FILE__,__LINE__,trim(ival)
# 294 "pionfget_mod.F90.in"
  end function Get_var_0d_text


! TYPE int,real,double,short
! DIMS 0
# 299 "pionfget_mod.F90.in"
  integer function get_var_0d_int (File,varid, ival) result(ierr)
    use iso_c_binding
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival
    integer(i4)  :: aival(1)


    ierr = PIOc_get_var_int (File%fh, varid-1, aival)
    ival = aival(1)

# 310 "pionfget_mod.F90.in"
  end function Get_var_0d_int
! TYPE int,real,double,short
! DIMS 0
# 299 "pionfget_mod.F90.in"
  integer function get_var_0d_real (File,varid, ival) result(ierr)
    use iso_c_binding
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival
    real(r4)  :: aival(1)


    ierr = PIOc_get_var_float (File%fh, varid-1, aival)
    ival = aival(1)

# 310 "pionfget_mod.F90.in"
  end function Get_var_0d_real
! TYPE int,real,double,short
! DIMS 0
# 299 "pionfget_mod.F90.in"
  integer function get_var_0d_double (File,varid, ival) result(ierr)
    use iso_c_binding
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival
    real(r8)  :: aival(1)


    ierr = PIOc_get_var_double (File%fh, varid-1, aival)
    ival = aival(1)

# 310 "pionfget_mod.F90.in"
  end function Get_var_0d_double
! TYPE int,real,double,short
! DIMS 0
# 299 "pionfget_mod.F90.in"
  integer function get_var_0d_short (File,varid, ival) result(ierr)
    use iso_c_binding
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival
    integer(i2)  :: aival(1)


    ierr = PIOc_get_var_short (File%fh, varid-1, aival)
    ival = aival(1)

# 310 "pionfget_mod.F90.in"
  end function Get_var_0d_short

! DIMS 1,2,3,4,5
# 313 "pionfget_mod.F90.in"
  integer function get_var_1d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:)
    ival = ' '
    ierr = get_var_text_internal(File%fh, varid, size(ival), ival, len(ival))

# 320 "pionfget_mod.F90.in"
  end function get_var_1d_text
! DIMS 1,2,3,4,5
# 313 "pionfget_mod.F90.in"
  integer function get_var_2d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:)
    ival = ' '
    ierr = get_var_text_internal(File%fh, varid, size(ival), ival, len(ival))

# 320 "pionfget_mod.F90.in"
  end function get_var_2d_text
! DIMS 1,2,3,4,5
# 313 "pionfget_mod.F90.in"
  integer function get_var_3d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:)
    ival = ' '
    ierr = get_var_text_internal(File%fh, varid, size(ival), ival, len(ival))

# 320 "pionfget_mod.F90.in"
  end function get_var_3d_text
! DIMS 1,2,3,4,5
# 313 "pionfget_mod.F90.in"
  integer function get_var_4d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:,:)
    ival = ' '
    ierr = get_var_text_internal(File%fh, varid, size(ival), ival, len(ival))

# 320 "pionfget_mod.F90.in"
  end function get_var_4d_text
! DIMS 1,2,3,4,5
# 313 "pionfget_mod.F90.in"
  integer function get_var_5d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    character(len=*), intent(out) :: ival(:,:,:,:,:)
    ival = ' '
    ierr = get_var_text_internal(File%fh, varid, size(ival), ival, len(ival))

# 320 "pionfget_mod.F90.in"
  end function get_var_5d_text

# 322 "pionfget_mod.F90.in"
  integer function get_var_text_internal (ncid,varid, nstrs, ival, strlen) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: nstrs
    integer, intent(in) :: strlen
    character(len=strlen), intent(out) :: ival(*)
    integer :: j

    do j=1,nstrs
       ival(j) = C_NULL_CHAR
    enddo
    ierr = PIOc_get_var_text(ncid, varid-1, ival)
    do j=1,nstrs
       call replace_c_null(ival(j), int(strlen,kind=PIO_OFFSET_KIND))
    end do

# 338 "pionfget_mod.F90.in"
  end function get_var_text_internal

! TYPE int,real,double,short
# 341 "pionfget_mod.F90.in"
  integer function get_var_int_internal  (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(i4), intent(out), target :: ival(*)

    ierr = PIOc_get_var_int (ncid, varid-1, ival)

# 348 "pionfget_mod.F90.in"
  end function get_var_int_internal
! TYPE int,real,double,short
# 341 "pionfget_mod.F90.in"
  integer function get_var_real_internal  (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    real(r4), intent(out), target :: ival(*)

    ierr = PIOc_get_var_float (ncid, varid-1, ival)

# 348 "pionfget_mod.F90.in"
  end function get_var_real_internal
! TYPE int,real,double,short
# 341 "pionfget_mod.F90.in"
  integer function get_var_double_internal  (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    real(r8), intent(out), target :: ival(*)

    ierr = PIOc_get_var_double (ncid, varid-1, ival)

# 348 "pionfget_mod.F90.in"
  end function get_var_double_internal
! TYPE int,real,double,short
# 341 "pionfget_mod.F90.in"
  integer function get_var_short_internal  (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(i2), intent(out), target :: ival(*)

    ierr = PIOc_get_var_short (ncid, varid-1, ival)

# 348 "pionfget_mod.F90.in"
  end function get_var_short_internal

! TYPE int,real,double,short
# 351 "pionfget_mod.F90.in"
  integer function get_vara_int_internal  (ncid,varid, start, count, ival) result(ierr)
    use pio_nf, only : pio_inq_varndims
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    integer(i4), target, intent(out) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims, indims

    ierr = pio_inq_varndims(ncid,varid, ndims)
    allocate(cstart(ndims),ccount(ndims))
    indims = size(start)
    cstart = 0
    ccount = 1
    do i=ndims-indims+1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

    ierr = PIOc_get_vara_int (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart, ccount)

# 374 "pionfget_mod.F90.in"
  end function get_vara_int_internal
! TYPE int,real,double,short
# 351 "pionfget_mod.F90.in"
  integer function get_vara_real_internal  (ncid,varid, start, count, ival) result(ierr)
    use pio_nf, only : pio_inq_varndims
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    real(r4), target, intent(out) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims, indims

    ierr = pio_inq_varndims(ncid,varid, ndims)
    allocate(cstart(ndims),ccount(ndims))
    indims = size(start)
    cstart = 0
    ccount = 1
    do i=ndims-indims+1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

    ierr = PIOc_get_vara_float (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart, ccount)

# 374 "pionfget_mod.F90.in"
  end function get_vara_real_internal
! TYPE int,real,double,short
# 351 "pionfget_mod.F90.in"
  integer function get_vara_double_internal  (ncid,varid, start, count, ival) result(ierr)
    use pio_nf, only : pio_inq_varndims
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    real(r8), target, intent(out) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims, indims

    ierr = pio_inq_varndims(ncid,varid, ndims)
    allocate(cstart(ndims),ccount(ndims))
    indims = size(start)
    cstart = 0
    ccount = 1
    do i=ndims-indims+1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

    ierr = PIOc_get_vara_double (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart, ccount)

# 374 "pionfget_mod.F90.in"
  end function get_vara_double_internal
! TYPE int,real,double,short
# 351 "pionfget_mod.F90.in"
  integer function get_vara_short_internal  (ncid,varid, start, count, ival) result(ierr)
    use pio_nf, only : pio_inq_varndims
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    integer(i2), target, intent(out) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims, indims

    ierr = pio_inq_varndims(ncid,varid, ndims)
    allocate(cstart(ndims),ccount(ndims))
    indims = size(start)
    cstart = 0
    ccount = 1
    do i=ndims-indims+1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

    ierr = PIOc_get_vara_short (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart, ccount)

# 374 "pionfget_mod.F90.in"
  end function get_vara_short_internal

# 376 "pionfget_mod.F90.in"
  integer function get_vara_text_internal  (ncid,varid, start, count, nstrs, ival) result(ierr)
    use pio_nf, only : pio_inq_varndims
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    integer, intent(in) :: nstrs
    character(len=*), intent(out) :: ival(*)
    integer :: j
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    ierr = pio_inq_varndims(ncid,varid, ndims)
    allocate(cstart(ndims),ccount(ndims))
    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

    ierr = PIOc_get_vara_text (ncid, varid-1, cstart, ccount, ival)
    do j=1,nstrs
       call replace_c_null(ival(j),ccount(ndims))
    end do
    deallocate(ccount, cstart)
# 400 "pionfget_mod.F90.in"
  end function get_vara_text_internal

! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_1d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:)

    ierr = get_var_int_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_1d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_2d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:)

    ierr = get_var_int_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_2d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_3d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:)

    ierr = get_var_int_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_3d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_4d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:,:)

    ierr = get_var_int_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_4d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_5d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_int_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_5d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_1d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:)

    ierr = get_var_real_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_1d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_2d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:)

    ierr = get_var_real_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_2d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_3d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:)

    ierr = get_var_real_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_3d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_4d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:,:)

    ierr = get_var_real_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_4d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_5d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_real_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_5d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_1d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:)

    ierr = get_var_double_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_1d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_2d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:)

    ierr = get_var_double_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_2d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_3d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:)

    ierr = get_var_double_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_3d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_4d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:,:)

    ierr = get_var_double_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_4d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_5d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    real(r8), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_double_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_5d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_1d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival(:)

    ierr = get_var_short_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_1d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_2d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival(:,:)

    ierr = get_var_short_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_2d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_3d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival(:,:,:)

    ierr = get_var_short_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_3d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_4d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival(:,:,:,:)

    ierr = get_var_short_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_4d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
# 404 "pionfget_mod.F90.in"
  integer function get_var_5d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    integer, intent(in) :: varid
    integer(i2), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_short_internal(File%fh, varid, ival)

# 411 "pionfget_mod.F90.in"
  end function get_var_5d_short


!>
!! @public
!! @ingroup PIO_get_var
!! @brief Gets data from a file
!! @details
!! @param File @ref file_desc_t
!! @param vardesc @ref var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @ref error_return
!<
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_0d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival

    ierr = get_var_0d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_0d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_1d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:)

    ierr = get_var_1d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_1d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_2d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:)

    ierr = get_var_2d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_2d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_3d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:)

    ierr = get_var_3d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_3d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_4d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:,:)

    ierr = get_var_4d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_4d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_5d_text (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    character(len=*), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_5d_text (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_5d_text
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_0d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival

    ierr = get_var_0d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_0d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_1d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:)

    ierr = get_var_1d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_1d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_2d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:)

    ierr = get_var_2d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_2d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_3d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:)

    ierr = get_var_3d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_3d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_4d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:,:)

    ierr = get_var_4d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_4d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_5d_real (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_5d_real (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_5d_real
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_0d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival

    ierr = get_var_0d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_0d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_1d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:)

    ierr = get_var_1d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_1d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_2d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:)

    ierr = get_var_2d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_2d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_3d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:)

    ierr = get_var_3d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_3d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_4d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:,:)

    ierr = get_var_4d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_4d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_5d_double (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    real(r8), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_5d_double (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_5d_double
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_0d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival

    ierr = get_var_0d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_0d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_1d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:)

    ierr = get_var_1d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_1d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_2d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:)

    ierr = get_var_2d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_2d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_3d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:)

    ierr = get_var_3d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_3d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_4d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:,:)

    ierr = get_var_4d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_4d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_5d_int (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i4), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_5d_int (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_5d_int
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_0d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival

    ierr = get_var_0d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_0d_short
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_1d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival(:)

    ierr = get_var_1d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_1d_short
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_2d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival(:,:)

    ierr = get_var_2d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_2d_short
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_3d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival(:,:,:)

    ierr = get_var_3d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_3d_short
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_4d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival(:,:,:,:)

    ierr = get_var_4d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_4d_short
# 424 "pionfget_mod.F90.in"
  integer function get_var_vdesc_5d_short (File,vardesc, ival) result(ierr)
    type (File_desc_t), intent(in) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer(i2), intent(out) :: ival(:,:,:,:,:)

    ierr = get_var_5d_short (File, vardesc%varid, ival)

# 431 "pionfget_mod.F90.in"
  end function get_var_vdesc_5d_short
end module pionfget_mod
