!===================================================
! DO NOT EDIT THIS FILE, it was generated using ../../scripts/genf90.pl
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ "pionfput_mod.F90"
#include "config.h"
!>
!! @file
!! @brief Write routines for non-decomposed NetCDF data.
!<
!>
!! @defgroup PIO_put_var Write Variable
!! Writes data to a variable.
!! @warning Although this is a collective call the variable is written from the
!! root IO task, no consistancy check is made with data passed on other tasks.
!<
module pionfput_mod
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf      ! _EXTERNAL
#endif
  use iso_c_binding
  use pio_kinds, only: i2,i4,r4,r8
  use pio_types, only : file_desc_t, var_desc_t, pio_noerr

  implicit none
  private

  public :: put_var
# 25 "pionfput_mod.F90.in"
  interface put_var
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_text, put_var_vdesc_0d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_text, put_var_vdesc_1d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_text, put_var_vdesc_2d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_text, put_var_vdesc_3d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_text, put_var_vdesc_4d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_text, put_var_vdesc_5d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_real, put_var_vdesc_0d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_real, put_var_vdesc_1d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_real, put_var_vdesc_2d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_real, put_var_vdesc_3d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_real, put_var_vdesc_4d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_real, put_var_vdesc_5d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_double, put_var_vdesc_0d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_double, put_var_vdesc_1d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_double, put_var_vdesc_2d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_double, put_var_vdesc_3d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_double, put_var_vdesc_4d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_double, put_var_vdesc_5d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_int, put_var_vdesc_0d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_int, put_var_vdesc_1d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_int, put_var_vdesc_2d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_int, put_var_vdesc_3d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_int, put_var_vdesc_4d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_int, put_var_vdesc_5d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_short, put_var_vdesc_0d_short
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_short, put_var_vdesc_1d_short
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_short, put_var_vdesc_2d_short
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_short, put_var_vdesc_3d_short
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_short, put_var_vdesc_4d_short
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_short, put_var_vdesc_5d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_1d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_2d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_3d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_4d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_5d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_1d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_2d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_3d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_4d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_5d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_1d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_2d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_3d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_4d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_5d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_1d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_2d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_3d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_4d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_5d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_1d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_2d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_3d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_4d_short
     !  DIMS 1,2,3,4,5
     module procedure put_vara_vdesc_5d_short
     module procedure put_var1_text, put_var1_vdesc_text
     module procedure put_var1_real, put_var1_vdesc_real
     module procedure put_var1_double, put_var1_vdesc_double
     module procedure put_var1_int, put_var1_vdesc_int
     module procedure put_var1_short, put_var1_vdesc_short
  end interface
# 34 "pionfput_mod.F90.in"
  interface
# 36 "pionfput_mod.F90.in"
     !TYPE text,int,double,short
     integer(C_INT) function PIOc_put_var_text(ncid, varid, op) &
          bind(C,name="PIOc_put_var_text")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       character(C_CHAR) :: op(*)
# 42 "pionfput_mod.F90.in"
     end function PIOc_put_var_text
     !TYPE text,int,double,short
     integer(C_INT) function PIOc_put_var_int(ncid, varid, op) &
          bind(C,name="PIOc_put_var_int")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_INT) :: op(*)
# 42 "pionfput_mod.F90.in"
     end function PIOc_put_var_int
     !TYPE text,int,double,short
     integer(C_INT) function PIOc_put_var_double(ncid, varid, op) &
          bind(C,name="PIOc_put_var_double")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       real(C_DOUBLE) :: op(*)
# 42 "pionfput_mod.F90.in"
     end function PIOc_put_var_double
     !TYPE text,int,double,short
     integer(C_INT) function PIOc_put_var_short(ncid, varid, op) &
          bind(C,name="PIOc_put_var_short")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SHORT) :: op(*)
# 42 "pionfput_mod.F90.in"
     end function PIOc_put_var_short
  end interface
# 44 "pionfput_mod.F90.in"
  interface
# 46 "pionfput_mod.F90.in"
     ! TYPE text,int,double,short
     integer(C_INT) function PIOc_put_vara_text(ncid, varid, start, count, op) &
          bind(C,name="PIOc_put_vara_text")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SIZE_T), intent(in) :: start(*)
       integer(C_SIZE_T), intent(in) :: count(*)
       character(C_CHAR), intent(in) :: op(*)
# 54 "pionfput_mod.F90.in"
     end function PIOc_put_vara_text
     ! TYPE text,int,double,short
     integer(C_INT) function PIOc_put_vara_int(ncid, varid, start, count, op) &
          bind(C,name="PIOc_put_vara_int")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SIZE_T), intent(in) :: start(*)
       integer(C_SIZE_T), intent(in) :: count(*)
       integer(C_INT), intent(in) :: op(*)
# 54 "pionfput_mod.F90.in"
     end function PIOc_put_vara_int
     ! TYPE text,int,double,short
     integer(C_INT) function PIOc_put_vara_double(ncid, varid, start, count, op) &
          bind(C,name="PIOc_put_vara_double")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SIZE_T), intent(in) :: start(*)
       integer(C_SIZE_T), intent(in) :: count(*)
       real(C_DOUBLE), intent(in) :: op(*)
# 54 "pionfput_mod.F90.in"
     end function PIOc_put_vara_double
     ! TYPE text,int,double,short
     integer(C_INT) function PIOc_put_vara_short(ncid, varid, start, count, op) &
          bind(C,name="PIOc_put_vara_short")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SIZE_T), intent(in) :: start(*)
       integer(C_SIZE_T), intent(in) :: count(*)
       integer(C_SHORT), intent(in) :: op(*)
# 54 "pionfput_mod.F90.in"
     end function PIOc_put_vara_short
  end interface
# 56 "pionfput_mod.F90.in"
  interface
# 57 "pionfput_mod.F90.in"
     integer(C_INT) function PIOc_put_vara_float(ncid, varid, start, count, op) &
          bind(C,name="PIOc_put_vara_float")
       use iso_c_binding
       integer(C_INT), intent(in), value :: ncid
       integer(C_INT), intent(in), value :: varid
       integer(C_SIZE_T), intent(in) :: start(*)
       integer(C_SIZE_T), intent(in) :: count(*)
       real(C_FLOAT)   , intent(in) :: op(*)
# 65 "pionfput_mod.F90.in"
     end function PIOc_put_vara_float
  end interface

# 68 "pionfput_mod.F90.in"
contains

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 81 "pionfput_mod.F90.in"
  integer function put_var1_text (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(in) :: ival
    integer, allocatable :: count(:)
    integer :: ndims

    ndims = size(index)
    allocate(count(ndims))
    count = 1
    count(1) = len(ival)

    ierr = put_vara_internal_text(File%fh, varid, index, count, ival//C_NULL_CHAR)

    deallocate(count)
# 96 "pionfput_mod.F90.in"
  end function put_var1_text
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 109 "pionfput_mod.F90.in"
  integer function put_var1_int (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(in) :: ival
    integer :: clen, i
    integer(C_SIZE_T), allocatable :: cindex(:)
# 115 "pionfput_mod.F90.in"
    interface
# 116 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var1_int(ncid, varid, index, op) &
            bind(C,name="PIOc_put_var1_int")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_SIZE_T), intent(in) :: index(*)
         integer(C_INT) :: op
# 123 "pionfput_mod.F90.in"
       end function PIOc_put_var1_int
    end interface

#ifdef TIMING
    call t_startf("PIO:put_var1_int")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i) = index(clen-i+1)-1
    enddo

    ierr = PIOc_put_var1_int (file%fh, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:put_var1_int")
#endif
# 140 "pionfput_mod.F90.in"
  end function put_var1_int
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 109 "pionfput_mod.F90.in"
  integer function put_var1_real (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r4), intent(in) :: ival
    integer :: clen, i
    integer(C_SIZE_T), allocatable :: cindex(:)
# 115 "pionfput_mod.F90.in"
    interface
# 116 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var1_float(ncid, varid, index, op) &
            bind(C,name="PIOc_put_var1_float")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_SIZE_T), intent(in) :: index(*)
         real(C_FLOAT) :: op
# 123 "pionfput_mod.F90.in"
       end function PIOc_put_var1_float
    end interface

#ifdef TIMING
    call t_startf("PIO:put_var1_real")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i) = index(clen-i+1)-1
    enddo

    ierr = PIOc_put_var1_float (file%fh, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:put_var1_real")
#endif
# 140 "pionfput_mod.F90.in"
  end function put_var1_real
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 109 "pionfput_mod.F90.in"
  integer function put_var1_double (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r8), intent(in) :: ival
    integer :: clen, i
    integer(C_SIZE_T), allocatable :: cindex(:)
# 115 "pionfput_mod.F90.in"
    interface
# 116 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var1_double(ncid, varid, index, op) &
            bind(C,name="PIOc_put_var1_double")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_SIZE_T), intent(in) :: index(*)
         real(C_DOUBLE) :: op
# 123 "pionfput_mod.F90.in"
       end function PIOc_put_var1_double
    end interface

#ifdef TIMING
    call t_startf("PIO:put_var1_double")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i) = index(clen-i+1)-1
    enddo

    ierr = PIOc_put_var1_double (file%fh, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:put_var1_double")
#endif
# 140 "pionfput_mod.F90.in"
  end function put_var1_double
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 109 "pionfput_mod.F90.in"
  integer function put_var1_short (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    integer(i2), intent(in) :: ival
    integer :: clen, i
    integer(C_SIZE_T), allocatable :: cindex(:)
# 115 "pionfput_mod.F90.in"
    interface
# 116 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var1_short(ncid, varid, index, op) &
            bind(C,name="PIOc_put_var1_short")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_SIZE_T), intent(in) :: index(*)
         integer(C_SHORT) :: op
# 123 "pionfput_mod.F90.in"
       end function PIOc_put_var1_short
    end interface

#ifdef TIMING
    call t_startf("PIO:put_var1_short")
#endif
    clen = size(index)
    allocate(cindex(clen))
    do i=1,clen
       cindex(i) = index(clen-i+1)-1
    enddo

    ierr = PIOc_put_var1_short (file%fh, varid-1, cindex, ival)
    deallocate(cindex)
#ifdef TIMING
    call t_stopf("PIO:put_var1_short")
#endif
# 140 "pionfput_mod.F90.in"
  end function put_var1_short

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write one element of data to a netCDF variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 153 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_text (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  index(:)
    character(len=*), intent(in) :: ival

    ierr = put_var1_text (File, vardesc%varid, index, ival)
# 160 "pionfput_mod.F90.in"
  end function put_var1_vdesc_text
# 153 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_real (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  index(:)
    real(r4), intent(in) :: ival

    ierr = put_var1_real (File, vardesc%varid, index, ival)
# 160 "pionfput_mod.F90.in"
  end function put_var1_vdesc_real
# 153 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_double (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  index(:)
    real(r8), intent(in) :: ival

    ierr = put_var1_double (File, vardesc%varid, index, ival)
# 160 "pionfput_mod.F90.in"
  end function put_var1_vdesc_double
# 153 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_int (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  index(:)
    integer(i4), intent(in) :: ival

    ierr = put_var1_int (File, vardesc%varid, index, ival)
# 160 "pionfput_mod.F90.in"
  end function put_var1_vdesc_int
# 153 "pionfput_mod.F90.in"
  integer function put_var1_vdesc_short (File,vardesc, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  index(:)
    integer(i2), intent(in) :: ival

    ierr = put_var1_short (File, vardesc%varid, index, ival)
# 160 "pionfput_mod.F90.in"
  end function put_var1_vdesc_short

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes a netCDF scalar variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf variable
!! @retval ierr @copydoc error_return
!<
# 172 "pionfput_mod.F90.in"
  integer function put_var_0d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival

    character, allocatable :: cval(:)
    integer :: clen, i


!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    allocate(cval(clen))
    cval = C_NULL_CHAR
    do i=1,len_trim(ival)
       cval(i) = ival(i:i)
    end do

    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)

    deallocate(cval)
# 194 "pionfput_mod.F90.in"
  end function put_var_0d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes text data to netcdf variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 207 "pionfput_mod.F90.in"
  integer function put_var_1d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:)
    character, allocatable :: cval(:)
    integer :: clen,  sd

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    ierr = PIO_NOERR
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_1d (ival, cval)
    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)
    deallocate(cval)


# 226 "pionfput_mod.F90.in"
  end function put_var_1d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes text data to netcdf variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 207 "pionfput_mod.F90.in"
  integer function put_var_2d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    ierr = PIO_NOERR
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_2d (ival, cval)
    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)
    deallocate(cval)


# 226 "pionfput_mod.F90.in"
  end function put_var_2d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes text data to netcdf variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 207 "pionfput_mod.F90.in"
  integer function put_var_3d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    ierr = PIO_NOERR
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_3d (ival, cval)
    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)
    deallocate(cval)


# 226 "pionfput_mod.F90.in"
  end function put_var_3d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes text data to netcdf variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 207 "pionfput_mod.F90.in"
  integer function put_var_4d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    ierr = PIO_NOERR
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_4d (ival, cval)
    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)
    deallocate(cval)


# 226 "pionfput_mod.F90.in"
  end function put_var_4d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes text data to netcdf variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 207 "pionfput_mod.F90.in"
  integer function put_var_5d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    ierr = PIO_NOERR
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_5d (ival, cval)
    ierr = PIOc_put_var_text(file%fh, varid-1,  cval)
    deallocate(cval)


# 226 "pionfput_mod.F90.in"
  end function put_var_5d_text

! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes int data to a netCDF variable.
!! @details
!! @param ncid : The netcdf file id.
!! @param varid : The netcdf variable identifier
!! @param ival : The data to write.
!! @retval ierr @copydoc error_return
!<
# 240 "pionfput_mod.F90.in"
  integer function put_var_internal_int (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(*)

# 245 "pionfput_mod.F90.in"
    interface
# 246 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var_int(ncid, varid, op) &
            bind(C,name="PIOc_put_var_int")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_INT), intent(in) :: op(*)
# 252 "pionfput_mod.F90.in"
       end function PIOc_put_var_int
    end interface

    ierr=PIOc_put_var_int (ncid, varid-1, ival)


# 258 "pionfput_mod.F90.in"
  end function put_var_internal_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes real data to a netCDF variable.
!! @details
!! @param ncid : The netcdf file id.
!! @param varid : The netcdf variable identifier
!! @param ival : The data to write.
!! @retval ierr @copydoc error_return
!<
# 240 "pionfput_mod.F90.in"
  integer function put_var_internal_real (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(*)

# 245 "pionfput_mod.F90.in"
    interface
# 246 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var_float(ncid, varid, op) &
            bind(C,name="PIOc_put_var_float")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         real(C_FLOAT), intent(in) :: op(*)
# 252 "pionfput_mod.F90.in"
       end function PIOc_put_var_float
    end interface

    ierr=PIOc_put_var_float (ncid, varid-1, ival)


# 258 "pionfput_mod.F90.in"
  end function put_var_internal_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes double data to a netCDF variable.
!! @details
!! @param ncid : The netcdf file id.
!! @param varid : The netcdf variable identifier
!! @param ival : The data to write.
!! @retval ierr @copydoc error_return
!<
# 240 "pionfput_mod.F90.in"
  integer function put_var_internal_double (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(*)

# 245 "pionfput_mod.F90.in"
    interface
# 246 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var_double(ncid, varid, op) &
            bind(C,name="PIOc_put_var_double")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         real(C_DOUBLE), intent(in) :: op(*)
# 252 "pionfput_mod.F90.in"
       end function PIOc_put_var_double
    end interface

    ierr=PIOc_put_var_double (ncid, varid-1, ival)


# 258 "pionfput_mod.F90.in"
  end function put_var_internal_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes short data to a netCDF variable.
!! @details
!! @param ncid : The netcdf file id.
!! @param varid : The netcdf variable identifier
!! @param ival : The data to write.
!! @retval ierr @copydoc error_return
!<
# 240 "pionfput_mod.F90.in"
  integer function put_var_internal_short (ncid,varid, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(*)

# 245 "pionfput_mod.F90.in"
    interface
# 246 "pionfput_mod.F90.in"
       integer(C_INT) function PIOc_put_var_short(ncid, varid, op) &
            bind(C,name="PIOc_put_var_short")
         use iso_c_binding
         integer(C_INT), intent(in), value :: ncid
         integer(C_INT), intent(in), value :: varid
         integer(C_SHORT), intent(in) :: op(*)
# 252 "pionfput_mod.F90.in"
       end function PIOc_put_var_short
    end interface

    ierr=PIOc_put_var_short (ncid, varid-1, ival)


# 258 "pionfput_mod.F90.in"
  end function put_var_internal_short

! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netCDF varaible of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_1d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:)
    integer(i4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_int (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_1d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netCDF varaible of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_2d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:)
    integer(i4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_int (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_2d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netCDF varaible of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_3d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:)
    integer(i4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_int (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_3d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netCDF varaible of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_4d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer(i4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_int (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_4d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netCDF varaible of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_5d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer(i4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_int (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_5d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netCDF varaible of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_1d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:)
    real(r4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_real (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_1d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netCDF varaible of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_2d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:)
    real(r4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_real (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_2d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netCDF varaible of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_3d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:)
    real(r4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_real (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_3d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netCDF varaible of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_4d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:)
    real(r4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_real (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_4d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netCDF varaible of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_5d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:,:)
    real(r4), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_real (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_5d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netCDF varaible of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_1d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:)
    real(r8), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_double (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_1d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netCDF varaible of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_2d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:)
    real(r8), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_double (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_2d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netCDF varaible of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_3d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:)
    real(r8), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_double (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_3d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netCDF varaible of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_4d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:)
    real(r8), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_double (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_4d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netCDF varaible of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_5d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:,:)
    real(r8), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_double (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_5d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netCDF varaible of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_1d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(:)
    integer(i2), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_short (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_1d_short
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netCDF varaible of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_2d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(:,:)
    integer(i2), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_short (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_2d_short
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netCDF varaible of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_3d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(:,:,:)
    integer(i2), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_short (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_3d_short
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netCDF varaible of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_4d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(:,:,:,:)
    integer(i2), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_short (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_4d_short
! DIMS 1,2,3,4,5
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netCDF varaible of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 272 "pionfput_mod.F90.in"
  integer function put_var_5d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival(:,:,:,:,:)
    integer(i2), allocatable :: cval(:)
    integer :: clen
    clen = size(ival)
    allocate(cval(clen))
    cval = reshape(ival,(/clen/))
    ierr = put_var_internal_short (File%fh, varid, cval)
    deallocate(cval)

# 284 "pionfput_mod.F90.in"
  end function put_var_5d_short

! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes int data to a netCDF scalar variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 297 "pionfput_mod.F90.in"
  integer function put_var_0d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival
    ierr=PIO_NOERR
#ifdef TIMING
    call t_startf("PIO:put_var_0d_int")
#endif

    ierr = put_var_internal_int (File%fh, varid, (/ival/))

#ifdef TIMING
    call t_stopf("PIO:put_var_0d_int")
#endif
# 311 "pionfput_mod.F90.in"
  end function put_var_0d_int
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes real data to a netCDF scalar variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 297 "pionfput_mod.F90.in"
  integer function put_var_0d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival
    ierr=PIO_NOERR
#ifdef TIMING
    call t_startf("PIO:put_var_0d_real")
#endif

    ierr = put_var_internal_real (File%fh, varid, (/ival/))

#ifdef TIMING
    call t_stopf("PIO:put_var_0d_real")
#endif
# 311 "pionfput_mod.F90.in"
  end function put_var_0d_real
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes double data to a netCDF scalar variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 297 "pionfput_mod.F90.in"
  integer function put_var_0d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival
    ierr=PIO_NOERR
#ifdef TIMING
    call t_startf("PIO:put_var_0d_double")
#endif

    ierr = put_var_internal_double (File%fh, varid, (/ival/))

#ifdef TIMING
    call t_stopf("PIO:put_var_0d_double")
#endif
# 311 "pionfput_mod.F90.in"
  end function put_var_0d_double
! TYPE int,real,double,short
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes short data to a netCDF scalar variable.
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 297 "pionfput_mod.F90.in"
  integer function put_var_0d_short (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i2), intent(in) :: ival
    ierr=PIO_NOERR
#ifdef TIMING
    call t_startf("PIO:put_var_0d_short")
#endif

    ierr = put_var_internal_short (File%fh, varid, (/ival/))

#ifdef TIMING
    call t_stopf("PIO:put_var_0d_short")
#endif
# 311 "pionfput_mod.F90.in"
  end function put_var_0d_short


!! TYPE int,real,double,short
# 315 "pionfput_mod.F90.in"
  integer function put_vara_internal_text (ncid,varid,start,count, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    character(len=*), target, intent(in) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(ccount(ndims), cstart(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo
    ierr=PIOc_put_vara_text (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart,ccount)

# 341 "pionfput_mod.F90.in"
  end function put_vara_internal_text
# 315 "pionfput_mod.F90.in"
  integer function put_vara_internal_real (ncid,varid,start,count, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    real(r4), target, intent(in) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(ccount(ndims), cstart(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo
    ierr=PIOc_put_vara_float (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart,ccount)

# 341 "pionfput_mod.F90.in"
  end function put_vara_internal_real
# 315 "pionfput_mod.F90.in"
  integer function put_vara_internal_double (ncid,varid,start,count, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    real(r8), target, intent(in) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(ccount(ndims), cstart(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo
    ierr=PIOc_put_vara_double (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart,ccount)

# 341 "pionfput_mod.F90.in"
  end function put_vara_internal_double
# 315 "pionfput_mod.F90.in"
  integer function put_vara_internal_int (ncid,varid,start,count, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    integer(i4), target, intent(in) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(ccount(ndims), cstart(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo
    ierr=PIOc_put_vara_int (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart,ccount)

# 341 "pionfput_mod.F90.in"
  end function put_vara_internal_int
# 315 "pionfput_mod.F90.in"
  integer function put_vara_internal_short (ncid,varid,start,count, ival) result(ierr)
    integer, intent(in) :: ncid
    integer, intent(in) :: varid
    integer, intent(in) :: start(:)
    integer, intent(in) :: count(:)
    integer(i2), target, intent(in) :: ival(*)
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i, ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(ccount(ndims), cstart(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo
    ierr=PIOc_put_vara_short (ncid, varid-1, cstart, ccount, ival)
    deallocate(cstart,ccount)

# 341 "pionfput_mod.F90.in"
  end function put_vara_internal_short

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 0 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival

    ierr = put_var_0d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_0d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:)

    ierr = put_var_1d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_1d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:)

    ierr = put_var_2d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_2d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:)

    ierr = put_var_3d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_3d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:)

    ierr = put_var_4d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_4d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:,:)

    ierr = put_var_5d_text (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_5d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 0 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival

    ierr = put_var_0d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_0d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:)

    ierr = put_var_1d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_1d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:)

    ierr = put_var_2d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_2d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:)

    ierr = put_var_3d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_3d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:)

    ierr = put_var_4d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_4d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_var_5d_real (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_5d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 0 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival

    ierr = put_var_0d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_0d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:)

    ierr = put_var_1d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_1d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:)

    ierr = put_var_2d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_2d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:)

    ierr = put_var_3d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_3d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:)

    ierr = put_var_4d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_4d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:,:)

    ierr = put_var_5d_double (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_5d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 0 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival

    ierr = put_var_0d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_0d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:)

    ierr = put_var_1d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_1d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:)

    ierr = put_var_2d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_2d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:)

    ierr = put_var_3d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_3d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:)

    ierr = put_var_4d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_4d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_var_5d_int (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_5d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 0 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival

    ierr = put_var_0d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_0d_short
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival(:)

    ierr = put_var_1d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_1d_short
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival(:,:)

    ierr = put_var_2d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_2d_short
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival(:,:,:)

    ierr = put_var_3d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_3d_short
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival(:,:,:,:)

    ierr = put_var_4d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_4d_short
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 354 "pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_short (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i2), intent(in) :: ival(:,:,:,:,:)

    ierr = put_var_5d_short (File, vardesc%varid, ival)

# 361 "pionfput_mod.F90.in"
  end function put_var_vdesc_5d_short

! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 377 "pionfput_mod.F90.in"
  integer function put_vara_1d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(in) :: ival(:)
    character, allocatable :: cval(:)
    integer :: clen,  sd
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i
    integer :: ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(cstart(ndims),ccount(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_1d (ival, cval)

    ierr = PIOc_put_vara_text(file%fh, varid-1,  cstart, ccount, cval)
    deallocate(cval, cstart, ccount)


# 414 "pionfput_mod.F90.in"
  end function put_vara_1d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 377 "pionfput_mod.F90.in"
  integer function put_vara_2d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(in) :: ival(:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i
    integer :: ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(cstart(ndims),ccount(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_2d (ival, cval)

    ierr = PIOc_put_vara_text(file%fh, varid-1,  cstart, ccount, cval)
    deallocate(cval, cstart, ccount)


# 414 "pionfput_mod.F90.in"
  end function put_vara_2d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 377 "pionfput_mod.F90.in"
  integer function put_vara_3d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i
    integer :: ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(cstart(ndims),ccount(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_3d (ival, cval)

    ierr = PIOc_put_vara_text(file%fh, varid-1,  cstart, ccount, cval)
    deallocate(cval, cstart, ccount)


# 414 "pionfput_mod.F90.in"
  end function put_vara_3d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 377 "pionfput_mod.F90.in"
  integer function put_vara_4d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i
    integer :: ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(cstart(ndims),ccount(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_4d (ival, cval)

    ierr = PIOc_put_vara_text(file%fh, varid-1,  cstart, ccount, cval)
    deallocate(cval, cstart, ccount)


# 414 "pionfput_mod.F90.in"
  end function put_vara_4d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 377 "pionfput_mod.F90.in"
  integer function put_vara_5d_text (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    character, allocatable :: cval(:)
    integer :: clen,  sd
    integer(C_SIZE_T), allocatable :: cstart(:), ccount(:)
    integer :: i
    integer :: ndims

    do i=1,size(count)
       if(count(i)<=0) then
          ndims=i-1
          exit
       else
          ndims=i
       endif
    enddo
    allocate(cstart(ndims),ccount(ndims))

    do i=1,ndims
       cstart(i) = start(ndims-i+1)-1
       ccount(i) = count(ndims-i+1)
    enddo

!   This manipulation is required to convert the fortran string to
!   a c character array with all trailing space set to null
!
    clen = len(ival)
    sd = size(ival)
    allocate(cval(clen*sd))
    call Fstring2Cstring_5d (ival, cval)

    ierr = PIOc_put_vara_text(file%fh, varid-1,  cstart, ccount, cval)
    deallocate(cval, cstart, ccount)


# 414 "pionfput_mod.F90.in"
  end function put_vara_5d_text

! DIMS 1,2,3,4,5
# 417 "pionfput_mod.F90.in"
  subroutine Fstring2Cstring_1d(fstr, cstr)
    character(len=*), intent(in) :: fstr(:)
    character(C_CHAR), intent(out) :: cstr(:)
    integer :: clen, sd(1)
    integer :: cinc
    integer :: i, j
#if 1 >= 2
    integer :: k
#endif
#if 1 >= 3
    integer :: m
#endif
#if 1 >= 4
    integer :: n
#endif
#if 1 == 5
    integer :: q
#endif

    cstr = C_NULL_CHAR
    do i=1,1
       sd(i) = size(fstr,i)
    enddo
    cinc = 0
#if 1 == 1
    clen= len(fstr(1))
    do j=1,sd(1)
       do i=1,max(1,len_trim(fstr(j)))
          cstr(i+cinc*clen) = fstr(j)(i:i)
       end do
       cinc = cinc+1
    enddo
#endif
#if 1 == 2
    clen= len(fstr(1,1))
    do k=1,sd(2)
       do j=1,sd(1)
          do i=1,max(1,len_trim(fstr(j,k)))
             cstr(i+cinc*clen) = fstr(j,k)(i:i)
          end do
          cinc = cinc+1
       enddo
    enddo
#endif
#if 1 == 3
    clen= len(fstr(1,1,1))
    do m=1,sd(3)
       do k=1,sd(2)
          do j=1,sd(1)
             do i=1,max(1,len_trim(fstr(j,k,m)))
                cstr(i+cinc*clen) = fstr(j,k,m)(i:i)
             end do
             cinc = cinc+1
          enddo
       enddo
    enddo
#endif
#if 1 == 4
    clen= len(fstr(1,1,1,1))
    do n=1,sd(4)
       do m=1,sd(3)
          do k=1,sd(2)
             do j=1,sd(1)
                do i=1,max(1,len_trim(fstr(j,k,m,n)))
                   cstr(i+cinc*clen) = fstr(j,k,m,n)(i:i)
                end do
                cinc = cinc+1
             enddo
          enddo
       enddo
    enddo
#endif
#if 1 == 5
    clen= len(fstr(1,1,1,1,1))
    do q=1,sd(5)
       do n=1,sd(4)
          do m=1,sd(3)
             do k=1,sd(2)
                do j=1,sd(1)
                   do i=1,max(1,len_trim(fstr(j,k,m,n,q)))
                      cstr(i+cinc*clen) = fstr(j,k,m,n,q)(i:i)
                   end do
                   cinc = cinc+1
                enddo
             enddo
          enddo
       enddo
    enddo
#endif


# 508 "pionfput_mod.F90.in"
  end subroutine Fstring2Cstring_1d
! DIMS 1,2,3,4,5
# 417 "pionfput_mod.F90.in"
  subroutine Fstring2Cstring_2d(fstr, cstr)
    character(len=*), intent(in) :: fstr(:,:)
    character(C_CHAR), intent(out) :: cstr(:)
    integer :: clen, sd(2)
    integer :: cinc
    integer :: i, j
#if 2 >= 2
    integer :: k
#endif
#if 2 >= 3
    integer :: m
#endif
#if 2 >= 4
    integer :: n
#endif
#if 2 == 5
    integer :: q
#endif

    cstr = C_NULL_CHAR
    do i=1,2
       sd(i) = size(fstr,i)
    enddo
    cinc = 0
#if 2 == 1
    clen= len(fstr(1))
    do j=1,sd(1)
       do i=1,max(1,len_trim(fstr(j)))
          cstr(i+cinc*clen) = fstr(j)(i:i)
       end do
       cinc = cinc+1
    enddo
#endif
#if 2 == 2
    clen= len(fstr(1,1))
    do k=1,sd(2)
       do j=1,sd(1)
          do i=1,max(1,len_trim(fstr(j,k)))
             cstr(i+cinc*clen) = fstr(j,k)(i:i)
          end do
          cinc = cinc+1
       enddo
    enddo
#endif
#if 2 == 3
    clen= len(fstr(1,1,1))
    do m=1,sd(3)
       do k=1,sd(2)
          do j=1,sd(1)
             do i=1,max(1,len_trim(fstr(j,k,m)))
                cstr(i+cinc*clen) = fstr(j,k,m)(i:i)
             end do
             cinc = cinc+1
          enddo
       enddo
    enddo
#endif
#if 2 == 4
    clen= len(fstr(1,1,1,1))
    do n=1,sd(4)
       do m=1,sd(3)
          do k=1,sd(2)
             do j=1,sd(1)
                do i=1,max(1,len_trim(fstr(j,k,m,n)))
                   cstr(i+cinc*clen) = fstr(j,k,m,n)(i:i)
                end do
                cinc = cinc+1
             enddo
          enddo
       enddo
    enddo
#endif
#if 2 == 5
    clen= len(fstr(1,1,1,1,1))
    do q=1,sd(5)
       do n=1,sd(4)
          do m=1,sd(3)
             do k=1,sd(2)
                do j=1,sd(1)
                   do i=1,max(1,len_trim(fstr(j,k,m,n,q)))
                      cstr(i+cinc*clen) = fstr(j,k,m,n,q)(i:i)
                   end do
                   cinc = cinc+1
                enddo
             enddo
          enddo
       enddo
    enddo
#endif


# 508 "pionfput_mod.F90.in"
  end subroutine Fstring2Cstring_2d
! DIMS 1,2,3,4,5
# 417 "pionfput_mod.F90.in"
  subroutine Fstring2Cstring_3d(fstr, cstr)
    character(len=*), intent(in) :: fstr(:,:,:)
    character(C_CHAR), intent(out) :: cstr(:)
    integer :: clen, sd(3)
    integer :: cinc
    integer :: i, j
#if 3 >= 2
    integer :: k
#endif
#if 3 >= 3
    integer :: m
#endif
#if 3 >= 4
    integer :: n
#endif
#if 3 == 5
    integer :: q
#endif

    cstr = C_NULL_CHAR
    do i=1,3
       sd(i) = size(fstr,i)
    enddo
    cinc = 0
#if 3 == 1
    clen= len(fstr(1))
    do j=1,sd(1)
       do i=1,max(1,len_trim(fstr(j)))
          cstr(i+cinc*clen) = fstr(j)(i:i)
       end do
       cinc = cinc+1
    enddo
#endif
#if 3 == 2
    clen= len(fstr(1,1))
    do k=1,sd(2)
       do j=1,sd(1)
          do i=1,max(1,len_trim(fstr(j,k)))
             cstr(i+cinc*clen) = fstr(j,k)(i:i)
          end do
          cinc = cinc+1
       enddo
    enddo
#endif
#if 3 == 3
    clen= len(fstr(1,1,1))
    do m=1,sd(3)
       do k=1,sd(2)
          do j=1,sd(1)
             do i=1,max(1,len_trim(fstr(j,k,m)))
                cstr(i+cinc*clen) = fstr(j,k,m)(i:i)
             end do
             cinc = cinc+1
          enddo
       enddo
    enddo
#endif
#if 3 == 4
    clen= len(fstr(1,1,1,1))
    do n=1,sd(4)
       do m=1,sd(3)
          do k=1,sd(2)
             do j=1,sd(1)
                do i=1,max(1,len_trim(fstr(j,k,m,n)))
                   cstr(i+cinc*clen) = fstr(j,k,m,n)(i:i)
                end do
                cinc = cinc+1
             enddo
          enddo
       enddo
    enddo
#endif
#if 3 == 5
    clen= len(fstr(1,1,1,1,1))
    do q=1,sd(5)
       do n=1,sd(4)
          do m=1,sd(3)
             do k=1,sd(2)
                do j=1,sd(1)
                   do i=1,max(1,len_trim(fstr(j,k,m,n,q)))
                      cstr(i+cinc*clen) = fstr(j,k,m,n,q)(i:i)
                   end do
                   cinc = cinc+1
                enddo
             enddo
          enddo
       enddo
    enddo
#endif


# 508 "pionfput_mod.F90.in"
  end subroutine Fstring2Cstring_3d
! DIMS 1,2,3,4,5
# 417 "pionfput_mod.F90.in"
  subroutine Fstring2Cstring_4d(fstr, cstr)
    character(len=*), intent(in) :: fstr(:,:,:,:)
    character(C_CHAR), intent(out) :: cstr(:)
    integer :: clen, sd(4)
    integer :: cinc
    integer :: i, j
#if 4 >= 2
    integer :: k
#endif
#if 4 >= 3
    integer :: m
#endif
#if 4 >= 4
    integer :: n
#endif
#if 4 == 5
    integer :: q
#endif

    cstr = C_NULL_CHAR
    do i=1,4
       sd(i) = size(fstr,i)
    enddo
    cinc = 0
#if 4 == 1
    clen= len(fstr(1))
    do j=1,sd(1)
       do i=1,max(1,len_trim(fstr(j)))
          cstr(i+cinc*clen) = fstr(j)(i:i)
       end do
       cinc = cinc+1
    enddo
#endif
#if 4 == 2
    clen= len(fstr(1,1))
    do k=1,sd(2)
       do j=1,sd(1)
          do i=1,max(1,len_trim(fstr(j,k)))
             cstr(i+cinc*clen) = fstr(j,k)(i:i)
          end do
          cinc = cinc+1
       enddo
    enddo
#endif
#if 4 == 3
    clen= len(fstr(1,1,1))
    do m=1,sd(3)
       do k=1,sd(2)
          do j=1,sd(1)
             do i=1,max(1,len_trim(fstr(j,k,m)))
                cstr(i+cinc*clen) = fstr(j,k,m)(i:i)
             end do
             cinc = cinc+1
          enddo
       enddo
    enddo
#endif
#if 4 == 4
    clen= len(fstr(1,1,1,1))
    do n=1,sd(4)
       do m=1,sd(3)
          do k=1,sd(2)
             do j=1,sd(1)
                do i=1,max(1,len_trim(fstr(j,k,m,n)))
                   cstr(i+cinc*clen) = fstr(j,k,m,n)(i:i)
                end do
                cinc = cinc+1
             enddo
          enddo
       enddo
    enddo
#endif
#if 4 == 5
    clen= len(fstr(1,1,1,1,1))
    do q=1,sd(5)
       do n=1,sd(4)
          do m=1,sd(3)
             do k=1,sd(2)
                do j=1,sd(1)
                   do i=1,max(1,len_trim(fstr(j,k,m,n,q)))
                      cstr(i+cinc*clen) = fstr(j,k,m,n,q)(i:i)
                   end do
                   cinc = cinc+1
                enddo
             enddo
          enddo
       enddo
    enddo
#endif


# 508 "pionfput_mod.F90.in"
  end subroutine Fstring2Cstring_4d
! DIMS 1,2,3,4,5
# 417 "pionfput_mod.F90.in"
  subroutine Fstring2Cstring_5d(fstr, cstr)
    character(len=*), intent(in) :: fstr(:,:,:,:,:)
    character(C_CHAR), intent(out) :: cstr(:)
    integer :: clen, sd(5)
    integer :: cinc
    integer :: i, j
#if 5 >= 2
    integer :: k
#endif
#if 5 >= 3
    integer :: m
#endif
#if 5 >= 4
    integer :: n
#endif
#if 5 == 5
    integer :: q
#endif

    cstr = C_NULL_CHAR
    do i=1,5
       sd(i) = size(fstr,i)
    enddo
    cinc = 0
#if 5 == 1
    clen= len(fstr(1))
    do j=1,sd(1)
       do i=1,max(1,len_trim(fstr(j)))
          cstr(i+cinc*clen) = fstr(j)(i:i)
       end do
       cinc = cinc+1
    enddo
#endif
#if 5 == 2
    clen= len(fstr(1,1))
    do k=1,sd(2)
       do j=1,sd(1)
          do i=1,max(1,len_trim(fstr(j,k)))
             cstr(i+cinc*clen) = fstr(j,k)(i:i)
          end do
          cinc = cinc+1
       enddo
    enddo
#endif
#if 5 == 3
    clen= len(fstr(1,1,1))
    do m=1,sd(3)
       do k=1,sd(2)
          do j=1,sd(1)
             do i=1,max(1,len_trim(fstr(j,k,m)))
                cstr(i+cinc*clen) = fstr(j,k,m)(i:i)
             end do
             cinc = cinc+1
          enddo
       enddo
    enddo
#endif
#if 5 == 4
    clen= len(fstr(1,1,1,1))
    do n=1,sd(4)
       do m=1,sd(3)
          do k=1,sd(2)
             do j=1,sd(1)
                do i=1,max(1,len_trim(fstr(j,k,m,n)))
                   cstr(i+cinc*clen) = fstr(j,k,m,n)(i:i)
                end do
                cinc = cinc+1
             enddo
          enddo
       enddo
    enddo
#endif
#if 5 == 5
    clen= len(fstr(1,1,1,1,1))
    do q=1,sd(5)
       do n=1,sd(4)
          do m=1,sd(3)
             do k=1,sd(2)
                do j=1,sd(1)
                   do i=1,max(1,len_trim(fstr(j,k,m,n,q)))
                      cstr(i+cinc*clen) = fstr(j,k,m,n,q)(i:i)
                   end do
                   cinc = cinc+1
                enddo
             enddo
          enddo
       enddo
    enddo
#endif


# 508 "pionfput_mod.F90.in"
  end subroutine Fstring2Cstring_5d

! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_1d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i4), intent(in) :: ival(:)
#ifdef TIMING
    call t_startf("PIO:put_vara_1d_int")
#endif

    ierr = put_vara_internal_int (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_1d_int")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_1d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_2d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i4), intent(in) :: ival(:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_2d_int")
#endif

    ierr = put_vara_internal_int (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_2d_int")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_2d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_3d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i4), intent(in) :: ival(:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_3d_int")
#endif

    ierr = put_vara_internal_int (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_3d_int")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_3d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_4d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i4), intent(in) :: ival(:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_4d_int")
#endif

    ierr = put_vara_internal_int (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_4d_int")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_4d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_5d_int (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i4), intent(in) :: ival(:,:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_5d_int")
#endif

    ierr = put_vara_internal_int (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_5d_int")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_5d_int
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_1d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r4), intent(in) :: ival(:)
#ifdef TIMING
    call t_startf("PIO:put_vara_1d_real")
#endif

    ierr = put_vara_internal_real (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_1d_real")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_1d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_2d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r4), intent(in) :: ival(:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_2d_real")
#endif

    ierr = put_vara_internal_real (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_2d_real")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_2d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_3d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r4), intent(in) :: ival(:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_3d_real")
#endif

    ierr = put_vara_internal_real (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_3d_real")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_3d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_4d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r4), intent(in) :: ival(:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_4d_real")
#endif

    ierr = put_vara_internal_real (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_4d_real")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_4d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_5d_real (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r4), intent(in) :: ival(:,:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_5d_real")
#endif

    ierr = put_vara_internal_real (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_5d_real")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_5d_real
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_1d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r8), intent(in) :: ival(:)
#ifdef TIMING
    call t_startf("PIO:put_vara_1d_double")
#endif

    ierr = put_vara_internal_double (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_1d_double")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_1d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_2d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r8), intent(in) :: ival(:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_2d_double")
#endif

    ierr = put_vara_internal_double (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_2d_double")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_2d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_3d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r8), intent(in) :: ival(:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_3d_double")
#endif

    ierr = put_vara_internal_double (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_3d_double")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_3d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_4d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r8), intent(in) :: ival(:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_4d_double")
#endif

    ierr = put_vara_internal_double (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_4d_double")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_4d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_5d_double (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    real(r8), intent(in) :: ival(:,:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_5d_double")
#endif

    ierr = put_vara_internal_double (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_5d_double")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_5d_double
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_1d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i2), intent(in) :: ival(:)
#ifdef TIMING
    call t_startf("PIO:put_vara_1d_short")
#endif

    ierr = put_vara_internal_short (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_1d_short")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_1d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_2d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i2), intent(in) :: ival(:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_2d_short")
#endif

    ierr = put_vara_internal_short (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_2d_short")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_2d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_3d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i2), intent(in) :: ival(:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_3d_short")
#endif

    ierr = put_vara_internal_short (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_3d_short")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_3d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_4d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i2), intent(in) :: ival(:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_4d_short")
#endif

    ierr = put_vara_internal_short (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_4d_short")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_4d_short
! TYPE int,real,double,short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 524 "pionfput_mod.F90.in"
  integer function put_vara_5d_short (File,varid, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(i2), intent(in) :: ival(:,:,:,:,:)
#ifdef TIMING
    call t_startf("PIO:put_vara_5d_short")
#endif

    ierr = put_vara_internal_short (File%fh, varid, start, count, ival)

#ifdef TIMING
    call t_stopf("PIO:put_vara_5d_short")
#endif
# 538 "pionfput_mod.F90.in"
  end function put_vara_5d_short

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:)

    ierr = put_vara_1d_text (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:)

    ierr = put_vara_2d_text (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_text (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_text (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write text data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_text (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:)

    ierr = put_vara_1d_real (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_real (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_real (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_real (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write real data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_real (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:)

    ierr = put_vara_1d_double (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:)

    ierr = put_vara_2d_double (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_double (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_double (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write double data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_double (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:)

    ierr = put_vara_1d_int (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_int (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_int (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_int (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write int data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_int (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 1 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i2), intent(in) :: ival(:)

    ierr = put_vara_1d_short (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 2 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i2), intent(in) :: ival(:,:)

    ierr = put_vara_2d_short (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 3 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i2), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_short (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 4 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i2), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_short (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_short
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Write short data to a netcdf variable of 5 dimension(s).
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 553 "pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_short (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i2), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_short (File, vardesc%varid, start, count, ival)


# 562 "pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_short
end module pionfput_mod
