! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from ncdf_inq.F90.in

#include "config.h"
MODULE ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:2
  use pio_tutil   ! ncdf_inq.F90.in:3
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_fname = "pio_ncdf_inq_test_file.nc"   ! ncdf_inq.F90.in:4
  integer :: tgv_iotype   ! ncdf_inq.F90.in:5
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_var_name = "dummy_var"   ! ncdf_inq.F90.in:6
  integer, parameter :: tgv_var_ndims = 1   ! ncdf_inq.F90.in:7
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_dim_name = "dummy_dim"   ! ncdf_inq.F90.in:8
  integer, parameter :: TGV_DIM_LEN = 100   ! ncdf_inq.F90.in:9
  integer, parameter :: tgv_var_natts = 2   ! ncdf_inq.F90.in:10
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_iatt_name = "dummy_iatt"   ! ncdf_inq.F90.in:11
  integer, parameter :: tgv_iatt_val = 3   ! ncdf_inq.F90.in:12
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_catt_name = "dummy_catt"   ! ncdf_inq.F90.in:13
  integer, parameter :: TGV_ATT_LEN = 100   ! ncdf_inq.F90.in:14
  character(len=TGV_ATT_LEN) :: tgv_catt_val = "DUMMY_STR"   ! ncdf_inq.F90.in:15
END MODULE ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:16


SUBROUTINE test_setup(ret)   ! ncdf_inq.F90.in:18
  use pio_tutil   ! ncdf_inq.F90.in:19
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:20
  implicit none   ! ncdf_inq.F90.in:21


  integer, intent(out) :: ret   ! ncdf_inq.F90.in:23


  type(file_desc_t) :: pio_file   ! ncdf_inq.F90.in:25
  type(var_desc_t)  :: pio_var   ! ncdf_inq.F90.in:26
  integer :: pio_dim   ! ncdf_inq.F90.in:27
  real, dimension(TGV_DIM_LEN) :: val   ! ncdf_inq.F90.in:28
  integer, dimension(TGV_ATT_LEN) :: iatt   ! ncdf_inq.F90.in:29
  CHARACTER(len=TGV_ATT_LEN) :: catt   ! ncdf_inq.F90.in:30


  ret = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname, PIO_CLOBBER)   ! ncdf_inq.F90.in:32
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to open:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:33)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:33


  ! Since file is just created no need to enter redef
  ret = PIO_def_dim(pio_file, tgv_dim_name, TGV_DIM_LEN, pio_dim)   ! ncdf_inq.F90.in:36
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define dim:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:37)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:37


  ret = PIO_def_var(pio_file, tgv_var_name, pio_real, (/pio_dim/), pio_var)   ! ncdf_inq.F90.in:39
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define var:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:40)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:40


  iatt = tgv_iatt_val   ! ncdf_inq.F90.in:42
  ret = PIO_put_att(pio_file, pio_var, tgv_iatt_name, iatt);   ! ncdf_inq.F90.in:43
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to put attribute:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:44)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:44


  catt = tgv_catt_val   ! ncdf_inq.F90.in:46
  ret = PIO_put_att(pio_file, pio_var, tgv_catt_name, catt);   ! ncdf_inq.F90.in:47
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to put attribute:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:48)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:48


  ret = PIO_enddef(pio_file)   ! ncdf_inq.F90.in:50
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:51)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:51


  val = pio_tf_world_rank_   ! ncdf_inq.F90.in:53
  ret = PIO_put_var(pio_file, pio_var, val)   ! ncdf_inq.F90.in:54
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to put var: " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:55)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:55


  call PIO_closefile(pio_file)   ! ncdf_inq.F90.in:57
END SUBROUTINE test_setup   ! ncdf_inq.F90.in:58


SUBROUTINE test_teardown(ret)   ! ncdf_inq.F90.in:60
  use pio_tutil   ! ncdf_inq.F90.in:61
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:62
  implicit none   ! ncdf_inq.F90.in:63


  integer, intent(out) :: ret   ! ncdf_inq.F90.in:65


  ret = PIO_NOERR   ! ncdf_inq.F90.in:67
  call PIO_deletefile(pio_tf_iosystem_, tgv_fname)     ! ncdf_inq.F90.in:68
END SUBROUTINE test_teardown   ! ncdf_inq.F90.in:69


SUBROUTINE test_inq_var(pio_file, ret)   ! ncdf_inq.F90.in:71
  use pio_tutil   ! ncdf_inq.F90.in:72
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:73
  implicit none   ! ncdf_inq.F90.in:74


  type(file_desc_t), intent(in) :: pio_file   ! ncdf_inq.F90.in:76
  integer, intent(inout) :: ret   ! ncdf_inq.F90.in:77


  integer :: var_id, var_type, var_ndims, var_natts   ! ncdf_inq.F90.in:79
  integer, dimension(:), allocatable :: var_dims   ! ncdf_inq.F90.in:80
  character(len=pio_max_name) :: var_name   ! ncdf_inq.F90.in:81


  ret = pio_inq_varid(pio_file, tgv_var_name, var_id)   ! ncdf_inq.F90.in:83
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to inquire varid :"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:84)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:84


  ret = pio_inq_varname(pio_file, var_id, var_name)   ! ncdf_inq.F90.in:86
  
  IF (.NOT. (PIO_TF_Passert_(var_name .eq. tgv_var_name, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Variable name is not the expected value",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:87)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:87


  ret = pio_inq_vartype(pio_file, var_id, var_type)   ! ncdf_inq.F90.in:89
  
  IF (.NOT. (PIO_TF_Passert_(var_type == PIO_real, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Variable tye is not the expected type",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:90)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:90


  ret = pio_inq_varndims(pio_file, var_id, var_ndims)   ! ncdf_inq.F90.in:92
  
  IF (.NOT. (PIO_TF_Passert_(var_ndims == tgv_var_ndims, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Num of dims for variable is not expected",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:93)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:93


  allocate(var_dims(var_ndims))   ! ncdf_inq.F90.in:95
  ret = pio_inq_vardimid(pio_file, var_id, var_dims)   ! ncdf_inq.F90.in:96
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to get dim ids:"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:97)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:97
  deallocate(var_dims)   ! ncdf_inq.F90.in:98


  ret = pio_inq_varnatts(pio_file, var_id, var_natts)   ! ncdf_inq.F90.in:100
  
  IF (.NOT. (PIO_TF_Passert_(var_natts == tgv_var_natts, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Num of atts for variable is not expected",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:101)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:101


END SUBROUTINE test_inq_var   ! ncdf_inq.F90.in:103


SUBROUTINE test_inq_dim(pio_file, ret)   ! ncdf_inq.F90.in:105
  use pio_tutil   ! ncdf_inq.F90.in:106
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:107
  implicit none   ! ncdf_inq.F90.in:108


  type(file_desc_t), intent(in) :: pio_file   ! ncdf_inq.F90.in:110
  integer, intent(inout) :: ret   ! ncdf_inq.F90.in:111


  integer :: dim_id   ! ncdf_inq.F90.in:113
  character(len=pio_max_name) :: dim_name   ! ncdf_inq.F90.in:114
  integer(kind=pio_offset_kind) :: dim_len   ! ncdf_inq.F90.in:115


  ret = pio_inq_dimid(pio_file, tgv_dim_name, dim_id)   ! ncdf_inq.F90.in:117
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to inq dimid :"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:118)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:118


  ret = pio_inq_dimname(pio_file, dim_id, dim_name)   ! ncdf_inq.F90.in:120
   
  IF (.NOT. (PIO_TF_Passert_(dim_name .eq. tgv_dim_name, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Dim name is not the expected value",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:121)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:121


  ret = pio_inq_dimlen(pio_file, dim_id, dim_len)   ! ncdf_inq.F90.in:123
  
  IF (.NOT. (PIO_TF_Passert_(dim_len == TGV_DIM_LEN, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Dim length is not the expected value",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:124)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:124


END SUBROUTINE test_inq_dim   ! ncdf_inq.F90.in:126


SUBROUTINE test_inq_att(pio_file, ret)   ! ncdf_inq.F90.in:128
  use pio_tutil   ! ncdf_inq.F90.in:129
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:130
  implicit none   ! ncdf_inq.F90.in:131


  type(file_desc_t), intent(inout) :: pio_file   ! ncdf_inq.F90.in:133
  integer, intent(inout) :: ret   ! ncdf_inq.F90.in:134


  integer :: var_id   ! ncdf_inq.F90.in:136
  integer(kind=pio_offset_kind) :: att_len   ! ncdf_inq.F90.in:137


  ret = pio_inq_varid(pio_file, tgv_var_name, var_id)   ! ncdf_inq.F90.in:139
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to inquire varid :"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:140)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:140


  ret = pio_inq_attlen(pio_file, var_id, tgv_iatt_name, att_len)   ! ncdf_inq.F90.in:142
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to inquire att len :"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:143)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:143
  !PIO_TF_PASSERT(att_len == tgv_iatt_len, "Att length is not expected value")


  ret = pio_inq_attlen(pio_file, var_id, tgv_catt_name, att_len)   ! ncdf_inq.F90.in:146
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to inquire att len :"//trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:147)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:147
  
  IF (.NOT. (PIO_TF_Passert_(att_len == len(trim(tgv_catt_val)), pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Assertion failed :",&
         "Attribute length is not expected value",&
         ":", __FILE__, ":", __LINE__,&
        "(ncdf_inq.F90.in:148)"
    END IF
    RETURN
  END IF   ! ncdf_inq.F90.in:148


END SUBROUTINE test_inq_att   ! ncdf_inq.F90.in:150


SUBROUTINE test_inq
  USE pio_tutil
   ! ncdf_inq.F90.in:152
  use ncdf_inq_tests_tgv   ! ncdf_inq.F90.in:153
  Implicit none   ! ncdf_inq.F90.in:154
  type(file_desc_t) :: pio_file   ! ncdf_inq.F90.in:155
  integer, dimension(:), allocatable :: iotypes   ! ncdf_inq.F90.in:156
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! ncdf_inq.F90.in:157
  integer :: num_iotypes   ! ncdf_inq.F90.in:158
  integer :: i, ret   ! ncdf_inq.F90.in:159


  num_iotypes = 0   ! ncdf_inq.F90.in:161
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! ncdf_inq.F90.in:162
  do i=1,num_iotypes   ! ncdf_inq.F90.in:163

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing type :", iotype_descs(i)
      END IF
    END IF   ! ncdf_inq.F90.in:164
    tgv_iotype = iotypes(i)   ! ncdf_inq.F90.in:165


    call test_setup(ret)   ! ncdf_inq.F90.in:167
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Test setup failed",&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:168)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:168


    ret = PIO_openfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname, PIO_nowrite)   ! ncdf_inq.F90.in:170
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to open: "// trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:171)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:171


    call test_inq_var(pio_file, ret)   ! ncdf_inq.F90.in:173
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inq var:" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:174)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:174


    call test_inq_dim(pio_file, ret)   ! ncdf_inq.F90.in:176
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inq dim:" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:177)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:177


    call test_inq_att(pio_file, ret)   ! ncdf_inq.F90.in:179
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inq att:" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:180)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:180


    call PIO_closefile(pio_file)   ! ncdf_inq.F90.in:182


    call test_teardown(ret)   ! ncdf_inq.F90.in:184
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Test teardown failed",&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_inq.F90.in:185)"
      END IF
      RETURN
    END IF   ! ncdf_inq.F90.in:185
  end do   ! ncdf_inq.F90.in:186
  if(allocated(iotypes)) then   ! ncdf_inq.F90.in:187
    deallocate(iotypes)   ! ncdf_inq.F90.in:188
    deallocate(iotype_descs)   ! ncdf_inq.F90.in:189
  end if   ! ncdf_inq.F90.in:190


END SUBROUTINE test_inq   ! ncdf_inq.F90.in:192


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting test_inq"
    END IF
    CALL test_inq()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "test_inq","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "test_inq","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
