! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from ncdf_simple_tests.F90.in

#include "config.h"
MODULE ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:2
  use pio_tutil   ! ncdf_simple_tests.F90.in:3
  ! tgv in prefix corresponds to module name (ncdf_simple_tests_tgv)
  character(len=PIO_TF_MAX_STR_LEN), parameter :: tgv_fname = "pio_ncdf_test_file.nc"   ! ncdf_simple_tests.F90.in:5
  integer :: tgv_iotype   ! ncdf_simple_tests.F90.in:6
END MODULE ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:7


SUBROUTINE test_clobber
  USE pio_tutil
   ! ncdf_simple_tests.F90.in:9
  use ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:10
  Implicit none   ! ncdf_simple_tests.F90.in:11
  type(file_desc_t) :: pio_file   ! ncdf_simple_tests.F90.in:12
  character(len=PIO_TF_MAX_STR_LEN), parameter :: clob_fname = "pio_test_clobber.nc"   ! ncdf_simple_tests.F90.in:13
  integer :: ret   ! ncdf_simple_tests.F90.in:14


  ! Default is NOCLOBBER
  ret = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, clob_fname)   ! ncdf_simple_tests.F90.in:17
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to create:" // trim(clob_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:18)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:18


  call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:20


  ! Recrate with CLOBBER option - should erase existing file and create new one
  ret = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, clob_fname, PIO_CLOBBER)   ! ncdf_simple_tests.F90.in:23
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to create (with CLOBBER):" // trim(clob_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:24)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:24


  call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:26
  call PIO_deletefile(pio_tf_iosystem_, clob_fname)   ! ncdf_simple_tests.F90.in:27


END SUBROUTINE test_clobber   ! ncdf_simple_tests.F90.in:29


SUBROUTINE test_redef_enddef
  USE pio_tutil
   ! ncdf_simple_tests.F90.in:31
  use ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:32
  Implicit none   ! ncdf_simple_tests.F90.in:33
  type(file_desc_t) :: pio_file   ! ncdf_simple_tests.F90.in:34
  integer :: ret   ! ncdf_simple_tests.F90.in:35


  ret = PIO_openfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname, PIO_write)   ! ncdf_simple_tests.F90.in:37
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to open:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:38)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:38


  ! A simple redef and then enddef
  ret = PIO_redef(pio_file)   ! ncdf_simple_tests.F90.in:41
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to redef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:42)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:42


  ret = PIO_enddef(pio_file)   ! ncdf_simple_tests.F90.in:44
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:45)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:45


  call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:47


END SUBROUTINE test_redef_enddef   ! ncdf_simple_tests.F90.in:49


SUBROUTINE test_def_dim
  USE pio_tutil
   ! ncdf_simple_tests.F90.in:51
  use ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:52
  Implicit none   ! ncdf_simple_tests.F90.in:53
  type(file_desc_t) :: pio_file   ! ncdf_simple_tests.F90.in:54
  integer :: pio_dim   ! ncdf_simple_tests.F90.in:55
  integer :: ret   ! ncdf_simple_tests.F90.in:56


  ret = PIO_openfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname, PIO_write)   ! ncdf_simple_tests.F90.in:58
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to open:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:59)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:59


  ! A simple redef and then enddef
  ret = PIO_redef(pio_file)   ! ncdf_simple_tests.F90.in:62
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to redef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:63)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:63


  ret = PIO_def_dim(pio_file, 'dummy_dim_def_dim', 100, pio_dim)   ! ncdf_simple_tests.F90.in:65
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define dim:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:66)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:66


  ret = PIO_enddef(pio_file)   ! ncdf_simple_tests.F90.in:68
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:69)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:69


  call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:71


END SUBROUTINE test_def_dim   ! ncdf_simple_tests.F90.in:73


SUBROUTINE test_def_var
  USE pio_tutil
   ! ncdf_simple_tests.F90.in:75
  use ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:76
  Implicit none   ! ncdf_simple_tests.F90.in:77
  type(file_desc_t) :: pio_file   ! ncdf_simple_tests.F90.in:78
  type(var_desc_t)  :: pio_var   ! ncdf_simple_tests.F90.in:79
  integer :: pio_dim   ! ncdf_simple_tests.F90.in:80
  integer :: ret   ! ncdf_simple_tests.F90.in:81


  ret = PIO_openfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname, PIO_write)   ! ncdf_simple_tests.F90.in:83
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to open:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:84)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:84


  ! A simple redef and then enddef
  ret = PIO_redef(pio_file)   ! ncdf_simple_tests.F90.in:87
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to redef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:88)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:88


  ret = PIO_def_dim(pio_file, 'dummy_dim_def_var', 100, pio_dim)   ! ncdf_simple_tests.F90.in:90
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define dim:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:91)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:91


  ret = PIO_def_var(pio_file, 'dummy_var_def_var', PIO_int, (/pio_dim/), pio_var)   ! ncdf_simple_tests.F90.in:93
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define var:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:94)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:94


  ret = PIO_enddef(pio_file)   ! ncdf_simple_tests.F90.in:96
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef:" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:97)"
    END IF
    RETURN
  END IF   ! ncdf_simple_tests.F90.in:97


  call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:99


END SUBROUTINE test_def_var   ! ncdf_simple_tests.F90.in:101




SUBROUTINE test_data_conversion_PIO_int_integer_kind_fc_int___
USE pio_tutil

  use ncdf_simple_tests_tgv
  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: data_fname = "pio_test_data_conversion_PIO_int_integer_kind_fc_int___.nc"
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: compdof, compdof_rel_disps
  integer, dimension(VEC_LOCAL_SZ) :: wbuf
  integer(kind=fc_int), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
   ! ncdf_simple_tests.F90.in:118
   ! ncdf_simple_tests.F90.in:119
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  compdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = pio_tf_world_rank_;
  exp_val = pio_tf_world_rank_;
   ! ncdf_simple_tests.F90.in:127
  ! Set the decomposition for writing data as PIO_int
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wiodesc)
   ! ncdf_simple_tests.F90.in:130
  ! Set the decomposition for reading data as various types
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, riodesc)
   ! ncdf_simple_tests.F90.in:133
  ierr = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, data_fname, PIO_CLOBBER)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:135)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:136
  ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a dim : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:138)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:139
  ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a var : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:141)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:142
  ierr = PIO_enddef(pio_file)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to end redef mode : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:144)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:145
  ! Write the variable out
  call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to write darray : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:148)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:149
  call PIO_syncfile(pio_file)
   ! ncdf_simple_tests.F90.in:151
  if (tgv_iotype .eq. PIO_iotype_pnetcdf) then

     IF (pio_tf_world_rank_ == 0) THEN
       IF (pio_tf_log_level_ >= 0) THEN
         WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
         WRITE(*,*)  "WARNING: Data type conversion not supported in pnetcdf vard interface, skipping test"
       END IF
     END IF
  else
     ! Read the variable back (data conversion might occur)
     call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
     
     IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Function failed:",&
            "Failed to read darray : " // trim(data_fname),&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:157)"
       END IF
       RETURN
     END IF
     
     IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Check failed:",&
            "Got wrong val",&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:158)"
       END IF
       RETURN
     END IF
  endif
   ! ncdf_simple_tests.F90.in:160
  call PIO_closefile(pio_file)
  call PIO_deletefile(pio_tf_iosystem_, data_fname);
   ! ncdf_simple_tests.F90.in:163
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
   ! ncdf_simple_tests.F90.in:166
END SUBROUTINE test_data_conversion_PIO_int_integer_kind_fc_int___


SUBROUTINE test_data_conversion_PIO_short_integer_kind_fc_short___
USE pio_tutil

  use ncdf_simple_tests_tgv
  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: data_fname = "pio_test_data_conversion_PIO_short_integer_kind_fc_short___.nc"
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: compdof, compdof_rel_disps
  integer, dimension(VEC_LOCAL_SZ) :: wbuf
  integer(kind=fc_short), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
   ! ncdf_simple_tests.F90.in:118
   ! ncdf_simple_tests.F90.in:119
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  compdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = pio_tf_world_rank_;
  exp_val = pio_tf_world_rank_;
   ! ncdf_simple_tests.F90.in:127
  ! Set the decomposition for writing data as PIO_int
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wiodesc)
   ! ncdf_simple_tests.F90.in:130
  ! Set the decomposition for reading data as various types
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, riodesc)
   ! ncdf_simple_tests.F90.in:133
  ierr = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, data_fname, PIO_CLOBBER)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:135)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:136
  ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a dim : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:138)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:139
  ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a var : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:141)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:142
  ierr = PIO_enddef(pio_file)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to end redef mode : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:144)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:145
  ! Write the variable out
  call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to write darray : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:148)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:149
  call PIO_syncfile(pio_file)
   ! ncdf_simple_tests.F90.in:151
  if (tgv_iotype .eq. PIO_iotype_pnetcdf) then

     IF (pio_tf_world_rank_ == 0) THEN
       IF (pio_tf_log_level_ >= 0) THEN
         WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
         WRITE(*,*)  "WARNING: Data type conversion not supported in pnetcdf vard interface, skipping test"
       END IF
     END IF
  else
     ! Read the variable back (data conversion might occur)
     call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
     
     IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Function failed:",&
            "Failed to read darray : " // trim(data_fname),&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:157)"
       END IF
       RETURN
     END IF
     
     IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Check failed:",&
            "Got wrong val",&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:158)"
       END IF
       RETURN
     END IF
  endif
   ! ncdf_simple_tests.F90.in:160
  call PIO_closefile(pio_file)
  call PIO_deletefile(pio_tf_iosystem_, data_fname);
   ! ncdf_simple_tests.F90.in:163
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
   ! ncdf_simple_tests.F90.in:166
END SUBROUTINE test_data_conversion_PIO_short_integer_kind_fc_short___


SUBROUTINE test_data_conversion_PIO_real_real_kind_fc_real___
USE pio_tutil

  use ncdf_simple_tests_tgv
  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: data_fname = "pio_test_data_conversion_PIO_real_real_kind_fc_real___.nc"
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: compdof, compdof_rel_disps
  integer, dimension(VEC_LOCAL_SZ) :: wbuf
  real(kind=fc_real), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
   ! ncdf_simple_tests.F90.in:118
   ! ncdf_simple_tests.F90.in:119
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  compdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = pio_tf_world_rank_;
  exp_val = pio_tf_world_rank_;
   ! ncdf_simple_tests.F90.in:127
  ! Set the decomposition for writing data as PIO_int
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wiodesc)
   ! ncdf_simple_tests.F90.in:130
  ! Set the decomposition for reading data as various types
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, riodesc)
   ! ncdf_simple_tests.F90.in:133
  ierr = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, data_fname, PIO_CLOBBER)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:135)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:136
  ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a dim : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:138)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:139
  ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a var : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:141)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:142
  ierr = PIO_enddef(pio_file)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to end redef mode : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:144)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:145
  ! Write the variable out
  call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to write darray : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:148)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:149
  call PIO_syncfile(pio_file)
   ! ncdf_simple_tests.F90.in:151
  if (tgv_iotype .eq. PIO_iotype_pnetcdf) then

     IF (pio_tf_world_rank_ == 0) THEN
       IF (pio_tf_log_level_ >= 0) THEN
         WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
         WRITE(*,*)  "WARNING: Data type conversion not supported in pnetcdf vard interface, skipping test"
       END IF
     END IF
  else
     ! Read the variable back (data conversion might occur)
     call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
     
     IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Function failed:",&
            "Failed to read darray : " // trim(data_fname),&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:157)"
       END IF
       RETURN
     END IF
     
     IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Check failed:",&
            "Got wrong val",&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:158)"
       END IF
       RETURN
     END IF
  endif
   ! ncdf_simple_tests.F90.in:160
  call PIO_closefile(pio_file)
  call PIO_deletefile(pio_tf_iosystem_, data_fname);
   ! ncdf_simple_tests.F90.in:163
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
   ! ncdf_simple_tests.F90.in:166
END SUBROUTINE test_data_conversion_PIO_real_real_kind_fc_real___


SUBROUTINE test_data_conversion_PIO_double_real_kind_fc_double___
USE pio_tutil

  use ncdf_simple_tests_tgv
  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: data_fname = "pio_test_data_conversion_PIO_double_real_kind_fc_double___.nc"
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: compdof, compdof_rel_disps
  integer, dimension(VEC_LOCAL_SZ) :: wbuf
  real(kind=fc_double), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
   ! ncdf_simple_tests.F90.in:118
   ! ncdf_simple_tests.F90.in:119
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  compdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = pio_tf_world_rank_;
  exp_val = pio_tf_world_rank_;
   ! ncdf_simple_tests.F90.in:127
  ! Set the decomposition for writing data as PIO_int
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wiodesc)
   ! ncdf_simple_tests.F90.in:130
  ! Set the decomposition for reading data as various types
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, riodesc)
   ! ncdf_simple_tests.F90.in:133
  ierr = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, data_fname, PIO_CLOBBER)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:135)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:136
  ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a dim : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:138)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:139
  ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define a var : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:141)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:142
  ierr = PIO_enddef(pio_file)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to end redef mode : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:144)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:145
  ! Write the variable out
  call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
  
  IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to write darray : " // trim(data_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(ncdf_simple_tests.F90.in:148)"
    END IF
    RETURN
  END IF
   ! ncdf_simple_tests.F90.in:149
  call PIO_syncfile(pio_file)
   ! ncdf_simple_tests.F90.in:151
  if (tgv_iotype .eq. PIO_iotype_pnetcdf) then

     IF (pio_tf_world_rank_ == 0) THEN
       IF (pio_tf_log_level_ >= 0) THEN
         WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
         WRITE(*,*)  "WARNING: Data type conversion not supported in pnetcdf vard interface, skipping test"
       END IF
     END IF
  else
     ! Read the variable back (data conversion might occur)
     call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
     
     IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Function failed:",&
            "Failed to read darray : " // trim(data_fname),&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:157)"
       END IF
       RETURN
     END IF
     
     IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
       pio_tf_retval_utest_ = -1
       IF (pio_tf_world_rank_ == 0) THEN
         PRINT *, "PIO_TF: PIO Check failed:",&
            "Got wrong val",&
           ":", __FILE__, ":", __LINE__,&
           "(ncdf_simple_tests.F90.in:158)"
       END IF
       RETURN
     END IF
  endif
   ! ncdf_simple_tests.F90.in:160
  call PIO_closefile(pio_file)
  call PIO_deletefile(pio_tf_iosystem_, data_fname);
   ! ncdf_simple_tests.F90.in:163
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
   ! ncdf_simple_tests.F90.in:166
END SUBROUTINE test_data_conversion_PIO_double_real_kind_fc_double___
   ! ncdf_simple_tests.F90.in:167


SUBROUTINE PIO_TF_Test_driver_
  USE pio_tutil
   ! ncdf_simple_tests.F90.in:169
  use ncdf_simple_tests_tgv   ! ncdf_simple_tests.F90.in:170
  Implicit none   ! ncdf_simple_tests.F90.in:171
  type(file_desc_t) :: pio_file   ! ncdf_simple_tests.F90.in:172
  integer :: ret, i   ! ncdf_simple_tests.F90.in:173
  ! iotypes = valid NC types
  integer, dimension(:), allocatable :: iotypes   ! ncdf_simple_tests.F90.in:175
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! ncdf_simple_tests.F90.in:176
  integer :: num_iotypes   ! ncdf_simple_tests.F90.in:177


  num_iotypes = 0   ! ncdf_simple_tests.F90.in:179
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! ncdf_simple_tests.F90.in:180
  do i=1,num_iotypes   ! ncdf_simple_tests.F90.in:181
    tgv_iotype = iotypes(i)   ! ncdf_simple_tests.F90.in:182
    ret = PIO_createfile(pio_tf_iosystem_, pio_file, tgv_iotype, tgv_fname)   ! ncdf_simple_tests.F90.in:183
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create:"//trim(iotype_descs(i))//":"//trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(ncdf_simple_tests.F90.in:184)"
      END IF
      RETURN
    END IF   ! ncdf_simple_tests.F90.in:184


    call PIO_closefile(pio_file)   ! ncdf_simple_tests.F90.in:186


    ! Make sure that global variables are set correctly before running the tests
    
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Running AUTO tests: ", trim(iotype_descs(i))
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_data_conversion_PIO_int_integer_kind_fc_int___"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_data_conversion_PIO_int_integer_kind_fc_int___"
      END IF
      CALL test_data_conversion_PIO_int_integer_kind_fc_int___()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_data_conversion_PIO_short_integer_kind_fc_short___"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_data_conversion_PIO_short_integer_kind_fc_short___"
      END IF
      CALL test_data_conversion_PIO_short_integer_kind_fc_short___()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_data_conversion_PIO_real_real_kind_fc_real___"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_data_conversion_PIO_real_real_kind_fc_real___"
      END IF
      CALL test_data_conversion_PIO_real_real_kind_fc_real___()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_data_conversion_PIO_double_real_kind_fc_double___"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_data_conversion_PIO_double_real_kind_fc_double___"
      END IF
      CALL test_data_conversion_PIO_double_real_kind_fc_double___()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_clobber"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_clobber"
      END IF
      CALL test_clobber()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_redef_enddef"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_redef_enddef"
      END IF
      CALL test_redef_enddef()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_def_dim"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_def_dim"
      END IF
      CALL test_def_dim()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
      pio_tf_retval_utest_ = 0
      pio_tf_tmp_log_str_="test_def_var"//"("//trim(iotype_descs(i))//")"
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: Starting test_def_var"
      END IF
      CALL test_def_var()
      IF (pio_tf_retval_utest_ /= 0) THEN
        pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
      END IF
      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
            pio_tf_tmp_log_str_,&
            "---------","PASSED"
        ELSE
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
            pio_tf_tmp_log_str_,&
            "---------","FAILED"
        END IF
      END IF
   ! ncdf_simple_tests.F90.in:189


    call PIO_deletefile(pio_tf_iosystem_, tgv_fname)   ! ncdf_simple_tests.F90.in:191
  end do   ! ncdf_simple_tests.F90.in:192
  if(allocated(iotypes)) then   ! ncdf_simple_tests.F90.in:193
    deallocate(iotypes)   ! ncdf_simple_tests.F90.in:194
    deallocate(iotype_descs)   ! ncdf_simple_tests.F90.in:195
  end if   ! ncdf_simple_tests.F90.in:196



END SUBROUTINE PIO_TF_Test_driver_   ! ncdf_simple_tests.F90.in:198


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
