! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_decomp_fillval.F90.in

#include "config.h"
! nc write 1d array with fillvalues (the holes are explicitly specified)


SUBROUTINE nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole, this hole
  ! is usually filled with a fillvalue
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  integer(kind=fc_int), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  integer(kind=fc_int), PARAMETER :: BUF_FILLVAL = -2
  integer :: no_fill
  integer(kind=fc_int) :: fillval
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:27
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:34
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = 0
   ! pio_decomp_fillval.F90.in:38
  ! Even indices need to be filled with (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    wcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = BUF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:44
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:47
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  do i=1,num_iotypes
   ! pio_decomp_fillval.F90.in:51
    write(filename,'(a,i1)') "test_pio_decomp_fillval_tests.testfile",i
   ! pio_decomp_fillval.F90.in:53

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:56)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:57
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:59)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:60
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:62)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:63
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:65)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:66
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:68)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:69
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:72)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:73
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:75
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:77)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:78)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:80)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:81)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:82
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:90
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole, this hole
  ! is usually filled with a fillvalue
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  integer(kind=fc_short), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  integer(kind=fc_short), PARAMETER :: BUF_FILLVAL = -2
  integer :: no_fill
  integer(kind=fc_short) :: fillval
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:27
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:34
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = 0
   ! pio_decomp_fillval.F90.in:38
  ! Even indices need to be filled with (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    wcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = BUF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:44
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:47
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  do i=1,num_iotypes
   ! pio_decomp_fillval.F90.in:51
    write(filename,'(a,i1)') "test_pio_decomp_fillval_tests.testfile",i
   ! pio_decomp_fillval.F90.in:53

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:56)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:57
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:59)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:60
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:62)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:63
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:65)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:66
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:68)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:69
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:72)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:73
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:75
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:77)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:78)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:80)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:81)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:82
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:90
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole, this hole
  ! is usually filled with a fillvalue
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  real(kind=fc_real), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  real(kind=fc_real), PARAMETER :: BUF_FILLVAL = -2
  integer :: no_fill
  real(kind=fc_real) :: fillval
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:27
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:34
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = 0
   ! pio_decomp_fillval.F90.in:38
  ! Even indices need to be filled with (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    wcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = BUF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:44
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:47
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  do i=1,num_iotypes
   ! pio_decomp_fillval.F90.in:51
    write(filename,'(a,i1)') "test_pio_decomp_fillval_tests.testfile",i
   ! pio_decomp_fillval.F90.in:53

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:56)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:57
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:59)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:60
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:62)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:63
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:65)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:66
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:68)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:69
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:72)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:73
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:75
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:77)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:78)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:80)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:81)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:82
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:90
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___


SUBROUTINE nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole, this hole
  ! is usually filled with a fillvalue
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  real(kind=fc_double), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  real(kind=fc_double), PARAMETER :: BUF_FILLVAL = -2
  integer :: no_fill
  real(kind=fc_double) :: fillval
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:27
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:34
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = 0
   ! pio_decomp_fillval.F90.in:38
  ! Even indices need to be filled with (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    wcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = BUF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:44
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:47
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  do i=1,num_iotypes
   ! pio_decomp_fillval.F90.in:51
    write(filename,'(a,i1)') "test_pio_decomp_fillval_tests.testfile",i
   ! pio_decomp_fillval.F90.in:53

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:56)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:57
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:59)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:60
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:62)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:63
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:65)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:66
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:68)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:69
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:72)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:73
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:75
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:77)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:78)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:80)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:81)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:82
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:90
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___
   ! pio_decomp_fillval.F90.in:93


! nc write 1d array with fillvalues (the holes are implicit)


SUBROUTINE nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: wcompdof
  integer :: wcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: rcompdof, compdof_rel_disps
  integer(kind=fc_int), dimension(:), allocatable :: wbuf
  integer(kind=fc_int), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  integer(kind=fc_int), PARAMETER :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: no_fill
  integer(kind=fc_int) :: fillval
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:120
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  wcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(wcompdof(wcompdof_sz))
  allocate(wbuf(wcompdof_sz))
   ! pio_decomp_fillval.F90.in:126
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! rank 0 has 1 valid data value, rank 2 has 2 data values and so on...
  do i=1,wcompdof_sz
    wcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Read everything - including fillvalues that should have been
  ! written for locations unspecified in wcompdof(:) i.e.,
  ! wcompdof(wcompdof_sz:VEC_LOCAL_SZ]
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:139
  wbuf = 0
  ! The first wcompdof_sz values, wbuf[1:wcompdof_sz], are valid in wbuf
  do i=1,wcompdof_sz
    wbuf(i) = wcompdof(i)
    exp_val(i) = wbuf(i)
  end do
  ! We expect the values (wcompdof_sz:VEC_LOCAL_SZ] to be read as
  ! user specified fill values
  do i=wcompdof_sz+1,VEC_LOCAL_SZ
    exp_val(i) = BUF_FILLVAL
  end do
  rbuf = 0
   ! pio_decomp_fillval.F90.in:152
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:155
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:162)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:163
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:165)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:166
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:168)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:169
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:171)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:172
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:174)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:175
    ! Write the variable out, user specified fillvalue = BUF_FILLVAL
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:178)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:179
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:181
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:183)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:184)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:186)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:187)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:188
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:196
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(wbuf)
  deallocate(wcompdof)
END SUBROUTINE nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: wcompdof
  integer :: wcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: rcompdof, compdof_rel_disps
  integer(kind=fc_short), dimension(:), allocatable :: wbuf
  integer(kind=fc_short), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  integer(kind=fc_short), PARAMETER :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: no_fill
  integer(kind=fc_short) :: fillval
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:120
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  wcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(wcompdof(wcompdof_sz))
  allocate(wbuf(wcompdof_sz))
   ! pio_decomp_fillval.F90.in:126
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! rank 0 has 1 valid data value, rank 2 has 2 data values and so on...
  do i=1,wcompdof_sz
    wcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Read everything - including fillvalues that should have been
  ! written for locations unspecified in wcompdof(:) i.e.,
  ! wcompdof(wcompdof_sz:VEC_LOCAL_SZ]
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:139
  wbuf = 0
  ! The first wcompdof_sz values, wbuf[1:wcompdof_sz], are valid in wbuf
  do i=1,wcompdof_sz
    wbuf(i) = wcompdof(i)
    exp_val(i) = wbuf(i)
  end do
  ! We expect the values (wcompdof_sz:VEC_LOCAL_SZ] to be read as
  ! user specified fill values
  do i=wcompdof_sz+1,VEC_LOCAL_SZ
    exp_val(i) = BUF_FILLVAL
  end do
  rbuf = 0
   ! pio_decomp_fillval.F90.in:152
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:155
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:162)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:163
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:165)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:166
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:168)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:169
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:171)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:172
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:174)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:175
    ! Write the variable out, user specified fillvalue = BUF_FILLVAL
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:178)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:179
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:181
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:183)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:184)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:186)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:187)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:188
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:196
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(wbuf)
  deallocate(wcompdof)
END SUBROUTINE nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: wcompdof
  integer :: wcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: rcompdof, compdof_rel_disps
  real(kind=fc_real), dimension(:), allocatable :: wbuf
  real(kind=fc_real), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  real(kind=fc_real), PARAMETER :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: no_fill
  real(kind=fc_real) :: fillval
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:120
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  wcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(wcompdof(wcompdof_sz))
  allocate(wbuf(wcompdof_sz))
   ! pio_decomp_fillval.F90.in:126
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! rank 0 has 1 valid data value, rank 2 has 2 data values and so on...
  do i=1,wcompdof_sz
    wcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Read everything - including fillvalues that should have been
  ! written for locations unspecified in wcompdof(:) i.e.,
  ! wcompdof(wcompdof_sz:VEC_LOCAL_SZ]
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:139
  wbuf = 0
  ! The first wcompdof_sz values, wbuf[1:wcompdof_sz], are valid in wbuf
  do i=1,wcompdof_sz
    wbuf(i) = wcompdof(i)
    exp_val(i) = wbuf(i)
  end do
  ! We expect the values (wcompdof_sz:VEC_LOCAL_SZ] to be read as
  ! user specified fill values
  do i=wcompdof_sz+1,VEC_LOCAL_SZ
    exp_val(i) = BUF_FILLVAL
  end do
  rbuf = 0
   ! pio_decomp_fillval.F90.in:152
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:155
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:162)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:163
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:165)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:166
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:168)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:169
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:171)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:172
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:174)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:175
    ! Write the variable out, user specified fillvalue = BUF_FILLVAL
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:178)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:179
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:181
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:183)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:184)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:186)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:187)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:188
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:196
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(wbuf)
  deallocate(wcompdof)
END SUBROUTINE nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___


SUBROUTINE nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: wcompdof
  integer :: wcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: rcompdof, compdof_rel_disps
  real(kind=fc_double), dimension(:), allocatable :: wbuf
  real(kind=fc_double), dimension(VEC_LOCAL_SZ) :: rbuf, exp_val
  ! The buffer fillvalue to be used when writing data
  real(kind=fc_double), PARAMETER :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: no_fill
  real(kind=fc_double) :: fillval
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:120
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  wcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(wcompdof(wcompdof_sz))
  allocate(wbuf(wcompdof_sz))
   ! pio_decomp_fillval.F90.in:126
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! rank 0 has 1 valid data value, rank 2 has 2 data values and so on...
  do i=1,wcompdof_sz
    wcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Read everything - including fillvalues that should have been
  ! written for locations unspecified in wcompdof(:) i.e.,
  ! wcompdof(wcompdof_sz:VEC_LOCAL_SZ]
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:139
  wbuf = 0
  ! The first wcompdof_sz values, wbuf[1:wcompdof_sz], are valid in wbuf
  do i=1,wcompdof_sz
    wbuf(i) = wcompdof(i)
    exp_val(i) = wbuf(i)
  end do
  ! We expect the values (wcompdof_sz:VEC_LOCAL_SZ] to be read as
  ! user specified fill values
  do i=wcompdof_sz+1,VEC_LOCAL_SZ
    exp_val(i) = BUF_FILLVAL
  end do
  rbuf = 0
   ! pio_decomp_fillval.F90.in:152
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:155
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:162)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:163
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:165)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:166
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:168)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:169
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:171)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:172
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:174)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:175
    ! Write the variable out, user specified fillvalue = BUF_FILLVAL
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:178)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:179
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:181
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:183)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:184)"
      END IF
      RETURN
    END IF
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:186)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:187)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:188
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:196
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(wbuf)
  deallocate(wcompdof)
END SUBROUTINE nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___
   ! pio_decomp_fillval.F90.in:201


! nc read 1d array with fillvalues (the holes are explicitly specified)


SUBROUTINE nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  integer(kind=fc_int), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue used to initialize data
  integer(kind=fc_int), PARAMETER :: BUF_FILLVAL = -2
  ! fillvalue returned from pio_inq_var_fill
  integer(kind=fc_int) :: fillval
   ! pio_decomp_fillval.F90.in:220
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  integer :: no_fill 
   ! pio_decomp_fillval.F90.in:229
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:236
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = BUF_FILLVAL
   ! pio_decomp_fillval.F90.in:240
  ! We don't want to read even indices (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    rcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = PIO_COMPDOF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:246
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:249
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
   ! pio_decomp_fillval.F90.in:252
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:257)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:258

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : filename : ", trim(filename)
      END IF
    END IF
   ! pio_decomp_fillval.F90.in:260
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:262)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:263
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:265)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:266
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:268)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:269
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:271)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:272
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:275)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:276
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:278
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:281
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:282)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:283
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:285)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:287
   ! pio_decomp_fillval.F90.in:288
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:296
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  integer(kind=fc_short), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue used to initialize data
  integer(kind=fc_short), PARAMETER :: BUF_FILLVAL = -2
  ! fillvalue returned from pio_inq_var_fill
  integer(kind=fc_short) :: fillval
   ! pio_decomp_fillval.F90.in:220
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  integer :: no_fill 
   ! pio_decomp_fillval.F90.in:229
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:236
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = BUF_FILLVAL
   ! pio_decomp_fillval.F90.in:240
  ! We don't want to read even indices (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    rcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = PIO_COMPDOF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:246
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:249
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
   ! pio_decomp_fillval.F90.in:252
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:257)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:258

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : filename : ", trim(filename)
      END IF
    END IF
   ! pio_decomp_fillval.F90.in:260
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:262)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:263
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:265)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:266
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:268)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:269
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:271)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:272
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:275)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:276
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:278
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:281
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:282)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:283
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:285)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:287
   ! pio_decomp_fillval.F90.in:288
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:296
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  real(kind=fc_real), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue used to initialize data
  real(kind=fc_real), PARAMETER :: BUF_FILLVAL = -2
  ! fillvalue returned from pio_inq_var_fill
  real(kind=fc_real) :: fillval
   ! pio_decomp_fillval.F90.in:220
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  integer :: no_fill 
   ! pio_decomp_fillval.F90.in:229
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:236
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = BUF_FILLVAL
   ! pio_decomp_fillval.F90.in:240
  ! We don't want to read even indices (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    rcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = PIO_COMPDOF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:246
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:249
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
   ! pio_decomp_fillval.F90.in:252
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:257)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:258

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : filename : ", trim(filename)
      END IF
    END IF
   ! pio_decomp_fillval.F90.in:260
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:262)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:263
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:265)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:266
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:268)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:269
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:271)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:272
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:275)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:276
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:278
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:281
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:282)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:283
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:285)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:287
   ! pio_decomp_fillval.F90.in:288
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:296
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___


SUBROUTINE nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, rcompdof, compdof_rel_disps
  ! Compdof value to suggest that data point is a hole
  integer, parameter :: PIO_COMPDOF_FILLVAL = 0
  real(kind=fc_double), dimension(VEC_LOCAL_SZ) :: wbuf, rbuf, exp_val
  ! The buffer fillvalue used to initialize data
  real(kind=fc_double), PARAMETER :: BUF_FILLVAL = -2
  ! fillvalue returned from pio_inq_var_fill
  real(kind=fc_double) :: fillval
   ! pio_decomp_fillval.F90.in:220
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  integer :: no_fill 
   ! pio_decomp_fillval.F90.in:229
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  rcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
   ! pio_decomp_fillval.F90.in:236
  wbuf = wcompdof
  exp_val = wcompdof
  rbuf = BUF_FILLVAL
   ! pio_decomp_fillval.F90.in:240
  ! We don't want to read even indices (BUF_FILLVAL == -2)
  do i=1,VEC_LOCAL_SZ,2
    rcompdof(i) = PIO_COMPDOF_FILLVAL
    exp_val(i) = PIO_COMPDOF_FILLVAL
  end do
   ! pio_decomp_fillval.F90.in:246
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:249
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
   ! pio_decomp_fillval.F90.in:252
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:257)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:258

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : filename : ", trim(filename)
      END IF
    END IF
   ! pio_decomp_fillval.F90.in:260
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:262)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:263
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:265)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:266
    ierr = PIO_put_att(pio_file, pio_var, '_FillValue', BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define fill value : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:268)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:269
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:271)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:272
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr, BUF_FILLVAL)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:275)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:276
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:278
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:281
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:282)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:283
    ierr = PIO_inq_var_fill(pio_file, pio_var, no_fill, fillval)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to inquire var fill: " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:285)"
      END IF
      RETURN
    END IF
    
    IF (.NOT. PIO_TF_Check_val_(fillval, BUF_FILLVAL)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:287
   ! pio_decomp_fillval.F90.in:288
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:296
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
END SUBROUTINE nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___
   ! pio_decomp_fillval.F90.in:299


! nc read 1d array with fillvalues (the holes are implicit)


SUBROUTINE nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: rcompdof
  integer :: rcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, compdof_rel_disps
  integer(kind=fc_int), dimension(:), allocatable :: rbuf, exp_val
  integer(kind=fc_int), dimension(VEC_LOCAL_SZ) :: wbuf
  integer, parameter :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:323
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  rcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(rcompdof(rcompdof_sz))
  allocate(rbuf(rcompdof_sz))
  allocate(exp_val(rcompdof_sz))
   ! pio_decomp_fillval.F90.in:330
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! We only read 1 value on rank0, 2 values on rank1, ...
  do i=1,rcompdof_sz
    rcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Write everything - we only read some of these values
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = wcompdof
   ! pio_decomp_fillval.F90.in:342
  rbuf = BUF_FILLVAL
  do i=1,rcompdof_sz
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_fillval.F90.in:347
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:350
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:357)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:358
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:360)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:361
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:363)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:364
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:366)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:367
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:369)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:370
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:372
    ! Read only part of the written data
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:375)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:376
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:378
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:386
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(rcompdof)
END SUBROUTINE nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: rcompdof
  integer :: rcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, compdof_rel_disps
  integer(kind=fc_short), dimension(:), allocatable :: rbuf, exp_val
  integer(kind=fc_short), dimension(VEC_LOCAL_SZ) :: wbuf
  integer, parameter :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:323
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  rcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(rcompdof(rcompdof_sz))
  allocate(rbuf(rcompdof_sz))
  allocate(exp_val(rcompdof_sz))
   ! pio_decomp_fillval.F90.in:330
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! We only read 1 value on rank0, 2 values on rank1, ...
  do i=1,rcompdof_sz
    rcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Write everything - we only read some of these values
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = wcompdof
   ! pio_decomp_fillval.F90.in:342
  rbuf = BUF_FILLVAL
  do i=1,rcompdof_sz
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_fillval.F90.in:347
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:350
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:357)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:358
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:360)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:361
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:363)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:364
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:366)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:367
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:369)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:370
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:372
    ! Read only part of the written data
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:375)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:376
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:378
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:386
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(rcompdof)
END SUBROUTINE nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: rcompdof
  integer :: rcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, compdof_rel_disps
  real(kind=fc_real), dimension(:), allocatable :: rbuf, exp_val
  real(kind=fc_real), dimension(VEC_LOCAL_SZ) :: wbuf
  integer, parameter :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:323
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  rcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(rcompdof(rcompdof_sz))
  allocate(rbuf(rcompdof_sz))
  allocate(exp_val(rcompdof_sz))
   ! pio_decomp_fillval.F90.in:330
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! We only read 1 value on rank0, 2 values on rank1, ...
  do i=1,rcompdof_sz
    rcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Write everything - we only read some of these values
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = wcompdof
   ! pio_decomp_fillval.F90.in:342
  rbuf = BUF_FILLVAL
  do i=1,rcompdof_sz
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_fillval.F90.in:347
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:350
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:357)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:358
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:360)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:361
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:363)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:364
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:366)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:367
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:369)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:370
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:372
    ! Read only part of the written data
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:375)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:376
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:378
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:386
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(rcompdof)
END SUBROUTINE nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___


SUBROUTINE nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  integer, parameter :: VEC_LOCAL_SZ = 7
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wiodesc, riodesc
  integer, dimension(:), allocatable :: rcompdof
  integer :: rcompdof_sz
  integer, dimension(VEC_LOCAL_SZ) :: wcompdof, compdof_rel_disps
  real(kind=fc_double), dimension(:), allocatable :: rbuf, exp_val
  real(kind=fc_double), dimension(VEC_LOCAL_SZ) :: wbuf
  integer, parameter :: BUF_FILLVAL = -2
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_fillval.F90.in:323
  ! compdof is only specified for valid data values, the data holes are
  ! implicitly stated (by not specifying them rather than filling it with 0s)
  rcompdof_sz = min(pio_tf_world_rank_+1, VEC_LOCAL_SZ)
  allocate(rcompdof(rcompdof_sz))
  allocate(rbuf(rcompdof_sz))
  allocate(exp_val(rcompdof_sz))
   ! pio_decomp_fillval.F90.in:330
  do i=1,VEC_LOCAL_SZ
    compdof_rel_disps(i) = i
  end do
  dims(1) = VEC_LOCAL_SZ * pio_tf_world_sz_
  ! We only read 1 value on rank0, 2 values on rank1, ...
  do i=1,rcompdof_sz
    rcompdof(i) = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps(i)
  end do
  ! Write everything - we only read some of these values
  wcompdof = VEC_LOCAL_SZ * pio_tf_world_rank_ + compdof_rel_disps
  wbuf = wcompdof
   ! pio_decomp_fillval.F90.in:342
  rbuf = BUF_FILLVAL
  do i=1,rcompdof_sz
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_fillval.F90.in:347
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, wcompdof, wiodesc)
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, rcompdof, riodesc)
   ! pio_decomp_fillval.F90.in:350
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_fillval_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:357)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:358
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:360)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:361
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:363)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:364
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:366)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:367
    call PIO_write_darray(pio_file, pio_var, wiodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:369)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:370
    call PIO_syncfile(pio_file)
   ! pio_decomp_fillval.F90.in:372
    ! Read only part of the written data
    call PIO_read_darray(pio_file, pio_var, riodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:375)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:376
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_fillval.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_fillval.F90.in:378
    call PIO_closefile(pio_file)
    call PIO_deletefile(pio_tf_iosystem_, filename)
  end do
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_fillval.F90.in:386
  call PIO_freedecomp(pio_tf_iosystem_, riodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wiodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(rcompdof)
END SUBROUTINE nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___
   ! pio_decomp_fillval.F90.in:392


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 13:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 13:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 14:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 14:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 15:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 15:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 16:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 16:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 17:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 17:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 18:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 18:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 19:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 19:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 20:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 20:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 21:",&
          "nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 21:",&
          "nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 22:",&
          "nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 22:",&
          "nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 23:",&
          "nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 23:",&
          "nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 24:",&
          "nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 24:",&
          "nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 25:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 25:",&
          "nc_write_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 26:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 26:",&
          "nc_write_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 27:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 27:",&
          "nc_write_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 28:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 28:",&
          "nc_write_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 29:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 29:",&
          "nc_write_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 30:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 30:",&
          "nc_write_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 31:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 31:",&
          "nc_write_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 32:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 32:",&
          "nc_write_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 33:",&
          "nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 33:",&
          "nc_read_1d_explicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 34:",&
          "nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 34:",&
          "nc_read_1d_explicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 35:",&
          "nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 35:",&
          "nc_read_1d_explicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 36:",&
          "nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 36:",&
          "nc_read_1d_explicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 37:",&
          "nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 37:",&
          "nc_read_1d_implicit_fval_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 38:",&
          "nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 38:",&
          "nc_read_1d_implicit_fval_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 39:",&
          "nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 39:",&
          "nc_read_1d_implicit_fval_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 40:",&
          "nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 40:",&
          "nc_read_1d_implicit_fval_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
