! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_decomp_frame_tests.F90.in

#include "config.h"
! Get a 3D column decomposition
! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_HGT_SZ blocks of 
! (VEC_COL_SZ rows x VEC_ROW_SZ columns) elements
! # All odd procs have  VEC_HGT_SZ blocks of
! (VEC_COL_SZ rows x VEC_ROW_SZ + 1 columns) elements
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2, VEC_HGT_SZ = 2
! and ranks 0, 1, 2,
! e.g. 1) |(1,1,1) (1,2,1) (2,1,1) (2,2,1)|
!         |(1,1,2) (1,2,2) (2,1,2) (2,2,2)| ,
!         |(1,3,1) (1,4,1) (1,5,1) (2,3,1) (2,4,1) (2,5,1)|
!         |(1,3,2) (1,4,2) (1,5,2) (2,3,2) (2,4,2) (2,5,2)|,
!         |(1,6,1) (1,7,1) (2,6,1) (2,7,1)|
!         |(1,6,2) (1,7,2) (2,6,2) (2,7,2)|
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2, VEC_HGT_SZ = 2
! and ranks 0, 1, 2,
! e.g. 1  |(1,3,1) (1,4,1) (1,5,1) (2,3,1) (2,4,1) (2,5,1)|
!         |(1,3,2) (1,4,2) (1,5,2) (2,3,2) (2,4,2) (2,5,2)|,
!         |(1,1,1) (1,2,1) (2,1,1) (2,2,1)|
!         |(1,1,2) (1,2,2) (2,1,2) (2,2,2)| ,
!         |(1,6,1) (1,7,1) (2,6,1) (2,7,1)|
!         |(1,6,2) (1,7,2) (2,6,2) (2,7,2)|
! This for example can be used to force rearrangement when reading
! or writing data.
SUBROUTINE get_3d_col_decomp_info(rank, sz, dims, start, count, force_rearrange)   ! pio_decomp_frame_tests.F90.in:29
  integer, parameter :: VEC_ROW_SZ = 2   ! pio_decomp_frame_tests.F90.in:30
  integer, parameter :: VEC_COL_SZ = 2   ! pio_decomp_frame_tests.F90.in:31
  integer, parameter :: VEC_HGT_SZ = 2   ! pio_decomp_frame_tests.F90.in:32
  integer, parameter :: NDIMS = 3   ! pio_decomp_frame_tests.F90.in:33
  integer, intent(in) :: rank   ! pio_decomp_frame_tests.F90.in:34
  integer, intent(in) :: sz   ! pio_decomp_frame_tests.F90.in:35
  integer, dimension(NDIMS), intent(out) :: dims   ! pio_decomp_frame_tests.F90.in:36
  integer, dimension(NDIMS), intent(out) :: start   ! pio_decomp_frame_tests.F90.in:37
  integer, dimension(NDIMS), intent(out) :: count   ! pio_decomp_frame_tests.F90.in:38
  logical, intent(in) :: force_rearrange   ! pio_decomp_frame_tests.F90.in:39


  logical :: is_even_rank   ! pio_decomp_frame_tests.F90.in:41
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_frame_tests.F90.in:42
  integer :: iodd, ieven   ! pio_decomp_frame_tests.F90.in:43


  is_even_rank = .false.   ! pio_decomp_frame_tests.F90.in:45
  if (mod(rank, 2) == 0) then   ! pio_decomp_frame_tests.F90.in:46
    is_even_rank = .true.   ! pio_decomp_frame_tests.F90.in:47
  end if   ! pio_decomp_frame_tests.F90.in:48
  num_odd_procs = sz / 2   ! pio_decomp_frame_tests.F90.in:49
  num_even_procs = sz - num_odd_procs   ! pio_decomp_frame_tests.F90.in:50
  dims(1) = VEC_COL_SZ   ! pio_decomp_frame_tests.F90.in:51
  dims(2) = num_even_procs * VEC_ROW_SZ + num_odd_procs * (VEC_ROW_SZ + 1)   ! pio_decomp_frame_tests.F90.in:52
  dims(3) = VEC_HGT_SZ   ! pio_decomp_frame_tests.F90.in:53
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_frame_tests.F90.in:55
  ieven = (rank + 1) / 2   ! pio_decomp_frame_tests.F90.in:56


  ! Rows
  start(1) = 1   ! pio_decomp_frame_tests.F90.in:59
  count(1) = VEC_COL_SZ   ! pio_decomp_frame_tests.F90.in:60


  ! Columns
  if(force_rearrange) then   ! pio_decomp_frame_tests.F90.in:63
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_decomp_frame_tests.F90.in:65
      if(rank + 1 < sz) then   ! pio_decomp_frame_tests.F90.in:66
        ! Force rearrangement
        count(2) = VEC_ROW_SZ + 1   ! pio_decomp_frame_tests.F90.in:68
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + (VEC_ROW_SZ) + 1   ! pio_decomp_frame_tests.F90.in:69
      else   ! pio_decomp_frame_tests.F90.in:70
        count(2) = VEC_ROW_SZ   ! pio_decomp_frame_tests.F90.in:71
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_frame_tests.F90.in:72
      end if   ! pio_decomp_frame_tests.F90.in:73
    else   ! pio_decomp_frame_tests.F90.in:74
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(2) = VEC_ROW_SZ   ! pio_decomp_frame_tests.F90.in:77
      start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) - (VEC_ROW_SZ) + 1   ! pio_decomp_frame_tests.F90.in:78
    end if   ! pio_decomp_frame_tests.F90.in:79
  else   ! pio_decomp_frame_tests.F90.in:80
    if (is_even_rank) then   ! pio_decomp_frame_tests.F90.in:81
      count(2) = VEC_ROW_SZ   ! pio_decomp_frame_tests.F90.in:82
    else   ! pio_decomp_frame_tests.F90.in:83
      count(2) = VEC_ROW_SZ + 1   ! pio_decomp_frame_tests.F90.in:84
    end if   ! pio_decomp_frame_tests.F90.in:85
    start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_frame_tests.F90.in:86
  end if   ! pio_decomp_frame_tests.F90.in:87


  ! Height
  start(3) = 1   ! pio_decomp_frame_tests.F90.in:90
  count(3) = VEC_HGT_SZ   ! pio_decomp_frame_tests.F90.in:91
END SUBROUTINE   ! pio_decomp_frame_tests.F90.in:92


! Write with one decomp (to force rearrangement) and read with another (no
! rearrangement)


SUBROUTINE nc_write_read_4d_col_decomp_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:97
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:98


  implicit none   ! pio_decomp_frame_tests.F90.in:100
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:101
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:102
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:103
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:104
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:105
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:106
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:107
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:108
  integer, dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:109
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:110
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:111
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:112
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:113
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:115
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:116
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:117
   ! pio_decomp_frame_tests.F90.in:115
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:120
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:121
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:122
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:123


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:125
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:126
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:127
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:128
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:129
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:130
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:132
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:133
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:134
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:135
        end do   ! pio_decomp_frame_tests.F90.in:136
      end do   ! pio_decomp_frame_tests.F90.in:137
    end do   ! pio_decomp_frame_tests.F90.in:138
  end do   ! pio_decomp_frame_tests.F90.in:139
   ! pio_decomp_frame_tests.F90.in:137
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:141
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:142
   ! pio_decomp_frame_tests.F90.in:140
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:145
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:146
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:147
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:148


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:150
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:151
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:152
   ! pio_decomp_frame_tests.F90.in:150
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:154
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:155
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:156
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:157
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:158
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:160
          exp_val(i,j,k,f) = compdof(tmp_idx) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:161
        end do   ! pio_decomp_frame_tests.F90.in:162
      end do   ! pio_decomp_frame_tests.F90.in:163
    end do   ! pio_decomp_frame_tests.F90.in:164
  end do   ! pio_decomp_frame_tests.F90.in:165
   ! pio_decomp_frame_tests.F90.in:163
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:167
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:168
   ! pio_decomp_frame_tests.F90.in:166
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:170
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:171
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:172
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:173


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:175
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:176
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:177
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:178
      END IF   ! pio_decomp_frame_tests.F90.in:179
    END IF   ! pio_decomp_frame_tests.F90.in:180
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:181


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:183
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:184
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:185
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:173)"   ! pio_decomp_frame_tests.F90.in:189
      END IF   ! pio_decomp_frame_tests.F90.in:190
      RETURN   ! pio_decomp_frame_tests.F90.in:191
    END IF   ! pio_decomp_frame_tests.F90.in:192
   ! pio_decomp_frame_tests.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:194


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:196
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:197
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:198
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:176)"   ! pio_decomp_frame_tests.F90.in:202
      END IF   ! pio_decomp_frame_tests.F90.in:203
      RETURN   ! pio_decomp_frame_tests.F90.in:204
    END IF   ! pio_decomp_frame_tests.F90.in:205
   ! pio_decomp_frame_tests.F90.in:177
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:207


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:209
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:210
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:211
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:179)"   ! pio_decomp_frame_tests.F90.in:215
      END IF   ! pio_decomp_frame_tests.F90.in:216
      RETURN   ! pio_decomp_frame_tests.F90.in:217
    END IF   ! pio_decomp_frame_tests.F90.in:218
   ! pio_decomp_frame_tests.F90.in:180
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:220


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:222
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:223
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:224
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:182)"   ! pio_decomp_frame_tests.F90.in:228
      END IF   ! pio_decomp_frame_tests.F90.in:229
      RETURN   ! pio_decomp_frame_tests.F90.in:230
    END IF   ! pio_decomp_frame_tests.F90.in:231
   ! pio_decomp_frame_tests.F90.in:183
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:233


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:235
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:236
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:237
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:185)"   ! pio_decomp_frame_tests.F90.in:241
      END IF   ! pio_decomp_frame_tests.F90.in:242
      RETURN   ! pio_decomp_frame_tests.F90.in:243
    END IF   ! pio_decomp_frame_tests.F90.in:244
   ! pio_decomp_frame_tests.F90.in:186
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:246


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:248
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:249
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:250
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:188)"   ! pio_decomp_frame_tests.F90.in:254
      END IF   ! pio_decomp_frame_tests.F90.in:255
      RETURN   ! pio_decomp_frame_tests.F90.in:256
    END IF   ! pio_decomp_frame_tests.F90.in:257
   ! pio_decomp_frame_tests.F90.in:189
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:259


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:261
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:262
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:263
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:191)"   ! pio_decomp_frame_tests.F90.in:267
      END IF   ! pio_decomp_frame_tests.F90.in:268
      RETURN   ! pio_decomp_frame_tests.F90.in:269
    END IF   ! pio_decomp_frame_tests.F90.in:270
   ! pio_decomp_frame_tests.F90.in:192
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:272
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:273
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:275


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:277
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:278
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:279
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:197)"   ! pio_decomp_frame_tests.F90.in:283
        END IF   ! pio_decomp_frame_tests.F90.in:284
        RETURN   ! pio_decomp_frame_tests.F90.in:285
      END IF   ! pio_decomp_frame_tests.F90.in:286
    end do   ! pio_decomp_frame_tests.F90.in:287
   ! pio_decomp_frame_tests.F90.in:199
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:289
   ! pio_decomp_frame_tests.F90.in:201
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:291
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:292
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:293


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:295
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:296
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:297
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:205)"   ! pio_decomp_frame_tests.F90.in:301
        END IF   ! pio_decomp_frame_tests.F90.in:302
        RETURN   ! pio_decomp_frame_tests.F90.in:303
      END IF   ! pio_decomp_frame_tests.F90.in:304
    end do   ! pio_decomp_frame_tests.F90.in:305
   ! pio_decomp_frame_tests.F90.in:207
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:307


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:309
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:310
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:311
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:209)"   ! pio_decomp_frame_tests.F90.in:315
        END IF   ! pio_decomp_frame_tests.F90.in:316
        RETURN   ! pio_decomp_frame_tests.F90.in:317
      END IF   ! pio_decomp_frame_tests.F90.in:318
    end do   ! pio_decomp_frame_tests.F90.in:319
   ! pio_decomp_frame_tests.F90.in:211
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:321


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:323
  end do   ! pio_decomp_frame_tests.F90.in:324
   ! pio_decomp_frame_tests.F90.in:216
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:326
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:327
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:328
  end if   ! pio_decomp_frame_tests.F90.in:329
   ! pio_decomp_frame_tests.F90.in:221
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:331
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:332
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:333
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:334
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:335
END SUBROUTINE nc_write_read_4d_col_decomp_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:336




SUBROUTINE nc_write_read_4d_col_decomp_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:339
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:340


  implicit none   ! pio_decomp_frame_tests.F90.in:342
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:343
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:344
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:345
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:346
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:347
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:348
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:349
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:350
  real(kind=fc_real), dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:351
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:352
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:353
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:354
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:355
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:357
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:358
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:359
   ! pio_decomp_frame_tests.F90.in:115
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:362
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:363
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:364
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:365


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:367
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:368
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:369
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:370
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:371
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:372
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:374
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:375
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:376
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:377
        end do   ! pio_decomp_frame_tests.F90.in:378
      end do   ! pio_decomp_frame_tests.F90.in:379
    end do   ! pio_decomp_frame_tests.F90.in:380
  end do   ! pio_decomp_frame_tests.F90.in:381
   ! pio_decomp_frame_tests.F90.in:137
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:383
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:384
   ! pio_decomp_frame_tests.F90.in:140
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:387
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:388
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:389
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:390


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:392
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:393
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:394
   ! pio_decomp_frame_tests.F90.in:150
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:396
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:397
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:398
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:399
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:400
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:402
          exp_val(i,j,k,f) = compdof(tmp_idx) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:403
        end do   ! pio_decomp_frame_tests.F90.in:404
      end do   ! pio_decomp_frame_tests.F90.in:405
    end do   ! pio_decomp_frame_tests.F90.in:406
  end do   ! pio_decomp_frame_tests.F90.in:407
   ! pio_decomp_frame_tests.F90.in:163
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:409
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:410
   ! pio_decomp_frame_tests.F90.in:166
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:412
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:413
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:414
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:415


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:417
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:418
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:419
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:420
      END IF   ! pio_decomp_frame_tests.F90.in:421
    END IF   ! pio_decomp_frame_tests.F90.in:422
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:423


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:425
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:426
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:427
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:173)"   ! pio_decomp_frame_tests.F90.in:431
      END IF   ! pio_decomp_frame_tests.F90.in:432
      RETURN   ! pio_decomp_frame_tests.F90.in:433
    END IF   ! pio_decomp_frame_tests.F90.in:434
   ! pio_decomp_frame_tests.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:436


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:438
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:439
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:440
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:176)"   ! pio_decomp_frame_tests.F90.in:444
      END IF   ! pio_decomp_frame_tests.F90.in:445
      RETURN   ! pio_decomp_frame_tests.F90.in:446
    END IF   ! pio_decomp_frame_tests.F90.in:447
   ! pio_decomp_frame_tests.F90.in:177
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:449


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:451
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:452
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:453
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:179)"   ! pio_decomp_frame_tests.F90.in:457
      END IF   ! pio_decomp_frame_tests.F90.in:458
      RETURN   ! pio_decomp_frame_tests.F90.in:459
    END IF   ! pio_decomp_frame_tests.F90.in:460
   ! pio_decomp_frame_tests.F90.in:180
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:462


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:464
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:465
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:466
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:182)"   ! pio_decomp_frame_tests.F90.in:470
      END IF   ! pio_decomp_frame_tests.F90.in:471
      RETURN   ! pio_decomp_frame_tests.F90.in:472
    END IF   ! pio_decomp_frame_tests.F90.in:473
   ! pio_decomp_frame_tests.F90.in:183
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:475


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:477
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:478
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:479
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:185)"   ! pio_decomp_frame_tests.F90.in:483
      END IF   ! pio_decomp_frame_tests.F90.in:484
      RETURN   ! pio_decomp_frame_tests.F90.in:485
    END IF   ! pio_decomp_frame_tests.F90.in:486
   ! pio_decomp_frame_tests.F90.in:186
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:488


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:490
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:491
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:492
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:188)"   ! pio_decomp_frame_tests.F90.in:496
      END IF   ! pio_decomp_frame_tests.F90.in:497
      RETURN   ! pio_decomp_frame_tests.F90.in:498
    END IF   ! pio_decomp_frame_tests.F90.in:499
   ! pio_decomp_frame_tests.F90.in:189
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:501


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:503
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:504
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:505
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:191)"   ! pio_decomp_frame_tests.F90.in:509
      END IF   ! pio_decomp_frame_tests.F90.in:510
      RETURN   ! pio_decomp_frame_tests.F90.in:511
    END IF   ! pio_decomp_frame_tests.F90.in:512
   ! pio_decomp_frame_tests.F90.in:192
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:514
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:515
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:517


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:519
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:520
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:521
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:197)"   ! pio_decomp_frame_tests.F90.in:525
        END IF   ! pio_decomp_frame_tests.F90.in:526
        RETURN   ! pio_decomp_frame_tests.F90.in:527
      END IF   ! pio_decomp_frame_tests.F90.in:528
    end do   ! pio_decomp_frame_tests.F90.in:529
   ! pio_decomp_frame_tests.F90.in:199
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:531
   ! pio_decomp_frame_tests.F90.in:201
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:533
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:534
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:535


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:537
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:538
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:539
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:205)"   ! pio_decomp_frame_tests.F90.in:543
        END IF   ! pio_decomp_frame_tests.F90.in:544
        RETURN   ! pio_decomp_frame_tests.F90.in:545
      END IF   ! pio_decomp_frame_tests.F90.in:546
    end do   ! pio_decomp_frame_tests.F90.in:547
   ! pio_decomp_frame_tests.F90.in:207
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:549


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:551
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:552
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:553
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:209)"   ! pio_decomp_frame_tests.F90.in:557
        END IF   ! pio_decomp_frame_tests.F90.in:558
        RETURN   ! pio_decomp_frame_tests.F90.in:559
      END IF   ! pio_decomp_frame_tests.F90.in:560
    end do   ! pio_decomp_frame_tests.F90.in:561
   ! pio_decomp_frame_tests.F90.in:211
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:563


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:565
  end do   ! pio_decomp_frame_tests.F90.in:566
   ! pio_decomp_frame_tests.F90.in:216
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:568
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:569
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:570
  end if   ! pio_decomp_frame_tests.F90.in:571
   ! pio_decomp_frame_tests.F90.in:221
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:573
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:574
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:575
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:576
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:577
END SUBROUTINE nc_write_read_4d_col_decomp_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:578




SUBROUTINE nc_write_read_4d_col_decomp_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:581
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:582


  implicit none   ! pio_decomp_frame_tests.F90.in:584
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:585
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:586
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:587
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:588
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:589
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:590
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:591
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:592
  real(kind=fc_double), dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:593
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:594
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:595
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:596
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:597
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:599
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:600
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:601
   ! pio_decomp_frame_tests.F90.in:115
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:604
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:605
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:606
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:607


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:609
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:610
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:611
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:612
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:613
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:614
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:616
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + (f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:617
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:618
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:619
        end do   ! pio_decomp_frame_tests.F90.in:620
      end do   ! pio_decomp_frame_tests.F90.in:621
    end do   ! pio_decomp_frame_tests.F90.in:622
  end do   ! pio_decomp_frame_tests.F90.in:623
   ! pio_decomp_frame_tests.F90.in:137
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:625
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:626
   ! pio_decomp_frame_tests.F90.in:140
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:629
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:630
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:631
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:632


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:634
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:635
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:636
   ! pio_decomp_frame_tests.F90.in:150
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:638
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:639
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:640
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:641
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:642
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:644
          exp_val(i,j,k,f) = compdof(tmp_idx) + (f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:645
        end do   ! pio_decomp_frame_tests.F90.in:646
      end do   ! pio_decomp_frame_tests.F90.in:647
    end do   ! pio_decomp_frame_tests.F90.in:648
  end do   ! pio_decomp_frame_tests.F90.in:649
   ! pio_decomp_frame_tests.F90.in:163
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:651
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:652
   ! pio_decomp_frame_tests.F90.in:166
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:654
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:655
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:656
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:657


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:659
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:660
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:661
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:662
      END IF   ! pio_decomp_frame_tests.F90.in:663
    END IF   ! pio_decomp_frame_tests.F90.in:664
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:665


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:667
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:668
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:669
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:173)"   ! pio_decomp_frame_tests.F90.in:673
      END IF   ! pio_decomp_frame_tests.F90.in:674
      RETURN   ! pio_decomp_frame_tests.F90.in:675
    END IF   ! pio_decomp_frame_tests.F90.in:676
   ! pio_decomp_frame_tests.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:678


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:680
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:681
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:682
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:176)"   ! pio_decomp_frame_tests.F90.in:686
      END IF   ! pio_decomp_frame_tests.F90.in:687
      RETURN   ! pio_decomp_frame_tests.F90.in:688
    END IF   ! pio_decomp_frame_tests.F90.in:689
   ! pio_decomp_frame_tests.F90.in:177
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:691


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:693
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:694
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:695
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:179)"   ! pio_decomp_frame_tests.F90.in:699
      END IF   ! pio_decomp_frame_tests.F90.in:700
      RETURN   ! pio_decomp_frame_tests.F90.in:701
    END IF   ! pio_decomp_frame_tests.F90.in:702
   ! pio_decomp_frame_tests.F90.in:180
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:704


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:706
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:707
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:708
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:182)"   ! pio_decomp_frame_tests.F90.in:712
      END IF   ! pio_decomp_frame_tests.F90.in:713
      RETURN   ! pio_decomp_frame_tests.F90.in:714
    END IF   ! pio_decomp_frame_tests.F90.in:715
   ! pio_decomp_frame_tests.F90.in:183
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:717


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:719
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:720
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:721
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:185)"   ! pio_decomp_frame_tests.F90.in:725
      END IF   ! pio_decomp_frame_tests.F90.in:726
      RETURN   ! pio_decomp_frame_tests.F90.in:727
    END IF   ! pio_decomp_frame_tests.F90.in:728
   ! pio_decomp_frame_tests.F90.in:186
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:730


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:732
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:733
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:734
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:188)"   ! pio_decomp_frame_tests.F90.in:738
      END IF   ! pio_decomp_frame_tests.F90.in:739
      RETURN   ! pio_decomp_frame_tests.F90.in:740
    END IF   ! pio_decomp_frame_tests.F90.in:741
   ! pio_decomp_frame_tests.F90.in:189
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:743


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:745
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:746
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:747
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:191)"   ! pio_decomp_frame_tests.F90.in:751
      END IF   ! pio_decomp_frame_tests.F90.in:752
      RETURN   ! pio_decomp_frame_tests.F90.in:753
    END IF   ! pio_decomp_frame_tests.F90.in:754
   ! pio_decomp_frame_tests.F90.in:192
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:756
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:757
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:759


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:761
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:762
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:763
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:197)"   ! pio_decomp_frame_tests.F90.in:767
        END IF   ! pio_decomp_frame_tests.F90.in:768
        RETURN   ! pio_decomp_frame_tests.F90.in:769
      END IF   ! pio_decomp_frame_tests.F90.in:770
    end do   ! pio_decomp_frame_tests.F90.in:771
   ! pio_decomp_frame_tests.F90.in:199
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:773
   ! pio_decomp_frame_tests.F90.in:201
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:775
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:776
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:777


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:779
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:780
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:781
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:205)"   ! pio_decomp_frame_tests.F90.in:785
        END IF   ! pio_decomp_frame_tests.F90.in:786
        RETURN   ! pio_decomp_frame_tests.F90.in:787
      END IF   ! pio_decomp_frame_tests.F90.in:788
    end do   ! pio_decomp_frame_tests.F90.in:789
   ! pio_decomp_frame_tests.F90.in:207
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:791


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:793
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:794
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:795
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:209)"   ! pio_decomp_frame_tests.F90.in:799
        END IF   ! pio_decomp_frame_tests.F90.in:800
        RETURN   ! pio_decomp_frame_tests.F90.in:801
      END IF   ! pio_decomp_frame_tests.F90.in:802
    end do   ! pio_decomp_frame_tests.F90.in:803
   ! pio_decomp_frame_tests.F90.in:211
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:805


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:807
  end do   ! pio_decomp_frame_tests.F90.in:808
   ! pio_decomp_frame_tests.F90.in:216
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:810
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:811
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:812
  end if   ! pio_decomp_frame_tests.F90.in:813
   ! pio_decomp_frame_tests.F90.in:221
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:815
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:816
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:817
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:818
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:819
END SUBROUTINE nc_write_read_4d_col_decomp_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:820
   ! pio_decomp_frame_tests.F90.in:227


! Using a 3d decomp for writing out a 3d and a 4d var
! Write with one decomp (to force rearrangement) and read with another (no
! rearrangement)


SUBROUTINE nc_reuse_3d_decomp_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:827
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:828


  implicit none   ! pio_decomp_frame_tests.F90.in:830
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:831
  integer, parameter :: NFRAMES = 3   ! pio_decomp_frame_tests.F90.in:832
  type(var_desc_t)  :: pio_var3d, pio_var4d   ! pio_decomp_frame_tests.F90.in:833
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:834
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:835
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:836
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:837
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:838
  integer, dimension(:,:,:,:), allocatable :: rbuf4d, wbuf4d, exp_val4d   ! pio_decomp_frame_tests.F90.in:839
  integer, dimension(:,:,:), allocatable :: rbuf3d, wbuf3d, exp_val3d   ! pio_decomp_frame_tests.F90.in:840
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:841
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:842
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:843
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:844
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:846
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:847
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:848
   ! pio_decomp_frame_tests.F90.in:846
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:851
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:852
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:853
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:854


  ! Initialize the 4d var
  allocate(wbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:857
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:858
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:859
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:860
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:861
          wbuf4d(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:863
          wbuf4d(i,j,k,f) = wbuf4d(i,j,k,f) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:864
        end do   ! pio_decomp_frame_tests.F90.in:865
      end do   ! pio_decomp_frame_tests.F90.in:866
    end do   ! pio_decomp_frame_tests.F90.in:867
  end do   ! pio_decomp_frame_tests.F90.in:868
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:869
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:870
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:871
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:872
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:873
        compdof(tmp_idx) = int(wbuf4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:874
      end do   ! pio_decomp_frame_tests.F90.in:875
    end do   ! pio_decomp_frame_tests.F90.in:876
  end do   ! pio_decomp_frame_tests.F90.in:877
  ! Initialize the 3d var
  allocate(wbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:879
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:880
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:881
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:882
        wbuf3d(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:884
      end do   ! pio_decomp_frame_tests.F90.in:885
    end do   ! pio_decomp_frame_tests.F90.in:886
  end do   ! pio_decomp_frame_tests.F90.in:887
   ! pio_decomp_frame_tests.F90.in:885
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:889
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:890
   ! pio_decomp_frame_tests.F90.in:888
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:893
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:894
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:895
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:896


  allocate(rbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:898
  rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:899
  ! Expected val for 4d var
  allocate(exp_val4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:901
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:902
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:903
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:904
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:905
          exp_val4d(i,j,k,f) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:907
          exp_val4d(i,j,k,f) = exp_val4d(i,j,k,f) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:908
        end do   ! pio_decomp_frame_tests.F90.in:909
      end do   ! pio_decomp_frame_tests.F90.in:910
    end do   ! pio_decomp_frame_tests.F90.in:911
  end do   ! pio_decomp_frame_tests.F90.in:912
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:913
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:914
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:915
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:916
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:917
        compdof(tmp_idx) = int(exp_val4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:918
      end do   ! pio_decomp_frame_tests.F90.in:919
    end do   ! pio_decomp_frame_tests.F90.in:920
  end do   ! pio_decomp_frame_tests.F90.in:921
   ! pio_decomp_frame_tests.F90.in:919
  allocate(rbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:923
  rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:924
  ! Expected val for 3d var
  allocate(exp_val3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:926
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:927
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:928
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:929
        exp_val3d(i,j,k) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:931
      end do   ! pio_decomp_frame_tests.F90.in:932
    end do   ! pio_decomp_frame_tests.F90.in:933
  end do   ! pio_decomp_frame_tests.F90.in:934
   ! pio_decomp_frame_tests.F90.in:932
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:936
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:937
   ! pio_decomp_frame_tests.F90.in:935
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:939
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:940
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:941
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:942


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:944
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:945
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:946
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:947
      END IF   ! pio_decomp_frame_tests.F90.in:948
    END IF   ! pio_decomp_frame_tests.F90.in:949
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:950


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:952
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:953
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:954
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:942)"   ! pio_decomp_frame_tests.F90.in:958
      END IF   ! pio_decomp_frame_tests.F90.in:959
      RETURN   ! pio_decomp_frame_tests.F90.in:960
    END IF   ! pio_decomp_frame_tests.F90.in:961
   ! pio_decomp_frame_tests.F90.in:943
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:963


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:965
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:966
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:967
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:945)"   ! pio_decomp_frame_tests.F90.in:971
      END IF   ! pio_decomp_frame_tests.F90.in:972
      RETURN   ! pio_decomp_frame_tests.F90.in:973
    END IF   ! pio_decomp_frame_tests.F90.in:974
   ! pio_decomp_frame_tests.F90.in:946
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:976


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:978
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:979
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:980
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:948)"   ! pio_decomp_frame_tests.F90.in:984
      END IF   ! pio_decomp_frame_tests.F90.in:985
      RETURN   ! pio_decomp_frame_tests.F90.in:986
    END IF   ! pio_decomp_frame_tests.F90.in:987
   ! pio_decomp_frame_tests.F90.in:949
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:989


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:991
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:992
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:993
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:951)"   ! pio_decomp_frame_tests.F90.in:997
      END IF   ! pio_decomp_frame_tests.F90.in:998
      RETURN   ! pio_decomp_frame_tests.F90.in:999
    END IF   ! pio_decomp_frame_tests.F90.in:1000
   ! pio_decomp_frame_tests.F90.in:952
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:1002


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1004
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1005
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1006
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:954)"   ! pio_decomp_frame_tests.F90.in:1010
      END IF   ! pio_decomp_frame_tests.F90.in:1011
      RETURN   ! pio_decomp_frame_tests.F90.in:1012
    END IF   ! pio_decomp_frame_tests.F90.in:1013
   ! pio_decomp_frame_tests.F90.in:955
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_3d_var', PIO_int, pio_dims(1:3), pio_var3d)   ! pio_decomp_frame_tests.F90.in:1015


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1017
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1018
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1019
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 3d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:957)"   ! pio_decomp_frame_tests.F90.in:1023
      END IF   ! pio_decomp_frame_tests.F90.in:1024
      RETURN   ! pio_decomp_frame_tests.F90.in:1025
    END IF   ! pio_decomp_frame_tests.F90.in:1026
   ! pio_decomp_frame_tests.F90.in:958
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_4d_var', PIO_int, pio_dims, pio_var4d)   ! pio_decomp_frame_tests.F90.in:1028


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1030
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1031
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1032
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 4d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:960)"   ! pio_decomp_frame_tests.F90.in:1036
      END IF   ! pio_decomp_frame_tests.F90.in:1037
      RETURN   ! pio_decomp_frame_tests.F90.in:1038
    END IF   ! pio_decomp_frame_tests.F90.in:1039
   ! pio_decomp_frame_tests.F90.in:961
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:1041


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1043
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1044
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1045
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:963)"   ! pio_decomp_frame_tests.F90.in:1049
      END IF   ! pio_decomp_frame_tests.F90.in:1050
      RETURN   ! pio_decomp_frame_tests.F90.in:1051
    END IF   ! pio_decomp_frame_tests.F90.in:1052
   ! pio_decomp_frame_tests.F90.in:964
    call PIO_write_darray(pio_file, pio_var3d, wr_iodesc, wbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1054


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1056
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1057
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1058
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:966)"   ! pio_decomp_frame_tests.F90.in:1062
      END IF   ! pio_decomp_frame_tests.F90.in:1063
      RETURN   ! pio_decomp_frame_tests.F90.in:1064
    END IF   ! pio_decomp_frame_tests.F90.in:1065
   ! pio_decomp_frame_tests.F90.in:967
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1067
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1068
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var4d, wr_iodesc, wbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1070


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1072
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1073
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1074
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:972)"   ! pio_decomp_frame_tests.F90.in:1078
        END IF   ! pio_decomp_frame_tests.F90.in:1079
        RETURN   ! pio_decomp_frame_tests.F90.in:1080
      END IF   ! pio_decomp_frame_tests.F90.in:1081
    end do   ! pio_decomp_frame_tests.F90.in:1082
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:1083
   ! pio_decomp_frame_tests.F90.in:975
    rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:1085
    rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:1086
   ! pio_decomp_frame_tests.F90.in:978
    call PIO_read_darray(pio_file, pio_var3d, rd_iodesc, rbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1088


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1090
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1091
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1092
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:980)"   ! pio_decomp_frame_tests.F90.in:1096
      END IF   ! pio_decomp_frame_tests.F90.in:1097
      RETURN   ! pio_decomp_frame_tests.F90.in:1098
    END IF   ! pio_decomp_frame_tests.F90.in:1099
   ! pio_decomp_frame_tests.F90.in:981
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1101
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1102
      call PIO_read_darray(pio_file, pio_var4d, rd_iodesc, rbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1103


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1105
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1106
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1107
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:985)"   ! pio_decomp_frame_tests.F90.in:1111
        END IF   ! pio_decomp_frame_tests.F90.in:1112
        RETURN   ! pio_decomp_frame_tests.F90.in:1113
      END IF   ! pio_decomp_frame_tests.F90.in:1114
    end do   ! pio_decomp_frame_tests.F90.in:1115
   ! pio_decomp_frame_tests.F90.in:987
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1117


      IF (.NOT. PIO_TF_Check_val_(rbuf4d(:,:,:,f), exp_val4d(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:1119
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1120
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1121
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong 4d val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:989)"   ! pio_decomp_frame_tests.F90.in:1125
        END IF   ! pio_decomp_frame_tests.F90.in:1126
        RETURN   ! pio_decomp_frame_tests.F90.in:1127
      END IF   ! pio_decomp_frame_tests.F90.in:1128
    end do   ! pio_decomp_frame_tests.F90.in:1129


    IF (.NOT. PIO_TF_Check_val_(rbuf3d, exp_val3d)) THEN   ! pio_decomp_frame_tests.F90.in:1131
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1132
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1133
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong 3dd val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:991)"   ! pio_decomp_frame_tests.F90.in:1137
      END IF   ! pio_decomp_frame_tests.F90.in:1138
      RETURN   ! pio_decomp_frame_tests.F90.in:1139
    END IF   ! pio_decomp_frame_tests.F90.in:1140
   ! pio_decomp_frame_tests.F90.in:992
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:1142


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:1144
  end do   ! pio_decomp_frame_tests.F90.in:1145
   ! pio_decomp_frame_tests.F90.in:997
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:1147
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:1148
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:1149
  end if   ! pio_decomp_frame_tests.F90.in:1150
   ! pio_decomp_frame_tests.F90.in:1002
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1152
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1153
   ! pio_decomp_frame_tests.F90.in:1005
  deallocate(exp_val3d)   ! pio_decomp_frame_tests.F90.in:1155
  deallocate(rbuf3d)   ! pio_decomp_frame_tests.F90.in:1156
  deallocate(wbuf3d)   ! pio_decomp_frame_tests.F90.in:1157
   ! pio_decomp_frame_tests.F90.in:1009
  deallocate(exp_val4d)   ! pio_decomp_frame_tests.F90.in:1159
  deallocate(rbuf4d)   ! pio_decomp_frame_tests.F90.in:1160
  deallocate(wbuf4d)   ! pio_decomp_frame_tests.F90.in:1161
END SUBROUTINE nc_reuse_3d_decomp_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:1162




SUBROUTINE nc_reuse_3d_decomp_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:1165
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:1166


  implicit none   ! pio_decomp_frame_tests.F90.in:1168
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:1169
  integer, parameter :: NFRAMES = 3   ! pio_decomp_frame_tests.F90.in:1170
  type(var_desc_t)  :: pio_var3d, pio_var4d   ! pio_decomp_frame_tests.F90.in:1171
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:1172
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:1173
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:1174
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:1175
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:1176
  real(kind=fc_real), dimension(:,:,:,:), allocatable :: rbuf4d, wbuf4d, exp_val4d   ! pio_decomp_frame_tests.F90.in:1177
  real(kind=fc_real), dimension(:,:,:), allocatable :: rbuf3d, wbuf3d, exp_val3d   ! pio_decomp_frame_tests.F90.in:1178
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:1179
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:1180
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:1181
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:1182
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:1184
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:1185
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:1186
   ! pio_decomp_frame_tests.F90.in:846
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:1189
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1190
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1191
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1192


  ! Initialize the 4d var
  allocate(wbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1195
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1196
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1197
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1198
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1199
          wbuf4d(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1201
          wbuf4d(i,j,k,f) = wbuf4d(i,j,k,f) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1202
        end do   ! pio_decomp_frame_tests.F90.in:1203
      end do   ! pio_decomp_frame_tests.F90.in:1204
    end do   ! pio_decomp_frame_tests.F90.in:1205
  end do   ! pio_decomp_frame_tests.F90.in:1206
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1207
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1208
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1209
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1210
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1211
        compdof(tmp_idx) = int(wbuf4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:1212
      end do   ! pio_decomp_frame_tests.F90.in:1213
    end do   ! pio_decomp_frame_tests.F90.in:1214
  end do   ! pio_decomp_frame_tests.F90.in:1215
  ! Initialize the 3d var
  allocate(wbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1217
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1218
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1219
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1220
        wbuf3d(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1222
      end do   ! pio_decomp_frame_tests.F90.in:1223
    end do   ! pio_decomp_frame_tests.F90.in:1224
  end do   ! pio_decomp_frame_tests.F90.in:1225
   ! pio_decomp_frame_tests.F90.in:885
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1227
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1228
   ! pio_decomp_frame_tests.F90.in:888
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:1231
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1232
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1233
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1234


  allocate(rbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1236
  rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:1237
  ! Expected val for 4d var
  allocate(exp_val4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1239
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1240
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1241
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1242
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1243
          exp_val4d(i,j,k,f) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1245
          exp_val4d(i,j,k,f) = exp_val4d(i,j,k,f) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1246
        end do   ! pio_decomp_frame_tests.F90.in:1247
      end do   ! pio_decomp_frame_tests.F90.in:1248
    end do   ! pio_decomp_frame_tests.F90.in:1249
  end do   ! pio_decomp_frame_tests.F90.in:1250
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1251
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1252
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1253
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1254
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1255
        compdof(tmp_idx) = int(exp_val4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:1256
      end do   ! pio_decomp_frame_tests.F90.in:1257
    end do   ! pio_decomp_frame_tests.F90.in:1258
  end do   ! pio_decomp_frame_tests.F90.in:1259
   ! pio_decomp_frame_tests.F90.in:919
  allocate(rbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1261
  rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:1262
  ! Expected val for 3d var
  allocate(exp_val3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1264
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1265
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1266
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1267
        exp_val3d(i,j,k) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1269
      end do   ! pio_decomp_frame_tests.F90.in:1270
    end do   ! pio_decomp_frame_tests.F90.in:1271
  end do   ! pio_decomp_frame_tests.F90.in:1272
   ! pio_decomp_frame_tests.F90.in:932
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1274
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1275
   ! pio_decomp_frame_tests.F90.in:935
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:1277
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:1278
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:1279
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:1280


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1282
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:1283
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:1284
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:1285
      END IF   ! pio_decomp_frame_tests.F90.in:1286
    END IF   ! pio_decomp_frame_tests.F90.in:1287
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:1288


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1290
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1291
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1292
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:942)"   ! pio_decomp_frame_tests.F90.in:1296
      END IF   ! pio_decomp_frame_tests.F90.in:1297
      RETURN   ! pio_decomp_frame_tests.F90.in:1298
    END IF   ! pio_decomp_frame_tests.F90.in:1299
   ! pio_decomp_frame_tests.F90.in:943
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:1301


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1303
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1304
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1305
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:945)"   ! pio_decomp_frame_tests.F90.in:1309
      END IF   ! pio_decomp_frame_tests.F90.in:1310
      RETURN   ! pio_decomp_frame_tests.F90.in:1311
    END IF   ! pio_decomp_frame_tests.F90.in:1312
   ! pio_decomp_frame_tests.F90.in:946
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:1314


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1316
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1317
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1318
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:948)"   ! pio_decomp_frame_tests.F90.in:1322
      END IF   ! pio_decomp_frame_tests.F90.in:1323
      RETURN   ! pio_decomp_frame_tests.F90.in:1324
    END IF   ! pio_decomp_frame_tests.F90.in:1325
   ! pio_decomp_frame_tests.F90.in:949
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:1327


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1329
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1330
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1331
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:951)"   ! pio_decomp_frame_tests.F90.in:1335
      END IF   ! pio_decomp_frame_tests.F90.in:1336
      RETURN   ! pio_decomp_frame_tests.F90.in:1337
    END IF   ! pio_decomp_frame_tests.F90.in:1338
   ! pio_decomp_frame_tests.F90.in:952
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:1340


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1342
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1343
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1344
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:954)"   ! pio_decomp_frame_tests.F90.in:1348
      END IF   ! pio_decomp_frame_tests.F90.in:1349
      RETURN   ! pio_decomp_frame_tests.F90.in:1350
    END IF   ! pio_decomp_frame_tests.F90.in:1351
   ! pio_decomp_frame_tests.F90.in:955
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_3d_var', PIO_real, pio_dims(1:3), pio_var3d)   ! pio_decomp_frame_tests.F90.in:1353


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1355
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1356
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1357
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 3d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:957)"   ! pio_decomp_frame_tests.F90.in:1361
      END IF   ! pio_decomp_frame_tests.F90.in:1362
      RETURN   ! pio_decomp_frame_tests.F90.in:1363
    END IF   ! pio_decomp_frame_tests.F90.in:1364
   ! pio_decomp_frame_tests.F90.in:958
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_4d_var', PIO_real, pio_dims, pio_var4d)   ! pio_decomp_frame_tests.F90.in:1366


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1368
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1369
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1370
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 4d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:960)"   ! pio_decomp_frame_tests.F90.in:1374
      END IF   ! pio_decomp_frame_tests.F90.in:1375
      RETURN   ! pio_decomp_frame_tests.F90.in:1376
    END IF   ! pio_decomp_frame_tests.F90.in:1377
   ! pio_decomp_frame_tests.F90.in:961
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:1379


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1381
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1382
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1383
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:963)"   ! pio_decomp_frame_tests.F90.in:1387
      END IF   ! pio_decomp_frame_tests.F90.in:1388
      RETURN   ! pio_decomp_frame_tests.F90.in:1389
    END IF   ! pio_decomp_frame_tests.F90.in:1390
   ! pio_decomp_frame_tests.F90.in:964
    call PIO_write_darray(pio_file, pio_var3d, wr_iodesc, wbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1392


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1394
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1395
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1396
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:966)"   ! pio_decomp_frame_tests.F90.in:1400
      END IF   ! pio_decomp_frame_tests.F90.in:1401
      RETURN   ! pio_decomp_frame_tests.F90.in:1402
    END IF   ! pio_decomp_frame_tests.F90.in:1403
   ! pio_decomp_frame_tests.F90.in:967
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1405
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1406
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var4d, wr_iodesc, wbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1408


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1410
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1411
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1412
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:972)"   ! pio_decomp_frame_tests.F90.in:1416
        END IF   ! pio_decomp_frame_tests.F90.in:1417
        RETURN   ! pio_decomp_frame_tests.F90.in:1418
      END IF   ! pio_decomp_frame_tests.F90.in:1419
    end do   ! pio_decomp_frame_tests.F90.in:1420
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:1421
   ! pio_decomp_frame_tests.F90.in:975
    rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:1423
    rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:1424
   ! pio_decomp_frame_tests.F90.in:978
    call PIO_read_darray(pio_file, pio_var3d, rd_iodesc, rbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1426


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1428
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1429
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1430
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:980)"   ! pio_decomp_frame_tests.F90.in:1434
      END IF   ! pio_decomp_frame_tests.F90.in:1435
      RETURN   ! pio_decomp_frame_tests.F90.in:1436
    END IF   ! pio_decomp_frame_tests.F90.in:1437
   ! pio_decomp_frame_tests.F90.in:981
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1439
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1440
      call PIO_read_darray(pio_file, pio_var4d, rd_iodesc, rbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1441


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1443
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1444
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1445
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:985)"   ! pio_decomp_frame_tests.F90.in:1449
        END IF   ! pio_decomp_frame_tests.F90.in:1450
        RETURN   ! pio_decomp_frame_tests.F90.in:1451
      END IF   ! pio_decomp_frame_tests.F90.in:1452
    end do   ! pio_decomp_frame_tests.F90.in:1453
   ! pio_decomp_frame_tests.F90.in:987
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1455


      IF (.NOT. PIO_TF_Check_val_(rbuf4d(:,:,:,f), exp_val4d(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:1457
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1458
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1459
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong 4d val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:989)"   ! pio_decomp_frame_tests.F90.in:1463
        END IF   ! pio_decomp_frame_tests.F90.in:1464
        RETURN   ! pio_decomp_frame_tests.F90.in:1465
      END IF   ! pio_decomp_frame_tests.F90.in:1466
    end do   ! pio_decomp_frame_tests.F90.in:1467


    IF (.NOT. PIO_TF_Check_val_(rbuf3d, exp_val3d)) THEN   ! pio_decomp_frame_tests.F90.in:1469
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1470
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1471
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong 3dd val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:991)"   ! pio_decomp_frame_tests.F90.in:1475
      END IF   ! pio_decomp_frame_tests.F90.in:1476
      RETURN   ! pio_decomp_frame_tests.F90.in:1477
    END IF   ! pio_decomp_frame_tests.F90.in:1478
   ! pio_decomp_frame_tests.F90.in:992
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:1480


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:1482
  end do   ! pio_decomp_frame_tests.F90.in:1483
   ! pio_decomp_frame_tests.F90.in:997
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:1485
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:1486
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:1487
  end if   ! pio_decomp_frame_tests.F90.in:1488
   ! pio_decomp_frame_tests.F90.in:1002
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1490
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1491
   ! pio_decomp_frame_tests.F90.in:1005
  deallocate(exp_val3d)   ! pio_decomp_frame_tests.F90.in:1493
  deallocate(rbuf3d)   ! pio_decomp_frame_tests.F90.in:1494
  deallocate(wbuf3d)   ! pio_decomp_frame_tests.F90.in:1495
   ! pio_decomp_frame_tests.F90.in:1009
  deallocate(exp_val4d)   ! pio_decomp_frame_tests.F90.in:1497
  deallocate(rbuf4d)   ! pio_decomp_frame_tests.F90.in:1498
  deallocate(wbuf4d)   ! pio_decomp_frame_tests.F90.in:1499
END SUBROUTINE nc_reuse_3d_decomp_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:1500




SUBROUTINE nc_reuse_3d_decomp_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:1503
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:1504


  implicit none   ! pio_decomp_frame_tests.F90.in:1506
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:1507
  integer, parameter :: NFRAMES = 3   ! pio_decomp_frame_tests.F90.in:1508
  type(var_desc_t)  :: pio_var3d, pio_var4d   ! pio_decomp_frame_tests.F90.in:1509
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:1510
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:1511
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:1512
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:1513
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:1514
  real(kind=fc_double), dimension(:,:,:,:), allocatable :: rbuf4d, wbuf4d, exp_val4d   ! pio_decomp_frame_tests.F90.in:1515
  real(kind=fc_double), dimension(:,:,:), allocatable :: rbuf3d, wbuf3d, exp_val3d   ! pio_decomp_frame_tests.F90.in:1516
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:1517
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:1518
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:1519
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:1520
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:1522
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:1523
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:1524
   ! pio_decomp_frame_tests.F90.in:846
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:1527
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1528
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1529
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1530


  ! Initialize the 4d var
  allocate(wbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1533
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1534
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1535
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1536
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1537
          wbuf4d(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1539
          wbuf4d(i,j,k,f) = wbuf4d(i,j,k,f) + (f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1540
        end do   ! pio_decomp_frame_tests.F90.in:1541
      end do   ! pio_decomp_frame_tests.F90.in:1542
    end do   ! pio_decomp_frame_tests.F90.in:1543
  end do   ! pio_decomp_frame_tests.F90.in:1544
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1545
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1546
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1547
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1548
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1549
        compdof(tmp_idx) = int(wbuf4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:1550
      end do   ! pio_decomp_frame_tests.F90.in:1551
    end do   ! pio_decomp_frame_tests.F90.in:1552
  end do   ! pio_decomp_frame_tests.F90.in:1553
  ! Initialize the 3d var
  allocate(wbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1555
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1556
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1557
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1558
        wbuf3d(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1560
      end do   ! pio_decomp_frame_tests.F90.in:1561
    end do   ! pio_decomp_frame_tests.F90.in:1562
  end do   ! pio_decomp_frame_tests.F90.in:1563
   ! pio_decomp_frame_tests.F90.in:885
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1565
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1566
   ! pio_decomp_frame_tests.F90.in:888
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:1569
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1570
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1571
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1572


  allocate(rbuf4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1574
  rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:1575
  ! Expected val for 4d var
  allocate(exp_val4d(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1577
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1578
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1579
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1580
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1581
          exp_val4d(i,j,k,f) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1583
          exp_val4d(i,j,k,f) = exp_val4d(i,j,k,f)+(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1584
        end do   ! pio_decomp_frame_tests.F90.in:1585
      end do   ! pio_decomp_frame_tests.F90.in:1586
    end do   ! pio_decomp_frame_tests.F90.in:1587
  end do   ! pio_decomp_frame_tests.F90.in:1588
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1589
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1590
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1591
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1592
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1593
        compdof(tmp_idx) = int(exp_val4d(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:1594
      end do   ! pio_decomp_frame_tests.F90.in:1595
    end do   ! pio_decomp_frame_tests.F90.in:1596
  end do   ! pio_decomp_frame_tests.F90.in:1597
   ! pio_decomp_frame_tests.F90.in:919
  allocate(rbuf3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1599
  rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:1600
  ! Expected val for 3d var
  allocate(exp_val3d(nrows, ncols, nhgts))   ! pio_decomp_frame_tests.F90.in:1602
  do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1603
    do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1604
      do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1605
        exp_val3d(i,j,k) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1607
      end do   ! pio_decomp_frame_tests.F90.in:1608
    end do   ! pio_decomp_frame_tests.F90.in:1609
  end do   ! pio_decomp_frame_tests.F90.in:1610
   ! pio_decomp_frame_tests.F90.in:932
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1612
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1613
   ! pio_decomp_frame_tests.F90.in:935
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:1615
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:1616
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:1617
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:1618


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1620
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:1621
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:1622
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:1623
      END IF   ! pio_decomp_frame_tests.F90.in:1624
    END IF   ! pio_decomp_frame_tests.F90.in:1625
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:1626


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1628
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1629
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1630
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:942)"   ! pio_decomp_frame_tests.F90.in:1634
      END IF   ! pio_decomp_frame_tests.F90.in:1635
      RETURN   ! pio_decomp_frame_tests.F90.in:1636
    END IF   ! pio_decomp_frame_tests.F90.in:1637
   ! pio_decomp_frame_tests.F90.in:943
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:1639


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1641
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1642
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1643
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:945)"   ! pio_decomp_frame_tests.F90.in:1647
      END IF   ! pio_decomp_frame_tests.F90.in:1648
      RETURN   ! pio_decomp_frame_tests.F90.in:1649
    END IF   ! pio_decomp_frame_tests.F90.in:1650
   ! pio_decomp_frame_tests.F90.in:946
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:1652


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1654
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1655
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1656
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:948)"   ! pio_decomp_frame_tests.F90.in:1660
      END IF   ! pio_decomp_frame_tests.F90.in:1661
      RETURN   ! pio_decomp_frame_tests.F90.in:1662
    END IF   ! pio_decomp_frame_tests.F90.in:1663
   ! pio_decomp_frame_tests.F90.in:949
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:1665


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1667
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1668
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1669
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:951)"   ! pio_decomp_frame_tests.F90.in:1673
      END IF   ! pio_decomp_frame_tests.F90.in:1674
      RETURN   ! pio_decomp_frame_tests.F90.in:1675
    END IF   ! pio_decomp_frame_tests.F90.in:1676
   ! pio_decomp_frame_tests.F90.in:952
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time', pio_unlimited, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:1678


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1680
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1681
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1682
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:954)"   ! pio_decomp_frame_tests.F90.in:1686
      END IF   ! pio_decomp_frame_tests.F90.in:1687
      RETURN   ! pio_decomp_frame_tests.F90.in:1688
    END IF   ! pio_decomp_frame_tests.F90.in:1689
   ! pio_decomp_frame_tests.F90.in:955
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_3d_var', PIO_double, pio_dims(1:3), pio_var3d)   ! pio_decomp_frame_tests.F90.in:1691


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1693
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1694
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1695
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 3d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:957)"   ! pio_decomp_frame_tests.F90.in:1699
      END IF   ! pio_decomp_frame_tests.F90.in:1700
      RETURN   ! pio_decomp_frame_tests.F90.in:1701
    END IF   ! pio_decomp_frame_tests.F90.in:1702
   ! pio_decomp_frame_tests.F90.in:958
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_4d_var', PIO_double, pio_dims, pio_var4d)   ! pio_decomp_frame_tests.F90.in:1704


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1706
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1707
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1708
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a 4d var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:960)"   ! pio_decomp_frame_tests.F90.in:1712
      END IF   ! pio_decomp_frame_tests.F90.in:1713
      RETURN   ! pio_decomp_frame_tests.F90.in:1714
    END IF   ! pio_decomp_frame_tests.F90.in:1715
   ! pio_decomp_frame_tests.F90.in:961
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:1717


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1719
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1720
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1721
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:963)"   ! pio_decomp_frame_tests.F90.in:1725
      END IF   ! pio_decomp_frame_tests.F90.in:1726
      RETURN   ! pio_decomp_frame_tests.F90.in:1727
    END IF   ! pio_decomp_frame_tests.F90.in:1728
   ! pio_decomp_frame_tests.F90.in:964
    call PIO_write_darray(pio_file, pio_var3d, wr_iodesc, wbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1730


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1732
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1733
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1734
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:966)"   ! pio_decomp_frame_tests.F90.in:1738
      END IF   ! pio_decomp_frame_tests.F90.in:1739
      RETURN   ! pio_decomp_frame_tests.F90.in:1740
    END IF   ! pio_decomp_frame_tests.F90.in:1741
   ! pio_decomp_frame_tests.F90.in:967
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1743
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1744
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var4d, wr_iodesc, wbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1746


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1748
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1749
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1750
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:972)"   ! pio_decomp_frame_tests.F90.in:1754
        END IF   ! pio_decomp_frame_tests.F90.in:1755
        RETURN   ! pio_decomp_frame_tests.F90.in:1756
      END IF   ! pio_decomp_frame_tests.F90.in:1757
    end do   ! pio_decomp_frame_tests.F90.in:1758
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:1759
   ! pio_decomp_frame_tests.F90.in:975
    rbuf4d = 0   ! pio_decomp_frame_tests.F90.in:1761
    rbuf3d = 0   ! pio_decomp_frame_tests.F90.in:1762
   ! pio_decomp_frame_tests.F90.in:978
    call PIO_read_darray(pio_file, pio_var3d, rd_iodesc, rbuf3d, ierr)   ! pio_decomp_frame_tests.F90.in:1764


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1766
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1767
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1768
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read 3d darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:980)"   ! pio_decomp_frame_tests.F90.in:1772
      END IF   ! pio_decomp_frame_tests.F90.in:1773
      RETURN   ! pio_decomp_frame_tests.F90.in:1774
    END IF   ! pio_decomp_frame_tests.F90.in:1775
   ! pio_decomp_frame_tests.F90.in:981
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1777
      call PIO_setframe(pio_file, pio_var4d, f)   ! pio_decomp_frame_tests.F90.in:1778
      call PIO_read_darray(pio_file, pio_var4d, rd_iodesc, rbuf4d(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:1779


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1781
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1782
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1783
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read 4d darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:985)"   ! pio_decomp_frame_tests.F90.in:1787
        END IF   ! pio_decomp_frame_tests.F90.in:1788
        RETURN   ! pio_decomp_frame_tests.F90.in:1789
      END IF   ! pio_decomp_frame_tests.F90.in:1790
    end do   ! pio_decomp_frame_tests.F90.in:1791
   ! pio_decomp_frame_tests.F90.in:987
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1793


      IF (.NOT. PIO_TF_Check_val_(rbuf4d(:,:,:,f), exp_val4d(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:1795
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1796
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1797
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong 4d val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:989)"   ! pio_decomp_frame_tests.F90.in:1801
        END IF   ! pio_decomp_frame_tests.F90.in:1802
        RETURN   ! pio_decomp_frame_tests.F90.in:1803
      END IF   ! pio_decomp_frame_tests.F90.in:1804
    end do   ! pio_decomp_frame_tests.F90.in:1805


    IF (.NOT. PIO_TF_Check_val_(rbuf3d, exp_val3d)) THEN   ! pio_decomp_frame_tests.F90.in:1807
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1808
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1809
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong 3dd val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:991)"   ! pio_decomp_frame_tests.F90.in:1813
      END IF   ! pio_decomp_frame_tests.F90.in:1814
      RETURN   ! pio_decomp_frame_tests.F90.in:1815
    END IF   ! pio_decomp_frame_tests.F90.in:1816
   ! pio_decomp_frame_tests.F90.in:992
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:1818


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:1820
  end do   ! pio_decomp_frame_tests.F90.in:1821
   ! pio_decomp_frame_tests.F90.in:997
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:1823
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:1824
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:1825
  end if   ! pio_decomp_frame_tests.F90.in:1826
   ! pio_decomp_frame_tests.F90.in:1002
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1828
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1829
   ! pio_decomp_frame_tests.F90.in:1005
  deallocate(exp_val3d)   ! pio_decomp_frame_tests.F90.in:1831
  deallocate(rbuf3d)   ! pio_decomp_frame_tests.F90.in:1832
  deallocate(wbuf3d)   ! pio_decomp_frame_tests.F90.in:1833
   ! pio_decomp_frame_tests.F90.in:1009
  deallocate(exp_val4d)   ! pio_decomp_frame_tests.F90.in:1835
  deallocate(rbuf4d)   ! pio_decomp_frame_tests.F90.in:1836
  deallocate(wbuf4d)   ! pio_decomp_frame_tests.F90.in:1837
END SUBROUTINE nc_reuse_3d_decomp_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:1838
   ! pio_decomp_frame_tests.F90.in:1013




! Same as nc_write_read_4d_col_decomp, but use a limited time dimension instead


SUBROUTINE nc_test_limited_time_dim_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:1844
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:1845


  implicit none   ! pio_decomp_frame_tests.F90.in:1847
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:1848
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:1849
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:1850
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:1851
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:1852
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:1853
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:1854
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:1855
  integer, dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:1856
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:1857
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:1858
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:1859
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:1860
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:1862
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:1863
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:1864
   ! pio_decomp_frame_tests.F90.in:1862
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:1867
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1868
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1869
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1870


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1872
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1873
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1874
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1875
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1876
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1877
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1879
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1880
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1881
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:1882
        end do   ! pio_decomp_frame_tests.F90.in:1883
      end do   ! pio_decomp_frame_tests.F90.in:1884
    end do   ! pio_decomp_frame_tests.F90.in:1885
  end do   ! pio_decomp_frame_tests.F90.in:1886
   ! pio_decomp_frame_tests.F90.in:1884
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:1888
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1889
   ! pio_decomp_frame_tests.F90.in:1887
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:1892
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:1893
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:1894
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:1895


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1897
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:1898
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:1899
   ! pio_decomp_frame_tests.F90.in:1897
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:1901
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:1902
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:1903
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:1904
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:1905
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:1907
          exp_val(i,j,k,f) = compdof(tmp_idx) + int(f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:1908
        end do   ! pio_decomp_frame_tests.F90.in:1909
      end do   ! pio_decomp_frame_tests.F90.in:1910
    end do   ! pio_decomp_frame_tests.F90.in:1911
  end do   ! pio_decomp_frame_tests.F90.in:1912
   ! pio_decomp_frame_tests.F90.in:1910
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:1914
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:1915
   ! pio_decomp_frame_tests.F90.in:1913
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:1917
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:1918
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:1919
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:1920


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1922
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:1923
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:1924
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:1925
      END IF   ! pio_decomp_frame_tests.F90.in:1926
    END IF   ! pio_decomp_frame_tests.F90.in:1927
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:1928


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1930
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1931
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1932
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1920)"   ! pio_decomp_frame_tests.F90.in:1936
      END IF   ! pio_decomp_frame_tests.F90.in:1937
      RETURN   ! pio_decomp_frame_tests.F90.in:1938
    END IF   ! pio_decomp_frame_tests.F90.in:1939
   ! pio_decomp_frame_tests.F90.in:1921
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:1941


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1943
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1944
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1945
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1923)"   ! pio_decomp_frame_tests.F90.in:1949
      END IF   ! pio_decomp_frame_tests.F90.in:1950
      RETURN   ! pio_decomp_frame_tests.F90.in:1951
    END IF   ! pio_decomp_frame_tests.F90.in:1952
   ! pio_decomp_frame_tests.F90.in:1924
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:1954


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1956
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1957
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1958
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1926)"   ! pio_decomp_frame_tests.F90.in:1962
      END IF   ! pio_decomp_frame_tests.F90.in:1963
      RETURN   ! pio_decomp_frame_tests.F90.in:1964
    END IF   ! pio_decomp_frame_tests.F90.in:1965
   ! pio_decomp_frame_tests.F90.in:1927
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:1967


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1969
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1970
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1971
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1929)"   ! pio_decomp_frame_tests.F90.in:1975
      END IF   ! pio_decomp_frame_tests.F90.in:1976
      RETURN   ! pio_decomp_frame_tests.F90.in:1977
    END IF   ! pio_decomp_frame_tests.F90.in:1978
   ! pio_decomp_frame_tests.F90.in:1930
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time_limited', NFRAMES, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:1980


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1982
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1983
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1984
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1932)"   ! pio_decomp_frame_tests.F90.in:1988
      END IF   ! pio_decomp_frame_tests.F90.in:1989
      RETURN   ! pio_decomp_frame_tests.F90.in:1990
    END IF   ! pio_decomp_frame_tests.F90.in:1991
   ! pio_decomp_frame_tests.F90.in:1933
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:1993


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:1995
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:1996
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:1997
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1935)"   ! pio_decomp_frame_tests.F90.in:2001
      END IF   ! pio_decomp_frame_tests.F90.in:2002
      RETURN   ! pio_decomp_frame_tests.F90.in:2003
    END IF   ! pio_decomp_frame_tests.F90.in:2004
   ! pio_decomp_frame_tests.F90.in:1936
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:2006


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2008
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2009
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2010
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1938)"   ! pio_decomp_frame_tests.F90.in:2014
      END IF   ! pio_decomp_frame_tests.F90.in:2015
      RETURN   ! pio_decomp_frame_tests.F90.in:2016
    END IF   ! pio_decomp_frame_tests.F90.in:2017
   ! pio_decomp_frame_tests.F90.in:1939
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2019
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2020
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2022


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2024
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2025
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2026
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1944)"   ! pio_decomp_frame_tests.F90.in:2030
        END IF   ! pio_decomp_frame_tests.F90.in:2031
        RETURN   ! pio_decomp_frame_tests.F90.in:2032
      END IF   ! pio_decomp_frame_tests.F90.in:2033
    end do   ! pio_decomp_frame_tests.F90.in:2034
   ! pio_decomp_frame_tests.F90.in:1946
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:2036
   ! pio_decomp_frame_tests.F90.in:1948
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2038
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2039
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2040


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2042
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2043
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2044
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1952)"   ! pio_decomp_frame_tests.F90.in:2048
        END IF   ! pio_decomp_frame_tests.F90.in:2049
        RETURN   ! pio_decomp_frame_tests.F90.in:2050
      END IF   ! pio_decomp_frame_tests.F90.in:2051
    end do   ! pio_decomp_frame_tests.F90.in:2052
   ! pio_decomp_frame_tests.F90.in:1954
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2054


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:2056
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2057
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2058
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1956)"   ! pio_decomp_frame_tests.F90.in:2062
        END IF   ! pio_decomp_frame_tests.F90.in:2063
        RETURN   ! pio_decomp_frame_tests.F90.in:2064
      END IF   ! pio_decomp_frame_tests.F90.in:2065
    end do   ! pio_decomp_frame_tests.F90.in:2066
   ! pio_decomp_frame_tests.F90.in:1958
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:2068


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:2070
  end do   ! pio_decomp_frame_tests.F90.in:2071
   ! pio_decomp_frame_tests.F90.in:1963
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:2073
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:2074
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:2075
  end if   ! pio_decomp_frame_tests.F90.in:2076
   ! pio_decomp_frame_tests.F90.in:1968
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:2078
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:2079
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:2080
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:2081
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:2082
END SUBROUTINE nc_test_limited_time_dim_PIO_int_integer__   ! pio_decomp_frame_tests.F90.in:2083




SUBROUTINE nc_test_limited_time_dim_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:2086
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:2087


  implicit none   ! pio_decomp_frame_tests.F90.in:2089
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:2090
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:2091
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:2092
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:2093
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:2094
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:2095
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:2096
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:2097
  real(kind=fc_real), dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:2098
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:2099
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:2100
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:2101
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:2102
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:2104
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:2105
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:2106
   ! pio_decomp_frame_tests.F90.in:1862
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:2109
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:2110
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:2111
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:2112


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2114
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:2115
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2116
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:2117
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:2118
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:2119
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:2121
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:2122
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:2123
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:2124
        end do   ! pio_decomp_frame_tests.F90.in:2125
      end do   ! pio_decomp_frame_tests.F90.in:2126
    end do   ! pio_decomp_frame_tests.F90.in:2127
  end do   ! pio_decomp_frame_tests.F90.in:2128
   ! pio_decomp_frame_tests.F90.in:1884
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:2130
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:2131
   ! pio_decomp_frame_tests.F90.in:1887
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:2134
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:2135
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:2136
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:2137


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2139
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:2140
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2141
   ! pio_decomp_frame_tests.F90.in:1897
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2143
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:2144
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:2145
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:2146
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:2147
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:2149
          exp_val(i,j,k,f) = compdof(tmp_idx) + real(f - 1) * real(dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:2150
        end do   ! pio_decomp_frame_tests.F90.in:2151
      end do   ! pio_decomp_frame_tests.F90.in:2152
    end do   ! pio_decomp_frame_tests.F90.in:2153
  end do   ! pio_decomp_frame_tests.F90.in:2154
   ! pio_decomp_frame_tests.F90.in:1910
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:2156
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:2157
   ! pio_decomp_frame_tests.F90.in:1913
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:2159
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:2160
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:2161
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:2162


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2164
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:2165
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:2166
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:2167
      END IF   ! pio_decomp_frame_tests.F90.in:2168
    END IF   ! pio_decomp_frame_tests.F90.in:2169
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:2170


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2172
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2173
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2174
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1920)"   ! pio_decomp_frame_tests.F90.in:2178
      END IF   ! pio_decomp_frame_tests.F90.in:2179
      RETURN   ! pio_decomp_frame_tests.F90.in:2180
    END IF   ! pio_decomp_frame_tests.F90.in:2181
   ! pio_decomp_frame_tests.F90.in:1921
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:2183


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2185
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2186
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2187
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1923)"   ! pio_decomp_frame_tests.F90.in:2191
      END IF   ! pio_decomp_frame_tests.F90.in:2192
      RETURN   ! pio_decomp_frame_tests.F90.in:2193
    END IF   ! pio_decomp_frame_tests.F90.in:2194
   ! pio_decomp_frame_tests.F90.in:1924
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:2196


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2198
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2199
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2200
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1926)"   ! pio_decomp_frame_tests.F90.in:2204
      END IF   ! pio_decomp_frame_tests.F90.in:2205
      RETURN   ! pio_decomp_frame_tests.F90.in:2206
    END IF   ! pio_decomp_frame_tests.F90.in:2207
   ! pio_decomp_frame_tests.F90.in:1927
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:2209


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2211
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2212
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2213
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1929)"   ! pio_decomp_frame_tests.F90.in:2217
      END IF   ! pio_decomp_frame_tests.F90.in:2218
      RETURN   ! pio_decomp_frame_tests.F90.in:2219
    END IF   ! pio_decomp_frame_tests.F90.in:2220
   ! pio_decomp_frame_tests.F90.in:1930
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time_limited', NFRAMES, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:2222


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2224
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2225
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2226
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1932)"   ! pio_decomp_frame_tests.F90.in:2230
      END IF   ! pio_decomp_frame_tests.F90.in:2231
      RETURN   ! pio_decomp_frame_tests.F90.in:2232
    END IF   ! pio_decomp_frame_tests.F90.in:2233
   ! pio_decomp_frame_tests.F90.in:1933
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:2235


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2237
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2238
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2239
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1935)"   ! pio_decomp_frame_tests.F90.in:2243
      END IF   ! pio_decomp_frame_tests.F90.in:2244
      RETURN   ! pio_decomp_frame_tests.F90.in:2245
    END IF   ! pio_decomp_frame_tests.F90.in:2246
   ! pio_decomp_frame_tests.F90.in:1936
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:2248


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2250
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2251
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2252
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1938)"   ! pio_decomp_frame_tests.F90.in:2256
      END IF   ! pio_decomp_frame_tests.F90.in:2257
      RETURN   ! pio_decomp_frame_tests.F90.in:2258
    END IF   ! pio_decomp_frame_tests.F90.in:2259
   ! pio_decomp_frame_tests.F90.in:1939
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2261
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2262
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2264


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2266
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2267
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2268
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1944)"   ! pio_decomp_frame_tests.F90.in:2272
        END IF   ! pio_decomp_frame_tests.F90.in:2273
        RETURN   ! pio_decomp_frame_tests.F90.in:2274
      END IF   ! pio_decomp_frame_tests.F90.in:2275
    end do   ! pio_decomp_frame_tests.F90.in:2276
   ! pio_decomp_frame_tests.F90.in:1946
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:2278
   ! pio_decomp_frame_tests.F90.in:1948
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2280
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2281
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2282


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2284
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2285
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2286
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1952)"   ! pio_decomp_frame_tests.F90.in:2290
        END IF   ! pio_decomp_frame_tests.F90.in:2291
        RETURN   ! pio_decomp_frame_tests.F90.in:2292
      END IF   ! pio_decomp_frame_tests.F90.in:2293
    end do   ! pio_decomp_frame_tests.F90.in:2294
   ! pio_decomp_frame_tests.F90.in:1954
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2296


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:2298
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2299
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2300
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1956)"   ! pio_decomp_frame_tests.F90.in:2304
        END IF   ! pio_decomp_frame_tests.F90.in:2305
        RETURN   ! pio_decomp_frame_tests.F90.in:2306
      END IF   ! pio_decomp_frame_tests.F90.in:2307
    end do   ! pio_decomp_frame_tests.F90.in:2308
   ! pio_decomp_frame_tests.F90.in:1958
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:2310


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:2312
  end do   ! pio_decomp_frame_tests.F90.in:2313
   ! pio_decomp_frame_tests.F90.in:1963
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:2315
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:2316
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:2317
  end if   ! pio_decomp_frame_tests.F90.in:2318
   ! pio_decomp_frame_tests.F90.in:1968
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:2320
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:2321
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:2322
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:2323
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:2324
END SUBROUTINE nc_test_limited_time_dim_PIO_real_real_kind_fc_real___   ! pio_decomp_frame_tests.F90.in:2325




SUBROUTINE nc_test_limited_time_dim_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:2328
USE pio_tutil   ! pio_decomp_frame_tests.F90.in:2329


  implicit none   ! pio_decomp_frame_tests.F90.in:2331
  integer, parameter :: NDIMS = 4   ! pio_decomp_frame_tests.F90.in:2332
  integer, parameter :: NFRAMES = 6   ! pio_decomp_frame_tests.F90.in:2333
  type(var_desc_t)  :: pio_var   ! pio_decomp_frame_tests.F90.in:2334
  type(file_desc_t) :: pio_file   ! pio_decomp_frame_tests.F90.in:2335
  character(len=PIO_TF_MAX_STR_LEN) :: filename   ! pio_decomp_frame_tests.F90.in:2336
  type(io_desc_t) :: wr_iodesc, rd_iodesc   ! pio_decomp_frame_tests.F90.in:2337
  integer, dimension(:), allocatable :: compdof   ! pio_decomp_frame_tests.F90.in:2338
  integer, dimension(NDIMS) :: start, count   ! pio_decomp_frame_tests.F90.in:2339
  real(kind=fc_double), dimension(:,:,:,:), allocatable :: rbuf, wbuf, exp_val   ! pio_decomp_frame_tests.F90.in:2340
  integer, dimension(NDIMS-1) :: dims   ! pio_decomp_frame_tests.F90.in:2341
  integer, dimension(NDIMS) :: pio_dims   ! pio_decomp_frame_tests.F90.in:2342
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts   ! pio_decomp_frame_tests.F90.in:2343
  integer(kind=pio_offset_kind) :: f   ! pio_decomp_frame_tests.F90.in:2344
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_decomp_frame_tests.F90.in:2346
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_decomp_frame_tests.F90.in:2347
  integer :: num_iotypes   ! pio_decomp_frame_tests.F90.in:2348
   ! pio_decomp_frame_tests.F90.in:1862
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_decomp_frame_tests.F90.in:2351
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:2352
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:2353
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:2354


  allocate(wbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2356
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:2357
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2358
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:2359
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:2360
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:2361
          wbuf(i,j,k,f) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                        (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:2363
          wbuf(i,j,k,f) = wbuf(i,j,k,f) + (f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:2364
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:2365
          compdof(tmp_idx) = int(wbuf(i,j,k,1))   ! pio_decomp_frame_tests.F90.in:2366
        end do   ! pio_decomp_frame_tests.F90.in:2367
      end do   ! pio_decomp_frame_tests.F90.in:2368
    end do   ! pio_decomp_frame_tests.F90.in:2369
  end do   ! pio_decomp_frame_tests.F90.in:2370
   ! pio_decomp_frame_tests.F90.in:1884
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:2372
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:2373
   ! pio_decomp_frame_tests.F90.in:1887
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)   ! pio_decomp_frame_tests.F90.in:2376
  nrows = count(1)   ! pio_decomp_frame_tests.F90.in:2377
  ncols = count(2)   ! pio_decomp_frame_tests.F90.in:2378
  nhgts = count(3)   ! pio_decomp_frame_tests.F90.in:2379


  allocate(rbuf(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2381
  allocate(compdof(nrows * ncols * nhgts))   ! pio_decomp_frame_tests.F90.in:2382
  allocate(exp_val(nrows, ncols, nhgts, NFRAMES))   ! pio_decomp_frame_tests.F90.in:2383
   ! pio_decomp_frame_tests.F90.in:1897
  do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2385
    do k=1,nhgts   ! pio_decomp_frame_tests.F90.in:2386
      do j=1,ncols   ! pio_decomp_frame_tests.F90.in:2387
        do i=1,nrows   ! pio_decomp_frame_tests.F90.in:2388
          tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i   ! pio_decomp_frame_tests.F90.in:2389
          compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                              (start(2) - 1 + j - 1) * dims(1) + i   ! pio_decomp_frame_tests.F90.in:2391
          exp_val(i,j,k,f) = compdof(tmp_idx) + (f - 1) * (dims(1) * dims(2) * dims(3))   ! pio_decomp_frame_tests.F90.in:2392
        end do   ! pio_decomp_frame_tests.F90.in:2393
      end do   ! pio_decomp_frame_tests.F90.in:2394
    end do   ! pio_decomp_frame_tests.F90.in:2395
  end do   ! pio_decomp_frame_tests.F90.in:2396
   ! pio_decomp_frame_tests.F90.in:1910
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:2398
  deallocate(compdof)   ! pio_decomp_frame_tests.F90.in:2399
   ! pio_decomp_frame_tests.F90.in:1913
  num_iotypes = 0   ! pio_decomp_frame_tests.F90.in:2401
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_decomp_frame_tests.F90.in:2402
  filename = "test_pio_decomp_simple_tests.testfile"   ! pio_decomp_frame_tests.F90.in:2403
  do i=1,num_iotypes   ! pio_decomp_frame_tests.F90.in:2404


    IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2406
      IF (pio_tf_log_level_ >= 0) THEN   ! pio_decomp_frame_tests.F90.in:2407
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "   ! pio_decomp_frame_tests.F90.in:2408
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)   ! pio_decomp_frame_tests.F90.in:2409
      END IF   ! pio_decomp_frame_tests.F90.in:2410
    END IF   ! pio_decomp_frame_tests.F90.in:2411
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)   ! pio_decomp_frame_tests.F90.in:2412


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2414
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2415
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2416
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1920)"   ! pio_decomp_frame_tests.F90.in:2420
      END IF   ! pio_decomp_frame_tests.F90.in:2421
      RETURN   ! pio_decomp_frame_tests.F90.in:2422
    END IF   ! pio_decomp_frame_tests.F90.in:2423
   ! pio_decomp_frame_tests.F90.in:1921
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))   ! pio_decomp_frame_tests.F90.in:2425


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2427
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2428
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2429
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1923)"   ! pio_decomp_frame_tests.F90.in:2433
      END IF   ! pio_decomp_frame_tests.F90.in:2434
      RETURN   ! pio_decomp_frame_tests.F90.in:2435
    END IF   ! pio_decomp_frame_tests.F90.in:2436
   ! pio_decomp_frame_tests.F90.in:1924
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))   ! pio_decomp_frame_tests.F90.in:2438


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2440
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2441
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2442
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1926)"   ! pio_decomp_frame_tests.F90.in:2446
      END IF   ! pio_decomp_frame_tests.F90.in:2447
      RETURN   ! pio_decomp_frame_tests.F90.in:2448
    END IF   ! pio_decomp_frame_tests.F90.in:2449
   ! pio_decomp_frame_tests.F90.in:1927
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))   ! pio_decomp_frame_tests.F90.in:2451


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2453
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2454
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2455
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1929)"   ! pio_decomp_frame_tests.F90.in:2459
      END IF   ! pio_decomp_frame_tests.F90.in:2460
      RETURN   ! pio_decomp_frame_tests.F90.in:2461
    END IF   ! pio_decomp_frame_tests.F90.in:2462
   ! pio_decomp_frame_tests.F90.in:1930
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_time_limited', NFRAMES, pio_dims(4))   ! pio_decomp_frame_tests.F90.in:2464


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2466
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2467
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2468
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1932)"   ! pio_decomp_frame_tests.F90.in:2472
      END IF   ! pio_decomp_frame_tests.F90.in:2473
      RETURN   ! pio_decomp_frame_tests.F90.in:2474
    END IF   ! pio_decomp_frame_tests.F90.in:2475
   ! pio_decomp_frame_tests.F90.in:1933
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, pio_dims, pio_var)   ! pio_decomp_frame_tests.F90.in:2477


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2479
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2480
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2481
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1935)"   ! pio_decomp_frame_tests.F90.in:2485
      END IF   ! pio_decomp_frame_tests.F90.in:2486
      RETURN   ! pio_decomp_frame_tests.F90.in:2487
    END IF   ! pio_decomp_frame_tests.F90.in:2488
   ! pio_decomp_frame_tests.F90.in:1936
    ierr = PIO_enddef(pio_file)   ! pio_decomp_frame_tests.F90.in:2490


    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2492
      pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2493
      IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2494
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_frame_tests.F90.in:1938)"   ! pio_decomp_frame_tests.F90.in:2498
      END IF   ! pio_decomp_frame_tests.F90.in:2499
      RETURN   ! pio_decomp_frame_tests.F90.in:2500
    END IF   ! pio_decomp_frame_tests.F90.in:2501
   ! pio_decomp_frame_tests.F90.in:1939
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2503
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2504
      ! Write the current frame
      call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2506


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2508
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2509
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2510
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to write darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1944)"   ! pio_decomp_frame_tests.F90.in:2514
        END IF   ! pio_decomp_frame_tests.F90.in:2515
        RETURN   ! pio_decomp_frame_tests.F90.in:2516
      END IF   ! pio_decomp_frame_tests.F90.in:2517
    end do   ! pio_decomp_frame_tests.F90.in:2518
   ! pio_decomp_frame_tests.F90.in:1946
    call PIO_syncfile(pio_file)   ! pio_decomp_frame_tests.F90.in:2520
   ! pio_decomp_frame_tests.F90.in:1948
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2522
      call PIO_setframe(pio_file, pio_var, f)   ! pio_decomp_frame_tests.F90.in:2523
      call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf(:,:,:,f), ierr)   ! pio_decomp_frame_tests.F90.in:2524


      IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN   ! pio_decomp_frame_tests.F90.in:2526
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2527
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2528
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to read darray : " // trim(filename),&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1952)"   ! pio_decomp_frame_tests.F90.in:2532
        END IF   ! pio_decomp_frame_tests.F90.in:2533
        RETURN   ! pio_decomp_frame_tests.F90.in:2534
      END IF   ! pio_decomp_frame_tests.F90.in:2535
    end do   ! pio_decomp_frame_tests.F90.in:2536
   ! pio_decomp_frame_tests.F90.in:1954
    do f=1,NFRAMES   ! pio_decomp_frame_tests.F90.in:2538


      IF (.NOT. PIO_TF_Check_val_(rbuf(:,:,:,f), exp_val(:,:,:,f))) THEN   ! pio_decomp_frame_tests.F90.in:2540
        pio_tf_retval_utest_ = -1   ! pio_decomp_frame_tests.F90.in:2541
        IF (pio_tf_world_rank_ == 0) THEN   ! pio_decomp_frame_tests.F90.in:2542
          PRINT *, "PIO_TF: PIO Check failed:",&
             "Got wrong val, frame=", f,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_decomp_frame_tests.F90.in:1956)"   ! pio_decomp_frame_tests.F90.in:2546
        END IF   ! pio_decomp_frame_tests.F90.in:2547
        RETURN   ! pio_decomp_frame_tests.F90.in:2548
      END IF   ! pio_decomp_frame_tests.F90.in:2549
    end do   ! pio_decomp_frame_tests.F90.in:2550
   ! pio_decomp_frame_tests.F90.in:1958
    call PIO_closefile(pio_file)   ! pio_decomp_frame_tests.F90.in:2552


    call PIO_deletefile(pio_tf_iosystem_, filename);   ! pio_decomp_frame_tests.F90.in:2554
  end do   ! pio_decomp_frame_tests.F90.in:2555
   ! pio_decomp_frame_tests.F90.in:1963
  if(allocated(iotypes)) then   ! pio_decomp_frame_tests.F90.in:2557
    deallocate(iotypes)   ! pio_decomp_frame_tests.F90.in:2558
    deallocate(iotype_descs)   ! pio_decomp_frame_tests.F90.in:2559
  end if   ! pio_decomp_frame_tests.F90.in:2560
   ! pio_decomp_frame_tests.F90.in:1968
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)   ! pio_decomp_frame_tests.F90.in:2562
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)   ! pio_decomp_frame_tests.F90.in:2563
  deallocate(exp_val)   ! pio_decomp_frame_tests.F90.in:2564
  deallocate(rbuf)   ! pio_decomp_frame_tests.F90.in:2565
  deallocate(wbuf)   ! pio_decomp_frame_tests.F90.in:2566
END SUBROUTINE nc_test_limited_time_dim_PIO_double_real_kind_fc_double___   ! pio_decomp_frame_tests.F90.in:2567


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
