! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_decomp_tests_1d.F90.in

#include "config.h"
! Get a block cyclic decomposition
! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_LOCAL_SZ elements
! # All odd procs have VEC_LOCAL_SZ + 1 elements
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [1,2] [3,4,5] [6,7]
! e.g. 2)    [1,2] [3,4,5] [6,7] [8,9,10]
! e.g. 3)    [1,2] [3,4,5] [6,7] [8,9,10] [11,12]
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! This for example can be used to force rearrangement when reading
! or writing data.
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [3,4,5] [1,2] [6,7]
! e.g. 2)    [3,4,5] [1,2] [8,9,10] [6,7]
! e.g. 3)    [3,4,5] [1,2] [8,9,10] [6,7] [11,12]
SUBROUTINE get_1d_bc_info(rank, sz, dims, start, count, force_rearrange)   ! pio_decomp_tests_1d.F90.in:19
  integer, parameter :: VEC_LOCAL_SZ = 7   ! pio_decomp_tests_1d.F90.in:20
  integer, intent(in) :: rank   ! pio_decomp_tests_1d.F90.in:21
  integer, intent(in) :: sz   ! pio_decomp_tests_1d.F90.in:22
  integer, dimension(1), intent(out) :: dims   ! pio_decomp_tests_1d.F90.in:23
  integer, dimension(1), intent(out) :: start   ! pio_decomp_tests_1d.F90.in:24
  integer, dimension(1), intent(out) :: count   ! pio_decomp_tests_1d.F90.in:25
  logical, intent(in) :: force_rearrange   ! pio_decomp_tests_1d.F90.in:26


  logical :: is_even_rank   ! pio_decomp_tests_1d.F90.in:28
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_tests_1d.F90.in:29
  integer :: iodd, ieven   ! pio_decomp_tests_1d.F90.in:30


  is_even_rank = .false.   ! pio_decomp_tests_1d.F90.in:32
  if (mod(rank, 2) == 0) then   ! pio_decomp_tests_1d.F90.in:33
    is_even_rank = .true.   ! pio_decomp_tests_1d.F90.in:34
  end if   ! pio_decomp_tests_1d.F90.in:35
  num_odd_procs = sz / 2   ! pio_decomp_tests_1d.F90.in:36
  num_even_procs = sz - num_odd_procs   ! pio_decomp_tests_1d.F90.in:37
  dims(1) = num_even_procs * VEC_LOCAL_SZ + num_odd_procs * (VEC_LOCAL_SZ + 1)   ! pio_decomp_tests_1d.F90.in:38
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_tests_1d.F90.in:40
  ieven = (rank + 1) / 2   ! pio_decomp_tests_1d.F90.in:41
  if(force_rearrange) then   ! pio_decomp_tests_1d.F90.in:42
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_decomp_tests_1d.F90.in:44
      if(rank + 1 < sz) then   ! pio_decomp_tests_1d.F90.in:45
        ! Force rearrangement
        count(1) = VEC_LOCAL_SZ + 1   ! pio_decomp_tests_1d.F90.in:47
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + (VEC_LOCAL_SZ) + 1   ! pio_decomp_tests_1d.F90.in:48
      else   ! pio_decomp_tests_1d.F90.in:49
        count(1) = VEC_LOCAL_SZ   ! pio_decomp_tests_1d.F90.in:50
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_decomp_tests_1d.F90.in:51
      end if   ! pio_decomp_tests_1d.F90.in:52
    else   ! pio_decomp_tests_1d.F90.in:53
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(1) = VEC_LOCAL_SZ   ! pio_decomp_tests_1d.F90.in:56
      start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) - (VEC_LOCAL_SZ) + 1   ! pio_decomp_tests_1d.F90.in:57
    end if   ! pio_decomp_tests_1d.F90.in:58
  else   ! pio_decomp_tests_1d.F90.in:59
    if (is_even_rank) then   ! pio_decomp_tests_1d.F90.in:60
      count(1) = VEC_LOCAL_SZ   ! pio_decomp_tests_1d.F90.in:61
    else   ! pio_decomp_tests_1d.F90.in:62
      count(1) = VEC_LOCAL_SZ + 1   ! pio_decomp_tests_1d.F90.in:63
    end if   ! pio_decomp_tests_1d.F90.in:64
    start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_decomp_tests_1d.F90.in:65
  end if   ! pio_decomp_tests_1d.F90.in:66


END SUBROUTINE   ! pio_decomp_tests_1d.F90.in:68


! Get a 1d block decomposition with holes
! If has_hole is TRUE, the decomposition is such that
! # All even procs have VEC_LOCAL_SZ * 2 elements
! # (the even procs take all elems from the odd procs)
! # All odd procs have 0 elements
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [1,2,3,4] [] [5,6]
! e.g. 2)    [1,2,3,4] [] [5,6,7,8] []
! If has_hole is FALSE, the data is evenly divided among all procs
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [1,2] [3,4] [5,6]
! e.g. 2)    [1,2] [3,4] [5,6] [7,8]
SUBROUTINE get_1d_bc_with_holes_info(rank, sz, dims, start, count, has_hole)   ! pio_decomp_tests_1d.F90.in:82
  integer, parameter :: VEC_LOCAL_SZ = 7   ! pio_decomp_tests_1d.F90.in:83
  integer, intent(in) :: rank   ! pio_decomp_tests_1d.F90.in:84
  integer, intent(in) :: sz   ! pio_decomp_tests_1d.F90.in:85
  integer, dimension(1), intent(out) :: dims   ! pio_decomp_tests_1d.F90.in:86
  integer, dimension(1), intent(out) :: start   ! pio_decomp_tests_1d.F90.in:87
  integer, dimension(1), intent(out) :: count   ! pio_decomp_tests_1d.F90.in:88
  logical, intent(in) :: has_hole   ! pio_decomp_tests_1d.F90.in:89


  logical :: is_even_rank   ! pio_decomp_tests_1d.F90.in:91
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_tests_1d.F90.in:92
  integer :: iodd, ieven   ! pio_decomp_tests_1d.F90.in:93


  is_even_rank = .false.   ! pio_decomp_tests_1d.F90.in:95
  if (mod(rank, 2) == 0) then   ! pio_decomp_tests_1d.F90.in:96
    is_even_rank = .true.   ! pio_decomp_tests_1d.F90.in:97
  end if   ! pio_decomp_tests_1d.F90.in:98
  num_odd_procs = sz / 2   ! pio_decomp_tests_1d.F90.in:99
  num_even_procs = sz - num_odd_procs   ! pio_decomp_tests_1d.F90.in:100
  dims(1) = VEC_LOCAL_SZ * sz   ! pio_decomp_tests_1d.F90.in:101
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_tests_1d.F90.in:103
  ieven = (rank + 1) / 2   ! pio_decomp_tests_1d.F90.in:104
  if(has_hole) then   ! pio_decomp_tests_1d.F90.in:105
    if (is_even_rank) then   ! pio_decomp_tests_1d.F90.in:106
      if(rank + 1 < sz) then   ! pio_decomp_tests_1d.F90.in:107
        count(1) = VEC_LOCAL_SZ * 2   ! pio_decomp_tests_1d.F90.in:108
      else   ! pio_decomp_tests_1d.F90.in:109
        count(1) = VEC_LOCAL_SZ   ! pio_decomp_tests_1d.F90.in:110
      end if   ! pio_decomp_tests_1d.F90.in:111
      start(1) = ieven * VEC_LOCAL_SZ * 2 + 1   ! pio_decomp_tests_1d.F90.in:112
    else   ! pio_decomp_tests_1d.F90.in:113
      count(1) = 0   ! pio_decomp_tests_1d.F90.in:114
      start(1) = 0   ! pio_decomp_tests_1d.F90.in:115
    end if   ! pio_decomp_tests_1d.F90.in:116
  else   ! pio_decomp_tests_1d.F90.in:117
    count(1) = VEC_LOCAL_SZ   ! pio_decomp_tests_1d.F90.in:118
    start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ) + 1   ! pio_decomp_tests_1d.F90.in:119
  end if   ! pio_decomp_tests_1d.F90.in:120


END SUBROUTINE   ! pio_decomp_tests_1d.F90.in:122


! Test block cyclic interface
! Write with one decomp and read with another
! Test all combs
! - no rearrage read + no rearrange write
! - rearrage read + no rearrange write
! - no rearrage read + rearrange write
! - rearrage read + rearrange write


SUBROUTINE nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  integer(kind=fc_int), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  logical, dimension(2) :: enable_rd_rearr = (/.false., .true./)
  integer :: rd_rearr_opt_idx
  logical, dimension(2) :: enable_wr_rearr = (/.false., .true./)
  integer :: wr_rearr_opt_idx
   ! pio_decomp_tests_1d.F90.in:152
  do rd_rearr_opt_idx=1,size(enable_rd_rearr)
    do wr_rearr_opt_idx=1,size(enable_wr_rearr)

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*, *)  "Testing Rd rearr =", enable_rd_rearr(rd_rearr_opt_idx), ",Write rearr=", enable_wr_rearr(wr_rearr_opt_idx)
        END IF
      END IF
      ! Set the decomposition for writing data - forcing rearrangement
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_wr_rearr(wr_rearr_opt_idx))
      allocate(wbuf(count(1)))
      allocate(compdof(count(1)))
      do i=1,count(1)
        wbuf(i) = start(1) + i - 1
        compdof(i) = start(1) + i - 1
      end do
   ! pio_decomp_tests_1d.F90.in:165
      call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:168
      ! Set the decomposition for reading data - different from the write decomp
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_rd_rearr(rd_rearr_opt_idx))
      allocate(rbuf(count(1)))
      allocate(compdof(count(1)))
      allocate(exp_val(count(1)))
      do i=1,count(1)
        compdof(i) = start(1) + i -1
        ! Expected value, after reading, is the same as the compdof
        exp_val(i) = compdof(i)
      end do
   ! pio_decomp_tests_1d.F90.in:180
      call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:183
      num_iotypes = 0
      call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
      filename = "test_pio_decomp_simple_tests.testfile"
      do i=1,num_iotypes

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
          END IF
        END IF
        ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Could not create file " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:190)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:191
        ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a dim : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:193)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:194
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_int, (/pio_dim/), pio_var1)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:196)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:197
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_int, (/pio_dim/), pio_var2)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:199)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:200
        ierr = PIO_enddef(pio_file)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to end redef mode : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:202)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:203
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:206)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:207
        wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:209
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:212)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:213
        call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:215
        rbuf = 0
        call PIO_read_darray(pio_file, pio_var1, rd_iodesc, rbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to read darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:218)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:219
        
        IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Check failed:",&
               "Got wrong val",&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:220)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:221
        call PIO_closefile(pio_file)
        wbuf = wbuf - 200
        call PIO_deletefile(pio_tf_iosystem_, filename);
      end do
   ! pio_decomp_tests_1d.F90.in:226
      if(allocated(iotypes)) then
        deallocate(iotypes)
        deallocate(iotype_descs)
      end if
   ! pio_decomp_tests_1d.F90.in:231
      call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
      call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
      deallocate(exp_val)
      deallocate(rbuf)
      deallocate(wbuf)
    end do 
  end do 
END SUBROUTINE nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  integer(kind=fc_short), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  logical, dimension(2) :: enable_rd_rearr = (/.false., .true./)
  integer :: rd_rearr_opt_idx
  logical, dimension(2) :: enable_wr_rearr = (/.false., .true./)
  integer :: wr_rearr_opt_idx
   ! pio_decomp_tests_1d.F90.in:152
  do rd_rearr_opt_idx=1,size(enable_rd_rearr)
    do wr_rearr_opt_idx=1,size(enable_wr_rearr)

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*, *)  "Testing Rd rearr =", enable_rd_rearr(rd_rearr_opt_idx), ",Write rearr=", enable_wr_rearr(wr_rearr_opt_idx)
        END IF
      END IF
      ! Set the decomposition for writing data - forcing rearrangement
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_wr_rearr(wr_rearr_opt_idx))
      allocate(wbuf(count(1)))
      allocate(compdof(count(1)))
      do i=1,count(1)
        wbuf(i) = start(1) + i - 1
        compdof(i) = start(1) + i - 1
      end do
   ! pio_decomp_tests_1d.F90.in:165
      call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:168
      ! Set the decomposition for reading data - different from the write decomp
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_rd_rearr(rd_rearr_opt_idx))
      allocate(rbuf(count(1)))
      allocate(compdof(count(1)))
      allocate(exp_val(count(1)))
      do i=1,count(1)
        compdof(i) = start(1) + i -1
        ! Expected value, after reading, is the same as the compdof
        exp_val(i) = compdof(i)
      end do
   ! pio_decomp_tests_1d.F90.in:180
      call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, rd_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:183
      num_iotypes = 0
      call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
      filename = "test_pio_decomp_simple_tests.testfile"
      do i=1,num_iotypes

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
          END IF
        END IF
        ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Could not create file " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:190)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:191
        ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a dim : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:193)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:194
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_short, (/pio_dim/), pio_var1)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:196)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:197
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_short, (/pio_dim/), pio_var2)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:199)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:200
        ierr = PIO_enddef(pio_file)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to end redef mode : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:202)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:203
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:206)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:207
        wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:209
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:212)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:213
        call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:215
        rbuf = 0
        call PIO_read_darray(pio_file, pio_var1, rd_iodesc, rbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to read darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:218)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:219
        
        IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Check failed:",&
               "Got wrong val",&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:220)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:221
        call PIO_closefile(pio_file)
        wbuf = wbuf - 200
        call PIO_deletefile(pio_tf_iosystem_, filename);
      end do
   ! pio_decomp_tests_1d.F90.in:226
      if(allocated(iotypes)) then
        deallocate(iotypes)
        deallocate(iotype_descs)
      end if
   ! pio_decomp_tests_1d.F90.in:231
      call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
      call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
      deallocate(exp_val)
      deallocate(rbuf)
      deallocate(wbuf)
    end do 
  end do 
END SUBROUTINE nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  real(kind=fc_real), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  logical, dimension(2) :: enable_rd_rearr = (/.false., .true./)
  integer :: rd_rearr_opt_idx
  logical, dimension(2) :: enable_wr_rearr = (/.false., .true./)
  integer :: wr_rearr_opt_idx
   ! pio_decomp_tests_1d.F90.in:152
  do rd_rearr_opt_idx=1,size(enable_rd_rearr)
    do wr_rearr_opt_idx=1,size(enable_wr_rearr)

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*, *)  "Testing Rd rearr =", enable_rd_rearr(rd_rearr_opt_idx), ",Write rearr=", enable_wr_rearr(wr_rearr_opt_idx)
        END IF
      END IF
      ! Set the decomposition for writing data - forcing rearrangement
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_wr_rearr(wr_rearr_opt_idx))
      allocate(wbuf(count(1)))
      allocate(compdof(count(1)))
      do i=1,count(1)
        wbuf(i) = start(1) + i - 1
        compdof(i) = start(1) + i - 1
      end do
   ! pio_decomp_tests_1d.F90.in:165
      call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:168
      ! Set the decomposition for reading data - different from the write decomp
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_rd_rearr(rd_rearr_opt_idx))
      allocate(rbuf(count(1)))
      allocate(compdof(count(1)))
      allocate(exp_val(count(1)))
      do i=1,count(1)
        compdof(i) = start(1) + i -1
        ! Expected value, after reading, is the same as the compdof
        exp_val(i) = compdof(i)
      end do
   ! pio_decomp_tests_1d.F90.in:180
      call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:183
      num_iotypes = 0
      call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
      filename = "test_pio_decomp_simple_tests.testfile"
      do i=1,num_iotypes

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
          END IF
        END IF
        ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Could not create file " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:190)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:191
        ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a dim : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:193)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:194
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_real, (/pio_dim/), pio_var1)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:196)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:197
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_real, (/pio_dim/), pio_var2)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:199)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:200
        ierr = PIO_enddef(pio_file)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to end redef mode : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:202)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:203
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:206)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:207
        wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:209
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:212)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:213
        call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:215
        rbuf = 0
        call PIO_read_darray(pio_file, pio_var1, rd_iodesc, rbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to read darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:218)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:219
        
        IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Check failed:",&
               "Got wrong val",&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:220)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:221
        call PIO_closefile(pio_file)
        wbuf = wbuf - 200
        call PIO_deletefile(pio_tf_iosystem_, filename);
      end do
   ! pio_decomp_tests_1d.F90.in:226
      if(allocated(iotypes)) then
        deallocate(iotypes)
        deallocate(iotype_descs)
      end if
   ! pio_decomp_tests_1d.F90.in:231
      call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
      call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
      deallocate(exp_val)
      deallocate(rbuf)
      deallocate(wbuf)
    end do 
  end do 
END SUBROUTINE nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___


SUBROUTINE nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  real(kind=fc_double), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
  logical, dimension(2) :: enable_rd_rearr = (/.false., .true./)
  integer :: rd_rearr_opt_idx
  logical, dimension(2) :: enable_wr_rearr = (/.false., .true./)
  integer :: wr_rearr_opt_idx
   ! pio_decomp_tests_1d.F90.in:152
  do rd_rearr_opt_idx=1,size(enable_rd_rearr)
    do wr_rearr_opt_idx=1,size(enable_wr_rearr)

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*, *)  "Testing Rd rearr =", enable_rd_rearr(rd_rearr_opt_idx), ",Write rearr=", enable_wr_rearr(wr_rearr_opt_idx)
        END IF
      END IF
      ! Set the decomposition for writing data - forcing rearrangement
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_wr_rearr(wr_rearr_opt_idx))
      allocate(wbuf(count(1)))
      allocate(compdof(count(1)))
      do i=1,count(1)
        wbuf(i) = start(1) + i - 1
        compdof(i) = start(1) + i - 1
      end do
   ! pio_decomp_tests_1d.F90.in:165
      call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:168
      ! Set the decomposition for reading data - different from the write decomp
      call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims,&
             start, count, enable_rd_rearr(rd_rearr_opt_idx))
      allocate(rbuf(count(1)))
      allocate(compdof(count(1)))
      allocate(exp_val(count(1)))
      do i=1,count(1)
        compdof(i) = start(1) + i -1
        ! Expected value, after reading, is the same as the compdof
        exp_val(i) = compdof(i)
      end do
   ! pio_decomp_tests_1d.F90.in:180
      call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)
      deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:183
      num_iotypes = 0
      call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
      filename = "test_pio_decomp_simple_tests.testfile"
      do i=1,num_iotypes

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
          END IF
        END IF
        ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Could not create file " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:190)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:191
        ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a dim : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:193)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:194
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_double, (/pio_dim/), pio_var1)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:196)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:197
        ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_double, (/pio_dim/), pio_var2)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to define a var : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:199)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:200
        ierr = PIO_enddef(pio_file)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to end redef mode : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:202)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:203
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:206)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:207
        wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:209
        ! Write the variable out
        call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to write darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:212)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:213
        call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:215
        rbuf = 0
        call PIO_read_darray(pio_file, pio_var1, rd_iodesc, rbuf, ierr)
        
        IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Failed to read darray : " // trim(filename),&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:218)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:219
        
        IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Check failed:",&
               "Got wrong val",&
              ":", __FILE__, ":", __LINE__,&
              "(pio_decomp_tests_1d.F90.in:220)"
          END IF
          RETURN
        END IF
   ! pio_decomp_tests_1d.F90.in:221
        call PIO_closefile(pio_file)
        wbuf = wbuf - 200
        call PIO_deletefile(pio_tf_iosystem_, filename);
      end do
   ! pio_decomp_tests_1d.F90.in:226
      if(allocated(iotypes)) then
        deallocate(iotypes)
        deallocate(iotype_descs)
      end if
   ! pio_decomp_tests_1d.F90.in:231
      call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
      call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
      deallocate(exp_val)
      deallocate(rbuf)
      deallocate(wbuf)
    end do 
  end do 
END SUBROUTINE nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_1d.F90.in:239




SUBROUTINE nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  integer(kind=fc_int), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:258
  ! Set the decomposition for writing data - has holes
  call get_1d_bc_with_holes_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  allocate(wbuf(count(1)))
  allocate(rbuf(count(1)))
  allocate(compdof(count(1)))
  allocate(exp_val(count(1)))
  do i=1,count(1)
    wbuf(i) = start(1) + i - 1
    compdof(i) = int(wbuf(i))
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_tests_1d.F90.in:270
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:273
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:281
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:283)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:284
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:287
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:289)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:290
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:293)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:294
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:296
    call PIO_read_darray(pio_file, pio_var, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:298)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:299
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:300)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:301
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:303
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:306
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:311
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  integer(kind=fc_short), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:258
  ! Set the decomposition for writing data - has holes
  call get_1d_bc_with_holes_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  allocate(wbuf(count(1)))
  allocate(rbuf(count(1)))
  allocate(compdof(count(1)))
  allocate(exp_val(count(1)))
  do i=1,count(1)
    wbuf(i) = start(1) + i - 1
    compdof(i) = int(wbuf(i))
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_tests_1d.F90.in:270
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:273
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:281
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:283)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:284
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:287
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:289)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:290
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:293)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:294
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:296
    call PIO_read_darray(pio_file, pio_var, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:298)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:299
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:300)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:301
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:303
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:306
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:311
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  real(kind=fc_real), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:258
  ! Set the decomposition for writing data - has holes
  call get_1d_bc_with_holes_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  allocate(wbuf(count(1)))
  allocate(rbuf(count(1)))
  allocate(compdof(count(1)))
  allocate(exp_val(count(1)))
  do i=1,count(1)
    wbuf(i) = start(1) + i - 1
    compdof(i) = int(wbuf(i))
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_tests_1d.F90.in:270
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:273
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:281
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:283)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:284
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:287
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:289)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:290
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:293)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:294
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:296
    call PIO_read_darray(pio_file, pio_var, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:298)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:299
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:300)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:301
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:303
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:306
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:311
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___


SUBROUTINE nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(1) :: start, count
  real(kind=fc_double), dimension(:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, ierr
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:258
  ! Set the decomposition for writing data - has holes
  call get_1d_bc_with_holes_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  allocate(wbuf(count(1)))
  allocate(rbuf(count(1)))
  allocate(compdof(count(1)))
  allocate(exp_val(count(1)))
  do i=1,count(1)
    wbuf(i) = start(1) + i - 1
    compdof(i) = int(wbuf(i))
    exp_val(i) = wbuf(i)
  end do
   ! pio_decomp_tests_1d.F90.in:270
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:273
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:280)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:281
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:283)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:284
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, (/pio_dim/), pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:286)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:287
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:289)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:290
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:293)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:294
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:296
    call PIO_read_darray(pio_file, pio_var, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:298)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:299
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:300)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:301
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:303
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:306
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:311
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_1d.F90.in:316




SUBROUTINE nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___
USE pio_tutil

  use mpi, only : MPI_INT
  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof, gcompdof
  integer, dimension(1) :: count
  integer(kind=fc_int), dimension(:), allocatable :: rbuf, wbuf
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, j, ierr
  integer :: tmp
  real :: u
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:338
  ! Set the decomposition for writing data - random order same local size
  count(1) = 4
  dims(1) = count(1)*pio_tf_world_sz_
  if(pio_tf_world_rank_ == 0) then
     allocate(gcompdof(dims(1)))
     gcompdof = 0
     do i=1,dims(1)
        gcompdof(i) = i
     enddo
     do i=dims(1),1,-1
        call random_number(u)
        j = CEILING(real(i)*u)
        tmp = gcompdof(j)
        gcompdof(j) = gcompdof(i)
        gcompdof(i) = tmp
     enddo
  endif
  allocate(compdof(count(1)))
  call mpi_scatter(gcompdof, count(1), MPI_INT, compdof, 4, MPI_INT, 0, pio_tf_comm_, ierr)
  if(allocated(gcompdof)) deallocate(gcompdof)
  allocate(rbuf(count(1)))
  allocate(wbuf(count(1)))
  do i=1,count(1)
    wbuf(i) = compdof(i)
  end do
   ! pio_decomp_tests_1d.F90.in:364
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:367
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:374)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:375
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:378
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_int, (/pio_dim/), pio_var1)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:380)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:381
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_int, (/pio_dim/), pio_var2)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:383)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:384
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:386)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:387
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:390)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:391
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:393
    call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:395)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:396
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:398
   ! pio_decomp_tests_1d.F90.in:399
    call PIO_read_darray(pio_file, pio_var1, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:401)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:402
    wbuf = wbuf - 200
   ! pio_decomp_tests_1d.F90.in:404
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:405)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:406
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:408
    call PIO_read_darray(pio_file, pio_var2, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:410)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:411
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:412)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:413
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:415
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:417
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:420
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:425
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___
USE pio_tutil

  use mpi, only : MPI_INT
  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof, gcompdof
  integer, dimension(1) :: count
  integer(kind=fc_short), dimension(:), allocatable :: rbuf, wbuf
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, j, ierr
  integer :: tmp
  real :: u
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:338
  ! Set the decomposition for writing data - random order same local size
  count(1) = 4
  dims(1) = count(1)*pio_tf_world_sz_
  if(pio_tf_world_rank_ == 0) then
     allocate(gcompdof(dims(1)))
     gcompdof = 0
     do i=1,dims(1)
        gcompdof(i) = i
     enddo
     do i=dims(1),1,-1
        call random_number(u)
        j = CEILING(real(i)*u)
        tmp = gcompdof(j)
        gcompdof(j) = gcompdof(i)
        gcompdof(i) = tmp
     enddo
  endif
  allocate(compdof(count(1)))
  call mpi_scatter(gcompdof, count(1), MPI_INT, compdof, 4, MPI_INT, 0, pio_tf_comm_, ierr)
  if(allocated(gcompdof)) deallocate(gcompdof)
  allocate(rbuf(count(1)))
  allocate(wbuf(count(1)))
  do i=1,count(1)
    wbuf(i) = compdof(i)
  end do
   ! pio_decomp_tests_1d.F90.in:364
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:367
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:374)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:375
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:378
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_short, (/pio_dim/), pio_var1)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:380)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:381
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_short, (/pio_dim/), pio_var2)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:383)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:384
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:386)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:387
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:390)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:391
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:393
    call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:395)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:396
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:398
   ! pio_decomp_tests_1d.F90.in:399
    call PIO_read_darray(pio_file, pio_var1, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:401)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:402
    wbuf = wbuf - 200
   ! pio_decomp_tests_1d.F90.in:404
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:405)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:406
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:408
    call PIO_read_darray(pio_file, pio_var2, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:410)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:411
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:412)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:413
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:415
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:417
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:420
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:425
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___
USE pio_tutil

  use mpi, only : MPI_INT
  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof, gcompdof
  integer, dimension(1) :: count
  real(kind=fc_real), dimension(:), allocatable :: rbuf, wbuf
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, j, ierr
  integer :: tmp
  real :: u
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:338
  ! Set the decomposition for writing data - random order same local size
  count(1) = 4
  dims(1) = count(1)*pio_tf_world_sz_
  if(pio_tf_world_rank_ == 0) then
     allocate(gcompdof(dims(1)))
     gcompdof = 0
     do i=1,dims(1)
        gcompdof(i) = i
     enddo
     do i=dims(1),1,-1
        call random_number(u)
        j = CEILING(real(i)*u)
        tmp = gcompdof(j)
        gcompdof(j) = gcompdof(i)
        gcompdof(i) = tmp
     enddo
  endif
  allocate(compdof(count(1)))
  call mpi_scatter(gcompdof, count(1), MPI_INT, compdof, 4, MPI_INT, 0, pio_tf_comm_, ierr)
  if(allocated(gcompdof)) deallocate(gcompdof)
  allocate(rbuf(count(1)))
  allocate(wbuf(count(1)))
  do i=1,count(1)
    wbuf(i) = compdof(i)
  end do
   ! pio_decomp_tests_1d.F90.in:364
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:367
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:374)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:375
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:378
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_real, (/pio_dim/), pio_var1)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:380)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:381
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_real, (/pio_dim/), pio_var2)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:383)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:384
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:386)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:387
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:390)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:391
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:393
    call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:395)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:396
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:398
   ! pio_decomp_tests_1d.F90.in:399
    call PIO_read_darray(pio_file, pio_var1, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:401)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:402
    wbuf = wbuf - 200
   ! pio_decomp_tests_1d.F90.in:404
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:405)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:406
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:408
    call PIO_read_darray(pio_file, pio_var2, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:410)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:411
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:412)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:413
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:415
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:417
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:420
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:425
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___


SUBROUTINE nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___
USE pio_tutil

  use mpi, only : MPI_INT
  implicit none
  type(var_desc_t)  :: pio_var1, pio_var2
  type(file_desc_t) :: pio_file
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc
  integer, dimension(:), allocatable :: compdof, gcompdof
  integer, dimension(1) :: count
  real(kind=fc_double), dimension(:), allocatable :: rbuf, wbuf
  integer, dimension(1) :: dims
  integer :: pio_dim
  integer :: i, j, ierr
  integer :: tmp
  real :: u
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_1d.F90.in:338
  ! Set the decomposition for writing data - random order same local size
  count(1) = 4
  dims(1) = count(1)*pio_tf_world_sz_
  if(pio_tf_world_rank_ == 0) then
     allocate(gcompdof(dims(1)))
     gcompdof = 0
     do i=1,dims(1)
        gcompdof(i) = i
     enddo
     do i=dims(1),1,-1
        call random_number(u)
        j = CEILING(real(i)*u)
        tmp = gcompdof(j)
        gcompdof(j) = gcompdof(i)
        gcompdof(i) = tmp
     enddo
  endif
  allocate(compdof(count(1)))
  call mpi_scatter(gcompdof, count(1), MPI_INT, compdof, 4, MPI_INT, 0, pio_tf_comm_, ierr)
  if(allocated(gcompdof)) deallocate(gcompdof)
  allocate(rbuf(count(1)))
  allocate(wbuf(count(1)))
  do i=1,count(1)
    wbuf(i) = compdof(i)
  end do
   ! pio_decomp_tests_1d.F90.in:364
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_1d.F90.in:367
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:374)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:375
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim', dims(1), pio_dim)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:377)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:378
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var1', PIO_double, (/pio_dim/), pio_var1)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:380)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:381
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var2', PIO_double, (/pio_dim/), pio_var2)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:383)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:384
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:386)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:387
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var1, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:390)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:391
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:393
    call PIO_write_darray(pio_file, pio_var2, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:395)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:396
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_1d.F90.in:398
   ! pio_decomp_tests_1d.F90.in:399
    call PIO_read_darray(pio_file, pio_var1, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:401)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:402
    wbuf = wbuf - 200
   ! pio_decomp_tests_1d.F90.in:404
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:405)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:406
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:408
    call PIO_read_darray(pio_file, pio_var2, wr_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:410)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:411
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_1d.F90.in:412)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_1d.F90.in:413
    call PIO_closefile(pio_file)
   ! pio_decomp_tests_1d.F90.in:415
    wbuf = wbuf + 200
   ! pio_decomp_tests_1d.F90.in:417
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_1d.F90.in:420
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_1d.F90.in:425
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_1d.F90.in:429


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 13:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 13:",&
          "nc_wr_rd_1d_bc_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 14:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 14:",&
          "nc_wr_rd_1d_bc_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 15:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 15:",&
          "nc_wr_rd_1d_bc_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 16:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 16:",&
          "nc_wr_rd_1d_bc_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 17:",&
          "nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 17:",&
          "nc_wr_1d_bc_with_holes_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 18:",&
          "nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 18:",&
          "nc_wr_1d_bc_with_holes_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 19:",&
          "nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 19:",&
          "nc_wr_1d_bc_with_holes_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 20:",&
          "nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 20:",&
          "nc_wr_1d_bc_with_holes_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 21:",&
          "nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 21:",&
          "nc_wr_1d_bc_random_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 22:",&
          "nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 22:",&
          "nc_wr_1d_bc_random_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 23:",&
          "nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 23:",&
          "nc_wr_1d_bc_random_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 24:",&
          "nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 24:",&
          "nc_wr_1d_bc_random_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
