! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_decomp_tests_2d.F90.in

#include "config.h"
! Get a 2D column decomposition
! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_COL_SZ rows of VEC_ROW_SZ elements
! # All odd procs have  VEC_COL_SZ rows of VEC_ROW_SZ + 1 elements
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2 and ranks 0, 1, 2,
! e.g. 1) |(1,1) (1,2)|  |(1,3) (1,4) (1,5)|  |(1,6) (1,7)|
!         |(2,1) (2,2)|, |(2,3) (2,4) (2,5)|, |(2,6) (2,7)|
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! This for example can be used to force rearrangement when reading
! or writing data.
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2 and ranks 0, 1, 2
! e.g. 1) |(1,3) (1,4) (1,5)|  |(1,1) (1,2)|   |(1,6) (1,7)|
!         |(2,3) (2,4) (2,5)|, |(2,1) (2,2)|,  |(2,6) (2,7)|
SUBROUTINE get_2d_col_decomp_info(rank, sz, dims, start, count, force_rearrange)   ! pio_decomp_tests_2d.F90.in:17
  integer, parameter :: VEC_ROW_SZ = 7   ! pio_decomp_tests_2d.F90.in:18
  integer, parameter :: VEC_COL_SZ = 7   ! pio_decomp_tests_2d.F90.in:19
  integer, parameter :: NDIMS = 2   ! pio_decomp_tests_2d.F90.in:20
  integer, intent(in) :: rank   ! pio_decomp_tests_2d.F90.in:21
  integer, intent(in) :: sz   ! pio_decomp_tests_2d.F90.in:22
  integer, dimension(NDIMS), intent(out) :: dims   ! pio_decomp_tests_2d.F90.in:23
  integer, dimension(NDIMS), intent(out) :: start   ! pio_decomp_tests_2d.F90.in:24
  integer, dimension(NDIMS), intent(out) :: count   ! pio_decomp_tests_2d.F90.in:25
  logical, intent(in) :: force_rearrange   ! pio_decomp_tests_2d.F90.in:26


  logical :: is_even_rank   ! pio_decomp_tests_2d.F90.in:28
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_tests_2d.F90.in:29
  integer :: iodd, ieven   ! pio_decomp_tests_2d.F90.in:30


  is_even_rank = .false.   ! pio_decomp_tests_2d.F90.in:32
  if (mod(rank, 2) == 0) then   ! pio_decomp_tests_2d.F90.in:33
    is_even_rank = .true.   ! pio_decomp_tests_2d.F90.in:34
  end if   ! pio_decomp_tests_2d.F90.in:35
  num_odd_procs = sz / 2   ! pio_decomp_tests_2d.F90.in:36
  num_even_procs = sz - num_odd_procs   ! pio_decomp_tests_2d.F90.in:37
  dims(1) = VEC_COL_SZ   ! pio_decomp_tests_2d.F90.in:38
  dims(2) = num_even_procs * VEC_ROW_SZ + num_odd_procs * (VEC_ROW_SZ + 1)   ! pio_decomp_tests_2d.F90.in:39
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_tests_2d.F90.in:41
  ieven = (rank + 1) / 2   ! pio_decomp_tests_2d.F90.in:42


  ! Rows
  start(1) = 1   ! pio_decomp_tests_2d.F90.in:45
  count(1) = VEC_COL_SZ   ! pio_decomp_tests_2d.F90.in:46


  ! Columns
  if(force_rearrange) then   ! pio_decomp_tests_2d.F90.in:49
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_decomp_tests_2d.F90.in:51
      if(rank + 1 < sz) then   ! pio_decomp_tests_2d.F90.in:52
        ! Force rearrangement
        count(2) = VEC_ROW_SZ + 1   ! pio_decomp_tests_2d.F90.in:54
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + (VEC_ROW_SZ) + 1   ! pio_decomp_tests_2d.F90.in:55
      else   ! pio_decomp_tests_2d.F90.in:56
        count(2) = VEC_ROW_SZ   ! pio_decomp_tests_2d.F90.in:57
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_tests_2d.F90.in:58
      end if   ! pio_decomp_tests_2d.F90.in:59
    else   ! pio_decomp_tests_2d.F90.in:60
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(2) = VEC_ROW_SZ   ! pio_decomp_tests_2d.F90.in:63
      start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) - (VEC_ROW_SZ) + 1   ! pio_decomp_tests_2d.F90.in:64
    end if   ! pio_decomp_tests_2d.F90.in:65
  else   ! pio_decomp_tests_2d.F90.in:66
    if (is_even_rank) then   ! pio_decomp_tests_2d.F90.in:67
      count(2) = VEC_ROW_SZ   ! pio_decomp_tests_2d.F90.in:68
    else   ! pio_decomp_tests_2d.F90.in:69
      count(2) = VEC_ROW_SZ + 1   ! pio_decomp_tests_2d.F90.in:70
    end if   ! pio_decomp_tests_2d.F90.in:71
    start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_tests_2d.F90.in:72
  end if   ! pio_decomp_tests_2d.F90.in:73


END SUBROUTINE   ! pio_decomp_tests_2d.F90.in:75


! Get a 2D row decomposition
! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_COL_SZ rows of VEC_ROW_SZ elements
! # All odd procs have  VEC_COL_SZ+1 rows of VEC_ROW_SZ elements
! e.g. For VEC_ROW_SZ = 6, VEC_COL_SZ = 1 and ranks 0, 1, 2,
! e.g. 1) |(1,1) (1,2) (1,3) (1,4) (1,5) (1,6)|,
!         |(2,1) (2,2) (2,3) (2,4) (2,5) (2,6)|
!         |(3,1) (3,2) (3,3) (3,4) (3,5) (3,6)|,
!         |(4,1) (4,2) (4,3) (4,4) (4,5) (4,6)|
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements (rows) with the next
! higher ranked odd proc.
! This for example can be used to force rearrangement when reading
! or writing data.
! e.g. For VEC_ROW_SZ = 6, VEC_COL_SZ = 1 and ranks 0, 1, 2
! e.g. 1) |(2,1) (2,2) (2,3) (2,4) (2,5) (2,6)|
!         |(3,1) (3,2) (3,3) (3,4) (3,5) (3,6)|,
!         |(1,1) (1,2) (1,3) (1,4) (1,5) (1,6)|,
!         |(4,1) (4,2) (4,3) (4,4) (4,5) (4,6)|
SUBROUTINE get_2d_row_decomp_info(rank, sz, dims, start, count, force_rearrange)   ! pio_decomp_tests_2d.F90.in:96
  integer, parameter :: VEC_COL_SZ = 7   ! pio_decomp_tests_2d.F90.in:97
  integer, parameter :: VEC_ROW_SZ = 7   ! pio_decomp_tests_2d.F90.in:98
  integer, parameter :: NDIMS = 2   ! pio_decomp_tests_2d.F90.in:99
  integer, intent(in) :: rank   ! pio_decomp_tests_2d.F90.in:100
  integer, intent(in) :: sz   ! pio_decomp_tests_2d.F90.in:101
  integer, dimension(NDIMS), intent(out) :: dims   ! pio_decomp_tests_2d.F90.in:102
  integer, dimension(NDIMS), intent(out) :: start   ! pio_decomp_tests_2d.F90.in:103
  integer, dimension(NDIMS), intent(out) :: count   ! pio_decomp_tests_2d.F90.in:104
  logical, intent(in) :: force_rearrange   ! pio_decomp_tests_2d.F90.in:105


  logical :: is_even_rank   ! pio_decomp_tests_2d.F90.in:107
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_tests_2d.F90.in:108
  integer :: iodd, ieven   ! pio_decomp_tests_2d.F90.in:109


  is_even_rank = .false.   ! pio_decomp_tests_2d.F90.in:111
  if (mod(rank, 2) == 0) then   ! pio_decomp_tests_2d.F90.in:112
    is_even_rank = .true.   ! pio_decomp_tests_2d.F90.in:113
  end if   ! pio_decomp_tests_2d.F90.in:114
  num_odd_procs = sz / 2   ! pio_decomp_tests_2d.F90.in:115
  num_even_procs = sz - num_odd_procs   ! pio_decomp_tests_2d.F90.in:116
  dims(1) = num_even_procs * VEC_COL_SZ + num_odd_procs * (VEC_COL_SZ + 1)   ! pio_decomp_tests_2d.F90.in:117
  dims(2) = VEC_ROW_SZ   ! pio_decomp_tests_2d.F90.in:118
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_tests_2d.F90.in:120
  ieven = (rank + 1) / 2   ! pio_decomp_tests_2d.F90.in:121


  ! Rows
  if(force_rearrange) then   ! pio_decomp_tests_2d.F90.in:124
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_decomp_tests_2d.F90.in:126
      if(rank + 1 < sz) then   ! pio_decomp_tests_2d.F90.in:127
        ! Force rearrangement
        count(1) = VEC_COL_SZ + 1   ! pio_decomp_tests_2d.F90.in:129
        start(1) = ieven * VEC_COL_SZ + iodd * (VEC_COL_SZ + 1) + (VEC_COL_SZ) + 1   ! pio_decomp_tests_2d.F90.in:130
      else   ! pio_decomp_tests_2d.F90.in:131
        count(1) = VEC_COL_SZ   ! pio_decomp_tests_2d.F90.in:132
        start(1) = ieven * VEC_COL_SZ + iodd * (VEC_COL_SZ + 1) + 1   ! pio_decomp_tests_2d.F90.in:133
      end if   ! pio_decomp_tests_2d.F90.in:134
    else   ! pio_decomp_tests_2d.F90.in:135
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(1) = VEC_COL_SZ   ! pio_decomp_tests_2d.F90.in:138
      start(1) = ieven * VEC_COL_SZ + iodd * (VEC_COL_SZ + 1) - (VEC_COL_SZ) + 1   ! pio_decomp_tests_2d.F90.in:139
    end if   ! pio_decomp_tests_2d.F90.in:140
  else   ! pio_decomp_tests_2d.F90.in:141
    if (is_even_rank) then   ! pio_decomp_tests_2d.F90.in:142
      count(1) = VEC_COL_SZ   ! pio_decomp_tests_2d.F90.in:143
    else   ! pio_decomp_tests_2d.F90.in:144
      count(1) = VEC_COL_SZ + 1   ! pio_decomp_tests_2d.F90.in:145
    end if   ! pio_decomp_tests_2d.F90.in:146
    start(1) = ieven * VEC_COL_SZ + iodd * (VEC_COL_SZ + 1) + 1   ! pio_decomp_tests_2d.F90.in:147
  end if   ! pio_decomp_tests_2d.F90.in:148


  ! Columns
  start(2) = 1   ! pio_decomp_tests_2d.F90.in:151
  count(2) = VEC_ROW_SZ   ! pio_decomp_tests_2d.F90.in:152


END SUBROUTINE   ! pio_decomp_tests_2d.F90.in:154


! Write with one decomp (to force rearrangement) and read with another (no
! rearrangement)


SUBROUTINE nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_int), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:176
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * nrows + i
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:191
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:194
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * nrows + i
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:211
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:214
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:221)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:222
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:224)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:225
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:227)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:228
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:230)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:231
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:233)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:234
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:237)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:238
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:240
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:242)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:243
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:244)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:245
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:250
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:255
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_short), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:176
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * nrows + i
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:191
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:194
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * nrows + i
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:211
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:214
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:221)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:222
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:224)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:225
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:227)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:228
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:230)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:231
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:233)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:234
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:237)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:238
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:240
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:242)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:243
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:244)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:245
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:250
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:255
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_real), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:176
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * nrows + i
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:191
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:194
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * nrows + i
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:211
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:214
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:221)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:222
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:224)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:225
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:227)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:228
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:230)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:231
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:233)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:234
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:237)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:238
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:240
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:242)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:243
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:244)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:245
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:250
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:255
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___


SUBROUTINE nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_double), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:176
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * nrows + i
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:191
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:194
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * nrows + i
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:211
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:214
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:221)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:222
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:224)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:225
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:227)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:228
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:230)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:231
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:233)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:234
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:237)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:238
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:240
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:242)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:243
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:244)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:245
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:250
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:255
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_2d.F90.in:261


! Write with one decomp (to force rearrangement) and read with another (no
! rearrangement)


SUBROUTINE nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_int), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:283
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
   ! pio_decomp_tests_2d.F90.in:288
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:298
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:301
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:318
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:321
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:328)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:329
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:331)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:332
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:334)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:335
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:337)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:338
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:340)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:341
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:344)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:345
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:347
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:349)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:350
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:351)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:352
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:357
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:362
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_short), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:283
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
   ! pio_decomp_tests_2d.F90.in:288
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:298
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:301
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:318
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:321
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:328)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:329
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:331)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:332
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:334)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:335
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:337)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:338
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:340)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:341
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:344)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:345
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:347
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:349)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:350
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:351)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:352
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:357
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:362
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_real), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:283
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
   ! pio_decomp_tests_2d.F90.in:288
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:298
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:301
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:318
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:321
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:328)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:329
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:331)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:332
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:334)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:335
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:337)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:338
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:340)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:341
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:344)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:345
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:347
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:349)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:350
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:351)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:352
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:357
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:362
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___


SUBROUTINE nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 2
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_double), dimension(:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, tmp_idx, ierr, nrows, ncols
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_2d.F90.in:283
  ! Set the decomposition for writing data - forcing rearrangement
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
   ! pio_decomp_tests_2d.F90.in:288
  allocate(wbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  do j=1,ncols
    do i=1,nrows
      wbuf(i,j) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = int(wbuf(i,j))
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:298
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:301
  ! Set the decomposition for reading data - different from the write decomp
  call get_2d_row_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  
  allocate(rbuf(nrows, ncols))
  allocate(compdof(nrows * ncols))
  allocate(exp_val(nrows, ncols))
  do j=1,ncols
    do i=1,nrows
      tmp_idx = (j - 1) * nrows + i
      compdof(tmp_idx) = (start(2) - 1 + j - 1) * dims(1) + start(1) + i - 1
      ! Expected value, after reading, is the same as the compdof
      exp_val(i,j) = compdof(tmp_idx)
    end do
  end do
   ! pio_decomp_tests_2d.F90.in:318
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_2d.F90.in:321
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:328)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:329
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:331)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:332
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:334)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:335
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:337)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:338
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:340)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:341
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:344)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:345
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_2d.F90.in:347
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:349)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:350
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_2d.F90.in:351)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_2d.F90.in:352
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_2d.F90.in:357
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_2d.F90.in:362
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_2d.F90.in:368


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 5:",&
          "nc_write_read_2d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 6:",&
          "nc_write_read_2d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 7:",&
          "nc_write_read_2d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 8:",&
          "nc_write_read_2d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 9:",&
          "nc_write_read_2d_row_decomp_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 10:",&
          "nc_write_read_2d_row_decomp_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 11:",&
          "nc_write_read_2d_row_decomp_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 12:",&
          "nc_write_read_2d_row_decomp_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
