! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_decomp_tests_3d.F90.in

#include "config.h"
! Get a 3D column decomposition
! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_HGT_SZ blocks of 
! (VEC_COL_SZ rows x VEC_ROW_SZ columns) elements
! # All odd procs have  VEC_HGT_SZ blocks of
! (VEC_COL_SZ rows x VEC_ROW_SZ + 1 columns) elements
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2, VEC_HGT_SZ = 2
! and ranks 0, 1, 2,
! e.g. 1) |(1,1,1) (1,2,1) (2,1,1) (2,2,1)|
!         |(1,1,2) (1,2,2) (2,1,2) (2,2,2)| ,
!         |(1,3,1) (1,4,1) (1,5,1) (2,3,1) (2,4,1) (2,5,1)|
!         |(1,3,2) (1,4,2) (1,5,2) (2,3,2) (2,4,2) (2,5,2)|,
!         |(1,6,1) (1,7,1) (2,6,1) (2,7,1)|
!         |(1,6,2) (1,7,2) (2,6,2) (2,7,2)|
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! e.g. For VEC_ROW_SZ = 2, VEC_COL_SZ = 2, VEC_HGT_SZ = 2
! and ranks 0, 1, 2,
! e.g. 1  |(1,3,1) (1,4,1) (1,5,1) (2,3,1) (2,4,1) (2,5,1)|
!         |(1,3,2) (1,4,2) (1,5,2) (2,3,2) (2,4,2) (2,5,2)|,
!         |(1,1,1) (1,2,1) (2,1,1) (2,2,1)|
!         |(1,1,2) (1,2,2) (2,1,2) (2,2,2)| ,
!         |(1,6,1) (1,7,1) (2,6,1) (2,7,1)|
!         |(1,6,2) (1,7,2) (2,6,2) (2,7,2)|
! This for example can be used to force rearrangement when reading
! or writing data.
SUBROUTINE get_3d_col_decomp_info(rank, sz, dims, start, count, force_rearrange)   ! pio_decomp_tests_3d.F90.in:29
  integer, parameter :: VEC_ROW_SZ = 2   ! pio_decomp_tests_3d.F90.in:30
  integer, parameter :: VEC_COL_SZ = 2   ! pio_decomp_tests_3d.F90.in:31
  integer, parameter :: VEC_HGT_SZ = 2   ! pio_decomp_tests_3d.F90.in:32
  integer, parameter :: NDIMS = 3   ! pio_decomp_tests_3d.F90.in:33
  integer, intent(in) :: rank   ! pio_decomp_tests_3d.F90.in:34
  integer, intent(in) :: sz   ! pio_decomp_tests_3d.F90.in:35
  integer, dimension(NDIMS), intent(out) :: dims   ! pio_decomp_tests_3d.F90.in:36
  integer, dimension(NDIMS), intent(out) :: start   ! pio_decomp_tests_3d.F90.in:37
  integer, dimension(NDIMS), intent(out) :: count   ! pio_decomp_tests_3d.F90.in:38
  logical, intent(in) :: force_rearrange   ! pio_decomp_tests_3d.F90.in:39


  logical :: is_even_rank   ! pio_decomp_tests_3d.F90.in:41
  integer :: num_odd_procs, num_even_procs   ! pio_decomp_tests_3d.F90.in:42
  integer :: iodd, ieven   ! pio_decomp_tests_3d.F90.in:43


  is_even_rank = .false.   ! pio_decomp_tests_3d.F90.in:45
  if (mod(rank, 2) == 0) then   ! pio_decomp_tests_3d.F90.in:46
    is_even_rank = .true.   ! pio_decomp_tests_3d.F90.in:47
  end if   ! pio_decomp_tests_3d.F90.in:48
  num_odd_procs = sz / 2   ! pio_decomp_tests_3d.F90.in:49
  num_even_procs = sz - num_odd_procs   ! pio_decomp_tests_3d.F90.in:50
  dims(1) = VEC_COL_SZ   ! pio_decomp_tests_3d.F90.in:51
  dims(2) = num_even_procs * VEC_ROW_SZ + num_odd_procs * (VEC_ROW_SZ + 1)   ! pio_decomp_tests_3d.F90.in:52
  dims(3) = VEC_HGT_SZ   ! pio_decomp_tests_3d.F90.in:53
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_decomp_tests_3d.F90.in:55
  ieven = (rank + 1) / 2   ! pio_decomp_tests_3d.F90.in:56


  ! Rows
  start(1) = 1   ! pio_decomp_tests_3d.F90.in:59
  count(1) = VEC_COL_SZ   ! pio_decomp_tests_3d.F90.in:60


  ! Columns
  if(force_rearrange) then   ! pio_decomp_tests_3d.F90.in:63
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_decomp_tests_3d.F90.in:65
      if(rank + 1 < sz) then   ! pio_decomp_tests_3d.F90.in:66
        ! Force rearrangement
        count(2) = VEC_ROW_SZ + 1   ! pio_decomp_tests_3d.F90.in:68
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + (VEC_ROW_SZ) + 1   ! pio_decomp_tests_3d.F90.in:69
      else   ! pio_decomp_tests_3d.F90.in:70
        count(2) = VEC_ROW_SZ   ! pio_decomp_tests_3d.F90.in:71
        start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_tests_3d.F90.in:72
      end if   ! pio_decomp_tests_3d.F90.in:73
    else   ! pio_decomp_tests_3d.F90.in:74
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(2) = VEC_ROW_SZ   ! pio_decomp_tests_3d.F90.in:77
      start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) - (VEC_ROW_SZ) + 1   ! pio_decomp_tests_3d.F90.in:78
    end if   ! pio_decomp_tests_3d.F90.in:79
  else   ! pio_decomp_tests_3d.F90.in:80
    if (is_even_rank) then   ! pio_decomp_tests_3d.F90.in:81
      count(2) = VEC_ROW_SZ   ! pio_decomp_tests_3d.F90.in:82
    else   ! pio_decomp_tests_3d.F90.in:83
      count(2) = VEC_ROW_SZ + 1   ! pio_decomp_tests_3d.F90.in:84
    end if   ! pio_decomp_tests_3d.F90.in:85
    start(2) = ieven * VEC_ROW_SZ + iodd * (VEC_ROW_SZ + 1) + 1   ! pio_decomp_tests_3d.F90.in:86
  end if   ! pio_decomp_tests_3d.F90.in:87


  ! Height
  start(3) = 1   ! pio_decomp_tests_3d.F90.in:90
  count(3) = VEC_HGT_SZ   ! pio_decomp_tests_3d.F90.in:91
END SUBROUTINE   ! pio_decomp_tests_3d.F90.in:92


! Write with one decomp (to force rearrangement) and read with another (no
! rearrangement)


SUBROUTINE nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 3
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_int), dimension(:,:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_3d.F90.in:114
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(wbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        wbuf(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) = int(wbuf(i,j,k))
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:133
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:136
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(rbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  allocate(exp_val(nrows, ncols, nhgts))
   ! pio_decomp_tests_3d.F90.in:146
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i
        exp_val(i,j,k) = compdof(tmp_idx)
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:157
  call PIO_initdecomp(pio_tf_iosystem_, PIO_int, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:160
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_int : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:167)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:168
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:170)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:171
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:173)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:176)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:177
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_int, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:179)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:180
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:182)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:183
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:186)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:187
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_3d.F90.in:189
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:191)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:192
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:193)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:194
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_3d.F90.in:199
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_3d.F90.in:204
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___


SUBROUTINE nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 3
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  integer(kind=fc_short), dimension(:,:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_3d.F90.in:114
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(wbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        wbuf(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) = int(wbuf(i,j,k))
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:133
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:136
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(rbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  allocate(exp_val(nrows, ncols, nhgts))
   ! pio_decomp_tests_3d.F90.in:146
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i
        exp_val(i,j,k) = compdof(tmp_idx)
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:157
  call PIO_initdecomp(pio_tf_iosystem_, PIO_short, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:160
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_short : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:167)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:168
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:170)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:171
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:173)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:176)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:177
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_short, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:179)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:180
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:182)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:183
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:186)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:187
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_3d.F90.in:189
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:191)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:192
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:193)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:194
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_3d.F90.in:199
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_3d.F90.in:204
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___


SUBROUTINE nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 3
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_real), dimension(:,:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_3d.F90.in:114
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(wbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        wbuf(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) = int(wbuf(i,j,k))
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:133
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:136
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(rbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  allocate(exp_val(nrows, ncols, nhgts))
   ! pio_decomp_tests_3d.F90.in:146
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i
        exp_val(i,j,k) = compdof(tmp_idx)
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:157
  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:160
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_real : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:167)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:168
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:170)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:171
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:173)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:176)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:177
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_real, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:179)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:180
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:182)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:183
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:186)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:187
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_3d.F90.in:189
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:191)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:192
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:193)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:194
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_3d.F90.in:199
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_3d.F90.in:204
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___


SUBROUTINE nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___
USE pio_tutil

  implicit none
  type(var_desc_t)  :: pio_var
  type(file_desc_t) :: pio_file
  integer, parameter :: NDIMS = 3
  character(len=PIO_TF_MAX_STR_LEN) :: filename
  type(io_desc_t) :: wr_iodesc, rd_iodesc
  integer, dimension(:), allocatable :: compdof
  integer, dimension(NDIMS) :: start, count
  real(kind=fc_double), dimension(:,:,:), allocatable :: rbuf, wbuf, exp_val
  integer, dimension(NDIMS) :: dims
  integer, dimension(NDIMS) :: pio_dims
  integer :: i, j, k, tmp_idx, ierr, nrows, ncols, nhgts
  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs
  integer :: num_iotypes
   ! pio_decomp_tests_3d.F90.in:114
  ! Set the decomposition for writing data - forcing rearrangement
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(wbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        wbuf(i,j,k) = (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                      (start(2) - 1 + j - 1) * dims(1) + i
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) = int(wbuf(i,j,k))
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:133
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, wr_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:136
  ! Set the decomposition for reading data - different from the write decomp
  call get_3d_col_decomp_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .false.)
  nrows = count(1)
  ncols = count(2)
  nhgts = count(3)
  
  allocate(rbuf(nrows, ncols, nhgts))
  allocate(compdof(nrows * ncols * nhgts))
  allocate(exp_val(nrows, ncols, nhgts))
   ! pio_decomp_tests_3d.F90.in:146
  do k=1,nhgts
    do j=1,ncols
      do i=1,nrows
        tmp_idx = (k - 1) * (ncols * nrows) + (j - 1) * nrows + i
        compdof(tmp_idx) =  (start(3) - 1 + k - 1) * (dims(1) * dims(2)) +&
                            (start(2) - 1 + j - 1) * dims(1) + i
        exp_val(i,j,k) = compdof(tmp_idx)
      end do
    end do
  end do
   ! pio_decomp_tests_3d.F90.in:157
  call PIO_initdecomp(pio_tf_iosystem_, PIO_double, dims, compdof, rd_iodesc)
  deallocate(compdof)
   ! pio_decomp_tests_3d.F90.in:160
  num_iotypes = 0
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)
  filename = "test_pio_decomp_simple_tests.testfile"
  do i=1,num_iotypes

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : PIO_double : ", iotype_descs(i)
      END IF
    END IF
    ierr = PIO_createfile(pio_tf_iosystem_, pio_file, iotypes(i), filename, PIO_CLOBBER) 
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Could not create file " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:167)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:168
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_row', dims(1), pio_dims(1))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:170)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:171
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_col', dims(2), pio_dims(2))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:173)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:174
    ierr = PIO_def_dim(pio_file, 'PIO_TF_test_dim_hgt', dims(3), pio_dims(3))
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a dim : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:176)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:177
    ierr = PIO_def_var(pio_file, 'PIO_TF_test_var', PIO_double, pio_dims, pio_var)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define a var : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:179)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:180
    ierr = PIO_enddef(pio_file)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to end redef mode : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:182)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:183
    ! Write the variable out
    call PIO_write_darray(pio_file, pio_var, wr_iodesc, wbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:186)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:187
    call PIO_syncfile(pio_file)
   ! pio_decomp_tests_3d.F90.in:189
    call PIO_read_darray(pio_file, pio_var, rd_iodesc, rbuf, ierr)
    
    IF (.NOT. (PIO_TF_Passert_((ierr) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray : " // trim(filename),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:191)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:192
    
    IF (.NOT. PIO_TF_Check_val_(rbuf, exp_val)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_decomp_tests_3d.F90.in:193)"
      END IF
      RETURN
    END IF
   ! pio_decomp_tests_3d.F90.in:194
    call PIO_closefile(pio_file)
    
    call PIO_deletefile(pio_tf_iosystem_, filename);
  end do
   ! pio_decomp_tests_3d.F90.in:199
  if(allocated(iotypes)) then
    deallocate(iotypes)
    deallocate(iotype_descs)
  end if
   ! pio_decomp_tests_3d.F90.in:204
  call PIO_freedecomp(pio_tf_iosystem_, rd_iodesc)
  call PIO_freedecomp(pio_tf_iosystem_, wr_iodesc)
  deallocate(exp_val)
  deallocate(rbuf)
  deallocate(wbuf)
END SUBROUTINE nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___
   ! pio_decomp_tests_3d.F90.in:210


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___"
    END IF
    CALL nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "nc_write_read_3d_col_decomp_PIO_int_integer_kind_fc_int___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___"
    END IF
    CALL nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "nc_write_read_3d_col_decomp_PIO_short_integer_kind_fc_short___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___"
    END IF
    CALL nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 3:",&
          "nc_write_read_3d_col_decomp_PIO_real_real_kind_fc_real___","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___"
    END IF
    CALL nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 4:",&
          "nc_write_read_3d_col_decomp_PIO_double_real_kind_fc_double___","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
