! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_iosystem_tests.F90.in

#include "config.h"
! Split comm world into two comms (one with even procs and the other
! with odd procs
SUBROUTINE split_world_odd_even(new_comm, new_rank, new_size, is_even)   ! pio_iosystem_tests.F90.in:4
  use mpi   ! pio_iosystem_tests.F90.in:5
  use pio_tutil   ! pio_iosystem_tests.F90.in:6
  implicit none   ! pio_iosystem_tests.F90.in:7
  integer, intent(inout) :: new_comm   ! pio_iosystem_tests.F90.in:8
  integer, intent(inout) :: new_rank   ! pio_iosystem_tests.F90.in:9
  integer, intent(inout) :: new_size   ! pio_iosystem_tests.F90.in:10
  logical, intent(inout) :: is_even   ! pio_iosystem_tests.F90.in:11


  integer :: ierr   ! pio_iosystem_tests.F90.in:13
  integer :: color   ! pio_iosystem_tests.F90.in:14


  new_comm = MPI_COMM_NULL   ! pio_iosystem_tests.F90.in:16
  new_rank = 0   ! pio_iosystem_tests.F90.in:17
  new_size = 0   ! pio_iosystem_tests.F90.in:18


  if(mod(pio_tf_world_rank_, 2) == 0) then   ! pio_iosystem_tests.F90.in:20
    is_even = .true.   ! pio_iosystem_tests.F90.in:21
    color = 1   ! pio_iosystem_tests.F90.in:22
  else   ! pio_iosystem_tests.F90.in:23
    is_even = .false.   ! pio_iosystem_tests.F90.in:24
    color = 0   ! pio_iosystem_tests.F90.in:25
  end if   ! pio_iosystem_tests.F90.in:26


  call MPI_Comm_split(pio_tf_comm_, color, 0, new_comm, ierr)   ! pio_iosystem_tests.F90.in:28


  call MPI_Comm_rank(new_comm, new_rank, ierr)   ! pio_iosystem_tests.F90.in:30
  call MPI_Comm_size(new_comm, new_size, ierr)   ! pio_iosystem_tests.F90.in:31
END SUBROUTINE split_world_odd_even   ! pio_iosystem_tests.F90.in:32


SUBROUTINE split_world_only_even(new_comm, new_rank, new_size, is_even)   ! pio_iosystem_tests.F90.in:34
  use mpi   ! pio_iosystem_tests.F90.in:35
  use pio_tutil   ! pio_iosystem_tests.F90.in:36
  implicit none   ! pio_iosystem_tests.F90.in:37
  integer, intent(inout) :: new_comm   ! pio_iosystem_tests.F90.in:38
  integer, intent(inout) :: new_rank   ! pio_iosystem_tests.F90.in:39
  integer, intent(inout) :: new_size   ! pio_iosystem_tests.F90.in:40
  logical, intent(inout) :: is_even   ! pio_iosystem_tests.F90.in:41


  integer :: ierr   ! pio_iosystem_tests.F90.in:43
  integer :: color   ! pio_iosystem_tests.F90.in:44


  new_comm = MPI_COMM_NULL   ! pio_iosystem_tests.F90.in:46
  new_rank = 0   ! pio_iosystem_tests.F90.in:47
  new_size = 0   ! pio_iosystem_tests.F90.in:48


  if(mod(pio_tf_world_rank_, 2) == 0) then   ! pio_iosystem_tests.F90.in:50
    is_even = .true.   ! pio_iosystem_tests.F90.in:51
    color = 1   ! pio_iosystem_tests.F90.in:52
  else   ! pio_iosystem_tests.F90.in:53
    is_even = .false.   ! pio_iosystem_tests.F90.in:54
    color = MPI_UNDEFINED   ! pio_iosystem_tests.F90.in:55
  end if   ! pio_iosystem_tests.F90.in:56


  call MPI_Comm_split(pio_tf_comm_, color, 0, new_comm, ierr)   ! pio_iosystem_tests.F90.in:58


  if(new_comm /= MPI_COMM_NULL) then   ! pio_iosystem_tests.F90.in:60
    call MPI_Comm_rank(new_comm, new_rank, ierr)   ! pio_iosystem_tests.F90.in:61
    call MPI_Comm_size(new_comm, new_size, ierr)   ! pio_iosystem_tests.F90.in:62
  end if   ! pio_iosystem_tests.F90.in:63
END SUBROUTINE split_world_only_even   ! pio_iosystem_tests.F90.in:64


! Create a file with a global attribute (filename)
SUBROUTINE create_file(comm, iosys, iotype, fname, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:67
    use pio_tutil   ! pio_iosystem_tests.F90.in:68
    implicit none   ! pio_iosystem_tests.F90.in:69


    integer, intent(in) :: comm   ! pio_iosystem_tests.F90.in:71
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_iosystem_tests.F90.in:72
    integer, intent(in) :: iotype   ! pio_iosystem_tests.F90.in:73
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests.F90.in:74
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests.F90.in:75
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests.F90.in:76
    integer, intent(inout) :: ret   ! pio_iosystem_tests.F90.in:77


    type(file_desc_t) :: pio_file   ! pio_iosystem_tests.F90.in:79
    integer :: pio_dim   ! pio_iosystem_tests.F90.in:80
    type(var_desc_t) :: pio_var   ! pio_iosystem_tests.F90.in:81


    ret = PIO_createfile(iosys, pio_file, iotype, fname, PIO_CLOBBER)   ! pio_iosystem_tests.F90.in:83
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create dummy file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:84)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:84


    ret = PIO_def_dim(pio_file, dimname, PIO_TF_MAX_STR_LEN, pio_dim)   ! pio_iosystem_tests.F90.in:86
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define dim "// trim(dimname) // "in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:87)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:87


    ret = PIO_def_var(pio_file, attname, PIO_char, (/pio_dim/), pio_var)   ! pio_iosystem_tests.F90.in:89
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define var " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:90)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:90


    ret = PIO_put_att(pio_file, pio_var, attname, fname)   ! pio_iosystem_tests.F90.in:92
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to put att " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:93)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:93


    call PIO_closefile(pio_file)   ! pio_iosystem_tests.F90.in:95
END SUBROUTINE create_file   ! pio_iosystem_tests.F90.in:96


! Check the contents of file : Check the
! global attribute 'filename' (should be equal to the
! name of the file, fname)
SUBROUTINE check_file(comm, pio_file, fname, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:101
    use pio_tutil   ! pio_iosystem_tests.F90.in:102
    implicit none   ! pio_iosystem_tests.F90.in:103


    integer, intent(in) :: comm   ! pio_iosystem_tests.F90.in:105
    type(file_desc_t), intent(inout) :: pio_file   ! pio_iosystem_tests.F90.in:106
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests.F90.in:107
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests.F90.in:108
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests.F90.in:109
    integer, intent(inout) :: ret   ! pio_iosystem_tests.F90.in:110


    integer :: pio_dim   ! pio_iosystem_tests.F90.in:112
    type(var_desc_t) :: pio_var   ! pio_iosystem_tests.F90.in:113
    character(len=PIO_TF_MAX_STR_LEN) :: val   ! pio_iosystem_tests.F90.in:114


    ret = PIO_inq_dimid(pio_file, dimname, pio_dim)   ! pio_iosystem_tests.F90.in:116
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to find dim "// trim(dimname) // "in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:117)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:117


    ret = PIO_inq_varid(pio_file, attname, pio_var)   ! pio_iosystem_tests.F90.in:119
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to find var " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:120)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:120


    ret = PIO_get_att(pio_file, pio_var, attname, val)   ! pio_iosystem_tests.F90.in:122
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to get att " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:123)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:123


    PRINT *, "val = ", trim(val), ", fname =", trim(fname)   ! pio_iosystem_tests.F90.in:125
    
    IF (.NOT. (PIO_TF_Passert_(val .eq. fname,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: Assertion failed :",&
           "Attribute value is not the expected value",&
           ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:126)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:126
END SUBROUTINE check_file   ! pio_iosystem_tests.F90.in:127


! Open and check the contents of file : open it and check the
! global attribute 'filename' (should be equal to the
! name of the file, fname)
SUBROUTINE open_and_check_file(comm, iosys, iotype, pio_file, fname, &
                      attname, dimname, disable_fclose, ret)   ! pio_iosystem_tests.F90.in:133
    use pio_tutil   ! pio_iosystem_tests.F90.in:134
    implicit none   ! pio_iosystem_tests.F90.in:135


    integer, intent(in) :: comm   ! pio_iosystem_tests.F90.in:137
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_iosystem_tests.F90.in:138
    integer, intent(in) :: iotype   ! pio_iosystem_tests.F90.in:139
    type(file_desc_t), intent(inout) :: pio_file   ! pio_iosystem_tests.F90.in:140
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests.F90.in:141
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests.F90.in:142
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests.F90.in:143
    logical, intent(in) :: disable_fclose   ! pio_iosystem_tests.F90.in:144
    integer, intent(inout) :: ret   ! pio_iosystem_tests.F90.in:145


    ret = PIO_openfile(iosys, pio_file, iotype, fname, PIO_write)   ! pio_iosystem_tests.F90.in:147
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to open:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:148)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:148


    call check_file(comm, pio_file, fname, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:150
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:151)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:151


    if(.not. disable_fclose) then   ! pio_iosystem_tests.F90.in:153
      call PIO_closefile(pio_file)   ! pio_iosystem_tests.F90.in:154
    end if   ! pio_iosystem_tests.F90.in:155
END SUBROUTINE open_and_check_file   ! pio_iosystem_tests.F90.in:156


! Create a file with one iosystem - with all procs, and open/read with
! another iosystem - subset (odd/even) of procs
SUBROUTINE two_iosystems_odd_even
  USE pio_tutil
   ! pio_iosystem_tests.F90.in:160
  implicit none   ! pio_iosystem_tests.F90.in:161


  character(len=PIO_TF_MAX_STR_LEN), target :: fname1 = "pio_iosys_test_file1.nc"   ! pio_iosystem_tests.F90.in:163
  character(len=PIO_TF_MAX_STR_LEN), target :: fname2 = "pio_iosys_test_file2.nc"   ! pio_iosystem_tests.F90.in:164
  character(len=PIO_TF_MAX_STR_LEN), parameter :: attname = "filename"   ! pio_iosystem_tests.F90.in:165
  character(len=PIO_TF_MAX_STR_LEN), parameter :: dimname = "filename_dim"   ! pio_iosystem_tests.F90.in:166
  character(len=PIO_TF_MAX_STR_LEN), pointer :: fname   ! pio_iosystem_tests.F90.in:167
  integer, dimension(:), allocatable :: iotypes   ! pio_iosystem_tests.F90.in:168
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_iosystem_tests.F90.in:169
  integer :: i, num_iotypes = 0   ! pio_iosystem_tests.F90.in:170
  type(file_desc_t) :: pio_file   ! pio_iosystem_tests.F90.in:171


  type(iosystem_desc_t) :: odd_even_iosys   ! pio_iosystem_tests.F90.in:173
  integer :: odd_even_comm, odd_even_comm_rank, odd_even_comm_size   ! pio_iosystem_tests.F90.in:174
  logical :: is_even   ! pio_iosystem_tests.F90.in:175
  integer :: ret   ! pio_iosystem_tests.F90.in:176


  ! Split world to odd and even procs
  call split_world_odd_even(odd_even_comm, odd_even_comm_rank, odd_even_comm_size, is_even)   ! pio_iosystem_tests.F90.in:179


  call PIO_init(odd_even_comm_rank, odd_even_comm, odd_even_comm_size, &
                1, &! Num aggregators
                1, &! Stride
                PIO_rearr_subset, odd_even_iosys, base=0)   ! pio_iosystem_tests.F90.in:184
  call PIO_seterrorhandling(odd_even_iosys, PIO_BCAST_ERROR)   ! pio_iosystem_tests.F90.in:185


  ! Open two different files and close it with two different iosystems
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_iosystem_tests.F90.in:188
  do i=1,num_iotypes   ! pio_iosystem_tests.F90.in:189

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : ", iotype_descs(i)
      END IF
    END IF   ! pio_iosystem_tests.F90.in:190
    ! Create two files to be opened later - world - all procs
    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname1, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:193
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname1,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:194)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:194


    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname2, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:197
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname2,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:198)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:198


    ! Open file1 from odd processes and file2 from even processes
    if(is_even) then   ! pio_iosystem_tests.F90.in:201
      fname => fname1   ! pio_iosystem_tests.F90.in:202
    else   ! pio_iosystem_tests.F90.in:203
      fname => fname2   ! pio_iosystem_tests.F90.in:204
    end if   ! pio_iosystem_tests.F90.in:205


    call open_and_check_file(odd_even_comm, odd_even_iosys, iotypes(i), &
                    pio_file, fname, attname, dimname, .false., ret)   ! pio_iosystem_tests.F90.in:208
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:209)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:209
  end do   ! pio_iosystem_tests.F90.in:210


  call PIO_finalize(odd_even_iosys, ret)   ! pio_iosystem_tests.F90.in:212
  call MPI_Comm_free(odd_even_comm, ret)   ! pio_iosystem_tests.F90.in:213
  if(allocated(iotypes)) then   ! pio_iosystem_tests.F90.in:214
    deallocate(iotypes)   ! pio_iosystem_tests.F90.in:215
    deallocate(iotype_descs)   ! pio_iosystem_tests.F90.in:216
  end if   ! pio_iosystem_tests.F90.in:217
END SUBROUTINE two_iosystems_odd_even   ! pio_iosystem_tests.F90.in:218


! Create a file with one iosystem - with all procs, and open/read with
! two iosystems - (1) with all procs (2) subset (even) of procs
SUBROUTINE two_iosystems_even_all
  USE pio_tutil
   ! pio_iosystem_tests.F90.in:222
  implicit none   ! pio_iosystem_tests.F90.in:223


  character(len=PIO_TF_MAX_STR_LEN), target :: fname1 = "pio_iosys_test_file1.nc"   ! pio_iosystem_tests.F90.in:225
  character(len=PIO_TF_MAX_STR_LEN), target :: fname2 = "pio_iosys_test_file2.nc"   ! pio_iosystem_tests.F90.in:226
  character(len=PIO_TF_MAX_STR_LEN), parameter :: attname = "filename"   ! pio_iosystem_tests.F90.in:227
  character(len=PIO_TF_MAX_STR_LEN), parameter :: dimname = "filename_dim"   ! pio_iosystem_tests.F90.in:228
  integer, dimension(:), allocatable :: iotypes   ! pio_iosystem_tests.F90.in:229
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_iosystem_tests.F90.in:230
  integer :: i, num_iotypes = 0   ! pio_iosystem_tests.F90.in:231
  type(file_desc_t) :: pio_file1, pio_file2   ! pio_iosystem_tests.F90.in:232


  type(iosystem_desc_t) :: odd_even_iosys   ! pio_iosystem_tests.F90.in:234
  integer :: odd_even_comm, odd_even_comm_rank, odd_even_comm_size   ! pio_iosystem_tests.F90.in:235
  logical :: is_even   ! pio_iosystem_tests.F90.in:236
  logical :: disable_fclose = .true.   ! pio_iosystem_tests.F90.in:237
  integer :: ret   ! pio_iosystem_tests.F90.in:238


  ! Split world to odd and even procs
  call split_world_only_even(odd_even_comm, odd_even_comm_rank, odd_even_comm_size, is_even)   ! pio_iosystem_tests.F90.in:241


  if(is_even) then   ! pio_iosystem_tests.F90.in:243
    call PIO_init(odd_even_comm_rank, odd_even_comm, odd_even_comm_size, &
                  1, &! Num aggregators
                  1, &! Stride
                  PIO_rearr_subset, odd_even_iosys, base=0)   ! pio_iosystem_tests.F90.in:247
    call PIO_seterrorhandling(odd_even_iosys, PIO_BCAST_ERROR)   ! pio_iosystem_tests.F90.in:248
  end if   ! pio_iosystem_tests.F90.in:249


  ! Open two different files and close it with two different iosystems
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_iosystem_tests.F90.in:252
  do i=1,num_iotypes   ! pio_iosystem_tests.F90.in:253

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : ", iotype_descs(i)
      END IF
    END IF   ! pio_iosystem_tests.F90.in:254
    ! Create two files to be opened later - world - all procs
    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname1, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:257
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname1,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:258)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:258


    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname2, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:261
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname2,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:262)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:262


    ! Open file1 from all even processes and file2 from all odd processes
    ! - PIO called from all processes with the odd_even_iosys
    if(is_even) then   ! pio_iosystem_tests.F90.in:266
      call open_and_check_file(odd_even_comm, odd_even_iosys, iotypes(i), &
                    pio_file1, fname1, attname, dimname, disable_fclose, ret)   ! pio_iosystem_tests.F90.in:268
      PRINT *, "file1,", trim(fname1), "fh: ", pio_file1%fh   ! pio_iosystem_tests.F90.in:269
    end if   ! pio_iosystem_tests.F90.in:270
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname1,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:271)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:271


    call open_and_check_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                    pio_file2, fname2, attname, dimname, disable_fclose, ret)   ! pio_iosystem_tests.F90.in:274
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname2,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:275)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:275
    PRINT *, "file2,", trim(fname2), "fh: ", pio_file2%fh   ! pio_iosystem_tests.F90.in:276


    ! Check contents of the files again
    ! - PIO called from odd and even processes separately with odd_even_iosys
    if(is_even) then   ! pio_iosystem_tests.F90.in:280
      call check_file(odd_even_comm, pio_file1, &
                      fname1, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:282
      !call PIO_closefile(pio_file1)
    end if   ! pio_iosystem_tests.F90.in:284
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname1,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:285)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:285


    call check_file(pio_tf_comm_, pio_file2, &
                    fname2, attname, dimname, ret)   ! pio_iosystem_tests.F90.in:288
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname2,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests.F90.in:289)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests.F90.in:289


    if(disable_fclose) then   ! pio_iosystem_tests.F90.in:291
      if(is_even) then   ! pio_iosystem_tests.F90.in:292
        call PIO_closefile(pio_file1)   ! pio_iosystem_tests.F90.in:293
      end if   ! pio_iosystem_tests.F90.in:294
      call PIO_closefile(pio_file2)   ! pio_iosystem_tests.F90.in:295
    end if   ! pio_iosystem_tests.F90.in:296
  end do   ! pio_iosystem_tests.F90.in:297


  if(is_even) then   ! pio_iosystem_tests.F90.in:299
    call PIO_finalize(odd_even_iosys, ret)   ! pio_iosystem_tests.F90.in:300
    call MPI_Comm_free(odd_even_comm, ret)   ! pio_iosystem_tests.F90.in:301
  end if   ! pio_iosystem_tests.F90.in:302
  if(allocated(iotypes)) then   ! pio_iosystem_tests.F90.in:303
    deallocate(iotypes)   ! pio_iosystem_tests.F90.in:304
    deallocate(iotype_descs)   ! pio_iosystem_tests.F90.in:305
  end if   ! pio_iosystem_tests.F90.in:306
END SUBROUTINE two_iosystems_even_all   ! pio_iosystem_tests.F90.in:307


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting two_iosystems_odd_even"
    END IF
    CALL two_iosystems_odd_even()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "two_iosystems_odd_even","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "two_iosystems_odd_even","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting two_iosystems_even_all"
    END IF
    CALL two_iosystems_even_all()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "two_iosystems_even_all","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "two_iosystems_even_all","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
