! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_iosystem_tests3.F90.in

#include "config.h"
! Split comm world into two comms (even procs and odd procs) and
! rank == overlapped_rank included in both comms
SUBROUTINE split_world_two_with_overlap(new_comms, new_ranks, new_sizes, overlapped_rank)   ! pio_iosystem_tests3.F90.in:4
  use mpi   ! pio_iosystem_tests3.F90.in:5
  use pio_tutil   ! pio_iosystem_tests3.F90.in:6
  implicit none   ! pio_iosystem_tests3.F90.in:7
  integer, parameter :: NUM_COMMS = 2   ! pio_iosystem_tests3.F90.in:8
  integer, dimension(NUM_COMMS), intent(inout) :: new_comms   ! pio_iosystem_tests3.F90.in:9
  integer, dimension(NUM_COMMS), intent(inout) :: new_ranks   ! pio_iosystem_tests3.F90.in:10
  integer, dimension(NUM_COMMS), intent(inout) :: new_sizes   ! pio_iosystem_tests3.F90.in:11
  integer, intent(in) :: overlapped_rank   ! pio_iosystem_tests3.F90.in:12


  integer :: i, ierr   ! pio_iosystem_tests3.F90.in:14
  integer :: world_group   ! pio_iosystem_tests3.F90.in:15
  ! first group range (first rank, last rank, stride) for including rank=overlapped_rank
  ! second group range (first rank, last rank, stride) for other procs
  !   strided depending on number of comms
  ! Note: NUM_GROUP_RANGES is always 2, indep of value of NUM_COMMS
  integer, parameter :: NUM_GROUP_RANGES = 2   ! pio_iosystem_tests3.F90.in:20
  integer :: nranges   ! pio_iosystem_tests3.F90.in:21
  integer, dimension(3,NUM_GROUP_RANGES) :: new_group_ranges   ! pio_iosystem_tests3.F90.in:22
  integer, dimension(NUM_COMMS) :: new_groups   ! pio_iosystem_tests3.F90.in:23


  do i=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:25
    new_comms(i) = MPI_COMM_NULL   ! pio_iosystem_tests3.F90.in:26
    new_ranks(i) = -1   ! pio_iosystem_tests3.F90.in:27
    new_sizes(i) = 0   ! pio_iosystem_tests3.F90.in:28
  end do   ! pio_iosystem_tests3.F90.in:29


  call MPI_Comm_group(pio_tf_comm_, world_group, ierr)   ! pio_iosystem_tests3.F90.in:31


  do i=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:33
    if(pio_tf_world_sz_ == 1) then   ! pio_iosystem_tests3.F90.in:34
      nranges = 1   ! pio_iosystem_tests3.F90.in:35
      new_group_ranges(1,1) = overlapped_rank   ! pio_iosystem_tests3.F90.in:36
      new_group_ranges(2,1) = overlapped_rank   ! pio_iosystem_tests3.F90.in:37
      new_group_ranges(3,1) = 1   ! pio_iosystem_tests3.F90.in:38
    else if(overlapped_rank / NUM_COMMS /= i-1) then   ! pio_iosystem_tests3.F90.in:39
      nranges = 2   ! pio_iosystem_tests3.F90.in:40
      ! Include rank == overlapped_rank
      new_group_ranges(1,1) = overlapped_rank   ! pio_iosystem_tests3.F90.in:42
      new_group_ranges(2,1) = overlapped_rank   ! pio_iosystem_tests3.F90.in:43
      new_group_ranges(3,1) = 1   ! pio_iosystem_tests3.F90.in:44


      ! Include other processes split evenly among NUM_COMMS
      new_group_ranges(1,2) = i-1   ! pio_iosystem_tests3.F90.in:47
      new_group_ranges(2,2) = i-1 + (pio_tf_world_sz_/NUM_COMMS - 1) * NUM_COMMS   ! pio_iosystem_tests3.F90.in:48
      new_group_ranges(3,2) = NUM_COMMS   ! pio_iosystem_tests3.F90.in:49
    else   ! pio_iosystem_tests3.F90.in:50
      nranges = 1   ! pio_iosystem_tests3.F90.in:51
      ! Include processes split evenly among NUM_COMMS
      ! rank == overlapped_rank is already included in this range
      new_group_ranges(1,1) = i-1   ! pio_iosystem_tests3.F90.in:54
      new_group_ranges(2,1) = i-1 + (pio_tf_world_sz_/NUM_COMMS - 1) * NUM_COMMS   ! pio_iosystem_tests3.F90.in:55
      new_group_ranges(3,1) = NUM_COMMS   ! pio_iosystem_tests3.F90.in:56
    end if   ! pio_iosystem_tests3.F90.in:57


    call MPI_Group_range_incl(world_group, nranges, new_group_ranges,&
          new_groups(i), ierr)   ! pio_iosystem_tests3.F90.in:60
  end do   ! pio_iosystem_tests3.F90.in:61


  call MPI_Group_free(world_group, ierr)   ! pio_iosystem_tests3.F90.in:63


  ! Create communicators corresponding to the groups
  ! All the communicators will have rank == overlapped_rank and are
  ! disjoint otherwise
  do i=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:68
    call MPI_Comm_create(pio_tf_comm_, new_groups(i), new_comms(i), ierr)   ! pio_iosystem_tests3.F90.in:69
    call MPI_Group_free(new_groups(i), ierr)   ! pio_iosystem_tests3.F90.in:70
    if(new_comms(i) /= MPI_COMM_NULL) then   ! pio_iosystem_tests3.F90.in:71
      call MPI_Comm_rank(new_comms(i), new_ranks(i), ierr)   ! pio_iosystem_tests3.F90.in:72
      call MPI_Comm_size(new_comms(i), new_sizes(i), ierr)   ! pio_iosystem_tests3.F90.in:73
    else   ! pio_iosystem_tests3.F90.in:74
      new_ranks(i) = -1   ! pio_iosystem_tests3.F90.in:75
      new_sizes(i) = 0   ! pio_iosystem_tests3.F90.in:76
    end if   ! pio_iosystem_tests3.F90.in:77
  end do   ! pio_iosystem_tests3.F90.in:78


END SUBROUTINE split_world_two_with_overlap   ! pio_iosystem_tests3.F90.in:80


! Create a file with a global attribute (filename)
SUBROUTINE create_file(comm, iosys, iotype, fname, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:83
    use pio_tutil   ! pio_iosystem_tests3.F90.in:84
    implicit none   ! pio_iosystem_tests3.F90.in:85


    integer, intent(in) :: comm   ! pio_iosystem_tests3.F90.in:87
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_iosystem_tests3.F90.in:88
    integer, intent(in) :: iotype   ! pio_iosystem_tests3.F90.in:89
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests3.F90.in:90
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests3.F90.in:91
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests3.F90.in:92
    integer, intent(inout) :: ret   ! pio_iosystem_tests3.F90.in:93


    type(file_desc_t) :: pio_file   ! pio_iosystem_tests3.F90.in:95
    integer :: pio_dim   ! pio_iosystem_tests3.F90.in:96
    type(var_desc_t) :: pio_var   ! pio_iosystem_tests3.F90.in:97


    ret = PIO_createfile(iosys, pio_file, iotype, fname, PIO_CLOBBER)   ! pio_iosystem_tests3.F90.in:99
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create dummy file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:100)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:100


    ret = PIO_def_dim(pio_file, dimname, PIO_TF_MAX_STR_LEN, pio_dim)   ! pio_iosystem_tests3.F90.in:102
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define dim "// trim(dimname) // "in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:103)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:103


    ret = PIO_def_var(pio_file, attname, PIO_char, (/pio_dim/), pio_var)   ! pio_iosystem_tests3.F90.in:105
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define var " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:106)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:106


    ret = PIO_put_att(pio_file, pio_var, attname, fname)   ! pio_iosystem_tests3.F90.in:108
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to put att " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:109)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:109


    call PIO_closefile(pio_file)   ! pio_iosystem_tests3.F90.in:111
END SUBROUTINE create_file   ! pio_iosystem_tests3.F90.in:112


! Check the contents of file : Check the
! global attribute 'filename' (should be equal to the
! name of the file, fname)
SUBROUTINE check_file(comm, pio_file, fname, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:117
    use pio_tutil   ! pio_iosystem_tests3.F90.in:118
    implicit none   ! pio_iosystem_tests3.F90.in:119


    integer, intent(in) :: comm   ! pio_iosystem_tests3.F90.in:121
    type(file_desc_t), intent(inout) :: pio_file   ! pio_iosystem_tests3.F90.in:122
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests3.F90.in:123
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests3.F90.in:124
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests3.F90.in:125
    integer, intent(inout) :: ret   ! pio_iosystem_tests3.F90.in:126


    integer :: pio_dim   ! pio_iosystem_tests3.F90.in:128
    type(var_desc_t) :: pio_var   ! pio_iosystem_tests3.F90.in:129
    character(len=PIO_TF_MAX_STR_LEN) :: val   ! pio_iosystem_tests3.F90.in:130


    ret = PIO_inq_dimid(pio_file, dimname, pio_dim)   ! pio_iosystem_tests3.F90.in:132
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to find dim "// trim(dimname) // "in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:133)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:133


    ret = PIO_inq_varid(pio_file, attname, pio_var)   ! pio_iosystem_tests3.F90.in:135
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to find var " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:136)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:136


    ret = PIO_get_att(pio_file, pio_var, attname, val)   ! pio_iosystem_tests3.F90.in:138
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to get att " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:139)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:139


    PRINT *, "val = ", trim(val), ", fname =", trim(fname)   ! pio_iosystem_tests3.F90.in:141
    
    IF (.NOT. (PIO_TF_Passert_(val .eq. fname,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: Assertion failed :",&
           "Attribute value is not the expected value",&
           ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:142)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:142
END SUBROUTINE check_file   ! pio_iosystem_tests3.F90.in:143


! Open and check the contents of file : open it and check the
! global attribute 'filename' (should be equal to the
! name of the file, fname)
SUBROUTINE open_and_check_file(comm, iosys, iotype, pio_file, fname, &
                      attname, dimname, disable_fclose, ret)   ! pio_iosystem_tests3.F90.in:149
    use pio_tutil   ! pio_iosystem_tests3.F90.in:150
    implicit none   ! pio_iosystem_tests3.F90.in:151


    integer, intent(in) :: comm   ! pio_iosystem_tests3.F90.in:153
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_iosystem_tests3.F90.in:154
    integer, intent(in) :: iotype   ! pio_iosystem_tests3.F90.in:155
    type(file_desc_t), intent(inout) :: pio_file   ! pio_iosystem_tests3.F90.in:156
    character(len=*), intent(in) :: fname   ! pio_iosystem_tests3.F90.in:157
    character(len=*), intent(in) :: attname   ! pio_iosystem_tests3.F90.in:158
    character(len=*), intent(in) :: dimname   ! pio_iosystem_tests3.F90.in:159
    logical, intent(in) :: disable_fclose   ! pio_iosystem_tests3.F90.in:160
    integer, intent(inout) :: ret   ! pio_iosystem_tests3.F90.in:161


    ret = PIO_openfile(iosys, pio_file, iotype, fname, PIO_write)   ! pio_iosystem_tests3.F90.in:163
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to open:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:164)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:164


    call check_file(comm, pio_file, fname, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:166
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:167)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:167


    if(.not. disable_fclose) then   ! pio_iosystem_tests3.F90.in:169
      call PIO_closefile(pio_file)   ! pio_iosystem_tests3.F90.in:170
    end if   ! pio_iosystem_tests3.F90.in:171
END SUBROUTINE open_and_check_file   ! pio_iosystem_tests3.F90.in:172


! Create three files with one iosystem - with all procs, and open/read with
! two different iosystems - subset (odd/even) of procs
! The two iosystems created overlap at rank=0 (and are disjoint otherwise)
SUBROUTINE three_files_two_iosystems_with_overlap
  USE pio_tutil
   ! pio_iosystem_tests3.F90.in:177
  use mpi   ! pio_iosystem_tests3.F90.in:178
  implicit none   ! pio_iosystem_tests3.F90.in:179


  character(len=PIO_TF_MAX_STR_LEN), target :: fname0 = "pio_iosys_test_file0.nc"   ! pio_iosystem_tests3.F90.in:181
  character(len=PIO_TF_MAX_STR_LEN), target :: fname1 = "pio_iosys_test_file1.nc"   ! pio_iosystem_tests3.F90.in:182
  character(len=PIO_TF_MAX_STR_LEN), target :: fname2 = "pio_iosys_test_file2.nc"   ! pio_iosystem_tests3.F90.in:183
  character(len=PIO_TF_MAX_STR_LEN), parameter :: attname = "filename"   ! pio_iosystem_tests3.F90.in:184
  character(len=PIO_TF_MAX_STR_LEN), parameter :: dimname = "filename_dim"   ! pio_iosystem_tests3.F90.in:185
  character(len=PIO_TF_MAX_STR_LEN), pointer :: fname   ! pio_iosystem_tests3.F90.in:186
  integer, dimension(:), allocatable :: iotypes   ! pio_iosystem_tests3.F90.in:187
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_iosystem_tests3.F90.in:188
  integer :: i, j, num_iotypes = 0   ! pio_iosystem_tests3.F90.in:189
  type(file_desc_t) :: pio_file0   ! pio_iosystem_tests3.F90.in:190
  integer, parameter :: NUM_COMMS = 2   ! pio_iosystem_tests3.F90.in:191
  type(file_desc_t), dimension(NUM_COMMS) :: pio_files   ! pio_iosystem_tests3.F90.in:192
  integer :: pio_base_rank = 0, pio_num_iotasks = 0   ! pio_iosystem_tests3.F90.in:193


  type(iosystem_desc_t), dimension(NUM_COMMS) :: overlapped_iosys   ! pio_iosystem_tests3.F90.in:195
  integer, dimension(NUM_COMMS) :: overlapped_comms, overlapped_comm_ranks, overlapped_comm_sizes   ! pio_iosystem_tests3.F90.in:196
  integer :: ret   ! pio_iosystem_tests3.F90.in:197


  ! Split world to two disjoint comms with overlap only at overlapped_rank=0
  call split_world_two_with_overlap(overlapped_comms, overlapped_comm_ranks, overlapped_comm_sizes, 0)   ! pio_iosystem_tests3.F90.in:200


  do i=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:202
    if(overlapped_comms(i) /= MPI_COMM_NULL) then   ! pio_iosystem_tests3.F90.in:203
      ! If we have more than 1 proc, make sure that the io tasks start from 1
      ! since rank=0 is always shared by all the overlapped_comms above
      if(overlapped_comm_sizes(i) > 1) then   ! pio_iosystem_tests3.F90.in:206
        pio_base_rank = 1   ! pio_iosystem_tests3.F90.in:207
        pio_num_iotasks = overlapped_comm_sizes(i) - 1   ! pio_iosystem_tests3.F90.in:208
      else   ! pio_iosystem_tests3.F90.in:209
        pio_base_rank = 0   ! pio_iosystem_tests3.F90.in:210
        pio_num_iotasks = overlapped_comm_sizes(i)   ! pio_iosystem_tests3.F90.in:211
      end if   ! pio_iosystem_tests3.F90.in:212
      call PIO_init(overlapped_comm_ranks(i), overlapped_comms(i), &
                    pio_num_iotasks, &
                    1, &! Num aggregators
                    1, &! Stride
                    PIO_rearr_subset, overlapped_iosys(i), base=pio_base_rank)   ! pio_iosystem_tests3.F90.in:217
      call PIO_seterrorhandling(overlapped_iosys(i), PIO_BCAST_ERROR)   ! pio_iosystem_tests3.F90.in:218
    end if   ! pio_iosystem_tests3.F90.in:219
  end do   ! pio_iosystem_tests3.F90.in:220


  ! Open two different files and close it with two different iosystems
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_iosystem_tests3.F90.in:223
  do i=1,num_iotypes   ! pio_iosystem_tests3.F90.in:224

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : ", iotype_descs(i)
      END IF
    END IF   ! pio_iosystem_tests3.F90.in:225
    ! Create three files to be opened later - world - all procs
    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname0, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:228
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname0,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:229)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:229


    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname1, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:232
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname1,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:233)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:233


    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname2, attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:236
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname2,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:237)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:237


    ! Open file0 from all procs - disable close
    call open_and_check_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                    pio_file0, fname0, attname, dimname, .true., ret)   ! pio_iosystem_tests3.F90.in:241
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Checking contents of file failed :" // fname0,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_iosystem_tests3.F90.in:242)"
      END IF
      RETURN
    END IF   ! pio_iosystem_tests3.F90.in:242


    fname => fname1   ! pio_iosystem_tests3.F90.in:244


    do j=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:246
      ! The two comms operate on different files
      if(fname == fname1) then   ! pio_iosystem_tests3.F90.in:248
        fname => fname2   ! pio_iosystem_tests3.F90.in:249
      else   ! pio_iosystem_tests3.F90.in:250
        fname => fname1   ! pio_iosystem_tests3.F90.in:251
      end if   ! pio_iosystem_tests3.F90.in:252
      if(overlapped_comms(j) /= MPI_COMM_NULL) then   ! pio_iosystem_tests3.F90.in:253
        call open_and_check_file(overlapped_comms(j), overlapped_iosys(j), iotypes(i), &
                        pio_files(j), fname, attname, dimname, .true., ret)   ! pio_iosystem_tests3.F90.in:255
        
        IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  overlapped_comms(j)))) THEN
          call MPI_COMM_RANK( overlapped_comms(j), pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
          pio_tf_retval_utest_ = -1
          IF (pio_tf_tmp_comm_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Checking contents of file failed :" // fname,&
              ":", __FILE__, ":", __LINE__,&
              "(pio_iosystem_tests3.F90.in:256)"
          END IF
          RETURN
        END IF   ! pio_iosystem_tests3.F90.in:256


        ! Make sure that we can still check the contents of the file
        call check_file(overlapped_comms(j), pio_files(j), fname, &
             attname, dimname, ret)   ! pio_iosystem_tests3.F90.in:260
        
        IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  overlapped_comms(j)))) THEN
          call MPI_COMM_RANK( overlapped_comms(j), pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
          pio_tf_retval_utest_ = -1
          IF (pio_tf_tmp_comm_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Checking (second) contents of file failed :" // fname,&
              ":", __FILE__, ":", __LINE__,&
              "(pio_iosystem_tests3.F90.in:261)"
          END IF
          RETURN
        END IF   ! pio_iosystem_tests3.F90.in:261
      end if   ! pio_iosystem_tests3.F90.in:262
    end do   ! pio_iosystem_tests3.F90.in:263


    do j=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:265
      if(overlapped_comms(j) /= MPI_COMM_NULL) then   ! pio_iosystem_tests3.F90.in:266
        call PIO_closefile(pio_files(j))   ! pio_iosystem_tests3.F90.in:267
      end if   ! pio_iosystem_tests3.F90.in:268
    end do   ! pio_iosystem_tests3.F90.in:269
    call PIO_closefile(pio_file0)   ! pio_iosystem_tests3.F90.in:270
  end do   ! pio_iosystem_tests3.F90.in:271


  do i=1,NUM_COMMS   ! pio_iosystem_tests3.F90.in:273
    if(overlapped_comms(i) /= MPI_COMM_NULL) then   ! pio_iosystem_tests3.F90.in:274
      call PIO_finalize(overlapped_iosys(i), ret)   ! pio_iosystem_tests3.F90.in:275
      call MPI_Comm_free(overlapped_comms(i), ret)   ! pio_iosystem_tests3.F90.in:276
    end if   ! pio_iosystem_tests3.F90.in:277
  end do   ! pio_iosystem_tests3.F90.in:278
  if(allocated(iotypes)) then   ! pio_iosystem_tests3.F90.in:279
    deallocate(iotypes)   ! pio_iosystem_tests3.F90.in:280
    deallocate(iotype_descs)   ! pio_iosystem_tests3.F90.in:281
  end if   ! pio_iosystem_tests3.F90.in:282
END SUBROUTINE three_files_two_iosystems_with_overlap   ! pio_iosystem_tests3.F90.in:283


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting three_files_two_iosystems_with_overlap"
    END IF
    CALL three_files_two_iosystems_with_overlap()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "three_files_two_iosystems_with_overlap","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "three_files_two_iosystems_with_overlap","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
