! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_rearr.F90.in

#include "config.h"
! Create a file with a global attribute (filename)
SUBROUTINE create_file(comm, iosys, iotype, fname, attname, dimname, ret)   ! pio_rearr.F90.in:3
    use pio_tutil   ! pio_rearr.F90.in:4
    implicit none   ! pio_rearr.F90.in:5


    integer, intent(in) :: comm   ! pio_rearr.F90.in:7
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_rearr.F90.in:8
    integer, intent(in) :: iotype   ! pio_rearr.F90.in:9
    character(len=*), intent(in) :: fname   ! pio_rearr.F90.in:10
    character(len=*), intent(in) :: attname   ! pio_rearr.F90.in:11
    character(len=*), intent(in) :: dimname   ! pio_rearr.F90.in:12
    integer, intent(inout) :: ret   ! pio_rearr.F90.in:13


    type(file_desc_t) :: pio_file   ! pio_rearr.F90.in:15
    integer :: pio_dim   ! pio_rearr.F90.in:16
    type(var_desc_t) :: pio_var   ! pio_rearr.F90.in:17


    ret = PIO_createfile(iosys, pio_file, iotype, fname, PIO_CLOBBER)   ! pio_rearr.F90.in:19
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create dummy file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:20)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:20


    ret = PIO_def_dim(pio_file, dimname, PIO_TF_MAX_STR_LEN, pio_dim)   ! pio_rearr.F90.in:22
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define dim "// trim(dimname) // "in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:23)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:23


    ret = PIO_def_var(pio_file, attname, PIO_char, (/pio_dim/), pio_var)   ! pio_rearr.F90.in:25
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to define var " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:26)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:26


    ret = PIO_put_att(pio_file, pio_var, attname, fname)   ! pio_rearr.F90.in:28
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to put att " // trim(attname) // " in file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:29)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:29


    ret = PIO_enddef(pio_file)   ! pio_rearr.F90.in:31
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to enddef, file :" // trim(fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:32)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:32


    call PIO_closefile(pio_file)   ! pio_rearr.F90.in:34
END SUBROUTINE create_file   ! pio_rearr.F90.in:35


! Open a file and perform read and write
SUBROUTINE open_and_check_rdwr(comm, iosys, iotype, pio_file, fname, ret)   ! pio_rearr.F90.in:38
    use pio_tutil   ! pio_rearr.F90.in:39
    implicit none   ! pio_rearr.F90.in:40


    integer, intent(in) :: comm   ! pio_rearr.F90.in:42
    type(iosystem_desc_t), intent(inout) :: iosys   ! pio_rearr.F90.in:43
    integer, intent(in) :: iotype   ! pio_rearr.F90.in:44
    type(file_desc_t), intent(inout) :: pio_file   ! pio_rearr.F90.in:45
    character(len=*), intent(in) :: fname   ! pio_rearr.F90.in:46
    integer, intent(inout) :: ret   ! pio_rearr.F90.in:47


    integer, parameter :: VEC_LOCAL_SZ = 3   ! pio_rearr.F90.in:49
    character(len=PIO_TF_MAX_STR_LEN) :: var_name = "test_1d_var"   ! pio_rearr.F90.in:50
    character(len=PIO_TF_MAX_STR_LEN) :: dim_name = "test_dim_1d_var"   ! pio_rearr.F90.in:51
    type(var_desc_t) :: pio_var   ! pio_rearr.F90.in:52
    type(io_desc_t) :: iodesc   ! pio_rearr.F90.in:53
    integer, dimension(VEC_LOCAL_SZ) :: compdof, compdof_rel_disps   ! pio_rearr.F90.in:54
    integer :: start_compdof   ! pio_rearr.F90.in:55
    real, dimension(VEC_LOCAL_SZ) :: wbuf   ! pio_rearr.F90.in:56
    real, dimension(:), allocatable :: rbuf   ! pio_rearr.F90.in:57
    integer, dimension(1) :: dims   ! pio_rearr.F90.in:58
    integer :: pio_dim   ! pio_rearr.F90.in:59
    integer :: comm_rank, comm_sz   ! pio_rearr.F90.in:60
    integer :: i   ! pio_rearr.F90.in:61


    call MPI_Comm_size(comm, comm_sz, ret)   ! pio_rearr.F90.in:63
    call MPI_Comm_rank(comm, comm_rank, ret)   ! pio_rearr.F90.in:64


    dims(1) = VEC_LOCAL_SZ * comm_sz   ! pio_rearr.F90.in:66


    ret = PIO_openfile(iosys, pio_file, iotype, fname, PIO_write)   ! pio_rearr.F90.in:68
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to open:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:69)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:69


    ret = pio_inq_dimid(pio_file, dim_name, pio_dim)   ! pio_rearr.F90.in:71
    if(ret /= PIO_NOERR) then   ! pio_rearr.F90.in:72
      ! Define the required dim/var
      ret = PIO_redef(pio_file)   ! pio_rearr.F90.in:74
      
      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
        call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
        pio_tf_retval_utest_ = -1
        IF (pio_tf_tmp_comm_rank_ == 0) THEN
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to redef:" // fname,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_rearr.F90.in:75)"
        END IF
        RETURN
      END IF   ! pio_rearr.F90.in:75


      ret = PIO_def_dim(pio_file, dim_name, dims(1), pio_dim)   ! pio_rearr.F90.in:77
      
      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
        call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
        pio_tf_retval_utest_ = -1
        IF (pio_tf_tmp_comm_rank_ == 0) THEN
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to define dim:" // fname,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_rearr.F90.in:78)"
        END IF
        RETURN
      END IF   ! pio_rearr.F90.in:78


      ! Assume var is not defined either
      ret = PIO_def_var(pio_file, var_name, pio_real, (/pio_dim/), pio_var)   ! pio_rearr.F90.in:81
      
      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
        call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
        pio_tf_retval_utest_ = -1
        IF (pio_tf_tmp_comm_rank_ == 0) THEN
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to define var:" // fname,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_rearr.F90.in:82)"
        END IF
        RETURN
      END IF   ! pio_rearr.F90.in:82


      ret = PIO_enddef(pio_file)   ! pio_rearr.F90.in:84
      
      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
        call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
        pio_tf_retval_utest_ = -1
        IF (pio_tf_tmp_comm_rank_ == 0) THEN
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to enddef:" // fname,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_rearr.F90.in:85)"
        END IF
        RETURN
      END IF   ! pio_rearr.F90.in:85
    else   ! pio_rearr.F90.in:86
      ! Assume var was also defined
      ret = PIO_inq_varid(pio_file, var_name, pio_var)   ! pio_rearr.F90.in:88
      
      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
        call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
        pio_tf_retval_utest_ = -1
        IF (pio_tf_tmp_comm_rank_ == 0) THEN
          PRINT *, "PIO_TF: PIO Function failed:",&
             "Failed to inq var:" // fname,&
            ":", __FILE__, ":", __LINE__,&
            "(pio_rearr.F90.in:89)"
        END IF
        RETURN
      END IF   ! pio_rearr.F90.in:89
    end if   ! pio_rearr.F90.in:90


    ! Compdof is a simple reverse (of chunks of VEC_LOCAL_SZ) of the file offsets
    ! e.g. VEC_LOCAL_SZ = 3, with 2 procs
    ! [4 5 6] [1 2 3]
    start_compdof = (comm_sz - comm_rank - 1) * VEC_LOCAL_SZ   ! pio_rearr.F90.in:95
    do i=1,VEC_LOCAL_SZ   ! pio_rearr.F90.in:96
      compdof_rel_disps(i) = i   ! pio_rearr.F90.in:97
    end do   ! pio_rearr.F90.in:98


    compdof = start_compdof + compdof_rel_disps   ! pio_rearr.F90.in:100
    wbuf = compdof   ! pio_rearr.F90.in:101
    allocate(rbuf(size(wbuf)))   ! pio_rearr.F90.in:102
    rbuf = 0   ! pio_rearr.F90.in:103


    call PIO_initdecomp(iosys, pio_real, dims, compdof, iodesc)   ! pio_rearr.F90.in:105
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to init decomp:" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:106)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:106


    ! Write and read back the data
    call PIO_write_darray(pio_file, pio_var, iodesc, wbuf, ret)   ! pio_rearr.F90.in:109
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to write darray: " // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:110)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:110


    call PIO_syncfile(pio_file)   ! pio_rearr.F90.in:112


    call PIO_read_darray(pio_file, pio_var, iodesc, rbuf, ret)   ! pio_rearr.F90.in:114
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  comm))) THEN
      call MPI_COMM_RANK( comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to read darray: " // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:115)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:115


    
    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Check failed:",&
           "Got wrong val",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:117)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:117


    deallocate(rbuf)   ! pio_rearr.F90.in:119


    call PIO_freedecomp(iosys, iodesc)   ! pio_rearr.F90.in:121


    call PIO_closefile(pio_file)   ! pio_rearr.F90.in:123
END SUBROUTINE open_and_check_rdwr   ! pio_rearr.F90.in:124


SUBROUTINE test_rearrs_base
  USE pio_tutil
   ! pio_rearr.F90.in:126
  implicit none   ! pio_rearr.F90.in:127


  character(len=PIO_TF_MAX_STR_LEN), target :: fname = "pio_test_rearrs_base.nc"   ! pio_rearr.F90.in:129
  character(len=PIO_TF_MAX_STR_LEN), parameter :: attname = "filename"   ! pio_rearr.F90.in:130
  character(len=PIO_TF_MAX_STR_LEN), parameter :: dimname = "filename_dim"   ! pio_rearr.F90.in:131
  integer, parameter :: NUM_REARRANGERS = 2   ! pio_rearr.F90.in:132
  integer :: rearrs(NUM_REARRANGERS) = (/pio_rearr_subset,pio_rearr_box/)   ! pio_rearr.F90.in:133
  character(len=PIO_TF_MAX_STR_LEN) :: rearrs_info(NUM_REARRANGERS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)   ! pio_rearr.F90.in:134
  integer, dimension(:), allocatable :: iotypes   ! pio_rearr.F90.in:135
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_rearr.F90.in:136
  integer :: i, j, k, num_iotypes = 0   ! pio_rearr.F90.in:137
  type(file_desc_t) :: pio_file   ! pio_rearr.F90.in:138


  type(iosystem_desc_t) :: dup_iosys   ! pio_rearr.F90.in:140
  integer :: dup_comm   ! pio_rearr.F90.in:141
  integer :: dup_comm_rank, dup_comm_sz, dup_iosys_base   ! pio_rearr.F90.in:142
  integer :: ret   ! pio_rearr.F90.in:143


  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_rearr.F90.in:145
  do i=1,num_iotypes   ! pio_rearr.F90.in:146

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing iotype: ", iotype_descs(i)
      END IF
    END IF   ! pio_rearr.F90.in:147
    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname, attname, dimname, ret)   ! pio_rearr.F90.in:149
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  pio_tf_comm_))) THEN
      call MPI_COMM_RANK( pio_tf_comm_, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:150)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:150


    call MPI_Comm_dup(pio_tf_comm_, dup_comm, ret)   ! pio_rearr.F90.in:152
    call MPI_Comm_rank(dup_comm, dup_comm_rank, ret)   ! pio_rearr.F90.in:153
    call MPI_Comm_size(dup_comm, dup_comm_sz, ret)   ! pio_rearr.F90.in:154
    do j=1, NUM_REARRANGERS   ! pio_rearr.F90.in:155

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*,*)  "Testing rearr : ", rearrs_info(j)
        END IF
      END IF   ! pio_rearr.F90.in:156
      do k=1, dup_comm_sz   ! pio_rearr.F90.in:157
        dup_iosys_base = k-1   ! pio_rearr.F90.in:158

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Base = ", dup_iosys_base
          END IF
        END IF   ! pio_rearr.F90.in:159
        call PIO_init(pio_tf_world_rank_, dup_comm, pio_tf_world_sz_, &
                      1, &! Num aggregators
                      1, &! Stride
                      rearrs(j), dup_iosys, base=dup_iosys_base)   ! pio_rearr.F90.in:163
        call PIO_seterrorhandling(dup_iosys, PIO_BCAST_ERROR)   ! pio_rearr.F90.in:164


        call open_and_check_rdwr(dup_comm, dup_iosys, iotypes(i), &
                        pio_file, fname, ret)   ! pio_rearr.F90.in:167
        
        IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
          call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
          pio_tf_retval_utest_ = -1
          IF (pio_tf_tmp_comm_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Checking rd+wr on file failed :" // fname,&
              ":", __FILE__, ":", __LINE__,&
              "(pio_rearr.F90.in:168)"
          END IF
          RETURN
        END IF   ! pio_rearr.F90.in:168


        call PIO_finalize(dup_iosys, ret)   ! pio_rearr.F90.in:170
      end do   ! pio_rearr.F90.in:171
    end do   ! pio_rearr.F90.in:172
    call PIO_deletefile(pio_tf_iosystem_, fname)   ! pio_rearr.F90.in:173
    call MPI_Comm_free(dup_comm, ret)   ! pio_rearr.F90.in:174
  end do   ! pio_rearr.F90.in:175
  if(allocated(iotypes)) then   ! pio_rearr.F90.in:176
    deallocate(iotypes)   ! pio_rearr.F90.in:177
    deallocate(iotype_descs)   ! pio_rearr.F90.in:178
  end if   ! pio_rearr.F90.in:179
END SUBROUTINE test_rearrs_base   ! pio_rearr.F90.in:180


! Test different combinations of the rearrangers to test the compatibility
! between different rearrangers
! init/rd+wr/finalize with one rearranger followed by another and try
! all combinations ((subset,box),(box_subset),(box,box),(subset,subset))
SUBROUTINE test_rearrs_combs
  USE pio_tutil
   ! pio_rearr.F90.in:186
  implicit none   ! pio_rearr.F90.in:187


  character(len=PIO_TF_MAX_STR_LEN), target :: fname = "pio_rearrs_combs.nc"   ! pio_rearr.F90.in:189
  character(len=PIO_TF_MAX_STR_LEN), parameter :: attname = "filename"   ! pio_rearr.F90.in:190
  character(len=PIO_TF_MAX_STR_LEN), parameter :: dimname = "filename_dim"   ! pio_rearr.F90.in:191
  integer, parameter :: NUM_REARRANGERS = 2   ! pio_rearr.F90.in:192
  integer, parameter :: MAX_PERMS = 4   ! pio_rearr.F90.in:193
  integer :: rearrs_perms(NUM_REARRANGERS,MAX_PERMS) = reshape(&
                (/pio_rearr_subset, pio_rearr_box,&
                  pio_rearr_box, pio_rearr_subset,&
                  pio_rearr_subset, pio_rearr_subset,&
                  pio_rearr_box, pio_rearr_box/),&
                  (/NUM_REARRANGERS,MAX_PERMS/)&
              )    ! pio_rearr.F90.in:200
  character(len=PIO_TF_MAX_STR_LEN) :: rearrs_perms_info(NUM_REARRANGERS,MAX_PERMS) =&
            reshape(&
              (/"PIO_REARR_SUBSET", "PIO_REARR_BOX   ",&
              "PIO_REARR_BOX   ", "PIO_REARR_SUBSET",&
              "PIO_REARR_SUBSET", "PIO_REARR_SUBSET",&
              "PIO_REARR_BOX   ", "PIO_REARR_BOX   "/),&
              (/NUM_REARRANGERS,MAX_PERMS/)&
            )   ! pio_rearr.F90.in:208
  integer, dimension(:), allocatable :: iotypes   ! pio_rearr.F90.in:209
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_rearr.F90.in:210
  integer :: i, j, k, num_iotypes = 0   ! pio_rearr.F90.in:211
  type(file_desc_t) :: pio_file   ! pio_rearr.F90.in:212


  type(iosystem_desc_t) :: dup_iosys   ! pio_rearr.F90.in:214
  integer :: dup_comm   ! pio_rearr.F90.in:215
  integer :: ret   ! pio_rearr.F90.in:216


  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_rearr.F90.in:218
  do i=1,num_iotypes   ! pio_rearr.F90.in:219

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing iotype: ", iotype_descs(i)
      END IF
    END IF   ! pio_rearr.F90.in:220
    call create_file(pio_tf_comm_, pio_tf_iosystem_, iotypes(i), &
                      fname, attname, dimname, ret)   ! pio_rearr.F90.in:222
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  pio_tf_comm_))) THEN
      call MPI_COMM_RANK( pio_tf_comm_, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
      pio_tf_retval_utest_ = -1
      IF (pio_tf_tmp_comm_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Failed to create file :" // fname,&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr.F90.in:223)"
      END IF
      RETURN
    END IF   ! pio_rearr.F90.in:223


    call MPI_Comm_dup(pio_tf_comm_, dup_comm, ret)   ! pio_rearr.F90.in:225
    ! Try different combinations of rearrangers
    do k=1,MAX_PERMS   ! pio_rearr.F90.in:227
      do j=1, NUM_REARRANGERS   ! pio_rearr.F90.in:228

        IF (pio_tf_world_rank_ == 0) THEN
          IF (pio_tf_log_level_ >= 0) THEN
            WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
            WRITE(*,*)  "Testing rearr : ", rearrs_perms_info(j,k)
          END IF
        END IF   ! pio_rearr.F90.in:229
        call PIO_init(pio_tf_world_rank_, dup_comm, pio_tf_world_sz_, &
                      1, &! Num aggregators
                      1, &! Stride
                      rearrs_perms(j,k), dup_iosys, base=0)   ! pio_rearr.F90.in:233
        call PIO_seterrorhandling(dup_iosys, PIO_BCAST_ERROR)   ! pio_rearr.F90.in:234


        call open_and_check_rdwr(dup_comm, dup_iosys, iotypes(i), &
                        pio_file, fname, ret)   ! pio_rearr.F90.in:237
        
        IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
          call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
          pio_tf_retval_utest_ = -1
          IF (pio_tf_tmp_comm_rank_ == 0) THEN
            PRINT *, "PIO_TF: PIO Function failed:",&
               "Checking rd+wr on file failed :" // fname,&
              ":", __FILE__, ":", __LINE__,&
              "(pio_rearr.F90.in:238)"
          END IF
          RETURN
        END IF   ! pio_rearr.F90.in:238


        call PIO_finalize(dup_iosys, ret)   ! pio_rearr.F90.in:240
      end do   ! pio_rearr.F90.in:241
    end do   ! pio_rearr.F90.in:242
    call PIO_deletefile(pio_tf_iosystem_, fname)   ! pio_rearr.F90.in:243
    call MPI_Comm_free(dup_comm, ret)   ! pio_rearr.F90.in:244
  end do   ! pio_rearr.F90.in:245
  if(allocated(iotypes)) then   ! pio_rearr.F90.in:246
    deallocate(iotypes)   ! pio_rearr.F90.in:247
    deallocate(iotype_descs)   ! pio_rearr.F90.in:248
  end if   ! pio_rearr.F90.in:249
END SUBROUTINE test_rearrs_combs   ! pio_rearr.F90.in:250




  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting test_rearrs_base"
    END IF
    CALL test_rearrs_base()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "test_rearrs_base","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "test_rearrs_base","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting test_rearrs_combs"
    END IF
    CALL test_rearrs_combs()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "test_rearrs_combs","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "test_rearrs_combs","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
