! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_rearr_opts.F90.in

#include "config.h"
MODULE pio_rearr_opts_tgv   ! pio_rearr_opts.F90.in:2
  use pio_tutil   ! pio_rearr_opts.F90.in:3
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_fname ="pio_rearr_opts_test.nc"   ! pio_rearr_opts.F90.in:4
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_var_name ="dummy_var"   ! pio_rearr_opts.F90.in:5
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_dim_name ="dummy_dim"   ! pio_rearr_opts.F90.in:6
END MODULE pio_rearr_opts_tgv   ! pio_rearr_opts.F90.in:7


! Test init/finalize wiht a default set of rearranger options
SUBROUTINE init_fin_with_rearr_opts
  USE pio_tutil
   ! pio_rearr_opts.F90.in:10
  implicit none   ! pio_rearr_opts.F90.in:11


  integer, parameter :: NUM_REARRANGERS = 2   ! pio_rearr_opts.F90.in:13
  integer :: rearrs(NUM_REARRANGERS) = (/pio_rearr_subset,pio_rearr_box/)   ! pio_rearr_opts.F90.in:14
  type(pio_rearr_opt_t) :: pio_rearr_opts   ! pio_rearr_opts.F90.in:15
  ! Dummy val for max pend req
  integer, parameter :: MAX_PEND_REQ = 10   ! pio_rearr_opts.F90.in:17


  type(iosystem_desc_t) :: dup_iosys   ! pio_rearr_opts.F90.in:19
  integer :: dup_comm   ! pio_rearr_opts.F90.in:20
  integer :: i, ret   ! pio_rearr_opts.F90.in:21


  call MPI_Comm_dup(pio_tf_comm_, dup_comm, ret)   ! pio_rearr_opts.F90.in:23


  do i=1,NUM_REARRANGERS   ! pio_rearr_opts.F90.in:25
    ! Some dummy values for rearranger options
    pio_rearr_opts%comm_type = PIO_rearr_comm_p2p   ! pio_rearr_opts.F90.in:27
    pio_rearr_opts%fcd = PIO_rearr_comm_fc_2d_enable   ! pio_rearr_opts.F90.in:28


    pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req = PIO_REARR_COMM_UNLIMITED_PEND_REQ   ! pio_rearr_opts.F90.in:30
    pio_rearr_opts%comm_fc_opts_comp2io%enable_hs = .true.   ! pio_rearr_opts.F90.in:31
    pio_rearr_opts%comm_fc_opts_comp2io%enable_isend = .true.   ! pio_rearr_opts.F90.in:32


    pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req = MAX_PEND_REQ   ! pio_rearr_opts.F90.in:34
    pio_rearr_opts%comm_fc_opts_io2comp%enable_hs = .true.   ! pio_rearr_opts.F90.in:35
    pio_rearr_opts%comm_fc_opts_io2comp%enable_isend = .true.   ! pio_rearr_opts.F90.in:36


    call PIO_init(pio_tf_world_rank_, dup_comm, pio_tf_world_sz_, &
                  1, &! Num aggregators
                  1, &! Stride
                  rearrs(i), dup_iosys, base=0, rearr_opts=pio_rearr_opts)   ! pio_rearr_opts.F90.in:41
    call PIO_seterrorhandling(dup_iosys, PIO_BCAST_ERROR)   ! pio_rearr_opts.F90.in:42


    call PIO_finalize(dup_iosys, ret)   ! pio_rearr_opts.F90.in:44
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Finalize failed",&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr_opts.F90.in:45)"
      END IF
      RETURN
    END IF   ! pio_rearr_opts.F90.in:45
  end do   ! pio_rearr_opts.F90.in:46


  call MPI_Comm_free(dup_comm, ret)   ! pio_rearr_opts.F90.in:48


END SUBROUTINE init_fin_with_rearr_opts   ! pio_rearr_opts.F90.in:50


SUBROUTINE print_rearr_opts(pio_rearr_opts, ret)   ! pio_rearr_opts.F90.in:52
  use pio_tutil   ! pio_rearr_opts.F90.in:53
  implicit none   ! pio_rearr_opts.F90.in:54


  type(pio_rearr_opt_t), intent(in) :: pio_rearr_opts   ! pio_rearr_opts.F90.in:56
  integer, intent(inout) :: ret   ! pio_rearr_opts.F90.in:57


  ret = PIO_NOERR   ! pio_rearr_opts.F90.in:59



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  "PIO rearranger options :"
    END IF
  END IF   ! pio_rearr_opts.F90.in:61
  if(pio_rearr_opts%comm_type == PIO_rearr_comm_p2p) then   ! pio_rearr_opts.F90.in:62

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = PIO_rearr_comm_p2p"
      END IF
    END IF   ! pio_rearr_opts.F90.in:63
  else if(pio_rearr_opts%comm_type == PIO_rearr_comm_coll) then   ! pio_rearr_opts.F90.in:64

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = PIO_rearr_comm_coll"
      END IF
    END IF   ! pio_rearr_opts.F90.in:65
  else   ! pio_rearr_opts.F90.in:66

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = INVALID"
      END IF
    END IF   ! pio_rearr_opts.F90.in:67
  end if   ! pio_rearr_opts.F90.in:68


  if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_2d_enable) then   ! pio_rearr_opts.F90.in:70

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_2d_enable"
      END IF
    END IF   ! pio_rearr_opts.F90.in:71
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_1d_comp2io) then   ! pio_rearr_opts.F90.in:72

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_1d_comp2io"
      END IF
    END IF   ! pio_rearr_opts.F90.in:73
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_1d_io2comp) then   ! pio_rearr_opts.F90.in:74

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_1d_io2comp"
      END IF
    END IF   ! pio_rearr_opts.F90.in:75
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_2d_disable) then   ! pio_rearr_opts.F90.in:76

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_2d_disable"
      END IF
    END IF   ! pio_rearr_opts.F90.in:77
  else   ! pio_rearr_opts.F90.in:78

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = INVALID"
      END IF
    END IF   ! pio_rearr_opts.F90.in:79
  end if   ! pio_rearr_opts.F90.in:80



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  " comp2io max_pend_req =", pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req
    END IF
  END IF   ! pio_rearr_opts.F90.in:82
  if(pio_rearr_opts%comm_fc_opts_comp2io%enable_hs) then   ! pio_rearr_opts.F90.in:83

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_hs = TRUE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:84
  else   ! pio_rearr_opts.F90.in:85

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_hs = FALSE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:86
  end if   ! pio_rearr_opts.F90.in:87
  if(pio_rearr_opts%comm_fc_opts_comp2io%enable_isend) then   ! pio_rearr_opts.F90.in:88

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_isend = TRUE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:89
  else   ! pio_rearr_opts.F90.in:90

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_isend = FALSE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:91
  end if   ! pio_rearr_opts.F90.in:92



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  " io2comp max_pend_req =", pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req
    END IF
  END IF   ! pio_rearr_opts.F90.in:94
  if(pio_rearr_opts%comm_fc_opts_io2comp%enable_hs) then   ! pio_rearr_opts.F90.in:95

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_hs = TRUE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:96
  else   ! pio_rearr_opts.F90.in:97

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_hs = FALSE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:98
  end if   ! pio_rearr_opts.F90.in:99
  if(pio_rearr_opts%comm_fc_opts_io2comp%enable_isend) then   ! pio_rearr_opts.F90.in:100

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_isend = TRUE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:101
  else   ! pio_rearr_opts.F90.in:102

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_isend = FALSE"
      END IF
    END IF   ! pio_rearr_opts.F90.in:103
  end if   ! pio_rearr_opts.F90.in:104


END SUBROUTINE print_rearr_opts   ! pio_rearr_opts.F90.in:106


! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_LOCAL_SZ elements
! # All odd procs have VEC_LOCAL_SZ + 1 elements
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [1,2] [3,4,5] [6,7]
! e.g. 2)    [1,2] [3,4,5] [6,7] [8,9,10]
! e.g. 3)    [1,2] [3,4,5] [6,7] [8,9,10] [11,12]
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! This for example can be used to force rearrangement when reading
! or writing data.
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [3,4,5] [1,2] [6,7]
! e.g. 2)    [3,4,5] [1,2] [8,9,10] [6,7]
! e.g. 3)    [3,4,5] [1,2] [8,9,10] [6,7] [11,12]
SUBROUTINE get_1d_bc_info(rank, sz, dims, start, count, force_rearrange)   ! pio_rearr_opts.F90.in:124
  implicit none   ! pio_rearr_opts.F90.in:125


  integer, parameter :: VEC_LOCAL_SZ = 3   ! pio_rearr_opts.F90.in:127
  integer, intent(in) :: rank   ! pio_rearr_opts.F90.in:128
  integer, intent(in) :: sz   ! pio_rearr_opts.F90.in:129
  integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts.F90.in:130
  integer, dimension(1), intent(out) :: start   ! pio_rearr_opts.F90.in:131
  integer, dimension(1), intent(out) :: count   ! pio_rearr_opts.F90.in:132
  logical, intent(in) :: force_rearrange   ! pio_rearr_opts.F90.in:133


  logical :: is_even_rank   ! pio_rearr_opts.F90.in:135
  integer :: num_odd_procs, num_even_procs   ! pio_rearr_opts.F90.in:136
  integer :: iodd, ieven   ! pio_rearr_opts.F90.in:137


  is_even_rank = .false.   ! pio_rearr_opts.F90.in:139
  if (mod(rank, 2) == 0) then   ! pio_rearr_opts.F90.in:140
    is_even_rank = .true.   ! pio_rearr_opts.F90.in:141
  end if   ! pio_rearr_opts.F90.in:142
  num_odd_procs = sz / 2   ! pio_rearr_opts.F90.in:143
  num_even_procs = sz - num_odd_procs   ! pio_rearr_opts.F90.in:144
  dims(1) = num_even_procs * VEC_LOCAL_SZ + num_odd_procs * (VEC_LOCAL_SZ + 1)   ! pio_rearr_opts.F90.in:145
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_rearr_opts.F90.in:147
  ieven = (rank + 1) / 2   ! pio_rearr_opts.F90.in:148
  if(force_rearrange) then   ! pio_rearr_opts.F90.in:149
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_rearr_opts.F90.in:151
      if(rank + 1 < sz) then   ! pio_rearr_opts.F90.in:152
        ! Force rearrangement
        count(1) = VEC_LOCAL_SZ + 1   ! pio_rearr_opts.F90.in:154
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + (VEC_LOCAL_SZ) + 1   ! pio_rearr_opts.F90.in:155
      else   ! pio_rearr_opts.F90.in:156
        count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts.F90.in:157
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_rearr_opts.F90.in:158
      end if   ! pio_rearr_opts.F90.in:159
    else   ! pio_rearr_opts.F90.in:160
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts.F90.in:163
      start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) - (VEC_LOCAL_SZ) + 1   ! pio_rearr_opts.F90.in:164
    end if   ! pio_rearr_opts.F90.in:165
  else   ! pio_rearr_opts.F90.in:166
    if (is_even_rank) then   ! pio_rearr_opts.F90.in:167
      count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts.F90.in:168
    else   ! pio_rearr_opts.F90.in:169
      count(1) = VEC_LOCAL_SZ + 1   ! pio_rearr_opts.F90.in:170
    end if   ! pio_rearr_opts.F90.in:171
    start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_rearr_opts.F90.in:172
  end if   ! pio_rearr_opts.F90.in:173


END SUBROUTINE   ! pio_rearr_opts.F90.in:175


! Create a decomp that will be used by tests below
! The iodesc needs to be freed by the caller
SUBROUTINE create_decomp_and_init_buf(iosys, iocomm, iodesc, wbuf, dims, ret)   ! pio_rearr_opts.F90.in:179
  use pio_tutil   ! pio_rearr_opts.F90.in:180
  implicit none   ! pio_rearr_opts.F90.in:181


  type(iosystem_desc_t), intent(inout) :: iosys   ! pio_rearr_opts.F90.in:183
  integer, intent(in) :: iocomm   ! pio_rearr_opts.F90.in:184
  type(io_desc_t), intent(out) :: iodesc   ! pio_rearr_opts.F90.in:185
  real, dimension(:), allocatable, intent(inout) :: wbuf   ! pio_rearr_opts.F90.in:186
  integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts.F90.in:187
  integer, intent(out) :: ret   ! pio_rearr_opts.F90.in:188


  integer, dimension(:), allocatable :: compdof   ! pio_rearr_opts.F90.in:190
  integer, dimension(1) :: start, count   ! pio_rearr_opts.F90.in:191
  integer :: i   ! pio_rearr_opts.F90.in:192
  integer :: rank, sz   ! pio_rearr_opts.F90.in:193


  ret = PIO_NOERR   ! pio_rearr_opts.F90.in:195


  call MPI_Comm_size(iocomm, sz, ret)   ! pio_rearr_opts.F90.in:197
  call MPI_Comm_rank(iocomm, rank, ret)   ! pio_rearr_opts.F90.in:198


  call get_1d_bc_info(rank, sz, dims, start, count, .true.)   ! pio_rearr_opts.F90.in:200
  allocate(wbuf(count(1)))   ! pio_rearr_opts.F90.in:201
  allocate(compdof(count(1)))   ! pio_rearr_opts.F90.in:202
  do i=1,count(1)   ! pio_rearr_opts.F90.in:203
    wbuf(i) = start(1) + i - 1   ! pio_rearr_opts.F90.in:204
    compdof(i) = int(wbuf(i))   ! pio_rearr_opts.F90.in:205
  end do   ! pio_rearr_opts.F90.in:206


  call PIO_initdecomp(iosys, PIO_real, dims, compdof, iodesc)   ! pio_rearr_opts.F90.in:208
  deallocate(compdof)   ! pio_rearr_opts.F90.in:209


END SUBROUTINE   ! pio_rearr_opts.F90.in:211


! Create file and var used in the tests below
! All details are picked from pio_rearr_opts_tgv module
SUBROUTINE create_file_and_var(iotype, ret)   ! pio_rearr_opts.F90.in:215
  use pio_tutil   ! pio_rearr_opts.F90.in:216
  use pio_rearr_opts_tgv   ! pio_rearr_opts.F90.in:217
  implicit none   ! pio_rearr_opts.F90.in:218


  integer, intent(in) :: iotype   ! pio_rearr_opts.F90.in:220
  integer, intent(out) :: ret   ! pio_rearr_opts.F90.in:221


  type(file_desc_t) :: pio_file   ! pio_rearr_opts.F90.in:223
  type(var_desc_t) :: pio_var   ! pio_rearr_opts.F90.in:224
  integer :: pio_dim   ! pio_rearr_opts.F90.in:225
  integer, dimension(1) :: dims   ! pio_rearr_opts.F90.in:226
  integer, dimension(1) :: start, count   ! pio_rearr_opts.F90.in:227


  call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_rearr_opts.F90.in:229


  ret = PIO_createfile(pio_tf_iosystem_, pio_file, iotype, tgv_fname, PIO_CLOBBER)   ! pio_rearr_opts.F90.in:231
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:232)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:232


  ret = PIO_def_dim(pio_file, tgv_dim_name, dims(1), pio_dim)   ! pio_rearr_opts.F90.in:234
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define dim file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:235)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:235


  ret = PIO_def_var(pio_file, tgv_var_name, pio_real, (/pio_dim/), pio_var)   ! pio_rearr_opts.F90.in:237
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define var file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:238)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:238


  ret = PIO_enddef(pio_file)   ! pio_rearr_opts.F90.in:240
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:241)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:241


  call PIO_closefile(pio_file)   ! pio_rearr_opts.F90.in:243


END SUBROUTINE   ! pio_rearr_opts.F90.in:245


! Open file and inq var
! All details are picked from pio_rearr_opts_tgv module
! Note: The file is kept open so the called needs to close it
SUBROUTINE open_file_and_get_var(iosys, pio_file, iotype, pio_var, ret)   ! pio_rearr_opts.F90.in:250
  use pio_tutil   ! pio_rearr_opts.F90.in:251
  use pio_rearr_opts_tgv   ! pio_rearr_opts.F90.in:252
  implicit none   ! pio_rearr_opts.F90.in:253


  type(iosystem_desc_t), intent(inout) :: iosys   ! pio_rearr_opts.F90.in:255
  type(file_desc_t), intent(out) :: pio_file   ! pio_rearr_opts.F90.in:256
  integer, intent(in) :: iotype   ! pio_rearr_opts.F90.in:257
  type(var_desc_t), intent(out) :: pio_var   ! pio_rearr_opts.F90.in:258
  integer, intent(out) :: ret   ! pio_rearr_opts.F90.in:259


  ret = PIO_openfile(iosys, pio_file, iotype, tgv_fname, pio_write)   ! pio_rearr_opts.F90.in:261
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:262)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:262


  ret = PIO_inq_varid(pio_file, tgv_var_name, pio_var)   ! pio_rearr_opts.F90.in:264
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not inq var " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts.F90.in:265)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts.F90.in:265


END SUBROUTINE   ! pio_rearr_opts.F90.in:267




! Test all possible combinations of rearranger options
SUBROUTINE write_with_rearr_opts
  USE pio_tutil
   ! pio_rearr_opts.F90.in:271
  use pio_rearr_opts_tgv   ! pio_rearr_opts.F90.in:272
  implicit none   ! pio_rearr_opts.F90.in:273
  interface   ! pio_rearr_opts.F90.in:274
    subroutine create_decomp_and_init_buf(iosys, iocomm, iodesc, wbuf, dims, ret)   ! pio_rearr_opts.F90.in:275
      use pio_tutil   ! pio_rearr_opts.F90.in:276
      type(iosystem_desc_t), intent(inout) :: iosys   ! pio_rearr_opts.F90.in:277
      integer, intent(in) :: iocomm   ! pio_rearr_opts.F90.in:278
      type(io_desc_t), intent(out) :: iodesc   ! pio_rearr_opts.F90.in:279
      real, dimension(:), allocatable, intent(inout) :: wbuf   ! pio_rearr_opts.F90.in:280
      integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts.F90.in:281
      integer, intent(out) :: ret   ! pio_rearr_opts.F90.in:282
    end subroutine create_decomp_and_init_buf   ! pio_rearr_opts.F90.in:283
  end interface    ! pio_rearr_opts.F90.in:284


  integer, parameter :: NUM_REARRANGERS = 2   ! pio_rearr_opts.F90.in:286
  integer :: rearrs(NUM_REARRANGERS) = (/pio_rearr_subset,pio_rearr_box/)   ! pio_rearr_opts.F90.in:287
  character(len=PIO_TF_MAX_STR_LEN) :: rearrs_info(NUM_REARRANGERS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)   ! pio_rearr_opts.F90.in:288
  type(pio_rearr_opt_t) :: pio_rearr_opts   ! pio_rearr_opts.F90.in:289


  ! Different rearranger options that are tested here
  integer, parameter :: NUM_COMM_TYPE_OPTS = 2   ! pio_rearr_opts.F90.in:292
  integer :: comm_type_opts(NUM_COMM_TYPE_OPTS) =&
                  (/pio_rearr_comm_p2p,pio_rearr_comm_coll/)   ! pio_rearr_opts.F90.in:294
  integer, parameter :: NUM_FCD_OPTS = 4   ! pio_rearr_opts.F90.in:295
  integer :: fcd_opts(NUM_FCD_OPTS) = &
                  (/pio_rearr_comm_fc_2d_disable,&
                    pio_rearr_comm_fc_1d_comp2io,&
                    pio_rearr_comm_fc_1d_io2comp,&
                    pio_rearr_comm_fc_2d_enable/)   ! pio_rearr_opts.F90.in:300
  integer :: num_fcd_opts_comm_type   ! pio_rearr_opts.F90.in:301
  integer, parameter :: NUM_ENABLE_HS_OPTS = 2   ! pio_rearr_opts.F90.in:302
  logical :: enable_hs_opts(NUM_ENABLE_HS_OPTS) = (/.true.,.false./)   ! pio_rearr_opts.F90.in:303
  integer :: num_enable_hs_opts_comp2io, num_enable_hs_opts_io2comp   ! pio_rearr_opts.F90.in:304
  integer, parameter :: NUM_ENABLE_ISEND_OPTS = 2   ! pio_rearr_opts.F90.in:305
  logical :: enable_isend_opts(NUM_ENABLE_ISEND_OPTS) = (/.true.,.false./)   ! pio_rearr_opts.F90.in:306
  integer :: num_enable_isend_opts_comp2io, num_enable_isend_opts_io2comp   ! pio_rearr_opts.F90.in:307
  integer, parameter :: NUM_MAX_PEND_REQ_OPTS = 2   ! pio_rearr_opts.F90.in:308
  integer :: max_pend_req_opts(NUM_MAX_PEND_REQ_OPTS) = &
                  (/pio_rearr_comm_unlimited_pend_req, 2/)   ! pio_rearr_opts.F90.in:310
  integer :: num_max_pend_req_opts_comp2io, num_max_pend_req_opts_io2comp   ! pio_rearr_opts.F90.in:311


  type(iosystem_desc_t) :: dup_iosys   ! pio_rearr_opts.F90.in:313
  integer :: dup_comm   ! pio_rearr_opts.F90.in:314
  integer :: cur_rearr, cur_comm_type_opt, cur_fcd_opt, cur_enable_hs_c2i, &
              cur_enable_isend_c2i, cur_max_pend_req_c2i, &
              cur_enable_hs_i2c, cur_enable_isend_i2c, cur_max_pend_req_i2c   ! pio_rearr_opts.F90.in:317


  type(file_desc_t) :: pio_file   ! pio_rearr_opts.F90.in:319
  type(io_desc_t) :: iodesc   ! pio_rearr_opts.F90.in:320
  type(var_desc_t) :: pio_var   ! pio_rearr_opts.F90.in:321
  integer, dimension(1) :: dims   ! pio_rearr_opts.F90.in:322


  real, dimension(:), allocatable :: rbuf, wbuf   ! pio_rearr_opts.F90.in:324


  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_rearr_opts.F90.in:327
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_rearr_opts.F90.in:328
  integer :: num_iotypes   ! pio_rearr_opts.F90.in:329
  integer :: ret, i   ! pio_rearr_opts.F90.in:330


  num_iotypes = 0   ! pio_rearr_opts.F90.in:332
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_rearr_opts.F90.in:333
  do i=1,num_iotypes   ! pio_rearr_opts.F90.in:334

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : ", iotype_descs(i)
      END IF
    END IF   ! pio_rearr_opts.F90.in:335
    ! Create the file and decomp 
    call create_file_and_var(iotypes(i), ret)   ! pio_rearr_opts.F90.in:337
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Creating file/decomp/var reqd for test failed :" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr_opts.F90.in:338)"
      END IF
      RETURN
    END IF   ! pio_rearr_opts.F90.in:338


    call MPI_Comm_dup(pio_tf_comm_, dup_comm, ret)   ! pio_rearr_opts.F90.in:340


    ! Test all combinations of these flow control parameters
    do cur_rearr=1,NUM_REARRANGERS   ! pio_rearr_opts.F90.in:343

      IF (pio_tf_world_rank_ == 0) THEN
        IF (pio_tf_log_level_ >= 0) THEN
          WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
          WRITE(*,*)  "Testing ", rearrs_info(cur_rearr)
        END IF
      END IF   ! pio_rearr_opts.F90.in:344
      do cur_comm_type_opt=1,NUM_COMM_TYPE_OPTS   ! pio_rearr_opts.F90.in:345
        pio_rearr_opts%comm_type = comm_type_opts(cur_comm_type_opt)   ! pio_rearr_opts.F90.in:346
        if(pio_rearr_opts%comm_type == pio_rearr_comm_coll) then   ! pio_rearr_opts.F90.in:347
          ! For coll we only test pio_rearr_comm_fc_2d_disable
          num_fcd_opts_comm_type = 1   ! pio_rearr_opts.F90.in:349
        else if(pio_rearr_opts%comm_type == pio_rearr_comm_p2p) then   ! pio_rearr_opts.F90.in:350
          ! for p2p we test all possible combinations
          num_fcd_opts_comm_type = NUM_FCD_OPTS   ! pio_rearr_opts.F90.in:352
        else   ! pio_rearr_opts.F90.in:353
          
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: Fatal Error:",&
              "Unexpected comm type",&
               ":", __FILE__, ":", __LINE__,&
              "(pio_rearr_opts.F90.in:354)"
          END IF
          RETURN   ! pio_rearr_opts.F90.in:354
        end if   ! pio_rearr_opts.F90.in:355
        do cur_fcd_opt=1,num_fcd_opts_comm_type   ! pio_rearr_opts.F90.in:356
          pio_rearr_opts%fcd = fcd_opts(cur_fcd_opt)   ! pio_rearr_opts.F90.in:357
          if(pio_rearr_opts%fcd == pio_rearr_comm_fc_2d_enable) then   ! pio_rearr_opts.F90.in:358
            num_enable_hs_opts_comp2io = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts.F90.in:359
            num_enable_hs_opts_io2comp = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts.F90.in:360
            num_enable_isend_opts_comp2io = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts.F90.in:361
            num_enable_isend_opts_io2comp = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts.F90.in:362
            num_max_pend_req_opts_comp2io = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts.F90.in:363
            num_max_pend_req_opts_io2comp = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts.F90.in:364
          else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_1d_comp2io) then   ! pio_rearr_opts.F90.in:365
            ! Only test different rearr opts in comp2io direction
            num_enable_hs_opts_comp2io = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts.F90.in:367
            num_enable_hs_opts_io2comp = 1   ! pio_rearr_opts.F90.in:368
            num_enable_isend_opts_comp2io = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts.F90.in:369
            num_enable_isend_opts_io2comp = 1   ! pio_rearr_opts.F90.in:370
            num_max_pend_req_opts_comp2io = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts.F90.in:371
            num_max_pend_req_opts_io2comp = 1   ! pio_rearr_opts.F90.in:372
          else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_1d_io2comp) then   ! pio_rearr_opts.F90.in:373
            ! Only test different rearr opts in io2comp direction
            num_enable_hs_opts_comp2io = 1   ! pio_rearr_opts.F90.in:375
            num_enable_hs_opts_io2comp = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts.F90.in:376
            num_enable_isend_opts_comp2io = 1   ! pio_rearr_opts.F90.in:377
            num_enable_isend_opts_io2comp = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts.F90.in:378
            num_max_pend_req_opts_comp2io = 1   ! pio_rearr_opts.F90.in:379
            num_max_pend_req_opts_io2comp = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts.F90.in:380
          else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_2d_disable) then   ! pio_rearr_opts.F90.in:381
            ! Just test one default combination
            num_enable_hs_opts_comp2io = 1   ! pio_rearr_opts.F90.in:383
            num_enable_hs_opts_io2comp = 1   ! pio_rearr_opts.F90.in:384
            num_enable_isend_opts_comp2io = 1   ! pio_rearr_opts.F90.in:385
            num_enable_isend_opts_io2comp = 1   ! pio_rearr_opts.F90.in:386
            num_max_pend_req_opts_comp2io = 1   ! pio_rearr_opts.F90.in:387
            num_max_pend_req_opts_io2comp = 1   ! pio_rearr_opts.F90.in:388
          else   ! pio_rearr_opts.F90.in:389
            
            pio_tf_retval_utest_ = -1
            IF (pio_tf_world_rank_ == 0) THEN
              PRINT *, "PIO_TF: Fatal Error:",&
                "Unexpected flow control option",&
                 ":", __FILE__, ":", __LINE__,&
                "(pio_rearr_opts.F90.in:390)"
            END IF
            RETURN   ! pio_rearr_opts.F90.in:390
          end if   ! pio_rearr_opts.F90.in:391
          do cur_enable_hs_c2i=1,num_enable_hs_opts_comp2io   ! pio_rearr_opts.F90.in:392
            pio_rearr_opts%comm_fc_opts_comp2io%enable_hs = &
                  enable_hs_opts(cur_enable_hs_c2i)   ! pio_rearr_opts.F90.in:394


            do cur_enable_isend_c2i=1,num_enable_isend_opts_comp2io   ! pio_rearr_opts.F90.in:396
              pio_rearr_opts%comm_fc_opts_comp2io%enable_isend = &
                    enable_isend_opts(cur_enable_isend_c2i)   ! pio_rearr_opts.F90.in:398


              do cur_max_pend_req_c2i=1,num_max_pend_req_opts_comp2io   ! pio_rearr_opts.F90.in:400
                pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req = &
                    max_pend_req_opts(cur_max_pend_req_c2i)   ! pio_rearr_opts.F90.in:402


                do cur_enable_hs_i2c=1,num_enable_hs_opts_io2comp   ! pio_rearr_opts.F90.in:404
                  pio_rearr_opts%comm_fc_opts_io2comp%enable_hs =&
                    enable_hs_opts(cur_enable_hs_i2c)   ! pio_rearr_opts.F90.in:406


                  do cur_enable_isend_i2c=1,num_enable_isend_opts_io2comp   ! pio_rearr_opts.F90.in:408
                    pio_rearr_opts%comm_fc_opts_io2comp%enable_isend =&
                      enable_isend_opts(cur_enable_isend_i2c)   ! pio_rearr_opts.F90.in:410


                    do cur_max_pend_req_i2c=1,num_max_pend_req_opts_io2comp   ! pio_rearr_opts.F90.in:412
                      pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req =&
                        max_pend_req_opts(cur_max_pend_req_i2c)   ! pio_rearr_opts.F90.in:414


                      call print_rearr_opts(pio_rearr_opts, ret)   ! pio_rearr_opts.F90.in:416
                      ! Ignoring return value - just printing for info
                      call PIO_init(pio_tf_world_rank_,&
                                      dup_comm, pio_tf_world_sz_, &
                                      1, &! Num aggregators
                                      1, &! Stride
                                      rearrs(cur_rearr),&
                                      dup_iosys, base=0,&
                                      rearr_opts=pio_rearr_opts)   ! pio_rearr_opts.F90.in:424


                      call PIO_seterrorhandling(dup_iosys, PIO_BCAST_ERROR)   ! pio_rearr_opts.F90.in:426


                      call create_decomp_and_init_buf(dup_iosys, dup_comm, iodesc, wbuf, dims, ret)   ! pio_rearr_opts.F90.in:428
                      
                      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
                        call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_tmp_comm_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Function failed:",&
                             "Creating decomp failed",&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:429)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:429


                      allocate(rbuf(size(wbuf)))   ! pio_rearr_opts.F90.in:431
                      rbuf = 0   ! pio_rearr_opts.F90.in:432


                      call open_file_and_get_var(dup_iosys, pio_file, iotypes(i),&
                              pio_var, ret)   ! pio_rearr_opts.F90.in:435
                      
                      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
                        call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_tmp_comm_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Function failed:",&
                             "Creating file/decomp/var reqd for test failed :" // trim(tgv_fname),&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:436)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:436


                      call PIO_write_darray(pio_file, pio_var, iodesc, wbuf, ret)   ! pio_rearr_opts.F90.in:438
                      
                      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
                        call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_tmp_comm_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Function failed:",&
                             "Writing var failed fname="//trim(tgv_fname),&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:439)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:439


                      call PIO_syncfile(pio_file)   ! pio_rearr_opts.F90.in:441


                      call PIO_read_darray(pio_file, pio_var, iodesc, rbuf, ret)   ! pio_rearr_opts.F90.in:443
                      
                      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR,  dup_comm))) THEN
                        call MPI_COMM_RANK( dup_comm, pio_tf_tmp_comm_rank_, pio_tf_retval_utest_)
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_tmp_comm_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Function failed:",&
                             "Reading var failed fname="//trim(tgv_fname),&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:444)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:444


                      
                      IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_world_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Check failed:",&
                             "Got wrong val",&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:446)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:446


                      call PIO_freedecomp(dup_iosys, iodesc)   ! pio_rearr_opts.F90.in:448


                      deallocate(rbuf)   ! pio_rearr_opts.F90.in:450
                      if(allocated(wbuf)) then   ! pio_rearr_opts.F90.in:451
                        deallocate(wbuf)   ! pio_rearr_opts.F90.in:452
                      end if   ! pio_rearr_opts.F90.in:453


                      call PIO_closefile(pio_file)   ! pio_rearr_opts.F90.in:455


                      call PIO_finalize(dup_iosys, ret)   ! pio_rearr_opts.F90.in:457
                      
                      IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
                        pio_tf_retval_utest_ = -1
                        IF (pio_tf_world_rank_ == 0) THEN
                          PRINT *, "PIO_TF: PIO Function failed:",&
                             "Finalize failed",&
                            ":", __FILE__, ":", __LINE__,&
                            "(pio_rearr_opts.F90.in:458)"
                        END IF
                        RETURN
                      END IF   ! pio_rearr_opts.F90.in:458
                    end do ! cur_max_pend_req_i2c   ! pio_rearr_opts.F90.in:459
                  end do ! cur_enable_isend_i2c   ! pio_rearr_opts.F90.in:460
                end do ! cur_enable_hs_i2c   ! pio_rearr_opts.F90.in:461
              end do ! cur_max_pend_req_c2i       ! pio_rearr_opts.F90.in:462
            end do ! cur_enable_isend_c2i   ! pio_rearr_opts.F90.in:463
          end do ! cur_enable_hs_c2i   ! pio_rearr_opts.F90.in:464
        end do ! cur_fcd_opt   ! pio_rearr_opts.F90.in:465
      end do ! cur_comm_type_opt   ! pio_rearr_opts.F90.in:466
    end do ! cur_rearr   ! pio_rearr_opts.F90.in:467


    call PIO_deletefile(pio_tf_iosystem_, trim(tgv_fname))   ! pio_rearr_opts.F90.in:469


    call MPI_Comm_free(dup_comm, ret)   ! pio_rearr_opts.F90.in:471
  end do ! iotypes   ! pio_rearr_opts.F90.in:472


  if(allocated(iotypes)) then   ! pio_rearr_opts.F90.in:474
    deallocate(iotypes)   ! pio_rearr_opts.F90.in:475
    deallocate(iotype_descs)   ! pio_rearr_opts.F90.in:476
  end if   ! pio_rearr_opts.F90.in:477


END SUBROUTINE write_with_rearr_opts   ! pio_rearr_opts.F90.in:479


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting init_fin_with_rearr_opts"
    END IF
    CALL init_fin_with_rearr_opts()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "init_fin_with_rearr_opts","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "init_fin_with_rearr_opts","-----------", "FAILED"
      END IF
    END IF
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting write_with_rearr_opts"
    END IF
    CALL write_with_rearr_opts()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "write_with_rearr_opts","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 2:",&
          "write_with_rearr_opts","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
