! DON'T MODIFY THIS FILE, ALL YOUR CHANGES WILL BE LOST
! This file is generated by util/pio_tf_f90gen.pl
! from pio_rearr_opts2.F90.in

#include "config.h"
MODULE pio_rearr_opts_tgv   ! pio_rearr_opts2.F90.in:2
  use pio_tutil   ! pio_rearr_opts2.F90.in:3
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_fname ="pio_rearr_opts2_test.nc"   ! pio_rearr_opts2.F90.in:4
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_var_name ="dummy_var"   ! pio_rearr_opts2.F90.in:5
  character(len=PIO_TF_MAX_STR_LEN), parameter ::tgv_dim_name ="dummy_dim"   ! pio_rearr_opts2.F90.in:6
END MODULE pio_rearr_opts_tgv   ! pio_rearr_opts2.F90.in:7


SUBROUTINE print_rearr_opts(pio_rearr_opts, ret)   ! pio_rearr_opts2.F90.in:9
  use pio_tutil   ! pio_rearr_opts2.F90.in:10
  implicit none   ! pio_rearr_opts2.F90.in:11


  type(pio_rearr_opt_t), intent(in) :: pio_rearr_opts   ! pio_rearr_opts2.F90.in:13
  integer, intent(inout) :: ret   ! pio_rearr_opts2.F90.in:14


  ret = PIO_NOERR   ! pio_rearr_opts2.F90.in:16



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  "PIO rearranger options :"
    END IF
  END IF   ! pio_rearr_opts2.F90.in:18
  if(pio_rearr_opts%comm_type == PIO_rearr_comm_p2p) then   ! pio_rearr_opts2.F90.in:19

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = PIO_rearr_comm_p2p"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:20
  else if(pio_rearr_opts%comm_type == PIO_rearr_comm_coll) then   ! pio_rearr_opts2.F90.in:21

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = PIO_rearr_comm_coll"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:22
  else   ! pio_rearr_opts2.F90.in:23

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comm_type = INVALID"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:24
  end if   ! pio_rearr_opts2.F90.in:25


  if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_2d_enable) then   ! pio_rearr_opts2.F90.in:27

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_2d_enable"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:28
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_1d_comp2io) then   ! pio_rearr_opts2.F90.in:29

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_1d_comp2io"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:30
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_1d_io2comp) then   ! pio_rearr_opts2.F90.in:31

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_1d_io2comp"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:32
  else if(pio_rearr_opts%fcd == PIO_rearr_comm_fc_2d_disable) then   ! pio_rearr_opts2.F90.in:33

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = PIO_rearr_comm_fc_2d_disable"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:34
  else   ! pio_rearr_opts2.F90.in:35

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " fcd = INVALID"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:36
  end if   ! pio_rearr_opts2.F90.in:37



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  " comp2io max_pend_req =", pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req
    END IF
  END IF   ! pio_rearr_opts2.F90.in:39
  if(pio_rearr_opts%comm_fc_opts_comp2io%enable_hs) then   ! pio_rearr_opts2.F90.in:40

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_hs = TRUE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:41
  else   ! pio_rearr_opts2.F90.in:42

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_hs = FALSE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:43
  end if   ! pio_rearr_opts2.F90.in:44
  if(pio_rearr_opts%comm_fc_opts_comp2io%enable_isend) then   ! pio_rearr_opts2.F90.in:45

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_isend = TRUE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:46
  else   ! pio_rearr_opts2.F90.in:47

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " comp2io enable_isend = FALSE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:48
  end if   ! pio_rearr_opts2.F90.in:49



  IF (pio_tf_world_rank_ == 0) THEN
    IF (pio_tf_log_level_ >= 0) THEN
      WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
      WRITE(*,*)  " io2comp max_pend_req =", pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req
    END IF
  END IF   ! pio_rearr_opts2.F90.in:51
  if(pio_rearr_opts%comm_fc_opts_io2comp%enable_hs) then   ! pio_rearr_opts2.F90.in:52

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_hs = TRUE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:53
  else   ! pio_rearr_opts2.F90.in:54

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_hs = FALSE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:55
  end if   ! pio_rearr_opts2.F90.in:56
  if(pio_rearr_opts%comm_fc_opts_io2comp%enable_isend) then   ! pio_rearr_opts2.F90.in:57

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_isend = TRUE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:58
  else   ! pio_rearr_opts2.F90.in:59

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  " io2comp enable_isend = FALSE"
      END IF
    END IF   ! pio_rearr_opts2.F90.in:60
  end if   ! pio_rearr_opts2.F90.in:61


END SUBROUTINE print_rearr_opts   ! pio_rearr_opts2.F90.in:63


! If force_rearrange is FALSE, the decomposition is such that
! # All even procs have VEC_LOCAL_SZ elements
! # All odd procs have VEC_LOCAL_SZ + 1 elements
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [1,2] [3,4,5] [6,7]
! e.g. 2)    [1,2] [3,4,5] [6,7] [8,9,10]
! e.g. 3)    [1,2] [3,4,5] [6,7] [8,9,10] [11,12]
! If force_rearrange is TRUE, the decomposition is such that,
! If possible, the even rank "exchanges" elements with the next
! higher ranked odd proc.
! This for example can be used to force rearrangement when reading
! or writing data.
! e.g. For VEC_LOCAL_SZ = 2,
! e.g. 1)    [3,4,5] [1,2] [6,7]
! e.g. 2)    [3,4,5] [1,2] [8,9,10] [6,7]
! e.g. 3)    [3,4,5] [1,2] [8,9,10] [6,7] [11,12]
SUBROUTINE get_1d_bc_info(rank, sz, dims, start, count, force_rearrange)   ! pio_rearr_opts2.F90.in:81
  implicit none   ! pio_rearr_opts2.F90.in:82


  integer, parameter :: VEC_LOCAL_SZ = 3   ! pio_rearr_opts2.F90.in:84
  integer, intent(in) :: rank   ! pio_rearr_opts2.F90.in:85
  integer, intent(in) :: sz   ! pio_rearr_opts2.F90.in:86
  integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts2.F90.in:87
  integer, dimension(1), intent(out) :: start   ! pio_rearr_opts2.F90.in:88
  integer, dimension(1), intent(out) :: count   ! pio_rearr_opts2.F90.in:89
  logical, intent(in) :: force_rearrange   ! pio_rearr_opts2.F90.in:90


  logical :: is_even_rank   ! pio_rearr_opts2.F90.in:92
  integer :: num_odd_procs, num_even_procs   ! pio_rearr_opts2.F90.in:93
  integer :: iodd, ieven   ! pio_rearr_opts2.F90.in:94


  is_even_rank = .false.   ! pio_rearr_opts2.F90.in:96
  if (mod(rank, 2) == 0) then   ! pio_rearr_opts2.F90.in:97
    is_even_rank = .true.   ! pio_rearr_opts2.F90.in:98
  end if   ! pio_rearr_opts2.F90.in:99
  num_odd_procs = sz / 2   ! pio_rearr_opts2.F90.in:100
  num_even_procs = sz - num_odd_procs   ! pio_rearr_opts2.F90.in:101
  dims(1) = num_even_procs * VEC_LOCAL_SZ + num_odd_procs * (VEC_LOCAL_SZ + 1)   ! pio_rearr_opts2.F90.in:102
  ! Number of odd and even procs before this rank
  iodd = rank / 2   ! pio_rearr_opts2.F90.in:104
  ieven = (rank + 1) / 2   ! pio_rearr_opts2.F90.in:105
  if(force_rearrange) then   ! pio_rearr_opts2.F90.in:106
    ! Make sure that we force rearrangement
    if (is_even_rank) then   ! pio_rearr_opts2.F90.in:108
      if(rank + 1 < sz) then   ! pio_rearr_opts2.F90.in:109
        ! Force rearrangement
        count(1) = VEC_LOCAL_SZ + 1   ! pio_rearr_opts2.F90.in:111
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + (VEC_LOCAL_SZ) + 1   ! pio_rearr_opts2.F90.in:112
      else   ! pio_rearr_opts2.F90.in:113
        count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts2.F90.in:114
        start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_rearr_opts2.F90.in:115
      end if   ! pio_rearr_opts2.F90.in:116
    else   ! pio_rearr_opts2.F90.in:117
      ! For all odd procs there is an even lower ranked, rank-1, proc
      ! So force rearrangement
      count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts2.F90.in:120
      start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) - (VEC_LOCAL_SZ) + 1   ! pio_rearr_opts2.F90.in:121
    end if   ! pio_rearr_opts2.F90.in:122
  else   ! pio_rearr_opts2.F90.in:123
    if (is_even_rank) then   ! pio_rearr_opts2.F90.in:124
      count(1) = VEC_LOCAL_SZ   ! pio_rearr_opts2.F90.in:125
    else   ! pio_rearr_opts2.F90.in:126
      count(1) = VEC_LOCAL_SZ + 1   ! pio_rearr_opts2.F90.in:127
    end if   ! pio_rearr_opts2.F90.in:128
    start(1) = ieven * VEC_LOCAL_SZ + iodd * (VEC_LOCAL_SZ + 1) + 1   ! pio_rearr_opts2.F90.in:129
  end if   ! pio_rearr_opts2.F90.in:130


END SUBROUTINE   ! pio_rearr_opts2.F90.in:132


! Create a decomp that will be used by tests below
! The iodesc needs to be freed by the caller
SUBROUTINE create_decomp_and_init_buf(iodesc, wbuf, dims, ret)   ! pio_rearr_opts2.F90.in:136
  use pio_tutil   ! pio_rearr_opts2.F90.in:137
  implicit none   ! pio_rearr_opts2.F90.in:138


  type(io_desc_t), intent(out) :: iodesc   ! pio_rearr_opts2.F90.in:140
  real, dimension(:), allocatable, intent(inout) :: wbuf   ! pio_rearr_opts2.F90.in:141
  integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts2.F90.in:142
  integer, intent(out) :: ret   ! pio_rearr_opts2.F90.in:143


  integer, dimension(:), allocatable :: compdof   ! pio_rearr_opts2.F90.in:145
  integer, dimension(1) :: start, count   ! pio_rearr_opts2.F90.in:146
  integer :: i   ! pio_rearr_opts2.F90.in:147


  ret = PIO_NOERR   ! pio_rearr_opts2.F90.in:149


  call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_rearr_opts2.F90.in:151
  allocate(wbuf(count(1)))   ! pio_rearr_opts2.F90.in:152
  allocate(compdof(count(1)))   ! pio_rearr_opts2.F90.in:153
  do i=1,count(1)   ! pio_rearr_opts2.F90.in:154
    wbuf(i) = start(1) + i - 1   ! pio_rearr_opts2.F90.in:155
    compdof(i) = int(wbuf(i))   ! pio_rearr_opts2.F90.in:156
  end do   ! pio_rearr_opts2.F90.in:157


  call PIO_initdecomp(pio_tf_iosystem_, PIO_real, dims, compdof, iodesc)   ! pio_rearr_opts2.F90.in:159
  deallocate(compdof)   ! pio_rearr_opts2.F90.in:160


END SUBROUTINE   ! pio_rearr_opts2.F90.in:162


! Create file and var used in the tests below
! All details are picked from pio_rearr_opts_tgv module
SUBROUTINE create_file_and_var(iotype, ret)   ! pio_rearr_opts2.F90.in:166
  use pio_tutil   ! pio_rearr_opts2.F90.in:167
  use pio_rearr_opts_tgv   ! pio_rearr_opts2.F90.in:168
  implicit none   ! pio_rearr_opts2.F90.in:169


  integer, intent(in) :: iotype   ! pio_rearr_opts2.F90.in:171
  integer, intent(out) :: ret   ! pio_rearr_opts2.F90.in:172


  type(file_desc_t) :: pio_file   ! pio_rearr_opts2.F90.in:174
  type(var_desc_t) :: pio_var   ! pio_rearr_opts2.F90.in:175
  integer :: pio_dim   ! pio_rearr_opts2.F90.in:176
  integer, dimension(1) :: dims   ! pio_rearr_opts2.F90.in:177
  integer, dimension(1) :: start, count   ! pio_rearr_opts2.F90.in:178


  call get_1d_bc_info(pio_tf_world_rank_, pio_tf_world_sz_, dims, start, count, .true.)   ! pio_rearr_opts2.F90.in:180


  ret = PIO_createfile(pio_tf_iosystem_, pio_file, iotype, tgv_fname, PIO_CLOBBER)   ! pio_rearr_opts2.F90.in:182
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:183)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:183


  ret = PIO_def_dim(pio_file, tgv_dim_name, dims(1), pio_dim)   ! pio_rearr_opts2.F90.in:185
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define dim file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:186)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:186


  ret = PIO_def_var(pio_file, tgv_var_name, pio_real, (/pio_dim/), pio_var)   ! pio_rearr_opts2.F90.in:188
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to define var file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:189)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:189


  ret = PIO_enddef(pio_file)   ! pio_rearr_opts2.F90.in:191
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Failed to enddef file =" // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:192)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:192


  call PIO_closefile(pio_file)   ! pio_rearr_opts2.F90.in:194


END SUBROUTINE   ! pio_rearr_opts2.F90.in:196


! Open file and inq var
! All details are picked from pio_rearr_opts_tgv module
! Note: The file is kept open so the called needs to close it
SUBROUTINE open_file_and_get_var(pio_file, iotype, pio_var, ret)   ! pio_rearr_opts2.F90.in:201
  use pio_tutil   ! pio_rearr_opts2.F90.in:202
  use pio_rearr_opts_tgv   ! pio_rearr_opts2.F90.in:203
  implicit none   ! pio_rearr_opts2.F90.in:204


  type(file_desc_t), intent(out) :: pio_file   ! pio_rearr_opts2.F90.in:206
  integer, intent(in) :: iotype   ! pio_rearr_opts2.F90.in:207
  type(var_desc_t), intent(out) :: pio_var   ! pio_rearr_opts2.F90.in:208
  integer, intent(out) :: ret   ! pio_rearr_opts2.F90.in:209


  ret = PIO_openfile(pio_tf_iosystem_, pio_file, iotype, tgv_fname, pio_write)   ! pio_rearr_opts2.F90.in:211
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not create file " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:212)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:212


  ret = PIO_inq_varid(pio_file, tgv_var_name, pio_var)   ! pio_rearr_opts2.F90.in:214
  
  IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
    pio_tf_retval_utest_ = -1
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: PIO Function failed:",&
         "Could not inq var " // trim(tgv_fname),&
        ":", __FILE__, ":", __LINE__,&
        "(pio_rearr_opts2.F90.in:215)"
    END IF
    RETURN
  END IF   ! pio_rearr_opts2.F90.in:215


END SUBROUTINE   ! pio_rearr_opts2.F90.in:217


! Test all possible combinations of rearranger options
! using the pio interface to explicitly set the rearranger options
! after init.
SUBROUTINE set_rearr_opts_and_write
  USE pio_tutil
   ! pio_rearr_opts2.F90.in:222
  use pio_rearr_opts_tgv   ! pio_rearr_opts2.F90.in:223
  implicit none   ! pio_rearr_opts2.F90.in:224
  interface   ! pio_rearr_opts2.F90.in:225
    subroutine create_decomp_and_init_buf(iodesc, wbuf, dims, ret)   ! pio_rearr_opts2.F90.in:226
      use pio_tutil   ! pio_rearr_opts2.F90.in:227
      type(io_desc_t), intent(out) :: iodesc   ! pio_rearr_opts2.F90.in:228
      real, dimension(:), allocatable, intent(inout) :: wbuf   ! pio_rearr_opts2.F90.in:229
      integer, dimension(1), intent(out) :: dims   ! pio_rearr_opts2.F90.in:230
      integer, intent(out) :: ret   ! pio_rearr_opts2.F90.in:231
    end subroutine create_decomp_and_init_buf   ! pio_rearr_opts2.F90.in:232
  end interface    ! pio_rearr_opts2.F90.in:233


  type(pio_rearr_opt_t) :: pio_rearr_opts   ! pio_rearr_opts2.F90.in:235


  ! Different rearranger options that are tested here
  integer, parameter :: NUM_COMM_TYPE_OPTS = 2   ! pio_rearr_opts2.F90.in:238
  integer :: comm_type_opts(NUM_COMM_TYPE_OPTS) =&
                  (/pio_rearr_comm_p2p,pio_rearr_comm_coll/)   ! pio_rearr_opts2.F90.in:240
  integer, parameter :: NUM_FCD_OPTS = 4   ! pio_rearr_opts2.F90.in:241
  integer :: fcd_opts(NUM_FCD_OPTS) = &
                  (/pio_rearr_comm_fc_2d_disable,&
                    pio_rearr_comm_fc_1d_comp2io,&
                    pio_rearr_comm_fc_1d_io2comp,&
                    pio_rearr_comm_fc_2d_enable/)   ! pio_rearr_opts2.F90.in:246
  integer :: num_fcd_opts_comm_type   ! pio_rearr_opts2.F90.in:247
  integer, parameter :: NUM_ENABLE_HS_OPTS = 2   ! pio_rearr_opts2.F90.in:248
  logical :: enable_hs_opts(NUM_ENABLE_HS_OPTS) = (/.true.,.false./)   ! pio_rearr_opts2.F90.in:249
  integer :: num_enable_hs_opts_comp2io, num_enable_hs_opts_io2comp   ! pio_rearr_opts2.F90.in:250
  integer, parameter :: NUM_ENABLE_ISEND_OPTS = 2   ! pio_rearr_opts2.F90.in:251
  logical :: enable_isend_opts(NUM_ENABLE_ISEND_OPTS) = (/.true.,.false./)   ! pio_rearr_opts2.F90.in:252
  integer :: num_enable_isend_opts_comp2io, num_enable_isend_opts_io2comp   ! pio_rearr_opts2.F90.in:253
  integer, parameter :: NUM_MAX_PEND_REQ_OPTS = 3   ! pio_rearr_opts2.F90.in:254
  integer :: max_pend_req_opts(NUM_MAX_PEND_REQ_OPTS) = &
                  (/pio_rearr_comm_unlimited_pend_req, 1, 2/)   ! pio_rearr_opts2.F90.in:256
  integer :: num_max_pend_req_opts_comp2io, num_max_pend_req_opts_io2comp   ! pio_rearr_opts2.F90.in:257


  integer ::  cur_comm_type_opt, cur_fcd_opt, cur_enable_hs_c2i, &
              cur_enable_isend_c2i, cur_max_pend_req_c2i, &
              cur_enable_hs_i2c, cur_enable_isend_i2c, cur_max_pend_req_i2c   ! pio_rearr_opts2.F90.in:261


  type(file_desc_t) :: pio_file   ! pio_rearr_opts2.F90.in:263
  type(io_desc_t) :: iodesc   ! pio_rearr_opts2.F90.in:264
  type(var_desc_t) :: pio_var   ! pio_rearr_opts2.F90.in:265
  integer, dimension(1) :: dims   ! pio_rearr_opts2.F90.in:266


  real, dimension(:), allocatable :: rbuf, wbuf   ! pio_rearr_opts2.F90.in:268


  ! iotypes = valid io types
  integer, dimension(:), allocatable :: iotypes   ! pio_rearr_opts2.F90.in:271
  character(len=PIO_TF_MAX_STR_LEN), dimension(:), allocatable :: iotype_descs   ! pio_rearr_opts2.F90.in:272
  integer :: num_iotypes   ! pio_rearr_opts2.F90.in:273
  integer :: ret, i   ! pio_rearr_opts2.F90.in:274


  num_iotypes = 0   ! pio_rearr_opts2.F90.in:276
  call PIO_TF_Get_nc_iotypes(iotypes, iotype_descs, num_iotypes)   ! pio_rearr_opts2.F90.in:277
  do i=1,num_iotypes   ! pio_rearr_opts2.F90.in:278

    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_log_level_ >= 0) THEN
        WRITE(*,"(A)",ADVANCE="NO") "PIO_TF: "
        WRITE(*,*)  "Testing : ", iotype_descs(i)
      END IF
    END IF   ! pio_rearr_opts2.F90.in:279
    ! Create the file and decomp 
    call create_file_and_var(iotypes(i), ret)   ! pio_rearr_opts2.F90.in:281
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Creating file/decomp/var reqd for test failed :" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr_opts2.F90.in:282)"
      END IF
      RETURN
    END IF   ! pio_rearr_opts2.F90.in:282


    call open_file_and_get_var(pio_file, iotypes(i), pio_var, ret)   ! pio_rearr_opts2.F90.in:284
    
    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
      pio_tf_retval_utest_ = -1
      IF (pio_tf_world_rank_ == 0) THEN
        PRINT *, "PIO_TF: PIO Function failed:",&
           "Creating file/decomp/var reqd for test failed :" // trim(tgv_fname),&
          ":", __FILE__, ":", __LINE__,&
          "(pio_rearr_opts2.F90.in:285)"
      END IF
      RETURN
    END IF   ! pio_rearr_opts2.F90.in:285


    ! Test all combinations of these flow control parameters
    do cur_comm_type_opt=1,NUM_COMM_TYPE_OPTS   ! pio_rearr_opts2.F90.in:288
      pio_rearr_opts%comm_type = comm_type_opts(cur_comm_type_opt)   ! pio_rearr_opts2.F90.in:289
      if(pio_rearr_opts%comm_type == pio_rearr_comm_coll) then   ! pio_rearr_opts2.F90.in:290
        ! For coll we only test pio_rearr_comm_fc_2d_disable
        num_fcd_opts_comm_type = 1   ! pio_rearr_opts2.F90.in:292
      else if(pio_rearr_opts%comm_type == pio_rearr_comm_p2p) then   ! pio_rearr_opts2.F90.in:293
        ! for p2p we test all possible combinations
        num_fcd_opts_comm_type = NUM_FCD_OPTS   ! pio_rearr_opts2.F90.in:295
      else   ! pio_rearr_opts2.F90.in:296
        
        pio_tf_retval_utest_ = -1
        IF (pio_tf_world_rank_ == 0) THEN
          PRINT *, "PIO_TF: Fatal Error:",&
            "Unexpected comm type",&
             ":", __FILE__, ":", __LINE__,&
            "(pio_rearr_opts2.F90.in:297)"
        END IF
        RETURN   ! pio_rearr_opts2.F90.in:297
      end if   ! pio_rearr_opts2.F90.in:298
      do cur_fcd_opt=1,num_fcd_opts_comm_type   ! pio_rearr_opts2.F90.in:299
        pio_rearr_opts%fcd = fcd_opts(cur_fcd_opt)   ! pio_rearr_opts2.F90.in:300
        if(pio_rearr_opts%fcd == pio_rearr_comm_fc_2d_enable) then   ! pio_rearr_opts2.F90.in:301
          num_enable_hs_opts_comp2io = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts2.F90.in:302
          num_enable_hs_opts_io2comp = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts2.F90.in:303
          num_enable_isend_opts_comp2io = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts2.F90.in:304
          num_enable_isend_opts_io2comp = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts2.F90.in:305
          num_max_pend_req_opts_comp2io = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts2.F90.in:306
          num_max_pend_req_opts_io2comp = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts2.F90.in:307
        else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_1d_comp2io) then   ! pio_rearr_opts2.F90.in:308
          ! Only test different rearr opts in comp2io direction
          num_enable_hs_opts_comp2io = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts2.F90.in:310
          num_enable_hs_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:311
          num_enable_isend_opts_comp2io = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts2.F90.in:312
          num_enable_isend_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:313
          num_max_pend_req_opts_comp2io = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts2.F90.in:314
          num_max_pend_req_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:315
        else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_1d_io2comp) then   ! pio_rearr_opts2.F90.in:316
          ! Only test different rearr opts in io2comp direction
          num_enable_hs_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:318
          num_enable_hs_opts_io2comp = NUM_ENABLE_HS_OPTS   ! pio_rearr_opts2.F90.in:319
          num_enable_isend_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:320
          num_enable_isend_opts_io2comp = NUM_ENABLE_ISEND_OPTS   ! pio_rearr_opts2.F90.in:321
          num_max_pend_req_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:322
          num_max_pend_req_opts_io2comp = NUM_MAX_PEND_REQ_OPTS   ! pio_rearr_opts2.F90.in:323
        else if(pio_rearr_opts%fcd == pio_rearr_comm_fc_2d_disable) then   ! pio_rearr_opts2.F90.in:324
          ! Just test one default combination
          num_enable_hs_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:326
          num_enable_hs_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:327
          num_enable_isend_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:328
          num_enable_isend_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:329
          num_max_pend_req_opts_comp2io = 1   ! pio_rearr_opts2.F90.in:330
          num_max_pend_req_opts_io2comp = 1   ! pio_rearr_opts2.F90.in:331
        else   ! pio_rearr_opts2.F90.in:332
          
          pio_tf_retval_utest_ = -1
          IF (pio_tf_world_rank_ == 0) THEN
            PRINT *, "PIO_TF: Fatal Error:",&
              "Unexpected flow control option",&
               ":", __FILE__, ":", __LINE__,&
              "(pio_rearr_opts2.F90.in:333)"
          END IF
          RETURN   ! pio_rearr_opts2.F90.in:333
        end if   ! pio_rearr_opts2.F90.in:334
        do cur_enable_hs_c2i=1,num_enable_hs_opts_comp2io   ! pio_rearr_opts2.F90.in:335
          pio_rearr_opts%comm_fc_opts_comp2io%enable_hs = &
                enable_hs_opts(cur_enable_hs_c2i)   ! pio_rearr_opts2.F90.in:337


          do cur_enable_isend_c2i=1,num_enable_isend_opts_comp2io   ! pio_rearr_opts2.F90.in:339
            pio_rearr_opts%comm_fc_opts_comp2io%enable_isend = &
                  enable_isend_opts(cur_enable_isend_c2i)   ! pio_rearr_opts2.F90.in:341


            do cur_max_pend_req_c2i=1,num_max_pend_req_opts_comp2io   ! pio_rearr_opts2.F90.in:343
              pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req = &
                  max_pend_req_opts(cur_max_pend_req_c2i)   ! pio_rearr_opts2.F90.in:345


              do cur_enable_hs_i2c=1,num_enable_hs_opts_io2comp   ! pio_rearr_opts2.F90.in:347
                pio_rearr_opts%comm_fc_opts_io2comp%enable_hs =&
                  enable_hs_opts(cur_enable_hs_i2c)   ! pio_rearr_opts2.F90.in:349


                do cur_enable_isend_i2c=1,num_enable_isend_opts_io2comp   ! pio_rearr_opts2.F90.in:351
                  pio_rearr_opts%comm_fc_opts_io2comp%enable_isend =&
                    enable_isend_opts(cur_enable_isend_i2c)   ! pio_rearr_opts2.F90.in:353


                  do cur_max_pend_req_i2c=1,num_max_pend_req_opts_io2comp   ! pio_rearr_opts2.F90.in:355
                    pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req =&
                      max_pend_req_opts(cur_max_pend_req_i2c)   ! pio_rearr_opts2.F90.in:357


                    call print_rearr_opts(pio_rearr_opts, ret)   ! pio_rearr_opts2.F90.in:359
                    ! Ignoring return value - just printing for info


                    ! Set the rearranger options
                    ! rearr_opt_t descributes logicals as logical(kind=c_bool)
                    ! but pio_set_rearr_opts() expects regular logicals, hence
                    ! explicit type cast is reqd for logical params
                    ret = PIO_set_rearr_opts(pio_tf_iosystem_,&
                            pio_rearr_opts%comm_type,&
                            pio_rearr_opts%fcd,&
                            logical(pio_rearr_opts%comm_fc_opts_comp2io%enable_hs),&
                            logical(pio_rearr_opts%comm_fc_opts_comp2io%enable_isend),&
                            pio_rearr_opts%comm_fc_opts_comp2io%max_pend_req,&
                            logical(pio_rearr_opts%comm_fc_opts_io2comp%enable_hs),&
                            logical(pio_rearr_opts%comm_fc_opts_io2comp%enable_isend),&
                            pio_rearr_opts%comm_fc_opts_io2comp%max_pend_req)   ! pio_rearr_opts2.F90.in:374
                    
                    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
                      pio_tf_retval_utest_ = -1
                      IF (pio_tf_world_rank_ == 0) THEN
                        PRINT *, "PIO_TF: PIO Function failed:",&
                           "Setting rearr opts failed fname="//trim(tgv_fname),&
                          ":", __FILE__, ":", __LINE__,&
                          "(pio_rearr_opts2.F90.in:375)"
                      END IF
                      RETURN
                    END IF   ! pio_rearr_opts2.F90.in:375


                    call create_decomp_and_init_buf(iodesc, wbuf, dims, ret)   ! pio_rearr_opts2.F90.in:377
                    
                    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
                      pio_tf_retval_utest_ = -1
                      IF (pio_tf_world_rank_ == 0) THEN
                        PRINT *, "PIO_TF: PIO Function failed:",&
                           "Creating decomp failed",&
                          ":", __FILE__, ":", __LINE__,&
                          "(pio_rearr_opts2.F90.in:378)"
                      END IF
                      RETURN
                    END IF   ! pio_rearr_opts2.F90.in:378


                    allocate(rbuf(size(wbuf)))   ! pio_rearr_opts2.F90.in:380
                    rbuf = 0   ! pio_rearr_opts2.F90.in:381


                    call PIO_write_darray(pio_file, pio_var, iodesc, wbuf, ret)   ! pio_rearr_opts2.F90.in:383
                    
                    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
                      pio_tf_retval_utest_ = -1
                      IF (pio_tf_world_rank_ == 0) THEN
                        PRINT *, "PIO_TF: PIO Function failed:",&
                           "Writing var failed fname="//trim(tgv_fname),&
                          ":", __FILE__, ":", __LINE__,&
                          "(pio_rearr_opts2.F90.in:384)"
                      END IF
                      RETURN
                    END IF   ! pio_rearr_opts2.F90.in:384


                    call PIO_syncfile(pio_file)   ! pio_rearr_opts2.F90.in:386


                    call PIO_read_darray(pio_file, pio_var, iodesc, rbuf, ret)   ! pio_rearr_opts2.F90.in:388
                    
                    IF (.NOT. (PIO_TF_Passert_((ret) == PIO_NOERR, pio_tf_comm_))) THEN
                      pio_tf_retval_utest_ = -1
                      IF (pio_tf_world_rank_ == 0) THEN
                        PRINT *, "PIO_TF: PIO Function failed:",&
                           "Reading var failed fname="//trim(tgv_fname),&
                          ":", __FILE__, ":", __LINE__,&
                          "(pio_rearr_opts2.F90.in:389)"
                      END IF
                      RETURN
                    END IF   ! pio_rearr_opts2.F90.in:389


                    
                    IF (.NOT. PIO_TF_Check_val_(rbuf, wbuf)) THEN
                      pio_tf_retval_utest_ = -1
                      IF (pio_tf_world_rank_ == 0) THEN
                        PRINT *, "PIO_TF: PIO Check failed:",&
                           "Got wrong val",&
                          ":", __FILE__, ":", __LINE__,&
                          "(pio_rearr_opts2.F90.in:391)"
                      END IF
                      RETURN
                    END IF   ! pio_rearr_opts2.F90.in:391


                    call PIO_freedecomp(pio_tf_iosystem_, iodesc)   ! pio_rearr_opts2.F90.in:393


                    deallocate(rbuf)   ! pio_rearr_opts2.F90.in:395
                    if(allocated(wbuf)) then   ! pio_rearr_opts2.F90.in:396
                      deallocate(wbuf)   ! pio_rearr_opts2.F90.in:397
                    end if   ! pio_rearr_opts2.F90.in:398


                  end do ! cur_max_pend_req_i2c   ! pio_rearr_opts2.F90.in:400
                end do ! cur_enable_isend_i2c   ! pio_rearr_opts2.F90.in:401
              end do ! cur_enable_hs_i2c   ! pio_rearr_opts2.F90.in:402
            end do ! cur_max_pend_req_c2i       ! pio_rearr_opts2.F90.in:403
          end do ! cur_enable_isend_c2i   ! pio_rearr_opts2.F90.in:404
        end do ! cur_enable_hs_c2i   ! pio_rearr_opts2.F90.in:405
      end do ! cur_fcd_opt   ! pio_rearr_opts2.F90.in:406
    end do ! cur_comm_type_opt   ! pio_rearr_opts2.F90.in:407


    call PIO_closefile(pio_file)   ! pio_rearr_opts2.F90.in:409
    call PIO_deletefile(pio_tf_iosystem_, trim(tgv_fname))   ! pio_rearr_opts2.F90.in:410
  end do ! iotypes   ! pio_rearr_opts2.F90.in:411


  if(allocated(iotypes)) then   ! pio_rearr_opts2.F90.in:413
    deallocate(iotypes)   ! pio_rearr_opts2.F90.in:414
    deallocate(iotype_descs)   ! pio_rearr_opts2.F90.in:415
  end if   ! pio_rearr_opts2.F90.in:416


END SUBROUTINE set_rearr_opts_and_write   ! pio_rearr_opts2.F90.in:418


  SUBROUTINE PIO_TF_Test_driver_
    USE pio_tutil
    USE mpi, only : mpi_abort, mpi_comm_world
    IMPLICIT NONE
    integer :: mpierr
    pio_tf_retval_utest_ = 0
    IF (pio_tf_world_rank_ == 0) THEN
      PRINT *, "PIO_TF: Starting set_rearr_opts_and_write"
    END IF
    CALL set_rearr_opts_and_write()
    IF (pio_tf_retval_utest_ /= 0) THEN
      pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
    END IF
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_retval_utest_ == 0) THEN
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "set_rearr_opts_and_write","-----------", "PASSED"
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF:Test 1:",&
          "set_rearr_opts_and_write","-----------", "FAILED"
      END IF
    END IF
  END SUBROUTINE PIO_TF_Test_driver_


  PROGRAM PIO_TF_Test_main_
    USE pio_tutil
    IMPLICIT NONE
    INTEGER, PARAMETER :: NREARRS = 2
    INTEGER :: rearrs(NREARRS) = (/pio_rearr_subset,pio_rearr_box/)
    CHARACTER(LEN=PIO_TF_MAX_STR_LEN) :: rearrs_info(NREARRS) = (/"PIO_REARR_SUBSET","PIO_REARR_BOX   "/)
    INTEGER i, ierr

    pio_tf_nerrs_total_=0
    pio_tf_retval_utest_=0
    CALL MPI_Init(ierr)
    DO i=1,SIZE(rearrs)
      CALL PIO_TF_Init_(rearrs(i))
      IF (pio_tf_world_rank_ == 0) THEN
        WRITE(*,*) "PIO_TF: Testing : ", trim(rearrs_info(i))
      END IF
      CALL PIO_TF_Test_driver_()
      CALL PIO_TF_Finalize_()
    END DO
    IF (pio_tf_world_rank_ == 0) THEN
      IF (pio_tf_nerrs_total_ == 0) THEN
        IF (pio_tf_retval_utest_ == 0) THEN
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "All tests", "---------", "PASSED"
        ELSE
          pio_tf_nerrs_total_ = pio_tf_nerrs_total_ + 1
          WRITE(*,PIO_TF_TEST_RES_FMT) "PIO_TF: ",&
           "Test driver", "---------", "FAILED"
        END IF
      ELSE
        WRITE(*,PIO_TF_TEST_RES_FMT2) "PIO_TF:[",&
          pio_tf_nerrs_total_,"] Tests",&
          "----- FAILED"
      END IF
    END IF
    CALL MPI_Finalize(ierr)
    IF (pio_tf_nerrs_total_ /= 0) THEN
      STOP 99
    END IF
  END PROGRAM
