#!/bin/bash 
#PK`configure' configures HDF5 1.12.1 to adapt to many kinds of systems.
#PK
#PKUsage: ./configure [OPTION]... [VAR=VALUE]...
#PK
#PKTo assign environment variables (e.g., CC, CFLAGS...), specify them as
#PKVAR=VALUE.  See below for descriptions of some of the useful variables.
#PK
#PKDefaults for the options are specified in brackets.
#PK
#PK#PKConfiguration:
#PK   -h, --help              display this help and exit
#PK       --help=short        display options specific to this package
#PK       --help=recursive    display the short help of all the included packages
#PK   -V, --version           display version information and exit
#PK   -q, --quiet, --silent   do not print `checking ...' messages
#PK       --cache-file=FILE   cache test results in FILE [disabled]
#PK   -C, --config-cache      alias for `--cache-file=config.cache'
#PK   -n, --no-create         do not create output files
#PK       --srcdir=DIR        find the sources in DIR [configure dir or `..']
#PK
#PKInstallation directories:
#PK   --prefix=PREFIX         install architecture-independent files in PREFIX
#PK                           [/mnt/beegfs/paulo.kubota/lib_intel/hdf5-1.12.1/hdf5]
#PK   --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
#PK                           [PREFIX]
#PK
#PKBy default, `make install' will install all the files in
#PK`/mnt/beegfs/paulo.kubota/lib_intel/hdf5-1.12.1/hdf5/bin', `/mnt/beegfs/paulo.kubota/lib_intel/hdf5-1.12.1/hdf5/lib' etc.  You can specify
#PKan installation prefix other than `/mnt/beegfs/paulo.kubota/lib_intel/hdf5-1.12.1/hdf5' using `--prefix',
#PKfor instance `--prefix=$HOME'.
#PK
#PKFor better control, use the options below.
#PK
#PKFine tuning of the installation directories:
#PK   --bindir=DIR            user executables [EPREFIX/bin]
#PK   --sbindir=DIR           system admin executables [EPREFIX/sbin]
#PK   --libexecdir=DIR        program executables [EPREFIX/libexec]
#PK   --sysconfdir=DIR        read-only single-machine data [PREFIX/etc]
#PK   --sharedstatedir=DIR    modifiable architecture-independent data [PREFIX/com]
#PK   --localstatedir=DIR     modifiable single-machine data [PREFIX/var]
#PK   --libdir=DIR            object code libraries [EPREFIX/lib]
#PK   --includedir=DIR        C header files [PREFIX/include]
#PK   --oldincludedir=DIR     C header files for non-gcc [/usr/include]
#PK   --datarootdir=DIR       read-only arch.-independent data root [PREFIX/share]
#PK   --datadir=DIR           read-only architecture-independent data [DATAROOTDIR]
#PK   --infodir=DIR           info documentation [DATAROOTDIR/info]
#PK   --localedir=DIR         locale-dependent data [DATAROOTDIR/locale]
#PK   --mandir=DIR            man documentation [DATAROOTDIR/man]
#PK   --docdir=DIR            documentation root [DATAROOTDIR/doc/hdf5]
#PK   --htmldir=DIR           html documentation [DOCDIR]
#PK   --dvidir=DIR            dvi documentation [DOCDIR]
#PK   --pdfdir=DIR            pdf documentation [DOCDIR]
#PK   --psdir=DIR             ps documentation [DOCDIR]
#PK
#PKProgram names:
#PK   --program-prefix=PREFIX            prepend PREFIX to installed program names
#PK   --program-suffix=SUFFIX            append SUFFIX to installed program names
#PK   --program-transform-name=PROGRAM   run sed PROGRAM on installed program names
#PK
#PKSystem types:
#PK   --build=BUILD     configure for building on BUILD [guessed]
#PK   --host=HOST       cross-compile to build programs to run on HOST [BUILD]
#PK
#PKOptional Features:
#PK   --disable-option-checking  ignore unrecognized --enable/--with options
#PK   --disable-FEATURE       do not include FEATURE (same as --enable-FEATURE=no)
#PK   --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
#PK   --enable-silent-rules   less verbose build output (undo: "make V=1")
#PK   --disable-silent-rules  verbose build output (undo: "make V=0")
#PK   --enable-maintainer-mode
#PK                           enable make rules and dependencies not useful (and
#PK                           sometimes confusing) to the casual installer
#PK   --enable-sanitize-checks=address
#PK                           (clang/clang++ compilers only) Enable sanitize
#PK                           checks. Address is useful for detecting issues
#PK                           dealing with memory. See AddressSanitizer in
#PK                           config/sanitizer/README.md for more information.
#PK                           [default=none]
#PK   --enable-build-mode=(debug|production|clean)
#PK                           Sets the build mode. Debug turns on symbols, API
#PK                           tracing, asserts, and debug optimization, as well as
#PK                           several other minor configure options that aid in
#PK                           debugging. Production turns high optimizations on.
#PK                           Clean turns nothing on and disables optimization
#PK                           (i.e.: a 'clean slate' configuration). All these
#PK                           settings can be overridden by using specific
#PK                           configure flags. [default=production]
#PK   --enable-dependency-tracking
#PK                           do not reject slow dependency extractors
#PK   --disable-dependency-tracking
#PK                           speeds up one-time build
#PK   --enable-unsupported    Allow unsupported combinations of configure options
#PK   --enable-fortran        Compile the Fortran interface [default=no]
#PK   --enable-cxx            Compile the C++ interface [default=no]
#PK   --enable-hl             Enable the high-level library. [default=yes (unless
#PK                           build mode = clean)]
#PK   --enable-java           Compile the Java JNI interface [default=no]
#PK   --enable-tests          Compile the HDF5 tests [default=yes]
#PK   --enable-tools          Compile the HDF5 tools [default=yes]
#PK   --enable-doxygen        Compile the HDF5 doxygen files [default=no]
#PK   --disable-doxygen-doc   don't generate any doxygen documentation
#PK   --enable-doxygen-dot    generate graphics for doxygen documentation
#PK   --disable-doxygen-man   don't generate doxygen manual pages
#PK   --enable-doxygen-rtf    generate doxygen RTF documentation
#PK   --enable-doxygen-xml    generate doxygen XML documentation
#PK   --enable-doxygen-chm    generate doxygen compressed HTML help documentation
#PK   --enable-doxygen-chi    generate doxygen separate compressed HTML help index
#PK                           file
#PK   --disable-doxygen-html  don't generate doxygen plain HTML documentation
#PK   --enable-doxygen-ps     generate doxygen PostScript documentation
#PK   --enable-doxygen-pdf    generate doxygen PDF documentation
#PK   --enable-shared[=PKGS]  build shared libraries [default=yes]
#PK   --enable-static[=PKGS]  build static libraries [default=yes]
#PK   --enable-fast-install[=PKGS]
#PK                           optimize for fast installation [default=yes]
#PK   --disable-libtool-lock  avoid locking (might break parallel builds)
#PK   --enable-static-exec    Install only statically linked executables
#PK                           [default=no]
#PK   --disable-sharedlib-rpath
#PK                           Disable use of the '=Wl,-rpath' linker option
#PK   --enable-threadsafe     Enable thread-safe capability. Not compatible with
#PK                           the high-level library, Fortran, or C++ wrappers.
#PK                           [default=no]
#PK   --enable-recursive-rw-locks
#PK                           Enable recursive RW locks for thread safety.
#PK                           Requires a thread-safe library and Pthreads.
#PK                           [default=no]
#PK   --enable-debug          OPTION CHANGE: use --enable-build-mode=debug
#PK   --enable-production     OPTION CHANGE: use --enable-build-mode=production
#PK   --enable-diags=(yes|no|<custom>)
#PK                           Allow default enhanced diagnostics to the build.
#PK                           This is independent of the build mode and
#PK                           optimization level. [default=no]
#PK   --enable-symbols=(yes|no|<custom>)
#PK                           Add debug symbols to the library (e.g.: build with
#PK                           -g). This is independent of the build mode and
#PK                           optimization level. The custom string allows special
#PK                           settings like -ggdb, etc. to be used. [default=yes
#PK                           if debug build, otherwise no]
#PK   --enable-asserts        Determines whether NDEBUG is defined or not, which
#PK                           controls assertions. This is independent of the
#PK                           build mode and presence of debugging symbols.
#PK                           [default=yes if debug build, otherwise no]
#PK   --enable-developer-warnings
#PK                           Determines whether developer warnings will be
#PK                           emitted. These are usually performance suggestions
#PK                           (e.g. -Wsuggest-attribute) and do not flag poor code
#PK                           quality. [default=no]
#PK   --enable-warnings-as-errors
#PK                           Determines whether certain warnings will be
#PK                           considered errors. This is mainly for use by HDF5
#PK                           library developers. [default=no]
#PK   --enable-profiling=(yes|no|<custom>)
#PK                           Enable profiling flags (e.g.: -pg). This can be set
#PK                           independently from the build mode. The custom
#PK                           setting can be used to pass alternative profiling
#PK                           flags (e.g.: -P for using Prof with gcc).
#PK                           [default=no]
#PK   --enable-optimization=(high|debug|none|<custom>)
#PK                           Enable optimization flags/settings (e.g.: -O3). This
#PK                           can be set independently from the build mode.
#PK                           Optimizations for a given compiler can be specified
#PK                           at several levels: High, with aggressive
#PK                           optimizations turned on; debug, with optimizations
#PK                           that are unlikely to interfere with debugging or
#PK                           profiling; and none, with no optimizations at all.
#PK                           See the compiler-specific config/*-flags file for
#PK                           more details. Alternatively, optimization options
#PK                           can be specified directly by specifying them as a
#PK                           string value. These custom optimzation flags will
#PK                           completely replace all other optimization flags.
#PK                           [default depends on build mode: debug=debug,
#PK                           production=high, clean=none]
#PK   --enable-file-locking=(yes|no|best-effort)
#PK                           Sets the default for whether or not to use file
#PK                           locking when opening files. Can be overridden with
#PK                           the HDF5_USE_FILE_LOCKING environment variable and
#PK                           the H5Pset_file_locking() API call. best-effort
#PK                           attempts to use file locking but does not fail when
#PK                           file locks have been disabled on the file system
#PK                           (useful with Lustre). [default=best-effort]
#PK   --enable-internal-debug=(yes|all|no|none|<pkg list>)
#PK                           Enable extra debugging output on HDF5 library
#PK                           errors. One may also specify a comma-separated list
#PK                           of package names without the leading H5. This is
#PK                           independent of the build mode and is mainly of
#PK                           interest to HDF Group developers. Yes/all and
#PK                           no/none are synonymous. [default=all if debug build,
#PK                           otherwise none]
#PK   --enable-codestack      Enable the function stack tracing (for developer
#PK                           debugging). [default=no]
#PK   --enable-trace          Enable HDF5 API tracing capability. [default=yes if
#PK                           debug build, otherwise no]
#PK   --enable-using-memchecker
#PK                           Enable this option if a memory allocation and/or
#PK                           bounds checking tool will be used on the HDF5
#PK                           library. Enabling this causes the library to be more
#PK                           picky about its memory operations and also disables
#PK                           the library's free space manager code. This option
#PK                           is orthogonal to the
#PK                           --enable-memory-alloc-sanity-check option.
#PK                           [default=no]
#PK   --enable-memory-alloc-sanity-check
#PK                           Enable this option to turn on internal memory
#PK                           allocation sanity checking. This could cause more
#PK                           memory use and somewhat slower allocation. This
#PK                           option is orthogonal to the
#PK                           --enable-using-memchecker option. [default=no]
#PK   --enable-parallel       Search for MPI-IO and MPI support files
#PK   --enable-instrument     Enable library instrumentation of optimization
#PK                           tracing (only used with parallel builds).
#PK                           [default=yes if a parallel debug build, otherwise
#PK                           no]
#PK   --enable-map-api        Build the map API (H5M). This is not yet supported
#PK                           in the native file format and requires a VOL
#PK                           connector that supports it. [default=no]
#PK   --enable-direct-vfd     Build the direct I/O virtual file driver (VFD). This
#PK                           is based on the POSIX (sec2) VFD and requires the
#PK                           open() call to take the O_DIRECT flag. [default=no]
#PK   --enable-mirror-vfd     Build the socket-based Mirror virtual file driver
#PK                           (VFD). [default=no]
#PK   --enable-ros3-vfd       Build the Read-Only S3 virtual file driver (VFD).
#PK                           [default=no]
#PK   --enable-dconv-exception
#PK                           if exception handling functions is checked during
#PK                           data conversions [default=yes]
#PK   --enable-dconv-accuracy if data accuracy is guaranteed during data
#PK                           conversions [default=yes]
#PK   --enable-build-all      Build helper programs that only developers should
#PK                           need [default=no]
#PK   --enable-deprecated-symbols
#PK                           Enable deprecated public API symbols. [default=yes
#PK                           (unless build mode = clean)]
#PK   --enable-strict-format-checks
#PK                           Enable strict file format checks. [default=yes if
#PK                           debug build, otherwise no]
#PK   --enable-preadwrite     Enable using pread/pwrite instead of read/write in
#PK                           sec2/log/core VFDs. [default=yes if pread/pwrite are
#PK                           present]
#PK   --enable-embedded-libinfo
#PK                           Enable embedded library information [default=yes]
#PK
#PKOptional Packages:
#PK   --with-PACKAGE[=ARG]    use PACKAGE [ARG=yes]
#PK   --without-PACKAGE       do not use PACKAGE (same as --with-PACKAGE=no)
#PK   --with-java-prefix=PFX  prefix where Java runtime is installed (optional)
#PK   --with-javac-flags=FLAGS flags to pass to the Java compiler (optional)
#PK   --with-java-flags=FLAGS flags to pass to the Java VM (optional)
#PK   --with-pic[=PKGS]       try to use only PIC/non-PIC objects [default=use
#PK                           both]
#PK   --with-aix-soname=aix|svr4|both
#PK                           shared library versioning (aka "SONAME") variant to
#PK                           provide on AIX, [default=aix].
#PK   --with-gnu-ld           assume the C compiler uses GNU ld [default=no]
#PK   --with-sysroot[=DIR]    Search for dependent libraries within DIR (or the
#PK                           compiler's sysroot if not specified).
#PK
#PK  For the following --with-xxx options, you can specify where the header
#PK  files and libraries are in two different ways:
#PK
#PK     --with-xxx=INC,LIB - Specify individually the include directory and
#PK                          library directory separated by a comma
#PK     --with-xxx=DIR     - Specify only the directory which contains the
#PK                          include/ and lib/ subdirectories
#PK
#PK   --with-dmalloc=DIR      Use dmalloc memory debugging aid [default=no]
#PK   --with-zlib=DIR         Use zlib library for external deflate I/O filter
#PK                           [default=yes]
#PK   --with-szlib=DIR        Use szlib library for external szlib I/O filter
#PK                           [default=no]
#PK   --with-pthread=DIR      Specify alternative path to Pthreads library when
#PK                           thread-safe capability is built.
#PK   --with-mpe=DIR          Use MPE instrumentation [default=no]
#PK   --with-libhdfs=DIR      Provide libhdfs library to enable HDFS virtual file
#PK                           driver (VFD) [default=no]
#PK   --with-examplesdir=location
#PK                           Specify path for examples
#PK                           [default="DATAROOTDIR/hdf5_examples"]
#PK   --with-default-plugindir=location
#PK                           Specify default location for plugins
#PK                           [default="/usr/local/hdf5/lib/plugin"]
#PK   --with-default-api-version=(v16|v18|v110|v112)
#PK                           Specify default release version of public symbols
#PK                           [default=v112]
#PK
#PKSome influential environment variables:
#PK   CC          C compiler command
#PK   CFLAGS      C compiler flags
#PK   LDFLAGS     linker flags, e.g. -L<lib dir> if you have libraries in a
#PK               nonstandard directory <lib dir>
#PK   LIBS        libraries to pass to the linker, e.g. -l<library>
#PK   CPPFLAGS    (Objective) C/C++ preprocessor flags, e.g. -I<include dir> if
#PK               you have headers in a nonstandard directory <include dir>
#PK   CPP         C preprocessor
#PK   FC          Fortran compiler command
#PK   FCFLAGS     Fortran compiler flags
#PK   CXX         C++ compiler command
#PK   CXXFLAGS    C++ compiler flags
#PK   CXXCPP      C++ preprocessor
#PK   DOXYGEN_PAPER_SIZE
#PK               a4wide (default), a4, letter, legal or executive
#PK   LT_SYS_LIBRARY_PATH
#PK               User-defined run-time library search path.
#PK
#PKUse these variables to override the choices made by `configure' or to help
#PKit to find libraries and programs with nonstandard names/locations.
#PK
#PKReport bugs to <help@hdfgroup.org>.

rm -rf  hdf5-1.12.1
tar -zxvf  hdf5-1.12.1.tar.gz
export CC=gcc       #C compiler command
export CFLAGS       #C compiler flags
export LDFLAGS="-L/mnt/beegfs/paulo.kubota/lib/lib_gnu/zlib/lib"      #linker flags, e.g. -L<lib dir> if you have libraries i
                        #nonstandard directory <lib dir>
export LIBS         #libraries to pass to the linker, e.g. -l<library>
export CPPFLAGS="-I/mnt/beegfs/paulo.kubota/lib/lib_gnu/zlib/include"     #(Objective) C/C++ preprocessor flags, e.g. -I<include 
                      #you have headers in a nonstandard directory <include d
export CPP          #C preprocessor
export FC=gfortran     #Fortran compiler command
export FCFLAGS      #Fortran compiler flags
export CXX=g++     #C++ compiler command
export CXXFLAGS     #C++ compiler flags
export CXXCPP       #C++ preprocessor
export LD_LIBRARY_PATH=/mnt/beegfs/paulo.kubota/lib/lib_gnu/zlib/lib:${LD_LIBRARY_PATH}

cd hdf5-1.12.1
./configure --prefix=/mnt/beegfs/paulo.kubota/lib/lib_gnu/hdf5 --enable-fortran --enable-parallel --enable-shared=no --with-zlib=/mnt/beegfs/paulo.kubota/lib/lib_gnu/zlib/lib
make
make check
make install
cd hdf5/lib
ln -s libhdf5.a    libhdf5_fortran.a
ln -s libhdf5_hl.a libhdf5_hl_fortran.a
cp /mnt/beegfs/paulo.kubota/lib/lib_gnu/zlib/lib/* .
