#PK `configure' configures Open MPI 5.0.5 to adapt to many kinds of systems.
#PK 
#PK Usage: ./configure [OPTION]... [VAR=VALUE]...
#PK 
#PK To assign environment variables (e.g., CC, CFLAGS...), specify them as
#PK VAR=VALUE.  See below for descriptions of some of the useful variables.
#PK 
#PK Defaults for the options are specified in brackets.
#PK 
#PK Configuration:
#PK  -h, --help              display this help and exit
#PK      --help=short        display options specific to this package
#PK      --help=recursive    display the short help of all the included packages
#PK  -V, --version           display version information and exit
#PK  -q, --quiet, --silent   do not print `checking ...' messages
#PK      --cache-file=FILE   cache test results in FILE [disabled]
#PK  -C, --config-cache      alias for `--cache-file=config.cache'
#PK  -n, --no-create         do not create output files
#PK      --srcdir=DIR        find the sources in DIR [configure dir or `..']
#PK 
#PK Installation directories:
#PK  --prefix=PREFIX         install architecture-independent files in PREFIX
#PK                          [/usr/local]
#PK  --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
#PK                          [PREFIX]
#PK 
#PK By default, `make install' will install all the files in
#PK `/usr/local/bin', `/usr/local/lib' etc.  You can specify
#PK an installation prefix other than `/usr/local' using `--prefix',
#PK for instance `--prefix=$HOME'.
#PK 
#PK For better control, use the options below.
#PK 
#PK Fine tuning of the installation directories:
#PK  --bindir=DIR            user executables [EPREFIX/bin]
#PK  --sbindir=DIR           system admin executables [EPREFIX/sbin]
#PK  --libexecdir=DIR        program executables [EPREFIX/libexec]
#PK  --sysconfdir=DIR        read-only single-machine data [PREFIX/etc]
#PK  --sharedstatedir=DIR    modifiable architecture-independent data [PREFIX/com]
#PK  --localstatedir=DIR     modifiable single-machine data [PREFIX/var]
#PK  --runstatedir=DIR       modifiable per-process data [LOCALSTATEDIR/run]
#PK  --libdir=DIR            object code libraries [EPREFIX/lib]
#PK  --includedir=DIR        C header files [PREFIX/include]
#PK  --oldincludedir=DIR     C header files for non-gcc [/usr/include]
#PK  --datarootdir=DIR       read-only arch.-independent data root [PREFIX/share]
#PK  --datadir=DIR           read-only architecture-independent data [DATAROOTDIR]
#PK  --infodir=DIR           info documentation [DATAROOTDIR/info]
#PK  --localedir=DIR         locale-dependent data [DATAROOTDIR/locale]
#PK  --mandir=DIR            man documentation [DATAROOTDIR/man]
#PK  --docdir=DIR            documentation root [DATAROOTDIR/doc/openmpi]
#PK  --htmldir=DIR           html documentation [DOCDIR]
#PK  --dvidir=DIR            dvi documentation [DOCDIR]
#PK  --pdfdir=DIR            pdf documentation [DOCDIR]
#PK  --psdir=DIR             ps documentation [DOCDIR]
#PK 
#PK Program names:
#PK  --program-prefix=PREFIX            prepend PREFIX to installed program names
#PK  --program-suffix=SUFFIX            append SUFFIX to installed program names
#PK  --program-transform-name=PROGRAM   run sed PROGRAM on installed program names
#PK 
#PK System types:
#PK  --build=BUILD     configure for building on BUILD [guessed]
#PK  --host=HOST       cross-compile to build programs to run on HOST [BUILD]
#PK  --target=TARGET   configure for building compilers for TARGET [HOST]
#PK 
#PK Optional Features:
#PK  --disable-option-checking  ignore unrecognized --enable/--with options
#PK  --disable-FEATURE       do not include FEATURE (same as --enable-FEATURE=no)
#PK  --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
#PK  --enable-silent-rules   less verbose build output (undo: "make V=1")
#PK  --disable-silent-rules  verbose build output (undo: "make V=0")
#PK  --enable-mpi-cxx        *DELETED* Build the MPI C++ bindings
#PK  --enable-mpi-cxx-seek   *DELETED* Build support for MPI::SEEK
#PK  --enable-cxx-exceptions *DELETED* Build support for C++ exceptions in the
#PK                          MPI C++ bindings
#PK  --enable-coverage       enable code coverage files to be generated
#PK  --enable-branch-probabilities
#PK                          enable profile arcs and branch probability
#PK                          optimization
#PK  --enable-mem-debug      enable memory debugging (not for general MPI users!)
#PK                          (default: disabled)
#PK  --enable-mem-profile    enable memory profiling (not for general MPI users!)
#PK                          (default: disabled)
#PK  --enable-picky          enable developer-level compiler pickyness when
#PK                          building Open MPI (default: disabled, unless a .git
#PK                          directory is found in the build tree)
#PK  --enable-debug          enable developer-level debugging code (not for
#PK                          general MPI users!) (default: disabled)
#PK  --enable-timing         enable developer-level timing code (not for general
#PK                          MPI users!) (default: disabled)
#PK  --disable-debug-symbols Disable adding compiler flags to enable debugging
#PK                          symbols if --enable-debug is specified. For
#PK                          non-debugging builds, this flag has no effect.
#PK  --enable-pretty-print-stacktrace
#PK                          Pretty print stacktrace on process signal (default:
#PK                          enabled)
#PK  --enable-pty-support    Enable/disable PTY support for STDIO forwarding.
#PK                          (default: enabled)
#PK  --enable-weak-symbols   use weak symbols, if available (default: enabled)
#PK  --enable-dlopen         Whether build should attempt to use dlopen (or
#PK                          similar) to dynamically load components. Disabling
#PK                          dlopen implies --disable-mca-dso. (default: enabled)
#PK  --enable-heterogeneous  Enable features required for heterogeneous platform
#PK                          support (default: disabled)
#PK  --enable-binaries       Build and install binaries required for Open MPI,
#PK                          such as the wrapper compilers. Useful for multi-lib
#PK                          installations. (default: enabled)
#PK  --enable-script-wrapper-compilers
#PK                          Use less featured script-based wrapper compilers
#PK                          instead of the standard C-based wrapper compilers.
#PK                          This option ignores the --disable-binaries option
#PK                          and is mainly useful in cross-compile environments
#PK  --enable-per-user-config-files
#PK                          Disable per-user configuration files, to save disk
#PK                          accesses during job start-up. This is likely
#PK                          desirable for large jobs. Note that this can also be
#PK                          achieved by environment variables at run-time.
#PK                          (default: enabled)
#PK  --enable-ipv6           Enable IPv6 support, but only if the underlying
#PK                          system supports it (default: disabled)
#PK  --disable-getpwuid      Disable getpwuid support (default: enabled)
#PK  --disable-mpi           Disable building the MPI layer (default:enabled)
#PK  --enable-mpi-interface-warning
#PK                          enable compile-time warnings when deprecated MPI
#PK                          functions are used (default: enabled)
#PK  --enable-sparse-groups  enable sparse process groups (default: not enabled)
#PK  --enable-peruse         enable PERUSE interface (default: disabled)
#PK  --enable-mpi-fortran    specify which Fortran MPI bindings to build: yes,
#PK                          none (or no), best-effort, mpifh (build only mpif.h
#PK                          support), usempi (build mpif.h and the mpi module),
#PK                          or usempif08 (or all, build mpifh, the mpi module,
#PK                          and the mpi_f08 module) (default: "yes" if Fortran
#PK                          compiler found)
#PK  --enable-mpi1-compatibility
#PK                          Enable support for MPI-1.x functions removed from
#PK                          the current MPI standard (MPI-3.x). This option will
#PK                          go away in a future release of Open MPI (default:
#PK                          disabled)
#PK  --enable-grequest-extensions
#PK                          Enable support for Grequest extensions (default:
#PK                          disabled)
#PK  --disable-io-ompio      Disable the ompio MPI-IO component
#PK  --enable-spc            Enable software-based performance counters
#PK                          capability (default: disabled)
#PK  --enable-oshmem         Enable building the OpenSHMEM interface (available
#PK                          on Linux only, where it is enabled by default)
#PK  --enable-oshmem-compat  enable compatibility mode (default: enabled)
#PK  --enable-oshmem-profile enable OpenSHMEM profiling (default: enabled)
#PK  --enable-oshmem-fortran enable OpenSHMEM Fortran bindings (default: enabled
#PK                          if Fortran compiler found)
#PK  --enable-shared[=PKGS]  build shared libraries [default=yes]
#PK  --enable-static[=PKGS]  build static libraries [default=no]
#PK  --enable-dependency-tracking
#PK                          do not reject slow dependency extractors
#PK  --disable-dependency-tracking
#PK                          speeds up one-time build
#PK  --enable-alt-short-float=TYPE
#PK                          Use an alternate C type TYPE of 'short float' if
#PK                          'short float' is not available on the C compiler.
#PK                          'short float' is a new C type proposed for the next
#PK                          C language standard in ISO/IEC JTC 1/SC 22 WG 14 (C
#PK                          WG). (default: "_Float16" if available, disabled
#PK                          otherwise)
#PK  --enable-mpi-java       enable Java MPI bindings (default: disabled)
#PK  --enable-c11-atomics    Enable use of C11 atomics if available. Note: GCC
#PK                          builtin atomics are currently preferred over C11
#PK                          atomics. (default: use if available, disabled by
#PK                          default on 64-bit PowerPC)
#PK  --enable-builtin-atomics
#PK                          Enable use of GCC built-in atomics. Currently
#PK                          preferred over C11 atomics. (default: use if
#PK                          available, disabled by default on 64-bit PowerPC)
#PK  --enable-builtin-atomics-for-ppc
#PK                          For performance reasons, 64-bit POWER architectures
#PK                          will not use C11 or GCC built-in atomics, even if
#PK                          --enable-c11-atomics is passed to configure.
#PK                          Enabling this option will re-enable support for both
#PK                          C11 and GCC built-in atomics.
#PK  --enable-wrapper-rpath  enable rpath/runpath support in the wrapper
#PK                          compilers (default=yes)
#PK  --enable-wrapper-runpath
#PK                          enable runpath in the wrapper compilers if linker
#PK                          supports it (default: enabled, unless wrapper-rpath
#PK                          is disabled).
#PK  --enable-sphinx         Force configure to fail if Sphinx is not found
#PK                          (Sphinx is used to build the HTML docs and man
#PK                          pages). This option is likely only useful for
#PK                          developers; end users who are building from
#PK                          distribution tarballs do ***not*** need to have
#PK                          Sphinx installed
#PK  --enable-devel-check    enable developer-level compiler pickyness when
#PK                          building PMIx (default: disabled)
#PK  --memory-sanitizers     enable developer-level memory sanitizers when
#PK                          building PMIx (default: disabled)
#PK  --enable-pmix-timing    enable PMIx developer-level timing code (default:
#PK                          disabled)
#PK  --enable-pmix-binaries  enable PMIx tools
#PK  --enable-python-bindings
#PK                          enable Python bindings (default: disabled)
#PK  --enable-nonglobal-dlopen
#PK                          enable non-global dlopen (default: enabled)
#PK  --enable-dummy-handshake
#PK                          Enables psec dummy component intended to check the
#PK                          PTL handshake scenario (default: disabled)
#PK  --disable-hwloc-lib-checks
#PK                          If --disable-hwloc-lib-checks is specified,
#PK                          configure will assume that -lhwloc is available
#PK  --disable-libev-lib-checks
#PK                          If --disable-libev-lib-checks is specified,
#PK                          configure will assume that -lev is available
#PK  --disable-libevent-lib-checks
#PK                          If --disable-libevent-lib-checks is specified,
#PK                          configure will assume that -levent is available
#PK  --enable-werror         Treat compiler warnings as errors
#PK  --disable-pmix-dlopen   Disable the PMIx "dlopen" PDL component (and
#PK                          probably force the use of the "libltdl" PDL
#PK                          component).
#PK 
#PK  --enable-show-load-errors-by-default
#PK                          Set the default value for the MCA parameter
#PK                          mca_base_component_show_load_errors (but can be
#PK                          overridden at run time by the usual
#PK                          MCA-variable-setting mechansism). This MCA variable
#PK                          controls whether warnings are displayed when an MCA
#PK                          component fails to load at run time due to an error.
#PK                          (default: enabled in --enable-debug builds, meaning
#PK                          that mca_base_component_show_load_errors is enabled
#PK                          by default when configured with --enable-debug
#PK  --disable-pmix-lib-checks
#PK                          If --disable-pmix-lib-checks is specified, configure
#PK                          will assume that -lpmix is available
#PK  --disable-prte-dlopen   Disable the "dlopen" PRTE DL component (and probably
#PK                          force the use of the "libltdl" DL component). This
#PK                          option should really only be used by PRTE
#PK                          developers. You are probably actually looking for
#PK                          the "--disable-dlopen" option, which disables all
#PK                          dlopen-like functionality from PRTE.
#PK 
#PK  --disable-ompi-support  Disable support for Open MPI (default: no)
#PK  --enable-prte-prefix-by-default
#PK                          Make "mpirun ..." behave exactly the same as "mpirun
#PK                          --prefix \$prefix", where \$prefix is the value
#PK                          given to --prefix in configure (default:enabled)
#PK  --enable-orterun-prefix-by-default
#PK                          *DEPRECATED* Please use
#PK                          --enable-prte-prefix-by-default in the future.
#PK  --enable-mpirun-prefix-by-default
#PK                          *DEPRECATED* Please use
#PK                          --enable-prte-prefix-by-default in the future.
#PK  --enable-mca-no-build=LIST
#PK                          Comma-separated list of <type>-<component> pairs
#PK                          that will not be built. Example:
#PK                          "--enable-mca-no-build=btl-portals4,topo-treematch"
#PK                          will disable building the "portals4" btl and the
#PK                          "treematch" topo components.
#PK  --enable-mca-dso=LIST   Comma-separated list of types and/or type-component
#PK                          pairs that will be built as run-time loadable
#PK                          components (as opposed to statically linked in), if
#PK                          supported on this platform.
#PK  --enable-mca-static=LIST
#PK                          Comma-separated list of types and/or type-component
#PK                          pairs that will be built statically linked into the
#PK                          library. The default (if DSOs are supported) is to
#PK                          build all components as DSOs. Enabling a component
#PK                          as static disables it building as a DSO. The default
#PK                          is to build all components statically.
#PK  --enable-mca-direct=LIST
#PK                          Comma-separated list of type-component pairs that
#PK                          will be hard coded as the one component to use for a
#PK                          given component type, saving the (small) overhead of
#PK                          the component architecture. LIST must not be empty
#PK                          and implies given component pairs are build as
#PK                          static components.
#PK  --enable-btl-portals4-flow-control
#PK                          enable flow control for Portals 4 BTL (default:
#PK                          disabled)
#PK  --enable-uct-version-check
#PK                          enable UCT version check (default: enabled)
#PK  --enable-opal-btl-usnic-unit-tests
#PK                          build unit tests for the usnic BTL, including the
#PK                          test runner program, opal_btl_usnic_run_tests
#PK  --enable-memchecker     Enable memory and buffer checks. Note that disabling
#PK                          will *also* add "memchecker" to the
#PK                          --enable-mca-no-build list (default: disabled)
#PK  --disable-mmap-shmem    disable mmap shared memory support (default:
#PK                          enabled)
#PK  --disable-posix-shmem   disable posix shared memory support (default:
#PK                          enabled)
#PK  --disable-sysv-shmem    disable sysv shared memory support (default:
#PK                          enabled)
#PK  --disable-io-romio      Disable the ROMIO MPI-IO component
#PK  --enable-mtl-portals4-flow-control
#PK                          enable flow control for Portals 4 MTL (default:
#PK                          disabled)
#PK  --disable-psm2-version-check
#PK                          Disable PSM2 version checking. Not recommended to
#PK                          disable. (default: enabled)
#PK  --disable-mmap-sshmem   disable mmap shared memory support (default:
#PK                          enabled)
#PK  --disable-sysv-sshmem   disable sysv shared memory support (default:
#PK                          enabled)
#PK  --enable-mpi-ext=LIST   Comma-separated list of extensions that should be
#PK                          built. Possible values:
#PK                          affinity,cuda,ftmpi,rocm,shortfloat. Example:
#PK                          "--enable-mpi-ext=foo,bar" will enable building the
#PK                          MPI extensions "foo" and "bar". If LIST is empty or
#PK                          the special value "all", then all available MPI
#PK                          extensions will be built (default: all).
#PK  --enable-visibility     enable visibility feature of certain
#PK                          compilers/linkers (default: enabled)
#PK  --enable-fast-install[=PKGS]
#PK                          optimize for fast installation [default=yes]
#PK  --disable-libtool-lock  avoid locking (might break parallel builds)
#PK 
#PK Optional Packages:
#PK  --with-PACKAGE[=ARG]    use PACKAGE [ARG=yes]
#PK  --without-PACKAGE       do not use PACKAGE (same as --with-PACKAGE=no)
#PK  --with-platform-patches-dir=DIR
#PK                          Location of the platform patches directory. If you
#PK                          use this option, you must also use --with-platform.
#PK  --with-platform=FILE    Load options for build from FILE. Options on the
#PK                          command line not in FILE are used. Options on the
#PK                          command line and in FILE are replaced by what is in
#PK                          FILE.
#PK  --with-libnl(=DIR)      Directory prefix for libnlv3 (typically only
#PK                          necessary if libnl is installed in a location that
#PK                          the compiler/linker will not search by default)
#PK  --with-libnl-libdir=DIR Directory prefix for libnlv3 libs(typically only
#PK                          necessary if libnl is installed in a location that
#PK                          the compiler/linker will not search by default)
#PK  --with-pmi(=DIR)        *DELETED* Build PMI support, optionally adding DIR
#PK                          to the search path (default: no)
#PK  --with-pmi-libdir=DIR   *DELETED* Look for libpmi or libpmi2 in the given
#PK                          directory DIR, DIR/lib or DIR/lib64
#PK  --with-devel-headers    normal MPI users/applications do not need this
#PK                          (mpi.h and mpif.h are ALWAYS installed). Developer
#PK                          headers are only necessary for MCA module authors
#PK                          (default: disabled).
#PK  --with-show-load-errors Set the default value for the MCA parameter
#PK                          mca_base_component_show_load_errors (but can be
#PK                          overridden at run time by the usual
#PK                          MCA-variable-setting mechansism). (default: "all")
#PK  --with-cross=FILE       Specify configure values that can not be determined
#PK                          in a cross-compilation environment. See the Open MPI
#PK                          FAQ.
#PK  --with-package-string=STRING
#PK                          Use a branding string throughout Open MPI
#PK  --with-ident-string=STRING
#PK                          Embed an ident string into Open MPI object files
#PK  --with-dst-checksum     Use an alternative checksum algorithm for messages
#PK  --with-max-processor-name=VALUE
#PK                          maximum length of processor names. VALUE argument
#PK                          has to be specified (default: [256]).
#PK  --with-max-error-string=VALUE
#PK                          maximum length of error strings. VALUE argument has
#PK                          to be specified (default: [256]).
#PK  --with-max-object-name=VALUE
#PK                          maximum length of object names. VALUE argument has
#PK                          to be specified (default: [64]).
#PK  --with-max-info-key=VALUE
#PK                          maximum length of info keys. VALUE argument has to
#PK                          be specified (default: [36]).
#PK  --with-max-info-val=VALUE
#PK                          maximum length of info vals. VALUE argument has to
#PK                          be specified (default: [256]).
#PK  --with-max-port-name=VALUE
#PK                          maximum length of port names. VALUE argument has to
#PK                          be specified (default: [1024]).
#PK  --with-max-datarep-string=VALUE
#PK                          maximum length of datarep strings. VALUE argument
#PK                          has to be specified (default: [128]).
#PK  --with-max-pset-name-len=VALUE
#PK                          maximum length of pset name lens. VALUE argument has
#PK                          to be specified (default: [512]).
#PK  --with-max-stringtag-len=VALUE
#PK                          maximum length of stringtag lens. VALUE argument has
#PK                          to be specified (default: [1024]).
#PK  --with-mpi-moduledir    specify where to install Fortran MPI modules
#PK                          (default: $libdir)
#PK  --with-mpi-param-check(=VALUE)
#PK                          behavior of MPI function parameter checking. Valid
#PK                          values are: always, never, runtime. If
#PK                          --with-mpi-param-check is specified with no VALUE
#PK                          argument, it is equivalent to a VALUE of "always";
#PK                          --without-mpi-param-check is equivalent to "never"
#PK                          (default: runtime).
#PK  --with-libmpi-name=STRING
#PK                          "Replace \"libmpi(_FOO)\" with \"libSTRING(_FOO)\"
#PK                          (default=mpi)"
#PK  --with-oshmem-param-check(=VALUE)
#PK                          behavior of OSHMEM API function parameter checking.
#PK                          Valid values are: always, never. If
#PK                          --with-oshmem-param-check is specified with no VALUE
#PK                          argument, it is equivalent to a VALUE of "always";
#PK                          --without-oshmem-param-check is equivalent to
#PK                          "never" (default: always).
#PK  --with-jdk-dir(=DIR)    Location of the JDK header directory. If you use
#PK                          this option, do not specify --with-jdk-bindir or
#PK                          --with-jdk-headers.
#PK  --with-jdk-bindir(=DIR) Location of the JDK bin directory. If you use this
#PK                          option, you must also use --with-jdk-headers (and
#PK                          you must NOT use --with-jdk-dir)
#PK  --with-jdk-headers(=DIR)
#PK                          Location of the JDK header directory. If you use
#PK                          this option, you must also use --with-jdk-bindir
#PK                          (and you must NOT use --with-jdk-dir)
#PK  --with-wrapper-cc=path  Set a different wrapper C compiler than the one used
#PK                          to build Open MPI
#PK  --with-wrapper-cflags   Extra flags to add to CFLAGS when using mpicc
#PK  --with-wrapper-cflags-prefix
#PK                          Extra flags (before user flags) to add to CFLAGS
#PK                          when using mpicc
#PK  --with-wrapper-cxxflags Extra flags to add to CXXFLAGS when using
#PK                          mpiCC/mpic++
#PK  --with-wrapper-cxxflags-prefix
#PK                          Extra flags to add to CXXFLAGS when using
#PK                          mpiCC/mpic++
#PK  --with-wrapper-fcflags  Extra flags to add to FCFLAGS when using mpifort
#PK  --with-wrapper-fcflags-prefix
#PK                          Extra flags (before user flags) to add to FCFLAGS
#PK                          when using mpifort
#PK  --with-wrapper-ldflags  Extra flags to add to LDFLAGS when using wrapper
#PK                          compilers
#PK  --with-wrapper-libs     Extra flags to add to LIBS when using wrapper
#PK                          compilers
#PK  --with-broken-qsort     Build with FreeBSD qsort instead of native qsort
#PK                          (default: no)
#PK  --with-cs-fs            Destination FS is case sensitive (default: set to
#PK                          value of the build FS's case sensitivity)
#PK  --with-ft=TYPE          Specify the type of fault tolerance to enable.
#PK                          Options: mpi (ULFM), (default: mpi)
#PK  --with-libevent(=DIR)   Build libevent support. DIR can take one of three
#PK                          values: "internal", "external", or a valid directory
#PK                          name. "internal" forces Open MPI to use its internal
#PK                          copy of libevent. "external" forces Open MPI to use
#PK                          an external installation of libevent. Supplying a
#PK                          valid directory name also forces Open MPI to use an
#PK                          external installation of libevent, and adds
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries. Note that Open MPI
#PK                          no longer supports --without-libevent. If no
#PK                          argument is specified, Open MPI will search default
#PK                          locations for libevent and fall back to an internal
#PK                          version if one is not found.
#PK  --with-libevent-libdir=DIR
#PK                          Search for libevent libraries in DIR. Should only be
#PK                          used if an external copy of libevent is being used.
#PK  --with-hwloc(=DIR)      Build hwloc support. DIR can take one of three
#PK                          values: "internal", "external", or a valid directory
#PK                          name. "internal" forces Open MPI to use its internal
#PK                          copy of hwloc. "external" forces Open MPI to use an
#PK                          external installation of hwloc. Supplying a valid
#PK                          directory name also forces Open MPI to use an
#PK                          external installation of hwloc, and adds
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries. Note that Open MPI
#PK                          no longer supports --without-hwloc. If no argument
#PK                          is specified, Open MPI will search default locations
#PK                          for hwloc and fall back to an internal version if
#PK                          one is not found.
#PK  --with-hwloc-libdir=DIR Search for hwloc libraries in DIR. Should only be
#PK                          used if an external copy of hwloc is being used.
#PK  --with-pmix(=DIR)       Build pmix support. DIR can take one of three
#PK                          values: "internal", "external", or a valid directory
#PK                          name. "internal" forces Open MPI to use its internal
#PK                          copy of pmix. "external" forces Open MPI to use an
#PK                          external installation of pmix. Supplying a valid
#PK                          directory name also forces Open MPI to use an
#PK                          external installation of pmix, and adds DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries. Note that Open MPI no longer
#PK                          supports --without-pmix. If no argument is
#PK                          specified, Open MPI will search default locations
#PK                          for pmix and fall back to an internal version if one
#PK                          is not found.
#PK  --with-pmix-libdir=DIR  Search for pmix libraries in DIR. Should only be
#PK                          used if an external copy of pmix is being used.
#PK  --with-pmix-package-string=STRING
#PK                          Use a branding string throughout PMIx
#PK  --with-pmix-headers     Install the PMIx header files (pmix.h and friends)
#PK                          (default: enabled)
#PK  --with-tests-examples   Whether or not to install the tests and example
#PK                          programs.
#PK  --with-alps-libdir=DIR  Location of alps libraries (alpslli, alpsutil)
#PK                          (default: /usr/lib/alps
#PK                          (/opt/cray/xe-sysroot/default/user on eslogin
#PK                          nodes))
#PK  --with-alps(=DIR|yes|no)
#PK                          Build with ALPS scheduler component, optionally
#PK                          adding DIR/include, DIR/lib, and DIR/lib64 to the
#PK                          search path for headers and libraries (default:
#PK                          auto)
#PK  --with-curl(=DIR)       Build curl support (default=no), optionally adding
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries
#PK  --with-curl-libdir=DIR  Search for Curl libraries in DIR
#PK  --with-jansson(=DIR)    Build jansson support (default=no), optionally
#PK                          adding DIR/include, DIR/lib, and DIR/lib64 to the
#PK                          search path for headers and libraries
#PK  --with-jansson-libdir=DIR
#PK                          Search for Jansson libraries in DIR
#PK  --with-slurm            Build SLURM scheduler component (default: yes)
#PK  --with-pmix-platform-patches-dir=DIR
#PK                          Location of the platform patches directory. If you
#PK                          use this option, you must also use --with-platform.
#PK  --with-pmix-platform=FILE
#PK                          Load options for build from FILE. Options on the
#PK                          command line not in FILE are used. Options on the
#PK                          command line and in FILE are replaced by what is in
#PK                          FILE.
#PK  --with-hwloc=DIR        Search for hwloc headers and libraries in DIR
#PK  --with-hwloc-libdir=DIR Search for hwloc libraries in DIR
#PK  --with-hwloc-extra-libs=LIBS
#PK                          Add LIBS as dependencies of hwloc
#PK  --with-libev=DIR        Search for libev headers and libraries in DIR
#PK  --with-libev-libdir=DIR Search for libev libraries in DIR
#PK  --with-libev-extra-libs=LIBS
#PK                          Add LIBS as dependencies of Libev
#PK  --with-libevent-extra-libs=LIBS
#PK                          Add LIBS as dependencies of Libevent
#PK  --with-zlib=DIR         Search for zlib headers and libraries in DIR
#PK  --with-zlib-libdir=DIR  Search for zlib libraries in DIR
#PK  --with-simptest         Include simptest fabric support
#PK  --with-slingshot        Include Slingshot fabric support
#PK  --with-cxi(=DIR)        Include CXI service library support, optionally
#PK                          adding DIR/include, DIR/include/cxi, DIR/lib, and
#PK                          DIR/lib64 to the search path for headers and
#PK                          libraries
#PK  --with-cxi-libdir=DIR   Search for CXI libraries in DIR
#PK  --with-pbs              Build PBS scheduler component (default: yes)
#PK  --with-munge=DIR        Search for munge headers and libraries in DIR
#PK  --with-munge-libdir=DIR Search for munge libraries in DIR
#PK  --with-prrte(=DIR)      Build prrte support. DIR can take one of four
#PK                          values: "internal", "external", "no", or a valid
#PK                          directory name. "internal" forces Open MPI to use
#PK                          its internal copy of prrte. "external" forces Open
#PK                          MPI to use an external installation of prrte.
#PK                          Supplying a valid directory name also forces Open
#PK                          MPI to use an external installation of prrte, and
#PK                          adds DIR/include, DIR/lib, and DIR/lib64 to the
#PK                          search path for headers and libraries. "no" means
#PK                          that Open MPI will not build components that require
#PK                          this package. If no argument is specified, Open MPI
#PK                          will search default locations for prrte and fall
#PK                          back to an internal version if one is not found.
#PK  --with-prrte-libdir=DIR Search for prrte libraries in DIR. Should only be
#PK                          used if an external copy of prrte is being used.
#PK  --with-prrte-bindir=DIR Search for PRRTE binaries in DIR. Defaults to
#PK                          PRRTE_DIR/bin if not specified
#PK  --with-lsf(=DIR)        Build LSF support
#PK  --with-lsf-libdir=DIR   Search for LSF libraries in DIR
#PK  --with-moab             Build MOAB scheduler component (default: yes)
#PK  --with-moab-libdir=DIR  Search for Moab libraries in DIR
#PK  --with-sge              Build SGE or Grid Engine support (default: no)
#PK  --with-singularity(=DIR)
#PK                          Build support for the Singularity container,
#PK                          optionally adding DIR to the search path
#PK  --with-tm(=DIR)         Build TM (Torque, PBSPro, and compatible) support,
#PK                          optionally adding DIR/include, DIR/lib, and
#PK                          DIR/lib64 to the search path for headers and
#PK                          libraries
#PK  --with-tm-libdir=DIR    Search for Torque libraries in DIR
#PK  --with-proxy-version-string
#PK                          Return the provided string when prte is used in
#PK                          proxy mode and the version is requested
#PK  --with-proxy-package-name
#PK                          Return the provided string when prte is used in
#PK                          proxy mode and the package name is requested
#PK  --with-proxy-bugreport  Return the provided string when prte is used in
#PK                          proxy mode and the PACKAGE_BUGREPORT is requested
#PK  --with-prte-platform-patches-dir=DIR
#PK                          Location of the platform patches directory. If you
#PK                          use this option, you must also use --with-platform.
#PK  --with-prte-platform=FILE
#PK                          Load options for build from FILE. Options on the
#PK                          command line not in FILE are used. Options on the
#PK                          command line and in FILE are replaced by what is in
#PK                          FILE.
#PK  --with-pmix-extra-libs=LIBS
#PK                          Add LIBS as dependencies of pmix
#PK  --with-libfabric=DIR    Deprecated synonym for --with-ofi
#PK  --with-libfabric-libdir=DIR
#PK                          Deprecated synonym for --with-ofi-libdir
#PK  --with-ofi=DIR          Specify location of OFI libfabric installation,
#PK                          adding DIR/include to the default search location
#PK                          for libfabric headers, and DIR/lib or DIR/lib64 to
#PK                          the default search location for libfabric libraries.
#PK                          Error if libfabric support cannot be found.
#PK  --with-ofi-libdir=DIR   Search for OFI libfabric libraries in DIR
#PK  --with-ucx(=DIR)        Build with Unified Communication X library support
#PK  --with-ucx-libdir=DIR   Search for Unified Communication X libraries in DIR
#PK  --with-cuda(=DIR)       Build cuda support, optionally adding DIR/include
#PK  --with-cuda-libdir=DIR  Search for CUDA libraries in DIR
#PK  --with-rocm(=DIR)       Build ROCm support, optionally adding DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries
#PK  --with-portals4(=DIR)   Build Portals4 support, optionally adding
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries
#PK  --with-portals4-libdir=DIR
#PK                          Search for Portals4 libraries in DIR
#PK  --with-portals4-max-md-size=SIZE
#PK                          Log base 2 of the maximum size in bytes of a memory
#PK                          descriptor. Should only be set for implementations
#PK                          which do not support binding all of virtual address
#PK                          space.
#PK  --with-portals4-max-va-size=SIZE
#PK                          Log base 2 of the maximum size in bytes of the user
#PK                          virtual address space. Should only be set for
#PK                          implementations which do not support binding all of
#PK                          virtual address space.
#PK  --with-ugni             Build support for Cray GNI. Set PKG_CONFIG_PATH env.
#PK                          variable to specify alternate path.
#PK  --with-usnic            If specified, cause an error if usNIC support cannot
#PK                          be built
#PK  --with-libltdl(=DIR)    Build libltdl support, optionally adding
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries
#PK  --with-libltdl-libdir=DIR
#PK                          Search for libltdl libraries in DIR
#PK  --with-valgrind(=DIR)   Directory where the valgrind software is installed
#PK  --with-memory-manager=TYPE
#PK                          Use TYPE for intercepting memory management calls to
#PK                          control memory pinning.
#PK  --with-memkind(=DIR)    ,
#PK 		Build with MEMKIND, searching for headers in DIR)
#PK  --with-udreg            Build support for Cray udreg support. Set
#PK                          PKG_CONFIG_PATH env. variable to specify alternate
#PK                          path.
#PK  --with-cma              Build Cross Memory Attach support (default:
#PK                          autodetect)
#PK  --with-knem(=DIR)       Build knem Linux kernel module support, searching
#PK                          for headers in DIR/include
#PK  --with-cray-xpmem(=yes/no)
#PK                          Build Cray XPMEM support(default: auto)
#PK  --with-xpmem(=DIR)      Build with XPMEM kernel module support, searching
#PK                          for headers in DIR
#PK  --with-xpmem-libdir=DIR Search for XPMEM library in DIR
#PK  --with-threads=TYPE     Specify thread TYPE to use. default:pthreads. Other
#PK                          options are qthreads and argobots.
#PK  --with-argobots=DIR     Specify location of argobots installation. Error if
#PK                          argobots support cannot be found.
#PK  --with-argobots-libdir=DIR
#PK                          Search for argobots libraries in DIR
#PK  --with-qthreads=DIR     Specify location of qthreads installation. Error if
#PK                          qthreads support cannot be found.
#PK  --with-qthreads-libdir=DIR
#PK                          Search for qthreads libraries in DIR
#PK  --with-timer=TYPE       Build high resolution timer component TYPE
#PK  --with-hcoll(=DIR)      Build hcoll (Mellanox Hierarchical Collectives)
#PK                          support, optionally adding DIR/include and DIR/lib
#PK                          or DIR/lib64 to the search path for headers and
#PK                          libraries
#PK  --with-ucc(=DIR)        Build UCC (Unified Collective Communication)
#PK  --with-ime(=DIR)        Build IME support, optionally adding DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries
#PK  --with-pvfs2(=DIR)      Build Pvfs2 support, optionally adding DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries
#PK  --with-gpfs(=DIR)       Build Gpfs support, optionally adding DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries
#PK  --with-lustre(=DIR)     Build Lustre support, optionally adding DIR/include,
#PK                          DIR/lib, and DIR/lib64 to the search path for
#PK                          headers and libraries
#PK  --with-io-romio-flags=FLAGS
#PK                          Pass FLAGS to the ROMIO distribution configuration
#PK                          script
#PK  --with-psm2(=DIR)       Build PSM2 (Intel PSM2) support, optionally adding
#PK                          DIR/include, DIR/lib, and DIR/lib64 to the search
#PK                          path for headers and libraries
#PK  --with-psm2-libdir=DIR  Search for PSM (Intel PSM2) libraries in DIR
#PK  --with-pml-ob1-matching=type
#PK                          Configure pml/ob1 to use an alternate matching
#PK                          engine. Only valid on x86_64 systems. Valid values
#PK                          are: none, default, arrays, fuzzy-byte, fuzzy-short,
#PK                          fuzzy-word, vector (default: none)
#PK  --with-treematch        Build TreeMatch topology support. Building against
#PK                          an external TreeMatch is no longer supported, so
#PK                          valid values are "yes" or "no".
#PK  --with-pic[=PKGS]       try to use only PIC/non-PIC objects [default=use
#PK                          both]
#PK  --with-aix-soname=aix|svr4|both
#PK                          shared library versioning (aka "SONAME") variant to
#PK                          provide on AIX, [default=aix].
#PK  --with-gnu-ld           assume the C compiler uses GNU ld [default=no]
#PK  --with-sysroot[=DIR]    Search for dependent libraries within DIR (or the
#PK                          compiler's sysroot if not specified).
#PK 
#PK Some influential environment variables:
#PK  CC          C compiler command
#PK  CFLAGS      C compiler flags
#PK  LDFLAGS     linker flags, e.g. -L<lib dir> if you have libraries in a
#PK              nonstandard directory <lib dir>
#PK  LIBS        libraries to pass to the linker, e.g. -l<library>
#PK  CPPFLAGS    (Objective) C/C++ preprocessor flags, e.g. -I<include dir> if
#PK              you have headers in a nonstandard directory <include dir>
#PK  CXX         C++ compiler command
#PK  CXXFLAGS    C++ compiler flags
#PK  CXXCPP      C++ preprocessor
#PK  CCAS        assembler compiler command (defaults to CC)
#PK  CCASFLAGS   assembler compiler flags (defaults to CFLAGS)
#PK  FC          Fortran compiler command
#PK  FCFLAGS     Fortran compiler flags
#PK  CPP         C preprocessor
#PK  PKG_CONFIG  path to pkg-config utility
#PK  PKG_CONFIG_PATH
#PK              directories to add to pkg-config's search path
#PK  PKG_CONFIG_LIBDIR
#PK              path overriding pkg-config's built-in search path
#PK  CRAY_UGNI_CFLAGS
#PK              C compiler flags for CRAY_UGNI, overriding pkg-config
#PK  CRAY_UGNI_LIBS
#PK              linker flags for CRAY_UGNI, overriding pkg-config
#PK  CRAY_UDREG_CFLAGS
#PK              C compiler flags for CRAY_UDREG, overriding pkg-config
#PK  CRAY_UDREG_LIBS
#PK              linker flags for CRAY_UDREG, overriding pkg-config
#PK  CRAY_XPMEM_CFLAGS
#PK              C compiler flags for CRAY_XPMEM, overriding pkg-config
#PK  CRAY_XPMEM_LIBS
#PK              linker flags for CRAY_XPMEM, overriding pkg-config
#PK  CRAY_XPMEM_STATIC_LIBS
#PK              static linker flags for CRAY_XPMEM, overriding pkg-config
#PK  LT_SYS_LIBRARY_PATH
#PK              User-defined run-time library search path.
#PK 
#PK Use these variables to override the choices made by `configure' or to help
#PK it to find libraries and programs with nonstandard names/locations.
#PK 
#PK Report bugs to <https://www.open-mpi.org/community/help/>.
rm -rf openmpi-5.0.5
tar -zxvf openmpi-5.0.5.tar.gz
export CC=gcc	      C compiler command
#PK export CFLAGS      C compiler flags
#PK export LDFLAGS     linker flags, e.g. -L<lib dir> if you have libraries in a nonstandard directory <lib dir>
#PK export LIBS        libraries to pass to the linker, e.g. -l<library>
#PK export CPPFLAGS    (Objective) C/C++ preprocessor flags, e.g. -I<include dir> if you have headers in a nonstandard directory <include dir>
export CXX=g++	      C++ compiler command
#PK export CXXFLAGS    C++ compiler flags
#PK export CXXCPP      C++ preprocessor

#PK export CCAS        assembler compiler command (defaults to CC)
#PK export CCASFLAGS   assembler compiler flags (defaults to CFLAGS)

export FC=gfortran	      Fortran compiler command
#PK export FCFLAGS     Fortran compiler flags
#PK export CPP	      C preprocessor
#PK export PKG_CONFIG  path to pkg-config utility
#PK export PKG_CONFIG_PATH  directories to add to pkg-config's search path
#PK export PKG_CONFIG_LIBDIR path overriding pkg-config's built-in search path
#PK export   CRAY_UGNI_CFLAGS C compiler flags for CRAY_UGNI, overriding pkg-config
#PK export   CRAY_UGNI_LIBS linker flags for CRAY_UGNI, overriding pkg-config
#PK export   CRAY_UDREG_CFLAGS C compiler flags for CRAY_UDREG, overriding pkg-config
#PK export   CRAY_UDREG_LIBS linker flags for CRAY_UDREG, overriding pkg-config
#PK export   CRAY_XPMEM_CFLAGS C compiler flags for CRAY_XPMEM, overriding pkg-config
#PK export   CRAY_XPMEM_LIBS linker flags for CRAY_XPMEM, overriding pkg-config
#PK export   CRAY_XPMEM_STATIC_LIBS static linker flags for CRAY_XPMEM, overriding pkg-config
#PK export   LT_SYS_LIBRARY_PATH User-defined run-time library search path.

cd openmpi-5.0.5

./configure  --prefix=/mnt/beegfs/paulo.kubota/lib/lib_gnu/openmpi  
make
make install

#PK  --prefix=PREFIX         install architecture-independent files in PREFIX
#PK                          [/usr/local]
#PK  --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
#PK                          [PREFIX]
