#!/bin/sh
## This script shall wrap/hide how we are going to compile C++ 
## source files within the ANTLR (www.antlr.org) project.
test -z "${verbose}" && { 
  verbose=0
}

## check whether we have something to do ..
test -z "$1" &&  exit 0

## get arguments
ARGV="$*"

## Command CXX is precomputed but user may override.
if test -z "${CXX}" ; then
  CXX="g++"
  cxx="gcc"
else
  cxx="`basename $CXX`"
  cxx="`echo $cxx|sed 's,\..*$,,'`"
fi

## use whitespace  to separate dirs, don't use compiler specific
## options like '-I' etc.  That will be added at runtime when we
## know what compiler is in use.
## 2.7.6: take CXXINCLUDE from environment into account.
CXXINCLUDE=". ${CXXINCLUDE} /mnt/beegfs/paulo.kubota/lib/lib_gnu/antlr/antlr-2.7.7/antlr-2.7.7/scripts/../lib/cpp"

## according to Kurt we need to set some additional included
## paths when using 'cxx' on Tru64. Here we go ..
case $cxx in
  cxx)
    CXXINCLUDE="$CXXINCLUDE /mnt/beegfs/paulo.kubota/lib/lib_gnu/antlr/antlr-2.7.7/antlr-2.7.7/scripts/../include"
    CXXINCLUDE="$CXXINCLUDE /usr/include/cxx"
    CXXINCLUDE="$CXXINCLUDE /usr/include"
    ;;
esac


test -z "${DEBUG}" && {
  DEBUG="0"
}

##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##
##       Here we set flags for well know programs         ##
##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##
##
## Do not set variable CXXFLAGS here, just  use it's sister
## variable 'cxxflags'. This  allows the caller to override
## this settings - see handling of CXXFLAGS below.

case "${cxx}" in
  cxx) 
    cxxflags="-D__DECCXX -ieee -DDEC -O0 -arch host -trapuv -check_bounds -warnprotos -std1 -noansi_args -portable"
    #-I/spare/mccalke/antlr-2.7.5-new/include -I/usr/include/cxx -I/usr/include -L/usr/lib/cmplrs/cxx -L/usr/lib/cmplrs/cxx/V6.5-042"
    ;;

  gcc)
    cxxflags="-felide-constructors -pipe"
    case "${DEBUG}" in
      0)
        cxxflags="-O2 -DNDEBUG ${cxxflags}"
        ;;
      1)
        cxxflags="-g ${cxxflags} -W -Wall"
        ;;
    esac
    ;;
  cl)
    cxxflags="-nologo -GX -GR" 
    ;;
  bcc32)
    cxxflags="-q -v -w-inl -w-aus -w-par -w-ccc" 
    ;;
  CC)
    cxxflags="-g" 
    ;;
  xlC)
    cxxflags="" 
    ;;
  aCC)
    cxxflags="" 
    ;;
  *)
    cxxflag=""
    ;;
esac

case ${cxx} in
  bcc32|CC|aCC|xlC|cxx)
    CXX_OPT_INCLUDE="-I"
    ;;
  *)
    CXX_OPT_INCLUDE="-I "
    ;;
esac

##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##
## **NO CHANGE NECESSARY BELOW THIS LINE - EXPERTS ONLY** ##
##xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx##


## If specific flags have been configured then they overrule
## our precomputed flags. Still a user can override by using
## environment variable $CXXFLAGS - see below.
test -n "" && {
  set x   ; shift
  case $1 in
    +)
      shift
      CXXFLAGS="${cxxflags} $*"
      ;;
    -)
      shift
      cxxflags="$* ${cxxflags}"
      ;;
    =)
      shift
      cxxflags="$*"
      ;;
    *)
      if test -z "$1" ; then
        cxxflags="${cxxflags}"
      else
        cxxflags="$*"
      fi
      ;;
  esac
}

## Regardless what has been configured, a user should always
## be able to  override  without  the need to reconfigure or
## change this file. Therefore we check variable $CXXFLAGS.
## In almost all cases the precomputed flags are just ok but
## some  additional  flags are needed. To support this in an
## easy way, we check for the very first value. If this val-
## ue is 
## '+'  -> append content of CXXFLAGS to precomputed flags
## '-'  -> prepend content    -*-
## '='  -> do not use precomputed flags
## If none of these characters are given, the behaviour will
## be the same as if "=" would have been given.

set x ${CXXFLAGS}  ; shift
case $1 in
  +)
    shift
    CXXFLAGS="${cxxflags} $*"
    ;;
  -)
    shift
    CXXFLAGS="$* ${cxxflags}"
    ;;
  =)
    shift
    CXXFLAGS="$*"
    ;;
  *)
    if test -z "$1" ; then
      CXXFLAGS="${cxxflags}"
    else
      CXXFLAGS="$*"
    fi
    ;;
esac

##%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%##
##    No  c u s t o m i z a t i o n  below this line          ##
##%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%##

## translate args - requires that we are on cygwin. Other-
## wise  we have to assume that args are already in proper 
## format.

case "linux-gnu" in
  cygwin)
    case "gcc" in
      cl|bcc32)
        ARGV="`cygpath -m ${ARGV}`"
        ;;
    esac
    ;;
esac

## we only add valid directories - note that CXXINCLUDE is
## supposed to  contain  directories  and  not optionized'
## arguments.

set x ${CXXINCLUDE} ; shift
Y=""

## filter non valid directories
while test $# -gt 0 ; do
  y="$1" ; shift
  test -d "${y}" && {
    Y="${Y} ${y}"
  }
done

set x ${Y} ; shift ; Y=""

## translate directories on cygwin
case "linux-gnu" in
  cygwin)
    set x `cygpath -m ${*}` ; shift
    ;;
esac

## prefix each arg with CXX_OPT_INCLUDE (for instance -I)
while test $# -gt 0 ; do
  y="$1" ; shift
  Y="${Y} ${CXX_OPT_INCLUDE}${y}"
done

CXXINCLUDE="${Y}"

###xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx###
###            LAST CHANCE COMPILER TUNIG HERE                     ###
###================================================================###

case "${cxx}" in
  cl)
    ;;
  bcc32)
    ;;
  gcc)
    ;;
  xlC)
    ;;
  CC)
    ;;
  aCC)
    ;;
  cxx)
    ;;
  *)
    ;;
esac

case "gcc" in
  *)
    CXXFLAGS="${CXXFLAGS} -c"
    ;;
esac

###xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
### all variables participating in calling must be set now..
###---------------------------------------------------------

CXX_CMD="${CXX} ${CXXFLAGS} ${CXXINCLUDE}"

test -z "${ARGV}" && exit 0

for x in ${ARGV} ; do
  cmd="$CXX_CMD $x"
  
  case "${verbose}" in
    0|no|nein|non)
      echo "*** compiling $x"
      ;;
    *)
      echo $cmd
      ;;
  esac
  
  $cmd || {
    rc=$?
    cat <<EOF

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
                      >> E R R O R <<
============================================================

$cmd

============================================================
Got an error while trying to execute  command  above.  Error
messages (if any) must have shown before. The exit code was:
exit($rc)
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
EOF
    exit $rc
 }

done
exit 0

