      SUBROUTINE W3FI82 (IFLD,FVAL1,FDIFF1,NPTS)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:  W3FI82        CONVERT TO SECOND DIFF ARRAY
C   PRGMMR: CAVANAUGH        ORG: NMC421      DATE:93-08-18
C
C ABSTRACT: ACCEPT AN INPUT ARRAY, CONVERT TO ARRAY OF SECOND
C   DIFFERENCES.  RETURN THE ORIGINAL FIRST VALUE AND THE FIRST
C   FIRST-DIFFERENCE AS SEPARATE VALUES.
C
C PROGRAM HISTORY LOG:
C   93-07-14  CAVANAUGH
C   93-08-18  R.E.JONES   RECOMPILE FOR SiliconGraphics
C   95-10-31  IREDELL     REMOVED SAVES AND PRINTS
C
C USAGE:    CALL W3FI82 (IFLD,FVAL1,FDIFF1,NPTS)
C   INPUT ARGUMENT LIST:
C     IFLD     - INTEGER INPUT ARRAY
C     NPTS     - NUMBER OF POINTS IN ARRAY
C
C   OUTPUT ARGUMENT LIST:
C     IFLD     - SECOND DIFFERENCED FIELD
C     FVAL1    - FLOATING POINT ORIGINAL FIRST VALUE
C     FDIFF1   -     "      "   FIRST FIRST-DIFFERENCE
C
C REMARKS: SUBPROGRAM CAN BE CALLED FROM A MULTIPROCESSING ENVIRONMENT.
C
C ATTRIBUTES:
C   LANGUAGE: SiliconGraphics 3.5 FORTRAN 77
C   MACHINE:  SiliconGraphics model 25, 35, INDIGO
C
C$$$
C
      REAL        FVAL1,FDIFF1
C
      INTEGER     IFLD(*),NPTS
C
C  ---------------------------------------------
          DO 4000 I = NPTS, 2, -1
              IFLD(I)  = IFLD(I) - IFLD(I-1)
 4000     CONTINUE
          DO 5000 I = NPTS, 3, -1
              IFLD(I)  = IFLD(I) - IFLD(I-1)
 5000     CONTINUE
C         PRINT *,'IFLD(1) =',IFLD(1),'  IFLD(2) =',IFLD(2)
C
C                      SPECIAL FOR GRIB
C                         FLOAT OUTPUT OF FIRST POINTS TO ANTICIPATE
C                         GRIB FLOATING POINT OUTPUT
C
          FVAL1    = IFLD(1)
          FDIFF1   = IFLD(2)
C
C       SET FIRST TWO POINTS TO SECOND DIFF VALUE FOR BETTER PACKING
C
          IFLD(1)  = IFLD(3)
          IFLD(2)  = IFLD(3)
C  -----------------------------------------------------------
      RETURN
      END
