;*************************************************************************************
;This program make the contour plot of the emissions given in the processed file from
;the RETRO or EDGAR databases, either in an X window or in a PS file.
;*************************************************************************************

pro legende , n_color,color,niveau,position_x_fin,position_y_debut,position_y_fin,unit

;*************************************************************************************
;This function is for ploting the color scale in the left part of the windows.
;*************************************************************************************

 	x0 = position_x_fin+0.03
 	x1 = x0+0.03
 	y1 = position_y_debut
 	largeur = (position_y_fin-position_y_debut)/float((n_color-1))
 	epaisseur = 0.003

	while largeur*(n_color+1) ge 1. do largeur = largeur - 0.001
			
	for i=0,(n_color-1) do begin
 		y0 = y1
 		y1 = y0+largeur
 		POLYFILL,[x0-epaisseur,x0-epaisseur,x1+epaisseur,x1+epaisseur],$
			[y0-epaisseur,y1+epaisseur,y1+epaisseur,y0-epaisseur],color = 0,/normal
 		POLYFILL, [x0,x0,x1,x1],[y0,y1,y1,y0],color = color(i),/normal
  		if i eq 0 then begin
  			xyouts,x1+0.01,y0-0.005, STRING(FORMAT='(i4)',niveau(i)),SIZE=0.6,/normal,charthick=1.
  		endif else begin
 			xyouts,x1+0.01,y0-0.005,STRING(format='(e10.4)',niveau(i)),SIZE=0.6,$
				/normal,charthick=1.
		endelse
 	endfor
 	y0 = y1
 	y1 = y0+largeur
 	xyouts,x1+0.01,y0-0.005,STRING(format='(e10.4)',niveau(i)),SIZE=0.6,/normal,charthick=1.
  	XYOUTS,x1+0.01,y1-largeur*0.4,unit,SIZE=0.6,/normal,charthick=1.
 	return
end

pro visu

	close, /all

;**************************************************************************************
;Loading of the color table and declaration of main variables (for both RETRO and EDGAR
;**************************************************************************************

	loadct, 33
	tvlct, r, g, b, /get
	!p.region = [0.1,0.1,0.9,0.9]
	mydevice = !d.name
	sortie = 0 ;X Window or PS file ?
	nbniv =   0 ;Number of contour level to plot
	nom = ' '
	ligne = ' '
	nbent = 0. ;Number of header lines
	nbligne = 0. ;Number of data lines
	retro = 0 ;Is 1 if it is a RETRO file
	edgar = 0 ;Is 1 if it is an EDGAR file
	som = 0 ;Do you wish to compute the sum over the year (for RETRO only) ?
	i = 0.
	j = 0.
	k = 1
	unit = 'kg/m**2/s'
	espece = ' '
	nmin = 0.
	nmax = 0.
	lontmp = 0.
	lattmp = 0.
	n1 = 0
	n2 = 0
	sources = ' '
	print, 'Name of the file ?'
	read, nom

;*************************************************************************************
;The name of the specie is read from the name of the file, which is common to EDGAR
;and RETRO. This name is only used for the title of the contour plot.
;*************************************************************************************
	
	if strpos(strupcase(nom),'CO') ne -1 then espece = 'CO'
	if strpos(strupcase(nom),'NO') ne -1 then espece = 'NO'
	if strpos(strupcase(nom),'C2H4') ne -1 then espece = 'C2H4'
	if strpos(strupcase(nom),'C2H6') ne -1 then espece = 'C2H6'
	if strpos(strupcase(nom),'ACETONE') ne -1 then espece = 'Acetone'
	if strpos(strupcase(nom),'C3H8') ne -1 then espece = 'C3H8'
	if strpos(strupcase(nom),'ISOPRENE') ne -1 then espece = 'Isoprene'
	if strpos(strupcase(nom),'TERPENES') ne -1 then espece = 'Monoterpene'
	if strpos(strupcase(nom),'CH3OH') ne -1 then espece = 'CH3OH'

	print, espece

	n1 = strpos(nom, '_')
        n2 = strpos(nom, '.', n1+1)
        sources = strmid(nom, n1+1,n2-n1-1)
	print, sources

	print, 'output format :'
	print, '(0) : X'
	print, '(1) : ps'
	read, sortie

;************************************************************************************
;Setings of the window for the PS file format and for the X window.
;************************************************************************************
	
	if sortie  then begin
		set_plot, 'PS'
		device,  /landscape, /color
		!p.position = [0.25,0.2,0.95,0.8]
	endif else begin
		device, decompose=0
		!p.background = 255
		!p.color = 0
		!P.position = [0.2,0.2,0.9,0.9]
		window, xsize = 1200., ysize = 600., retain=2
	endelse

;************************************************************************************
;Begining of the reading of the file. Since the number of lines change betwen each
;file, the file is read once to determine both the number of header lines and the 
;number of data lines. During this reading, the database used is checked and printed
;on the screen.
;************************************************************************************
	
	openr,1,nom
	print, ' '
	print, 'Header of the file :'
	print, ' '
 	while not EOF(1) do begin
		readf,1,ligne
               if ((strmid(ligne,0,1)ne'#')) then begin
		nbligne = nbligne+1.
		endif else begin
			nbent++
			print, ligne
			if strpos(strupcase(ligne),'POET') ne -1 then begin
				retro = 1
				print, 'Database used : POET.'
				print, ' '
			endif
		endelse
 	endwhile
	
	print, ' '
	print,nbent, ' header lines and ', nbligne, ' data lines.'
	print, ' '
	close,1
	
;*************************************************************************************
;Second reading of the file. This one depend on the database used. For RETRO, the
;header is writen in two part : one befor the indication of the month (13 lines),
;another after this indication (3 lines). For EDGAR, there is only one part.
;For RETRO, there are 12 monthly means given, so it is possible to compute the total
;for the entire year. The cell surface being given, it is also possible to obtain the 
;emissions in kg/s. For EDGAR, there is only the yearly mean, without the cell
;surface, so...
;For the total over the year, the first month is used to determine the year and so the
;number of days for this year (365 or 366 ?).
;During the reading, the tables are fill up, and the first line is given (so you can
;check with the file). It is also checked if there are negative emissions in the file
;(it can sometime happen, see the caveheats on the web site), so you will know wy the
;program does not work properly.
;It also check if the last value in lon is not 0, which would mean wrong reading.
;The only tables used for that is lon, since one line has the following format :
;longitude latitude values [1...12] surface (for RETRO)
;longitude latitude value                   (for EDGAR)
;So lon is enough.
;*************************************************************************************
	
	openr,1,nom
	
	if retro then begin
		valtmp = dblarr(12)
		val1tmp = 0.D
		val2tmp = 0.D
		val3tmp = 0.D
		val4tmp = 0.D
		val5tmp = 0.D
		val6tmp = 0.D
		val7tmp = 0.D
		val8tmp = 0.D
		val9tmp = 0.D
		val10tmp = 0.D
		val11tmp = 0.D
		val12tmp = 0.D
		tab_mois = fltarr(12)
		mois = ['jan','feb','march','apr','may','jun',$
			'jully','aug','sept','oct','nov','dec']

		annee = 0
		annual = 0
		monthly = 1
		dl = 1
		print, 'Monthly mean.'
		print, 'resolution : ', dl
		print, ' '
		print, 'Sum for the year ?'
		print, '(0) : no'
		print, '(1) : yes'
		read, som
		for i=0.,nbent-1. do begin
		readf,1,ligne
		endfor
		tab_mois = [31,28.25,31,30,31,30,31,31,30,31,30,31]
		lon = fltarr(nbligne)
		lat = fltarr(nbligne)
		i = 0.
print, tab_mois
		if som then begin
			tab_tot = dblarr(nbligne)
			while not EOF(1) do begin
				readf,1,lontmp,lattmp,valtmp
				lon(i) = lontmp
				lat(i) = lattmp
				for j=0,11 do begin
					tab_tot(i) = tab_tot(i)+valtmp(j)*tab_mois(j)/365.25
				endfor
				i++
			endwhile
			print, 'First data line :'
			print, lontmp,lattmp,valtmp
			print, ' '
		endif else begin
			tab_tot = dblarr(nbligne,12)
		 	val1 = dblarr(nbligne)
			val2 = dblarr(nbligne)
 			val3 = dblarr(nbligne)
 			val4 = dblarr(nbligne)
 			val5 = dblarr(nbligne)
 			val6 = dblarr(nbligne)
 			val7 = dblarr(nbligne)
 			val8 = dblarr(nbligne)
 			val9 = dblarr(nbligne)
 			val10 = dblarr(nbligne)
 			val11 = dblarr(nbligne)
 			val12 = dblarr(nbligne)
 			while not EOF(1) do begin
 				readf,1,lontmp,lattmp,valtmp
 				lon(i) = lontmp
 				lat(i) = lattmp
				for j=0,11 do tab_tot(i,j) = valtmp(j)
 				i++
			endwhile
			print, 'First data line :'
			print, lontmp,lattmp,val1tmp
			print, ' '
			val1(*) = tab_tot(*,0)
			val2(*) = tab_tot(*,1)
			val3(*) = tab_tot(*,2)
			val4(*) = tab_tot(*,3)
			val5(*) = tab_tot(*,4)
			val6(*) = tab_tot(*,5)
			val7(*) = tab_tot(*,6)
			val8(*) = tab_tot(*,7)
			val9(*) = tab_tot(*,8)
			val10(*) = tab_tot(*,9)
			val11(*) = tab_tot(*,10)
			val12(*) = tab_tot(*,11)
		endelse
		if (lon(nbligne-1) ne 0.) then begin
			print, 'Reading OK.'
		endif else begin
			print, 'Probleme during recuperation : missing value(s).'
		endelse
		close, 1
		pos = where(tab_tot lt 0)
		if pos(0) ne -1 then print, 'Negative value(s) : ', tab_tot(pos)
	endif

;*****************************************************************************
;Creation of the tables used to compute the contour plot. The number of values
;is determine by the spatial resolution (0.5 for RETRO and 1 for EDGAR).
;To determine the first values (eg -180 or -179.75 for RETRO) the program 
;look for the values 0.5 or 0.25. For EDGAR, there is no problem : the first
;value is -180. The tables created depend on what you compute : sum over the
;year, change of unit ?
;*****************************************************************************
		
	if dl eq 1. then begin
	        tab_lat = fltarr(181)
	        tab_lon = fltarr(361)
	        tab_val1 = dblarr(361,181)
	        tab_val2 = dblarr(361,181)
	        tab_val3 = dblarr(361,181)
	        tab_val4 = dblarr(361,181)
	        tab_val5 = dblarr(361,181)
	        tab_val6 = dblarr(361,181)
	        tab_val7 = dblarr(361,181)
	        tab_val8 = dblarr(361,181)
	        tab_val9 = dblarr(361,181)
	        tab_val10 = dblarr(361,181)
	        tab_val11 = dblarr(361,181)
	        tab_val12 = dblarr(361,181)
		if som then begin
			tot_val = dblarr(361,181)
		endif else begin
			tot_val = dblarr(361,181,12)
		endelse
		for i=0.,360. do begin
			tab_lon(i) = -179.5 + i
		endfor

		for i=0.,180. do begin
			tab_lat(i) = -89.5 + i
		endfor
	endif

	print, 'Initialisation OK.'

;*****************************************************************************
;The values of emissions range over several order of magnitude. So if you
;know the number of order of magnitude, you can choose the number of contour
;level you whish to plot and set nbniv to this value. If you don't know, you
;can either put 0 or a high number in nbniv, so the program will calculate
;nbniv to get at least 1 level by order of magnitude or at maximum 10 levels
;by order of magnitude.
;After that, the effectives contour levels and the color scale are calculated.
;*****************************************************************************
	
	temp = 0.
	npog = 0
monthly = 1
	
	if monthly then begin
		ou = where(tab_tot ne 0)
		nbnnul = size(ou, /n_elements)
		non_nul = dblarr(nbnnul)
		for i=0.,nbnnul-1. do begin
			non_nul(i) = tab_tot(ou(i))
		endfor	
	        nmax = max(non_nul)
	        nmin = min(non_nul)
	endif else begin
		nmax = max(val1)
		nmin = min(val1)
	endelse

print, nmin, nmax
	
	ogmin = floor(alog10(nmin))
	ogmax = floor(alog10(nmax) + 0.5)
	nog = ogmax - ogmin + 1
	npog = nbniv / nog
	if npog lt 1 then begin
		print, 'Not enough : ', npog
		while npog lt 1 do begin
			nbniv++
			npog = nbniv / nog
		endwhile
	endif
	if npog gt 10 then begin
		print, 'To much : ', npog
		while npog gt 10 do begin
			nbniv--
			npog = nbniv / nog
		endwhile
	endif
	print, ogmin, ogmax, nog
	print, 'Number of levels : ', nbniv
	print, 'Number of levels per order of magnitude : ', npog
	kmin = floor(alog10(nmin))
	kmax = floor(alog10(nmax+0.5))

        print, 'De : ', nmin,' a : ', nmax
	tab_col = fltarr(nbniv)
	tab_col2 = fltarr(nbniv+1)

	for i=0.,nbniv-1. do tab_col(i)= 250.*(i+1)/ (float(nbniv))
	tab_col2(0)=255.
	for i=0.,nbniv-1. do tab_col2(i+1)= 250.*(i+1)/ (float(nbniv))
	V = dblarr(nbniv+1)
	V2 = dblarr(nbniv+2)
	
	V2(0) = 0.D

	k = kmin
	j = 1
	for i=1,nbniv+1 do begin
		V2(i) = j*(1.D/npog)*(10.D^k)
		j++
		if j ge npog then begin
			j = 1
			k++
		endif
	endfor

	for i=0.,nbniv do begin
		V(i) = V2(i+1)
	endfor

;***********************************************************************************
;At last, the contour plot can be ploted ! Each case (RETRO or EDGAR) is
;different, like for the sum or not, or the change of unit. Each case is developed.
;To plot, the order of the calls is as follow :
; - seting of the map in order to adapt the contour plot size on the size of the map
; - ploting of the contours (/overplot is the key word to adapt the size)
; - ploting of the continents (over the contour)
; - ploting of the grid (over all to be visible)
;For RETRO :
;if you creat a PS file with the 12 month, 12 files are created,
;if you use the X window, the program will ask you for what month to plot.
;***********************************************************************************

	if monthly then begin
		if som then begin
 			for i=0.,nbligne-1 do begin
 				tot_val(where(tab_lon eq lon(i)),where(tab_lat eq lat(i)))$
					=tab_tot(i)
 			endfor
			if sortie then begin
				nom = strcompress('poet_sum_'+sources+'_'+espece+'.ps')
				device, filename = nom
				map_set,title = espece+' Min :'+string(nmin)+$
					' Max :'+string(nmax)+' '+unit
				contour,tot_val,tab_lon,tab_lat,$
					levels=V,/cell_fill,c_colors=tab_col,/overplot
				map_continents, /hires
				map_grid,/label,latdel=10,londel=10,latlab=-180,lonlab=-90,charsize=0.5
				legende, nbniv+1, tab_col2, V2, 0.0, 0.01, 0.9, unit
				device, /close
				print, 'Done !!'
			endif else begin
				map_set,title=espece+' Min :'+string(nmin)+$
					' Max :'+string(nmax)+' '+unit
				contour,tot_val,tab_lon,tab_lat,$
					levels=V,/cell_fill,c_colors=tab_col,/overplot
				map_continents, /hires
				map_grid,/label,latdel=10,londel=10,latlab=-180,lonlab=-90,charsize=0.5
				legende, nbniv+1, tab_col2, V2, 0.0, 0.01, 0.9, unit
			endelse
		endif else begin
			for i=0.,nbligne-1. do begin
 			tab_val1(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val1(i)
 			tab_val2(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val2(i)
 			tab_val3(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val3(i)
 			tab_val4(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val4(i)
 			tab_val5(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val5(i)
 			tab_val6(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val6(i)
 			tab_val7(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val7(i)
 			tab_val8(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val8(i)
 			tab_val9(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val9(i)
 			tab_val10(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val10(i)
 			tab_val11(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val11(i)
 			tab_val12(where(tab_lon eq lon(i)),where(tab_lat eq lat(i))) = val12(i)
			endfor
			tot_val(*,*,0) = tab_val1(*,*)
			tot_val(*,*,1) = tab_val2(*,*)
			tot_val(*,*,2) = tab_val3(*,*)
			tot_val(*,*,3) = tab_val4(*,*)
			tot_val(*,*,4) = tab_val5(*,*)
			tot_val(*,*,5) = tab_val6(*,*)
			tot_val(*,*,6) = tab_val7(*,*)
			tot_val(*,*,7) = tab_val8(*,*)
			tot_val(*,*,8) = tab_val9(*,*)
			tot_val(*,*,9) = tab_val10(*,*)
			tot_val(*,*,10) = tab_val11(*,*)
			tot_val(*,*,11) = tab_val12(*,*)

			if sortie then begin
				deb_nom = 'poet_month_'
				fin_nom = '.ps'
					for i=0,11 do begin
				device, filename=strcompress(deb_nom+string(i+1)+'_'+sources+'_'+espece+fin_nom, /remove_all)
				map_set,title=espece+' Min :'+$
				string(nmin)+' Max :'+string(nmax)+' '+unit+' '+mois(i)
				contour,tot_val(*,*,i),tab_lon,tab_lat,$
					levels=V,/cell_fill,c_colors=tab_col,/overplot
				map_continents, /hires
				map_grid, /label,latdel=10,londel=10,latlab=-180,lonlab=-90,charsize=0.5
				legende, nbniv+1, tab_col2, V2, 0.0, 0.01, 0.9, unit
				device, /close
				print, mois(i), 'Done !!'
					endfor
			endif else begin
				print, 'Months : 0  11'
				print, 'What month ?'
				read, i
				if i gt 11 then begin
					print, 'Be carefull, indices ranging from 0 to 11 !'
					print, 'Month corrected : 11.'
					i = 11
				endif
				if i lt 0 then i = 0
				map_set, title=espece+' Min :'+string(nmin)+' Max :'+string(nmax)+$
					' '+unit+' '+mois(i)
				contour,tot_val(*,*,i),tab_lon,tab_lat,$
					levels=V,/cell_fill,c_colors=tab_col,/overplot
				map_continents, /hires
				map_grid, /label,latdel=10,londel=10,latlab=-180,lonlab=-90,charsize=0.5
				legende, nbniv+1, tab_col2, V2, 0.0, 0.01, 0.9, unit
			endelse
		endelse
	endif
	set_plot, mydevice
end 
