
import os
import sys
import re
import matplotlib.pyplot as mpl
from mpl_toolkits.basemap import Basemap
from collections import OrderedDict
import numpy as np


def plot(window, file_lst):

    #
    # Building the map!
    #
    # Util: Basemap colors
    #       URL: https://matplotlib.org/examples/color/named_colors.html
    #
    map = Basemap(projection='cyl', resolution='l', lat_0=0, lon_0=0)
    map.drawcoastlines(linewidth=.3, color='gray')
    # map.drawcountries()
    # map.drawmapboundary()
    # labels = [left,right,top,bottom]
    map.drawmeridians(np.arange(0, 360, 30), labels=[0, 0, 1, 1], linewidth=.3, fontname='Tahoma', fontsize=6)
    map.drawparallels(np.arange(-80, 90, 20), labels=[1, 1, 0, 0], linewidth=.3, fontname='Tahoma', fontsize=6)

    n_obs = [0] * len(file_lst)
    i = 0
    for fi in file_lst:

        fname = path + "/" + fi

        print("(I) Data read {:s}".format(fname))

        if not os.path.exists(fname):
            i += 1
            continue

        fp = open(fname, "rt")
        fp.readline()
        data = fp.readlines()
        fp.close()

        print("(I) Num lines: ", len(data))

        lon = []
        lat = []
        for k in range(len(data)):
            line = re.findall(r'\S+', data[k])

            if len(line) < 7:
                continue

            if float(line[1]) < -180 or float(line[1]) > 360:
                continue

            if float(line[2]) < -90 or float(line[2]) > 90:
                continue

            lon.append(float(line[1]))
            lat.append(float(line[2]))

        # Plot
        x, y = map(lon, lat)
        n = len(set(zip(x, y)))  # count without duplicates!
        n_obs[i] = len(data)

        if fname.find("_aws") >= 0:
            lb = "AWS (" + str(n_obs[i]) + ")"
            map.plot(x, y, '.', label = lb, color='gold', markersize=2.5)
        elif fname.find("_metar") >= 0:
            lb = "METAR (" + str(n_obs[i]) + ")"
            map.plot(x, y, '.', label = lb, color='red', markersize=2.5)
        elif fname.find("_synop") >= 0:
            lb = "SYNOP (" + str(n_obs[i]) + ")"
            map.plot(x, y, '.', label = lb, color='blue', markersize=2.5)
        else:
            print("(W) Data type NOT implemented, yet")

        i += 1

    mpl.legend(loc = "lower center", bbox_to_anchor = (0.5, -0.15), ncol = 3)
    print(n_obs, sum(n_obs))
    total = sum(n_obs)

    # title = "\n"
    title = "Distribuicao Espacial das Observacoes (superficie da Terra)\n"
    title += "DIPTC/INPE, 25/06/2025 00GMT\n"
    title += "Total obs.: " + str(total)
    title += "\n"

    mpl.title(title, fontname='Tahoma', fontsize=12, color='darkblue')

    mpl.show()


# Globals
path = "./data"


def main():
    
    if len(sys.argv) != 3:
       print("Usage: {:s} YYYYmmddHH file_lst".format(sys.argv[0]))
       return 1
    
    window = sys.argv[1]

    if len(window) != 10:
       print("(E) Please, use the following date format: YYYYmmddHH")
       return 1

    file_lst = re.split(" ", sys.argv[2])

    # try:
    plot(window, file_lst)
    # except:
    #    print("(E) Error on data processing!")
    #    return 1

    return 0


if __name__ == '__main__':
    sys.exit(main())
    