
import math
import os
import re
import sys
from eccodes import *


def write_table(target_date, fname, fname_out):

    parm_lst = ["nonCoordinatePressure", "pressureReducedToMeanSeaLevel", "3HourPressureChange", 
                        "characteristicOfPressureTendency", "windDirectionAt10M", "windDirection", 
                        "windSpeedAt10M", "windSpeed", "airTemperatureAt2M", 
                        "airTemperature", "dewpointTemperatureAt2M", "dewpointTemperature", 
                        "relativeHumidity", "horizontalVisibility", "presentWeather", 
                        "pastWeather1", "pastWeather2", "cloudCoverTotal", 
                        "#1#cloudAmount", "heightOfBaseOfCloud", "#1#cloudType", 
                        "#2#cloudType", "#3#cloudType"]
                
    parm_lst_r = ["totalPrecipitationPast24Hours", "totalPrecipitationPast12Hours", "totalPrecipitationPast6Hours", 
                        "totalPrecipitationOrTotalWaterEquivalent"]

    parm_lst_tx = ["maximumTemperatureAt2MPast24Hours", "maximumTemperatureAt2MPast12Hours", "maximumTemperatureAtHeightAndOverPeriodSpecified"]
    
    parm_lst_tn = ["minimumTemperatureAt2MPast24Hours", "groundMinimumTemperaturePast12Hours", "groundMinimumTemperature", 
                        "minimumTemperatureAtHeightAndOverPeriodSpecified"]
                
    print("(I) Data reading (File: {:s})".format(fname))

    if fname_out != None:
       fp = open(fname_out, "a")

       if os.stat(fname_out).st_size == 0:
          fp.write("#code                  lon        lat         date        alt       type"
                        "         po          p         vp         ap          d          f"
                        "          t         td         ur          v         ww         w1"
                        "         w2          n         nh          h         cl         cm"
                        "         ch          r         tr         tn         tx\n")
    else:
       print("#code                  lon        lat         date        alt       type"
                "         po          p         vp         ap          d          f"
                "          t         td         ur          v         ww         w1"
                "         w2          n         nh          h         cl         cm"
                "         ch          r         tr         tn         tx")
    
    fp_2 = open(fname, "rb")
    
    code_lst = []
    m = 0
    while 1:

       msg = codes_bufr_new_from_file(fp_2)

       if msg == None:
          break

       n_subs = codes_get_long(msg, "numberOfSubsets")
       
       codes_set(msg, "unpack", 1)
       
       for i in range(1, n_subs + 1):
          
          try:
             codes_set(msg, "extractSubset", i)
             codes_set(msg, "doExtractSubsets", 1)
          except CodesInternalError:
             print("(E) Message #{:d} / Num of subsets: {:d} / ERROR on subset #{:d}".format((m + 1), n_subs, i))
             continue

          subs = codes_clone(msg)
          codes_set(subs, "unpack", 1)
          
          code = None
          lon = None
          lat = None
          alt = UNDEF
          stn_type = 255
          val_lst = [UNDEF] * len(parm_lst)
          
          if code == None:
             if codes_is_defined(subs, "blockNumber") and \
                        not codes_get_long(subs, "blockNumber") in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                if not codes_get_long(subs, "stationNumber") in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                   code = 1000 * codes_get_long(subs, "blockNumber") + codes_get_long(subs, "stationNumber")
                   code = format(code, "05")
                
          #if code == None:
          #   if codes_is_defined(subs, "shipOrMobileLandStationIdentifier") and \
          #              not codes_get_long(subs, "shipOrMobileLandStationIdentifier") in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
          #      code = str(codes_get(subs, "shipOrMobileLandStationIdentifier"))
          #
          if code == None:
             if codes_is_defined(subs, "wigosIdentifierSeries") and \
                        not codes_get(subs, "wigosIdentifierSeries") in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                if codes_is_defined(subs, "wigosIssuerOfIdentifier") and codes_is_defined(subs, "wigosIssueNumber"):
                   c1 = codes_get(subs, "wigosIdentifierSeries")
                   c2 = codes_get(subs, "wigosIssuerOfIdentifier")
                   c3 = codes_get(subs, "wigosIssueNumber")
                   c4 = codes_get(subs, "wigosLocalIdentifierCharacter")
                   code = str(c1) + "-" + str(c2) + "-" + str(c3) + "-" + str(c4)
          
          if code == None or len(code) < 5 or code in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             codes_release(subs)
             continue
          
          if codes_is_defined(subs, "longitude"):
             lon = codes_get_double(subs, "longitude")
          else:
             codes_release(subs)
             continue
          
          if codes_is_defined(subs, "latitude"):
             lat = codes_get_double(subs, "latitude")
          else:
             codes_release(subs)
             continue
             
          if lon in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE) or lat in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             codes_release(subs)
             continue
          
          if codes_is_defined(subs, "heightOfStationGroundAboveMeanSeaLevel"):
             alt = codes_get_long(subs, "heightOfStationGroundAboveMeanSeaLevel")
          else:
             if codes_is_defined(subs, "heightOfStation"):
                alt = codes_get_long(subs, "heightOfStation")
             else:
                if codes_is_defined(subs, "height"):
                   alt = codes_get_long(subs, "height")
          
          if alt in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             alt = UNDEF
          
          if codes_is_defined(subs, "dataSubCategory"):
             stn_type = codes_get_long(subs, "dataSubCategory")
          
             if stn_type in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                stn_type = 255
          
          YYYY = codes_get(subs, "year")
          mm = codes_get(subs, "month")
          dd = codes_get(subs, "day")
          HH = codes_get(subs, "hour")
          
          if YYYY in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE) or mm in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE) or \
                dd in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE) or HH in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             codes_release(subs)
             continue
          
          if len(str(YYYY)) < 2:
          
             if YYYY < 0 or YYYY > 99:
                codes_release(subs)
                continue
             
             if YYYY > 50:
                YYYY += 1900
             else:
                YYYY += 2000
          else:
             if YYYY < 1900 or YYYY > 2999:
                codes_release(subs)
                continue
          
          if mm < 1 or mm > 12:
             codes_release(subs)
             continue
          
          if dd < 1 or dd > 31:
             codes_release(subs)
             continue
          
          if HH < 0 or HH > 23:
             codes_release(subs)
             continue
             
          curr_date = ((((YYYY * 100) + mm) * 100 + dd) * 100) + HH
          
          if target_date != str(curr_date):
             codes_release(subs)
             continue
          
          code_ctr = str(code) + "_" + str(lon) + "_" + str(lat) + "_" + str(stn_type)
          
          found = 0
          for code_2 in code_lst:
             if code_ctr == code_2:
                found = 1
                break
          
          if found > 0:
             codes_release(subs)
             continue
          
          code_lst.append(code_ctr)
          
          k = 0
          for parm in parm_lst:
             val_lst[k] = UNDEF
          
             parm_id = codes_bufr_keys_iterator_new(subs)
             
             while codes_bufr_keys_iterator_next(parm_id):
                parm_2 = codes_bufr_keys_iterator_get_name(parm_id)
                
                if parm in parm_2:
                   if parm.find("#") < 0:
                      idx = [i_2 for i_2 in range(len(parm_2)) if parm_2[i_2] == "#"]
                      idx = idx[-1] + 1
                   else:
                      idx = 0
                   
                   if parm == parm_2[idx:]:
                      res = codes_get_double(subs, parm_2)
                   
                      if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                         val_lst[k] = res
                   
                      break
                      
             codes_bufr_keys_iterator_delete(parm_id)
                
             k += 1
          
          po = val_lst[0]
          p = val_lst[1]
          vp = val_lst[2]
          ap = val_lst[3]
          d = max(val_lst[4], val_lst[5])
          f = max(val_lst[6], val_lst[7])
          t = max(val_lst[8], val_lst[9])
          td = max(val_lst[10], val_lst[11])
          ur = val_lst[12]
          v = val_lst[13]
          ww = val_lst[14]
          w1 = val_lst[15]
          w2 = val_lst[16]
          n = val_lst[17]
          nh = val_lst[18]
          h = val_lst[19]
          cl = val_lst[20]
          cm = val_lst[21]
          ch = val_lst[22]
          
          # Finding for r
          r = UNDEF
          tr = UNDEF
          
          k = 0
          for parm in parm_lst_r:
             r = UNDEF
             tr = UNDEF
          
             parm_id = codes_bufr_keys_iterator_new(subs)
             
             while codes_bufr_keys_iterator_next(parm_id):
                parm_2 = codes_bufr_keys_iterator_get_name(parm_id)
                
                if "timePeriod" in parm_2:
                   res = codes_get_double(subs, parm_2)
                   
                   if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                      tr = abs(res)
                   
                   continue
                
                if parm in parm_2:
                   if parm.find("#") < 0:
                      idx = [i_2 for i_2 in range(len(parm_2)) if parm_2[i_2] == "#"]
                      idx = idx[-1] + 1
                   else:
                      idx = 0
                   
                   if parm == parm_2[idx:]:
                      res = codes_get_double(subs, parm_2)
                   
                      if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                         r = res
                         
                         if r < 0:
                            r = UNDEF
                      
             codes_bufr_keys_iterator_delete(parm_id)
             
             if not r in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                
                if k == 0:
                   tr = 24
                   break
                elif k == 1:
                   tr = 12
                   break
                elif k == 2:
                   tr = 6
                   break
                else:
                   if not tr in (6, 12, 24):
                      r = UNDEF
                      tr = UNDEF
                
             k += 1
          
          # Finding for tx
          tx = UNDEF
          ttx = UNDEF
          
          k = 0
          for parm in parm_lst_tx:
             tx = UNDEF
             ttx = UNDEF
             
             parm_id = codes_bufr_keys_iterator_new(subs)
             
             while codes_bufr_keys_iterator_next(parm_id):
                parm_2 = codes_bufr_keys_iterator_get_name(parm_id)
                
                if "timePeriod" in parm_2:
                   res = codes_get_double(subs, parm_2)
                   
                   if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                      ttx = abs(res)
                   
                   continue
                
                if parm in parm_2:
                   if parm.find("#") < 0:
                      idx = [i_2 for i_2 in range(len(parm_2)) if parm_2[i_2] == "#"]
                      idx = idx[-1] + 1
                   else:
                      idx = 0
                   
                   if parm == parm_2[idx:]:
                      res = codes_get_double(subs, parm_2)
                   
                      if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                         tx = res
                   
             codes_bufr_keys_iterator_delete(parm_id)
             
             if not tx in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                
                if k == 0:
                   ttx = 24
                   break
                elif k == 1:
                   ttx = 12
                   break
                else:
                   if not ttx in (12, 24):
                      tx = UNDEF
                      ttx = UNDEF
             
             k += 1
          
          # Finding for tn
          tn = UNDEF
          ttn = UNDEF
          
          k = 0
          for parm in parm_lst_tn:
             tn = UNDEF
             ttn = UNDEF
             
             parm_id = codes_bufr_keys_iterator_new(subs)
             
             while codes_bufr_keys_iterator_next(parm_id):
                parm_2 = codes_bufr_keys_iterator_get_name(parm_id)
                
                if "timePeriod" in parm_2:
                   res = codes_get_double(subs, parm_2)
                   
                   if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                      ttn = abs(res)
                   
                   continue
                
                if parm in parm_2:
                   if parm.find("#") < 0:
                      idx = [i_2 for i_2 in range(len(parm_2)) if parm_2[i_2] == "#"]
                      idx = idx[-1] + 1
                   else:
                      idx = 0
                   
                   if parm == parm_2[idx:]:
                      res = codes_get_double(subs, parm_2)
                   
                      if not res in (CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                         tn = res
                   
             codes_bufr_keys_iterator_delete(parm_id)
             
             if not tn in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
                
                if k == 0:
                   ttn = 24
                   break
                elif k == 1:
                   ttn = 12
                   break
                else:
                   if not ttn in (12, 24):
                      tn = UNDEF
                      ttn = UNDEF
                
             k += 1
             
          if not po in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             po /= 100
             
          if not p in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             p /= 100
          
          if not t in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             t -= 273.15  # K to C
             
             if t < 0:
                t = math.ceil(t * math.pow(10,1)) / math.pow(10,1)
             else:
                t = math.floor(t * math.pow(10,1)) / math.pow(10,1)
          
          if not td in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             td -= 273.15  # K to C
             
             if td < 0:
                td = math.ceil(td * math.pow(10,1)) / math.pow(10,1)
             else:
                td = math.floor(td * math.pow(10,1)) / math.pow(10,1)
          
          if not ur in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             if ur > 103:
                ur = UNDEF
             else:
                if ur > 100:
                   ur = 100
          
          if not v in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             if v > 9998:
                v = 10000
          
          if r in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             r = UNDEF
             tr = UNDEF
             
          if not tn in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             tn -= 273.15  # K to C
             
             if tn < 0:
                tn = math.ceil(tn * math.pow(10,1)) / math.pow(10,1)
             else:
                tn = math.floor(tn * math.pow(10,1)) / math.pow(10,1)
          
          if not tx in (UNDEF, CODES_MISSING_LONG, CODES_MISSING_DOUBLE):
             tx -= 273.15  # K to C
             
             if tx < 0:
                tx = math.ceil(tx * math.pow(10,1)) / math.pow(10,1)
             else:
                tx = math.floor(tx * math.pow(10,1)) / math.pow(10,1)
          
          if fname_out != None:
             fp.write("{:15s} {:10.4f} {:10.4f} {:12d} {:10d} {:10d} "
                        "{:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.2f} " \
                        "{:10.2f} {:10.2f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} " \
                        "{:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} " \
                        "{:10.0f} {:10.2f} {:10.0f} {:10.2f} {:10.2f}\n".format(code, lon, lat, curr_date, alt, stn_type, 
                        po, p, vp, ap, d, f, 
                        t, td, ur, v, ww, w1, 
                        w2, n, nh, h, cl, cm, 
                        ch, r, tr, tn, tx))
          else:
             print("{:15s} {:10.4f} {:10.4f} {:12d} {:10d} {:10d} "
                        "{:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.2f} " \
                        "{:10.2f} {:10.2f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} " \
                        "{:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} {:10.0f} " \
                        "{:10.0f} {:10.2f} {:10.0f} {:10.2f} {:10.2f}".format(code, lon, lat, curr_date, alt, stn_type, 
                        po, p, vp, ap, d, f, 
                        t, td, ur, v, ww, w1, 
                        w2, n, nh, h, cl, cm, 
                        ch, r, tr, tn, tx))
             
          codes_release(subs)
       
       codes_release(msg)
       
       m += 1
       
    fp_2.close()
    
    print("(I) Num of messages: {:d}".format(m + 1))
       
    if fname_out != None:
       fp.close()


# Globals
UNDEF = -9999


def main():

    if len(sys.argv) < 3 or len(sys.argv) > 4:
       print("Usage: {:s} YYYYmmddHH file_in [file_out]".format(sys.argv[0]))
       return 1

    target_date = sys.argv[1]

    if len(target_date) != 10:
       print("(E) Please, use the following date format: YYYYmmddHH")
       return 1

    fname = sys.argv[2]

    if os.path.exists(fname) == False:
       print("(E) Data file NOT found! (file name: {:s})".format(fname))
       return 1

    fname_out = None

    if len(sys.argv) > 3:
       fname_out = sys.argv[3]

    #try:
    write_table(target_date, fname, fname_out)
    #except:
    #   print("(E) Error on data processing!")
    #   return 1

    return 0


if __name__ == "__main__":
    sys.exit(main())
