#!/bin/bash
#SBATCH --job-name=Model.MONAN
#SBATCH --nodes=8
#SBATCH --ntasks=512
#SBATCH --tasks-per-node=64
#SBATCH --partition=batch
#SBATCH --time=8:00:00
#SBATCH --output=/mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs/model.bash.o%j    # File name for standard output
#SBATCH --error=/mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs/model.bash.e%j     # File name for standard error output
#SBATCH --exclusive
##SBATCH --mem=500000


export executable=atmosphere_model

ulimit -c unlimited
ulimit -v unlimited
ulimit -s unlimited

. /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/setenv.bash

cd /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts


date
time mpirun -np ${SLURM_NTASKS} -env UCX_NET_DEVICES=mlx5_0:1 -genvall ./${executable}
date

#
# move dataout, clean up and remove files/links
#

mv MONAN_DIAG_* /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model
mv MONAN_HIST_* /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model
cp /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/execs/VERSION.txt /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model

mv log.atmosphere.*.out /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs
mv log.atmosphere.*.err /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs
mv namelist.atmosphere /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs
mv stream* /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/dataout/2024042000/Model/logs

rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/atmosphere_model
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/*TBL 
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/*.DBL
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/*DATA
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/x1.2621442.static.nc
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/x1.2621442.graph.info.part.512
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/Vtable.GFS
rm -f /mnt/beegfs/eduardo.khamis/for_Saulo/scripts_CD-CT/scripts/x1.2621442.init.nc



