# /bin/bash -x

inctime=${HOME}/bin/inctime


## script que transforma daods .nc em dados binários manualmente. 


## diretório onde estão os dados brutos
datain='/share/das/dist/EXPS_SMNA/MONAN/'

## Nome do arquivo em .nc
file_name='MONAN_DIAG_G_POS_GFS_2024020600.00.00.x1024002L55.nc'

## Criação do diretório e log
nome_dir=$(echo "$file_name" | awk -F'[_.]' '{print $6}')
mkdir ${nome_dir}
cd ${nome_dir}
mkdir log
cd ../

## lats4d.sh ajuda a recortar o dado bruto em dados menores 

data_fmt() {

  data=${1}      
  yyyy=${data:0:4}
  mm=${data:4:2}
  dd=${data:6:2}
  hh=${data:8:2}

  if [ ${mm} -eq 01 ]; then nmm=JAN; fi
  if [ ${mm} -eq 02 ]; then nmm=FEB; fi
  if [ ${mm} -eq 03 ]; then nmm=MAR; fi
  if [ ${mm} -eq 04 ]; then nmm=APR; fi
  if [ ${mm} -eq 05 ]; then nmm=MAY; fi
  if [ ${mm} -eq 06 ]; then nmm=JUN; fi
  if [ ${mm} -eq 07 ]; then nmm=JUL; fi
  if [ ${mm} -eq 08 ]; then nmm=AUG; fi
  if [ ${mm} -eq 09 ]; then nmm=SEP; fi
  if [ ${mm} -eq 10 ]; then nmm=OCT; fi
  if [ ${mm} -eq 11 ]; then nmm=NOV; fi
  if [ ${mm} -eq 12 ]; then nmm=DEC; fi

  datafmt=${hh}Z${dd}${nmm}${yyyy}

}        

datai=2024020600
dataf=2024021600

data=${datai}

while [ ${data} -le ${dataf} ]
do        

  echo ${data}

  data_fmt ${data}

  fout=MONAN_${datai}_${data}
	
  lats4d.sh -v -i ${datain}${file_name} -time ${datafmt} ${datafmt} -o ${datain}${nome_dir}/${fout} -format sequential -ftype sdf  >> ${datain}${nome_dir}/log/${data}.log
 
  ## passo de tempo de 24 horas para obtenção das previsões  
  data=$(${inctime} ${data} +24h %y4%m2%d2%h2)

done
