# /bin/bash -x

inctime=${HOME}/bin/inctime


## script que transforma daods .nc em dados binários manualmente. 

datain='/share/das/dist/EXPS_SMNA/MONAN/'
dataout='/share/das/dist/EXPS_SMNA/MONAN_recortado/'
file_name='MONAN_DIAG_G_POS_GFS_2024022600.00.00.x1024002L55.nc'
nome_dir=$(echo "$file_name" | awk -F'[_.]' '{print $6}')

## saindo da pasta MONAN
cd ../

cd ${dataout}
mkdir ${nome_dir}
cd ${nome_dir}
mkdir log
cd ../../
cd ${datain}


data_fmt() {

  data=${1}      
  yyyy=${data:0:4}
  mm=${data:4:2}
  dd=${data:6:2}
  hh=${data:8:2}

  if [ ${mm} -eq 01 ]; then nmm=JAN; fi
  if [ ${mm} -eq 02 ]; then nmm=FEB; fi
  if [ ${mm} -eq 03 ]; then nmm=MAR; fi
  if [ ${mm} -eq 04 ]; then nmm=APR; fi
  if [ ${mm} -eq 05 ]; then nmm=MAY; fi
  if [ ${mm} -eq 06 ]; then nmm=JUN; fi
  if [ ${mm} -eq 07 ]; then nmm=JUL; fi
  if [ ${mm} -eq 08 ]; then nmm=AUG; fi
  if [ ${mm} -eq 09 ]; then nmm=SEP; fi
  if [ ${mm} -eq 10 ]; then nmm=OCT; fi
  if [ ${mm} -eq 11 ]; then nmm=NOV; fi
  if [ ${mm} -eq 12 ]; then nmm=DEC; fi

  datafmt=${hh}Z${dd}${nmm}${yyyy}

}        

datai=2024022600
dataf=2024030700

data=${datai}

while [ ${data} -le ${dataf} ]
do        

  echo ${data}

  data_fmt ${data}

  fout=MONAN_${datai}_${data}
	

  lats4d.sh -v -i ${datain}${file_name} -time ${datafmt} ${datafmt} -o ${dataout}${nome_dir}/${fout} -format grads_grib -ftype sdf -lon 1 360 >> ${dataout}${nome_dir}/log/${data}.log


  data=$(${inctime} ${data} +24h %y4%m2%d2%h2)

done
