      SUBROUTINE COEFJ(ARRX,IDIM,JDIM,I,J,C1,C2,C3,C4)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    COEFJ       INTRP WGTS FOR FILLED E-GRID COLS
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: ??-??-??
C     
C ABSTRACT:  
C     THIS ROUTINE RETURNS WEIGHTED E-GRID VALUES FOR CUBIC
C     INTERPOLATION OF COLUNMS ON FILLED E-GRID.
C   .     
C     
C PROGRAM HISTORY LOG:
C   93-05-12  RUSS TREADON - ADDED DOC BLOC
C     
C USAGE:    CALL COEFJ(ARRX,IDIM,JDIM,I,J,C1,C2,C3,C4)
C   INPUT ARGUMENT LIST:
C     ARRX     - ARRAY TO CONTAIN FILLED E-GRID.
C     IDIM     - 2*IM-1, FIRST DIMENSION OF ARRX
C     JDIM     - JM, SECOND DIMENSION OF ARRX
C     I        - TARGET POINT I INDEX
C     J        - TARGET POINT J INDEX
C
C   OUTPUT ARGUMENT LIST: 
C     C1,C2,C3,C4 - WEIGHTED FILLED E-GRID VALUES.
C
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       NONE
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C
      PARAMETER (C11=.166667,C12=-.5,C13=.5,C14=-.166667)
      PARAMETER (C21=-1.,C22=3.5,C23=-4.,C24=1.5)
      PARAMETER (C31=1.833333,C32=-7.,C33=9.5,C34=-4.333333)
      PARAMETER (C41=-1.,C42=4.,C43=-6.,C44=4.)
      DIMENSION ARRX(IDIM,JDIM)
      C1=C11*ARRX(I,J+6)+C12*ARRX(I,J+4)+C13*ARRX(I,J+2)+C14*ARRX(I,J)
      C2=C21*ARRX(I,J+6)+C22*ARRX(I,J+4)+C23*ARRX(I,J+2)+C24*ARRX(I,J)
      C3=C31*ARRX(I,J+6)+C32*ARRX(I,J+4)+C33*ARRX(I,J+2)+C34*ARRX(I,J)
      C4=C41*ARRX(I,J+6)+C42*ARRX(I,J+4)+C43*ARRX(I,J+2)+C44*ARRX(I,J)
      RETURN
      END
