      SUBROUTINE GENEUV(EVLAT,EVLON)
C
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    GENEUV      COMPUTE ROTATION (LAT,LON)
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-23
C     
C ABSTRACT:
C     THIS ROUTINE LOADS V POINT LATITUDE AND LONGITUDE
C     ARRAYS USED BY SUBROUTINE EUVGUV WHICH ROTATES 
C     U-V WINDS ON A FILLED E-GRID TO THE OUTPUT GRID
C     ORIENTATION.
C   .     
C     
C PROGRAM HISTORY LOG:
C   92-12-23  RUSS TREADON
C     
C USAGE:    CALL GENEUV(EVLAT,EVLON)
C   INPUT ARGUMENT LIST:
C     NONE
C
C   OUTPUT ARGUMENT LIST: 
C     EVLAT    - V POINT LATITUDES ON A FILLED E-GRID.
C     EVLON    - V POINT LONGITUDES ON A FILED E-GRID.
C     
C   OUTPUT FILES:
C     STDOUT  - RUN TIME STANDARD OUT.
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON   - EGRID
C                  IOUNIT
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C
C     
C     INCLUDE ETA MODEL DIMENSIONS.
      INCLUDE "parmeta"
      PARAMETER (IMT=2*IM-1,JMT=JM)
C     
C     DECLARE VARIABLES.
      LOGICAL NORTH
      REAL ALONVT, DLAM, DPHI, LAM0, PHI0, POLEI
      REAL POLEJ, COSPH0, SINPH0, TANPH0, WLONC, XMESHL
      REAL YLATC
      REAL EVLAT(IMT,JMT),EVLON(IMT,JMT)
C     
C     INCLUDE COMMONS.
      INCLUDE "EGRID.comm"
      INCLUDE "IOUNIT.comm"
C     
      EQUIVALENCE (YLATC,ALONVT), (DPHI, POLEI)
      EQUIVALENCE (WLONC, POLEJ), (DLAM,XMESHL)
C
      DATA CONV2R/0.017453293/,CONV2D/57.2958/
C     
C**************************************************************
C     START GENEUV HERE.
C     
      WRITE(STDOUT,*)'GENEUV:  LOAD EVLAT,EVLON'
C
C     COMPUTE GEODETIC LAT-LON OF E-GRID WIND POINTS.
C
      doout20: DO J = 1,JMT
      doin20: DO I = 1,IMT
         XI = I
         YJ = J
         BIGPHI = (YJ-(JDIM+1)/2.0)*DPHI*CONV2R
         BIGLAM = (XI-(IDIM+1)/2.0)*DLAM*CONV2R
         COSPHI = COS(BIGPHI)
         SINPHI = SIN(BIGPHI)
         COSLAM = COS(BIGLAM)
         PHI    = ASIN(SINPHI*COSPH0+COSPHI*SINPH0*COSLAM)
         X      = (COSPHI*COSLAM)/(COS(PHI)*COSPH0)
         Y1     = AMIN1(1.0,(X-TAN(PHI)*TANPH0))
         Y      = ACOS(Y1)*CONV2D
         YLAT   = PHI*CONV2D
         IF (BIGLAM.LT.0.0) WLON = WLONC+Y
         IF (BIGLAM.GE.0.0) WLON = WLONC-Y
         EVLAT(I,J) = YLAT
         EVLON(I,J) = WLON
       END DO doin20
       END DO doout20
C     
C     END OF ROUTINE.
C     
      RETURN
      END
