      SUBROUTINE RDRST2D(ARR,IM,JM,LUNIT,NREC0,NREC1,NF,PRE)
C
C------------------------------------------------------------
      PARAMETER (KM=7)
C
      INCLUDE "CTLBLK.comm"
C
      REAL ARR(IM,JM),RDDUM(IM,JM)
C
      INTEGER IDATx(3)
      LOGICAL RUN,PRE
      CHARACTER LABEL*32
C------------------------------------------------------------
C*** 
C***  ARR: ARRAY NEEDED FROM RESTRT FILE
C***
C***  RDDUM: DUMMY ARRAY USED TO READ THE RESTRT FILE
C***
C***  IM,JM: HORIZONTAL DIMENSIONS OF ARR AND RDDUM
C***
C***  KM: VERTICAL DIMENSION OF RDDUM; THIS IS THE MAXIMUM
C***      NUMBER OF 2-D ARRAYS THAT OCCUR ON ANY SINGLE
C***      RECORD OF THE FILE
C***
C***  LUNIT: UNIT NUMBER OF THE RESTRT FILE BEING READ
C***
C***  NREC0: THE RECORD AFTER WHICH THE POINTER IS SET
C***         WHEN THIS ROUTINE IS ENTERED
C***
C***  NREC1: THE NUMBER OF THE RECORD FROM WHICH 
C***         WE WANT TO EXTRACT
C***
C***  NF: SINCE THERE MAY BE MORE THAN ONE 2-D ARRAY IN EACH
C***      RECORD, THIS IS THE NUMBER OF THE FIELD WE ACTUALLY
C***      WANT IN THE GIVEN RECORD; NF CANNOT EXCEED KM
C***
C***  PRE: A LOGICAL FLAG INDICATING WHETHER OR NOT TO READ
C***       THE EXTRA WORDS WHICH OCCUR ON SOME OF THE RECORDS
C***       PRECEDING THE 2-D ARRAYS
C*** 
C------------------------------------------------------------

      print *, ' *** IN RDRST2D ***'
      NDIF=NREC1-NREC0
C***
C***  GO TO START OF THE DESIRED RECORD
C***
      IF(NDIF.GT.0)THEN
        DO KOUNT=1,NDIF
          READ(LUNIT)
        ENDDO
      ELSEIF(NDIF.LT.0)THEN
        NDIF=-NDIF
        DO KOUNT=1,NDIF
          BACKSPACE LUNIT
        ENDDO
      ENDIF
C***
C***  READ THE ARRAY FROM THIS RECORD
C***
      IF(PRE)THEN
        READ(LUNIT)RUN,IDATx,IHRST,NTSD,LABEL,
     1              (((RDDUM(I,J),I=1,IM),J=1,JM),K=1,NF)
      ELSE
        READ(LUNIT)(((RDDUM(I,J),I=1,IM),J=1,JM),K=1,NF)
      ENDIF
C
      CALL EXTRACT(RDDUM, ARR )
c     DO J=JSTA,JEND
c     DO I=1,IM
c       ARR(I,J)=RDDUM(I,J)
c     ENDDO
c     ENDDO
c
      RETURN
      END
