#!/bin/bash -f

pword=`whoami`
today=`date +%Y%m%d`
dget=`./yesterday_4 $today`

SFCDIR=../../data/sfc_data

"FIRST SURFACE DATA " $dget

rm -v ${SFCDIR}/*

#ftp://ftpprd.ncep.noaa.gov/pub/data/nccf/dcom/us007003/<YYYYMMDD>/wgrbbul/

wget ftp://anonymous:${pword}@ftpprd.ncep.noaa.gov:21/pub/data/nccf/com/gfs/prod/sst.$dget/sst2dvar_grb_0.5.grib2
wget ftp://anonymous:${pword}@ftpprd.ncep.noaa.gov:21/pub/data/nccf/com/gfs/prod/gdas.$dget/gdas1.t12z.sstgrb.grib2
wget ftp://anonymous:${pword}@ftpprd.ncep.noaa.gov:21/pub/data/nccf/dcom/us007003/$dget/wgrbbul/imssnow.grb
wget ftp://anonymous:${pword}@ftpprd.ncep.noaa.gov:21/pub/data/nccf/dcom/us007003/$dget/wgrbbul/snowdepth.grb

mv -v sst2dvar_grb_0.5.grib2 ../../data/sfc_data/sst2dvar_grb_0.5.grib2
mv -v gdas1.t12z.sstgrb.grib2 ../../data/sfc_data/gdas1.t12z.sstgrb.grib2
mv -v imssnow.grb ../../data/sfc_data/imssnow.grb
mv -v snowdepth.grb ../../data/sfc_data/snowdepth.grb

ls -l ../../data/sfc_data/

./sst_deco.sh 

# Save Surface data
mkdir ${SFCDIR}/$dget
cp -v ${SFCDIR}/gdas1.t12z.sstgrb.grib2    ${SFCDIR}/$dget/gdas1.t12z.sstgrb.grib2
cp -v ${SFCDIR}/sst2dvar_grb_0.5.grib2     ${SFCDIR}/$dget/sst2dvar_grb_0.5.grib2  
cp -v ${SFCDIR}/imssnow.grb                ${SFCDIR}/$dget/imssnow.grb
cp -v ${SFCDIR}/snowdepth.grb              ${SFCDIR}/$dget/snowdepth.grb 

exit
