#!/bin/bash -x
#

if [ $# -eq 3 ] ; then

dstr=$1
dend=$2
boco=$3

else
echo "Usage: $0 start end interval" 1>&2
echo "Example: $0 00 48 06 " 1>&2
exit 1
fi


GRBDIR=../../data/grib/08110600
WOUTDIR=../../data/wout

me=$(whoami)
echo "I am $me."

echo 'remove old files!!!'
rm -fv $WOUTDIR/wbin.*
rm -fv wbin.*

dhr=$dstr

while [ $dhr -le $dend ];do


if [ $dhr -ne 0 ];then
if [ $dhr -le 9 ];then
dhr=0$dhr
fi
fi

echo '==================================================='
echo 'file in process '$GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2'
echo '==================================================='

if [ $dhr -eq 0 ];then
line=$(./wgrib2 -v $GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2' | grep "HGT" | grep "10 mb")
dcat1=`expr index "$line" =`
dcat1=`expr $dcat1 + 2`
adate=${line:$dcat1:8}
echo $adate > adate.txt
fi

touch wbin.$dhr
echo 'OPEN ' wbin.$dhr '  FILE'

for vars in HGT UGRD VGRD TMP RH; do
for levs in 100000 97500 95000 92500 90000 85000 80000 75000 70000 65000 \
             60000 55000 50000 45000 40000 35000 30000 25000 20000 15000 \
             10000  7000  5000  3000  2000  1000;do


line=$(./wgrib2 -ctl_inv $GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2' | grep "$vars 100,$levs ")

if [ -z "$line" ]; then
echo 'MISSING DATA :: VAR = '$vars' LEVEL = '$levs
else

tptp=`expr index "$line" :`
tptp=`expr $tptp - 1`
nrec=${line:0:$tptp}

./wgrib2 -d $nrec $GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2' -append -bin wbin.$dhr >> log

fi   # if [ -z "$line" ]

done # for levs 
done # for vars 

# SURFACE VARIABLES

for vars in "LAND" "PRMSL" "PRES 1," "HGT 1,"\
            "TMP 106,0,0.1"\
            "SOILW 106,0,0.1"\
            "TMP 106,0.1,0.4"\
            "SOILW 106,0.1.0.4"\
            "TMP 106,0.4,1"\
            "SOILW 106,0.4,1"\
            "TMP 106,1,2"\
            "SOILW 106,1,2"\
	    ; do

line=$(./wgrib2 -ctl_inv $GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2' | grep "$vars")

if [ -z "$line" ]; then
echo 'NO DATA FOR VAR = '$vars' LEVEL = '$levs'mb'
else

tptp=`expr index "$line" :`
tptp=`expr $tptp - 1`
nrec=${line:0:$tptp}

./wgrib2 -d $nrec $GRBDIR'/gfs.t00z.pgrbf'$dhr'.grib2' -append -bin wbin.$dhr >> log

fi   # if [ -z "$line" ]

done # for vars


echo 'DONE WITH ' wbin.$dhr '  FILE'

#mv wbin.$dhr bllspl.$dhr


ls -l wbin.$dhr

#echo '=========================================='
dhr=`expr $dhr + $boco `

done # while [ $dhr -le $dend ]

mv -v wbin.* $WOUTDIR
mv -v adate.txt $WOUTDIR
mv -v log $WOUTDIR


exit
