      SUBROUTINE CLTEND (ICLTEND)
!-----------------------------------------------------------------------
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    CLTEND      TEMPERATURE CHANGE BY CLOUD PROCESSES
C   PRGRMMR: Ferrier         ORG: W/NP22     DATE: 26 Sept 2001
C     
C ABSTRACT:
C     CLTEND gradually updates temperature tendencies from convection
C     grid-scale microphysics, and precipitation assimilation
C     
C USAGE: CALL CLTEND FROM MAIN PROGRAM EBU
C   INPUT ARGUMENT LIST:
C     ICLTEND - flag set to -1 prior to physics calls, 0 after physics
C               calls, and 1 for updating temperatures every time step
C  
C   OUTPUT ARGUMENT LIST:  NONE
C     
C   OUTPUT FILES:  NONE
C     
C   SUBPROGRAMS CALLED:  NONE
C  
C   UNIQUE: NONE
C  
C   LIBRARY: NONE
C  
C   COMMON BLOCKS: CTLBLK
C                  MASKS
C                  VRBLS
C                  C_Tadj
C   
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C   MACHINE : IBM SP
C
!-----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "mpp.h"
!-----------------------------------------------------------------------
                             L O G I C A L
     & RUN,FIRST,RESTRT,SIGMA
!
      INCLUDE "CTLBLK.comm"
      INCLUDE "MASKS.comm"
      INCLUDE "VRBLS.comm"
      INCLUDE "C_Tadj.comm"
      REAL, SAVE :: T_old (IDIM1:IDIM2,JDIM1:JDIM2,LM)
!
!-----------------------------------------------------------------------
!
      IF (ICLTEND .LT. 0) THEN
  !
  !---- Save old temperature array before CUCNVC, GSMDRIVE, & ADJPPT -----
  !
        DO L=1,LM
          DO J=MYJS,MYJE
            DO I=MYIS,MYIE
              T_old(I,J,L)=T(I,J,L)
            ENDDO
          ENDDO
        ENDDO
      ELSE IF (ICLTEND .EQ. 0) THEN
  !
  !--- Calculate temperature tendencies from CUCNVC, GSMDRIVE, & ADJPPT 
  !
        DELTPH=1./FLOAT(NPHS)
        DO L=1,LM
          DO J=MYJS,MYJE
            DO I=MYIS,MYIE
              T_adj(I,J,L)=HTM(I,J,L)*HBM2(I,J)*
     &                     DELTPH*(T(I,J,L)-T_old(I,J,L))
              T(I,J,L)=T_old(I,J,L)
            ENDDO
          ENDDO
        ENDDO
      ELSE
  !
  !--- Gradually update temperature from CUCNVC, GSMDRIVE, & ADJPPT 
  !    in small increments every dynamics time step
  !
        DO L=1,LM
          DO J=MYJS2,MYJE2
            DO I=MYIS,MYIE
              T(I,J,L)=T(I,J,L)+T_adj(I,J,L)
            ENDDO
          ENDDO
        ENDDO
      ENDIF
!-----------------------------------------------------------------------
      RETURN
      END
