

                    SUBROUTINE CONRAD(NFILE)
C
C-----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "mpif.h"
      INCLUDE "mpp.h"

C-----------------------------------------------------------------------
                        P A R A M E T E R
     1 (IX=2*IM-1,KX=LM)
C    *******************************************************************
C    *                           C O N R A D                           *
C    *    READ CO2 TRANSMISSION DATA FROM UNIT(NFILE)FOR NEW VERTICAL  *
C    *      COORDINATE TESTS      ...                                  *
C    *    THESE ARRAYS USED TO BE IN BLOCK DATA    ...K.CAMPANA-MAR 90 *
C    *******************************************************************
C
      PARAMETER (L=KX,LP1=KX+1,KP=KX+1,LP12=LP1*LP1)
      DIMENSION SGTMP(LP1,2),CO21D(L,6),CO22D(LP1,LP1,6)
      DIMENSION CO21D3(LP1,6),CO21D7(LP1,6)
      DIMENSION RSZE(3),DATA2(LP12)
      INTEGER RSZE,RSIZE
C
C                 CO2 DATA TABLES FOR USER''S VERTICAL COORDINATE
C
C   THE FOLLOWING COMMON BLOCKS CONTAIN PRETABULATED CO2 TRANSMISSION
C       FUNCTIONS, EVALUATED USING THE METHODS OF FELS AND
C       SCHWARZKOPF (1981) AND SCHWARZKOPF AND FELS (1985),
C-----  THE 2-DIMENSIONAL ARRAYS ARE
C                    CO2 TRANSMISSION FUNCTIONS AND THEIR DERIVATIVES
C        FROM 109-LEVEL LINE-BY-LINE CALCULATIONS MADE USING THE 1982
C        MCCLATCHY TAPE (12511 LINES),CONSOLIDATED,INTERPOLATED
C        TO THE NMC MRF VERTICAL COORDINATTE,AND RE-CONSOLIDATED TO A
C        200 CM-1 BANDWIDTH. THE INTERPOLATION METHOD IS DESCRIBED IN
C        SCHWARZKOPF AND FELS (J.G.R.,1985).
C-----  THE 1-DIM ARRAYS ARE
C                  CO2 TRANSMISSION FUNCTIONS AND THEIR DERIVATIVES
C          FOR TAU(I,I+1),I=1,L,
C            WHERE THE VALUES ARE NOT OBTAINED BY QUADRATURE,BUT ARE THE
C            ACTUAL TRANSMISSIVITIES,ETC,BETWEEN A PAIR OF PRESSURES.
C          THESE USED ONLY FOR NEARBY LAYER CALCULATIONS INCLUDING QH2O.
C-----  THE WEIGHTING FUNCTION GTEMP=P(K)**0.2*(1.+P(K)/30000.)**0.8/
C         1013250.,WHERE P(K)=PRESSURE,NMC MRF(NEW)  L18 DATA LEVELS FOR
C         PSTAR=1013250.
C-----  STEMP IS US STANDARD ATMOSPHERES,1976,AT DATA PRESSURE LEVELS
C        USING NMC MRF SIGMAS,WHERE PSTAR=1013.25 MB (PTZ PROGRAM)
C***COMMON CO2BD3 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 560-800 CM-1 BAND. ALSO INCLUDED
C   ARE THE STANDARD TEMPERATURES AND THE WEIGHTING FUNCTION. THESE
C   DATA ARE IN BLOCK DATA BD3:
C         CO251    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO258    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= 810 MB
C         CDT51    =  FIRST TEMPERATURE DERIVATIVE OF CO251
C         CDT58    =  FIRST TEMPERATURE DERIVATIVE OF CO258
C         C2D51    =  SECOND TEMPERATURE DERIVATIVE OF CO251
C         C2D58    =  SECOND TEMPERATURE DERIVATIVE OF CO251
C         CO2M51   =  TRANSMISSION FCTNS FOR T0 FOR ADJACENT PRESSURE
C                        LEVELS, WITH NO PRESSURE QUADRATURE. USED FOR
C                        NEARBY LAYER COMPUTATIONS. P(SFC)=1013.25 MB
C         CO2M58   =  SAME AS CO2M51,WITH P(SFC)= 810 MB
C         CDTM51   =  FIRST TEMPERATURE DERIVATIVE OF CO2M51
C         CDTM58   =  FIRST TEMPERATURE DERIVATIVE OF CO2M58
C         C2DM51   =  SECOND TEMPERATURE DERIVATIVE OF CO2M51
C         C2DM58   =  SECOND TEMPERATURE DERIVATIVE OF CO2M58
C         STEMP    =  STANDARD TEMPERATURES FOR MODEL PRESSURE LEVEL
C                        STRUCTURE WITH P(SFC)=1013.25 MB
C         GTEMP    =  WEIGHTING FUNCTION FOR MODEL PRESSURE LEVEL
C                        STRUCTURE WITH P(SFC)=1013.25 MB.
C-----       THE FOLLOWING ARE STILL IN BLOCK DATA
C         B0       =  TEMP. COEFFICIENT USED FOR CO2 TRANS. FCTN.
C                        CORRECTION FOR T(K). (SEE REF. 4 AND BD3)
C         B1       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C         B2       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C         B3       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C
      COMMON/CO2BD3/CO251(LP1,LP1),CO258(LP1,LP1),CDT51(LP1,LP1),
     1 CDT58(LP1,LP1),C2D51(LP1,LP1),C2D58(LP1,LP1),CO2M51(L),
     2 CO2M58(L),CDTM51(L),CDTM58(L),C2DM51(L),C2DM58(L),
     3 STEMP(LP1),GTEMP(LP1),B0,B1,B2,B3
C
C***COMMON CO2BD2 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 560-670 CM-1 PART OF THE 15 UM
C   CO2 BAND.  THESE DATA ARE IN BLOCK DATA BD2.
C     FOR THE 560-670 CM-1 BAND,ONLY THE (1,I) VALUES ARE USED , SINCE
C     THESE ARE USED FOR CTS COMPUTATIONS.
C         CO231    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO238    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= 810 MB
C         CDT31    =  FIRST TEMPERATURE DERIVATIVE OF CO231
C         CDT38    =  FIRST TEMPERATURE DERIVATIVE OF CO238
C         C2D31    =  SECOND TEMPERATURE DERIVATIVE OF CO231
C         C2D38    =  SECOND TEMPERATURE DERIVATIVE OF CO231
C
      COMMON / CO2BD2 / CO231(LP1),CO238(LP1),CDT31(LP1),
     1 CDT38(LP1),C2D31(LP1),C2D38(LP1)
C
C***COMMON CO2BD4 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 670-800 CM-1 PART OF THE 15 UM
C   CO2 BAND.  THESE DATA ARE IN BLOCK DATA BD4.
C         CO271    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO278    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= 810 MB
C         CDT71    =  FIRST TEMPERATURE DERIVATIVE OF CO271
C         CDT78    =  FIRST TEMPERATURE DERIVATIVE OF CO278
C         C2D71    =  SECOND TEMPERATURE DERIVATIVE OF CO271
C         C2D78    =  SECOND TEMPERATURE DERIVATIVE OF CO271
C
      COMMON / CO2BD4 / CO271(LP1),CO278(LP1),CDT71(LP1),
     1 CDT78(LP1),C2D71(LP1),C2D78(LP1)
C
C *****THE FOLLOWING NOT USED IN CURRENT VERSION OF RADIATION *******
C
C --COMMON CO2BD5 CONTAINS CO2 TRANSMISSION FUNCTIONS FOR THE 2270-
C                                  2380 PART OF THE 4.3 UM CO2 BAND.
C              THESE DATA ARE IN BLOCK DATA BD5.
C         CO211    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                        WITH P(SFC)=1013.25 MB
C         CO218    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= 810 MB
C
      COMMON / CO2BD5 / CO211(LP1),CO218(LP1)
C
C *****THE ABOVE NOT USED IN CURRENT VERSION OF RADIATION ***********
C
C====>   BEGIN HERE TO GET CONSTANTS FOR RADIATION PACKAGE

Cexpl
	open(unit=NFILE,form='unformatted',file='co2.dat')
Cexpl

      REWIND NFILE
C       READ IN PRE-COMPUTED CO2 TRANSMISSION DATA....
C....     AND CONVERT TO CYBER WORDS
      RSZE(1) = LP1
      RSZE(2) = L
      RSZE(3) = LP1*LP1
C-----------------------------------------------------------------
      RSIZE = RSZE(1)
      DO 10 KK=1,2
      IF(MYPE.EQ.0)READ(NFILE)(SGTMP(I,KK),I=1,RSIZE)
      CALL MPI_BCAST(SGTMP(1,KK),RSIZE,MPI_REAL,0,
     1               MPI_COMM_COMP,IRTN)
   10 CONTINUE
C
C-----------------------------------------------------------------
      RSIZE = RSZE(2)
      DO 15 KK=1,6
      IF(MYPE.EQ.0)READ(NFILE)(CO21D(I,KK),I=1,RSIZE)
      CALL MPI_BCAST(CO21D(1,KK),RSIZE,MPI_REAL,0,
     1               MPI_COMM_COMP,IRTN)
   15 CONTINUE
C
C-----------------------------------------------------------------
      RSIZE = RSZE(3)
      DO 20 KK=1,6
      IF(MYPE.EQ.0)READ(NFILE)(DATA2(I),I=1,RSIZE)
      CALL MPI_BCAST(DATA2(1),RSIZE,MPI_REAL,0,
     1               MPI_COMM_COMP,IRTN)
C
      N=0
      DO 5673 I1=1,LP1
      DO 5673 I2=1,LP1
      N=N+1
      CO22D(I1,I2,KK)=DATA2(N)
 5673 CONTINUE
   20 CONTINUE
C
C-----------------------------------------------------------------
      RSIZE = RSZE(1)
      DO 25 KK=1,6
      IF(MYPE.EQ.0)READ(NFILE)(CO21D3(I,KK),I=1,RSIZE)
      CALL MPI_BCAST(CO21D3(1,KK),RSIZE,MPI_REAL,0,
     1               MPI_COMM_COMP,IRTN)
   25 CONTINUE
C
C-----------------------------------------------------------------
      DO 30 KK=1,6
      IF(MYPE.EQ.0)READ(NFILE)(CO21D7(I,KK),I=1,RSIZE)
      CALL MPI_BCAST(CO21D7(1,KK),RSIZE,MPI_REAL,0,
     1               MPI_COMM_COMP,IRTN)
   30 CONTINUE
C
C-----------------------------------------------------------------
      REWIND NFILE
      DO 35 K=1,LP1
        STEMP(K) = SGTMP(K,1)
        GTEMP(K) = SGTMP(K,2)
   35 CONTINUE
      DO 40 K=1,L
        CDTM51(K) = CO21D(K,1)
        CO2M51(K) = CO21D(K,2)
        C2DM51(K) = CO21D(K,3)
        CDTM58(K) = CO21D(K,4)
        CO2M58(K) = CO21D(K,5)
        C2DM58(K) = CO21D(K,6)
   40 CONTINUE
      DO 45 J=1,LP1
       DO 45 I=1,LP1
        CDT51(I,J) = CO22D(I,J,1)
        CO251(I,J) = CO22D(I,J,2)
        C2D51(I,J) = CO22D(I,J,3)
        CDT58(I,J) = CO22D(I,J,4)
        CO258(I,J) = CO22D(I,J,5)
        C2D58(I,J) = CO22D(I,J,6)
   45 CONTINUE
      DO 50 K=1,LP1
        CDT31(K) = CO21D3(K,1)
        CO231(K) = CO21D3(K,2)
        C2D31(K) = CO21D3(K,3)
        CDT38(K) = CO21D3(K,4)
        CO238(K) = CO21D3(K,5)
        C2D38(K) = CO21D3(K,6)
   50 CONTINUE
      DO 55 K=1,LP1
        CDT71(K) = CO21D7(K,1)
        CO271(K) = CO21D7(K,2)
        C2D71(K) = CO21D7(K,3)
        CDT78(K) = CO21D7(K,4)
        CO278(K) = CO21D7(K,5)
        C2D78(K) = CO21D7(K,6)
   55 CONTINUE
      IF(MYPE.EQ.0)PRINT 66,NFILE
   66 FORMAT(1H ,'----READ CO2 TRANSMISSION FUNCTIONS FROM UNIT ',I2)
C
C......    DEFINE TABLES FOR LW RADIATION
      CALL TABLE
C
      RETURN
      END
