

      BLOCK DATA  GFDLRD

C
C....    BLOCK DATA INTIALIZES QUANTITIES NEEDED BY THE GFDL CODES.
C.... BD2,BD3,BD4,BD5,BLCKFS ALL COMBINED INTO 1 BLOCKDATA FOR FRONTEND.
C
C     BLOCK DATA BD1 GIVES INPUT DATA (TEMPS,PRESSURES,MIXING RATIOS,
C     CLOUD AMTS AND HEIGHTS) FOR TESTING THE RADIATION CODE AS A
C     STANDALONE MODEL.
      COMMON/PHYCON/AMOLWT,CSUBP,DIFFCTR,G,GRAVDR,O3DIFCTR,P0,
     *            P0XZP2,P0XZP8,P0X2,RADCON,RGAS,RGASSP,SECPDA
      COMMON/PHYCON/RATCO2MW,RATH2OMW
      COMMON/PHYCON/RADCON1
      COMMON/PHYCON/GINV,P0INV,GP0INV
      COMMON/HCON/HUNDRED,HNINETY,SIXTY,FIFTY,TEN,EIGHT,FIVE,
     *            FOUR,THREE,TWO,ONE,HAF,QUARTR,ZERO
      COMMON/HCON/H83E26,H71E26,H1E15,H1E13,H1E11,H1E8,H4E5,
     *            H165E5,H5725E4,H488E4,H1E4,H24E3,H20788E3,
     *            H2075E3,H1224E3,H5E2,H3082E2,H3E2,H2945E2,
     *            H23E2,H15E2,H35E1,H3P6,H181E1,H18E1,H2P9,H2P8,
     *            H2P5,H1P8,H1P4387,H1P4,H1P25892,HP8,HP518,
     *            HP369,HP1
      COMMON/HCON/H44871M2,H559M3,H1M3,H987M4,H285M4,H1M4,
     *            H6938M5,H394M5,H37412M5,H1439M5,H128M5,H1M5,
     *            H7M6,H4999M6,H25452M6,H1M6,H391M7,H1174M7,
     *            H8725M8,H327M8,H257M8,H1M8,H23M10,H14M10,
     *            H11M10,H1M10,H83M11,H82M11,H8M11,H77M11,
     *            H72M11,H53M11,H48M11,H44M11,H42M11,H37M11,
     *            H35M11,H32M11,H3M11,H28M11,H24M11,H23M11,
     *            H2M11,H18M11,H15M11,H14M11,H114M11,H11M11,
     *            H1M11,H96M12,H93M12,H77M12,H74M12,H65M12,
     *            H62M12,H6M12,H45M12,H44M12,H4M12,H38M12,
     *            H37M12,H3M12,H29M12,H28M12,H24M12,H21M12,
     *            H16M12,H14M12,H12M12,H8M13,H46M13,H36M13,
     *            H135M13,H12M13,H1M13,H3M14,H15M14,H14M14,
     *            H1M17,H1M18,H1M19,H1M20,H1M21,H1M22,H1M23,
     *            H1M24,H26M30,H14M30,H25M31,H21M31,H12M31,
     *            H9M32,H55M32,H45M32,H4M33,H62M34,H1M60
      COMMON/HCON/HMP575,HM13EZ,HM19EZ,HM1E1,HM181E1,HM1E2
      COMMON/HCON/H1E6,H2E6,H1M2,HMP66667,HM6666M2,HP166666,
     *            H41666M2,HMP5,HM2M2,H29316E2,H1226E1,H3116E1,
     *            H9P94,HP6,H625M2,HP228,HP60241,HM1797E1,
     *            H8121E1,H2E2,HM1EZ,H26E2,H44194M2,H1P41819
      COMMON/HCON/HP219,HP144,HP816,H69766E5,H235M3,HP26,
     *            H129M2,H75826M4,H1P082,HP805,H1386E2,
     *            H658M2,H1036E2,H2118M2,H42M2,H323M4,
     *            H67390E2,HP3795,HP5048,H102M5,H451M6
      COMMON/HCON/H16E1,HM161E1,H161E1,H3M3,H101M16,
     *            HM1597E1,H25E2,HP118666,H15M5,H3P5,H18E3,
     *            H6P08108,HMP805,HP602409,HP526315,
     *            H28571M2,H1M16
      COMMON/HCON/H3M4
      COMMON/HCON/HM8E1
      COMMON/HCON/H28E1
C-----------------------------------------------------------------------
       INCLUDE "parmeta"
C-----------------------------------------------------------------------
C     PARAMETER SETTINGS FOR THE LONGWAVE AND SHORTWAVE RADIATION CODE:
C          IMAX   =  NO. POINTS ALONG THE LAT. CIRCLE USED IN CALCS.
C          L      =  NO. VERTICAL LEVELS (ALSO LAYERS) IN MODEL
C***NOTE: THE USER NORMALLY WILL MODIFY ONLY THE IMAX AND L PARAMETERS
C          NBLW   =  NO. FREQ. BANDS FOR APPROX COMPUTATIONS. SEE
C                      BANDTA FOR DEFINITION
C          NBLX   =  NO. FREQ BANDS FOR APPROX CTS COMPUTATIONS
C          NBLY   =  NO. FREQ. BANDS FOR EXACT CTS COMPUTATIONS. SEE
C                      BDCOMB FOR DEFINITION
C          INLTE  =  NO. LEVELS USED FOR NLTE CALCS.
C          NNLTE  =  INDEX NO. OF FREQ. BAND IN NLTE CALCS.
C          NB,KO2 ARE SHORTWAVE PARAMETERS; OTHER QUANTITIES ARE DERIVED
C                    FROM THE ABOVE PARAMETERS.
      PARAMETER (L=LM)
      PARAMETER (IMAX=IM,NCOL=IMAX)
      PARAMETER (NBLW=163,NBLX=47,NBLY=15)
      PARAMETER (NBLM=NBLY-1)
      PARAMETER (LP1=L+1,LP2=L+2,LP3=L+3)
      PARAMETER (LM1=L-1,LM2=L-2,LM3=L-3)
      PARAMETER (LL=2*L,LLP1=LL+1,LLP2=LL+2,LLP3=LL+3)
      PARAMETER (LLM1=LL-1,LLM2=LL-2,LLM3=LL-3)
      PARAMETER (LP1M=LP1*LP1,LP1M1=LP1M-1)
      PARAMETER (LP1V=LP1*(1+2*L/2))
      PARAMETER (LP121=LP1*NBLY)
      PARAMETER (LL3P=3*L+2)
      PARAMETER (NB=12)
      PARAMETER (INLTE=3,INLTEP=INLTE+1,NNLTE=56)
      PARAMETER (LP1I=IMAX*LP1,LLP1I=IMAX*LLP1,LL3PI=IMAX*LL3P)
      PARAMETER (NB1=NB-1)
      PARAMETER (KO2=12)
      PARAMETER (KO21=KO2+1,KO2M=KO2-1)
C     PARAMETER SETTINGS FOR THE LONGWAVE AND SHORTWAVE RADIATION CODE:
C          IMAX   =  NO. POINTS SENT TO RADFS
C          L      =  NO. VERTICAL LEVELS (ALSO LAYERS) IN MODEL
C***NOTE: THE USER NORMALLY WILL MODIFY ONLY THE IMAX AND L PARAMETERS
C          NBLW   =  NO. FREQ. BANDS FOR APPROX COMPUTATIONS. SEE
C                      BANDTA FOR DEFINITION
C          NBLX   =  NO. FREQ BANDS FOR APPROX CTS COMPUTATIONS
C          NBLY   =  NO. FREQ. BANDS FOR EXACT CTS COMPUTATIONS. SEE
C                      BDCOMB FOR DEFINITION
C          INLTE  =  NO. LEVELS USED FOR NLTE CALCS.
C          NNLTE  =  INDEX NO. OF FREQ. BAND IN NLTE CALCS.
C          NB,KO2 ARE SHORTWAVE PARAMETERS; OTHER QUANTITIES ARE DERIVED
C                    FROM THE ABOVE PARAMETERS.
C     THIS COMMON BLOCK IS FOR THE INPUT DATA WHEN IT IS DERIVED
C  INTERNALLY. IN RADMN,THESE DATA ARE TRANSFERRED INTO THE
C  REAL INPUT COMMON BLOCK,RADISW
      COMMON/INPUT/ICH,ICM,ICT,ICB,DTEMP(LP1),PPRESS(LP1),RR(L),QQO3(L),
     1 CH,CM,CL,EMCH,EMCM,EMCL
C     COMMON/SWINPT/COCA(LP1),CWCA(LP1),CWCB(LP1),CCOSZ,CTAUDA,
C    * CSOLAR
C    COMMON BLOCK BANDTA CONTAINS RANDOM BAND PARAMETERS FOR THE LW
C    CALCULATIONS USING 10 CM-1 WIDE BANDS.THE 15 UM CO2 COMPLEX
C    IS 2 BANDS,560-670 AND 670-800 CM-1. OZONE COEFFICIENTS ARE
C    IN 3 BANDS,670-800 (14.1 UM),990-1070 AND 1070-1200 (9.6 UM).
C    THE  (NBLW) BANDS NOW INCLUDE:
C                56 BANDS, 10  CM-1 WIDE    0  -   560  CM-1
C                 2 BANDS, 15 UM COMPLEX  560  -   670  CM-1
C                                         670  -   800  CM-1
C                 3 "CONTINUUM" BANDS     800  -   900  CM-1
C                                         900  -   990  CM-1
C                                        1070  -   1200 CM-1
C                 1 BAND FOR 9.6 UM BAND  990  -   1070 CM-1
C               100 BANDS, 10 CM-1 WIDE  1200  -   2200 CM-1
C                 1 BAND FOR 4.3 UM SRC  2270  -   2380 CM-1
C    THUS NBLW PRESENTLY EQUALS    163
C    ALL BANDS ARE ARRANGED IN ORDER OF INCREASING WAVENUMBER
C
C        ARNDM   =   RANDOM "A" PARAMETER FOR (NBLW) BANDS
C        BRNDM   =   RANDOM "B" PARAMETER FOR (NBLW) BANDS
C        BETAD   =   CONTINUUM COEFFICIENTS FOR (NBLW) BANDS
C        AP,BP   =   CAPPHI COEFFICIENTS FOR (NBLW) BANDS
C        ATP,BTP =   CAPPSI COEFFICIENTS FOR (NBLW) BANDS
C        BANDLO  =   LOWEST FREQUENCY IN EACH OF (NBLW) FREQ. BANDS
C        BANDHI  =   HIGHEST FREQUENCY IN EACH OF (NBLW) FREQ. BANDS
C        AO3RND  =   RANDOM "A" PARAMETER FOR OZONE IN (3) OZONE
C                    BANDS
C        BO3RND  =   RANDOM "B" PARAMETER FOR OZONE IN (3) OZONE
C                    BANDS
C        AB15    =   THE PRODUCT ARNDM*BRNDM FOR THE TWO BANDS
C                    REPRESENTING THE 15 UM BAND COMPLEX OF CO2
C     DATA FOR ARNDM,BRNDM,AP,BP,ATP,BTP,AO3RND,BO3RND ARE OBTAINED BY
C     USING THE AFGL 1982 CATALOG. CONTINUUM COEFFICIENTS ARE FROM
C     ROBERTS (1976).
      COMMON / BANDTA / ARNDM(NBLW),BRNDM(NBLW),BETAD(NBLW),AP(NBLW),
     1                  BP(NBLW),ATP(NBLW),BTP(NBLW),BANDLO(NBLW),
     2                  BANDHI(NBLW),AO3RND(3),BO3RND(3),AB15(2)
C
C    COMMON BLOCK BDWIDE CONTAINS RANDOM BAND PARAMETERS FOR SPECIFIC
C    WIDE BANDS. AT PRESENT,THE INFORMATION CONSISTS OF 1) RANDOM
C    MODEL PARAMETERS FOR THE 15 UM BAND,560-800 CM-1; 2) THE
C    CONTINUUM COEFFICIENT FOR THE 800-990,1070-1200 CM-1 BAND
C        SPECIFICALLY:
C        AWIDE       =   RANDOM "A" PARAMETER FOR  BAND
C        BWIDE       =   RANDOM "B" PARAMETER FOR  BAND
C        BETAWD      =   CONTINUUM COEFFICIENTS FOR BAND
C        APWD,BPWD   =   CAPPHI COEFFICIENTS FOR  BAND
C        ATPWD,BTPWD =   CAPPSI COEFFICIENTS FOR BAND
C        BDLOWD      =   LOWEST FREQUENCY IN EACH  FREQ  BAND
C        BDHIWD      =   HIGHEST FREQUENCY IN EACH FREQ  BAND
C        AB15WD      =   THE PRODUCT ARNDM*BRNDM FOR THE ONE BAND
C                        REPRESENTING THE 15 UM BAND COMPLEX OF CO2
C        BETINW      =   CONT.COEFFICIENT FOR A SPECIFIED WIDE
C                        FREQ.BAND (800-990 AND 1070-1200 CM-1).
C        SKO2D       =   1./BETINW, USED IN SPA88 FOR CONT. COEFFS
C        SKC1R       =   BETAWD/BETINW, USED FOR CONT. COEFF. FOR
C                        15 UM BAND IN FST88
C        SKO3R       =   RATIO OF CONT. COEFF. FOR 9.9 UM BAND TO
C                        BETINW, USED FOR 9.6 UM CONT COEFF IN FST88
C     DATA FOR AWIDE,BWIDE,APWD,BPWD,ATPWD,BTPWD,AO3WD,BO3WD ARE
C     OBTAINED BY USING THE AFGL 1982 CATALOG. CONTINUUM COEFFICIENTS
C     ARE FROM ROBERTS (1976).
      COMMON / BDWIDE / AWIDE,BWIDE,BETAWD,
     1                  APWD,BPWD,ATPWD,BTPWD,
     2                  BDLOWD,BDHIWD,BETINW,
     3                  AB15WD,SKO2D,SKC1R,SKO3R
C
C    COMMON BLOCK BDCOMB CONTAINS RANDOM BAND PARAMETERS FOR THE LW
C    CALCULATIONS USING COMBINED WIDE FREQUENCY BANDS BETWEEN 160 AND
C    1200 CM-1,AS WELL AS THE 2270-2380 BAND FOR SOURCE CALC.
C        BANDS 1-8: COMBINED WIDE FREQUENCY BANDS FOR 160-560 CM-1
C        BANDS 9-14: FREQUENCY BANDS,AS IN BANDTA (NARROW BANDS)
C                    FOR 560-1200 CM-1
C        BAND  15:  FREQUENCY BAND 2270-2380 CM-1,USED FOR SOURCE
C                   CALCULATION ONLY
C        THUS NBLY PRESENTLY EQUALS   15
C
C        BANDS ARE ARRANGED IN ORDER OF INCREASING WAVENUMBER
C        ACOMB       =   RANDOM "A" PARAMETER FOR (NBLY) BANDS
C        BCOMB       =   RANDOM "B" PARAMETER FOR (NBLY) BANDS
C        BETACM      =   CONTINUUM COEFFICIENTS FOR (NBLY) BANDS
C        APCM,BPCM   =   CAPPHI COEFFICIENTS FOR (NBLY) BANDS
C        ATPCM,BTPCM =   CAPPSI COEFFICIENTS FOR (NBLY) BANDS
C        BDLOCM      =   LOWEST FREQUENCY IN EACH OF (NBLY) FREQ. BANDS
C        BDHICM      =   HIGHEST FREQUENCY IN EACH OF (NBLY) FREQ. BANDS
C        AO3CM       =   RANDOM "A" PARAMETER FOR OZONE IN (3) OZONE
C                        BANDS
C        BO3CM       =   RANDOM "B" PARAMETER FOR OZONE IN (3) OZONE
C                        BANDS
C        AB15CM      =   THE PRODUCT ARNDM*BRNDM FOR THE TWO BANDS
C                        REPRESENTING THE 15 UM BAND COMPLEX OF CO2
C        BETINC      =   CONT.COEFFICIENT FOR A SPECIFIED WIDE
C                        FREQ.BAND (800-990 AND 1070-1200 CM-1).
C        IBAND       =   INDEX NO OF THE 40 WIDE BANDS USED IN
C                        COMBINED WIDE BAND CALCULATIONS. IN OTHER
C                        WORDS,INDEX TELLING WHICH OF THE 40 WIDE
C                        BANDS BETWEEN 160-560 CM-1 ARE INCLUDED IN
C                        EACH OF THE FIRST 8 COMBINED WIDE BANDS
C     DATA FOR ACOMB,BCOMB,APCM,BPCM,ATPCM,BTPCM,AO3CM,BO3CM ARE
C     OBTAINED BY USING THE AFGL 1982 CATALOG. CONTINUUM COEFFICIENTS
C     ARE FROM ROBERTS (1976). IBAND INDEX VALUES ARE OBTAINED BY
C     EXPERIMENTATION.
      COMMON / BDCOMB / IBAND(40),ACOMB(NBLY),BCOMB(NBLY),
     1                  BETACM(NBLY),APCM(NBLY),BPCM(NBLY),ATPCM(NBLY),
     2                  BTPCM(NBLY),BDLOCM(NBLY),BDHICM(NBLY),BETINC,
     3                  AO3CM(3),BO3CM(3),AB15CM(2)
C
C   THE FOLLOWING COMMON BLOCKS CONTAIN PRETABULATED CO2 TRANSMISSION
C       FUNCTIONS, EVALUATED USING THE METHODS OF FELS AND
C       SCHWARZKOPF (1981) AND SCHWARZKOPF AND FELS (1985),
C***COMMON CO2BD3 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 560-800 CM-1 BAND. ALSO INCLUDED
C   ARE THE STANDARD TEMPERATURES AND THE WEIGHTING FUNCTION. THESE
C   DATA ARE IN BLOCK DATA BD3:
C         CO251    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO258    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= ^810 MB
C         CDT51    =  FIRST TEMPERATURE DERIVATIVE OF CO251
C         CDT58    =  FIRST TEMPERATURE DERIVATIVE OF CO258
C         C2D51    =  SECOND TEMPERATURE DERIVATIVE OF CO251
C         C2D58    =  SECOND TEMPERATURE DERIVATIVE OF CO251
C         CO2M51   =  TRANSMISSION FCTNS FOR T0 FOR ADJACENT PRESSURE
C                        LEVELS, WITH NO PRESSURE QUADRATURE. USED FOR
C                        NEARBY LAYER COMPUTATIONS. P(SFC)=1013.25 MB
C         CO2M58   =  SAME AS CO2M51,WITH P(SFC)= ^810 MB
C         CDTM51   =  FIRST TEMPERATURE DERIVATIVE OF CO2M51
C         CDTM58   =  FIRST TEMPERATURE DERIVATIVE OF CO2M58
C         C2DM51   =  SECOND TEMPERATURE DERIVATIVE OF CO2M51
C         C2DM58   =  SECOND TEMPERATURE DERIVATIVE OF CO2M58
C         STEMP    =  STANDARD TEMPERATURES FOR MODEL PRESSURE LEVEL
C                        STRUCTURE WITH P(SFC)=1013.25 MB
C         GTEMP    =  WEIGHTING FUNCTION FOR MODEL PRESSURE LEVEL
C                        STRUCTURE WITH P(SFC)=1013.25 MB.
C         B0       =  TEMP. COEFFICIENT USED FOR CO2 TRANS. FCTN.
C                        CORRECTION FOR T(K). (SEE REF. 4 AND BD3)
C         B1       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C         B2       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C         B3       =  TEMP. COEFFICIENT, USED ALONG WITH B0
C
      COMMON/CO2BD3/CO251(LP1,LP1),CO258(LP1,LP1),CDT51(LP1,LP1),
     1 CDT58(LP1,LP1),C2D51(LP1,LP1),C2D58(LP1,LP1),CO2M51(L),
     2 CO2M58(L),CDTM51(L),CDTM58(L),C2DM51(L),C2DM58(L),
     3 STEMP(LP1),GTEMP(LP1),B0,B1,B2,B3
C
C***COMMON CO2BD2 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 560-670 CM-1 PART OF THE 15 UM
C   CO2 BAND.  THESE DATA ARE IN BLOCK DATA BD2.
C         CO231    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO238    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= ^810 MB
C         CDT31    =  FIRST TEMPERATURE DERIVATIVE OF CO231
C         CDT38    =  FIRST TEMPERATURE DERIVATIVE OF CO238
C         C2D31    =  SECOND TEMPERATURE DERIVATIVE OF CO231
C         C2D38    =  SECOND TEMPERATURE DERIVATIVE OF CO231
C
      COMMON / CO2BD2 / CO231(LP1),CO238(LP1),CDT31(LP1),
     1 CDT38(LP1),C2D31(LP1),C2D38(LP1)
C
C***COMMON CO2BD4 CONTAINS CO2 TRANSMISSION FUNCTIONS AND TEMPERATURE
C   AND PRESSURE DERIVATIVES FOR THE 670-800 CM-1 PART OF THE 15 UM
C   CO2 BAND.  THESE DATA ARE IN BLOCK DATA BD4.
C         CO271    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO278    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= ^810 MB
C         CDT71    =  FIRST TEMPERATURE DERIVATIVE OF CO271
C         CDT78    =  FIRST TEMPERATURE DERIVATIVE OF CO278
C         C2D71    =  SECOND TEMPERATURE DERIVATIVE OF CO271
C         C2D78    =  SECOND TEMPERATURE DERIVATIVE OF CO271
C
      COMMON / CO2BD4 / CO271(LP1),CO278(LP1),CDT71(LP1),
     1 CDT78(LP1),C2D71(LP1),C2D78(LP1)
C
C***COMMON CO2BD5 CONTAINS CO2 TRANSMISSION FUNCTIONS FOR THE 2270-
C   2380 PART OF THE 4.3 UM CO2 BAND. THESE DATA ARE IN BLOCK DATA BD5.
C         CO211    =  TRANSMISSION FCTNS FOR T0 (STD. PROFILE)
C                       WITH P(SFC)=1013.25 MB
C         CO218    =  TRANSMISSION FCTNS. FOR T0 (STD. PROFILE)
C                       WITH P(SFC)= ^810 MB
C
      COMMON / CO2BD5 / CO211(LP1),CO218(LP1)
C
      COMMON/TBLTMP/ DELCM(NBLY)
C*** NOTE: THE DATA,EQUIVALENCE AND DIMENSION STATEMENTS FOR QUANTITIES
C    EQUIVALENCED TO COMMON BLOCK BANDTA DEPEND ON THE VALUE OF THE
C    PARAMETER NBLW.
C
      DIMENSION ARNDM1(64),ARNDM2(64),ARNDM3(35)
      DIMENSION BRNDM1(64),BRNDM2(64),BRNDM3(35)
      DIMENSION AP1(64),AP2(64),AP3(35)
      DIMENSION BP1(64),BP2(64),BP3(35)
      DIMENSION ATP1(64),ATP2(64),ATP3(35)
      DIMENSION BTP1(64),BTP2(64),BTP3(35)
      DIMENSION BETAD1(64),BETAD2(64),BETAD3(35)
      DIMENSION BANDL1(64),BANDL2(64),BANDL3(35)
      DIMENSION BANDH1(64),BANDH2(64),BANDH3(35)
      EQUIVALENCE (ARNDM1(1),ARNDM(1)),(ARNDM2(1),ARNDM(65)),
     1            (ARNDM3(1),ARNDM(129))
      EQUIVALENCE (BRNDM1(1),BRNDM(1)),(BRNDM2(1),BRNDM(65)),
     1            (BRNDM3(1),BRNDM(129))
      EQUIVALENCE (AP1(1),AP(1)),(AP2(1),AP(65)),
     1            (AP3(1),AP(129))
      EQUIVALENCE (BP1(1),BP(1)),(BP2(1),BP(65)),
     1            (BP3(1),BP(129))
      EQUIVALENCE (ATP1(1),ATP(1)),(ATP2(1),ATP(65)),
     1            (ATP3(1),ATP(129))
      EQUIVALENCE (BTP1(1),BTP(1)),(BTP2(1),BTP(65)),
     1            (BTP3(1),BTP(129))
      EQUIVALENCE (BETAD1(1),BETAD(1)),(BETAD2(1),BETAD(65)),
     1            (BETAD3(1),BETAD(129))
      EQUIVALENCE (BANDL1(1),BANDLO(1)),(BANDL2(1),BANDLO(65)),
     1            (BANDL3(1),BANDLO(129))
      EQUIVALENCE (BANDH1(1),BANDHI(1)),(BANDH2(1),BANDHI(65)),
     1            (BANDH3(1),BANDHI(129))
C
C***THE FOLLOWING DATA STATEMENTS ARE BAND PARAMETERS OBTAINED USING
C   THE 1982 AFGL CATALOG ON THE SPECIFIED BANDS
      DATA ARNDM1  /
     *   0.354693E+00,  0.269857E+03,  0.167062E+03,  0.201314E+04,
     *   0.964533E+03,  0.547971E+04,  0.152933E+04,  0.599429E+04,
     *   0.699329E+04,  0.856721E+04,  0.962489E+04,  0.233348E+04,
     *   0.127091E+05,  0.104383E+05,  0.504249E+04,  0.181227E+05,
     *   0.856480E+03,  0.136354E+05,  0.288635E+04,  0.170200E+04,
     *   0.209761E+05,  0.126797E+04,  0.110096E+05,  0.336436E+03,
     *   0.491663E+04,  0.863701E+04,  0.540389E+03,  0.439786E+04,
     *   0.347836E+04,  0.130557E+03,  0.465332E+04,  0.253086E+03,
     *   0.257387E+04,  0.488041E+03,  0.892991E+03,  0.117148E+04,
     *   0.125880E+03,  0.458852E+03,  0.142975E+03,  0.446355E+03,
     *   0.302887E+02,  0.394451E+03,  0.438112E+02,  0.348811E+02,
     *   0.615503E+02,  0.143165E+03,  0.103958E+02,  0.725108E+02,
     *   0.316628E+02,  0.946456E+01,  0.542675E+02,  0.351557E+02,
     *   0.301797E+02,  0.381010E+01,  0.126319E+02,  0.548010E+01,
     *   0.600199E+01,  0.640803E+00,  0.501549E-01,  0.167961E-01,
     *   0.178110E-01,  0.170166E+00,  0.273514E-01,  0.983767E+00/
      DATA ARNDM2  /
     *   0.753946E+00,  0.941763E-01,  0.970547E+00,  0.268862E+00,
     *   0.564373E+01,  0.389794E+01,  0.310955E+01,  0.128235E+01,
     *   0.196414E+01,  0.247113E+02,  0.593435E+01,  0.377552E+02,
     *   0.305173E+02,  0.852479E+01,  0.116780E+03,  0.101490E+03,
     *   0.138939E+03,  0.324228E+03,  0.683729E+02,  0.471304E+03,
     *   0.159684E+03,  0.427101E+03,  0.114716E+03,  0.106190E+04,
     *   0.294607E+03,  0.762948E+03,  0.333199E+03,  0.830645E+03,
     *   0.162512E+04,  0.525676E+03,  0.137739E+04,  0.136252E+04,
     *   0.147164E+04,  0.187196E+04,  0.131118E+04,  0.103975E+04,
     *   0.621637E+01,  0.399459E+02,  0.950648E+02,  0.943161E+03,
     *   0.526821E+03,  0.104150E+04,  0.905610E+03,  0.228142E+04,
     *   0.806270E+03,  0.691845E+03,  0.155237E+04,  0.192241E+04,
     *   0.991871E+03,  0.123907E+04,  0.457289E+02,  0.146146E+04,
     *   0.319382E+03,  0.436074E+03,  0.374214E+03,  0.778217E+03,
     *   0.140227E+03,  0.562540E+03,  0.682685E+02,  0.820292E+02,
     *   0.178779E+03,  0.186150E+03,  0.383864E+03,  0.567416E+01/
      DATA ARNDM3  /
     *   0.225129E+03,  0.473099E+01,  0.753149E+02,  0.233689E+02,
     *   0.339802E+02,  0.108855E+03,  0.380016E+02,  0.151039E+01,
     *   0.660346E+02,  0.370165E+01,  0.234169E+02,  0.440206E+00,
     *   0.615283E+01,  0.304077E+02,  0.117769E+01,  0.125248E+02,
     *   0.142652E+01,  0.241831E+00,  0.483721E+01,  0.226357E-01,
     *   0.549835E+01,  0.597067E+00,  0.404553E+00,  0.143584E+01,
     *   0.294291E+00,  0.466273E+00,  0.156048E+00,  0.656185E+00,
     *   0.172727E+00,  0.118349E+00,  0.141598E+00,  0.588581E-01,
     *   0.919409E-01,  0.155521E-01,  0.537083E-02/
      DATA BRNDM1  /
     *   0.789571E-01,  0.920256E-01,  0.696960E-01,  0.245544E+00,
     *   0.188503E+00,  0.266127E+00,  0.271371E+00,  0.330917E+00,
     *   0.190424E+00,  0.224498E+00,  0.282517E+00,  0.130675E+00,
     *   0.212579E+00,  0.227298E+00,  0.138585E+00,  0.187106E+00,
     *   0.194527E+00,  0.177034E+00,  0.115902E+00,  0.118499E+00,
     *   0.142848E+00,  0.216869E+00,  0.149848E+00,  0.971585E-01,
     *   0.151532E+00,  0.865628E-01,  0.764246E-01,  0.100035E+00,
     *   0.171133E+00,  0.134737E+00,  0.105173E+00,  0.860832E-01,
     *   0.148921E+00,  0.869234E-01,  0.106018E+00,  0.184865E+00,
     *   0.767454E-01,  0.108981E+00,  0.123094E+00,  0.177287E+00,
     *   0.848146E-01,  0.119356E+00,  0.133829E+00,  0.954505E-01,
     *   0.155405E+00,  0.164167E+00,  0.161390E+00,  0.113287E+00,
     *   0.714720E-01,  0.741598E-01,  0.719590E-01,  0.140616E+00,
     *   0.355356E-01,  0.832779E-01,  0.128680E+00,  0.983013E-01,
     *   0.629660E-01,  0.643346E-01,  0.717082E-01,  0.629730E-01,
     *   0.875182E-01,  0.857907E-01,  0.358808E+00,  0.178840E+00/
      DATA BRNDM2  /
     *   0.254265E+00,  0.297901E+00,  0.153916E+00,  0.537774E+00,
     *   0.267906E+00,  0.104254E+00,  0.400723E+00,  0.389670E+00,
     *   0.263701E+00,  0.338116E+00,  0.351528E+00,  0.267764E+00,
     *   0.186419E+00,  0.238237E+00,  0.210408E+00,  0.176869E+00,
     *   0.114715E+00,  0.173299E+00,  0.967770E-01,  0.172565E+00,
     *   0.162085E+00,  0.157782E+00,  0.886832E-01,  0.242999E+00,
     *   0.760298E-01,  0.164248E+00,  0.221428E+00,  0.166799E+00,
     *   0.312514E+00,  0.380600E+00,  0.353828E+00,  0.269500E+00,
     *   0.254759E+00,  0.285408E+00,  0.159764E+00,  0.721058E-01,
     *   0.170528E+00,  0.231595E+00,  0.307184E+00,  0.564136E-01,
     *   0.159884E+00,  0.147907E+00,  0.185666E+00,  0.183567E+00,
     *   0.182482E+00,  0.230650E+00,  0.175348E+00,  0.195978E+00,
     *   0.255323E+00,  0.198517E+00,  0.195500E+00,  0.208356E+00,
     *   0.309603E+00,  0.112011E+00,  0.102570E+00,  0.128276E+00,
     *   0.168100E+00,  0.177836E+00,  0.105533E+00,  0.903330E-01,
     *   0.126036E+00,  0.101430E+00,  0.124546E+00,  0.221406E+00/
      DATA BRNDM3  /
     *   0.137509E+00,  0.911365E-01,  0.724508E-01,  0.795788E-01,
     *   0.137411E+00,  0.549175E-01,  0.787714E-01,  0.165544E+00,
     *   0.136484E+00,  0.146729E+00,  0.820496E-01,  0.846211E-01,
     *   0.785821E-01,  0.122527E+00,  0.125359E+00,  0.101589E+00,
     *   0.155756E+00,  0.189239E+00,  0.999086E-01,  0.480993E+00,
     *   0.100233E+00,  0.153754E+00,  0.130780E+00,  0.136136E+00,
     *   0.159353E+00,  0.156634E+00,  0.272265E+00,  0.186874E+00,
     *   0.192090E+00,  0.135397E+00,  0.131497E+00,  0.127463E+00,
     *   0.227233E+00,  0.190562E+00,  0.214005E+00/
      DATA AP1     /
     *  -0.675950E-02, -0.909459E-02, -0.800214E-02, -0.658673E-02,
     *  -0.245580E-02, -0.710464E-02, -0.205565E-02, -0.446529E-02,
     *  -0.440265E-02, -0.593625E-02, -0.201913E-02, -0.349169E-02,
     *  -0.209324E-02, -0.127980E-02, -0.388007E-02, -0.140542E-02,
     *   0.518346E-02, -0.159375E-02,  0.250508E-02,  0.132182E-01,
     *  -0.903779E-03,  0.110959E-01,  0.924528E-03,  0.207428E-01,
     *   0.364166E-02,  0.365229E-02,  0.884367E-02,  0.617260E-02,
     *   0.701340E-02,  0.184265E-01,  0.992822E-02,  0.908582E-02,
     *   0.106581E-01,  0.276268E-02,  0.158414E-01,  0.145747E-01,
     *   0.453080E-02,  0.214767E-01,  0.553895E-02,  0.195031E-01,
     *   0.237016E-01,  0.112371E-01,  0.275977E-01,  0.188833E-01,
     *   0.131079E-01,  0.130019E-01,  0.385122E-01,  0.111768E-01,
     *   0.622620E-02,  0.194397E-01,  0.134360E-01,  0.207829E-01,
     *   0.147960E-01,  0.744479E-02,  0.107564E-01,  0.181562E-01,
     *   0.170062E-01,  0.233303E-01,  0.256735E-01,  0.274745E-01,
     *   0.279259E-01,  0.197002E-01,  0.140268E-01,  0.185933E-01/
      DATA AP2     /
     *   0.169525E-01,  0.214410E-01,  0.136577E-01,  0.169510E-01,
     *   0.173025E-01,  0.958346E-02,  0.255024E-01,  0.308943E-01,
     *   0.196031E-01,  0.183608E-01,  0.149419E-01,  0.206358E-01,
     *   0.140654E-01,  0.172797E-01,  0.145470E-01,  0.982987E-02,
     *   0.116695E-01,  0.811333E-02,  0.965823E-02,  0.649977E-02,
     *   0.462192E-02,  0.545929E-02,  0.680407E-02,  0.291235E-02,
     *  -0.974773E-03,  0.341591E-02,  0.376198E-02,  0.770610E-03,
     *  -0.940864E-04,  0.514532E-02,  0.232371E-02, -0.177741E-02,
     *  -0.374892E-03, -0.370485E-03, -0.221435E-02, -0.490000E-02,
     *   0.588664E-02,  0.931411E-03, -0.456043E-03, -0.545576E-02,
     *  -0.421136E-02, -0.353742E-02, -0.174276E-02, -0.361246E-02,
     *  -0.337822E-02, -0.867030E-03, -0.118001E-02, -0.222405E-02,
     *  -0.725144E-03,  0.118483E-02,  0.995087E-02,  0.273812E-03,
     *   0.417298E-02,  0.764294E-02,  0.631568E-02, -0.213528E-02,
     *   0.746130E-02,  0.110337E-02,  0.153157E-01,  0.504532E-02,
     *   0.406047E-02,  0.192895E-02,  0.202058E-02,  0.126420E-01/
      DATA AP3     /
     *   0.310028E-02,  0.214779E-01,  0.560165E-02,  0.661070E-02,
     *   0.694966E-02,  0.539194E-02,  0.103745E-01,  0.180150E-01,
     *   0.747133E-02,  0.114927E-01,  0.115213E-01,  0.160709E-02,
     *   0.154278E-01,  0.112067E-01,  0.148690E-01,  0.154442E-01,
     *   0.123977E-01,  0.237539E-01,  0.162820E-01,  0.269484E-01,
     *   0.178081E-01,  0.143221E-01,  0.262468E-01,  0.217065E-01,
     *   0.107083E-01,  0.281220E-01,  0.115565E-01,  0.231244E-01,
     *   0.225197E-01,  0.178624E-01,  0.327708E-01,  0.116657E-01,
     *   0.277452E-01,  0.301647E-01,  0.349782E-01/
      DATA BP1     /
     *   0.717848E-05,  0.169280E-04,  0.126710E-04,  0.758397E-05,
     *  -0.533900E-05,  0.143490E-04, -0.595854E-05,  0.296465E-05,
     *   0.323446E-05,  0.115359E-04, -0.692861E-05,  0.131477E-04,
     *  -0.624945E-05, -0.756955E-06,  0.107458E-05, -0.159796E-05,
     *  -0.290529E-04, -0.170918E-05, -0.193934E-04, -0.707209E-04,
     *  -0.148154E-04, -0.383162E-04, -0.186050E-04, -0.951796E-04,
     *  -0.210944E-04, -0.330590E-04, -0.373087E-04, -0.408972E-04,
     *  -0.396759E-04, -0.827756E-04, -0.573773E-04, -0.325384E-04,
     *  -0.449411E-04, -0.271450E-04, -0.752791E-04, -0.549699E-04,
     *  -0.225655E-04, -0.102034E-03, -0.740322E-05, -0.668846E-04,
     *  -0.106063E-03, -0.304840E-04, -0.796023E-04,  0.504880E-04,
     *   0.486384E-04, -0.531946E-04, -0.147771E-03, -0.406785E-04,
     *   0.615750E-05, -0.486264E-04, -0.419335E-04, -0.819467E-04,
     *  -0.709498E-04,  0.326984E-05, -0.369743E-04, -0.526848E-04,
     *  -0.550050E-04, -0.684057E-04, -0.447093E-04, -0.778390E-04,
     *  -0.982953E-04, -0.772497E-04, -0.119430E-05, -0.655187E-04/
      DATA BP2     /
     *  -0.339078E-04,  0.716657E-04, -0.335893E-04,  0.220239E-04,
     *  -0.491012E-04, -0.393325E-04, -0.626461E-04, -0.795479E-04,
     *  -0.599181E-04, -0.578153E-04, -0.597559E-05, -0.866750E-04,
     *  -0.486783E-04, -0.580912E-04, -0.647368E-04, -0.350643E-04,
     *  -0.566635E-04, -0.385738E-04, -0.463782E-04, -0.321485E-04,
     *  -0.177300E-04, -0.250201E-04, -0.365492E-04, -0.165218E-04,
     *  -0.649177E-05, -0.218458E-04, -0.984604E-05, -0.120034E-04,
     *  -0.110119E-06, -0.164405E-04, -0.141396E-04,  0.315347E-05,
     *  -0.141544E-05, -0.297320E-05, -0.216248E-05,  0.839264E-05,
     *  -0.178197E-04, -0.106225E-04, -0.468195E-05,  0.997043E-05,
     *   0.679709E-05,  0.324610E-05, -0.367325E-05,  0.671058E-05,
     *   0.509293E-05, -0.437392E-05, -0.787922E-06, -0.271503E-06,
     *  -0.437940E-05, -0.128205E-04, -0.417830E-04, -0.561134E-05,
     *  -0.209940E-04, -0.414366E-04, -0.289765E-04,  0.680406E-06,
     *  -0.558644E-05, -0.530395E-05, -0.622242E-04, -0.159979E-05,
     *  -0.140286E-04, -0.128463E-04, -0.929499E-05, -0.327886E-04/
      DATA BP3     /
     *  -0.189353E-04, -0.737589E-04, -0.323471E-04, -0.272502E-04,
     *  -0.321731E-04, -0.326958E-04, -0.509157E-04, -0.681890E-04,
     *  -0.362182E-04, -0.354405E-04, -0.578392E-04,  0.238627E-05,
     *  -0.709028E-04, -0.518717E-04, -0.491859E-04, -0.718017E-04,
     *  -0.418978E-05, -0.940819E-04, -0.630375E-04, -0.478469E-04,
     *  -0.751896E-04, -0.267113E-04, -0.109019E-03, -0.890983E-04,
     *  -0.177301E-04, -0.120216E-03,  0.220464E-04, -0.734277E-04,
     *  -0.868068E-04, -0.652319E-04, -0.136982E-03, -0.279933E-06,
     *  -0.791824E-04, -0.111781E-03, -0.748263E-04/
      DATA ATP1    /
     *  -0.722782E-02, -0.901531E-02, -0.821263E-02, -0.808024E-02,
     *  -0.320169E-02, -0.661305E-02, -0.287272E-02, -0.486143E-02,
     *  -0.242857E-02, -0.530288E-02, -0.146813E-02, -0.566474E-03,
     *  -0.102192E-02,  0.300643E-03, -0.331655E-02,  0.648220E-03,
     *   0.552446E-02, -0.933046E-03,  0.205703E-02,  0.130638E-01,
     *  -0.229828E-02,  0.715648E-02,  0.444446E-03,  0.193500E-01,
     *   0.364119E-02,  0.252713E-02,  0.102420E-01,  0.494224E-02,
     *   0.584934E-02,  0.146255E-01,  0.921986E-02,  0.768012E-02,
     *   0.916105E-02,  0.276223E-02,  0.125245E-01,  0.131146E-01,
     *   0.793016E-02,  0.201536E-01,  0.658631E-02,  0.171711E-01,
     *   0.228470E-01,  0.131306E-01,  0.226658E-01,  0.176086E-01,
     *   0.149987E-01,  0.143060E-01,  0.313189E-01,  0.117070E-01,
     *   0.133522E-01,  0.244259E-01,  0.148393E-01,  0.223982E-01,
     *   0.151792E-01,  0.180474E-01,  0.106299E-01,  0.191016E-01,
     *   0.171776E-01,  0.229724E-01,  0.275530E-01,  0.302731E-01,
     *   0.281662E-01,  0.199525E-01,  0.192588E-01,  0.173220E-01/
      DATA ATP2    /
     *   0.195220E-01,  0.169371E-01,  0.193212E-01,  0.145558E-01,
     *   0.189654E-01,  0.122030E-01,  0.186206E-01,  0.228842E-01,
     *   0.139343E-01,  0.164006E-01,  0.137276E-01,  0.154005E-01,
     *   0.114575E-01,  0.129956E-01,  0.115305E-01,  0.929260E-02,
     *   0.106359E-01,  0.771623E-02,  0.106075E-01,  0.597630E-02,
     *   0.493960E-02,  0.532554E-02,  0.646175E-02,  0.302693E-02,
     *   0.150899E-02,  0.310333E-02,  0.533734E-02,  0.239094E-03,
     *   0.356782E-02,  0.707574E-02,  0.215758E-02, -0.527589E-03,
     *   0.643893E-03, -0.101916E-02, -0.383336E-02, -0.445966E-02,
     *   0.880190E-02,  0.245662E-02, -0.560923E-03, -0.582201E-02,
     *  -0.323233E-02, -0.454197E-02, -0.240905E-02, -0.343160E-02,
     *  -0.335156E-02, -0.623846E-03,  0.393633E-03, -0.271593E-02,
     *  -0.675874E-03,  0.920642E-03,  0.102168E-01, -0.250663E-03,
     *   0.437126E-02,  0.767434E-02,  0.569931E-02, -0.929326E-03,
     *   0.659414E-02,  0.280687E-02,  0.127614E-01,  0.780789E-02,
     *   0.374807E-02,  0.274288E-02,  0.534940E-02,  0.104349E-01/
       DATA ATP3   /
     *   0.294379E-02,  0.177846E-01,  0.523249E-02,  0.125339E-01,
     *   0.548538E-02,  0.577403E-02,  0.101532E-01,  0.170375E-01,
     *   0.758396E-02,  0.113402E-01,  0.106960E-01,  0.107782E-01,
     *   0.136148E-01,  0.992064E-02,  0.167276E-01,  0.149603E-01,
     *   0.136259E-01,  0.234521E-01,  0.166806E-01,  0.298505E-01,
     *   0.167592E-01,  0.186679E-01,  0.233062E-01,  0.228467E-01,
     *   0.128947E-01,  0.293979E-01,  0.219815E-01,  0.220663E-01,
     *   0.272710E-01,  0.237139E-01,  0.331743E-01,  0.208799E-01,
     *   0.281472E-01,  0.318440E-01,  0.370962E-01/
      DATA BTP1    /
     *   0.149748E-04,  0.188007E-04,  0.196530E-04,  0.124747E-04,
     *  -0.215751E-07,  0.128357E-04, -0.265798E-05,  0.606262E-05,
     *   0.287668E-05,  0.974612E-05, -0.833451E-05,  0.584410E-05,
     *  -0.452879E-05, -0.782537E-05,  0.786165E-05, -0.768351E-05,
     *  -0.196168E-04,  0.177297E-06, -0.129258E-04, -0.642798E-04,
     *  -0.986297E-05, -0.257145E-04, -0.141996E-04, -0.865089E-04,
     *  -0.141691E-04, -0.272578E-04, -0.295198E-04, -0.308878E-04,
     *  -0.313193E-04, -0.669272E-04, -0.475777E-04, -0.221332E-04,
     *  -0.419930E-04, -0.102519E-04, -0.590184E-04, -0.574771E-04,
     *  -0.240809E-04, -0.913994E-04, -0.908886E-05, -0.721074E-04,
     *  -0.902837E-04, -0.447582E-04, -0.664544E-04, -0.143150E-04,
     *  -0.511866E-05, -0.559352E-04, -0.104734E-03, -0.305206E-04,
     *   0.103303E-04, -0.613019E-04, -0.320040E-04, -0.738909E-04,
     *  -0.388263E-04,  0.306515E-04, -0.352214E-04, -0.253940E-04,
     *  -0.521369E-04, -0.746260E-04, -0.744124E-04, -0.881905E-04,
     *  -0.933645E-04, -0.664045E-04, -0.570712E-05, -0.566312E-04/
      DATA BTP2    /
     *  -0.364967E-04,  0.393501E-06, -0.234050E-04, -0.141317E-04,
     *  -0.525480E-04, -0.172241E-04, -0.410843E-04, -0.358348E-04,
     *  -0.256168E-04, -0.509482E-04, -0.180570E-04, -0.555356E-04,
     *  -0.271464E-04, -0.274040E-04, -0.480889E-04, -0.275751E-04,
     *  -0.415681E-04, -0.383770E-04, -0.280139E-04, -0.287919E-04,
     *  -0.125865E-04, -0.265467E-04, -0.172765E-04, -0.164611E-04,
     *   0.189183E-04, -0.171219E-04, -0.132766E-04, -0.344611E-05,
     *  -0.442832E-05, -0.185779E-04, -0.139755E-04,  0.168083E-05,
     *  -0.395287E-05, -0.297871E-05,  0.434383E-05,  0.131741E-04,
     *  -0.192637E-04, -0.549551E-05,  0.122553E-05,  0.204627E-04,
     *   0.154027E-04,  0.953462E-05,  0.131125E-05,  0.732839E-05,
     *   0.755405E-05, -0.305552E-05, -0.434858E-05,  0.308409E-05,
     *  -0.164787E-05, -0.818533E-05, -0.355041E-04, -0.504696E-05,
     *  -0.229022E-04, -0.356891E-04, -0.230346E-04,  0.518835E-05,
     *  -0.160187E-04, -0.104617E-04, -0.464754E-04, -0.115807E-04,
     *  -0.130230E-04, -0.603491E-05, -0.125324E-04, -0.165516E-04/
      DATA BTP3    /
     *  -0.991679E-05, -0.529432E-04, -0.200199E-04, -0.181977E-04,
     *  -0.220940E-04, -0.204483E-04, -0.432584E-04, -0.449109E-04,
     *  -0.247305E-04, -0.174253E-04, -0.484446E-04,  0.354150E-04,
     *  -0.425581E-04, -0.406562E-04, -0.505495E-04, -0.651856E-04,
     *  -0.153953E-04, -0.894294E-04, -0.616551E-04, -0.846504E-04,
     *  -0.699414E-04, -0.376203E-04, -0.940985E-04, -0.753050E-04,
     *  -0.183710E-04, -0.123907E-03, -0.279347E-04, -0.736381E-04,
     *  -0.103588E-03, -0.754117E-04, -0.140991E-03, -0.366687E-04,
     *  -0.927785E-04, -0.125321E-03, -0.115290E-03/
      DATA BETAD1  /
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.234879E+03,  0.217419E+03,  0.201281E+03,  0.186364E+03,
     *   0.172576E+03,  0.159831E+03,  0.148051E+03,  0.137163E+03,
     *   0.127099E+03,  0.117796E+03,  0.109197E+03,  0.101249E+03,
     *   0.939031E+02,  0.871127E+02,  0.808363E+02,  0.750349E+02,
     *   0.497489E+02,  0.221212E+02,  0.113124E+02,  0.754174E+01,
     *   0.589554E+01,  0.495227E+01,  0.000000E+00,  0.000000E+00/
      DATA BETAD2  /
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00/
      DATA BETAD3  /
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.000000E+00,  0.000000E+00,  0.000000E+00/
      DATA BANDL1 /
     *   0.000000E+00,  0.100000E+02,  0.200000E+02,  0.300000E+02,
     *   0.400000E+02,  0.500000E+02,  0.600000E+02,  0.700000E+02,
     *   0.800000E+02,  0.900000E+02,  0.100000E+03,  0.110000E+03,
     *   0.120000E+03,  0.130000E+03,  0.140000E+03,  0.150000E+03,
     *   0.160000E+03,  0.170000E+03,  0.180000E+03,  0.190000E+03,
     *   0.200000E+03,  0.210000E+03,  0.220000E+03,  0.230000E+03,
     *   0.240000E+03,  0.250000E+03,  0.260000E+03,  0.270000E+03,
     *   0.280000E+03,  0.290000E+03,  0.300000E+03,  0.310000E+03,
     *   0.320000E+03,  0.330000E+03,  0.340000E+03,  0.350000E+03,
     *   0.360000E+03,  0.370000E+03,  0.380000E+03,  0.390000E+03,
     *   0.400000E+03,  0.410000E+03,  0.420000E+03,  0.430000E+03,
     *   0.440000E+03,  0.450000E+03,  0.460000E+03,  0.470000E+03,
     *   0.480000E+03,  0.490000E+03,  0.500000E+03,  0.510000E+03,
     *   0.520000E+03,  0.530000E+03,  0.540000E+03,  0.550000E+03,
     *   0.560000E+03,  0.670000E+03,  0.800000E+03,  0.900000E+03,
     *   0.990000E+03,  0.107000E+04,  0.120000E+04,  0.121000E+04/
      DATA BANDL2 /
     *   0.122000E+04,  0.123000E+04,  0.124000E+04,  0.125000E+04,
     *   0.126000E+04,  0.127000E+04,  0.128000E+04,  0.129000E+04,
     *   0.130000E+04,  0.131000E+04,  0.132000E+04,  0.133000E+04,
     *   0.134000E+04,  0.135000E+04,  0.136000E+04,  0.137000E+04,
     *   0.138000E+04,  0.139000E+04,  0.140000E+04,  0.141000E+04,
     *   0.142000E+04,  0.143000E+04,  0.144000E+04,  0.145000E+04,
     *   0.146000E+04,  0.147000E+04,  0.148000E+04,  0.149000E+04,
     *   0.150000E+04,  0.151000E+04,  0.152000E+04,  0.153000E+04,
     *   0.154000E+04,  0.155000E+04,  0.156000E+04,  0.157000E+04,
     *   0.158000E+04,  0.159000E+04,  0.160000E+04,  0.161000E+04,
     *   0.162000E+04,  0.163000E+04,  0.164000E+04,  0.165000E+04,
     *   0.166000E+04,  0.167000E+04,  0.168000E+04,  0.169000E+04,
     *   0.170000E+04,  0.171000E+04,  0.172000E+04,  0.173000E+04,
     *   0.174000E+04,  0.175000E+04,  0.176000E+04,  0.177000E+04,
     *   0.178000E+04,  0.179000E+04,  0.180000E+04,  0.181000E+04,
     *   0.182000E+04,  0.183000E+04,  0.184000E+04,  0.185000E+04/
      DATA BANDL3 /
     *   0.186000E+04,  0.187000E+04,  0.188000E+04,  0.189000E+04,
     *   0.190000E+04,  0.191000E+04,  0.192000E+04,  0.193000E+04,
     *   0.194000E+04,  0.195000E+04,  0.196000E+04,  0.197000E+04,
     *   0.198000E+04,  0.199000E+04,  0.200000E+04,  0.201000E+04,
     *   0.202000E+04,  0.203000E+04,  0.204000E+04,  0.205000E+04,
     *   0.206000E+04,  0.207000E+04,  0.208000E+04,  0.209000E+04,
     *   0.210000E+04,  0.211000E+04,  0.212000E+04,  0.213000E+04,
     *   0.214000E+04,  0.215000E+04,  0.216000E+04,  0.217000E+04,
     *   0.218000E+04,  0.219000E+04,  0.227000E+04/
      DATA BANDH1 /
     *   0.100000E+02,  0.200000E+02,  0.300000E+02,  0.400000E+02,
     *   0.500000E+02,  0.600000E+02,  0.700000E+02,  0.800000E+02,
     *   0.900000E+02,  0.100000E+03,  0.110000E+03,  0.120000E+03,
     *   0.130000E+03,  0.140000E+03,  0.150000E+03,  0.160000E+03,
     *   0.170000E+03,  0.180000E+03,  0.190000E+03,  0.200000E+03,
     *   0.210000E+03,  0.220000E+03,  0.230000E+03,  0.240000E+03,
     *   0.250000E+03,  0.260000E+03,  0.270000E+03,  0.280000E+03,
     *   0.290000E+03,  0.300000E+03,  0.310000E+03,  0.320000E+03,
     *   0.330000E+03,  0.340000E+03,  0.350000E+03,  0.360000E+03,
     *   0.370000E+03,  0.380000E+03,  0.390000E+03,  0.400000E+03,
     *   0.410000E+03,  0.420000E+03,  0.430000E+03,  0.440000E+03,
     *   0.450000E+03,  0.460000E+03,  0.470000E+03,  0.480000E+03,
     *   0.490000E+03,  0.500000E+03,  0.510000E+03,  0.520000E+03,
     *   0.530000E+03,  0.540000E+03,  0.550000E+03,  0.560000E+03,
     *   0.670000E+03,  0.800000E+03,  0.900000E+03,  0.990000E+03,
     *   0.107000E+04,  0.120000E+04,  0.121000E+04,  0.122000E+04/
      DATA BANDH2 /
     *   0.123000E+04,  0.124000E+04,  0.125000E+04,  0.126000E+04,
     *   0.127000E+04,  0.128000E+04,  0.129000E+04,  0.130000E+04,
     *   0.131000E+04,  0.132000E+04,  0.133000E+04,  0.134000E+04,
     *   0.135000E+04,  0.136000E+04,  0.137000E+04,  0.138000E+04,
     *   0.139000E+04,  0.140000E+04,  0.141000E+04,  0.142000E+04,
     *   0.143000E+04,  0.144000E+04,  0.145000E+04,  0.146000E+04,
     *   0.147000E+04,  0.148000E+04,  0.149000E+04,  0.150000E+04,
     *   0.151000E+04,  0.152000E+04,  0.153000E+04,  0.154000E+04,
     *   0.155000E+04,  0.156000E+04,  0.157000E+04,  0.158000E+04,
     *   0.159000E+04,  0.160000E+04,  0.161000E+04,  0.162000E+04,
     *   0.163000E+04,  0.164000E+04,  0.165000E+04,  0.166000E+04,
     *   0.167000E+04,  0.168000E+04,  0.169000E+04,  0.170000E+04,
     *   0.171000E+04,  0.172000E+04,  0.173000E+04,  0.174000E+04,
     *   0.175000E+04,  0.176000E+04,  0.177000E+04,  0.178000E+04,
     *   0.179000E+04,  0.180000E+04,  0.181000E+04,  0.182000E+04,
     *   0.183000E+04,  0.184000E+04,  0.185000E+04,  0.186000E+04/
      DATA BANDH3 /
     *   0.187000E+04,  0.188000E+04,  0.189000E+04,  0.190000E+04,
     *   0.191000E+04,  0.192000E+04,  0.193000E+04,  0.194000E+04,
     *   0.195000E+04,  0.196000E+04,  0.197000E+04,  0.198000E+04,
     *   0.199000E+04,  0.200000E+04,  0.201000E+04,  0.202000E+04,
     *   0.203000E+04,  0.204000E+04,  0.205000E+04,  0.206000E+04,
     *   0.207000E+04,  0.208000E+04,  0.209000E+04,  0.210000E+04,
     *   0.211000E+04,  0.212000E+04,  0.213000E+04,  0.214000E+04,
     *   0.215000E+04,  0.216000E+04,  0.217000E+04,  0.218000E+04,
     *   0.219000E+04,  0.220000E+04,  0.238000E+04/
      DATA AO3RND /
     *   0.543368E+02,  0.234676E+04,  0.384881E+02/
      DATA BO3RND /
     *   0.526064E+01,  0.922424E+01,  0.496515E+01/
      DATA AWIDE  /
     *   0.309801E+01/
      DATA BWIDE  /
     *   0.495357E-01/
      DATA APWD   /
     *   0.177115E-01/
      DATA BPWD   /
     *  -0.545226E-04/
      DATA ATPWD  /
     *   0.187967E-01/
      DATA BTPWD  /
     *  -0.567449E-04/
      DATA BETAWD /
     *   0.347839E+02/
      DATA BETINW /
     *   0.766811E+01/
      DATA BDLOWD /
     *   0.560000E+03/
      DATA BDHIWD /
     *   0.800000E+03/
      DATA ACOMB  /
     *   0.152070E+05,  0.332194E+04,  0.527177E+03,  0.163124E+03,
     *   0.268808E+03,  0.534591E+02,  0.268071E+02,  0.123133E+02,
     *   0.600199E+01,  0.640803E+00,  0.501549E-01,  0.167961E-01,
     *   0.178110E-01,  0.170166E+00,  0.537083E-02/
      DATA BCOMB  /
     *   0.152538E+00,  0.118677E+00,  0.103660E+00,  0.100119E+00,
     *   0.127518E+00,  0.118409E+00,  0.904061E-01,  0.642011E-01,
     *   0.629660E-01,  0.643346E-01,  0.717082E-01,  0.629730E-01,
     *   0.875182E-01,  0.857907E-01,  0.214005E+00/
      DATA APCM   /
     *  -0.671879E-03,  0.654345E-02,  0.143657E-01,  0.923593E-02,
     *   0.117022E-01,  0.159596E-01,  0.181600E-01,  0.145013E-01,
     *   0.170062E-01,  0.233303E-01,  0.256735E-01,  0.274745E-01,
     *   0.279259E-01,  0.197002E-01,  0.349782E-01/
      DATA BPCM   /
     *  -0.113520E-04, -0.323965E-04, -0.448417E-04, -0.230779E-04,
     *  -0.361981E-04, -0.145117E-04,  0.198349E-04, -0.486529E-04,
     *  -0.550050E-04, -0.684057E-04, -0.447093E-04, -0.778390E-04,
     *  -0.982953E-04, -0.772497E-04, -0.748263E-04/
      DATA ATPCM  /
     *  -0.106346E-02,  0.641531E-02,  0.137362E-01,  0.922513E-02,
     *   0.136162E-01,  0.169791E-01,  0.206959E-01,  0.166223E-01,
     *   0.171776E-01,  0.229724E-01,  0.275530E-01,  0.302731E-01,
     *   0.281662E-01,  0.199525E-01,  0.370962E-01/
      DATA BTPCM  /
     *  -0.735731E-05, -0.294149E-04, -0.505592E-04, -0.280894E-04,
     *  -0.492972E-04, -0.341508E-04, -0.362947E-04, -0.250487E-04,
     *  -0.521369E-04, -0.746260E-04, -0.744124E-04, -0.881905E-04,
     *  -0.933645E-04, -0.664045E-04, -0.115290E-03/
      DATA BETACM /
     *   0.000000E+00,  0.000000E+00,  0.000000E+00,  0.000000E+00,
     *   0.188625E+03,  0.144293E+03,  0.174098E+03,  0.909366E+02,
     *   0.497489E+02,  0.221212E+02,  0.113124E+02,  0.754174E+01,
     *   0.589554E+01,  0.495227E+01,  0.000000E+00/
      DATA DELCM  /
     *   0.300000E+02,  0.110000E+03,  0.600000E+02,  0.400000E+02,
     *   0.200000E+02,  0.500000E+02,  0.400000E+02,  0.500000E+02,
     *   0.110000E+03,  0.130000E+03,  0.100000E+03,  0.900000E+02,
     *   0.800000E+02,  0.130000E+03,  0.110000E+03/
      DATA IBAND  /
     *    2,   1,   2,   2,   1,   2,   1,   3,   2,   2,
     *    3,   2,   2,   4,   2,   4,   2,   3,   3,   2,
     *    4,   3,   4,   3,   7,   5,   6,   7,   6,   5,
     *    7,   6,   7,   8,   6,   6,   8,   8,   8,   8/
      DATA CH,CM,CL,ICH,ICM,ICT,ICB/.159,.07,.269,5,11,12,14/
      DATA EMCH,EMCM,EMCL/1.,1.,1./
C     DATA COCA/0.,.210,.540,.660,.100,14*0./
C     DATA CWCA/0.,.190,.460,.500,0.,14*0./
C     DATA CWCB/0.,.040,.200,.300,0.,14*0./
C***THE FOLLOWING DATA ARE LEVEL-INDEPENDENT
CCCCC DATA RCO2/3.3E-4/
      DATA G/980.665/
C     DATA CTAUDA/.5/
C     DATA CSOLAR/1.96/
C     DATA CCOSZ/.5/
C   B0,B1,B2,B3 ARE COEFFICIENTS USED TO CORRECT FOR THE USE OF 250K IN
C   THE PLANCK FUNCTION USED IN EVALUATING PLANCK-WEIGHTED CO2
C   TRANSMISSION FUNCTIONS. (SEE REF. 4)
      DATA B0,B1,B2,B3/-.51926410E-4,-.18113332E-3,
     1 -.10680132E-5,-.67303519E-7/
C    *******************************************************************
C    *                                                                 *
C    *                           B L C K F S  FROM G F D L             *
C    *  UNUSED DATA CLEANED OUT - NOV 86 AND MAR 89 ..K.A.CAMPANA....  *
C    *                                                                 *
C    *******************************************************************
C
C     FOR SEASONAL VARIATION
C        SEASON=1,2,3,4 FOR WINTER,SPRING,SUMMER,FALL ONLY (NOT ACTIVE)
C        SEASON=5 - SEASONAL VARIATION(I.E.INTERPOLATE TO DAY OF FCST)
C
      INTEGER SEASON
      COMMON/DIUCON/SEASON,FCSTDA,JTIME(5),DAZ(12),JDNMC,
     .              FJDNMC,TSLAG,RLAG,TIMIN,TPI,HPI,YEAR,DAY,DHR,IXXXX
      DATA SEASON/5/
      DATA TSLAG/45.25/,  RLAG/14.8125/
      DATA DAY/86400./,  YEAR/365.25/
      DATA TPI/6.283185308/,  HPI/1.570796327/
      DATA JTIME/0,1,0,0,0/
      DATA DHR/2./
      DATA DAZ/0.,31.,59.,90.,120.,151.,181.,212.,243.,273.,304.,334./
C
C     SEA SURFACE ALBEDO DATA
C
      COMMON/SSALB/ALBD(21,20),ZA(20),TRN(21),DZA(19)
      DIMENSION ALB1(21,7),ALB2(21,7),ALB3(21,6)
      EQUIVALENCE (ALB1(1,1),ALBD(1,1)),(ALB2(1,1),ALBD(1,8)),
     .            (ALB3(1,1),ALBD(1,15))
      DATA ALB1/ .061,.062,.072,.087,.115,.163,.235,.318,.395,.472,.542,
     . .604,.655,.693,.719,.732,.730,.681,.581,.453,.425,.061,.062,.070,
     . .083,.108,.145,.198,.263,.336,.415,.487,.547,.595,.631,.656,.670,
     . .652,.602,.494,.398,.370,.061,.061,.068,.079,.098,.130,.174,.228,
     . .290,.357,.424,.498,.556,.588,.603,.592,.556,.488,.393,.342,.325,
     . .061,.061,.065,.073,.086,.110,.150,.192,.248,.306,.360,.407,.444,
     . .469,.480,.474,.444,.386,.333,.301,.290,.061,.061,.065,.070,.082,
     . .101,.131,.168,.208,.252,.295,.331,.358,.375,.385,.377,.356,.320,
     . .288,.266,.255,.061,.061,.063,.068,.077,.092,.114,.143,.176,.210,
     . .242,.272,.288,.296,.300,.291,.273,.252,.237,.266,.220,.061,.061,
     . .062,.066,.072,.084,.103,.127,.151,.176,.198,.219,.236,.245,.250,
     . .246,.235,.222,.211,.205,.200/
      DATA ALB2/ .061,.061,.061,.065,.071,.079,.094,.113,.134,.154,.173,
     . .185,.190,.193,.193,.190,.188,.185,.182,.180,.178,.061,.061,.061,
     . .064,.067,.072,.083,.099,.117,.135,.150,.160,.164,.165,.164,.162,
     . .160,.159,.158,.157,.157,.061,.061,.061,.062,.065,.068,.074,.084,
     . .097,.111,.121,.127,.130,.131,.131,.130,.129,.127,.126,.125,.122,
     . .061,.061,.061,.061,.062,.064,.070,.076,.085,.094,.101,.105,.107,
     . .106,.103,.100,.097,.096,.095,.095,.095,.061,.061,.061,.060,.061,
     . .062,.065,.070,.075,.081,.086,.089,.090,.088,.084,.080,.077,.075,
     . .074,.074,.074,.061,.061,.060,.060,.060,.061,.063,.065,.068,.072,
     . .076,.077,.076,.074,.071,.067,.064,.062,.061,.061,.061,.061,.061,
     . .060,.060,.060,.060,.061,.062,.065,.068,.069,.069,.068,.065,.061,
     . .058,.055,.054,.053,.052,.052/
      DATA ALB3/ .061,.061,.060,.060,.060,.060,.060,.060,.062,.065,.065,
     . .063,.060,.057,.054,.050,.047,.046,.045,.044,.044,.061,.061,.060,
     . .060,.060,.059,.059,.059,.059,.059,.058,.055,.051,.047,.043,.039,
     . .035,.033,.032,.031,.031,.061,.061,.060,.060,.060,.059,.059,.058,
     . .057,.056,.054,.051,.047,.043,.039,.036,.033,.030,.028,.027,.026,
     . .061,.061,.060,.060,.060,.059,.059,.058,.057,.055,.052,.049,.045,
     . .040,.036,.032,.029,.027,.026,.025,.025,.061,.061,.060,.060,.060,
     . .059,.059,.058,.056,.053,.050,.046,.042,.038,.034,.031,.028,.026,
     . .025,.025,.025,.061,.061,.060,.060,.059,.058,.058,.057,.055,.053,
     . .050,.046,.042,.038,.034,.030,.028,.029,.025,.025,.025/
      DATA ZA/90.,88.,86.,84.,82.,80.,78.,76.,74.,70.,66.,62.,58.,54.,
     .        50.,40.,30.,20.,10.,0.0/
      DATA TRN/.00,.05,.10,.15,.20,.25,.30,.35,.40,.45,.50,.55,.60,.65,
     .         .70,.75,.80,.85,.90,.95,1.00/
      DATA DZA/8*2.0,6*4.0,5*10.0/
C
      COMMON /SWRSAV/ ABCFF(NB),PWTS(NB),CFCO2,CFO3,REFLO3,RRAYAV
C---SPECIFICATION OF DATA STATEMENTS:
C         ABCFF=ABSORPTION COEFFICIENTS FOR BANDS IN K-DISTRI-
C     BUTION. ORIGINALLY GIVEN BY LACIS AND HANSEN, REVISED BY
C     RAMASWAMY
C         PWTS=CORRESPONDING WEIGHTS ASSIGNED TO BANDS IN THE
C     K-DISTRIBUTION
C         REFLO3,RRAYAV= REFLECTION COEFFICIENTS GIVEN BY
C     LACIS AND HANSEN TO ACCOUNT FOR EFFECTS OF RAYLEIGH SCATTERING
C     IN THE VISIBLE FREQUENCIES (BAND 1)
C         CFCO2,CFO3=CONVERSION FACTORS FROM GM/CM**2 TO CM-ATM(STP)
C
C---THE FOLLOWING ARE THE COEFFICIENTS FOR THE 12-BAND SHORTWAVE
C   RADIATION CODE, SPECIFIED BY RAMASWAMY.
      DATA ABCFF/2*4.0E-5,.002,.035,.377,1.95,9.40,44.6,190.,
     1           989.,2706.,39011./
      DATA PWTS/.5000,.121416,.0698,.1558,.0631,.0362,.0243,.0158,.0087,
     1          .001467,.002342,.001075/
C---THE ORIGINAL 9-BAND LACIS-HANSEN COEFFICIENTS ARE GIVEN HERE; IT
C   THE USER INSISTS ON USING THESE VALUES, SHE MUST ALSO CHANGE
C   THE PARAMETER NB FROM 12 TO 9. THIS PARAMETER IS DEFINED IN
C   RDPARM.H . NO OTHER CHANGES ARE REQUIRED!
C     DATA ABCFF/2*4.0E-5,.002,.035,.377,1.95,9.40,44.6,190./
C     DATA PWTS/.5000,.1470,.0698,.1443,.0584,.0335,.0225,.0158,.0087/
C
      DATA CFCO2,CFO3/508.96,466.64/
      DATA REFLO3/1.9/
      DATA RRAYAV/0.144/
      END
