      SUBROUTINE DTFRZNEW(TU,P,THTEU,QU,QFRZ,QICE,ALIQ,BLIQ,CLIQ,DLIQ)
C----------------------------------------------------------------------
C
C***  ALLOW THE FREEZING OF LIQUID WATER IN THE UPDRAFT TO PROCEED AS 
C***  AN APPROXIMATELY LINEAR FUNCTION OF TEMPERATURE IN THE TEMPERATURE 
C***  RANGE TTFRZ TO TBFRZ.
C***  FOR COLDER TERMPERATURES, FREEZE ALL LIQUID WATER.
C***  THERMODYNAMIC PROPERTIES ARE STILL CALCULATED WITH RESPECT TO 
C***  LIQUID WATER TO ALLOW THE USE OF LOOKUP TABLE TO EXTRACT TMP 
C***  FROM THETAE.
C
C----------------------------------------------------------------------
      RLC=2.5E6-2369.276*(TU-273.16)
      RLS=2833922.-259.532*(TU-273.16)
      RLF=RLS-RLC
      CP=1005.7*(1.+0.89*QU)
C
C***  A = D(es)/DT IS THAT CALCULATED FROM BUCKS (1981) EMPIRICAL 
C***  FORMULAS FOR SATURATION VAPOR PRESSURE.
C
      A=(CLIQ-BLIQ*DLIQ)/((TU-DLIQ)*(TU-DLIQ))
      DTFRZ=RLF*QFRZ/(CP+RLS*QU*A)
      TU=TU+DTFRZ
      
      ES=ALIQ*EXP((BLIQ*TU-CLIQ)/(TU-DLIQ))
      QS=ES*0.622/(P-ES)
C
C***  FREEZING WARMS THE AIR AND IT BECOMES UNSATURATED.  ASSUME THAT 
C***  SOME OF THE LIQUID WATER THAT IS AVAILABLE FOR FREEZING EVAPORATES
C***  TO MAINTAIN SATURATION.  SINCE THIS WATER HAS ALREADY BEEN
C***  TRANSFERRED TO THE ICE CATEGORY, SUBTRACT IT FROM ICE CONCENTRATION,
C***  THEN SET UPDRAFT MIXING RATIO AT THE NEW TEMPERATURE TO THE
C***  SATURATION VALUE.
C
      DQEVAP=QS-QU
      QICE=QICE-DQEVAP
      QU=QU+DQEVAP
      PI=(1.E5/P)**(0.2854*(1.-0.28*QU))
      THTEU=TU*PI*
     1      EXP((3374.6525/TU-2.5403)*QU*(1.+0.81*QU))
C----------------------------------------------------------------------
      RETURN
      END
