      SUBROUTINE KFTEND
C     ******************************************************************
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .
C SUBPROGRAM:    KFDRIVE     CONVECTIVE PRECIPITATION PARAMETERIZATION
C   PRGRMMR: KAIN            ORG: W/NP2      DATE: 00-03-30
C
C ABSTRACT:
C     KFTEND FEEDS TENDENCIES GENERATED BY THE KAIN-FRITSCH CONVECTIVE
C     SCHEME INTO THE GRIDSCALE TEMPERATURE AND MOISTURE FIELDS
C
C
C PROGRAM HISTORY LOG:
C   ??-??-??  KAIN       - ORIGINATOR
C   00-04-17  BLACK      - INCORPORATED INTO ETA MODEL
C
C USAGE: CALL KFTEND FROM MAIN PROGRAM EBU
C
C   INPUT ARGUMENT LIST:
C     NONE
C
C   OUTPUT ARGUMENT LIST:
C     NONE
C
C   SUBPROGRAMS CALLED:
C
C     UNIQUE:
C        KFPARA
C
C     LIBRARY:
C        NONE
C
C   COMMON BLOCKS: CTLBLK
C                  VRBLS
C                  DYNAM
C                  PVRBLS
C                  ACMCLH
C                  ACMPRE
C                  CNVCLD
C                  MASKS
C                  LOOPS
C                  KFFDBK
C                  CLDWTR
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C   MACHINE : IBM SP
C$$$
C----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "mpp.h"
C----------------------------------------------------------------------
      PARAMETER(LP1=LM+1,JAM=6+2*(JM-10))
C----------------------------------------------------------------------
      INCLUDE "CTLBLK.comm"
      INCLUDE "VRBLS.comm"
      INCLUDE "DYNAM.comm"
      INCLUDE "PVRBLS.comm"
      INCLUDE "ACMCLH.comm"
      INCLUDE "CNVCLD.comm"
      INCLUDE "MASKS.comm"
      INCLUDE "LOOPS.comm"
      INCLUDE "KFFDBK.comm"
      INCLUDE "CLDWTR.comm"
      INCLUDE "ACMPRE.comm"
C----------------------------------------------------------------------
C**********************************************************************
C----------------------------------------------------------------------
C
C***  FEEDBACK CONVECTIVE TENDENCIES EACH TIME STEP
C
!$omp parallel do
!$omp& private(i,l,lg)
      DO 30 J=MYJS2,MYJE2
      DO 30 I=MYIS1,MYIE1
C
      IF(NCA(I,J).LE.0)GO TO 30
      LG=LMH(I,J)
C
      DO L=1,LG
        T(I,J,L)=T(I,J,L)+DTDT(I,J,L)*DT*HBM2(I,J)
        Q(I,J,L)=Q(I,J,L)+DQDT(I,J,L)*DT*HBM2(I,J)
        CWM(I,J,L)=CWM(I,J,L)+DQCDT(I,J,L)*DT*HBM2(I,J) 
        TCUCN(I,J,L) = DTDT(I,J,L)*DT*HBM2(I,J)+ TCUCN(I,J,L)
      ENDDO
C
      CUPREC(I,J)=CUPREC(I,J)+RAINCV(I,J)*0.01
      ACPREC(I,J)=ACPREC(I,J)+RAINCV(I,J)*0.01
      CUPPT(I,J)=CUPPT(I,J)+RAINCV(I,J)*0.01
      PREC(I,J)=PREC(I,J)+RAINCV(I,J)*0.01
C
      PPTKF(I,J)=PPTKF(I,J)+RAINCV(I,J)*0.01
C
      IF(NCAD(I,J).GT.0)THEN
        TNCA(I,J)=TNCA(I,J)+1.
        SPCLB(I,J)=SPCLB(I,J)+PCLB(I,J)
C
C***  USE PEAK VALUE OF UMF INSTEAD OF 1 HOUR AVG.
C***  DO THE SAME FOR PSRC.
C
        SPSRC(I,J)=AMAX1(PSRC(I,J),SPSRC(I,J))
        SUMFB(I,J)=AMAX1(UMFB(I,J),SUMFB(I,J))
        NCAD(I,J)=NCAD(I,J)-1
      ENDIF
C----------------------------------------------------------------------
C
C***  UPDATE THE CONVECTIVE TIME SCALE ARRAY.
C
      NCA(I,J)=NCA(I,J)-1
C
      IF(NCA(I,J).EQ.0)THEN
        RAINCV(I,J)=0.
C
        DO L=1,LM
          DTDT(I,J,L)=0.
          DQDT(I,J,L)=0.
          DQCDT(I,J,L)=0.  
        ENDDO
C
        PSRC(I,J) = 0.
        PCLB(I,J) = 0.
        UMFB(I,J) = 0.
      ENDIF
C----------------------------------------------------------------------
 30   CONTINUE
C----------------------------------------------------------------------
      RETURN
      END
