
      SUBROUTINE TPMIX2(P,THES,TU,QU,QLIQ,QICE,QNEWLQ,QNEWIC,RATIO2
     1, XLV1,XLV0)
C----------------------------------------------------------------------
C*************** LOOKUP TABLE VARIABLES *******************************
      PARAMETER(KFNT=250,KFNP=220)
C
      COMMON/KFLUT/ TTAB(KFNT,KFNP),QSTAB(KFNT,KFNP),THE0K(KFNP)
     1, ALU(200),RDPR,RDTHK,PTOP
C***************************************************************
C
C***********************************************************************
C*** SCALING PRESSURE & TT TABLE INDEX
C***********************************************************************
C
      TP=(P-PTOP)*RDPR
      QQ=TP-AINT(TP)
      IPTB=INT(TP)+1
C
C***********************************************************************
C*** BASE AND SCALING FACTOR FOR THE
C***********************************************************************
C
C*** SCALING THE & TT TABLE INDEX
C
      BTH=(THE0K(IPTB+1)-THE0K(IPTB))*QQ+THE0K(IPTB)
      TTH=(THES-BTH)*RDTHK
      PP =TTH-AINT(TTH)
      ITHTB=INT(TTH)+1
c
      T00=TTAB(ITHTB ,IPTB )
      T10=TTAB(ITHTB+1,IPTB )
      T01=TTAB(ITHTB ,IPTB+1)
      T11=TTAB(ITHTB+1,IPTB+1)
C
      Q00=QSTAB(ITHTB ,IPTB )
      Q10=QSTAB(ITHTB+1,IPTB )
      Q01=QSTAB(ITHTB ,IPTB+1)
      Q11=QSTAB(ITHTB+1,IPTB+1)
C
C***********************************************************************
C*** PARCEL TEMPERATURE
c***********************************************************************
C
      TEMP=(T00+(T10-T00)*PP+(T01-T00)*QQ
     1 +(T00-T10-T01+T11)*PP*QQ)
c
      QS=(Q00+(Q10-Q00)*PP+(Q01-Q00)*QQ
     1 +(Q00-Q10-Q01+Q11)*PP*QQ)
C
      DQ=QS-QU
      IF(DQ.LE.0.)THEN
        QNEW=QU-QS
        QU=QS
      ELSE
C
C   IF THE PARCEL IS SUBSATURATED, TEMPERATURE AND MIXING RATIO MUST BE
C   ADJUSTED...IF LIQUID WATER IS PRESENT, IT IS ALLOWED TO EVAPORATE
C 
        QNEW=0.
        QTOT=QLIQ+QICE
C
C   IF THERE IS ENOUGH LIQUID OR ICE TO SATURATE THE PARCEL, TEMP STAYS AT ITS
C   WET BULB VALUE, VAPOR MIXING RATIO IS AT SATURATED LEVEL, AND THE MIXING
C   RATIOS OF LIQUID AND ICE ARE ADJUSTED TO MAKE UP THE ORIGINAL SATURATION
C   DEFICIT... OTHERWISE, ANY AVAILABLE LIQ OR ICE VAPORIZES AND APPROPRIATE
C   ADJUSTMENTS TO PARCEL TEMP; VAPOR, LIQUID, AND ICE MIXING RATIOS ARE MADE.
C
C...subsaturated values only occur in calculations involving various mixtures of
C...updraft and environmental air for estimation of entrainment and detrainment.
C...For these purposes, assume that reasonable estimates can be given using 
C...liquid water saturation calculations only - i.e., ignore the effect of the
C...ice phase in this process only...will not affect conservative properties...
C
        IF(QTOT.GE.DQ)THEN
          qliq=qliq-dq*qliq/(qtot+1.e-10)
          qice=qice-dq*qice/(qtot+1.e-10)
          QU=QS
        ELSE
          RLL=XLV0-XLV1*TEMP
          CPP=1005.7*(1.+0.89*QU)
          IF(QTOT.LT.1.E-10)THEN
C
C...IF NO LIQUID WATER OR ICE IS AVAILABLE, TEMPERATURE IS GIVEN BY:
            TEMP=TEMP+RLL*(DQ/(1.+DQ))/CPP
          ELSE
C
C...IF SOME LIQ WATER/ICE IS AVAILABLE, BUT NOT ENOUGH TO ACHIEVE SATURATION,
C   THE TEMPERATURE IS GIVEN BY:
C
            TEMP=TEMP+RLL*((DQ-QTOT)/(1+DQ-QTOT))/CPP
            QU=QU+QTOT
            QTOT=0.
            QLIQ=0.
            QICE=0.
          ENDIF
        ENDIF
      ENDIF
      TU=TEMP
      qnewlq=qnew
      qnewic=0.
C
      RETURN
      END

