      SUBROUTINE KFTEND
C     ******************************************************************
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .
C SUBPROGRAM:    KFDRIVE     CONVECTIVE PRECIPITATION PARAMETERIZATION
C   PRGRMMR: KAIN            ORG: W/NP2      DATE: 00-03-30
C
C ABSTRACT:
C     KFTEND FEEDS TENDENCIES GENERATED BY THE KAIN-FRITSCH CONVECTIVE
C     SCHEME INTO THE GRIDSCALE TEMPERATURE AND MOISTURE FIELDS
C
C
C PROGRAM HISTORY LOG:
C   ??-??-??  KAIN       - ORIGINATOR
C   00-04-17  BLACK      - INCORPORATED INTO ETA MODEL
C   06-10-19  BASTOS     - INCORPORATED HORIZONTAL WIND COMPONENTS
C
C USAGE: CALL KFTEND FROM MAIN PROGRAM EBU
C
C   INPUT ARGUMENT LIST:
C     NONE
C
C   OUTPUT ARGUMENT LIST:
C     NONE
C
C   SUBPROGRAMS CALLED:
C
C     UNIQUE:
C        KFPARA
C
C     LIBRARY:
C        NONE
C
C   COMMON BLOCKS: CTLBLK
C                  VRBLS
C                  DYNAM
C                  PVRBLS
C                  ACMCLH
C                  ACMPRE
C                  CNVCLD
C                  MASKS
C                  LOOPS
C                  KFFDBK
C                  CLDWTR
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C   MACHINE : IBM SP
C$$$
C----------------------------------------------------------------------
      INCLUDE "parmeta"
      INCLUDE "mpp.h"
C----------------------------------------------------------------------
      PARAMETER(LP1=LM+1,JAM=6+2*(JM-10))
C----------------------------------------------------------------------
      INCLUDE "CTLBLK.comm"
      INCLUDE "VRBLS.comm"
      INCLUDE "DYNAM.comm"
      INCLUDE "PVRBLS.comm"
      INCLUDE "ACMCLH.comm"
      INCLUDE "CNVCLD.comm"
      INCLUDE "MASKS.comm"
      INCLUDE "LOOPS.comm"
      INCLUDE "KFFDBK.comm"
      INCLUDE "CLDWTR.comm"
      INCLUDE "ACMPRE.comm"
C------------------------------------>>>>>>>>>>>>>>>>>>>>>>>>>>>
      INCLUDE "INDX.comm"
c-------------------------------------<<<<<<<<<<<<<<<<<<<<<<<<<<
C----------------------------------------------------------------------
C**********************************************************************
C----------------------------------------------------------------------
C
C***  FEEDBACK CONVECTIVE TENDENCIES EACH TIME STEP
C
!$omp parallel do
!$omp& private(i,l,lg)
      DO 30 J=MYJS2,MYJE2
      DO 30 I=MYIS1,MYIE1
C
      IF(NCA(I,J).LE.0)GO TO 30
      LG=LMH(I,J)
C
C
      DO L=1,LG
        T(I,J,L)=T(I,J,L)+DTDT(I,J,L)*DT*HBM2(I,J)
        Q(I,J,L)=Q(I,J,L)+DQDT(I,J,L)*DT*HBM2(I,J)
        CWM(I,J,L)=CWM(I,J,L)+DQCDT(I,J,L)*DT*HBM2(I,J) 
        TCUCN(I,J,L) = DTDT(I,J,L)*DT*HBM2(I,J)+ TCUCN(I,J,L)
C
C-------------------------------------------------->>>>>>>>>>>>>>>>>
C
        IF(VTM(I+IHE(J),J,L).EQ.1)THEN
C
        SUMV=HTM(I,J,L)+HTM(I+1,J,L)+HTM(I+1,J+1,L)+HTM(I+1,J-1,L)
C
          IF(SUMV.GT.0)THEN
C
        U(I+IHE(J),J,L)=U(I+IHE(J),J,L)+(DUDT(I,J,L)*HTM(I,J,L)+
     1    DUDT(I+1,J,L)*HTM(I+1,J,L)+DUDT(I+1,J+1,L)*HTM(I+1,J+1,L)+
     2    DUDT(I+1,J-1,L)*HTM(I+1,J-1,L))*DT*VBM2(I+IHE(J),J)/SUMV
C
        V(I+IHE(J),J,L)=V(I+IHE(J),J,L)+(DVDT(I,J,L)*HTM(I,J,L)+
     1    DVDT(I+1,J,L)*HTM(I+1,J,L)+DVDT(I+1,J+1,L)*HTM(I+1,J+1,L)+
     2    DVDT(I+1,J-1,L)*HTM(I+1,J-1,L))*DT*VBM2(I+IHE(J),J)/SUMV
C
          ENDIF
C
        ENDIF
C
        IF(VTM(I+IHW(J),J,L).EQ.1)THEN
C
        SUMV=HTM(I,J,L)+HTM(I-1,J,L)+HTM(I-1,J+1,L)+HTM(I-1,J-1,L)
C
          IF(SUMV.GT.0)THEN
C	 
        U(I+IHW(J),J,L)=U(I+IHW(J),J,L)+(DUDT(I,J,L)*HTM(I,J,L)+
     1    DUDT(I-1,J,L)*HTM(I-1,J,L)+DUDT(I-1,J+1,L)*HTM(I-1,J+1,L)+
     2    DUDT(I-1,J-1,L)*HTM(I-1,J-1,L))*DT*VBM2(I+IHW(J),J)/SUMV
C
        V(I+IHW(J),J,L)=V(I+IHW(J),J,L)+(DVDT(I,J,L)*HTM(I,J,L)+
     1    DVDT(I-1,J,L)*HTM(I-1,J,L)+DVDT(I-1,J+1,L)*HTM(I-1,J+1,L)+
     2    DVDT(I-1,J-1,L)*HTM(I-1,J-1,L))*DT*VBM2(I+IHW(J),J)/SUMV
C
          ENDIF
C
        ENDIF
C
        IF(VTM(I,J+1,L).EQ.1)THEN
C
        SUMV=HTM(I,J,L)+HTM(I-1,J+1,L)+HTM(I+1,J+1,L)+HTM(I,J+2,L)
C
          IF(SUMV.GT.0)THEN
C
        U(I,J+1,L)=U(I,J+1,L)+(DUDT(I,J,L)*HTM(I,J,L)+
     1    DUDT(I-1,J+1,L)*HTM(I-1,J+1,L)+DUDT(I+1,J+1,L)*HTM(I+1,J+1,L)+
     2    DUDT(I,J+2,L)*HTM(I,J+2,L))*DT*VBM2(I,J+1)/SUMV
C
        V(I,J+1,L)=V(I,J+1,L)+(DVDT(I,J,L)*HTM(I,J,L)+
     1    DVDT(I-1,J+1,L)*HTM(I-1,J+1,L)+DVDT(I+1,J+1,L)*HTM(I+1,J+1,L)+
     2    DVDT(I,J+2,L)*HTM(I,J+2,L))*DT*VBM2(I,J+1)/SUMV
C
          ENDIF
C
        ENDIF
C
        IF(VTM(I,J-1,L).EQ.1)THEN
C
        SUMV=HTM(I,J,L)+HTM(I-1,J-1,L)+HTM(I,J-2,L)+HTM(I+1,J-1,L)
C
          IF(SUMV.GT.0)THEN
C
        U(I,J-1,L)=U(I,J-1,L)+(DUDT(I,J,L)*HTM(I,J,L)+
     1    DUDT(I-1,J-1,L)*HTM(I-1,J-1,L)+DUDT(I,J-2,L)*HTM(I,J-2,L)+
     2    DUDT(I+1,J-1,L)*HTM(I+1,J-1,L))*DT*VBM2(I,J-1)/SUMV
C
        V(I,J-1,L)=V(I,J-1,L)+(DVDT(I,J,L)*HTM(I,J,L)+
     1    DVDT(I-1,J-1,L)*HTM(I-1,J-1,L)+DVDT(I,J-2,L)*HTM(I,J-2,L)+
     2    DVDT(I+1,J-1,L)*HTM(I+1,J-1,L))*DT*VBM2(I,J-1)/SUMV          
C
        ENDIF
C
        ENDIF              
C
C---------------------------------------------------<<<<<<<<<<<<<<<
C
      ENDDO
C
      CUPREC(I,J)=CUPREC(I,J)+RAINCV(I,J)*0.01
      ACPREC(I,J)=ACPREC(I,J)+RAINCV(I,J)*0.01
      CUPPT(I,J)=CUPPT(I,J)+RAINCV(I,J)*0.01
      PREC(I,J)=PREC(I,J)+RAINCV(I,J)*0.01
C
      PPTKF(I,J)=PPTKF(I,J)+RAINCV(I,J)*0.01
C
      IF(NCAD(I,J).GT.0)THEN
        TNCA(I,J)=TNCA(I,J)+1.
        SPCLB(I,J)=SPCLB(I,J)+PCLB(I,J)
C
C***  USE PEAK VALUE OF UMF INSTEAD OF 1 HOUR AVG.
C***  DO THE SAME FOR PSRC.
C
        SPSRC(I,J)=AMAX1(PSRC(I,J),SPSRC(I,J))
        SUMFB(I,J)=AMAX1(UMFB(I,J),SUMFB(I,J))
        NCAD(I,J)=NCAD(I,J)-1
      ENDIF
C----------------------------------------------------------------------
C
C***  UPDATE THE CONVECTIVE TIME SCALE ARRAY.
C
      NCA(I,J)=NCA(I,J)-1
C
      IF(NCA(I,J).EQ.0)THEN
        RAINCV(I,J)=0.
C
        DO L=1,LM
          DTDT(I,J,L)=0.
          DQDT(I,J,L)=0.
          DQCDT(I,J,L)=0.
C
C----------------------------------------------->>>>>>>>>>>>>>>>>>>
C
          DUDT(I,J,L)=0.
          DVDT(I,J,L)=0.
C
C-----------------------------------------------<<<<<<<<<<<<<<<<<<<
C       
        ENDDO
C
        PSRC(I,J) = 0.
        PCLB(I,J) = 0.
        UMFB(I,J) = 0.
      ENDIF
C----------------------------------------------------------------------
 30   CONTINUE
C----------------------------------------------------------------------
      RETURN
      END
