C-CP
      SUBROUTINE ZTERPG(II,JJ,Z,ZOLD,HLAT,HLON)
C
C     II,JJ: INDICIES ON ETA GRID
C
      INCLUDE "parmeta"
C
C   IMX,JMX are the dimensions of the 14 KM SST FIELD
C
                        P A R A M E T E R
     1 (IMX=1041,JMX=441,IMXP=IMX+1)
                        P A R A M E T E R
     1 (HD5=0.125,H2=2.0,RAD2D=57.29578)
                        D I M E N S I O N
     1  Z(IMX,JMX),HLAT(IM,JM),HLON(IM,JM)
     2, ALAT(IMX,JMX),ALON(IMX,JMX),ZOLD(IM,JM)
C***
C*** RECALL THAT HLAT AND HLON ARE THE GEODETIC LATITUDE AND
C*** LONGITUDE OF THE ETA GRID H POINTS.  ALAT AND ALON ARE THE
C-CP GEODETIC LATITUDE AND LONGITUDE OF THE 1/8 DEG LAT/LON GRID.
C*** GOING TO REPLACE ZOLD(M,N) WITH AN INTERPOLATED VALUE OF Z
C*** ONLY WHERE VALUES GREATER THAN ZERO EXIST IN Z.
C***
      D11=1.0
      D12=1.0
      D21=1.0
      D22=1.0
      DO 10 J=1,JMX
      DO 10 I=1,IMX
C
C   10N,195E is the lat/lon of the SW corner point of the
C   14 km SST grid
C
      ALAT(I,J)=10.0 +(J-1)*HD5
      ALON(I,J)=195.0+(I-1)*HD5
   10 CONTINUE
      TLAT=HLAT(II,JJ)*RAD2D
      TLON=HLON(II,JJ)*RAD2D
      DO 20 J=1,JMX
      IF(TLAT.GT.ALAT(1,J))GO TO 20
      JPT=J
      GO TO 25
   20 CONTINUE
      STOP50
   25 DO 50 I=1,IMXP
      ALON1=ALON(1,1)
      IF(I.LT.IMXP)ALON1=ALON(I,1)
      IF(TLON.GT.ALON1)GO TO 50
      IPT=I
      IPTM=IPT-1
      IF(IPT.EQ.IMXP)IPT=1
      IF(IPT.EQ.1)IPTM=IMX
      GO TO 60
   50 CONTINUE
      STOP601
   60 CONTINUE
      IF(JPT.EQ.1)JPT=2
      IF(IPT.EQ.1.AND.IPTM.LT.1)IPT=2
      DXT=ALON(IPT,JPT)-ALON(IPTM,JPT)
      DYT=ALAT(IPT,JPT)-ALAT(IPT,JPT-1)
      DX=(TLON-ALON(IPTM,JPT))/DXT
      DXR=(ALON(IPT,JPT)-TLON)/DXT
      DY=(TLAT-ALAT(IPT,JPT-1))/DYT
      DYR=(ALAT(IPT,JPT)-TLAT)/DYT
      ZTERP1=Z(IPTM,JPT-1)*DXR*DYR+
     1 Z(IPT,JPT-1)*DX*DYR+
     2 Z(IPTM,JPT)*DXR*DY+
     3 Z(IPT,JPT)*DX*DY
      IF (Z(IPTM,JPT-1).EQ.0.0) D11=0.0
      IF (Z(IPT ,JPT-1).EQ.0.0) D12=0.0
      IF (Z(IPTM,JPT  ).EQ.0.0) D21=0.0
      IF (Z(IPT ,JPT  ).EQ.0.0) D22=0.0
      IF (ZTERP1.EQ.0.0) THEN
      RETURN
      ELSE
      DENOM1=D11*DXR*DYR+
     1 D12*DX*DYR+
     2 D21*DXR*DY+
     3 D22*DX*DY
      ZOLD(II,JJ)=ZTERP1/DENOM1
      END IF
      RETURN
      END
