      SUBROUTINE CALDWP2(P1D,Q1D,TDWP,T1D)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    CALDWP2     COMPUTES 
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-12-22
C     
C ABSTRACT:  COMPUTES ANEMOMETER LEVEL WINDS.  AT EACH WIND
C   POINT IN THE GRID FIT A LOGRITHMIC, THEN LINEAR PROFILE 
C   BETWEEN THE WIND COMPONENTS AT Z0 AND THOSE IN THE FIRST
C   ATMOSPHERIC ETA LAYER.  WE MATCH THE TWO PROFILES AT A
C   CRITICAL HEIGHT, ZC, MAINTAINING ZEROTH AND FIRST ORDER 
C   CONTINUITY.   IF THE DISTANCE BETWEEN THE SURFACE AND 
C   THE FIRST ATMOSPHERIC ETA LAYER EXCEEDS A SWITCH HEIGHT,
C   ZSWITCH, WE ASSUME AN INVERSE EXPONENTIAL PROFILE BETWEEN
C   THE WIND COMPONENTS AT Z0 AND THOSE IN THE FIRST ATMOSPHERIC
C   ETA LAYER.  THIS INVERSE EXPONENTIAL PROFILE WAS A TEMPORARY
C   FIX TO AVOID UNREASONABLY SMALL ANEMOMETER LEVEL WINDS.
C   .     
C     
C PROGRAM HISTORY LOG:
C   92-12-22  RUSS TREADON
C   93-10-04  RUSS TREADON - ADDED CHECK TO BOUND DEWPOINT
C                            TEMPERATURE TO NOT EXCEED THE
C                            AMBIENT TEMPERATURE.
C   98-06-08  T BLACK      - CONVERSION FROM 1-D TO 2-D
C   00-01-04  JIM TUCCILLO - MPI VERSION                
C     
C USAGE:    CALL CALDWP2(P1D,Q1D,TDWP,T1D)
C   INPUT ARGUMENT LIST:
C     P1D      - PRESSURE (PA)
C     Q1D      - SPECIFIC HUMIDITY (KG/KG)
C     T1D      - TEMPERATURE (K)
C
C   OUTPUT ARGUMENT LIST: 
C     TDWP     - DEWPOINT TEMPERATURE (K)

C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       DEWPOINT - COMPUTES DEWPOINT GIVEN VAPOR PRESSURE.
C     LIBRARY:
C       NONE
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN 90
C     MACHINE : CRAY C-90
C$$$  
C
C
C     SET PARAMETERS.
      INCLUDE "parmeta" 
      INCLUDE "params"
      INCLUDE "CTLBLK.comm"
C     
C     DECLARE VARIABLES.
C     
      REAL EVP(IM,JM),P1D(IM,JM),Q1D(IM,JM),TDWP(IM,JM),T1D(IM,JM)
C     
C     
C****************************************************************************
C     START CALDWP2 HERE.
C     
C     COMPUTE VAPOR PRESSURE.  CONVERT TO CENITBARS.
C     
      DO J=JSTA,JEND
      DO I=1,IM
        EVP(I,J) = P1D(I,J)*Q1D(I,J)/(EPS+ONEPS*Q1D(I,J))
        EVP(I,J) = EVP(I,J)*D001
        EVP(I,J) = AMAX1(H1M12,EVP(I,J))
      ENDDO
      ENDDO
C     
C     COMPUTE DEWPOINT TEMPERATURE.
C     
      CALL DEWPOINT(EVP,TDWP,IM,JM)
C     
C     ENSURE DEWPOINT TEMPERATURE DOES NOT EXCEED AMBIENT TEMPERATURE.
C     
      DO J=JSTA,JEND
      DO I=1,IM
        IF (TDWP(I,J).GT.T1D(I,J)) TDWP(I,J) = T1D(I,J)
      ENDDO
      ENDDO
C
C     END OF ROUTINE.
C     
      RETURN
      END
