      SUBROUTINE GD2EG(IMOUT,JMOUT)
C
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    GD2EG       CNVRT OUT (I,J) TO E (I,J)
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 93-01-03       
C     
C ABSTRACT:
C     THIS ROUTINE CONVERTS OUTPUT GRID INTEGER (I,J) 
C     TO FILLED E-GRID FLOATING POINT (I,J).  SUBROUTINE
C     INTERP3 USES THIS INFORMATION TO BILINEARLY 
C     INTERPOLATE FROM A FILLED E-GRID TO THE OUTPUT GRID.
C   .     
C     
C PROGRAM HISTORY LOG:
C   93-01-03  RUSS TREADON
C     
C USAGE:    CALL GD2EG(IMOUT,JMOUT)
C   INPUT ARGUMENT LIST:
C     IMOUT    - FIRST DIMENSION OF OUTPUT GRID.
C     JMOUT    - SECOND DIMENSION OF OUTPUT GRID.
C
C   OUTPUT ARGUMENT LIST: 
C     
C   OUTPUT FILES:
C     STDOUT  - RUN TIME STANDARD OUT.
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       LL2EG - CONVERT (LAT,LON) TO FLOATING POINT E-GRID (I,J)
C     LIBRARY:
C       COMMON - IOUNIT
C                LLGRDS
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C     
C     
C     INCLUDE MAXIMUM OUTPUT GRID DIMENSIONS.
      INCLUDE "parmeta"
      INCLUDE "parmout"
      PARAMETER (imjm=im*jm-jm/2,IMT=2*IM-1,JMT=JM)
      PARAMETER (FMAXI=IMT-1.,FMAXJ=JMT-1.)
C     
C     INCLUDE COMMON BLOCKS.
      INCLUDE "IOUNIT.comm"
      INCLUDE "LLGRDS.comm"
C     
C*********************************************************************
C     START GD2EG HERE.
C     
C     INITIALIZE ARRAYS.
C     
CMIC$ DO ALL VECTOR AUTOSCOPE
      DO 10 J = 1,JMX
      DO 10 I = 1,IMX
         EGRDI(I,J) = -1
         EGRDJ(I,J) = -1
 10   CONTINUE
C     
C     LOOP OVER OUTPUT GRID (I,J).  FOR EACH OUTPUT GRID (I,J) FIND
C     THE CORRESPONDING E-GRID (I,J).
C     
      WRITE(STDOUT,*)'GD2EG:  FIND E-GRID (I,J) ON OUTPUT GRID'
      DO 20 J = 1,JMOUT
      DO 20 I = 1,IMOUT
         ALAT = GDLAT(I,J)
         ALON = GDLON(I,J)
         CALL LL2EG(ALAT,ALON,EI,EJ)
         EGRDI(I,J) = EI
         EGRDJ(I,J) = EJ
 20   CONTINUE
C     
C     END OF ROUTINE.
C     
      RETURN
      END
