      SUBROUTINE SCLFLD(FLD,SCALE,IMO,JMO)
C
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .     
C SUBPROGRAM:    SCLFLD      SCALE ARRAY ELEMENT BY CONSTANT
C   PRGRMMR: TREADON         ORG: W/NP2      DATE: 92-09-13       
C     
C ABSTRACT:  
C     THIS ROUTINE MULTIPLES (SCALES) THE FIRST IMO*JMO
C     ELEMENTS OF ARRAY FLD BY THE REAL SCALAR SCALE.
C     ARRAY ELEMENTS WHICH EQUAL A SPECIAL VALUE WILL
C     NOT BE SCALED BY SCALE.  THEY WILL BE LEFT AS IS.
C     THE SPECIAL VALUE, SPVAL, IS PASSED THROUGH COMMON
C     BLOCK OPTIONS.  IT IS SET IN INCLUDE FILE OPTIONS.
C   .     
C     
C PROGRAM HISTORY LOG:
C   92-09-13  RUSS TREADON
C   00-01-04  JIM TUCCILLO
C     
C USAGE:    CALL SCLFLD(FLD,SCALE,IMO,JMO)
C   INPUT ARGUMENT LIST:
C     FLD      - ARRAY WHOSE ELEMENTS ARE TO BE SCALED.
C     SCALE    - CONSTANT BY WHICH TO SCALE ELEMENTS OF FLD.
C     IMO,JMO  - DIMENSION OF ARRAY FLD.
C
C   OUTPUT ARGUMENT LIST: 
C     FLD      - ARRAY WHOSE ELEMENTS HAVE BEEN SCALED BY SCALE.
C     
C   OUTPUT FILES:
C     NONE
C     
C   SUBPROGRAMS CALLED:
C     UTILITIES:
C       NONE
C     LIBRARY:
C       COMMON - OPTIONS
C     
C   ATTRIBUTES:
C     LANGUAGE: FORTRAN
C     MACHINE : CRAY C-90
C$$$  
C
C     
C     
C     DECLARE PARAMETER.
      PARAMETER (SMALL=1.E-6)
C
C     DECLARE VARIABLES.
C     
      REAL SCALE, FLD(IMO,JMO)
C     
C     INCLUDE COMMON BLOCK WITH SPVAL.
      INCLUDE "OPTIONS.comm"
      INCLUDE "CTLBLK.comm"
C     
C     
C***********************************************************************
C     START SCLFLD HERE
C     
C     MULTIPLY EACH ELEMENT OF FLD BY SCALE.
C     
!$omp  parallel do
      IF ( ME .EQ. 0 ) THEN
      DO J=1,JMO
      DO I=1,IMO
        IF(ABS(FLD(I,J)-SPVAL).GT.SMALL) 
     1        FLD(I,J)=SCALE*FLD(I,J)
      ENDDO
      ENDDO
      END IF
C     
C     END OF ROUTINE.
C     
      RETURN
      END
