dnl acinclude.m4: 
dnl
dnl  This file contains custom M4 macro definitions for the GrADS build system.
dnl  It is merged with automake-related macros in "aclocal.m4" by the "aclocal"
dnl  program. The merged "aclocal.m4" file is in turn used by the "autoconf" 
dnl  program to generate the "configure" script. 
dnl



dnl GA_SET_FLAGS : Adds supplibs to the compile and link paths, plus any extra
dnl 		   compiler or linker flags given, and saves original settings
dnl 		   for restoration by GA_UNSET_FLAGS
dnl  args: 	   extra-CPP-flags, extra-LD-flags
AC_DEFUN(GA_SET_FLAGS,
[
  # Use to make temporary changes to -I and -L paths 
  # Just for use during tests, because configure and make may run 
  # from different directories. 
  ga_saved_cppflags=$CPPFLAGS
  ga_saved_ldflags=$LDFLAGS
  CPPFLAGS="$CPPFLAGS -I${ga_supplib_dir}/include $1"
  LDFLAGS="$LDFLAGS -L${ga_supplib_dir}/lib $2"
])



dnl GA_UNSET_FLAGS : Undoes changes to compiler and linker flags made by GA_SET_FLAGS.
dnl  args:	     none
AC_DEFUN(GA_UNSET_FLAGS,
[
  # Use to undo temporary changes to -I and -L paths 
  CPPFLAGS=$ga_saved_cppflags
  LDFLAGS=$ga_saved_ldflags
])



dnl GA_ENABLE_DYNAMIC : Enables dynamic compilation.
AC_DEFUN(GA_ENABLE_DYNAMIC,
[ 
  # Just set a flag variable. I put this here instead of configure.in
  # because this variable is used by other macros.  
  ga_dyn_supplibs=yes 
])



dnl GA_SET_SUPPLIBS : Find a supplibs directory. The algorithm is to search, in 
dnl  		      order, for "supplibs-$host_os", then "$old_platform_supplibs"
dnl		      which is the architecture name used by the old "config.sh"
dnl		      build system, then just plain "supplibs". If SUPPLIBS is 
dnl		      set, then it overrides all of these. 
dnl args: paths-to-search (eg. [. ..])
AC_DEFUN(GA_SET_SUPPLIBS,
[ 

  AC_MSG_CHECKING([for supplibs directory])

  if test -n "${SUPPLIBS}" ; then
    # Use present supplib name unmodified, assume it is absolute path

    AC_MSG_RESULT([${SUPPLIBS}])
    # This is the "official" variable name for use by other macros
    ga_supplib_dir="${SUPPLIBS}"

  else
    # Look for platform-specific supplib directory in ${top_builddir}

    platform_supplibs="supplibs-${host_os}"

    # Historic GrADS naming scheme
    case "$host" in 
      alpha-*-osf*)
      old_platform_supplibs="alpha"
      ;;
      cray-*-*)
        old_platform_supplibs="cray"
      ;;
      i*86-pc-linux-*)
        old_platform_supplibs="linux6"
      ;;
      sparc-sun-solaris*)
        old_platform_supplibs="sol55"
      ;;
      i*86-*-win*)
        old_platform_supplibs="win32"
      ;;
      *-msdos*)
        old_platform_supplibs="msdos"
      ;;
      *-hpux11*)
         old_platform_supplibs="hpux"
      ;;
      *-darwin*)
         old_platform_supplibs="darwin"
      ;;
      *)
         old_platform_supplibs="$host_os"
      ;;
    esac

    for ga_supplib_prefix in $1 ; do 
      SUPPLIBS="${ga_supplib_prefix}/${platform_supplibs}"
      if test -d "${SUPPLIBS}" ; then
        AC_MSG_RESULT([${SUPPLIBS}])
	break
      else
        SUPPLIBS="${ga_supplib_prefix}/${old_platform_supplibs}"
        if test -d "${SUPPLIBS}" ; then
          AC_MSG_RESULT([${SUPPLIBS}])
          break
        else
          # Revert to just plain old "supplibs/" if platform name not found
          SUPPLIBS="${ga_supplib_prefix}/supplibs"
          if test -d "${SUPPLIBS}" ; then
            AC_MSG_RESULT([${SUPPLIBS}])
            break
          fi 
        fi
      fi
    done

    if test ! -d "${SUPPLIBS}" ; then
      AC_MSG_RESULT([not found (defaulting to ./supplibs)])
      SUPPLIBS=supplibs
    fi

    # This is the "official" variable name for use by other macros
    ga_supplib_dir=$SUPPLIBS

    # Add prefix so that Makefiles in subdirectories can find it
    SUPPLIBS='$(top_builddir)/'"$SUPPLIBS"
  fi

  AC_SUBST(SUPPLIBS)
  
])



dnl GA_SET_LIB_VAR : Puts necessary linker options to link with libraries given, into
dnl                  a shell variable. If dynamic linking is enabled, options will
dnl                  have the form '-lname'. If not, they will have the form 
dnl		     'supplib_dir/libname.a'. 
dnl   args:	   : shell-variable-name, list-of-libraries (e.g. [readline termcap])
AC_DEFUN(GA_SET_LIB_VAR,
[
  if test "${ga_dyn_supplibs}" = "yes" ; then
     ga_lib_prefix='-l'
     ga_lib_suffix=''
  else
     ga_lib_prefix='$(supp_lib_dir)/lib'
     ga_lib_suffix='.a'
  fi

  for ga_lib_name in $2 ; do
      $1="$$1 ${ga_lib_prefix}${ga_lib_name}${ga_lib_suffix}"
  done  
])



dnl GA_CHECK_LIB : Checks for the presence of a library. If dynamic linking is 
dnl 		   enabled, just calls AC_CHECK_LIB. If not, checks for the presence
dnl		   of a file "libname.a" in the supplibs directory. 
dnl  args:	   library-name, extra-libs, action-if-found, action-if-not-found
AC_DEFUN(GA_CHECK_LIB,
[
  if test "${ga_dyn_supplibs}" = "yes" ; then
     AC_CHECK_LIB($1, $2, $3, $4)
  else 
     AC_MSG_CHECKING([for lib$1.a in supplibs])
     if test -f "${ga_supplib_dir}/lib/lib$1.a" ; then
     	AC_MSG_RESULT([yes])
	$3
     else 
     	AC_MSG_RESULT([no])
	$4
     fi
  fi

])



dnl GA_CHECK_READLINE : Checks whether GrADS can be built with readline features 
dnl  		      	enabled.
dnl  args : 		action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_READLINE,
[ 
  # Check libs and headers for readline
  GA_SET_FLAGS

  ga_check_readline="no"

  AC_CHECK_HEADER(readline/readline.h,
    [ AC_CHECK_HEADER(readline/history.h, 
      [ AC_SEARCH_LIBS(tgetent, [termcap ncurses],  
      	[ GA_CHECK_LIB(readline, readline, [ga_check_readline="yes"]) 
	])
      ])
    ])

  if test $ga_check_readline = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_GUI : Checks whether GrADS can be built with GUI features 
dnl  		      	enabled.
dnl  args : 		action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_GUI,
[
  # Check libs and headers for GUI widgets
  GA_SET_FLAGS([$X_CFLAGS], [$X_LIBS])

  ga_check_gui="no"
  AC_CHECK_HEADER(freq.h,
  [ AC_CHECK_LIB(Xt,main,
    [ AC_CHECK_LIB(Xaw,main,
      [ AC_CHECK_LIB(Xmu,main,
        [ GA_CHECK_LIB(freq,main,
	  [ GA_CHECK_LIB(sx,main,
	    [ ga_check_gui="yes"
            ])
	  ])
        ])
      ])
    ])
  ])

  if test $ga_check_gui = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_GD : Checks whether GrADS can be built with printim command 
dnl  		      	enabled.
dnl  args : 		action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_GD,
[
  # Check libs and headers for printim (GD interface)
  GA_SET_FLAGS

  ga_check_gd="no"
  AC_CHECK_HEADER(gd.h,
  [ AC_SEARCH_LIBS(tgetstr, [termcap ncurses], 
    [ GA_CHECK_LIB(z, compress, 
      [ GA_CHECK_LIB(png, main, 
      	[ GA_CHECK_LIB(gd, gdImageCreate, 
          [ ga_check_gd="yes"
          ])
	])
      ])
    ])
   ])

  if test $ga_check_gd = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_IMG : Checks whether GrADS can be built with wi command 
dnl  		      	enabled.
dnl  args : 		action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_IMG,
[
  # Check libs and headers for wi (ImageMagick interface)
  GA_SET_FLAGS([$X_CFLAGS], [$X_LIBS])

  ga_check_img="no"
  AC_CHECK_HEADER(magick.h,
  [ AC_CHECK_HEADER(api.h,
    [ GA_CHECK_LIB(jpeg,jpeg_write_scanlines,
      [ AC_CHECK_LIB(Xext, main, 
        [ GA_CHECK_LIB(Magick,main,
          [ ga_check_img="yes"
	  ])
        ])
      ])
    ])
  ])

  if test $ga_check_img = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_NC : Checks whether gradsnc (netCDF-enabled) binary can be built
dnl  args : 	  action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_NC,
[
  # Check libs and headers for netCDF support
  GA_SET_FLAGS([-I{ga_supplib_dir}/include/nc])

  ga_check_nc="no"
  AC_CHECK_HEADER(udunits.h,
  [ AC_CHECK_HEADER(netcdf.h,
    [ GA_CHECK_LIB(udunits, utInit,
      [ GA_CHECK_LIB(netcdf,main,
        [ ga_check_nc="yes"
        ])
      ])
    ])
  ])

  if test $ga_check_nc = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_HDF : Checks whether gradshdf (netCDF/HDF-SDS-enabled) binary 
dnl 		   can be built
dnl  args : 	   action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_HDF,
[
  # Check libs and headers for HDF support
  GA_SET_FLAGS([-I{ga_supplib_dir}/include/hdf])

  ga_check_hdf="no"
  AC_CHECK_HEADER(udunits.h,
  [ AC_CHECK_HEADER(netcdf.h,
    [ GA_CHECK_LIB(z, compress,
      [ GA_CHECK_LIB(udunits, utInit,
        [ GA_CHECK_LIB(jpeg, main,
          [ GA_CHECK_LIB(df,main, 
            [ GA_CHECK_LIB(mfhdf,main,
              [ ga_check_hdf="yes"
              ])
            ])
          ])
        ])
      ])
    ])
  ])

  if test $ga_check_hdf = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])



dnl GA_CHECK_NC : Checks whether gradsdods (OPeNDAP-enabled) binary can be 
dnl 		  built
dnl args :        action-if-yes, action-if-no
AC_DEFUN(GA_CHECK_DODS,
[
  # Check libs and headers for DODS support
  GA_SET_FLAGS([-I{ga_supplib_dir}/include/dods])

  ga_check_dods="no"
  AC_CHECK_HEADER(udunits.h,
  [ AC_CHECK_HEADER(netcdf.h,
    [ GA_CHECK_LIB(z, compress,
      [ GA_CHECK_LIB(udunits, utInit,
        [ GA_CHECK_LIB(rx,main,
          [ GA_CHECK_LIB(www,main,
            [ GA_CHECK_LIB(dap++,main,
              [ GA_CHECK_LIB(nc-dods,main,
                [ ga_check_dods="yes"
		])
              ])
            ])
          ])
        ])
      ])
    ])
  ])

  if test $ga_check_dods = "yes" ; then
    $1 
    true #dummy command
  else
    $2
    true #dummy command
  fi

  GA_UNSET_FLAGS
])

