/*  Copyright (C) 1988-2005 the Institute
                  of Global Environment and Society (IGES).  

    See file COPYRIGHT for more information.   */

/* bufrscan.c written by Joe Wielgosz */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gabufr.h"

#ifndef HAVE_FSEEKO

int fseeko(FILE *stream, off_t offset, int whence) {
  fseek(stream, (long)offset, whence);
}

off_t ftello(FILE *stream) {
  return (off_t)ftell(stream);
}
#endif

enum bufrscan_modes {
  HEADER_MODE = 0,
  DATA_MODE
};

void gabufr_print_dset(gabufr_dset * dset) {
  gabufr_msg * msg;
  gabufr_val * val;
  gabufr_varinf * varinf;
  int i;

  for (msg = dset->msgs; msg != NULL; msg = msg->next) {
    printf("\n\nmsg %d:\n", msg->fileindex);
    for (i = 0; i < msg->subcnt; i++) {
      printf("\nsubset %d:\n", i);
      for (val = msg->subs[i]; val != NULL; val = val->next) {
	printf("%d (%d) [%.3d]    0-%.2d-%.3d     ", msg->fileindex, 
	       i, val->z, val->x, val->y);
	if (val->sval) {
	  printf("[%s]", val->sval);
	} else {
	  if (val->undef) {
	    printf("undef (%g)", val->val);
	  } else {
	    printf("%g", val->val);
	  }	    
	}
	if ( gabufr_valid_varid(0, val->x, val->y)
	     && varinf == gabufr_get_varinf(val->x, val->y)) {
	  printf("\t\t(%s)", varinf->description);
	}
	printf("\n");
      }
    }
  }
}

void help() {
      printf("bufrscan [-h] [-d] tablepath filenames ...\n");
      printf("tablepath: directory containing BUFR decoding tables\n");
      printf("filenames: BUFR messages to be decoded\n");
      printf("-h, --header: print BUFR message headers (default)\n");
      printf("-d, --data: print BUFR message contents \n");
      printf("-?, --help: print this help message\n");
}

int main (int argc, char *argv[]) {
  gabufr_dset * dset;
  int i;
  const char * tablepath = NULL;
  const char * filename = NULL;
  int mode = HEADER_MODE;
  if (argc < 3) {
    help();
  }
  for (i = 1; i < argc; i++) {
    if (! strcmp(argv[i], "-d") || ! strcmp(argv[i], "--data")) {
      mode = DATA_MODE;
    } else if (! strcmp(argv[i], "-h") || ! strcmp(argv[i], "--header")) {
      mode = HEADER_MODE;
    } else if (! strcmp(argv[i], "-?") || ! strcmp(argv[i], "--help")) {
      help();
    } else if (!tablepath) {
	tablepath = argv[i];
	gabufr_set_tbl_base_path(tablepath);
    } else {
      if (mode == HEADER_MODE) {
	dset = gabufr_scan(argv[i]);
	if (! dset) {
	  return GABUFR_ERR;
	}
	gabufr_close(dset);
      } else {
	dset = gabufr_open(argv[i]);
	if (! dset) {
	  return GABUFR_ERR;
	}
	gabufr_print_dset(dset);
	
	gabufr_close(dset);
      }
    }	   
  }
}
