#!/bin/sh

##################################################
#
#  do_all.sh -
#
#	make three versions of grads using the config.sh script
#
#	the name of the grads binaries are set to coordinate with
#	the tar.dist.bin.sh script created by config.sh
#
# REVISION HISTORY:
#
# 29Apr98  da Silva  By default gradsc and gradshdf are now
#                    built with ImageMagick support;
#                    gradsc still isn't.
# 24oct01  da Silva  Added options -donc, -dohdf, -doc for creating
#                    only one set of binaries
#
#
##################################################



##################################################
#
#	intialization
#
##################################################

mach="none"                    # name of machine
site="none"                    # name of site
RMDIR="-i"                     # rm option
makeopt="-nomake"              # make option - KEEP THIS!!!!
RMDIR="-f"                     # rm option
noimg=""                       # build with IM support
gxpng="-gxpng"                 # change to "-nogxpng" to make default w/o

doimg=""

dods=1  # whether to create gradsdods
target="all"  # creates gradsc, gradsnc and gradshdf


##################################################
#
#	subroutines
#		
#		lshelp - how to use
#		rmobj - delete .o files that need to be recompiled
#
##################################################

:
lshelp() { 

echo " "
echo " GrADS Make Script -- create one or all three versions of GrADS:"
echo " "
echo " gradsnc   - unidata netCDF, LATS, GUI, SDF [wi image output]"
echo " gradshdf  - NCSA netCDF HDF, LATS, GUI, SDF"
echo " gradsc    - classic GrADS - NO LATS/GUI/SDF; readline only  "
echo " grads     - link to gradshdf (32-bit) or gradsc (64-bit)"
echo " "
echo "Usage: do_all.sh -arch=PLATFORM [ -site=SITE ] [ -noimg ]"
echo "         [-dodods] [-nodods] [-donc] [-dohdf] [-doc] [-dou] "
echo " "
echo "   PLATFORM = win32 | win32e | msdos | sunos4 | sol2 | "
echo "              irix4 (SGI) | irix5 (SGI) | irix6 (SGI)"
echo "              linux | hpux | alpha | aix (IBM) | nec | c90 | j90" 
echo "       SITE = where you are located for local settings (e.g., llnl)"
echo "      -noimg = do no build with image output tools"
echo "      -donc = creates gradsnc ONLY"
echo "      -dodods = creates gradsdods ONLY"
echo "      -nodods = do not attempt to build gradsdods"
echo "      -dohdf = creates gradshdf ONLY"
echo "      -doc = creates gradsc ONLY"
echo "      -dou = create GX utils ONLY (gxtran, gxeps, etc.)"
###echo "      -gxpng = build GXPNG code into GrADS for framebufferless grfx output"
###echo "      -nogxpng = don't bother"
###echo "     -imgxa = link in XA image output tools"
###echo "     -imgim = link in ImageMagick image output tools"
echo " "

}

:
rmobj() {
#
#  routines with general compile directives
#
rm $RMDIR grads.o 
rm $RMDIR gacfg.o
rm $RMDIR gaddes.o
rm $RMDIR gaio.o
rm $RMDIR gauser.o
rm $RMDIR gagx.o
rm $RMDIR gasdf.o
rm $RMDIR gaimg.o

#
#  routines with win32 compile directives
#
rm $RMDIR gafunc.o
rm $RMDIR gxX.o  
rm $RMDIR gautil.o

#
#  routines with alpha directives
#
rm $RMDIR gxdxwd.o

#
#  routines with LATS compile directives
#
rm $RMDIR latsnc.o

}

:
do_nc() {

##################################################
#
# NetCDF GrADS =
#	  LATS, netcdf or dods, sdf, gui, readline, wi
#
##################################################

rmobj
echo "---"
echo "config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -gradsbin=gradsnc"
echo "---"
config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -gradsbin=gradsnc 
make gx

}

:
do_dods() {

##################################################
#
# NetCDF GrADS =
#	  LATS, netcdf or dods, sdf, gui, readline, wi
#
##################################################

if [ "$dods" -eq 0 ]; then
     echo "Skipping DODS enabled binaries..."
     dodsbin=""
     return
fi

rmobj
dodsbin="gradsdods"
echo "---"
echo "config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -dods -gradsbin=gradsnc"
echo "---"
config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -dods -gradsbin=$dodsbin
make gx

}

:
do_hdf() {

##################################################
#
# HDF GrADS =
#          LATS, MFHDF, sdf, gui, readline, wi
#
##################################################

rmobj
 echo "---"
 echo config.sh -arch=$mach -site=$site -hdf $makeopt $noimg $gxpng -gradsbin=gradshdf
 echo "---"
 config.sh -arch=$mach -site=$site -hdf $makeopt $noimg $gxpng -gradsbin=gradshdf 
 make gx

}

:
do_classic() {

##################################################
#
#	Classic GrADS =
#			readline only
#
##################################################

rmobj

echo "---"
echo "config.sh -arch=$mach -site=$site -nogui -nolats -nosdf -noimg $gxpng $makeopt -gradsbin=gradsc"
echo "---"
config.sh -arch=$mach -site=$site -nogui -nolats -nosdf -noimg $gxpng $makeopt -gradsbin=gradsc 
make gx

}

:
do_utils() {

##################################################
#
# GrADS Utilities = gxeps, gxtran, etc
#
##################################################

rmobj
echo "---"
echo "config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -gradsbin=gradsnc"
echo "---"
config.sh -arch=$mach -site=$site $makeopt $noimg $gxpng -gradsbin=gradsnc 
make gxutils GAPREFIX=

}

:
do_tarball() {

##################################################
#
# Creates distribution tarball
#
##################################################

if [ "$mach" = "win32" -o "$mach" = "win32e" ] ; then
   echo "Run w32_dist.csh for creating Win32 distribution"
else
   echo "Creating distribution tarball $tarball..."
   tarball="GrADS`cat VERSION`.$mach.tar"
   gxbins="gradsc gradshdf gradsnc $dodsbin"
   gxutil="gribscan gribmap stnmap gxps gxtran wgrib gxeps"
   /bin/rm -f $tarball.Z
   tar cvf  $tarball INSTALL $gxbins $gxutil
   compress -v $tarball
fi

}

##################################################
#
#	Main Driver
#
##################################################

# parse command line
# ------------------
for arg in $* ; do
    case $arg in
        -arch=*)
	    mach=`echo $arg | sed -e 's/-arch=//'`
        ;;
	-site=*)
	    site=`echo $arg | sed -e 's/-site=//'`
	;;
	-noimg)
	    noimg="-noimg";
        ;;
	-gxpng)
	    gxpng="-gxpng";
	;;
        -nogxpng)
	    gxpng="-nogxpng"
        ;;
        -dodods)
 	    target="gradsdods"
	    dods=1
	;;
        -nodods)
	    dods=0
	;;
        -donc)
	   target="gradsnc"
	;;
        -dohdf)
	   target="gradshdf"
	;;
        -doc)
	   target="gradsc"
	;;
        -dou)
	   target="gxutils"
	;;
###	-imgxa)
###	    doimg="-imgxa";
###	;;
###	-imgim)
###	    doimg="-imgim";
###	;;
	*)
            lshelp $0
            echo "CCCCCCCC:  Specify PLATFORM with -arch=PLATFORM"
            exit 0
        ;;
    esac
done

if [ "$mach" = "none" ] ; then
    lshelp $0
    echo "Specify PLATFORM with -arch=PLATFORM"
    exit 1
fi

# Configure and compile GrADS for each target

if [ "$target" = "all" ] ; then
      make distclean
      do_classic
      do_nc
      do_dods
      do_hdf
      do_utils
      do_tarball
elif [ "$target" = "gradsc" ] ; then
      do_classic
elif [ "$target" = "gradsnc" ] ; then
      do_nc
elif [ "$target" = "gradsdods" ] ; then
      do_dods
elif [ "$target" = "gradshdf" ] ; then
      do_hdf
elif [ "$target" = "gxutils" ] ; then
      do_utils
fi

exit
