/*  Copyright (C) 1988-2005 by Brian Doty and the Institute
                  of Global Environment and Society (IGES).  

    See file COPYRIGHT for more information.   */

/* 
 * Include ./configure's header file
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* file: gacfg.c
 *
 *   Prints the configuration options of this build of GrADS.
 *   This function is invoked at startup and with 'q config'.
 *
 *   REVISION HISTORY:
 *
 *   09sep97   da Silva   Initial code.
 *   12oct97   da Silva   Small revisions, use of gaprnt().
 *   15apr98   da Silva    Added BUILDINFO stuff, made gacfg() void. 
 *   24jun02   K Komine   Added 64-bit mode . 
 *
 *   --
 *   (c) 1997 by Arlindo da Silva
 *
 *   Permission is granted to any individual or institution to use,
 *   copy, or redistribute this software so long as it is not sold for
 *   profit, and provided this notice is retained. 
 *
 */

#include <stdio.h>
#include "grads.h"
#include "buildinfo.h"

/*
 * gacfg() - Prints several configuration parameters. 
 *
 *           verbose = 0   only config string
 *                   = 1   config string + verbose description
 *                   > 1   no screen display.
 */
void
gacfg(int verbose)
{

char cmd[1024];

/* Config: v1.7b2,32-bit,little-endian,readline,NetCDF,sdf/xdf,lats,athena */

sprintf(cmd,"Config: v%s",GRADS_VERSION);

if(GRADS_CRAY)  strcat(cmd," 64-bit,cray");
/*kk 020624 --- s */
else if (GRADS_HP64) strcat(cmd," 64-bit,hpux11");
/*kk 020624 --- e */
else            strcat(cmd," 32-bit");

if(BYTEORDER)   strcat(cmd," big-endian");
else            strcat(cmd," little-endian");

if(READLINE)    strcat(cmd," readline");

if(USESDF) {
                strcat(cmd," sdf/xdf");
  if(USEHDF)    strcat(cmd," hdf-sds netcdf");
  else          strcat(cmd," netcdf");
  if(USEDODS) strcat(cmd, " dods");
  if (USEGADODS) strcat(cmd, " dods-stn");
}
if(USELATS)     strcat(cmd," lats");
if(USEGUI)      strcat(cmd," athena");
if(USEIMG == 2) strcat(cmd," xa/image-output");
if(USEIMG == 1) strcat(cmd," im/image-output");
if(GXPNG)       strcat(cmd," printim");

strcat(cmd,"\n\n");
gaprnt(verbose,cmd);
if (verbose==0)
       printf ("Issue 'q config' command for more information.\n\n");

if (verbose == 0) return;

gaprnt (verbose, "Grid Analysis and Display System (GrADS) Version " GRADS_VERSION "\n");
gaprnt (verbose, "Copyright (c) 1988-2005 by Brian Doty and IGES\n");
gaprnt (verbose, "Center for Ocean-Land-Atmosphere Studies (COLA)\n");
gaprnt (verbose, "Institute for Global Environment and Society (IGES) \n");
gaprnt (verbose, "This program is distributed WITHOUT ANY WARRANTY \n");
gaprnt (verbose, "See file COPYRIGHT for more information. \n\n");

gaprnt (verbose, buildinfo );

gaprnt(verbose,"\n\nThis version of GrADS has been configured with the following options:\n\n");

if(!GRADS_CRAY) {
  if(BYTEORDER) {
    sprintf (cmd,"   o This is a 32-bit BIG ENDIAN machine version.\n");
  } else {
    sprintf (cmd,"   o This is a 32-bit LITTLE ENDIAN machine version.\n");
  }
} else {
  sprintf (cmd,"   o This is a 64-bit BIG ENDIAN machine version (Cray).\n");
}
  gaprnt(verbose,cmd);

if(READLINE)
  sprintf(cmd,"   o Command line editing (readline) ENABLED.\n");
else
  sprintf(cmd,"   o Command line editing (readline) DISABLED.\n");
  gaprnt(verbose,cmd);

if(USESDF) {
  sprintf(cmd,"   o CIRES/CDC (http://www.cdc.noaa.gov) SDF/XDF interface ENABLED.\n");
  gaprnt(verbose,cmd);
  if(USEHDF) 
    sprintf(cmd,"     Use sdfopen or xdfopen to read both NetCDF and HDF-SDS files.\n"
                "   o DTYPE netcdf and DTYPE hdfsds are ENABLED.\n");
  else
    sprintf(cmd,"     Use sdfopen/xdfopen to read NetCDF files.\n"
                "   o DTYPE netcdf is ENABLED; DTYPE hdfsds is DISABLED.\n");
    gaprnt(verbose,cmd);
} 
else { /* no USESDF */
  sprintf(cmd,"   o CIRES/CDC (http://www.cdc.noaa.gov) SDF/XDF interface DISABLED. \n"
	      "     This version is NOT configured to read NetCDF/HDF-SDS files.\n"
	      "   o DTYPE netcdf and DTYPE hdfsds are DISABLED.\n");
   gaprnt(verbose,cmd);
}

if(USEDODS) {
        gaprnt(verbose,"   o OPeNDAP (a.k.a. DODS) gridded data interface ENABLED. (http://opendap.org)\n");
        gaprnt(verbose,"     This version is configured to access gridded data on OPeNDAP servers \n");
        gaprnt(verbose,"     via the sdfopen or xdfopen commands, or using DTYPE netcdf.\n");
} else {
        gaprnt(verbose,"   o OPeNDAP (a.k.a. DODS) gridded data interface DISABLED.\n");
}

if(USEGADODS) {
        gaprnt(verbose,"   o OPeNDAP (a.k.a. DODS) station data interface (gadods) ENABLED.\n");
        gaprnt(verbose,"     This version is configured to access station data on OPeNDAP servers \n");
        gaprnt(verbose,"     via the open command.\n");
} else {
        gaprnt(verbose,"   o OPeNDAP (a.k.a. DODS) station data interface DISABLED.\n");
}


if(USELATS) {
        sprintf(cmd,"   o PCMDI (http://www-pcmdi.llnl.gov) LATS interface ENABLED.\n"
		    "     This version is configured to write ");
        gaprnt(verbose,cmd);
  if(USESDF) {
     if(USEHDF) 
        sprintf(cmd,"GRIB and HDF-SDS files.\n");
     else
        sprintf(cmd,"GRIB and NetCDF files.\n");
     gaprnt(verbose,cmd);
  } 
  else  {
       sprintf(cmd,"GRIB files (but no NetCDF/HDF files).\n");
       gaprnt(verbose,cmd);
  }
} 

else {  /* No USELATS */
        sprintf(cmd,"   o PCMDI (http://www-pcmdi.llnl.gov) LATS interface DISABLED.\n"
		    "     This version is NOT configured to write GRIB, NetCDF, or HDF-SDS files.\n");  
        gaprnt(verbose,cmd);
}

if(USEGUI)
    sprintf(cmd,"   o DAO (http://dao.gsfc.nasa.gov) Athena Widget GUI ENABLED.\n ");
else
    sprintf(cmd,"   o DAO (http://dao.gsfc.nasa.gov) Athena Widget GUI DISABLED.\n ");
gaprnt(verbose,cmd);

if(USEIMG == 2)
    sprintf(cmd,"  o NRL/PCMDI XA Image Output ENABLED.\n"
	        "    Use \"wi filename format\" to output X window to an image file\n");
else if(USEIMG == 1)
    sprintf(cmd,"  o DAO/PCMDI ImageMagick Image Output ENABLED.\n"
	        "    Use \"wi filename.format (gif,jpeg,etc)\" to output X window to an image file\n");
else
    sprintf(cmd,"  o NRL/DAO/PCMDI XA or ImageMagick Image Output DISABLED.\n ");
gaprnt(verbose,cmd);

if (GXPNG) {
  gaprnt(verbose,"  o printim command for direct png/gif output ENABLED.\n");
  gaprnt(verbose,"     (via the GD Library -- http://www.boutell.com/gd)\n");
} else {
  gaprnt(verbose,"  o printim command DISABLED\n");
}

sprintf(cmd,
       "\nFor additional information please consult http://grads.iges.org/grads/\n\n");
gaprnt(verbose,cmd);

}


/* --------------------------------------------------------------*/
#ifdef TEST

void gaprnt ( int mode, char *cmd )
{
   if ( mode < 2 ) printf("%s",cmd);
}

main(int argc, char **argv )
{

gacfg(1);

}

#endif /* TEST */



