/*  Copyright (C) 1988-2005 by Brian Doty and the Institute
                  of Global Environment and Society (IGES).  

    See file COPYRIGHT for more information.   */

/* Authored by B. Doty */

/* kk 020624 ---  Change for 64bit seek K.Komine */

#ifdef HAVE_CONFIG_H
#include <config.h>

/* If autoconfed, only include malloc.h when it's present */
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif

#else /* undef HAVE_CONFIG_H */

#include <malloc.h>

#endif /* HAVE_CONFIG_H */


#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "grads.h"

/*mf 961205 --- expose Mike Fiorino's global struct to these routines for 365 day calandars mf*/
extern struct gamfcmn mfcmn;
/*mf 961205 --- expose Mike Fiorino's global struct to these routines for 365 day calandars mf*/

static char pout[512];
static FILE *pdfi;       /* File descriptor for pdef file */

FILE *descr;      /* File descriptor pointer */
                  /* Also used, via extern, by gasdf.c */

void ll2eg (int , int, float *, float, float, float *, float *, float *) ;
void ll2pse(int, int, float *, float, float, float *, float *);
void ll2ops (float *, float , float , float *, float *) ;


/* Read a GrADS data descriptor file and fill in the information
   into a gafile structure.  The gafile structure should be
   allocated and must be initialized by getpfi.  If this routine
   returns an error, release the pfi structure and allocated
   storage via frepfi.  mflag indicates whether to read the
   stnmap/index file; if this routine is being called to
   preprocess the dd file then this flag should be 0. 
   A mflag value of 2 will check if the stnmap/index file can be
   opened, but will not read it; mflag==2 will also turn off 
   calculation of the pdef interpolation values */

int gaddes (char *name, struct gafile *pfi, int mflag) {
  struct gavar *pvar,*pvar2;
  struct dt tdef,tdefi,dt1,dt2;
  struct gaindx *pindx;
  struct gaattr *attrib, *testattr;
  struct gachsub *pchsub;
  float *vals;
  int size=0,rc,len,swpflg,cnt,flag,tim1,tim2;
  char rec[512], mrec[512], *ch, *pos, *sname, *vectorpairs, *pair;
  int flgs[8],cflg,i,j,ii,jj,err,hdrb,trlb,mflflg;
  int mcnt,maxlv,foundvar1,foundvar2;
  off_t levs,acum,acumvz,recacm;
  float temp,v1,v2;
  FILE *mfile;
  char pdefnm[256],var1[256],var2[256];
  char *varname,*attrname,*attrtype,attrvalue[512];
  int pdefop1=0, pdefop2=0;
  int nzstride=0,first=1;
  int levsua=0,acumstride=0,npairs;
  unsigned char vermap;
  int idum,reclen;
  float fdum;
  unsigned char urec[4];
  int diag=0;
#if GRADS_CRAY == 1
  int crayflg=0;
#endif

  static char *errs[9] = {"XDEF","YDEF","ZDEF","TDEF","UNDEF",
			    "DSET","VARS","TITLE","DTYPE"};

 /*mf --- define here vice grads.c for cdunif.c mf*/
  mfcmn.fullyear=-999; 

  /* initialize variables */
  hdrb = 0;
  trlb = 0;
  pdfi = NULL;
  mflflg = 0;		
  mfile = NULL;
  pfi->mfile = NULL;
  mcnt = -1;
  vectorpairs = NULL;
  pair = NULL;
  varname = attrname = attrtype = NULL;
  attrib = NULL;
  sname=NULL;

  /* Try to open descriptor file */
  descr = fopen (name, "r");
  if (descr == NULL) {
    /* Try adding default suffix of .ctl */
    sname = (char *)malloc(strlen(name)+5);
    if(sname == NULL) {
      gaprnt(0,"malloc error in creating date descriptor file name\n");
      return(1);
    }
    for(i=0;i<=strlen(name);i++) *(sname+i)=*(name+i);
    strcat(sname,".ctl");
    descr = fopen (sname, "r");
  }

  /* If still can't open descriptor file, give up */
  if (descr == NULL) {
    gaprnt (0,"Open Error:  Can't open description file\n");
    if (sname) free (sname);
    return(1);
  }

  /* Copy descriptor file name into gafile structure */
  if (sname != NULL) {
    getwrd (pfi->dnam,sname,512);
    free(sname);
  } else {
    getwrd (pfi->dnam,name,512);
  }

  /* initialize error flags */
  for (i=0;i<8;i++) flgs[i] = 1;

  /* Parse the data descriptor file */
  while (fgets(rec,512,descr)!=NULL) {

    /* Remove any leading blanks from rec */
    reclen = strlen(rec);
    jj = 0;
    while (jj<reclen && rec[0]==' ') {
      for (ii=0; ii<reclen; ii++) rec[ii] = rec[ii+1];
      jj++;
    }

    /* Keep mixed case and lower case versions of rec handy */
    strcpy (mrec,rec);   
    lowcas(rec);

    if ( (cmpwrd("*",rec)) || (cmpwrd("#",rec)) || !isalnum(rec[0]) ) {
      cflg = 1;  
      /* Parse comment if it contains attribute metadata */
      if ((strncmp("*:attr",mrec,6)==0) || (strncmp("@",mrec,1)==0)) {
      	if ((ddfattr(mrec,pfi)) == -1) goto retrn;
      }

    } else if (cmpwrd("byteswapped",rec)) {
      pfi->bswap = 1;

    } else if (cmpwrd("fileheader",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing fileheader length\n");
      } else {
        ch = longprs(ch,&(pfi->fhdr));
        if (ch==NULL) {
          gaprnt (1,"Fileheader record invalid\n");
          pfi->fhdr = 0;
        }
      }

    } else if (cmpwrd("xyheader",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing xy grid header length\n");
      } else {
        ch = longprs(ch,&(pfi->xyhdr));
        if (ch==NULL) {
	  gaprnt (1,"xy grid header length invalid\n");
	  pfi->xyhdr = 0;
        } else {
	  pfi->xyhdr = pfi->xyhdr / sizeof(float);
	}
      }

    } else if (cmpwrd("unpack",rec)) {
      if ( (ch=nxtwrd(mrec))==NULL ) {
        gaprnt (1,"Descriptor File Warning: Missing attribute names in unpack record\n");
      } else {
	/* get the scale factor attribute name */
	len = 0;
	while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
	pfi->scattr = (char *)malloc(len+3);
	for (i=0; i<len; i++) *(pfi->scattr+i) = *(ch+i);
	*(pfi->scattr+len) = '\0';
	/* set the packflg to 1, meaning only scale factor has been retrieved */
	pfi->packflg = 1;
	
	/* get the offset attribute name */
	if ( (ch=nxtwrd(ch)) == NULL ) {
	  gaprnt (2,"Descriptor File Warning: No offset attribute name in unpack record\n");
	} else {
	  len = 0;
	  while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
	  pfi->ofattr = (char *)malloc(len+3);
	  for (i=0; i<len; i++) *(pfi->ofattr+i) = *(ch+i);
	  *(pfi->ofattr+len) = '\0';
	  /* Set the packflg to 2, meaning scale factor and offset have been retrieved */
	  pfi->packflg = 2;
	}
      }
      
    } else if (cmpwrd("theader",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing time chunk header length\n");
      } else {
        ch = longprs(ch,&(pfi->thdr));
        if (ch==NULL) {
          gaprnt (1,"time chunk grid header length invalid\n");
          pfi->thdr = 0;
        } else {
	  pfi->thdr = pfi->thdr / sizeof(float);
	}
      }

    } else if (cmpwrd("format",rec) || cmpwrd("options",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing options keyword\n");
      } else {
        while (ch!=NULL) {
          if (cmpwrd("sequential",ch)) pfi->seqflg = 1;
          else if (cmpwrd("yrev",ch)) pfi->yrflg = 1;
          else if (cmpwrd("zrev",ch)) pfi->zrflg = 1;
          else if (cmpwrd("template",ch)) pfi->tmplat = 1;
          else if (cmpwrd("byteswapped",ch)) pfi->bswap = 1;
          else if (cmpwrd("cray_32bit_ieee",ch) && GRADS_CRAY) pfi->cray_ieee = 1;
          else if (cmpwrd("cray_32bit_ieee",ch) && !GRADS_CRAY) pfi->cray_ieee = 0;
          else if (cmpwrd("365_day_calendar",ch)) {
	    pfi->calendar=1;
	    mfcmn.cal365=pfi->calendar;
	  }
/* ----> Kagimoto */
           else if (cmpwrd("360_day_calendar",ch)) {
             pfi->calendar=2;
             mfcmn.cal360=1;
             setup_360_day_calendar();
           }
/* <---- Kagimoto */	  
          else if (cmpwrd("big_endian",ch)) {
	    if (!BYTEORDER) pfi->bswap = 1;
          }
          else if (cmpwrd("little_endian",ch)) {
            if (BYTEORDER) pfi->bswap = 1;
          }
	  else {
	    gaprnt (0,"Open Error:  Data file type invalid\n");
	    goto err9;
          }
          ch = nxtwrd(ch);
        }
      }

    } else if (cmpwrd("trailerbytes",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Trailerbytes record invalid\n");
      } else {
        ch = intprs(ch,&trlb);
        if (ch==NULL) {
          gaprnt (1,"Trailerbytes record invalid\n");
          trlb = 0;
        } else {
          trlb = trlb/4;
        }
      }


    } else if (cmpwrd("headerbytes",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Headerbytes record invalid\n");
      } else {
        ch = intprs(ch,&hdrb);
        if (ch==NULL) {
          gaprnt (1,"Headerbytes record invalid\n");
          hdrb = 0;
        } else {
          hdrb = hdrb/4;
        }
      }

    /* Handle the chsub records.  time1, time2, then a string,  multiple times */
    } else if (cmpwrd("chsub",rec)) {

      pchsub = pfi->pchsub1;    /* point to first block in chain */
      if (pchsub) {
        while (pchsub->forw!=NULL) {
          pchsub = pchsub->forw;       /* advance to end of chain */
        }
      }
      flag = 0;
      ch = mrec;
      while (1) {
        if ( (ch=nxtwrd(ch)) == NULL ) break;
        flag = 1;
        if ( (ch = intprs(ch,&tim1)) == NULL) break;
        if ( (ch=nxtwrd(ch)) == NULL ) break;
        if (*ch=='*' && (*(ch+1)==' '||*(ch+1)=='\t')) tim2 = -99;
        else if ( (ch = intprs(ch,&tim2)) == NULL) break;
        if ( (ch=nxtwrd(ch)) == NULL ) break;
        flag = 0;
        if (pchsub) {
          pchsub->forw = (struct gachsub *)calloc(1,sizeof(struct gachsub));
          if (pchsub->forw==NULL) goto err8;
          pchsub = pchsub->forw;
        } else {
          pfi->pchsub1 = (struct gachsub *)calloc(1,sizeof(struct gachsub));
          if (pfi->pchsub1==NULL) goto err8;
          pchsub = pfi->pchsub1;
        }
        len = wrdlen(ch);
        pchsub->ch = (char *)malloc(len+1);
        if (pchsub->ch==NULL) goto err8;
        getwrd(pchsub->ch,ch,len);
        pchsub->t1 = tim1;
        pchsub->t2 = tim2;
      }
      if (flag) {
        gaprnt (1,"Description file warning: Invalid chsub record; Ignored\n");
      }

    } else if (cmpwrd("dtype",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing data type\n");
        gaprnt (1,"   Assuming data file type is grid\n");
      }
      if (cmpwrd("station",ch)) {
        pfi->type = 2;
        flgs[0] = 0;
        flgs[1] = 0;
        flgs[2] = 0;

      } else if (cmpwrd("bufr",ch)) {
	pfi->type = 2;    /* station data type */
	mflag = 0;        /* don't try to read a stnmap file */
	pfi->bufrflg = 1; 
        flgs[0] = 0;
        flgs[1] = 0;
        flgs[2] = 0;
	/* allocate memory for the bufrinfo structure and the two bufrtimeinfo structures */
	pfi->bufrinfo = (struct bufrinfo *)malloc(sizeof(struct bufrinfo));
	/* initialize with bad values */
	for (j=0;j<2;j++) {
	  pfi->bufrinfo->lonxy[j] = pfi->bufrinfo->latxy[j] = -999;;
	  pfi->bufrinfo->levxy[j] = pfi->bufrinfo->stidxy[j] = -999;;
	  pfi->bufrinfo->base.yrxy[j] = pfi->bufrinfo->base.moxy[j] = -999;;
	  pfi->bufrinfo->base.dyxy[j] = pfi->bufrinfo->base.hrxy[j] = -999;;
	  pfi->bufrinfo->base.mnxy[j] = pfi->bufrinfo->offset.yrxy[j] = -999;;
	  pfi->bufrinfo->offset.moxy[j] = pfi->bufrinfo->offset.dyxy[j] = -999;;
	  pfi->bufrinfo->offset.hrxy[j] = pfi->bufrinfo->offset.mnxy[j] = -999;;
	}

      } else if (cmpwrd("grib",ch)) {
        pfi->idxflg = 1;
        if ( (ch=nxtwrd(ch))!=NULL ) {
          if ( intprs(ch,&(pfi->grbgrd))==NULL) {
            gaprnt (1,"Description file warning: Invalid GRIB option\n");
            pfi->grbgrd = -999;
          }
        }
      } 
#if USESDF ==1
      else if (cmpwrd("netcdf",ch)) pfi->ncflg = 1;
#if USEHDF ==1
      else if (cmpwrd("hdfsds",ch)) pfi->ncflg = 2;
#endif
#endif
      else {
        gaprnt (0,"Open Error:  Data file type invalid\n");
        goto err9;
      }

    } else if (cmpwrd("xvar",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pair for XVAR entry\n");
      } else {
        j = 0;
        while (1) {
 	  if ( (ch=intprs(ch,&(pfi->bufrinfo->lonxy[j])))==NULL ) goto err6a;
          while (*ch==' ') ch++;
          if (*ch!=',') break;
          ch++;
          while (*ch==' ') ch++;
          j++;
          if (j>1) goto err6a;
        }
	if (pfi->bufrinfo->lonxy[0]==-999 || pfi->bufrinfo->lonxy[1]==-999) goto err6a;
      }
  
    } else if (cmpwrd("yvar",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pair for YVAR entry\n");
      } else {
        j = 0;
        while (1) {
 	  if ( (ch=intprs(ch,&(pfi->bufrinfo->latxy[j])))==NULL ) goto err6a;
          while (*ch==' ') ch++;
          if (*ch!=',') break;
          ch++;
          while (*ch==' ') ch++;
          j++;
          if (j>1) goto err6a;
        }
	if (pfi->bufrinfo->latxy[0]==-999 || pfi->bufrinfo->latxy[1]==-999) goto err6a;
      }
  
    } else if (cmpwrd("zvar",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pair for ZVAR entry\n");
      } else {
        j = 0;
        while (1) {
 	  if ( (ch=intprs(ch,&(pfi->bufrinfo->levxy[j])))==NULL ) goto err6a;
          while (*ch==' ') ch++;
          if (*ch!=',') break;
          ch++;
          while (*ch==' ') ch++;
          j++;
          if (j>1) goto err6a;
        }
	if (pfi->bufrinfo->levxy[0]==-999 || pfi->bufrinfo->levxy[1]==-999) goto err6a;
      }
  
    } else if (cmpwrd("tvar",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pairs for TVAR entry\n");
      } else {
	while (nxtwrd(ch)!=NULL) {
	  if (cmpwrd("yr",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR yr entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.yrxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.yrxy[0]==-999 || pfi->bufrinfo->base.yrxy[1]==-999) goto err6a;
	    }

	  } else if (cmpwrd("mo",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR mo entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.moxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.moxy[0]==-999 || pfi->bufrinfo->base.moxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("dy",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR dy entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.dyxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.dyxy[0]==-999 || pfi->bufrinfo->base.dyxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("hr",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR hr entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.hrxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.hrxy[0]==-999 || pfi->bufrinfo->base.hrxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("mn",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR mn entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.mnxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.mnxy[0]==-999 || pfi->bufrinfo->base.mnxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("sc",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TVAR sc entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->base.scxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->base.scxy[0]==-999 || pfi->bufrinfo->base.scxy[1]==-999) goto err6a;
	    }
	  } else {
	    goto err6a;
	  }
	} /* end of while loop */
      }

    } else if (cmpwrd("toffvar",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pairs for TOFFVAR entry\n");
      } else {
	while (nxtwrd(ch)!=NULL) {
	  if (cmpwrd("yr",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR yr entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.yrxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.yrxy[0]==-999 || pfi->bufrinfo->offset.yrxy[1]==-999) goto err6a;
	    }

	  } else if (cmpwrd("mo",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR mo entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.moxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.moxy[0]==-999 || pfi->bufrinfo->offset.moxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("dy",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR dy entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.dyxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.dyxy[0]==-999 || pfi->bufrinfo->offset.dyxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("hr",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR hr entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.hrxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.hrxy[0]==-999 || pfi->bufrinfo->offset.hrxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("mn",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR mn entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.mnxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.mnxy[0]==-999 || pfi->bufrinfo->offset.mnxy[1]==-999) goto err6a;
	    }
	  } else if (cmpwrd("sc",ch)) {
	    if ((ch=nxtwrd(ch))==NULL) {
	      gaprnt (1,"Description file warning: Missing x,y pair for TOFFVAR sc entry\n");
	    } else {
	      j = 0;
	      while (1) {
		if ( (ch=intprs(ch,&(pfi->bufrinfo->offset.scxy[j])))==NULL ) goto err6a;
		while (*ch==' ') ch++;
		if (*ch!=',') break;
		ch++;
		while (*ch==' ') ch++;
		j++;
		if (j>1) goto err6a;
	      }
	      if (pfi->bufrinfo->offset.scxy[0]==-999 || pfi->bufrinfo->offset.scxy[1]==-999) goto err6a;
	    }
	  } else {
	    goto err6a;
	  }
	} /* end of while loop */
      }

    } else if (cmpwrd("stid",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"Description file warning: Missing x,y pair for STID entry\n");
      } else {
        j = 0;
        while (1) {
 	  if ( (ch=intprs(ch,&(pfi->bufrinfo->stidxy[j])))==NULL ) goto err6a;
          while (*ch==' ') ch++;
          if (*ch!=',') break;
          ch++;
          while (*ch==' ') ch++;
          j++;
          if (j>1) goto err6a;
        }
	if (pfi->bufrinfo->stidxy[0]==-999 || pfi->bufrinfo->stidxy[1]==-999) goto err6a;
      }

    } else if (cmpwrd("title",rec)) {
      if ( (ch=nxtwrd(mrec))==NULL ) {
        gaprnt (1,"Description file warning: Missing title string\n");
      } else {
        getstr (pfi->title,ch,512);
        flgs[7] = 0;
      }

    } else if (cmpwrd("dset",rec)) {
      ch = nxtwrd(mrec);
      if (ch==NULL) {
        gaprnt (0,"Descriptor File Error:  Data file name is missing\n");
        goto err9;
      }
      if (*ch=='^' || *ch=='$') {
        fnmexp (pfi->name,ch,name);
      } else {
        getwrd (pfi->name,ch,512);
      }
      flgs[5] = 0;

    } else if (cmpwrd("stnmap",rec) || cmpwrd("index",rec)) {
      /* map file processing */
      if (cmpwrd("index",rec)) pfi->idxflg = 1;
      ch = nxtwrd(mrec);
      if (ch==NULL) {
        gaprnt (0,"Open Error:  Station or Index Map file name is missing\n");
        goto err9;
      }
      if (*ch=='^' || *ch=='$') {
        fnmexp (pout, ch, name);
      } else {
        getwrd (pout, ch, 500);  
      }
      len = 0;
      while (*(pout+len)) len++;
      pfi->mnam = (char *)malloc(len+3);
      if (pfi->mnam==NULL) goto err8;
      strcpy (pfi->mnam,pout);

      if (mflag) {
        mfile = fopen (pout, "rb");
        if (mfile==NULL) {
          gaprnt (0,"Open Error:  Can't open Station/Index map file ");
          gaprnt (0,pout);
          gaprnt (0,"\n");
          goto err9;
        }
	
        if (mflag==2) goto skipread;

        mflflg = 1;
        swpflg = 0;

     /* GRIB data - load the map INDEX data */

        if (pfi->idxflg && pfi->type != 2) {

          pindx = (struct gaindx *)malloc(sizeof(struct gaindx));
          if (pindx==NULL) goto err8;
          pfi->pindx = pindx;

	  /*  check the version number */
	  fseek(mfile,1,0);
	  fread(&vermap,sizeof(unsigned char),1,mfile);
	  if(diag) printf("ddd gribmap vermap =%d\n",vermap);

	  if(vermap == 2) {

	    fseek(mfile,2,0);
	    fread(mrec,sizeof(unsigned char),4,mfile);
	    pindx->hinum=gagby(mrec,0,4);
	    if(diag) printf("ddd  hinum = %d\n",pindx->hinum);

	    fread(mrec,sizeof(unsigned char),4,mfile);
	    pindx->hfnum=gagby(mrec,0,4);
	    if(diag) printf("ddd hfnum = %d\n",pindx->hfnum);

	    fread(mrec,sizeof(unsigned char),4,mfile);
	    pindx->intnum=gagby(mrec,0,4);
	    if(diag) printf("ddd intnum = %d\n",pindx->intnum);

	    fread(mrec,sizeof(unsigned char),4,mfile);
	    pindx->fltnum=gagby(mrec,0,4);
	    if(diag) printf("ddd fltnum = %d\n",pindx->fltnum);

	    /* skip the begining time struct info */
	    fread(mrec,sizeof(unsigned char),7,mfile);

	    pindx->hipnt = NULL;
	    pindx->hfpnt = NULL;
	    pindx->intpnt = NULL;
	    pindx->fltpnt = NULL;

	    if (pindx->hinum>0) {
	      pindx->hipnt = (int *)malloc(sizeof(int)*pindx->hinum);
	      if (pindx->hipnt==NULL) goto err8;

	      for(i=0;i<pindx->hinum;i++) {
		fread(mrec,sizeof(unsigned char),4,mfile);
		idum=gagby(mrec,0,4);
		if(gagbb(mrec,0,1)) idum=-idum;
		*(pindx->hipnt+i)=idum;
		if(diag) printf("ddd 1 i = %d pindx->hipnt = %d\n",i,idum);
	      }

	    }


	    if (pindx->hfnum>0) {
	      pindx->hfpnt = (float *)malloc(sizeof(float)*pindx->hfnum);
	      if (pindx->hfpnt==NULL) goto err8;
	      fread (pindx->hfpnt,sizeof(float),pindx->hfnum,mfile);
	    }

	    if (pindx->intnum>0) {
	      pindx->intpnt = (int *)malloc(sizeof(int)*pindx->intnum);
	      if (pindx->intpnt==NULL) goto err8;
	      for(i=0;i<pindx->intnum;i++) {
		fread(mrec,sizeof(unsigned char),4,mfile);
		idum=gagby(mrec,0,4);
		if(gagbb(mrec,0,1)) idum=-gagbb(mrec,1,31);
		*(pindx->intpnt+i)=idum;
		if(diag) printf("ddd 2 i = %d pindx->intpnt = %d\n",i,idum);
	      }

	    }

	    if (pindx->fltnum>0) {
	      pindx->fltpnt = (float *)malloc(sizeof(float)*pindx->fltnum);
	      if (pindx->fltpnt==NULL) goto err8;

	      for(i=0;i<pindx->fltnum;i++) {
		fread(urec,sizeof(unsigned char),4,mfile);
		fdum=ibm2flt(urec);
		*(pindx->fltpnt+i)=fdum;
		if(diag) printf("ddd 3 i = %d pindx->fltpnt = %g\n",i,fdum);
	      }

	    }

	  } else {

	    fseek (mfile,0L,0);
	    fread (pindx,sizeof(struct gaindx),1,mfile);
	    if (pindx->type>>24 > 0) swpflg=1;
	    if (swpflg) gabswp((float *)pindx,5);
	    pindx->hipnt = NULL;
	    pindx->hfpnt = NULL;
	    pindx->intpnt = NULL;
	    pindx->fltpnt = NULL;
	    if (pindx->hinum>0) {
	      pindx->hipnt = (int *)malloc(sizeof(int)*pindx->hinum);
	      if (pindx->hipnt==NULL) goto err8;
	      fread (pindx->hipnt,sizeof(int),pindx->hinum,mfile);
	      if (swpflg) gabswp((float *)(pindx->hipnt),pindx->hinum);
	    }
	    if (pindx->hfnum>0) {
	      pindx->hfpnt = (float *)malloc(sizeof(float)*pindx->hfnum);
	      if (pindx->hfpnt==NULL) goto err8;
	      fread (pindx->hfpnt,sizeof(float),pindx->hfnum,mfile);
	      if (swpflg) gabswp(pindx->hfpnt,pindx->hfnum);
	    }
	    if (pindx->intnum>0) {
	      pindx->intpnt = (int *)malloc(sizeof(int)*pindx->intnum);
	      if (pindx->intpnt==NULL) goto err8;
	      fread (pindx->intpnt,sizeof(int),pindx->intnum,mfile);
	      if (swpflg) gabswp((float *)(pindx->intpnt),pindx->intnum);
	    }
	    if (pindx->fltnum>0) {
	      pindx->fltpnt = (float *)malloc(sizeof(float)*pindx->fltnum);
	      if (pindx->fltpnt==NULL) goto err8;
	      fread (pindx->fltpnt,sizeof(float),pindx->fltnum,mfile);
	      if (swpflg) gabswp(pindx->fltpnt,pindx->fltnum);
	    }

	  }

        /* map file processing -- stnmap - current NONINDEXED map (idxflg = 0) */

        } else {

	  /*mf version detection mf*/

	  fread(rec,1,16,mfile);  /* minimum map file is 16 bytes */

	  vermap=1;
	  if(strncmp(rec,"GrADS_stnmapV002",16) == 0) {
	    vermap=2;
	  }

	  if(vermap == 2) {

	    fread(mrec,sizeof(unsigned char),4,mfile);
	    idum=gagby(mrec,0,4);
	    if(gagbb(mrec,0,1)) idum=-idum;
	    mcnt=idum;

	    fread(mrec,sizeof(unsigned char),4,mfile);
	    idum=gagby(mrec,0,4);
	    if(gagbb(mrec,0,1)) idum=-idum;
	    maxlv=idum;

	    pfi->tstrt = (int *)malloc(sizeof(int)*mcnt);
	    pfi->tcnt = (int *)malloc(sizeof(int)*mcnt);

	    for(i=0;i<mcnt;i++) {
	      fread(mrec,sizeof(unsigned char),4,mfile);
	      idum=gagby(mrec,0,4);
	      if(gagbb(mrec,0,1)) idum=-idum;
	      *(pfi->tstrt+i)=idum;
	    }

	    for(i=0;i<mcnt;i++) {
	      fread(mrec,sizeof(unsigned char),4,mfile);
	      idum=gagby(mrec,0,4);
	      if(gagbb(mrec,0,1)) idum=-idum;
	      *(pfi->tcnt+i)=idum;
	    }

	
	  } else if(vermap ==1) {

	    /* reposition and read two local ints for version 1 map*/

	    fseek (mfile,0L,0);

	    fread (&mcnt,sizeof(int),1,mfile);
	    fread (&maxlv,sizeof(int),1,mfile);

	    if (maxlv>>24 > 0) swpflg = 1;
	    if (swpflg) {
	      gabswp((float *)(&mcnt),1);
	      gabswp((float *)(&maxlv),1);
	    }
	    pfi->tstrt = (int *)malloc(sizeof(int)*mcnt);
	    pfi->tcnt = (int *)malloc(sizeof(int)*mcnt);
	    fread (pfi->tstrt,sizeof(int),mcnt,mfile);
	    fread (pfi->tcnt,sizeof(int),mcnt,mfile);
	    if (swpflg) {
	      gabswp((float *)pfi->tstrt,1);
	      gabswp((float *)pfi->tcnt,1);
	    }
	    pfi->mtype = 1;

	  }

	}
      skipread:
	fclose (mfile);
	mflflg = 0;

      } /* END OF mpfile check */


    } else if (cmpwrd("toff",rec)) {
      ch = nxtwrd(rec);
      if (ch==NULL) {
        gaprnt (0,"Open Error:  Missing toff value\n");
        goto err9;
      }
      pos = intprs(ch,&(pfi->tlpst));
      if (pos==NULL || pfi->tlpst>=pfi->dnum[3]) {
        gaprnt (0,"Open Error:  Invalid toff value\n");
        goto err9;
      }
      pfi->tlpflg = 1;


    }  else if (cmpwrd("undef",rec)) {
      ch = nxtwrd(mrec);
      if (ch==NULL) {
        gaprnt (0,"Open Error:  Missing undef value\n");
        goto err9;
      }
      
      pos = valprs(ch,&(pfi->undef));
      if (pos==NULL) {
        gaprnt (0,"Open Error:  Invalid undef value\n");
        goto err9;
      } 

      /* Get the undef attribute name, if it's there */
      if ( (ch=nxtwrd(ch))!=NULL ) {
	len = 0;
	while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
	pfi->undefattr = (char *)malloc(len+3);
	for (i=0; i<len; i++) *(pfi->undefattr+i) = *(ch+i);
	*(pfi->undefattr+len) = '\0';
	/* Set the undef attribute flag */
	pfi->undefattrflg = 1;
      }
     
      if (SETMISS) {
        pfi->ulow = fabs(pfi->undef/EPSILON);
        pfi->uhi  = pfi->undef + pfi->ulow;
        pfi->ulow = pfi->undef - pfi->ulow;
      }
      flgs[4] = 0;

    } else if (cmpwrd("pdef",rec)) {
      if ( (ch = nxtwrd(rec)) == NULL) goto errm;
      /* parse the i and j dimensions of the pre-projected grid */
      if ( (pos = intprs(ch,&(pfi->ppisiz)))==NULL) goto errm;
      if ( (ch = nxtwrd(ch)) == NULL) goto errm;
      if ( (pos = intprs(ch,&(pfi->ppjsiz)))==NULL) goto errm;
      if ( (ch = nxtwrd(ch)) == NULL) goto errm;
      /* set the pre-projected grid type and wind rotation flags */
      if (cmpwrd("nps",ch))        {pfi->ppflag=1; pfi->ppwrot=1; cnt=4;}
      else if (cmpwrd("sps",ch))   {pfi->ppflag=2; pfi->ppwrot=1; cnt=4;}
      else if (cmpwrd("lcc",ch))   {pfi->ppflag=3; pfi->ppwrot=0; cnt=9;}
      else if (cmpwrd("lccr",ch))  {pfi->ppflag=3; pfi->ppwrot=1; cnt=9;}
      else if (cmpwrd("eta.u",ch)) {pfi->ppflag=4; pfi->ppwrot=1; cnt=4;}
      else if (cmpwrd("pse",ch))   {pfi->ppflag=5; pfi->ppwrot=0; cnt=7;}
      else if (cmpwrd("ops",ch))   {pfi->ppflag=6; pfi->ppwrot=0; cnt=8;}
      else if (cmpwrd("bilin",ch)) {pfi->ppflag=7; pfi->ppwrot=1; cnt=0;}
      else if (cmpwrd("file",ch))  {pfi->ppflag=8; pfi->ppwrot=1; cnt=1;}
      else goto errm;
      /* parse the pre-projected grid parameters */
      for (i=0; i<cnt; i++) {
        if ( (ch = nxtwrd(ch)) == NULL) goto errm;
        if ( (pos = valprs(ch,&(pfi->ppvals[i])))==NULL) goto errm;
      }
      /* check "num" argument to pdef file option */
      if (pfi->ppflag==8) {
        i = (int)(pfi->ppvals[0]+0.1);
        if (i<1 || i>9) goto errm;
      }
      /* parse file type, byte order, and name for pdef 'bilin' and 'file' */
      if (pfi->ppflag==7 || pfi->ppflag==8) {
        if ( (ch = nxtwrd(ch)) == NULL) goto errm;
        if (cmpwrd("stream",ch))             pdefop1 = 1;
        else if (cmpwrd("sequential",ch))    pdefop1 = 2;
        else goto errm;

        if ( (ch = nxtwrd(ch)) == NULL) goto errm;
        if (cmpwrd("binary",ch))             pdefop2 = 1;
        else if (cmpwrd("binary-big",ch))    pdefop2 = 2;
        else if (cmpwrd("binary-little",ch)) pdefop2 = 3;
        else if (cmpwrd("packed",ch))        pdefop2 = 4;
        else goto errm;

        if ( (ch = nxtwrd(ch)) == NULL) goto errm;
	ch = mrec + (ch-rec);
        if (*ch=='^' || *ch=='$') {
          fnmexp (pdefnm,ch,name);
        } else {
          getwrd (pdefnm,ch,256);
        }
	/* open the pdef file */
        pdfi = fopen(pdefnm,"rb");
        if (pdfi==NULL) {
          sprintf (pout, "  Error opening pdef file:  %s\n",pdefnm);
          gaprnt (0,pout);
          goto errm;
        }
      }

    }  else if (cmpwrd("vectorpairs",rec)) {
      if ( (ch=nxtwrd(mrec))==NULL ) {
        gaprnt (1,"Description file warning: No vector pairs listed\n");
      } else {
	if ((vectorpairs = (char *)malloc(strlen(ch)+1)) == NULL) {
	  gaprnt(0,"malloc error for list of vector pairs\n");
	  return(1);
	}
        getstr(vectorpairs,ch,strlen(ch)+1);
      }
	
    }  else if (cmpwrd("xdef",rec)) {

      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(rec)) == NULL) goto err1;
      if ( (pos = intprs(ch,&(pfi->dnum[0])))==NULL) goto err1;
      if (*pos!=' ') goto err1;
      if ( (ch = nxtwrd(ch))==NULL) goto err2;
      if (cmpwrd("linear",ch)) {
        rc = deflin(ch, pfi, 0, 0);
        if (rc==-1) goto err8;
        if (rc) goto err9;
        v2 = *(pfi->grvals[0]);
        v1 = *(pfi->grvals[0]+1) + v2;
        temp = v1+((float)(pfi->dnum[0]))*v2;
        temp=temp-360.0;
        if (fabs(temp-v1)<0.01) pfi->wrap = 1;
      }
      else if (cmpwrd("levels",ch)) {
        if (pfi->dnum[0]<1) goto err7;
        rc = deflev (ch, rec, pfi, 0);
        if (rc==-1) goto err8;
        if (rc) goto err9;
      } else goto err2;
      flgs[0] = 0;

    } else if (cmpwrd("ydef",rec)) {
      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(rec)) == NULL) goto err1;
      if ( (pos = intprs(ch,&(pfi->dnum[1])))==NULL) goto err1;
      if (*pos!=' ') goto err1;
      if ( (ch = nxtwrd(ch))==NULL) goto err2;
      if (cmpwrd("linear",ch)) {
        rc = deflin(ch, pfi, 1, 0);
        if (rc==-1) goto err8;
        if (rc) goto err9;
      } else if (cmpwrd("levels",ch)) {
        if (pfi->dnum[1]<1) goto err7;
        rc = deflev (ch, rec, pfi, 1);
        if (rc==-1) goto err8;
        if (rc) goto err9;
      } else if (cmpwrd("gausr40",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gagaus(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else if (cmpwrd("mom32",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gamo32(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else if (cmpwrd("gaust62",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gagst62(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else if (cmpwrd("gausr30",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gags30(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else if (cmpwrd("gausr20",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gags20(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else if (cmpwrd("gausr15",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3;
        if ( (pos = intprs(ch,&i))==NULL) goto err3;
        pfi->grvals[1] = gags15(i,pfi->dnum[1]);
        if (pfi->grvals[1]==NULL) goto err9;
        pfi->abvals[1] = pfi->grvals[1];
        pfi->ab2gr[1] = lev2gr;
        pfi->gr2ab[1] = gr2lev;
        pfi->linear[1] = 0;
      } else goto err2;
      flgs[1] = 0;

    } else if (cmpwrd("zdef",rec)) {
      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(rec)) == NULL) goto err1;
      if ( (pos = intprs(ch,&(pfi->dnum[2])))==NULL) goto err1;
      if (*pos!=' ') goto err1;
      if ( (ch = nxtwrd(ch))==NULL) goto err2;
      if (cmpwrd("linear",ch)) {
        rc = deflin(ch, pfi, 2, 0);
        if (rc==-1) goto err8;
        if (rc) goto err9;
      }
      else if (cmpwrd("levels",ch)) {
        if (pfi->dnum[2]<1) goto err7;
        rc = deflev (ch, rec, pfi, 2);
        if (rc==-1) goto err8;
        if (rc) goto err9;
      } else goto err2;
      flgs[2] = 0;

    } else if (cmpwrd("tdef",rec)) {
      if ( (ch = nxtwrd(rec)) == NULL) goto err1;
      if ( (pos = intprs(ch,&(pfi->dnum[3])))==NULL) goto err1;
      if (*pos!=' ') goto err1;
      if ( (ch = nxtwrd(ch))==NULL) goto err2;
      if (cmpwrd("linear",ch)) {
        if ( (ch = nxtwrd(ch))==NULL) goto err3a_tdef;
        tdef.yr = -1000;
        tdef.mo = -1000;
        tdef.dy = -1000;
        if ( (pos = adtprs(ch,&tdef,&dt1))==NULL) goto err3b_tdef;
        if (*pos!=' ' || dt1.yr == -1000 || dt1.mo == -1000.0 ||
            dt1.dy == -1000) goto err3c_tdef;
        if ( (ch = nxtwrd(ch))==NULL) goto err4a_tdef;
        if ( (pos = rdtprs(ch,&dt2))==NULL) goto err4b_tdef;
        v1 = (dt2.yr * 12) + dt2.mo;
        v2 = (dt2.dy * 1440) + (dt2.hr * 60) + dt2.mn;
	/*mf --- check if 0 dt ---mf*/
	if( (v1 == 0) && (v2 == 0) ) goto err4c_tdef;
        vals = (float *)malloc(sizeof(float)*8);
        if (vals==NULL) goto err8;
        *(vals) = dt1.yr;
        *(vals+1) = dt1.mo;
        *(vals+2) = dt1.dy;
        *(vals+3) = dt1.hr;
        *(vals+4) = dt1.mn;
        *(vals+5) = v1;
        *(vals+6) = v2;
        *(vals+7) = -999.9;
        pfi->grvals[3] = vals;
        pfi->abvals[3] = vals;
        pfi->linear[3] = 1;
      } else goto err2;
      flgs[3] = 0;

    } else if (cmpwrd("vars",rec)) {
      if ( (ch = nxtwrd(rec)) == NULL) goto err5;
      if ( (pos = intprs(ch,&(pfi->vnum)))==NULL) goto err5;
      size = pfi->vnum * (sizeof(struct gavar) + 7 );
      pvar = (struct gavar *)malloc(size);
      pfi->pvar1 = pvar;
      i = 0;
      while (i<pfi->vnum) {
        if (fgets(rec,512,descr)==NULL) {
          gaprnt (0,"Open Error:  Unexpected EOF reading variables\n");
          sprintf (pout, "Was expecting %i records.  Found %i.\n", pfi->vnum, i);
          gaprnt (2,pout);
          goto retrn;
        }

	/* Remove any leading blanks from rec */
	reclen = strlen(rec);
	jj = 0;
	while (jj<reclen && rec[0]==' ') {
	  for (ii=0; ii<reclen; ii++) rec[ii] = rec[ii+1];
	  jj++;
	}

	/* Keep mixed case and lower case versions of rec handy */
        strcpy (mrec,rec);
        lowcas(rec);

	/* Allow comments between VARS and ENDVARS */
        if ( (strncmp(mrec,"*",1)==0) || (strncmp(mrec,"#",1)==0) || !isalnum(*(mrec)) ) {
	  /* Parse comment if it contains attribute metadata  */
	  if ((strncmp("*:attr",mrec,6)==0) || (strncmp("@",mrec,1)==0)) {
	    rc = ddfattr (mrec, pfi);
	    if (rc == -1) goto retrn;
	    else continue;
	  }
  	  else continue; 
	}
        if (cmpwrd("endvars",rec)) {
          gaprnt (0,"Open Error:  Unexpected ENDVARS record\n");
          sprintf (pout, "Was expecting %i records.  Found %i.\n", pfi->vnum, i);
          gaprnt (2,pout);
          goto err9;
        }
	
	/* get abbrv and full variable name if there */
        pvar->longnm = NULL; 
        if ((getvnm(pvar, mrec))!=0) goto err6;

	/* get the number of vertical levels */
        if ( (ch=nxtwrd(rec))==NULL) goto err6;
        if ( (pos=intprs(ch,&(pvar->levels)))==NULL ) goto err6;
        if ( (ch=nxtwrd(ch))==NULL) goto err6;

	/* parse the units field */
        for (j=0;j<16;j++) pvar->units[j] = -999;
        j = 0;
        while (1) {
          if (*ch=='x'||*ch=='y'||*ch=='z'||*ch=='t') { 
            if (*(ch+1)!=',' && *(ch+1)!=' ') goto err6;
            if (*ch=='x') pvar->units[j] = -100;
            if (*ch=='y') pvar->units[j] = -101;
            if (*ch=='z') pvar->units[j] = -102;
            if (*ch=='t') pvar->units[j] = -103;
            ch++;
          } else {
            if ( (ch=intprs(ch,&(pvar->units[j])))==NULL ) goto err6;
	    /* no negative array indices for ncflag files */
	    if ((pfi->ncflg) && (pvar->units[j] < 0))  goto err6;   
          }
          while (*ch==' ') ch++;
          if (*ch=='\0' || *ch=='\n') goto err6;
          if (*ch!=',') break;
          ch++;
          while (*ch==' ') ch++;
          if (*ch=='\0' || *ch=='\n') goto err6;
          j++;
          if (j>15) goto err6;
        }

	/* parse the variable description */
        getstr (pvar->varnm,mrec+(ch-rec),127);

	/* initialize the vector pair number and the "is u" flag*/
        pvar->vecpair = -999;
        pvar->isu = 0;

	/* initialize the var_z counter for NASA GLA format */
	pvar->var_z = 1;
	if(pvar->units[0] == -1 && pvar->units[1] == 10 ) {
	  nzstride++;
	}

	/* var_t is for DRS var-t transforms */
	pvar->var_t = 0;
	if(pvar->units[0] == -1 && pvar->units[1] == 20 ) pvar->var_t = 1;

	/* x-y transpose for lat/lon vice lon/lat data VERY INEFFICIENT!!! */
	pvar->y_x = 0;
	if(pvar->units[0] == -1 && pvar->units[1] == 30) pvar->y_x = 1;

	/*mf 961126 -  integer data types mf*/
	pvar->dfrm = 0;
	if( (pvar->units[0] == -1 && pvar->units[1] == 40 ) &&
	    (pvar->units[2] >=1 && pvar->units[2] <= 4 ) ) {
	  pvar->dfrm= pvar->units[2];
	  if ( pvar->units[2] == 2 ) pvar->dfrm=2;
	  if ( pvar->units[2] == 2 && pvar->units[3] == -1) pvar->dfrm=-2;
	}

#if GRADS_CRAY == 1
	/* 32-bit big endian ieee to cray float */
	if( (pvar->units[0]==-1 && pvar->units[1]==50) || crayflg ) pvar->dfrm=8;
#endif
        i++; pvar++;
      }

      /* Get ENDVARS statement and any additional comments */
      if (fgets(rec,512,descr)==NULL) {
        gaprnt (0,"Open Error:  Missing ENDVARS statement.\n");
        goto retrn;
      }
      /* Remove any leading blanks from rec */
      reclen = strlen(rec);
      jj = 0;
      while (jj<reclen && rec[0]==' ') {
	for (ii=0; ii<reclen; ii++) rec[ii] = rec[ii+1];
	jj++;
      }
      /* Keep mixed case and lower case versions handy */
      strcpy (mrec,rec);
      lowcas(rec);
      while (!cmpwrd("endvars",rec)) {
	/* see if it's an attribute comment, otherwise send error message */
	if ((strncmp("*:attr",mrec,6)==0) || (strncmp("@",mrec,1)==0)) {
	  if ((ddfattr(mrec,pfi)) == -1) goto retrn;
	}
        else {
	  sprintf(pout,"Open Error:  Looking for \"endvars\", found \"%s\" instead.\n",rec);
	  gaprnt (0,pout);
	  goto err9;
	}
  	if (fgets(rec,512,descr)==NULL) {
	  gaprnt (0,"Open Error:  Missing ENDVARS statement.\n");
	  goto retrn;
	}
      }

      flgs[6] = 0;
    } else {
      /* parse error of .ctl file */
      gaprnt (0,"Open Error:  Unknown keyword in description file\n");
      goto err9;
    }
  }

  err=0;
  for (i=0; i<7; i++) {
    if (flgs[i]) {
      sprintf (pout,"Open Error:  missing %s record \n",errs[i]);
      gaprnt (0,pout);
      err=1;
    }
  }

  if (err) goto retrn;


  /* Done scanning.  Check if scanned stuff makes sense, 
     and then set things up correctly */

  npairs = 0;
  if (vectorpairs) {
    /* parse the vector pairs */
    if ((pair = (char *)malloc(strlen(vectorpairs)+1)) == NULL) {
      gaprnt(0,"malloc error for list of vector pairs\n");
      err=1;
    } 
    else {
      while (1) {
	/* copy the comma-delimited pair of variable names */
	getwrd(pair,vectorpairs,strlen(vectorpairs));
	i=0;
	while (1) {
	  if (*(pair+i)==',') {
	    /* get the two variable names that comprise the vector pair */
	    getstr(var1, pair, i);
	    getstr(var2, pair+(i+1), strlen(pair)-i+1);
	    npairs++;

	    /* loop through variable list */
	    foundvar1=foundvar2=0;
	    pvar = pfi->pvar1;
	    for (j=1; j<=pfi->vnum; j++) {
	      /* if variable names match, set flags */
	      if (cmpwrd(pvar->abbrv,var1)) foundvar1=j;
	      if (cmpwrd(pvar->abbrv,var2)) foundvar2=j;
	      pvar++;
	    }
	    if (foundvar1 && foundvar2) {
	      pvar = pfi->pvar1;
	      for (j=1; j<=pfi->vnum; j++) {
		/* if we've found both variables, set pvar->vecpair */
		if (cmpwrd(pvar->abbrv,var1)) {
		  pvar->vecpair=npairs;
		  pvar->isu=1;    /* trip flag for u-component */
		}
		if (cmpwrd(pvar->abbrv,var2)) {
		  pvar->vecpair=npairs;
		}
		pvar++;
	      }
	    }
	    else {
	      sprintf(pout,"Warning: VECTORPAIRS variables %s,%s were not found \n",var1,var2);
	      gaprnt(1,pout);
	    }
	    break;
	  }
	  i++; 
	}
	/* move pointer forward one word */
	if ((vectorpairs = nxtwrd (vectorpairs)) == NULL) break;
      }
    }
    free(pair);
    free(vectorpairs);
  }

  /* Find variables with units[0]=33,34 -- vector pairs that havn't already been flagged */
  pvar=pfi->pvar1;
  for (j=1; j<=pfi->vnum; j++) {
    /* Look for a variable with units[0]==33,34 that hasn't been handled yet */
    if ((pvar->units[0]==33 || pvar->units[0]==34) && (pvar->vecpair<0)) {
      if (pvar->units[0]==33) { rc = 34; }
      else { rc = 33; }
      /* Look for a matching variable with all units fields equal */
      pvar2 = (struct gavar *)malloc(size);
      if (pvar2==NULL) {
	gaprnt (0,"Memory allocation error for pvar2 in gaddes.c \n");
	err=1;
        goto retrn;
      }
      pvar2 = pfi->pvar1;
      i = 0;
      while (i<pfi->vnum) {
	if (pvar2->vecpair<0 &&        
	    pvar2->units[0]==rc &&
	    (pvar->units[1]==pvar2->units[1]) &&
	    (pvar->units[2]==pvar2->units[2]) &&
	    (pvar->units[3]==pvar2->units[3]) ) break;
	pvar2++; i++;
      }
      if (i<pfi->vnum) { /* We've got a match! */
	npairs++;
	/* set the gavar parameters */
	pvar->vecpair=npairs;
	pvar2->vecpair=npairs;
	if (pvar->units[0]==33) { pvar->isu=1; }
	else { pvar2->isu=1; }
      }
    }
    pvar++;
  }
  if (err) goto retrn;  /* end of vector pair management */

  if (pfi->type>1 && mflag==1) {
    if (mcnt==-1) {
      gaprnt (0,"Open Error: missing STNMAP record\n");
      err=1;
    } else if (mcnt != pfi->dnum[3]) {
      gaprnt (0,"Open Error: Inconsistent time count\n");
      sprintf (pout,"  Count in station map file = %i\n",mcnt);
      gaprnt (0,pout);
      sprintf (pout,"  Count in descriptor file = %i\n",pfi->dnum[3]);
      gaprnt (0,pout);
      err=1;
    }
  }

  if (err) goto retrn;

  /* Figure out locations of variables within a time group */
  pvar = pfi->pvar1;

/* Grid data */
  if (pfi->type==1) {
    pfi->gsiz = pfi->dnum[0] * pfi->dnum[1];
    if (pfi->ppflag) pfi->gsiz = pfi->ppisiz * pfi->ppjsiz;

    /* add a constant xy header */
    if (pfi->xyhdr) {
      pfi->gsiz = pfi->gsiz + pfi->xyhdr;
    }

    if (pfi->seqflg) {
      pfi->gsiz+=2;
      if (hdrb>0) hdrb+=2;
      pvar->offset = 1+hdrb;
      acum = 1+hdrb;
    } else {
      pvar->offset = hdrb;
      acum = hdrb;
    }

    levs = pvar->levels;
    if (levs==0) levs=1;
    pvar->recoff = 0;
    recacm = 0;
    pvar++;

    acumvz=acum;

    for (i=1; i<pfi->vnum; i++) {

      /* NASA GLA FORMAT CHECKS */
      /* upper air fields which var and z are transposed*/
      if((pvar->units[0]==-1) &&
	 (pvar->units[1]==10) &&
	 (pvar->units[2]==1) ) {
						
	levsua = pvar->levels;
	acum = acum + pfi->gsiz;
	pvar->var_z = nzstride;

	/* diagnstotic fields AFTER  upper air fields which are in GrADS normal order */

      } else if((pvar->units[0]==-1) &&
		(pvar->units[1]==10) &&
		(pvar->units[2]==2) ) {
	if(first) {
	  acumstride = acumstride + nzstride*levsua*pfi->gsiz;
	  acum = acumstride + (pvar->levels*pfi->gsiz) ;
	  first = 0 ;
	} else {
	  acum = acum + (levs*pfi->gsiz);
	}

      } else if(pvar->var_t) {   /* DRS transposition of var and t */

	/* time template, read the third unit param for the size of each chunk in a file */
	if(pfi->tmplat) {  
	  if(pvar->units[2] != -999) {
	    acum = acum + levs*(pfi->gsiz)*(pvar->units[1]);
	  } else {
	    gaprnt (0,"Using time templat and 4-D variables, # times / file not specified\n");
	    gaprnt (0,"Defaulting to the number of times in the .ctl file\n");
	    acum = acum + levs*(pfi->gsiz)*(pfi->dnum[3]);
	  }
	} else {
	  acum = acum + levs*(pfi->gsiz)*(pfi->dnum[3]);
	}
      } else  {                                 /* simple GrADS */
	acum = acum + (levs*pfi->gsiz);
	acumstride = acum ;
      }
      recacm += levs;
      pvar->offset = acum;
      pvar->recoff = recacm;
      levs = pvar->levels;
      if (levs==0) levs=1;
      pvar++;
    }

    recacm += levs;

    /*mf 960514 correct for case where the last variable is a NASA UA */
    pvar--;
    if( (pvar->units[0]==-1) &&
       (pvar->units[1]==10) &&
       (pvar->units[2]==1) ) {
      acum = acumvz + recacm*pfi->gsiz;
    }
    else {					
      acum = acum + (levs*pfi->gsiz);
    }

    /* time chunk header; the default is 0 */
    if(pfi->seqflg && pfi->thdr>0) {
      pfi->thdr+=2;
    }
    pfi->tsiz = acum + pfi->thdr;
    pfi->trecs = recacm;
    if (pfi->seqflg) pfi->tsiz-=1;
    pfi->tsiz += trlb;

  } else {   /* non grid data */

    for (i=0; i<pfi->vnum; i++) {
      if (pvar->levels!=0) break;
      pvar->offset = i;
      pvar++;
    }
    for (j=i; j<pfi->vnum; j++) {
      if (pvar->levels==0) {
	if (!(pfi->bufrflg)) {   /* order of variables doesn't matter for BUFR data */
	  gaprnt (0,"Open Error: Variables out of order\n");
	  gaprnt (0,"  Non-vertical variables must go first\n");
	  goto retrn;
	}
      }
      pvar->offset = j-i;
      pvar++;
    }
    pfi->lvnum = pfi->vnum - i;
    pfi->ivnum = i;
  }

/* set the global calendar and check if we are trying to change with a new file...
   we do this here to set the calandar for templating */

  if(mfcmn.cal365<0) {
    mfcmn.cal365=pfi->calendar;
  } else {
    if(pfi->calendar != mfcmn.cal365) {
      gaprnt(0,"Attempt to change the global calendar...\n");
      if(mfcmn.cal365) {
	gaprnt(0,"The calendar is NOW 365 DAYS and you attempted to open a standard calendar file\n");
      } else {
	gaprnt(0,"The calendar is NOW STANDARD and you attempted to open a 365-day calendar file\n");
      }
      goto retrn;
    }
  }

  /* Allocate an I/O buffer the size of one row */
  if (pfi->type > 1) {
    if (pfi->bufrflg) maxlv=1;  /* Not used for BUFR interface, set to 1 */
    size = maxlv * sizeof(float);
  } else {
    size = pfi->dnum[0] * sizeof(float);
  }
  pfi->rbuf = (float *)malloc(size);
  if (pfi->idxflg) pfi->pbuf = (char *)malloc(size);

  /* If a pre-projected grid, set up the interpolation
     constants. If we're just checking the descriptor (mflag==2), 
     no need to do this */

  if (pfi->ppflag && mflag!=2) {
    rc = gappcn(pfi,pdefop1,pdefop2);
    if (rc) goto retrn;
  }

  /* If the file name is a time series template, figure out
     which times go with which files, so we don't waste a lot
     of time later opening and closing files unnecessarily. */

  /* BUFR files are treated like templated files, so that the 
     data file isn't parsed until an I/O request is made */

  if (pfi->tmplat || pfi->bufrflg==1) {
    pfi->fnums = (int *)malloc(sizeof(int)*pfi->dnum[3]);
    if (pfi->fnums==NULL) goto err8;
    j = 1;
    gr2t(pfi->grvals[3],1.0,&tdefi);
    ch = gafndt(pfi->name,&tdefi,&tdefi,pfi->abvals[3],pfi->pchsub1,1);
    if (ch==NULL) goto err8;
    *(pfi->fnums) = j;
    for (i=2; i<=pfi->dnum[3]; i++) {
      gr2t(pfi->grvals[3],(float)i,&tdef);
      pos = gafndt(pfi->name,&tdef,&tdefi,pfi->abvals[3],pfi->pchsub1,i);
      if (pos==NULL)  goto err8; 
      if (strcmp(ch,pos)!=0) {
	j = i;
	free(ch);
	ch = pos;
      }
      *(pfi->fnums+i-1) = j;
    }
    free(ch);
    pfi->fnumc = 0;
  }

  fclose (descr);
  if (pdfi) fclose(pdfi);

  return(0);

 errm:
  gaprnt(0,"Open Error: Invalid pdef record.\n");
  pfi->ppflag = 0;
  goto err9;

 err1:
  gaprnt (0,"Open Error:  Missing or invalid dimension size.\n");
  goto err9;

 err2:
  gaprnt (0,"Open Error:  Missing or invalid dimension");
  gaprnt (0," scaling type\n");
  goto err9;

 err3a_tdef:
  gaprnt (0,"Open Error:  Start Time missing in tdef card");
  gaprnt (0," starting value\n");
  goto err9;

 err3b_tdef:
  gaprnt (0,"Open Error:  Invalid start time in tdef card");
  gaprnt (0," starting value\n");
  goto err9;

 err3c_tdef:
  gaprnt (0,"Open Error:  Missing or invalid dimension");
  gaprnt (0," starting value\n");
  goto err9;

 err3:
  gaprnt (0,"Open Error:  Missing or invalid dimension");
  gaprnt (0," starting value\n");
  goto err9;

 err4a_tdef:
  gaprnt (0,"Open Error:  Time increment missing in tdef\n");
  gaprnt (0," use 1 for single time data\n");
  goto err9;

 err4b_tdef:
  gaprnt (0,"Open Error:  Invalid time increment in tdef\n");
  gaprnt (0," use 1 for single time data\n");
  goto err9;

 err4c_tdef:
  gaprnt (0,"Open Error:  0 time increment in tdef\n");
  gaprnt (0," use 1 for single time data\n");
  goto err9;

 err5:
  gaprnt (0,"Open Error:  Missing or invalid variable");
  gaprnt (0," count\n");
  goto err9;

 err6:
  gaprnt (0,"Open Error:  Invalid variable record\n");
  goto err9;

 err6a:
  gaprnt (0,"Open Error:  Invalid x,y pair\n");
  goto err9;

 err7:
  gaprnt (0,"Open Error:  Invalid number of levels\n");
  goto err9;

 err8:
  gaprnt (0,"Open Error:  Memory allocation Error in gaddes.c\n");
  goto retrn;

 err9:
  gaprnt (0,"  --> The invalid description file record is: \n");
  gaprnt (0,"  --> ");
  gaprnt (0,mrec);
  gaprnt (0,"\n");

 retrn:
  gaprnt (0,"  The data file was not opened. \n");
  fclose (descr);
  if (mflflg) fclose(mfile);
  if (pdfi) fclose(pdfi);
  return(1);

}



/* Process linear scaling args */

int deflin (char *ch, struct gafile *pfi, int dim, int flag) {
float *vals,v1,v2;

  vals = (float *)malloc(sizeof(float)*6);
  if (vals==NULL) return (-1);

  if ( (ch = nxtwrd(ch))==NULL) goto err1;
  if ( valprs(ch,&v1)==NULL) goto err1;
  if (flag) v2 = 1.0;
  else {
    if ( (ch = nxtwrd(ch))==NULL) goto err2;
    if ( valprs(ch,&v2)==NULL) goto err2;
  }
  if (dim<3 && v2<=0.0) goto err2;
  *(vals+1) = v1 - v2;
  *(vals) = v2;
  *(vals+2) = -999.9;
  pfi->grvals[dim] = vals;
  *(vals+4) = -1.0 * ( (v1-v2)/v2 );
  *(vals+3) = 1.0/v2;
  *(vals+5) = -999.9;
  pfi->abvals[dim] = vals+3;
  pfi->ab2gr[dim] = liconv;
  pfi->gr2ab[dim] = liconv;
  pfi->linear[dim] = 1;
  return (0);

err1:
  gaprnt (0,"Open Error:  Missing or invalid dimension");
  gaprnt (0," starting value\n");
  free (vals);
  return (1);

err2:
  gaprnt (0,"Open Error:  Missing or invalid dimension");
  gaprnt (0," increment value\n");
  free (vals);
  return (1);
}

/* Process levels values in def record */
/* Return codes:  -1 is memory allocation error, 1 is other error */

int deflev (char *ch, char *rec, struct gafile *pfi, int dim) {
float *vvs,*vals,v1;
int i;

  if (pfi->dnum[dim]==1) {
    i = deflin (ch, pfi, dim, 1);
    return (i);
  }

  vals = (float *)malloc((pfi->dnum[dim]+5)*sizeof(float));
  if (vals==NULL) return (-1);

  vvs = vals;
  *vvs = (float)pfi->dnum[dim];
  vvs++;
  for (i=0; i<pfi->dnum[dim]; i++) {
    if ( (ch = nxtwrd(ch))==NULL) {
      if (fgets(rec,256,descr)==NULL) goto err2;
      ch = rec;
      while (*ch==' ' || *ch=='\t') ch++;
      if (*ch=='\0' || *ch=='\n') goto err3;
    }
    if (valprs(ch,&v1)==NULL) goto err1;
    *vvs = v1;
    vvs++;
  }
  *vvs = -999.9;
  pfi->abvals[dim] = vals;
  pfi->grvals[dim] = vals;
  pfi->ab2gr[dim] = lev2gr;
  pfi->gr2ab[dim] = gr2lev;
  pfi->linear[dim] = 0;
  return (0);

err1:
  gaprnt (0,"Open Error:  Invalid value in LEVELS data\n");
  free (vals);
  return (1);

err2:
  gaprnt (0,"Open Error:  Unexpected EOF reading descriptor file\n");
  gaprnt (0,"   EOF occurred reading LEVELS values\n");
  free (vals);
  return (1);

err3:
  gaprnt (0,"Open Error:  Blank Record found in LEVELS data\n");
  free (vals);
  return (1);
}


/* Process attribute metadata embedded in a comment record */
/* Return codes:  -1 is memory allocation error */

int ddfattr (char *ch, struct gafile *pfi) {

  int jj,len;
  char *varname,*attrname,*attrtype,attrvalue[512];
  struct gaattr *testattr,*attrib;
  varname = attrname = attrtype = NULL;
  
  /* check for presence of attribute metadata */
  if ((ch=nxtwrd(ch))==NULL ) {
    gaprnt (2,"Warning: Attribute comment missing all required fields \n"); 
    return(0);
  } 
  
  /* get the variable name */
  len = 0;
  while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
  varname = (char *)malloc(len+3);
  for (jj=0; jj<len; jj++) *(varname+jj) = *(ch+jj);
  *(varname+len) = '\0';
  
  /* get the attribute type */
  if ( (ch=nxtwrd(ch))==NULL ) {
    gaprnt (2,"Warning: Attribute comment missing attribute type, name, and value \n"); 
    if (varname)  { free (varname);  varname = NULL; }
    return(0);
  } 
  len = 0;
  while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
  attrtype = (char *)malloc(len+3);
  for (jj=0; jj<len; jj++) *(attrtype+jj) = *(ch+jj);
  *(attrtype+len) = '\0';
  
  /* check if attribute type matches list of valid types */
  if ((strncmp(attrtype,"String",6)  != 0) &&
      (strncmp(attrtype,"Str",3)     != 0) &&
      (strncmp(attrtype,"Byte",4)    != 0) &&
      (strncmp(attrtype,"Int16",5)   != 0) &&
      (strncmp(attrtype,"UInt16",6)  != 0) &&
      (strncmp(attrtype,"Int32",5)   != 0) &&
      (strncmp(attrtype,"UInt32",6)  != 0) &&
      (strncmp(attrtype,"Float32",7) != 0) &&
      (strncmp(attrtype,"Float64",7) != 0) &&
      (strncmp(attrtype,"Url",3)     != 0)) {
    sprintf (pout,"Warning: Attribute type \"%s\" is not one of the OPeNDAP standards:\n",attrtype);
    gaprnt (2,pout);
    sprintf (pout,"  String, Str, Byte, Int16, UInt16, Int32, UInt32, Float32, Float64, Url\n");
    gaprnt (2,pout);
  }
  
  /* get the attribute name */
  if ( (ch=nxtwrd(ch))==NULL ) {
    gaprnt (2,"Warning: Attribute comment missing attribute name and value \n"); 
    if (varname)  { free (varname);  varname = NULL; }
    if (attrtype) { free (attrtype); attrtype = NULL; }
    return(0);
  }
  len = 0;
  while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
  attrname = (char *)malloc(len+3);
  for (jj=0; jj<len; jj++) *(attrname+jj) = *(ch+jj);
  *(attrname+len) = '\0';
  
  /* get the attribute value */
  if ( (ch=nxtwrd(ch))==NULL ) {
    gaprnt (2,"Warning: Attribute comment missing attribute value \n"); 
    if (varname)  { free (varname);  varname = NULL; }
    if (attrtype) { free (attrtype); attrtype = NULL; }
    if (attrname) { free (attrname); attrname = NULL; }
    return(0);
  } 
  getstr (attrvalue, ch, 512);
  
  /* Everything parsed OK, so add a link to the list of attributes */
  if (pfi->attr) { /* chain already exists */
    /* advance to end of chain */
    attrib=pfi->attr;
    while (attrib->next) attrib=attrib->next;
    /* initialize new link */
    if ((attrib->next = (struct gaattr *) calloc(1,sizeof(struct gaattr))) != NULL) {
      attrib = attrib->next;          /* advance to new end of chain */
      attrib->varname = varname;      
      attrib->name = attrname;
      attrib->type = attrtype;
      strcpy(attrib->value,attrvalue);
      attrib->next = NULL;
    } else {
      gaprnt (0,"Error: malloc failed for attribute metadata\n");
      if (varname)  { free (varname);  varname = NULL; }
      if (attrtype) { free (attrtype); attrtype = NULL; }
      if (attrname) { free (attrname); attrname = NULL; }
      return(-1);
    } 
  }
  else {
    /* initialize first link */
    pfi->attr = (struct gaattr *) calloc(1,sizeof(struct gaattr));
    if (pfi->attr != NULL) {
      pfi->attr->varname = varname;
      pfi->attr->name = attrname;
      pfi->attr->type = attrtype;
      strcpy(pfi->attr->value,attrvalue);
      pfi->attr->next = NULL;
      attrib = pfi->attr;
    } else {
      gaprnt (0,"Error: malloc failed for attribute metadata\n");
      if (varname)  { free (varname);  varname = NULL; }
      if (attrtype) { free (attrtype); attrtype = NULL; }
      if (attrname) { free (attrname); attrname = NULL; }
      return(-1);
    }
  } 
  return(0);
}


/* Allocate and initialize a gafile structure */

struct gafile *getpfi (void) {
struct gafile *pfi;
int i;

  pfi = (struct gafile *)malloc(sizeof(struct gafile));
  if (pfi==NULL) return (NULL);

  pfi->type = 1;        /* Assume grid unless told otherwise */
  pfi->tlpflg = 0;      /* Assume file not circular */
  pfi->bswap = 0;       /* Assume no byte swapping needed */
  pfi->seqflg = 0;      /* Assume direct access */
  pfi->yrflg = 0;       /* Assume south to north */
  pfi->zrflg = 0;       /* Assume bottom to top */
  pfi->idxflg = 0;      /* Assume binary */
  pfi->ncflg = 0;       /* Assume not netcdf */
  pfi->bufrflg = 0;     /* Assume not bufr */
  pfi->ncid = -999;     /* No netcdf file open */
  pfi->sdid = -999;     /* No hdfsds file open */
  pfi->fhdr = 0;        /* Assume no file header */
  pfi->thdr=0;          /*mf assume no time header mf*/
  pfi->xyhdr=0;         /*mf assume no xyheader mf*/
  pfi->fseq = -999;     /* No sequence number assigned */
  pfi->dhandle = -999;  /* Assume not a gadods stn data set */
  pfi->packflg = 0;     /* Assume data are not packed */
  pfi->undefattrflg = 0; /* Assume no undef attribute name given */

  pfi->bufrinfo = NULL;
  pfi->bufrdset = NULL;
  pfi->attr = NULL;
  pfi->scattr = NULL;   
  pfi->ofattr = NULL;   
  pfi->undefattr = NULL;   
  pfi->tempname = NULL;
  pfi->mnam = NULL;
  pfi->infile = NULL;
  pfi->rbuf = NULL;
  pfi->pbuf = NULL;
  pfi->bbuf = NULL;
  pfi->tstrt = NULL;
  pfi->tcnt = NULL;
  pfi->mfile = NULL;
  pfi->pvar1 = NULL;
  pfi->pindx = NULL;
  pfi->fnums = NULL;
  pfi->pchsub1 = NULL;

  pfi->wrap = 0;        /* Assume no wrapping */
  for (i=0; i<4; i++) pfi->dimoff[i] = 0;
  pfi->title[0] = '\0';
  pfi->grvals[0] = NULL;
  pfi->grvals[1] = NULL;
  pfi->grvals[2] = NULL;
  pfi->grvals[3] = NULL;
  pfi->grbgrd = -999;
  pfi->tmplat = 0;
  pfi->errcnt = 0;
  pfi->errflg = 0;
  pfi->ppflag = 0;  /* Assume lat-lon grid */
  pfi->ppwrot = 0;  /* Assume no wind rotataion */
  for (i=0; i<9; i++) pfi->ppi[i] = NULL;
  for (i=0; i<9; i++) pfi->ppf[i] = NULL;
  pfi->ppw = NULL;
  pfi->calendar=0;
  pfi->cray_ieee=0;

#if USESDF == 1
  pfi->sdf_ptr = NULL ;
  pfi->is_a_SDF = 0 ;
  pfi->first_sdf_ptr = NULL ;
#endif

  return (pfi);
}

/* Free a gafile structure and associated storage.  If the flag is
   true, DO NOT free the storage related to scaling transforms,
   since someone, somewhere,  may still be pointing to that. */

void frepfi (struct gafile *pfi, int flag) {
struct gaattr *attrib, *nextattrib;
struct gaindx *pindx;
struct gachsub *pchsub,*pch2;
int i;
#if USESDF == 1
void free_io_std(IO_STD**) ;
#endif

  if (pfi->pindx) {
    pindx = pfi->pindx;
    if (pindx->hipnt) free(pindx->hipnt);
    if (pindx->hfpnt) free(pindx->hfpnt);
    if (pindx->intpnt) free(pindx->intpnt);
    if (pindx->fltpnt) free(pindx->fltpnt);
    free (pindx);
  }
  pchsub = pfi->pchsub1;
  while (pchsub) {
    if (pchsub->ch) free(pchsub->ch);
    pch2 = pchsub->forw;
    free (pchsub);
    pchsub = pch2;
  }
  if (pfi->fnums)  free(pfi->fnums);
  if (pfi->tstrt)  free(pfi->tstrt);
  if (pfi->tcnt)   free(pfi->tcnt);
  if (pfi->pvar1)  free(pfi->pvar1);
  if (pfi->rbuf)   free(pfi->rbuf);
  if (pfi->pbuf)   free(pfi->pbuf);
  if (pfi->mnam)   free(pfi->mnam);
  if (pfi->scattr) free(pfi->scattr);
  if (pfi->ofattr) free(pfi->ofattr);
  if (pfi->undefattr) free(pfi->undefattr);
  if (pfi->bufrinfo) free(pfi->bufrinfo);
#ifndef STNDALN
  if (pfi->bufrdset) gabufr_close(pfi->bufrdset);
#endif
  for (i=0; i<9; i++) if (pfi->ppi[i]) free(pfi->ppi[i]);
  for (i=0; i<9; i++) if (pfi->ppf[i]) free(pfi->ppf[i]);
  if (pfi->ppw) free(pfi->ppw);
  if (!flag) {
    for (i=0; i<4; i++) if (pfi->grvals[i]) free(pfi->grvals[i]);
  }
  if (pfi->attr) {
    for (attrib = pfi->attr; attrib != NULL; attrib = nextattrib) { 
      nextattrib = attrib->next;
      if (attrib->varname) free(attrib->varname);
      if (attrib->type)    free(attrib->type);
      if (attrib->name)    free(attrib->name);
      free(attrib);
    }
  }
#if USESDF == 1
  if (pfi->sdf_ptr) {
    if ((pfi->sdf_ptr) == (pfi->first_sdf_ptr)) {
        pfi->first_sdf_ptr = (IO_STD *) 0 ;
    }
    free_io_std(&(pfi->sdf_ptr)) ;
  }
#endif
  free (pfi);
}


/* Routine to calculate or input the interpolation constants needed for
   the implicit interpolation from pre-projected grids to lat-lon. */

int gappcn (struct gafile *pfi, int pdefop1, int pdefop2) {
int size,i,j,ii,jj;
float lat,lon,rii,rjj;
float *dx, *dy, *dw, dum;
float pi;
int *ioff, rdw, rc, pnum, wflg;

  dw=NULL;
  size = pfi->dnum[0]*pfi->dnum[1];

  /* Allocate space needed for the ppi and ppf grids */
  if (pfi->ppflag != 8) {
   ;
    if ((pfi->ppi[0] = (int   *)malloc(sizeof(int  )*size)) == NULL) goto merr;
    if ((pfi->ppf[0] = (float *)malloc(sizeof(float)*size)) == NULL) goto merr;
    if ((pfi->ppf[1] = (float *)malloc(sizeof(float)*size)) == NULL) goto merr;
    if (pfi->ppwrot) {
      if ((pfi->ppw  = (float *)malloc(sizeof(float)*size)) == NULL) goto merr;
    }
  }

  /* pdef bilin */
  if (pfi->ppflag==7) {
    /* allocate memory for ppi values */
    if ((pfi->ppi[1] = (int *)malloc(sizeof(int)*size)) == NULL) goto merr;

    if (pdefop1==2) {  /* sequential -- read the 4-byte header */
      rc = fread(&rdw, sizeof(int), 1, pdfi);
      if (rc!=1) goto merr2;
    }
    /* read the grid of pdef ivals */
    rc = fread(pfi->ppf[0], sizeof(float), size, pdfi); if (rc!=size) goto merr2;

    if (pdefop1==2) {  /* sequential -- read the 4-byte footer and next header */
      rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
      rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
    }
    /* read the grid of pdef jvals */
    rc = fread(pfi->ppf[1], sizeof(float), size, pdfi); if (rc!=size) goto merr2;

    if (pdefop1==2) {  /* sequential -- read the 4-byte footer and next header */
      rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
      rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
    }
    /* read the grid of wind rotation vals */
    rc = fread(pfi->ppw, sizeof(float), size, pdfi); if (rc!=size) goto merr2;

    /* byte swap if necessary */
    if ((pdefop2==2 && !BYTEORDER) ||
        (pdefop2==3 &&  BYTEORDER)) {
      gabswp (pfi->ppf[0],size);
      gabswp (pfi->ppf[1],size);
      gabswp (pfi->ppw,size);
    }

    /* Fill grids of file offsets and weights (dx,dy) for pdef grid interpolation */
    ioff = pfi->ppi[0];
    dx = pfi->ppf[0];
    dy = pfi->ppf[1];
    dw = pfi->ppw;
    wflg = 0;
    for (j=0; j<pfi->dnum[1]; j++) {
      for (i=0; i<pfi->dnum[0]; i++) {
        if (*dx < 0.0) *ioff = -1;
        else {
          ii = (int)(*dx);
          jj = (int)(*dy);
          *dx = *dx - (float)ii;
          *dy = *dy - (float)jj;
          if (ii<1 || ii>pfi->ppisiz-1 || jj<1 || jj>pfi->ppjsiz-1) {
            *ioff = -1;
          } else {
            *ioff = (jj-1)*pfi->ppisiz + ii - 1;
          }
        }
        if (fabs(*dw) > 0.00001) wflg = 1;
        ioff++; dx++; dy++, dw++;
      }
    }
    pfi->ppwrot = wflg;

  /* When pdef is a file, read in the offsets of the points
     to use and their weights, as well as the array of
     wind rotation values to use */

  } else if (pfi->ppflag==8) {
    pnum = (int)(pfi->ppvals[0]+0.1);
    for (i=0; i<pnum; i++) {
      /* allocate memory and then read in the offsets */
      if ((pfi->ppi[i] = (int *)malloc(sizeof(int)*size)) == NULL) goto merr;
      if (pdefop1==2) {  /* sequential -- header */
        rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
      }
      rc = fread(pfi->ppi[i], sizeof(int), size, pdfi); if (rc!=size) goto merr2;
      if (pdefop1==2) {  /* sequential -- footer */
        rc = fread(&rdw, sizeof(int), 1, pdfi);  if (rc!=1) goto merr2;
      }
 
      /* allocate memory and then read in the weights */
      if ((pfi->ppf[i] = (float *)malloc(sizeof(int)*size)) == NULL) goto merr;
      if (pdefop1==2) {  /* sequential -- header */
        rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
      }
      rc = fread(pfi->ppf[i], sizeof(float), size, pdfi); if (rc!=size) goto merr2;
      if (pdefop1==2) {  /* sequential -- footer */
        rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
      }

      /* byte swap if necessary */
      if ((pdefop2==2 && !BYTEORDER) ||
          (pdefop2==3 &&  BYTEORDER)) {
        gabswp ((float *)(pfi->ppi[i]),size);
        gabswp (pfi->ppf[i],size);
      }
    }

    /* allocate memory and read in the wind rotation values */
    if ((pfi->ppw = (float *)malloc(sizeof(float)*size)) == NULL) goto merr;
    if (pdefop1==2) {  /* sequential -- header */
      rc = fread(&rdw, sizeof(int), 1, pdfi); if (rc!=1) goto merr2;
    }
    rc = fread(pfi->ppw, sizeof(float), size, pdfi); if (rc!=size) goto merr2;

    /* byte swap if necessary */
    if ((pdefop2==2 && !BYTEORDER) ||
        (pdefop2==3 &&  BYTEORDER)) {
      gabswp (pfi->ppw,size);
    }

    /* set wind rotation flag */
    dw = pfi->ppw;
    wflg = 0;
    for (i=0; i<size; i++) {
      if (fabs(*dw) > 0.00001) wflg = 1;
      dw++;
    }
    pfi->ppwrot = wflg;

  /* When a supported projection is specified,
     we calculate three constants at each lat-lon grid point:
     offset of the ij gridpoint, and the delta x and delta y
     values. */

  } else {
    pi = acos(-1.0);
    ioff = pfi->ppi[0];
    dx = pfi->ppf[0];
    dy = pfi->ppf[1];
    if ( pfi->ppwrot) dw = pfi->ppw;

    for (j=0; j<pfi->dnum[1]; j++) {
      lat = pfi->gr2ab[1](pfi->grvals[1],(float)(j+1));
      for (i=0; i<pfi->dnum[0]; i++) {
        lon = pfi->gr2ab[0](pfi->grvals[0],(float)(i+1));
	/* get i,j values in preprojected grid for each lat/lon point */
	if (pfi->ppflag==3) {             
	  if(pfi->ppwrot) {                /* PDEF lccr */
	    ll2lc (pfi->ppvals, lat, lon, &rii, &rjj, dw);   
	  } else {                         /* PDEF lcc */
	    ll2lc (pfi->ppvals, lat, lon, &rii, &rjj, &dum);
	  }
        } else if (pfi->ppflag==4) {       /* PDEF eta.u */
          ll2eg (pfi->ppisiz,pfi->ppjsiz,pfi->ppvals, lon, lat, &rii, &rjj, dw);
        } else if (pfi->ppflag==5) {       /* PDEF pse */
          ll2pse (pfi->ppisiz,pfi->ppjsiz,pfi->ppvals, lon, lat, &rii, &rjj);
        } else if (pfi->ppflag==6) {       /* PDEF ops */  
          ll2ops (pfi->ppvals, lon, lat, &rii, &rjj);
        } else {                           /* PDEF nps and sps */
          w3fb04(lat, -1.0*lon, pfi->ppvals[3], -1.0*pfi->ppvals[2], &rii, &rjj);
          rii = rii + pfi->ppvals[0];  /* Normalize based on pole point */ 
          rjj = rjj + pfi->ppvals[1];
          *dw = (pfi->ppvals[2]-lon) * pi/180.0;  /* wind rotation amount */
          if (pfi->ppflag==2) *dw = pi - *dw;
        }
        ii = (int)rii;
        jj = (int)rjj;
        *dx = rii - (float)ii;
        *dy = rjj - (float)jj;
        if (ii<1 || ii>pfi->ppisiz-1 || jj<1 || jj>pfi->ppjsiz-1) {
          *ioff = -1;
        } else {
          *ioff = (jj-1)*pfi->ppisiz + ii - 1;
        }
	ioff++; dx++; dy++;
        if (pfi->ppwrot) dw++;
      }
    }
  }
  return(0);

merr:
  gaprnt (0,"Open Error:  Memory allocation error in pdef handler\n");
  return(1);

merr2:
  gaprnt (0,"Open Error:  I/O Error on pdef file read\n");
  return(1);

}

void w3fb04 (float alat, float along, float xmeshl, float orient,
     float *xi, float *xj) {

/*
C
C SUBPROGRAM: W3FB04         LATITUDE, LONGITUDE TO GRID COORDINATES
C   AUTHOR: MCDONELL,J.      ORG: W345       DATE: 90-06-04
C
C ABSTRACT: CONVERTS THE COORDINATES OF A LOCATION ON EARTH FROM THE
C   NATURAL COORDINATE SYSTEM OF LATITUDE/LONGITUDE TO THE GRID (I,J)
C   COORDINATE SYSTEM OVERLAID ON A POLAR STEREOGRAPHIC MAP PRO-
C   JECTION TRUE AT 60 DEGREES N OR S LATITUDE. W3FB04 IS THE REVERSE
C   OF W3FB05.
C
C PROGRAM HISTORY LOG:
C   77-05-01  J. MCDONELL
C   89-01-10  R.E.JONES   CONVERT TO MICROSOFT FORTRAN 4.1
C   90-06-04  R.E.JONES   CONVERT TO SUN FORTRAN 1.3
C   93-01-26  B. Doty     converted to C
C
C USAGE:  CALL W3FB04 (ALAT, ALONG, XMESHL, ORIENT, XI, XJ)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     ALAT   ARG LIST  LATITUDE IN DEGREES (<0 IF SH)
C     ALONG  ARG LIST  WEST LONGITUDE IN DEGREES
C     XMESHL ARG LIST  MESH LENGTH OF GRID IN KM AT 60 DEG LAT(<0 IF SH)
C                   (190.5 LFM GRID, 381.0 NH PE GRID,-381.0 SH PE GRID)
C     ORIENT ARG LIST  ORIENTATION WEST LONGITUDE OF THE GRID
C                   (105.0 LFM GRID, 80.0 NH PE GRID, 260.0 SH PE GRID)
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     XI     ARG LIST  I OF THE POINT RELATIVE TO NORTH OR SOUTH POLE
C     XJ     ARG LIST  J OF THE POINT RELATIVE TO NORTH OR SOUTH POLE
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     COS SIN                                                 SYSLIB
C
C   REMARKS: ALL PARAMETERS IN THE CALLING STATEMENT MUST BE
C     REAL. THE RANGE OF ALLOWABLE LATITUDES IS FROM A POLE TO
C     30 DEGREES INTO THE OPPOSITE HEMISPHERE.
C     THE GRID USED IN THIS SUBROUTINE HAS ITS ORIGIN (I=0,J=0)
C     AT THE POLE IN EITHER HEMISPHERE, SO IF THE USER'S GRID HAS ITS
C     ORIGIN AT A POINT OTHER THAN THE POLE, A TRANSLATION IS NEEDED
C     TO GET I AND J. THE GRIDLINES OF I=CONSTANT ARE PARALLEL TO A
C     LONGITUDE DESIGNATED BY THE USER. THE EARTH'S RADIUS IS TAKEN
C     TO BE 6371.2 KM.
C
C ATTRIBUTES:
C   LANGUAGE: SUN FORTRAN 1.4
C   MACHINE:  SUN SPARCSTATION 1+
C*/

static float d2r = 3.14159/180.0;
static float earthr = 6371.2;

float re,xlat,wlong,r;

      re   = (earthr * 1.86603) / xmeshl;
      xlat = alat * d2r;

      if (xmeshl>0.0) {
        wlong = (along + 180.0 - orient) * d2r;
        r     = (re * cos(xlat)) / (1.0 + sin(xlat));
        *xi    = r * sin(wlong);
        *xj    = r * cos(wlong);

      } else {

        re    = -re;
        xlat =  -xlat;
        wlong = (along - orient) * d2r;
        r     = (re * cos(xlat)) / (1.0+ sin(xlat));
        *xi   =  r * sin(wlong);
        *xj   = -r * cos(wlong);
      }
}

/* Lambert conformal conversion */

void ll2lc (float *vals, float grdlat, float grdlon, float *grdi, float *grdj, float *wrot) {

/*  Subroutine to convert from lat-lon to lambert conformal i,j.
    Provided by NRL Monterey; converted to C 6/15/94.

c          SUBROUTINE: ll2lc
c
c          PURPOSE: To compute i- and j-coordinates of a specified
c                   grid given the latitude and longitude points.
c                   All latitudes in this routine start
c                   with -90.0 at the south pole and increase
c                   northward to +90.0 at the north pole.  The
c                   longitudes start with 0.0 at the Greenwich
c                   meridian and increase to the east, so that
c                   90.0 refers to 90.0E, 180.0 is the inter-
c                   national dateline and 270.0 is 90.0W.
c
c          INPUT VARIABLES:
c
c  vals+0    latref: latitude at reference point (iref,jref)
c 		    
c  vals+1    lonref: longitude at reference point (iref,jref)
c 		    
c  vals+2    iref:   i-coordinate value of reference point
c 		    
c  vals+3    jref:   j-coordinate value of reference point
c 		    
c  vals+4    stdlt1: standard latitude of grid (S True lat)
c 		    
c  vals+5    stdlt2: second standard latitude of grid (only required
c                    if igrid = 2, lambert conformal) (N True lat)
c 		    
c  vals+6    stdlon: standard longitude of grid (longitude that
c                     points to the north)
c 		    
c  vals+7    delx:   grid spacing of grid in x-direction
c                    for igrid = 1,2,3 or 4, delx must be in meters
c                    for igrid = 5, delx must be in degrees
c 		    
c  vals+8    dely:   grid spacing (in meters) of grid in y-direction
c                    for igrid = 1,2,3 or 4, delx must be in meters
c                    for igrid = 5, dely must be in degrees
c
c            grdlat: latitude of point (grdi,grdj)
c
c            grdlon: longitude of point (grdi,grdj)
c
c            grdi:   i-coordinate(s) that this routine will generate
c                    information for
c
c            grdj:   j-coordinate(s) that this routine will generate
c                    information for
c
*/

  float pi, pi2, pi4, d2r, r2d, radius, omega4;
  float gcon,ogcon,H,deg,cn1,cn2,cn3,cn4,rih,xih,yih,rrih,check;
  float alnfix,alon,x,y,windrot;
  float latref,lonref,iref,jref,stdlt1,stdlt2,stdlon,delx,dely;

  pi = 4.0*atan(1.0);
  pi2 = pi/2.0;
  pi4 = pi/4.0;
  d2r = pi/180.0;
  r2d = 180.0/pi;
  radius = 6371229.0;
  omega4 = 4.0*pi/86400.0;

  latref = *(vals+0);    
  lonref = *(vals+1);    
  iref   = *(vals+2);    
  jref   = *(vals+3);    
  stdlt1 = *(vals+4);    
  stdlt2 = *(vals+5);    
  stdlon = *(vals+6);    
  delx   = *(vals+7);    
  dely   = *(vals+8);    
                    
/* case where standard lats are the same */
/* corrected by Dan Geiszler of NRL; fabs of the 
   lats was required for shem cases */

  if(stdlt1 == stdlt2) {
    gcon = sin(d2r*(fabs(stdlt1)));
  } else {
    gcon = (log(sin((90.0-fabs(stdlt1))*d2r))
	   -log(sin((90.0-fabs(stdlt2))*d2r)))
          /(log(tan((90.0-fabs(stdlt1))*0.5*d2r))
           -log(tan((90.0-fabs(stdlt2))*0.5*d2r)));
  }
  ogcon = 1.0/gcon;
  H = fabs(stdlt1)/(stdlt1);        /* 1 for NHem, -1 for SHem */
  cn1 = sin((90.0-fabs(stdlt1))*d2r);
  cn2 = radius*cn1*ogcon;
  deg = (90.0-fabs(stdlt1))*d2r*0.5;
  cn3 = tan(deg);
  deg = (90.0-fabs(latref))*d2r*0.5;
  cn4 = tan(deg);
  rih = cn2*pow((cn4/cn3),gcon);

  xih =  rih*sin((lonref-stdlon)*d2r*gcon);
  yih = -rih*cos((lonref-stdlon)*d2r*gcon)*H;
  deg = (90.0-grdlat*H)*0.5*d2r;
  cn4 = tan(deg);
  rrih = cn2*pow((cn4/cn3),gcon);
  check  = 180.0-stdlon;
  alnfix = stdlon+check;
  alon   = grdlon+check;

  while (alon<  0.0) alon = alon+360.0;
  while (alon>360.0) alon = alon-360.0;

  deg = (alon-alnfix)*gcon*d2r;
  x =  rrih*sin(deg);
  y = -rrih*cos(deg)*H;
  *grdi = iref + (x-xih)/delx;
  *grdj = jref + (y-yih)/dely;
  /* mf 20040630 -- use ftp://grads.iges.org/grads/src/grib212.f to calc rotation factor */
  windrot=gcon*(stdlon-grdlon)*d2r;
  *wrot=windrot;
}

/* NMC eta ll to xy map  */

void ll2eg (int im, int jm, float *vals,  float grdlon, float grdlat,
	    float *grdi, float *grdj, float *alpha) {

/*  Subroutine to convert from lat-lon to NMC eta i,j.

    Provided by Eric Rogers NMC; 
    Converted to C 3/29/95 by Mike Fiorino
    Modified 9/2004 by J.M.Adams to correct grdi/j and alpha calculations

c          SUBROUTINE: ll2eg
c
c          PURPOSE: To compute i- and j-coordinates of a specified
c                   grid given the latitude and longitude points.
c                   All latitudes in this routine start
c                   with -90.0 at the south pole and increase
c                   northward to +90.0 at the north pole.  The
c                   longitudes start with 0.0 at the Greenwich
c                   meridian and increase to the east, so that
c                   90.0 refers to 90.0E, 180.0 is the inter-
c                   national dateline and 270.0 is 90.0W.
c
c          INPUT VARIABLES:
c
c  vals+0    tlm0d: longitude of the reference center point
c  vals+1    tph0d: latitude of the reference center point
c  vals+2    dlam:  dlon grid increment in deg
c  vals+3    dphi:  dlat grid increment in deg
c
c            grdlat: latitude of point (grdi,grdj)
c            grdlon: longitude of point (grdi,grdj)
c            grdi:   i-coordinate(s) that this routine will generate
c                    information for
c            grdj:   j-coordinate(s) that this routine will generate
c                    information for
*/

  float pi,d2r,r2d, earthr;
  float tlm0d,tph0d,dlam,dphi;
  float phi,lam,lam0,phi0;
  float x,y,z,xx,bigphi,biglam;
  float dlmd,dphd,wbd,sbd;

  pi = 3.141592654;
  d2r = pi/180.0;
  r2d = 1.0/d2r;
  earthr = 6371.2;

  tlm0d = -*(vals+0); /* convert + W to + E, the grads standard for longitude */
  tph0d =  *(vals+1);
  dlam  = (*(vals+2))*0.5;
  dphi  = (*(vals+3))*0.5;

  /* convert to radians */
  phi   =  grdlat*d2r;          /* grid latitude */
  lam   = -grdlon*d2r;          /* grid longitude, convert +W to +E, the grads standard */
  phi0  = tph0d*d2r;            /* center latitude  */
  lam0  = tlm0d*d2r;            /* center longitude */

  /* Transform grid lat/lon */
  x = cos(phi0)*cos(phi)*cos(lam-lam0)+sin(phi0)*sin(phi);
  y = -cos(phi)*sin(lam-lam0);
  z = -sin(phi0)*cos(phi)*cos(lam-lam0)+cos(phi0)*sin(phi);
  biglam = atan2(y,x)/d2r;                  /* transformed lon in degrees */
  bigphi = atan2(z,sqrt(x*x+y*y))/d2r;      /* transformed lat in degrees */

  /* Convert transformed lat/lon -> i,j */
  dlmd  = (*(vals+2));
  dphd  = (*(vals+3));
  wbd = (-1)*0.5*(im-1)*dlmd;               /* western boundary of transformed grid */
  sbd = (-1)*0.5*(jm-1)*dphd;               /* southern boundary of transformed grid */
  *grdi = 1.0 + (biglam-wbd)/dlmd;
  *grdj = 1.0 + (bigphi-sbd)/dphd;

  /* params for wind rotation alpha, alpha>0 ==> counter clockwise rotation */
  xx=sin(phi0)*sin(biglam*d2r)/cos(phi);
  if (xx < -1.0) xx = -1.0;
  else if (xx > 1.0) xx = 1.0;
  *alpha = (-1)*asin(xx);

}

void ll2pse (int im, int jm, float *vals, float lon, float lat,
	     float *grdi, float *grdj) {


  /* Convert from geodetic latitude and longitude to polar stereographic
     grid coordinates.  Follows mapll by V. J. Troisi.         */
  /* Conventions include that slat and lat must be absolute values */
  /* The hemispheres are controlled by the sgn parameter */
  /* Bob Grumbine 15 April 1994. */

  const float rearth = 6378.273e3;
  const float eccen2 = 0.006693883;
  const float pi = 3.141592654;

  float cdr, alat, along, e, e2;
  float t, x, y, rho, sl, tc, mc;
  float slat,slon,xorig,yorig,sgn,polei,polej,dx,dy;

  slat=*(vals+0);
  slon=*(vals+1);
  polei=*(vals+2);
  polej=*(vals+3);
  dx=*(vals+4)*1000;
  dy=*(vals+5)*1000;
  sgn=*(vals+6);

  xorig = -polei*dx;
  yorig = -polej*dy;

  cdr   = 180./pi;
  alat  = lat/cdr;
  along = lon/cdr;
  e2 = eccen2;
  e  = sqrt(eccen2);

  if ( fabs(lat) > 90.)  {
    *grdi = -1;
    *grdj = -1;
    return;
  }
  else {
    t = tan(pi/4. - alat/2.) /
      pow( (1.-e*sin(alat))/(1.+e*sin(alat)) , e/2.);

    if ( fabs(90. - slat) < 1.E-3) {
      rho = 2.*rearth*t/
	pow( pow(1.+e,1.+e) * pow(1.-e,1.-e) , e/2.);
    }
    else {
      sl = slat/cdr;
      tc = tan(pi/4.-sl/2.) /
	pow( (1.-e*sin(sl))/(1.+e*sin(sl)), (e/2.) );
      mc = cos(sl)/ sqrt(1.-e2*sin(sl)*sin(sl) );
      rho = rearth * mc*t/tc;
    }

    x = rho*sgn*cos(sgn*(along+slon/cdr));
    y = rho*sgn*sin(sgn*(along+slon/cdr));

    *grdi = (x - xorig)/dx+1;
    *grdj = (y - yorig)/dy+1;

    return;
  }

}

void ll2ops(float *vals, float lni, float lti, float *grdi, float *grdj) {

  const float radius = 6371229.0 ;

  float stdlat, stdlon, xref, yref, xiref, yjref, delx , dely;
  float plt,pln;
  double pi180,c1,c2,c3,c4,c5,c6,arg2a,bb,plt1,alpha, pln1,plt90,argu1,argu2;
  double hsign,glor,rstdlon,glolim,facpla,x,y;

  stdlat = *(vals+0);
  stdlon = *(vals+1);
  xref = *(vals+2);
  yref = *(vals+3);
  xiref = *(vals+4);
  yjref = *(vals+5);
  delx = *(vals+6);
  dely = *(vals+7);

  c1=1.0 ;
  pi180 = asin(c1)/90.0;

  /* set flag for n/s hemisphere and convert longitude to <0 ; 360> interval */
  if(stdlat >= 0.0) {
    hsign= 1.0 ;
  } else {
    hsign=-1.0 ;
  }

  /* set flag for n/s hemisphere and convert longitude to <0 ; 360> interval */
  glor=lni ;
  if(glor <= 0.0) glor=360.0+glor ;
  rstdlon=stdlon;
  if(rstdlon < 0.0) rstdlon=360.0+stdlon;

  /* test for a n/s pole case */
  if(stdlat == 90.0) {
    plt=lti ;
    pln=fmod(glor+270.0,360.0) ;
    goto l2000;
  }

  if(stdlat == -90.0) {
    plt=-lti ;
    pln=fmod(glor+270.0,360.0) ;
    goto l2000;
  }

  /* test for longitude on 'greenwich or date line' */
  if(glor == rstdlon) {
    if(lti > stdlat) {
      plt=90.0-lti+stdlat;
      pln=90.0;
    } else {
      plt=90.0-stdlat+lti;
      pln=270.0;;
    }
    goto l2000;
  }

  if(fmod(glor+180.0,360.0) == rstdlon) {
    plt=stdlat-90.0+lti;
    if(plt < -90.0) {
      plt=-180.0-plt;
      pln=270.0;
    } else {
      pln= 90.0;
    }
    goto l2000 ;
  }

  /* determine longitude distance relative to rstdlon so it belongs to
     the absolute interval 0 - 180 */
  argu1 = glor-rstdlon;
  if(argu1 > 180.0) argu1 = argu1-360.0;
  if(argu1 < -180.0) argu1 = argu1+360.0;

  /* 1. get the help circle bb and angle alpha (legalize arguments) */

  c2=lti*pi180 ;
  c3=argu1*pi180 ;
  arg2a = cos(c2)*cos(c3) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = max1(arg2a,-c1)  */
  if(  c1 < arg2a ) arg2a = c1 ; /* min1(arg2a, c1)         */
  bb = acos(arg2a) ;

  c4=hsign*lti*pi180 ;
  arg2a = sin(c4)/sin(bb) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a = c1  ; /* arg2a = dmin1(arg2a, c1) */
  alpha = asin(arg2a) ;

  /* 2. get plt and pln (still legalizing arguments) */
  c5=stdlat*pi180 ;
  c6=hsign*stdlat*pi180 ;
  arg2a = cos(c5)*cos(bb) + sin(c6)*sin(c4) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a = c1  ; /* arg2a = dmin1(arg2a, c1) */
  plt1   = asin(arg2a) ;

  arg2a = sin(bb)*cos(alpha)/cos(plt1) ;

  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a =  c1 ; /* arg2a = dmin1(arg2a, c1) */
  pln1   = asin(arg2a) ;


  /* test for passage of the 90 degree longitude (duallity in pln)
     get plt for which pln=90 when lti is the latitude */
  arg2a = sin(c4)/sin(c6) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a =  c1 ; /* arg2a = dmin1(arg2a, c1) */
  plt90 = asin(arg2a) ;

  /* get help arc bb and angle alpha */
  arg2a = cos(c5)*sin(plt90) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a =  c1 ; /* arg2a = dmin1(arg2a, c1) */
  bb    = acos(arg2a) ;

  arg2a = sin(c4)/sin(bb) ;
  if( -c1 > arg2a ) arg2a = -c1 ; /* arg2a = dmax1(arg2a,-c1) */
  if(  c1 < arg2a ) arg2a =  c1 ; /* arg2a = dmin1(arg2a, c1) */
  alpha = asin(arg2a) ;

  /* get glolim - it is nesc. to test for the existence of solution */
  argu2  = cos(c2)*cos(bb) / (1.-sin(c4)*sin(bb)*sin(alpha)) ;
  if( fabs(argu2) > c1 ) {
    glolim = 999.0;
  } else {
    glolim = acos(argu2)/pi180;
  }

  /* modify (if nesc.) the pln solution */
  if( ( fabs(argu1) > glolim && lti <= stdlat ) || ( lti > stdlat ) ) {
    pln1 = pi180*180.0 - pln1;
  }

  /* the solution is symmetric so the direction must be if'ed */
  if(argu1 < 0.0) {
    pln1 = -pln1;
  }

  /* convert the radians to degrees */
  plt = plt1/pi180 ;
  pln = pln1/pi180 ;

  /* to obtain a rotated value (ie so x-axis in pol.ste. points east) 
     add 270 to longitude */
  pln=fmod(pln+270.0,360.0) ;

 l2000:

/*
c     this program convert polar stereographic coordinates to x,y ditto
c     longitude:   0 - 360  ; positive to the east
c     latitude : -90 -  90  ; positive for northern hemisphere
c     it is assumed that the x-axis point towards the east and
c     corresponds to longitude = 0
c
c     tsp 20/06-89
c
c     constants and functions
*/
  facpla = radius*2.0/(1.0+sin(plt*pi180))*cos(plt*pi180);
  x = facpla*cos(pln*pi180) ;
  y = facpla*sin(pln*pi180)  ;

  *grdi=(x-xref)/delx + xiref;
  *grdj=(y-yref)/dely + yjref;

  return;

}


#if USESDF == 1
#ifdef STNDALN

#define Success 1
#define Failure 0

/* initialize a netCDF standard file structure */
int
init_io_std (std_ptr)
IO_STD    **std_ptr;		/* pointer to netCDF data structure */
{
  int         init_dim_info ();
  void        free_io_std ();

  if ((*std_ptr) != NULL)
    free_io_std (std_ptr);

  if (((*std_ptr) = (IO_STD *) malloc (sizeof (IO_STD))) == NULL)
  {
	printf ("Could not allocate memory for netCDF/HDF-SDS structure.\n");
	return Failure;
  }

  /* initialize contents of structure */
  (*std_ptr)->cdfid = -1;
  (*std_ptr)->ndims = 0;
  (*std_ptr)->nvars = 0;
  (*std_ptr)->ngatts = 0;
  (*std_ptr)->recdim = -1;
  (*std_ptr)->time_type = CDC;

  (*std_ptr)->first_gattr = NULL;

  /* don't create variable list quite yet */
  (*std_ptr)->var = NULL;

  /* intialize dimension information */
  if (init_dim_info ((*std_ptr)->dimids, (*std_ptr)->dimnam,
		     (*std_ptr)->dimsiz) != Success)
    return Failure;

  return Success;
}

/* initialize dimension information */
int
init_dim_info (dimids, dimnam, dimsiz)
int        *dimids;		/* array of dimension IDs   */
char        dimnam[MAX_NC_DIMS][MAX_NC_NAME + 1];	/* array of dimension
							 * names */
long       *dimsiz;		/* array of dimension sizes */
{
  int         i;

  /* set all dimension information to bogus values */
  for (i = 0; i < MAX_NC_DIMS; i++)
  {
    dimids[i] = -1;
    dimnam[i][0] = '\0';
    dimsiz[i] = -1;
  }

  return Success;
}

/* free a netCDF standard file structure */
void
free_io_std (std_ptr)
IO_STD    **std_ptr;
{
  void        free_var_info ();
  int         free_netcdf_att_list ();

  if (*std_ptr != NULL)
  {
    /* if the variable list exists, free it */
    if ((*std_ptr)->var != NULL)
      free_var_info (&((*std_ptr)->var));

    /* free the global attributes if they have been allocated */
    if ((*std_ptr)->first_gattr != NULL)
      free_netcdf_att_list (&((*std_ptr)->first_gattr));

    /* now free the IO_STD structure itself */
    free (*std_ptr);
    *std_ptr = NULL;
  }

  return;
}

/* free a variable structure */
void
free_var_info (var)
VAR_INFO  **var;
{
  void        free_var_info ();
  int	      free_netcdf_att_list ();

  /* go through list to the end and free all variable structures */
  if ((*var)->next != NULL)
    free_var_info (&((*var)->next));

  if ((*var)->first_vattr != NULL)
    free_netcdf_att_list (&((*var)->first_vattr));

  /* if data space has been allocated, free it */
  if ((*var)->data != NULL)
    free ((*var)->data);

  /* now free the variable structure itself */
  free (*var);
  *var = NULL;

  return;
}

/* Free a netCDF attribute list. */
int
free_netcdf_att_list (first_attr)
struct attrib_list **first_attr;	/* First attribute in list. */
{
  struct attrib_list *temp_attr,
             *save_attr;

  temp_attr = *first_attr;
  while (temp_attr != NULL)
  {
    save_attr = temp_attr->next;
    if (temp_attr->data != NULL)
      free (temp_attr->data);
    free (temp_attr);
    temp_attr = save_attr;
  }
  *first_attr = NULL;
  return Success;
}

#endif
#endif
