
/* 
 * Include ./configure's header file
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*
 *   Implements GrADS ImgTool interface
 *
 *
 *   REVISION HISTORY:
 *
 *   980115  - Mike Fiorino and Jonathan Allen using ImgTool libs vice ImageMagick
 *   980121  - Mike Fiorino and Jonathan Allen allow use of either XA of IM
 *
 *   --
 *   (c) 1997 by Arlindo da Silva
 *
 *   Permission is granted to any individual or institution to use,
 *   modify, copy, or redistribute this software so long as it is not 
 *   sold for profit, and provided this notice is retained. 
 *
 */

#if USEIMG == 2

#include <stdio.h>
#include <string.h>
#include "grads.h"
#include <prototypes.h>    /** <<--- ImgTool Includes **/
#include <Image.h>


/** Local Functions **/
static void     ungrabX(InfoXDefault*);
static int      getxcolors(XWindowAttributes *, XColor**,InfoXDefault*);
static int      already_init = 0;


/** Global Data Required (gxX.c) **/
extern struct gacmn  gcmn;
extern Window   win;

/* File Format String ID's */
/* TIFF,JPEG,XPM,XBM,IRIS,PPMA,PGMA,PPMR,PGMR,XWD,DUP,GIF */

static char pout[256];   /* Build error msgs here */

/*
 * int
 * img_init --- Initializes things. It also writes msg and returns 1 
 *              if GrADS running in batch mode.
 *
 */

int img_init()
{
  if ( already_init ) return 0;
  if ( gcmn.batflg ) {
       gaprnt (0,"IMG Error: image functions not available in batch mode\n");
       return 1;
  } 
  already_init = 1;
  return 0;
}

int img_write( char* filename, char* fileformat) {

  XWindowAttributes xwa;
  int             x, y, num_colors;
  unsigned int    w, h, b, depth;
  XColor          *colors;
  XImage          *xim = NULL;
  Window          root;
  InfoXDefault    *Info_X;
  int             success = -1;

  if (img_init()) return 1;

  uppcas(fileformat);

  if ((strcmp(fileformat,"GIF")) 
      && (strcmp(fileformat,"TIFF")) 
      && (strcmp(fileformat,"JPEG"))
      && (strcmp(fileformat,"XPM")) 
      && (strcmp(fileformat,"XBM")) 
      && (strcmp(fileformat,"IRIS")) 
      && (strcmp(fileformat,"PPMA"))
      && (strcmp(fileformat,"PGMA"))
      && (strcmp(fileformat,"PPMR"))
      && (strcmp(fileformat,"PGMR"))
      && (strcmp(fileformat,"XWD"))   
      && (strcmp(fileformat,"DUP"))	)
    
    {
      sprintf (pout,"wi FAILED to create: %s in: %s format\n",filename,fileformat);
      gaprnt (2,pout);
      sprintf (pout,"The specified graphics file format: %s not supported.\n",fileformat);
      gaprnt (2,pout);
      return 0;
    }


  Info_X = (InfoXDefault *) malloc(sizeof(InfoXDefault));
  if(!Info_X)
    ErrMesg(" ", "Couldn't allocate memory for the structure 'Info_X'", 1);

  DefaultXprop(Info_X, NULL, 1);   /* fill the structure with default X values */
  root = DefaultRootWindow(Info_X->theDisp);

  XBell  (Info_X->theDisp, 50);
  if (!XGetWindowAttributes(Info_X->theDisp, win, &xwa)) {
    ErrMesg("xtof.c","Unable to get window attributes for clicked-on window",1);
    ungrabX(Info_X);
    return 0;
  }

  XGetGeometry(Info_X->theDisp, win, &root, &x, &y, &w, &h, &b, &depth);
  w -= w%4;
  if((xim = XGetImage(Info_X->theDisp, win, 0, 0, w, h, AllPlanes, ZPixmap)) == NULL) {
    printf("%s : Can't create new XImage\n", "xtof" );
    return 0;
  }

  num_colors = getxcolors(&xwa, &colors,Info_X);
  ungrabX(Info_X);

  success = WindowToFile(Info_X, xim, num_colors,
			 colors, &xwa, filename, fileformat,1);
  XBell  (Info_X->theDisp, 100);
  if(success) {
    sprintf (pout,"wi successfully created: %s in: %s format\n",filename,fileformat);
    gaprnt (2,pout);
  } 
  if ( xim != NULL ) { XDestroyImage(xim);    }
  if(Info_X) free(Info_X);
  return success;
}

/* ******************************* */

static void ungrabX(InfoXDefault *Info_X) {
  XUngrabServer(Info_X->theDisp);
  XUngrabButton(Info_X->theDisp, (u_int) AnyButton, 0, Info_X->rootW);
}


static int getxcolors(XWindowAttributes *win_info,XColor **colors, 
		      InfoXDefault *Info_X) {
  int i, ncolors;
  Colormap cmap;

  *colors = (XColor *) NULL;
  if (win_info->visual->class == TrueColor) {
    return 0;
  }
  else if (!win_info->colormap) {
    return 0;
  }

  ncolors = win_info->visual->map_entries;

  if (!(*colors = (XColor *) malloc (sizeof(XColor) * ncolors)))
    ErrMesg("xtof.c","malloc failed in getxcolors()", 1);

  if (win_info->visual->class == DirectColor) {
    Pixel red, green, blue, red1, green1, blue1;

    red = green = blue = 0;
    red1   = lowbit(win_info->visual->red_mask);
    green1 = lowbit(win_info->visual->green_mask);
    blue1  = lowbit(win_info->visual->blue_mask);
    for (i=0; i<ncolors; i++) {
      (*colors)[i].pixel = red|green|blue;
      (*colors)[i].pad = 0;
      red += red1;
      if (red > win_info->visual->red_mask)     red =
						  0;
      green += green1;
      if (green > win_info->visual->green_mask) green
						  = 0;
      blue += blue1;
      if (blue > win_info->visual->blue_mask)   blue =
						  0;
    }
  }
  else {
    for (i=0; i<ncolors; i++) {
      (*colors)[i].pixel = i;
      (*colors)[i].pad = 0;
    }
  }
  XQueryColors(Info_X->theDisp, win_info->colormap, *colors,
	       ncolors);
  return(ncolors);
}

#endif /* USEIMG=2 */

#if USEIMG == 1
/*
 *   Implements GrADS ImageMagick interface.
 *
 *
 *   REVISION HISTORY:
 *
 *   20Dec97   da Silva  Initial prototype.
 *
 *   --
 *   (c) 1997 by Arlindo da Silva
 *
 *   Permission is granted to any individual or institution to use,
 *   modify, copy, or redistribute this software so long as it is not 
 *   sold for profit, and provided this notice is retained. 
 *
 */
/* kk 020624 --- Changing for 64bit version K.Komine */
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#if GRADS_HP64
#include <api.h>
#endif
#include <magick.h>
#include "grads.h"

extern Display       *display;    /* defined in gxX.c */
extern Window         win;          /* defined in gxX.c */
extern char          *window_name;   /* defined in gxX.c */
extern struct gacmn  gcmn;
static int           already_init = 0;


/*-----------------------------------------------------------------*/

/*
 * int
 * img_init --- Initializes things. It also writes msg and returns 1 
 *              if GrADS running in batch mode.
 *
 */

int
img_init()
{
  if ( already_init ) return 0;
  if ( gcmn.batflg ) {
       gaprnt (0,"IMG Error: image functions not available in batch mode\n");
       return 1;
  } 
  already_init = 1;
  return 0;
}


/*
 * int
 * img_write --- Saves current screen to a file using user specified
 *               format supported by ImageMagick API. The file format
 *               is deduced from the file extension.
 *
 */

int
img_write ( char *filename )
{
   Image      *image;
   ImageInfo  image_info;
   char       msg[512], fname[512];
   unsigned int status;

   if (img_init()) return 1;

   strcpy(fname,filename);
   if ( strchr(fname,'.') == NULL ) strcat(fname,".gif");

   GetImageInfo(&image_info);  /* initializes image info */

   image = XGetWindowImage(display, win, 0, 0); /* retrieve image */
   if ( image == (Image *) NULL ) {
        gaprnt(0,"IMG Error: failed to get X image!\n");
        return 1;
   }

   strcpy(image->filename, fname);
   status = WriteImage(&image_info,image);
   DestroyImage(image);

   if ( status == True ) {

/*
 20000127 - this is broken under linux redhat [6,7].?
 problem is value  of image->rows, etc for gif, some work, some don't but
 the outfile is ok

     if(strcmp(image_info.magick,"GIF") == 0) {
       sprintf(msg,"Saved %s image as file: %s\n", image_info.magick, 
	       fname); 
       printf("qqqqqqq\n"); 
     } else {
       sprintf(msg,"Saved %s image as file %s (%dx%dx%d)\n", image_info.magick, 
	       fname, image->rows, image->columns, image->depth );
     }

*/
       sprintf(msg,"Saved %s image as file: %s\n", image_info.magick, 
	       fname); 
     gaprnt(1,msg);
     return 0;
   } else {
        sprintf(msg, "IMG Error: failed to write file %s\n", fname);
        gaprnt(0,msg);
        return 1;
   }


}
#endif /* USEIMG=1 */
