/* Authored by Don Hooper */
/*
 * Include ./configure's header file
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if USESDF == 1
#define Success		1
#define Failure		0

/* Functions related to Self-Describing File (SDF) access.  -hoop, 95/07/10 */
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "grads.h"


/* expose Mike Fiorino's global struct to these for 365 day calendars */
extern struct gamfcmn mfcmn ;

/* expose descriptor global from gaddes.c here so can share w/routines there */
extern FILE *descr ;

/* kk 020624 ---s */
char *gxgnam(char *) ; /* This is also in gx.h */
/* kk 020624 ---e */
static char pout[512];    /* Build error msgs here */

/* Read the metadata from a Self-Describing File and fill in the information */
/* into a gafile structure.  The gafile structure should be allocated and */
/* must be initialized by getpfi.  If this routine returns an error, release */
/* the pfi structure and allocated storage via frepfi.  */

#define XINDEX 0
#define YINDEX 1
#define ZINDEX 2
#define TINDEX 3


int utISinit = 0 ;

/* For STNDALN, routines included are gadxdf and three others contained therein 
   These are used for parsing the descriptors just to see if GrADS will open them */
#ifndef STNDALN

int
gadsdf(char *name, struct gafile *pfi, char *template, int ntsteps, GASDFPARMS parms) {
  struct gavar *pvar;
  struct dt tdef, tdefi, dt1, dt2;
  struct gaindx *pindx;
  float *vals;
  int size, rc, len, swpflg, cnt, boole, boole2 ;
  char *ch, *dn, *pos;
  char *utname; 
  int flgs[8], cflg, i, j, err, hdrb, trlb, mflflg;
  int mcnt, maxlv, maxct, inx, xedni;
  int levs, acum, fpos, recacm, indx, numdvars ;
  int iyr, imo, idy, ihr, imn, isec, ispress, idim, isDatavar ;
  int xdimension_id, ydimension_id, zdimension_id, tdimension_id ;
  short *tempsarry ;
  float temp, v1, v2, *tempfarry, *tempfarry2 ;
  FILE *mfile;
  utUnit timeunit ;
  long start[1] = {0}, count[1] = {1}, tdimsiz ;
  double *time1ptr, *time2ptr, time1, time2, dsec, incrfactor, *tempdarry ;
  VAR_INFO *Xcoord=NULL, *Ycoord=NULL, *Zcoord=NULL, *Tcoord=NULL ;
  VAR_INFO *lclvar, *DataVar=NULL, *SaveDvar=NULL ;
  struct attrib_list *positive_attr, *globttl_attr, *missval_attr ;
  struct attrib_list *deltat_attr, *title_vattr, *timeunits_attr ;
  struct attrib_list *calendar_attr ;
  struct attrib_list *find_att(struct attrib_list *first_att, char *attname) ;
  int read_io_std(char *path, IO_STD *sdf_ptr) ; /* grab metadata */
  int isdvar(VAR_INFO *var, VAR_INFO *Xcoord, VAR_INFO *Ycoord,
	     VAR_INFO *Zcoord, VAR_INFO *Tcoord, int xdimension_id,
	     int ydimension_id, int zdimension_id, int tdimension_id) ;
  void free_io_std(IO_STD **sdf_ptr) ;
  int close_netcdf(int ncid) ;
  /* these routines try to find the right var struct in the */
  /* linked list in the IO_STD structure */
  int findX(IO_STD *sdf_ptr, VAR_INFO **coord) ;
  int findY(IO_STD *sdf_ptr, VAR_INFO **coord) ;
  int findZ(IO_STD *sdf_ptr, VAR_INFO **coord, int *ispressptr) ;
  int findT(IO_STD *sdf_ptr, VAR_INFO **coord) ;
  int sdfdeflev(struct gafile *pfi, VAR_INFO *coord, int GrADSdimnum, int revflag) ;
  int trydeflin(struct gafile *pfi, VAR_INFO *coord, int GrADSdimnum, int isX, int revflag) ;
  int convtype(void *srcptr, nc_type srctype, void *desptr, nc_type destype,
	       int srcindex, int desindex) ;
  int decode_ud_time(utUnit *unit, double time_val, int *yr, int *mo,
		     int *da, int *hr, int *min, double *sec) ;
  int decode_standard_time(double time_val, int *year, int *month, int *day,
			   int *hour, int *minn, double *sec) ;
  int find_dim(IO_STD *std_ptr, char *name) ;
  int find_dimix(int dimids[], int ndims, int dim) ;
  VAR_INFO *find_var(IO_STD *std_ptr, char *name) ;
  int findmatch(char *var_name, char **varnamelist, int namecount, int *inxptr) ;
  int copy_io_std(IO_STD **std_ptr2, IO_STD *std_ptr1) ;

  /* Enable griping, disable aborting, from within NetCDF library */
  ncopts = NC_VERBOSE ;
  if (!utISinit) {
    utname = gxgnam("udunits.dat") ;
    if (utname != NULL) {
      if (utInit(utname)) {
	gaprnt(0, "UDUNITS package initialization failure.\n") ;
	return(1) ;
      }
    }
    utISinit = 1 ;
  } 

  /* Grab the metadata */
  if (!read_io_std(name, pfi->sdf_ptr)) {
    gaprnt(0, "\nCouldn't ingest SDF metadata.\n") ;
#if USEHDF == 0
    gaprnt(0, "If this was an HDF-SDS file, try gradshdf.\n") ;
#endif
    return(1) ;
  }

  if (!parms.isxdf) {
    pfi->calendar = 0 ;  /* 365 day kind not available under COARDS */
    /* But we're going to fake something anyway.  -Hoop, 2001/05/31 */
    /* The code will be in the time coordinate setup section.  */
  }
  if (parms.xsrch) {
    if (!findX(pfi->sdf_ptr, &Xcoord)) {
      gaprnt(0, "SDF file has no discernable X coordinate.\n") ;
      return(1) ;
    }
  } else if (parms.xsetup) {
    Xcoord = find_var(pfi->sdf_ptr, parms.xdimname) ;
    if (!Xcoord) {
      gaprnt(0, "XDF file has no coordinate variable for X dimension.\n") ;
      return(1) ;
    }
  }
  if (parms.ysrch) {
    if (!findY(pfi->sdf_ptr, &Ycoord)) {
      gaprnt(0, "SDF file has no discernable Y coordinate.\n") ;
      return(1) ;
    }
  } else if (parms.ysetup) {
    Ycoord = find_var(pfi->sdf_ptr, parms.ydimname) ;
    if (!Ycoord) {
      gaprnt(0, "XDF file has no coordinate variable for Y dimension.\n") ;
      return(1) ;
    }
  }
  if (parms.tsrch) {
    if (!findT(pfi->sdf_ptr, &Tcoord)) {
      gaprnt(0, "SDF file has no discernable time coordinate.\n") ;
    }
  } else if (parms.tsetup) {
    if (!parms.tdimname) {
      gaprnt(0, "XDF file has no time dimension, but TDEF is incomplete.\n") ;
      gaprnt(0, "Failure parsing XDF-style data descriptor file (DDF).\n") ;
      return(1) ;
    }
    Tcoord = find_var(pfi->sdf_ptr, parms.tdimname) ;
    if (!Tcoord) {
      gaprnt(0, "XDF file has no coordinate variable for T dimension.\n") ;
      return(1) ;
    }
  }
  if (parms.zsrch) {
    (void) findZ(pfi->sdf_ptr, &Zcoord, &ispress) ;

  } else if (parms.zsetup) {
    Zcoord = find_var(pfi->sdf_ptr, parms.zdimname) ;
    if (!Zcoord) {
      gaprnt(0, "XDF file has no coordinate variable for Z dimension.\n") ;
      return(1) ;
    }
  }
#ifdef TESTING
  if (Xcoord) fprintf(stderr, "Using %s as X variable.\n", Xcoord->varnam) ;
  if (Ycoord) fprintf(stderr, "Using %s as Y variable.\n", Ycoord->varnam) ;
  if (Tcoord) fprintf(stderr, "Using %s as T variable.\n", Tcoord->varnam) ;
  if (Zcoord) 
    fprintf(stderr, "Using %s as Z variable.\n", Zcoord->varnam) ;
  else 
    fprintf(stderr, "Didn't find a Z variable.\n") ;

#endif
  if (parms.isxdf && (!parms.tsrch)) {
    if (!(parms.tdimname)) {
      tdimension_id = -1 ;
    } else {
      tdimension_id = find_dim(pfi->sdf_ptr, parms.tdimname) ;
    }
  } else {
    if (Tcoord) {
      tdimension_id = find_dim(pfi->sdf_ptr, Tcoord->varnam) ;
    } else {
      tdimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.zsrch)) {
    zdimension_id = find_dim(pfi->sdf_ptr, parms.zdimname) ;
  } else {
    if (Zcoord) {
      zdimension_id = find_dim(pfi->sdf_ptr, Zcoord->varnam) ;
    } else {
      zdimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.ysrch)) {
    ydimension_id = find_dim(pfi->sdf_ptr, parms.ydimname) ;
  } else {
    if (Ycoord) {
      ydimension_id = find_dim(pfi->sdf_ptr, Ycoord->varnam) ;
    } else {
      ydimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.xsrch)) {
    xdimension_id = find_dim(pfi->sdf_ptr, parms.xdimname) ;
  } else {
    if (Xcoord) {
      xdimension_id = find_dim(pfi->sdf_ptr, Xcoord->varnam) ;
    } else {
      xdimension_id = -1 ;
    }
  }
  if (parms.dvsrch) {
    numdvars = 0 ;
    SaveDvar = pfi->sdf_ptr->var ;
    for (DataVar = pfi->sdf_ptr->var ;  DataVar ;  DataVar = DataVar->next) {
      isDatavar = 0 ;
      isDatavar = isdvar(DataVar, Xcoord, Ycoord, Zcoord, Tcoord,
			 xdimension_id, ydimension_id, zdimension_id,
			 tdimension_id) ;
      if (isDatavar) {
	++numdvars ;
	if (numdvars == 1) /* Use first Dvar found as master */ {
	  SaveDvar = DataVar ;
	}
      }
    } /* for each data variable */
    if (numdvars == 0) /* oh dear... */ {
      gaprnt(0,"SDF file doesn't appear to have any non-coordinate variables. Yikes!\n") ;
      return(1) ;
    } else {
      parms.dvcount = numdvars ;
    }
  } else {
    numdvars = parms.dvcount ;
    for (DataVar = pfi->sdf_ptr->var ;  DataVar ;  DataVar = DataVar->next) {
      if (!strcmp(parms.dvncnames[0], DataVar->varnam)) { /* Use first Dvar as master */
	SaveDvar = DataVar ;
	break ;
      }
    }
    if (!SaveDvar) {
      sprintf(pout,"Couldn't find \"master\" data variable %s in SDF file.\n", parms.dvncnames[0]);
      gaprnt(0,pout);
      return(1);
    }
  }
  if (!parms.isxdf) {
    getwrd(pfi->dnam, name, 4095) ;
  }
  getwrd(pfi->name, name, 4095) ;  /* Is this template or first nc name? */
  /* I dunno about the next 5 lines... -hoop */
  hdrb = 0;
  trlb = 0;
  mflflg = 0;           /* no map file to open */
  pfi->mfile = NULL;
  mcnt = -1;

  if (parms.xsetup) {
    pfi->dnum[XINDEX] = pfi->sdf_ptr->dimsiz[Xcoord->vardimid[0]] ;
    if (!read_one_dimension(pfi->sdf_ptr, Xcoord, Xcoord->vardimid[0])) {
      gaprnt(0, "Failure checking X coordinate of SDF file.\n") ;
      return(1) ;
    }
    rc = trydeflin(pfi, Xcoord, XINDEX, 1, 0) ;
    if (rc < 0) {
      gaprnt(0, "Error evaluating X coordinate of SDF file.\n") ;
      return(1) ;
    }
    if (rc == 0) /* not linear; define levels */ {
      if (sdfdeflev(pfi, Xcoord, XINDEX, 0)) {
	gaprnt(0, "Failure defining X levels for SDF file.\n") ;
	return(1) ;
      }
#ifdef TESTING2
    } else {
      fprintf(stderr, "Using Linear X dim. on SDF file.\n") ;
#endif
    }
  } /* if doing X setup */
  if (parms.ysetup) {
    pfi->dnum[YINDEX] = pfi->sdf_ptr->dimsiz[Ycoord->vardimid[0]] ;
    if ((!read_one_dimension(pfi->sdf_ptr, Ycoord, Ycoord->vardimid[0])) ||
	(!(Ycoord->data))) {
      gaprnt(0, "Failure checking Y coordinate of SDF file.\n") ;
      return(1) ;
    }
    /* Next few lines of code only for Y; not analogous for X, tho' should be */
    tempfarry = (float *) malloc(2 * sizeof(float)) ;
    if (!convtype(Ycoord->data, Ycoord->vartype, tempfarry, NC_FLOAT, 0, 0)) {
      gaprnt(0, "Failure interpreting first Y coordinate value of SDF file.\n") ;
      return(1) ;
    }
    if ( (pfi->dnum[YINDEX]) > 1) {
      if (!convtype(Ycoord->data, Ycoord->vartype, tempfarry, NC_FLOAT, 1, 1)) {
	gaprnt(0, "Failure interpreting second Y coordinate value of SDF file.\n") ;
	return(1) ;
      }
      if (tempfarry[1] < tempfarry[0]) {
	pfi->yrflg = 1 ;
      } else {
	pfi->yrflg = 0 ;
      }
    } else {
      pfi->yrflg = 0 ;
    }
    /* End Y-only code */
    rc = trydeflin(pfi, Ycoord, YINDEX, 0, pfi->yrflg) ;
    if (rc < 0) {
      gaprnt(0, "Error evaluating Y coordinate of SDF file.\n") ;
      return(1) ;
    }
    if (rc == 0) /* not linear; define levels */ {
      if (sdfdeflev(pfi, Ycoord, YINDEX, pfi->yrflg)) {
	gaprnt(0, "Failure defining levels for Y coordinate for SDF file.\n") ;
	return(1) ;
      }
#ifdef TESTING2
    } else {
      fprintf(stderr, "Using Linear Y dim. on SDF file.\n") ;
#endif
    }
  } /* if doing y setup */
  if (parms.zsetup) {
    if (Zcoord) {
      pfi->zrflg = 0 ;
    }
  } /* if doing z setup */
  if (parms.needtitle) {
    globttl_attr = find_att(pfi->sdf_ptr->first_gattr, "title") ;
    if (globttl_attr) {
      if ((globttl_attr->len) > 510) {
	getstr(pfi->title, (char *)(globttl_attr->data), 511) ;
      } else {
	getstr(pfi->title, (char *)(globttl_attr->data), globttl_attr->len) ;
      }
    }
  }
  if (parms.needundef) {
    /* the following is a kludge because, by COARDS conventions, missing_value is */
    /* a per-variable attribute, while GrADS expects it to be global to the data */
    /* file.  So, the first non-coordinate variable is used to set a pseudo- */
    /* global "undefined" value */
    missval_attr = find_att(SaveDvar->first_vattr, "missing_value") ;
    if (!missval_attr) {
      missval_attr = find_att(SaveDvar->first_vattr, "_FillValue") ;
    }
    if (!missval_attr) {
      pfi->undef = FILL_FLOAT ;  /* default _FillValue */
    } else {
      if (missval_attr->type == NC_SHORT) /* KLUDGE! */ {
	pfi->undef = (-1.0) * FILL_FLOAT ;  /* CDC default w/packed data */
      } else /* must be NC_FLOAT or NC_DOUBLE, right?  I hope so... */ {
	if (missval_attr->type == NC_DOUBLE) {
	  tempdarry = (double *) missval_attr->data ;
	  pfi->undef = (float) tempdarry[0] ;
	} else {
	  tempfarry = (float *) missval_attr->data ;
	  pfi->undef = tempfarry[0] ;
	}
      }
    } /* there was a missing value of some name */
  } /* if undef needs to be set */ /* next if MAY need to be moved before this line */
  if (SETMISS) {
    /* Gads...  Will these statements work OK when pfi->undef is -infinity? */
    pfi->ulow = fabs(pfi->undef/EPSILON);
    pfi->uhi = pfi->undef + pfi->ulow;
    pfi->ulow = pfi->undef - pfi->ulow;
  }

  if (parms.zsetup) {
    if (!Zcoord) {
      pfi->dnum[ZINDEX] = 1 ;
      /* These lines adapted from deflin routine */
      tempfarry = (float *) malloc(sizeof(float) * 6) ;
      if (!tempfarry) {
	gaprnt(0, "Error evaluating fixed Z coordinate in SDF file.\n") ;
	return(1) ;
      }
      tempfarry[0] = 0.0 ;
      tempfarry[1] = 0.0 ; /* can do better if interp. level_desc attr. */
      tempfarry[2] = -999.9 ;
      tempfarry[3] = 1.0 ;
      tempfarry[4] = 1.0 ;
      tempfarry[5] = -999.9 ;
      pfi->grvals[ZINDEX] = tempfarry ;
      pfi->abvals[ZINDEX] = tempfarry + 3 ;
      pfi->ab2gr[ZINDEX] = liconv ;
      pfi->gr2ab[ZINDEX] = liconv ;
      pfi->linear[ZINDEX] = 1 ;
      /* end of lines adapted from deflin routine */
    } else /* not a dummy; an actual Z coordinate variable */ {
      pfi->dnum[ZINDEX] = pfi->sdf_ptr->dimsiz[Zcoord->vardimid[0]] ;
      if (!read_one_dimension(pfi->sdf_ptr, Zcoord, Zcoord->vardimid[0])) {
	gaprnt(0, "Failure checking Z coordinate of SDF file.\n") ;
	return(1) ;
      }
      tempfarry = (float *) malloc(2 * sizeof(float)) ;
      if (!convtype(Zcoord->data, Zcoord->vartype, tempfarry, NC_FLOAT, 0, 0)) {
	gaprnt(0, "Failure interpreting first Z coordinate value of SDF file.\n") ;
	return(1) ;
      }
      if (pfi->dnum[ZINDEX] > 1) {
	if (!convtype(Zcoord->data, Zcoord->vartype, tempfarry,
		      NC_FLOAT, 1, 1)) {
	  gaprnt(0, "Failure interpreting second Z coordinate value of SDF file.\n") ;
	  return(1) ;
	}
	positive_attr = find_att(Zcoord->first_vattr, "positive") ;
	if (positive_attr) {
	  if (!strncmp("down", (char *) (positive_attr->data), 4)) {
	    /* positive:down */
	    if (tempfarry[1] > tempfarry[0]) /* ascending Z values */ {
	      pfi->zrflg = 1 ;
	    } else {
	      pfi->zrflg = 0 ;
	    }
	  } else /* positive:up */ {
	    if (tempfarry[1] > tempfarry[0]) /* ascending Z values */ {
	      pfi->zrflg = 0 ;
	    } else {
	      pfi->zrflg = 1 ;
	    }
	  }
	}
	if (sdfdeflev(pfi, Zcoord, ZINDEX, pfi->zrflg)) {
#ifdef TESTING
	  fprintf(stderr, "sdfdeflev failed on Zcoord.\n") ;
#endif
	  gaprnt(0, "Couldn't define Z-axis usinng LEVELS method.\n") ;
	  return(1) ;
	} /* sdfdeflev */
      } else /* 1 Z value, so it linearly */ {
	/* These lines adapted from deflin routine */
	tempfarry2 = (float *) malloc(sizeof(float) * 6) ;
	if (!tempfarry2) {
	  gaprnt(0, "Error evaluating solo Z coordinate in SDF file.\n") ;
	  return(1) ;
	}
	tempfarry2[0] = 1.0 ;
	tempfarry2[1] = tempfarry[0] - 1.0 ;
	tempfarry2[2] = -999.9 ;
	tempfarry2[3] = 1.0 ;
	tempfarry2[4] = 1.0 - tempfarry[0] ;
	tempfarry2[5] = -999.9 ;
	pfi->grvals[ZINDEX] = tempfarry2 ;
	pfi->abvals[ZINDEX] = tempfarry2 + 3 ;
	pfi->ab2gr[ZINDEX] = liconv ;
	pfi->gr2ab[ZINDEX] = liconv ;
	pfi->linear[ZINDEX] = 1 ;
	/* end of lines adapted from deflin routine */
      } /* one Z coord. value */
    } /* setting up actual Z coordinate variable */
  } /* if parms say setup Z coordinate */
  if (parms.tsetup) {
    /* Initial setting only; could be updated if templating */
    if (!Tcoord) /* fake the time coord */ {
      pfi->dnum[TINDEX] = 1 ;
      tempfarry = (float *) malloc(sizeof(float) * 8) ;
      if (!tempfarry) {
	gaprnt(0, "Error finding storage to define time coordinate in SDF file.\n") ;
	return(1) ;
      }
      tempfarry[7] = -999.9 ;
      pfi->grvals[TINDEX] = tempfarry ;
      pfi->abvals[TINDEX] = tempfarry ;
      pfi->linear[TINDEX] = 1 ;
      tempfarry[0] = 1.0 ;
      tempfarry[1] = 1.0 ;
      tempfarry[2] = 1.0 ;
      tempfarry[3] = 0.0 ; /* initial hours */
      tempfarry[4] = 0.0 ;
      tempfarry[5] = 0.0 ; /* step in months */
      tempfarry[6] = 1.0 ; /* step in minutes */
    } else {
      calendar_attr = find_att(Tcoord->first_vattr, CALENDAR) ;
      if (calendar_attr) {
	if (!strcasecmp(CAL365, (char *) (calendar_attr->data))) {
	  mfcmn.cal365 = pfi->calendar = 1;
	}
	if (!strcasecmp(ALTCAL365, (char *) (calendar_attr->data))) {
	  mfcmn.cal365 = pfi->calendar = 1;
	}
      }
      pfi->dnum[TINDEX] = pfi->sdf_ptr->dimsiz[Tcoord->vardimid[0]] ;
      timeunits_attr = find_att(Tcoord->first_vattr, "units") ;
      if (!timeunits_attr) {
	gaprnt(0, "Couldn't find units attribute for Time coordinate of SDF file.\n") ;
	return(1) ;
      }
#if USEHDF == 1
      if (!read_variable_data(pfi->sdf_ptr->cdfid, Tcoord, start, count)) {
	gaprnt(0, "Error reading initial time value in SDF file.\n") ;
	return(1) ;
      }
      time1ptr = &time1 ;
      if (!convtype(Tcoord->data, Tcoord->vartype, time1ptr, NC_DOUBLE, 0, 0)) {
	gaprnt(0, "Error interpreting initial time value in SDF file.\n") ;
	return(1) ;
      }
      if (pfi->dnum[TINDEX] > 1) /* deduce increment */ {
	(start[0])++ ; /* set up to read second time value */
	if (!read_variable_data(pfi->sdf_ptr->cdfid, Tcoord, start, count)) {
	  gaprnt(0, "Error reading second time value in SDF file.\n") ;
	  return(1) ;
	}
	(start[0])-- ; /* reset it in case we need it again */
	time2ptr = &time2 ;
	if (!convtype(Tcoord->data, Tcoord->vartype, time2ptr, NC_DOUBLE, 0, 0)) {
	  gaprnt(0, "Error interpreting second time value in SDF file.\n") ;
	  return(1) ;
	}
      } else {
	time2 = time1 + 1 ; /* fake for single timestep files */
      }
#else
      if (pfi->dnum[TINDEX] > 1) /* deduce increment */ {
	count[0] = 2 ; /* read both time vals at once for DODS bug */
	if (!read_variable_data(pfi->sdf_ptr->cdfid, Tcoord, start, count)) {
	  gaprnt(0, "Error reading initial two time values in SDF file.\n") ;
	  return(1) ;
	}
	count[0] = 1 ; /* restore for other calls, if any */
	time1ptr = &time1 ;
	if (!convtype(Tcoord->data, Tcoord->vartype, time1ptr, NC_DOUBLE, 0, 0)) {
	  gaprnt(0, "Error interpreting initial time value in SDF file.\n") ;
	  return(1) ;
	}
	time2ptr = &time2 ;
	if (!convtype(Tcoord->data, Tcoord->vartype, time2ptr, NC_DOUBLE, 1, 0)) {
	  gaprnt(0, "Error interpreting second time value in SDF file.\n") ;
	  return(1) ;
	}
      } else /* fake it when only 1 timestep exists */ {
	if (!read_variable_data(pfi->sdf_ptr->cdfid, Tcoord, start, count)) {
	  gaprnt(0, "Error reading initial time value in SDF file.\n") ;
	  return(1) ;
	}
	time1ptr = &time1 ;
	if (!convtype(Tcoord->data, Tcoord->vartype, time1ptr, NC_DOUBLE, 0, 0)) {
	  gaprnt(0, "Error interpreting initial time value in SDF file.\n") ;
	  return(1) ;
	}
	time2 = time1 + 1 ; /* a kludge, of course */
      }
#endif
      tempfarry = (float *) malloc(sizeof(float) * 8) ;
      if (!tempfarry) {
	gaprnt(0,
	       "Error finding storage to define time coordinate in SDF file.\n") ;
	return(1) ;
      }
      tempfarry[7] = -999.9 ;
      pfi->grvals[TINDEX] = tempfarry ;
      pfi->abvals[TINDEX] = tempfarry ;
      pfi->linear[TINDEX] = 1 ;
      if ((timeunits_attr->len < 10) &&
	  (!strncmp((char *)timeunits_attr->data, "YYMMDDHH", 8))) /*GSFC time */{
	tempfarry[0] = (float) (((int) time1) / 1000000) ;
	tempfarry[1] = (float) ((((int) time1) / 10000) % 100) ;
	tempfarry[2] = (float) ((((int) time1) / 100) % 100) ;
	tempfarry[3] = (float) (((int) time1) % 100) ;
	tempfarry[4] =  0.0 ;
	if (pfi->dnum[TINDEX] > 1) /* deduce increment */ {
	  dt2.yr = (((int) time2) / 1000000) - (((int) time1) / 1000000) ;
	  dt2.mo = ((((int) time2) / 10000) % 100) -
	    ((((int) time1) / 10000) % 100) ;
	  dt2.dy = ((((int) time2) / 100) % 100) -
	    ((((int) time1) / 100) % 100) ;
	  dt2.hr = (((int) time2) % 100) - (((int) time1) % 100) ;
	  dt2.mn = 0 ;
	  if ((dt2.yr > 0) || (dt2.mo > 0)) {
	    tempfarry[5] = (dt2.yr * 12.0) + dt2.mo ;
	    tempfarry[6] = 0.0 ;
	  } else {
	    tempfarry[5] = 0.0 ;
	    tempfarry[6] = (dt2.dy * 1440.0) + (dt2.hr * 60.0) + dt2.mn ;
	    if (tempfarry[6] < 1.0) {
	      gaprnt(0, "Time unit in SDF file has too small an increment (min. 1 minute).\n") ;
	      return(1) ;
	    }
	  }
	} else /* one time step exists */ {
	  tempfarry[5] = 0.0 ;
	  tempfarry[6] = 1.0 ; /* KLUDGE for one time-step files */
	}
      } else if (pfi->sdf_ptr->time_type == CDC) /* handle YYYYMMDDHHMMSS time */ {
	if (!decode_standard_time(time1, &iyr, &imo, &idy, &ihr, &imn, &dsec)) {
	  gaprnt(0, "Error deciphering initial time value in SDF file.\n") ;
	  return(1) ;
	}
	if (iyr <= 0) iyr = 1 ;
	if (imo <= 0) imo = 1 ;
	if (idy <= 0) idy = 1 ;
	tempfarry[0] = (float) iyr ;
	tempfarry[1] = (float) imo ;
	tempfarry[2] = (float) idy ;
	tempfarry[3] = (float) ihr ;
	tempfarry[4] = (float) imn ;
	/* will cop out here and assume delta_t attribute exists, as divining the */
	/* increment from the first two values is too messy to contemplate */
	if (pfi->dnum[TINDEX] > 1) {
	  deltat_attr = find_att(Tcoord->first_vattr, "delta_t") ;
	  if (!deltat_attr) {
	    gaprnt(0, "Error in determining time increment in SDF file.\n") ;
	    return(1) ;
	  }
	  ch = (char *) deltat_attr->data ;
	  if (!decode_delta_t(ch, &dt2.yr, &dt2.mo, &dt2.dy, &dt2.hr, &dt2.mn, &isec)) {
	    gaprnt(0, "Error deciphering time increment in SDF file.\n") ;
	    return(1) ;
	  }
	  if ((dt2.yr > 0) || (dt2.mo > 0)) {
	    tempfarry[5] = (dt2.yr * 12.0) + dt2.mo ;
	    tempfarry[6] = 0.0 ;
	  } else {
	    tempfarry[5] = 0.0 ;
	    tempfarry[6] = (dt2.dy * 1440.0) + (dt2.hr * 60.0) + dt2.mn ;
	    if (tempfarry[6] < 1.0) {
	      gaprnt(0, "Time unit in SDF file has too small an increment (min. 1 minute).\n") ;
	      return(1) ;
	    }
	  }
	  /* Yet Another Kludge:  any seconds value in SDF file is ignored as minute */
	  /* is the finest resolution in GrADS */
	} else {
	  tempfarry[5] = 0.0 ;
	  tempfarry[6] = 1.0 ; /* KLUDGE for one time-step files */
	}
      } else /* assume udunits time */ {
	char *time_units = (char *) 0 ;
	int len_time_units ;
#define DFLTORIGIN " since 1-1-1 00:00:0.0"

	if (!strncmp((char *) timeunits_attr->data, "common_year", 11)) {
	  mfcmn.cal365 = pfi->calendar = 1;
	} /* that's the first step.  Now, have add new matches */
	if (!strstr((char *) timeunits_attr->data, " since ")) /* no origin */ {
	  len_time_units = (int) strlen((char *) timeunits_attr->data)
	    + (int) strlen(DFLTORIGIN) + 1 ;
	  time_units = (char *) malloc((size_t) len_time_units) ;
	  if (!time_units) {
	    gaprnt(0, "Malloc error generating time_units for SDF file.\n") ;
	    return(1) ;
	  }
	  strcpy(time_units, (char *) timeunits_attr->data) ;
	  strcat(time_units, DFLTORIGIN) ;
	}
	if (time_units) /* use units with default origin */ {
	  if (utScan(time_units, &timeunit)) {
	    gaprnt(0, "Error parsing time_units for SDF file.\n") ;
	    return(1) ;
	  }
	} else {
	  if (!get_ud_time_unit(Tcoord, &timeunit)) {
	    gaprnt(0, "Error parsing UDUNITS time units in SDF file.\n") ;
	    return(1) ;
	  }
	  time_units = (char *) timeunits_attr->data ;
	} /* using file's time units */
	if (!decode_ud_time(&timeunit, time1, &iyr, &imo, &idy, &ihr, &imn,
			    &dsec)) {
	  gaprnt(0,
		 "Error decoding initial udunits time value in SDF file.\n") ;
	  return(1) ;
	}
	if (imo == 0) imo = 1 ;
	if (idy == 0) idy = 1 ;
	tempfarry[0] = (float) iyr ;
	tempfarry[1] = (float) imo ;
	tempfarry[2] = (float) idy ;
	tempfarry[3] = (float) ihr ;
	tempfarry[4] = (float) imn ;
	if (pfi->dnum[TINDEX] > 1) /* deduce increment */ {
	  int compare_units(char *test_units, char *trunc_units) ;
	  char *trunc_units, *temp_str ;
	  int trunc_point ;
		    
	  temp_str = strstr(time_units, " since ") ;
	  /* the above guaranteed to succeed since default origin added if need be */
	  if (!temp_str) /* just in case, though */ {
	    trunc_point = strlen(time_units) ;
	  } else {
	    trunc_point = (int) (temp_str - time_units) ;
	  }
	  trunc_units = (char *) malloc(sizeof(char) * (size_t) (trunc_point+1)) ;
	  strncpy(trunc_units, time_units, trunc_point) ;
	  trunc_units[trunc_point] = '\0' ;
	  start[0] = 1 ;
	  incrfactor = time2 - time1 ;
	  if (compare_units("year", trunc_units)) /* match is 1 */ {
	    tempfarry[5] = 12.0 * ((float) incrfactor) ;
	    if (tempfarry[5] < 1.0) {
	      gaprnt(0, "Time unit in SDF file has too small an increment (min. 1 minute).\n") ;
	      return(1) ;
	    }
	    tempfarry[6] = 0.0 ;
	  } else {
	    /* COARDS conventions say only year, day, hour, and minute are OK, not month */
	    /* But I've accepted Camiel's patch for "months since ..."  -Hoop 2K/07/25 */
	    tempfarry[5] = 0.0 ;
	    /* CAS: Added month support */
	    if ((!strncmp(time_units, "month", 5)) ||
		(!strncmp(time_units, "common_year/12", 14)) ||
		(!strncmp(time_units, "common_years/12", 15))) {
	      /*                        if (compare_units("month", trunc_units)) { */
	      /* I doubt udunits will help us with units of "month" */
	      tempfarry[5] = ((float) incrfactor) ;
	      tempfarry[6] = 0.0 ;
	      if (tempfarry[5] < 1.0) {
		gaprnt(0, "SDF:  Fractional months are ill-defined and not supported by GrADS\n") ;
		return(1) ;
	      }
	      /* CAS: End of month support */
	    } else if (compare_units("day", trunc_units)) {
	      if (incrfactor < 28.0) {
		tempfarry[6] = ((float) incrfactor) * 24.0 * 60.0 ;
		if (tempfarry[6] < 1.0) {
		  gaprnt(0, "SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		  return(1) ;
		}
	      } else if (incrfactor < 360.0) /* assume really months */ {
		/* This dirty trick should get the right number of months for monthly, */
		/* bi-monthly, and seasonal data.  If there's anything between that and */
		/* annual data (which should have units of "year(s) since"), we're broken */
		tempfarry[5] = (float)(((int) (incrfactor + 0.5)) / 28) ;
		tempfarry[6] = 0.0 ;
		if (tempfarry[5] < 1.0) {
		  gaprnt(0, "SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		  return(1) ;
		}
	      } else /* annual or multi-annual w/"days since" */{
		/* also a dirty trick to figure out how many years & mult. by 12 */
		tempfarry[5] =
		  12.0 * ((float)(((int) (incrfactor + 0.5))/360)) ;
		tempfarry[6] = 0.0 ;
	      }
	    } else if (compare_units("hour", trunc_units)) {
	      if (incrfactor < (28.0 * 24.0)) {
		tempfarry[6] = ((float) incrfactor) * 60.0 ;
		if (tempfarry[6] < 1.0) {
		  gaprnt(0, "SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		  return(1) ;
		}
	      } else  {
		if (incrfactor >= (360 * 24)) /* try years? */{
		  tempfarry[5] = 12.0 * ((float) ((int)
						  (((int)(incrfactor + 0.5)) / (360.0 * 24.0)))) ;
		  tempfarry[6] = 0.0 ;
		} else /* assume really months */ {
		  tempfarry[5] = (float) (((int) (incrfactor + 0.5))/
					  (28 * 24)) ;
		  tempfarry[6] = 0.0 ;
		}
		if (tempfarry[5] < 1.0) {
		  gaprnt(0, "SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		  return(1) ;
		}
	      }
	    } else if (compare_units("minute", trunc_units)) {
	      if (incrfactor < (60.0 * 24.0 * 28.0)) {
		tempfarry[5] = 0.0 ;
		tempfarry[6] = (float) incrfactor ;
		if (tempfarry[6] < 1.0) {
		  gaprnt(0, "SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		  return(1) ;
		}
	      } else /* monthly or greater */ {
		if (tempfarry[6] < (60.0 * 24.0 * 360.0)) {
		  tempfarry[5] =
		    (float) (((int) ((incrfactor / (60.0 * 24.0)) + 0.5)) / 28) ;
		  tempfarry[6] = 0.0 ;
		} else {
		  gaprnt(0,"SDF:  Attempt at >monthly increment with 'minutes since' time units attribute value.\n") ;
		  return(1) ;
		}
	      }
	    } else if (compare_units("seconds", trunc_units)) {
	      if (incrfactor < 60.0) {
		gaprnt(0,"SDF:  Time unit has too small an increment (min. 1 minute).\n") ;
		return(1) ;
	      } else {
		if (incrfactor < (60.0 * 60.0 * 24.0 * 28.0)) {
		  /* less than monthly, so use tempfarry[6] */
		  tempfarry[6] = incrfactor / 60.0 ;
		} else /* monthly or greater */ {
		  if (incrfactor < (60.0 * 60.0 * 24.0 * 360)) {
		    /* assume monthly */
		    tempfarry[5] =
		      (float) (((int) ((incrfactor/(60.0 * 60.0 * 24.0)) + 0.5)) / 28) ;
		    tempfarry[6] = 0.0 ;
		  } else {
		    gaprnt(0,"SDF:  Attempt at > monthly interval with 'seconds since' time units attribute.\n") ;
		    return(1) ;
		  }
		}
	      }
	    } else {
	      gaprnt(0, "Error parsing time units in SDF file.\n") ;
	      return(1) ;
	    }
	  } /* finer than years resolution */
	  if (trunc_units) free(trunc_units) ;
	} else {
	  tempfarry[5] = 0.0 ;
	  tempfarry[6] = 1.0 ; /* KLUDGE for one time-step files */
	} /* end deduce increment */
#ifdef TESTING
	fprintf(stderr, "time1=%lf, time2=%lf, incrfactor=%lf.\n", time1, time2,
		incrfactor) ;
	fprintf(stderr, "tempfarry={%f, %f, %f, %f, %f, %f, %f}.\n", tempfarry[0],
		tempfarry[1], tempfarry[2], tempfarry[3], tempfarry[4],
		tempfarry[5], tempfarry[6]) ;
	fprintf(stderr, "diminq return=%d, time dimsize=%ld.\n",
		ncdiminq(pfi->sdf_ptr->cdfid,3,(char *)0,&tdimsiz), tdimsiz) ;
#endif
      } /* end if udunits time */
    } /* has a T coordinate */
  } /* doing T setup */
  if (parms.dvsrch) {
    pfi->vnum =  numdvars ; 
    parms.dvcount = pfi->vnum ;
    pfi->ivnum = pfi->lvnum = 0 ;
    size = numdvars * sizeof(struct gavar) ;
    pvar = (struct gavar *) malloc(size);
    pfi->pvar1 = pvar;
    parms.dvcount = numdvars ;
    parms.dvsetup = (int *) malloc(numdvars * sizeof(int)) ;
    for (xedni = 0 ;  xedni < pfi->vnum ;  ++xedni) {
      parms.dvsetup[xedni] = 1 ;
    }
  } else {
    pvar = pfi->pvar1 ;
  }
  if (parms.isxdf) {
    int xdfopenerr ;

    xdfopenerr = 0 ;
    if (!parms.tsrch) {
      if (parms.tdimname) {
	if (find_dim(pfi->sdf_ptr, parms.tdimname) == -1) {
	  gaprnt(0,"Alleged time dimension (from TDEF) is not an SDF dimension.  Cannot continue.\n") ;
	  gaprnt(0,"Time dimension name is:\n") ;
	  gaprnt(0,parms.tdimname) ;
	  gaprnt(0,"\n.\n") ;
	  xdfopenerr = 1 ;
	}
      }
    }
    if ((!parms.zsrch) && (find_dim(pfi->sdf_ptr, parms.zdimname) == -1)) {
      gaprnt(0,"Alleged level dimension (from ZDEF) is not an SDF dimension.  Cannot continue.\n") ;
      gaprnt(0,"Level dimension name is:\n") ;
      gaprnt(0,parms.zdimname) ;
      gaprnt(0,"\n.\n") ;
      xdfopenerr = 2 ;
    }
    if ((!parms.ysrch) && (find_dim(pfi->sdf_ptr, parms.ydimname) == -1)) {
      gaprnt(0,"Alleged lon dimension (from YDEF) is not an SDF dimension.  Cannot continue.\n") ;
      gaprnt(0,"Lon dimension name is:\n") ;
      gaprnt(0,parms.ydimname) ;
      gaprnt(0,"\n.\n") ;
      xdfopenerr = 3 ;
    }
    if ((!parms.xsrch) && (find_dim(pfi->sdf_ptr, parms.xdimname) == -1)) {
      gaprnt(0,"Alleged lat dimension (from XDEF) is not an SDF dimension.  Cannot continue.\n") ;
      gaprnt(0,"Lat dimension name is:\n") ;
      gaprnt(0,parms.xdimname) ;
      gaprnt(0,"\n.\n") ;
      xdfopenerr = 4 ;
    }
    if (xdfopenerr) {
      return(1) ;
    }
  } /* if it's from xdfopen */
  if (parms.isxdf && (!parms.tsrch)) {
    if (!parms.tdimname) {
      tdimension_id = -1 ;
    } else {
      tdimension_id = find_dim(pfi->sdf_ptr, parms.tdimname) ;
    }
  } else {
    if (Tcoord) {
      tdimension_id = find_dim(pfi->sdf_ptr, Tcoord->varnam) ;
    } else {
      tdimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.zsrch)) {
    zdimension_id = find_dim(pfi->sdf_ptr, parms.zdimname) ;
  } else {
    if (Zcoord) {
      zdimension_id = find_dim(pfi->sdf_ptr, Zcoord->varnam) ;
    } else {
      zdimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.ysrch)) {
    ydimension_id = find_dim(pfi->sdf_ptr, parms.ydimname) ;
  } else {
    if (Ycoord) {
      ydimension_id = find_dim(pfi->sdf_ptr, Ycoord->varnam) ;
    } else {
      ydimension_id = -1 ;
    }
  }
  if (parms.isxdf && (!parms.xsrch)) {
    xdimension_id = find_dim(pfi->sdf_ptr, parms.xdimname) ;
  } else {
    if (Xcoord) {
      xdimension_id = find_dim(pfi->sdf_ptr, Xcoord->varnam) ;
    } else {
      xdimension_id = -1 ;
    }
  }
  for (lclvar = pfi->sdf_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
    if (parms.isxdf && (!parms.dvsrch)) {
      boole = findmatch(lclvar->varnam, parms.dvncnames, parms.dvcount,
			&inx) ;
      if (boole) {
	while (strcmp(pvar->abbrv, parms.dvganames[inx])) {
	  pvar++ ;
	} /* so we mess with right pvar from gadxdf */
      }
    } else {
      boole = isdvar(lclvar, Xcoord, Ycoord, Zcoord, Tcoord,
		     xdimension_id, ydimension_id, zdimension_id,
		     tdimension_id) ;
    }
    if (boole) {
      if (parms.isxdf && (!parms.tsrch)) {
	if (!(parms.tdimname)) /* tdim-less support */ {
	  lclvar->dimidmap[0] = -1 ;
	  lclvar->dimmap[0] = -1 ;
	} else {
	  lclvar->dimidmap[0] = tdimension_id ;
	  lclvar->dimmap[0] =
	    find_dimix(lclvar->vardimid, lclvar->nvardims,
		       lclvar->dimidmap[0]) ;
	}
      } else {
	if (Tcoord) {
	  lclvar->dimidmap[0] = tdimension_id ;
	  lclvar->dimmap[0] = find_dimix(lclvar->vardimid,
					 lclvar->nvardims, lclvar->dimidmap[0]) ;
	} /* leave -1 otherwise and if not in this dvar */
      }
      if (parms.isxdf  && (!parms.zsrch)) {
	lclvar->dimidmap[1] = zdimension_id ;
	lclvar->dimmap[1] =
	  find_dimix(lclvar->vardimid, lclvar->nvardims,
		     lclvar->dimidmap[1]) ;
      } else {
	if (Zcoord) {
	  lclvar->dimidmap[1] = zdimension_id ;
	  lclvar->dimmap[1] =
	    find_dimix(lclvar->vardimid, lclvar->nvardims,
		       lclvar->dimidmap[1]) ;
	} /* leave -1 otherwise and if not in this dvar */
      }
      if (parms.isxdf && (!parms.ysrch)) {
	lclvar->dimidmap[2] = ydimension_id ;
      } else {
	lclvar->dimidmap[2] = ydimension_id ;
      }
      lclvar->dimmap[2] = find_dimix(lclvar->vardimid, lclvar->nvardims,
				     lclvar->dimidmap[2]) ;
      if (parms.isxdf && (!parms.xsrch)) {
	lclvar->dimidmap[3] = xdimension_id ;
      } else {
	lclvar->dimidmap[3] = xdimension_id ;
      }
      lclvar->dimmap[3] = find_dimix(lclvar->vardimid, lclvar->nvardims,
				     lclvar->dimidmap[3]) ;
      boole2 = 0 ;
      if (!(parms.isxdf)) {
	boole2 = 1 ;
      } else {
	if (parms.dvsrch) {
	  boole2 = 1 ;
	} else {
	  if ((parms.dvcount > inx) && (parms.dvsetup[inx])) {
	    boole2 = 1 ;
	  } else {
	    boole2 = 0 ;
	  }
	}
      }
      if (boole2) {
	if ((!(parms.isxdf)) || (parms.dvsrch)) {
	  /* if we got the data variables by searching in this routine */
	  strncpy(pvar->abbrv, lclvar->varnam, 15) ;
	  pvar->abbrv[15] = '\0' ;
	  lowcas(pvar->abbrv) ;
	}
	strcpy(lclvar->gradsabbr, pvar->abbrv) ;
	if (lclvar->dimmap[1] != -1) {
	  pvar->levels = pfi->dnum[ZINDEX] ;  /* by def'n in SDF file */
	  ++(pfi->lvnum) ;
	} else {
	  pvar->levels = 0 ;  /* I hope that's right... */
	  ++(pfi->ivnum) ;
	}
	for (j = 0 ;  j < 4 ;  j++) pvar->units[j] = -999;
	if (!(title_vattr = find_att(lclvar->first_vattr, "long_name"))) {
	  /* gad, I hope it's an old CDC standard file */
	  if (!(title_vattr = find_att(lclvar->first_vattr, "title"))) {
	    /* give up */
	    pvar->varnm[0] = '\0' ;
	  }
	}
	if (title_vattr) {
	  if (title_vattr->len > 79) {
	    strncpy(pvar->varnm, (char *)(title_vattr->data), 79) ;
	    pvar->varnm[79] = '\0' ;
	  } else {
	    strncpy(pvar->varnm, (char *)(title_vattr->data),
		    title_vattr->len) ;
	    pvar->varnm[title_vattr->len] = '\0' ;
	  }
	}
	pvar->offset = 0 ;
	pvar->recoff = 0 ;
	pvar->dfrm = 0 ;
	pvar->var_t = 0 ;
	pvar->var_z = 0 ;
	pvar->y_x = 0 ;
      } else {
	strcpy(lclvar->gradsabbr, pvar->abbrv) ;
      }
      if (lclvar->vartype == NC_DOUBLE) {
	sprintf(pout,"SDF:  The double precision values of the variable %s\n", pvar->abbrv) ;
	strcat(pout,"will be automatically converted to single precision.\n") ;
	gaprnt(0, pout) ;
      }
      if (parms.needundef) /* need to divine it now */ {
	/* get missing_value attribute value, and stuff it into lclvar->missing_value */
	missval_attr = find_att(lclvar->first_vattr, "missing_value") ;
	if (!missval_attr) {
	  missval_attr = find_att(lclvar->first_vattr, "_FillValue") ;
	}
	/* if the type of the data variable and that of the missing_value attribute */
	/* don't match, use the default, as we do if we have no attribute */
	if ((!missval_attr) || (missval_attr->type != lclvar->vartype)) {
	  switch (lclvar->vartype) {
	  case NC_BYTE:
	    lclvar->missing_value.bval = FILL_BYTE ;
	    break ;
	  case NC_SHORT:
	    lclvar->missing_value.sval = FILL_SHORT ;
	    break ;
	  case NC_LONG:
	    lclvar->missing_value.lval = FILL_LONG ;
	    break ;
	  case NC_FLOAT:
	    lclvar->missing_value.fval = FILL_FLOAT ;
	    break ;
	  case NC_DOUBLE:
	    lclvar->missing_value.dval = FILL_DOUBLE ;
	    break ;
	  } /* end switch */
	} else /* have an attribute value and types match */ {
	  switch (lclvar->vartype) {
	  case NC_BYTE:
	    lclvar->missing_value.bval = *((signed char *)missval_attr->data) ;
	    break ;
	  case NC_SHORT:
	    lclvar->missing_value.sval = *((short *)missval_attr->data) ;
	    break ;
	  case NC_LONG:
	    lclvar->missing_value.lval = *((long *)missval_attr->data) ;
	    break ;
	  case NC_FLOAT:
	    lclvar->missing_value.fval = *((float *)missval_attr->data) ;
	    break ;
	  case NC_DOUBLE:
	    lclvar->missing_value.dval = *((double *)missval_attr->data) ;
	    break ;
	  } /* end switch */
	} /* else is have attribute and types match */
      } else /* use value from UNDEF statement in DDF */ {
	lclvar->missing_value.fval = pfi->undef ; /* always float */
	if (parms.hasDDFundef) {
	  pfi->sdf_ptr->hasDDFundef = 1 ;
	}
      } /* end if need to get missing_value attribute value */
      if (parms.isxdf && (!parms.dvsrch)) {
	pvar = pfi->pvar1 ; /* reset for searching out next one */
      } else {
	pvar++;
      }
    }
  } /* end for each var in SDF file or descriptor file varlist */
  /* Figure out locations of variables within a time group ( N.A. ) */

  /* Allocate an I/O buffer the size of one grid */

  maxlv = pfi->dnum[ZINDEX] ;
  if (pfi->type > 1) {
    size = maxlv * sizeof(float);
  } else {
    size = pfi->dnum[XINDEX] * pfi->dnum[YINDEX] * sizeof(float);
  }

  /* If the file name is a time series template, figure out
     which times go with which files, so we don't waste a lot
     of time later opening and closing files unnecessarily. */

  if ((!(parms.isxdf)) && (pfi->tmplat)) {
    pfi->dnum[TINDEX] = ntsteps ;
    strcpy(pfi->name, template) ;
    pfi->fnums = (int *) malloc(sizeof(int) * pfi->dnum[TINDEX]) ;
    if (pfi->fnums == NULL) {
      gaprnt(0, "SDFOPEN error:  Memory allocation error.\n") ;
      /* what could I do if close_netcdf did bomb? */
      (void) close_netcdf(pfi->sdf_ptr->cdfid) ;
      if ((pfi->sdf_ptr) == (pfi->first_sdf_ptr)) {
	pfi->first_sdf_ptr = (IO_STD *) 0 ;
      }
      free_io_std(&(pfi->sdf_ptr)) ;
      return(1) ;
    }
    j = 1 ;
    gr2t(pfi->grvals[TINDEX], 1.0, &tdefi) ;
    ch = gafndt(pfi->name, &tdefi, &tdefi, pfi->abvals[TINDEX], NULL, 1) ;
    if (ch == NULL) {
      gaprnt(0, "SDFOPEN error:  Memory allocation error.\n") ;
      (void) close_netcdf(pfi->sdf_ptr->cdfid) ;
      if ((pfi->sdf_ptr) == (pfi->first_sdf_ptr)) {
	pfi->first_sdf_ptr = (IO_STD *) 0 ;
      }
      free_io_std(&(pfi->sdf_ptr)) ;
      return(1) ;
    }
    pfi->fnums[0] = j ;
    for (i = 2 ;  i <= pfi->dnum[TINDEX] ;  ++i) {
      gr2t(pfi->grvals[TINDEX], (float) i, &tdef) ;
      pos = gafndt(pfi->name, &tdef, &tdefi, pfi->abvals[TINDEX], NULL, 1) ;
      if (pos == NULL) {
        gaprnt(0, "SDFOPEN error:  Memory allocation error.\n") ;
        (void) close_netcdf(pfi->sdf_ptr->cdfid) ;
	free_io_std(&(pfi->sdf_ptr)) ;
	return(1) ;
      }
      if (strcmp(ch, pos) != 0) {
        j = i ;
	if (ch) {
	  free(ch) ;
        }
        ch = pos ;
      }
      pfi->fnums[i - 1] = j ;
    }
    if (ch) {
      free(ch) ;
    }
    pfi->fnumc = 0 ;
  } /* if templating in use and not XDF */  else if (pfi->tmplat) {
    strcpy(pfi->name, template) ;
  }
  if (copy_io_std(&(pfi->first_sdf_ptr), pfi->sdf_ptr) == Success) {
    return(0);
  } else {
    gaprnt(0, "SDF operational error (copy_io_std failed making current first)\n") ;
    return(1) ;
  }
}

int
compare_units(char *test_unit, char *trunc_unit) {
  utUnit testing_unit, truncated_unit ;
  int dequal(double op1, double op2, double threshold) ;
  int return_value ;
  double slope, intercept ;
    
  return_value = utScan(test_unit, &testing_unit) ;
  if (return_value != 0) /* probably shouldn't bitch about an err, but strange */ {
    return(0) ;
  }
  return_value = utScan(trunc_unit, &truncated_unit) ;
  if (return_value != 0) /* see above comment */ {
    return(0) ;
  }
  return_value = utConvert(&truncated_unit, &testing_unit, &slope, &intercept) ;
  if (return_value != 0) {
    return(0) ;
  }
  if (dequal(slope, 1.0, 0.000001) && dequal(intercept, 0.0, 0.000001)) {
    return(1) ; /* hopefully, this will catch all combos from common_year */
  } else {
    return(0) ;
  }
  /*NOTREACHED*/
}

int
findmatch(char *var_name, char **varnamelist, int namecount, int *inxptr) {
  int inx ;
    
  for (inx = 0 ;  inx < namecount ;  ++inx) {
    if (!strcmp(var_name, varnamelist[inx])) {
      *inxptr = inx ;
      return(1) ;
    }
  }
  *inxptr = -1 ;
  return(0) ;
}


void
doparms4sdf(GASDFPARMS *parms) {

  /* set values in parm struct as appropos for sdfopen (not xdfopen) */

  parms->xsrch = parms->ysrch = parms->zsrch = parms->tsrch = 1 ;
  parms->dvsrch = 1 ;
  parms->isxdf = 0 ;
  parms->xsetup = parms->ysetup = parms->zsetup = parms->tsetup = 1 ;
  parms->needtitle = parms->needundef = 1 ;
  parms->xdimname = parms->ydimname = parms->zdimname = parms->tdimname = (char *) 0 ;
  parms->dvcount = -1 ;
  parms->dvncnames = parms->dvganames = (char **) 0 ;
  parms->dvsetup = (int *) 0 ; 
  parms->hasDDFundef = 0 ;
  return ;
}

int
isdvar(VAR_INFO *var, VAR_INFO *X, VAR_INFO *Y, VAR_INFO *Z, VAR_INFO *T,
       int xdimid, int ydimid, int zdimid, int tdimid) {
  int idim, hasX, hasY, hasT ;

  if ((var->nvardims) < 2) {
    return(0) ;
  }
  hasX = hasY = hasT = 0 ;
  for (idim = 0 ;  idim < var->nvardims ;  ++idim) {
    if (var->vardimid[idim] == xdimid) {
      hasX = 1 ;
    }
    if (var->vardimid[idim] == ydimid) {
      hasY = 1 ;
    }
    if (tdimid > -1) {
      if (var->vardimid[idim] == tdimid) {
	hasT = 1 ;
      }
    }
  }
  if ((X && (var == X)) || (Y && (var == Y)) || (Z && (var == Z)) ||
      (T && (var == T)) ) {
    return(0) ;
  }
  return(hasX || hasY) ;
}

int
sdfdeflev(struct gafile *pfi, VAR_INFO *coord, int GrADSdimnum, int revflag) {
  float *tempfarry, *tempfarry2 ;
  int indx ;
  int convtype(void *srcptr, nc_type srctype, void *desptr, nc_type destype,
	       int srcindex, int desindex) ;
    
#ifdef TESTING2
  fprintf(stderr, "sdfdeflev(%s, %s, %d, %d);\n", pfi->name, coord->varnam,
	  GrADSdimnum, revflag);
#endif
  /* the following adapted from deflev routine */
  tempfarry2 =
    (float *) malloc((pfi->dnum[GrADSdimnum] + 5) * sizeof(float)) ;
  if (!tempfarry2) {
    gaprnt(0, "Failure setting up coordinate levels in SDF file.\n") ;
    return(1) ;
  }
  tempfarry2[0] = pfi->dnum[GrADSdimnum] ;
  for (indx = 1 ;  indx <= (pfi->dnum[GrADSdimnum]) ;  ++indx) {
    if (!revflag) {
      if (!convtype(coord->data, coord->vartype, tempfarry2, NC_FLOAT,
		    indx - 1, indx)) {
	gaprnt(0, "SDF:  Error interpreting coordinate value.\n") ;
	return(1) ;
      }
    } else {
      if (!convtype(coord->data, coord->vartype, tempfarry2, NC_FLOAT,
		    pfi->dnum[GrADSdimnum] - indx, indx)) {
	gaprnt(0, "SDF:  Error interpreting coordinate value.\n") ;
	return(1) ;
      }
    }
  }
  tempfarry2[(pfi->dnum[GrADSdimnum]) + 1] = -999.9 ;
  pfi->abvals[GrADSdimnum] = tempfarry2 ;
  pfi->grvals[GrADSdimnum] = tempfarry2 ;
  pfi->ab2gr[GrADSdimnum] = lev2gr ;
  pfi->gr2ab[GrADSdimnum] = gr2lev ;
  pfi->linear[GrADSdimnum] = 0 ;
  /* end of stuff adapted from deflev routine */
  return(0) ;
}


int
findX(IO_STD *sdf_ptr, VAR_INFO **Xcoordptr) {
  /* check for coordinate variable whose units are degrees_east, degree_east */
  /* degrees_E, or degree_E */
  struct attrib_list *units_vattr ;
  struct attrib_list *find_att(struct attrib_list *first_attr, char *attname) ;
  VAR_INFO *lclvar ;
  int iscoordvar, i ;
  char *ch ;

  *Xcoordptr = NULL ;    
  for (lclvar = sdf_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
    iscoordvar = 0 ;
    if (lclvar->nvardims == 1) {
      for (i = 0 ;  i < sdf_ptr->ndims ;  ++i) {
	if (lclvar->vardimid[0] == sdf_ptr->dimids[i]) {
	  if (!strcmp(sdf_ptr->dimnam[i], lclvar->varnam)) {
	    iscoordvar = 1 ;
	  }
	}
      } /* end for */
    }
    if (iscoordvar) /* it's a coordinate variable */ {
      if (!(units_vattr = find_att(lclvar->first_vattr, "units"))) {
	/* return(0) ; */  continue ;
      }
      ch = (char *) malloc(units_vattr->len + 1) ;
      strncpy(ch, (char *) units_vattr->data, units_vattr->len) ;
      ch[units_vattr->len] = '\0' ;
      /* Use strncmp to make up for ncgen's annoying lack of NULL terminators */
      if (strncmp(ch, "degrees_east", 12)) {
	if (strncmp(ch, "degree_east", 11)) {
	  if (strncmp(ch, "degrees_E", 9)) {
	    if (strncmp(ch, "degree_E", 8)) {
	      if (ch) {
		free(ch) ;
	      }
	      continue ;
	    }
	  }
	}
      }
      if (ch) {
	free(ch) ;
      }
      *Xcoordptr = lclvar ;
      return(1) ;  /* got a match on one of them */
    }
  } /* end for each variable */
  return(0) ;
}

int
findY(IO_STD *sdf_ptr, VAR_INFO **Ycoordptr) {
  /* check for coordinate variable whose units are degrees_north, degree_north */
  /* degrees_N, or degree_N */
  struct attrib_list *units_vattr ;
  struct attrib_list *find_att(struct attrib_list *first_attr, char *attname) ;
  VAR_INFO *lclvar ;
  int iscoordvar, i ;
  char *ch ;

  *Ycoordptr = NULL ;
  for (lclvar = sdf_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
    iscoordvar = 0 ;
    if (lclvar->nvardims == 1) {
      for (i = 0 ;  i < sdf_ptr->ndims ;  ++i) {
	if (lclvar->vardimid[0] == sdf_ptr->dimids[i]) {
	  if (!strcmp(sdf_ptr->dimnam[i], lclvar->varnam)) {
	    iscoordvar = 1 ;
	  }
	}
      } /* end for */
    }
    if (iscoordvar) /* it's a coordinate variable */ {
      if (!(units_vattr = find_att(lclvar->first_vattr, "units"))) {
	continue ;  /* try next variable */
      }
      ch = (char *) malloc(units_vattr->len + 1) ;
      strncpy(ch, (char *) units_vattr->data, units_vattr->len) ;
      ch[units_vattr->len] = '\0' ;
      /* Use strncmp to make up for ncgen's annoying lack of NULL terminators */
      if (strncmp(ch, "degrees_north", 13)) {
	if (strncmp(ch, "degree_north", 12)) {
	  if (strncmp(ch, "degrees_N", 9)) {
	    if (strncmp(ch, "degree_N", 8)) {
	      if (ch) {
		free(ch) ;
	      }
	      continue ;
	    }
	  }
	}
      }
      if (ch) {
	free(ch) ;
      }
      *Ycoordptr = lclvar ;
      return(1) ;  /* got a match on one of them */
    }
  } /* end for each variable */
  return(0) ;
}

int
findZ(IO_STD *sdf_ptr, VAR_INFO **Zcoordptr, int *ispressptr) {
  /* check for coordinate variable whose units are that of pressure, */
  /* or another unit approved by COARDS conventions */
  /* initially, the pressure units are "millibars" or "pascals" (caseless) */
  /* should probably allow for prefixes through udunits package */
  /* Will allow exact match on "mb" as a kludge for misbegotten NMC data */
  struct attrib_list *units_vattr, *positive_vattr ;
  struct attrib_list *find_att(struct attrib_list *first_attr, char *attname) ;
  VAR_INFO *lclvar ;
  int iscoordvar, i ;
  char *ch, *lwrunits ;
  struct utUnit feet, thisguy, pascals, kelvins ;
  double slope, intcept ;

  *Zcoordptr = NULL ;
  if (utScan("feet", &feet) != 0) /* bloody hell... */ {
    gaprnt(0, "The udunits library doesn't know feet; giving up...\n") ;
    return(9999) ;
  }
  if (utScan("pascals", &pascals) != 0) /* bloody hell... */ {
    gaprnt(0, "The udunits library doesn't know pascals; giving up...\n") ;
    return(9999) ;
  }
  if (utScan("kelvins", &kelvins) != 0) /* bloody hell... */ {
    gaprnt(0, "The udunits library doesn't know kelvins; giving up...\n") ;
    return(9999) ;
  }
  for (lclvar = sdf_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
    iscoordvar = 0 ;
    if (lclvar->nvardims == 1) {
      for (i = 0 ;  i < sdf_ptr->ndims ;  ++i) {
	if (lclvar->vardimid[0] == sdf_ptr->dimids[i]) {
	  if (!strcmp(sdf_ptr->dimnam[i], lclvar->varnam)) {
	    iscoordvar = 1 ;
	  }
	}
      } /* end for */
    }
    if (iscoordvar) /* it's a coordinate variable */ {
      if (!(units_vattr = find_att(lclvar->first_vattr, "units"))) {
	continue ;
      }
      ch = (char *) units_vattr->data ;
      lwrunits = (char *) malloc(units_vattr->len + 1) ;
      strncpy(lwrunits, ch, units_vattr->len) ;
      lwrunits[units_vattr->len] = '\0' ;
      lowcas(lwrunits) ;
      if (!strcmp(lwrunits, "mb")) {
	*Zcoordptr = lclvar ;
	*ispressptr = 1 ;
	if (lwrunits) {
	  free(lwrunits) ;
	}
	return(1) ;
      }
      /* depth, isothermic, sigma_level, & hybrid_sigma_pressure are the only others */
      if ((!strcmp(lwrunits, "sigma_level")) || (!strcmp(lwrunits, "degreesk")) ||
	  (!strcmp(lwrunits, "degrees_k")) || (!strcmp(lwrunits, "level")) || 
	  (!strcmp(lwrunits, "layer")) || (!strcmp(lwrunits, "layers"))) {
	*Zcoordptr = lclvar ;
	*ispressptr = 0 ;
	if (lwrunits) {
	  free(lwrunits) ;
	}
	return(1) ;
      }
      if (!strcmp(lwrunits, "hybrid_sigma_pressure")) { /* CSM - NCAR */
	*Zcoordptr = lclvar ;
	*ispressptr = 1 ;
	if (lwrunits) {
	  free(lwrunits) ;
	}
	return(1) ;
      }
      /* if we can convert the units to feet, then it could be depth */
      if (utScan(ch, &thisguy) == 0) {
	if (utConvert(&thisguy, &feet, &slope, &intcept) == 0) {
	  *Zcoordptr = lclvar ;
	  *ispressptr = 0 ;
	  if (lwrunits) {
	    free(lwrunits) ;
	  }
	  return(1) ;
	}
	/* if we can convert the units to pascals, then it could be pressure */
	if (utConvert(&thisguy, &pascals, &slope, &intcept) == 0) {
	  *Zcoordptr = lclvar ;
	  *ispressptr = 1 ;
	  if (lwrunits) {
	    free(lwrunits) ;
	  }
	  return(1) ;
	}
	/* if we can convert the units to kelvins, then it could be isothermic */
	if (utConvert(&thisguy, &kelvins, &slope, &intcept) == 0) {
	  *Zcoordptr = lclvar ;
	  if (lwrunits) {
	    free(lwrunits) ;
	  }
	  *ispressptr = 0 ;
	  return(1) ;
	}
      } /* if utScan-able */
      if (lwrunits) {
	free(lwrunits) ;
      }
    } /* if a coord. var. */
  } /* for each variable in SDF */
  return(0) ;
}

int
findT(IO_STD *sdf_ptr, VAR_INFO **Tcoordptr) {
  /* find a coordinate variable whose units mark it as one sort of time or
     another. */
  struct attrib_list *units_vattr ;
  struct attrib_list *find_att(struct attrib_list *first_attr, char *attname) ;
  VAR_INFO *lclvar ;
  int iscoordvar, i ;
  char *ch ;
  utUnit timeunit ;

  *Tcoordptr = NULL ;
  for (lclvar = sdf_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
    iscoordvar = 0 ;
    if (lclvar->nvardims == 1) {
      for (i = 0 ;  i < sdf_ptr->ndims ;  ++i) {
	if (lclvar->vardimid[0] == sdf_ptr->dimids[i]) {
	  if (!strcmp(sdf_ptr->dimnam[i], lclvar->varnam)) {
	    iscoordvar = 1 ;
	  }
	}
      } /* end for */
    }
    if (!iscoordvar) continue ;
    units_vattr = find_att(lclvar->first_vattr, "units") ;
    if (!units_vattr) continue ;
    ch = (char *) malloc(units_vattr->len + 1) ;
    strncpy(ch, (char *) units_vattr->data, units_vattr->len) ;
    ch[units_vattr->len] = '\0' ;
    if (!strcasecmp(ch, "yyyymmddhhmmss")) /* old-style CDC */ {
      if (ch) {
	free(ch) ;
      }
      *Tcoordptr = lclvar ;
      return(1) ;
    }
    if (!strcasecmp(ch, "yymmddhh")) /* "DAO format" */ {
      if (ch) {
	free(ch) ;
      }
      *Tcoordptr = lclvar ;
      return(1) ;
    }
    if (utScan(ch, &timeunit)) {
      if (ch) {
	free(ch) ;
      }
      continue ;
    }
    if (ch) {
      free(ch) ;
    }
    if (utIsTime(&timeunit)) /* will now supply default unit */ {
      *Tcoordptr = lclvar ;
      return(1) ;
    }
  } /* foreach var. */
  return(0) ;
}

/* Open a data set by reading the self-describing file for that
   data set, and create a gafile structure.  Chain the gafile
   structure on to the list anchored in the gastat.                   */

int
gasdfopen (char *args, struct gacmn *pcm) {
  struct gafile *pfi, *pfio;
  int size, rc, ntsteps, ichpos, idummy ,i, len;
  char pathname[4096], *optargs, template[4096], *cntsteps, *fnpart, *aux , *ch;
  GASDFPARMS parms ;
  int init_io_std(IO_STD **ptr) ;
  int gadsdf(char *name, struct gafile *pfi, char *template, int ntsteps,
	     GASDFPARMS parms) ;
  void doparms4sdf(GASDFPARMS *parms) ;

  doparms4sdf(&parms) ; /* set up for sdfopen calling gadsdf */
  getwrd(pathname, args, 4095) ;
  optargs = nxtwrd(args) ;
  gaprnt (2, "Scanning self-describing file:  ");
  gaprnt (2, pathname);
  gaprnt (2, "\n");
#ifdef TESTING3
  if (optargs && (*optargs != '\0')) {
    gaprnt (2, "Optional args to SDFOPEN command are:  ") ;
    gaprnt (2, optargs) ;
    gaprnt (2, "\n") ;
  }
#endif
  pfi = getpfi();
  if (pfi == NULL) {
    gaprnt (0,"Memory Allocation Error:  Prior to SDF File Open\n");
    return (1);
  }
  pfi->is_a_SDF = 1 ;
  pfi->ncflg = 3;       /* set a flag for detecting sdf files that is not #ifdef'd */
  if (!init_io_std(&(pfi->sdf_ptr))) {
    gaprnt(0, "Memory Allocation Error:  On SDF File Open\n") ;
    return(1) ;
  }
  pfi->tmplat = 0 ; /* assume no templating, unless get two more good args */
  if (!optargs || (*optargs == '\0')) {
    template[0] = '\0' ;
    ntsteps = -999 ;
  } else {
    /* get the template string */
    ch = optargs;
    len = 0;
    while (*(ch+len)!=' ' && *(ch+len)!='\n' && *(ch+len)!='\t') len++;
    for (i=0; i<len; i++) *(template+i) = *(ch+i);
    *(template+len) = '\0';
    /* get the number of time steps  */
    if ( (ch=nxtwrd(ch))==NULL ) {
      template[0] = '\0' ;
      ntsteps = -999 ;
      gaprnt(1,"Warning: Missing ntsteps arg to SDFOPEN command, ignoring templating info.\n");
    } else {
      if (!intprs(ch, &ntsteps) || ntsteps < 1) {
	template[0] = '\0' ;
	ntsteps = -999 ;
	gaprnt(1,"Warning: Bad ntsteps arg to SDFOPEN command, ignoring templating info.\n") ;
      }
      else {
	/* everything parsed ok, set templating flag */
	pfi->tmplat = 1;
      }
    }
#ifdef TESTING3    
    sprintf(pout,"  template=%s\n  ntsteps=%d\n", template,ntsteps);
    gaprnt(2,pout);
#endif
  } /* if no optargs */

  rc = gadsdf(pathname, pfi, template, ntsteps, parms);
#ifdef TESTING
  fprintf(stderr, "Return code from gadsdf=%d.\n", rc) ;
  fprintf(stderr, "Calling xdumpfile after gadsdf.\n") ;
  xdumpfile(pfi) ;
  if (pfi->pvar1) {
    fprintf(stderr, "Calling xdumpvar on first var after gadsdf.\n") ;
    xdumpvar(pfi->pvar1) ;
  }
#endif
  if (rc) {
    frepfi (pfi, 0) ;
    return (rc) ;
  }
  if (pcm->pfi1==NULL) {
    pcm->pfi1 = pfi;
  } else {
    pfio = pcm->pfi1;
    while (pfio->pforw!=NULL) pfio = pfio->pforw;
    pfio->pforw = pfi;
  }
  pfi->pforw = NULL;
  pcm->fnum++;

  if (pcm->fnum==1) {pcm->pfid = pcm->pfi1; pcm->dfnum = 1;}
  sprintf (pout,"SDF file %s is open as file %i\n",pfi->name,pcm->fnum);
  gaprnt (2,pout);

  /* If first file open, set up some default dimension
     ranges for the user */

  if (pcm->fnum==1) {
    if (pfi->type==2 || pfi->wrap) gacmd ("set lon 0 360",pcm,0);
    else {
      sprintf (pout,"set x 1 %i",pfi->dnum[0]);
      gacmd (pout,pcm,0);
    }
    if (pfi->type==2) {
      gacmd ("set lat -90 90",pcm,0);
      gacmd ("set lev 500",pcm,0);
    } else {
      sprintf (pout,"set y 1 %i",pfi->dnum[1]);
      gacmd (pout,pcm,0);
      gacmd ("set z 1",pcm,0);
    }
    gacmd ("set t 1",pcm,0);
  }

  if (pfi->ppflag) {
    sprintf (pout,"Notice: Implied interpolation for SDF file %s\n",pathname);
    gaprnt (1,pout);
    gaprnt (1," Interpolation will be performed on any data ");
    gaprnt (1,"displayed from this file\n");
  }

  return (0);
}

/* Routine to open appropriate file when using file templates */
/* Warning -- changes time value to time with respect to this file */

int gaopsdf(int t, struct gagrid *gridptr, VAR_INFO **data_var_ptr) {
  int i, abbrvlen, neednewfile, abbrlen, idim ;
  struct dt dtim, dtimi ;
  struct gafile *pfi ;
  struct attrib_list *missval_attr ;
  struct attrib_list *find_att(struct attrib_list *first_att, char *attname) ;
  char *fn ;
  IO_STD *oldsdf_ptr ;
  VAR_INFO *oldlclvar, *newlclvar ;
  void free_io_std(IO_STD **sdf_ptr) ;
  int close_netcdf(int ncid) ;
  int init_io_std(IO_STD **sdf_ptr) ;
  int read_io_std(char *path, IO_STD *sdf_ptr) ;
  int copy_io_std(IO_STD **sdf_ptr2, IO_STD *std_ptr1) ;

  neednewfile = 0 ;
  pfi = gridptr->pfile ;
  if ((t < 1) || (t > gridptr->pfile->dnum[TINDEX]) ) return(-99999) ;
  i = *(gridptr->pfile->fnums + t - 1) ;
  if (i != gridptr->pfile->fnumc) /* different file needed */ {
#ifdef TESTING3
    fprintf(stderr, "Going to new SDF file for index %d.\n", i) ;
#endif
    neednewfile = 1 ;
    if ((gridptr->pfile->tempname) && (gridptr->pfile->tempname != NULL)) {
      if (gridptr->pfile->tempname) {
	free(gridptr->pfile->tempname) ;
      }
    }
    oldsdf_ptr = (IO_STD *) NULL ;
    if (copy_io_std(&oldsdf_ptr, gridptr->pfile->sdf_ptr) == Failure) {
      gaprnt(1, "SDF templating:  Error copying SDF info from default.\n") ;
      return(-88888) ;
    }
    if (oldsdf_ptr == (IO_STD *) 0) {
      if (copy_io_std(&oldsdf_ptr, gridptr->pfile->first_sdf_ptr) == Failure) {
	gaprnt(1, "SDF templating:  Error copying SDF info from first.\n") ;
	return(-88888) ;
      }
    }
    gridptr->pfile->sdf_ptr = (IO_STD *) 0 ;
    gr2t(gridptr->pfile->grvals[TINDEX], (float) t, &dtim) ;
    gr2t(gridptr->pfile->grvals[TINDEX], 1.0, &dtimi) ;
    fn = gafndt(gridptr->pfile->name, &dtim, &dtimi, gridptr->pfile->abvals[TINDEX], NULL, 1) ;
#ifdef TESTING3
    fprintf(stderr, "dtimi=(%d, %d, %d, %d, %d), dtim=(%d, %d, %d, %d, %d)\n",
	    dtimi.yr, dtimi.mo, dtimi.dy, dtimi.hr, dtimi.mn, dtim.yr, dtim.mo, dtim.dy,
	    dtim.hr, dtim.mn) ;
    fprintf(stderr, "New SDF filename=%s.\n", fn) ;
#endif
    if (fn == NULL) {
      /* what could I do if close_netcdf did bomb? */
      (void) close_netcdf(oldsdf_ptr->cdfid) ;
      if (oldsdf_ptr != gridptr->pfile->first_sdf_ptr) {
	free_io_std(&(oldsdf_ptr)) ;
      } /* gotta keep that first one for the varlookups later */
      /* restore on failure */
      if (copy_io_std(&(gridptr->pfile->sdf_ptr),
		      gridptr->pfile->first_sdf_ptr) == Failure) {
	/* SIGH.  Two screwups at once! */
	gaprnt(1, "SDF templating:  Error copying SDF info from first to current.\n") ;
	return(-99999) ;  /* should be -88888, but... */
      }
      gaprnt(1, "SDF templating:  Error getting new filename.\n") ;
      return(-99999) ;
    }
    if (!init_io_std(&(gridptr->pfile->sdf_ptr))) {
      gaprnt(0, "SDF templating:  Allocation error opening new SDF file.\n") ;
      gridptr->pfile->fnumc = 0 ;
      /* what could I do if close_netcdf did bomb? */
      (void) close_netcdf(oldsdf_ptr->cdfid) ;
      if (oldsdf_ptr != gridptr->pfile->first_sdf_ptr) {
	free_io_std(&(oldsdf_ptr)) ;
      } /* gotta keep that first one for the varlookups later */
      /* restore on failure */
      gridptr->pfile->sdf_ptr = (IO_STD *) NULL ;
      if (copy_io_std(&(gridptr->pfile->sdf_ptr),
		      gridptr->pfile->first_sdf_ptr) == Failure) {
	gaprnt(1, "SDF templating:  Error copying first to current in switch.\n") ;
	return(-88888) ;
      }
      gaprnt(1, "SDF templating:  Error moving to new file.\n") ;
      return(-88888) ;
    }
    if (!read_io_std(fn, gridptr->pfile->sdf_ptr)) {
      gaprnt(0, "SDF templating:  Open of new SDF file failed.\n  Filename is ") ;
      gaprnt(0, fn) ;
      gaprnt(0, ".\n") ;
#if USEHDF == 0
      gaprnt(0, "If this was an HDF-SDS file, try gradshdf.\n") ;
#endif
      gridptr->pfile->fnumc = 0 ;
      /* what could I do if close_netcdf did bomb? */
      (void) close_netcdf(oldsdf_ptr->cdfid) ;
      /* restore on failure */
      gridptr->pfile->sdf_ptr = oldsdf_ptr ;
      gaprnt(1, "SDF templating:  New open failed.\n") ;
      return(-88888) ;
    }
    /* copy over the gradsabbr values into new file's structs */
    for (oldlclvar = oldsdf_ptr->var ;  oldlclvar ;
	 oldlclvar = oldlclvar->next) {
      /* find same netCDF var in new file */
      for (newlclvar = gridptr->pfile->sdf_ptr->var ;  newlclvar ;
	   newlclvar = newlclvar->next) {
	if (!strcmp(oldlclvar->varnam, newlclvar->varnam)) {
	  /* match */
	  if (oldlclvar->gradsabbr) {
	    strcpy(newlclvar->gradsabbr, oldlclvar->gradsabbr) ;
	  }
	  for (idim = 0 ;  idim < 4 ;  ++idim) /* copy dim. maps */ {
	    newlclvar->dimmap[idim] = oldlclvar->dimmap[idim] ;
	    newlclvar->dimidmap[idim] = oldlclvar->dimidmap[idim] ;
	  }
	  /* Here's the rub:  if this is an XDFopen-ed file, and that DDF had an UNDEF */
	  /* statement, we don't want to look for it in an attribute value.  However, */
	  /* I don't know how to tell this origin info at this point; it was in the */
	  /* parms structure during data discovery phase, (isxdf and needundef */
	  /* components), but I don't see any way to access that here.  Hoop, 2002/03/13  */
	  /* Figured out a way to communicate it from DDF parsing code, first via parms */
	  /* struct to data discovery fcn (first in this file), then via IO_STD struct to */
	  /* here.  hasDDFundef is new structure element in both cases. -Hoop, 2002/03/28 */
	  /* */
	  /* get missing_value attribute value, & stuff it into newlclvar->missing_value */
	  /* Added here from the data_var discovery code in gadsdf(), 2001/04/15 -Hoop */
	  if (gridptr->pfile->sdf_ptr->hasDDFundef) /* always float */ {
	    newlclvar->missing_value.fval = gridptr->pfile->undef ;
	  } else {
	    missval_attr = find_att(newlclvar->first_vattr, "missing_value") ;
	    if (!missval_attr) {
	      missval_attr = find_att(newlclvar->first_vattr, "_FillValue") ;
	    }
	    /* if the type of the data variable and that of the missing_value attribute */
	    /* don't match, use the default, as we do if we have no attribute */
	    if ((!missval_attr) ||
		(missval_attr->type != newlclvar->vartype)) {
	      switch (newlclvar->vartype) {
	      case NC_BYTE:
		newlclvar->missing_value.bval = FILL_BYTE ;
		break ;
	      case NC_SHORT:
		newlclvar->missing_value.sval = FILL_SHORT ;
		break ;
	      case NC_LONG:
		newlclvar->missing_value.lval = FILL_LONG ;
		break ;
	      case NC_FLOAT:
		newlclvar->missing_value.fval = FILL_FLOAT ;
		break ;
	      case NC_DOUBLE:
		newlclvar->missing_value.dval = FILL_DOUBLE ;
		break ;
	      } /* end switch */
	    } else /* have an attribute value and types match */ {
	      switch (newlclvar->vartype) {
	      case NC_BYTE:
		newlclvar->missing_value.bval =
		  *((signed char *)missval_attr->data) ;
		break ;
	      case NC_SHORT:
		newlclvar->missing_value.sval =
		  *((short *)missval_attr->data) ;
		break ;
	      case NC_LONG:
		newlclvar->missing_value.lval =
		  *((long *)missval_attr->data) ;
		break ;
	      case NC_FLOAT:
		newlclvar->missing_value.fval =
		  *((float *)missval_attr->data) ;
		break ;
	      case NC_DOUBLE:
		newlclvar->missing_value.dval =
		  *((double *)missval_attr->data) ;
		break ;
	      } /* end switch */
	    } /* else is have attribute and types match */
	  }
	  break ; /* found this oldlclvar amid new ones, go for next */
	} /* end if match found */
      } /* end for each new var */
    } /* end for each old var */
    /* what could I do if close_netcdf did bomb? */
    (void) close_netcdf(oldsdf_ptr->cdfid) ;
    /* must redetermine data_var */
    abbrvlen = (int) strlen(gridptr->pvar->abbrv) ;
    for ((*data_var_ptr) = gridptr->pfile->sdf_ptr->var ;  (*data_var_ptr) ;
         (*data_var_ptr) = (*data_var_ptr)->next) {
      if ((*data_var_ptr)->gradsabbr[0] != '\0') {
	if (!strcasecmp(gridptr->pvar->abbrv, (*data_var_ptr)->gradsabbr)) {
	  break ;
	}
      }
    }
    if (!(*data_var_ptr)) {
      sprintf(pout, "SDF templating:  Couldn't find variable %s in SDF file.\n", gridptr->pvar->abbrv) ;
      gaprnt(0, pout) ;
      (void) close_netcdf(oldsdf_ptr->cdfid) ;
      gridptr->pfile->fnumc = 0 ;
      /* restore on failure */
      if (copy_io_std(&(gridptr->pfile->sdf_ptr),
		      gridptr->pfile->first_sdf_ptr) == Failure) {
	gaprnt(1, "SDF templating:  Error copying current to first after failure finding variable.\n") ;
	return(-88888) ;
      }
      return(-88888) ;
    }
    gridptr->pfile->fnumc = i ;
    gridptr->pfile->tempname = fn ;
  } /* if i != gridptr->pfile->fnumc */
  t = 1 + t - gridptr->pfile->fnumc ;
  return(t) ;
}

#endif
int
gadxdf(char *name, struct gafile *pfi, char **template, int *ntsteps,
       char **sdfname, GASDFPARMS *parms) {
  struct gavar *pvar;
  struct dt tdef,tdefi,dt1,dt2;
  struct gaindx *pindx;
  float *vals;
  int size,rc,len,swpflg,cnt, idum, diag=0, ichar;
  char rec[512], mrec[512], *ch, *dn, *pos, *sname, *misc ; /*mf mf*/
  int flgs[1],cflg,i,j,err,hdrb,trlb,mflflg,crayflg=0;
  int mcnt,maxlv,maxct, mflag = 0 ;
  int levs,acum,acumvz,fpos,recacm;
  float temp,v1,v2, fdum;
  FILE *mfile = (FILE *) 0 ;
  static char *errs[1] = {"DSET"} ;
  int nzstride=0,first=1; 
  int levsua=0,acumstride=0;

#if GRADS_CDUNIF == 1
  mfcmn.fullyear=1;  /*mf --- define here vice grads.c for cdunif.c mf*/
#endif

  char *putncdnm(char *ch, char **dimname) ;
  void dupstrval(char *src, char **dest) ;

  hdrb = 0;
  trlb = 0;
  mflflg = 0;			/* map file not open */
  pfi->mfile = NULL;
  mcnt = -1;

  /* Initialize variables */
  parms->xsrch = parms->ysrch = parms->zsrch = parms->tsrch = 1 ;
  parms->dvsrch = 1 ;  parms->isxdf = 1 ;
  parms->xsetup = parms->ysetup = parms->zsetup = parms->tsetup = 1 ;
  parms->needtitle = parms->needundef = 1 ;
  parms->dvcount = -1 ;
  parms->xdimname = parms->ydimname = parms->zdimname = parms->tdimname = (char *) 0 ;
  parms->dvncnames = parms->dvganames = (char **) 0 ;
  parms->dvsetup = (int *) 0 ;
  parms->hasDDFundef = 0 ;
  sname=NULL;

  /* Open descriptor file */
  descr = fopen (name, "r");  
  if (descr == NULL) {
    /* Add default suffix of .ctl */
    sname = (char *)malloc(strlen(name)+5);
    if(sname == NULL) {
      gaprnt(0,"XDFopen:  malloc error in creating data descriptor file name\n");
      return(1);
    }
    for(i=0;i<=strlen(name);i++) *(sname+i)=*(name+i);
    strcat(sname,".ctl");
    descr = fopen (sname, "r");
  }

  if (descr == NULL) {
    gaprnt (0,"XDFOpen Error:  Can't open description file\n");
    if (sname) {
      free(sname);
    }
    return(1);
  }

  /* Copy descriptor file name into gafile structure */
  if(sname != NULL) {
    getwrd (pfi->dnam,sname,255);
    if (sname) {
      free(sname);
    }
  } else {
    getwrd (pfi->dnam,name,255);
  }

  /* initialize error flags */
  for (i=0;i<1;i++) flgs[i] = 1;

  /*mf initialize the calendar to standard and cray_ieee to 0 mf*/
  /*  pfi->calendar=0; */ /* Mike stopped doing it here in gaddes.c, so me too */
  pfi->cray_ieee=0;

  /* Parse the descriptor file */
  pfi->vnum = 0 ;
  while (fgets(rec,512,descr)!=NULL) {
    for (ichar = 0 ;  ichar < strlen(rec) ;  ++ichar) {
      if (rec[ichar] == '\n') {
	rec[ichar] = '\0' ;
      }
    }
    strcpy (mrec,rec);
    lowcas(rec);

    pfi->fhdr = 0;
    pfi->xyhdr = 0;
    pfi->thdr = 0;

    if ( (cmpwrd("*", rec) || cmpwrd("#", rec)) || !isalnum(rec[0]) ) {
      cflg = 1;
      /* Parse comment if it contains attribute metadata */
      if (strncmp("*:attr",mrec,6)==0) {
	if ((ddfattr(mrec,pfi)) == -1) goto retrn;
      }

    } else if (cmpwrd("options",rec)) {
      if ( (ch=nxtwrd(rec))==NULL ) {
        gaprnt (1,"XDFopen:  Description file warning: Missing options keyword\n");
      } else {
        while (ch != NULL) {
          if (cmpwrd("yrev",ch)) pfi->yrflg = 1;
          else if (cmpwrd("zrev",ch)) pfi->zrflg = 1;
          else if (cmpwrd("template",ch)) pfi->tmplat = 1;
	  else if (cmpwrd("365_day_calendar",ch)) {
	    pfi->calendar = 1 ;
	    mfcmn.cal365 = pfi->calendar ;
	  } else {
	    gaprnt (0,"XDFopen Error:  Data file option invalid\n");
	    goto err9;
          }
          ch = nxtwrd(ch);
        }
      }
    
    } else if (cmpwrd("title",rec)) {
      parms->needtitle = 0 ;
      if ( (ch=nxtwrd(mrec))==NULL ) {
        gaprnt (1,"XDFopen:  Description file warning: Missing title string\n");
	pfi->title[0] = '\0' ;
      } else {
        getstr (pfi->title,ch,511);
      }

    } else if (cmpwrd("dset",rec)) {
      ch = nxtwrd(mrec);
      if (ch==NULL) {
        gaprnt (0,"XDFOpen Error:  Data file name is missing\n");
        goto err9;
      }
      if (*ch=='^' || *ch=='$') {
        fnmexp (pfi->name,ch,name);
      } else {
        getwrd (pfi->name,ch,511);
      }
      flgs[0] = 0;

    }  else if (cmpwrd("undef",rec)) {
      ch = nxtwrd(rec);
      if (ch==NULL) {
        gaprnt (0,"XDFOpen Error:  Missing undef value\n");
        goto err9;
      }
      pos = valprs(ch,&(pfi->undef));
      if (pos==NULL) {
        gaprnt (0,"XDFOpen Error:  Invalid undef value\n");
        goto err9;
      }
      if (SETMISS) {
        pfi->ulow = fabs(pfi->undef/EPSILON);
        pfi->uhi = pfi->undef + pfi->ulow;
        pfi->ulow = pfi->undef - pfi->ulow;
      }
      parms->needundef = 0 ;
      parms->hasDDFundef = 1 ;

    }  else if (cmpwrd("xdef",rec)) {
      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(mrec)) == NULL) goto err0;   /* xdimname must be mixed case version*/
      parms->xsrch = 0 ;                    
      ch = putncdnm(ch, &(parms->xdimname)) ;        /* mallocs and strcpys */
      ch = nxtwrd(rec) ;                             /* skip over xdef in lowcase version */
      if ((ch = nxtwrd(ch)) == NULL) {
        parms->xsetup = 1 ;                    
      } else {
        if ( (pos = intprs(ch,&(pfi->dnum[0])))==NULL) {
	  goto err1 ;
        }
        if (*pos != ' ') goto err1;
        if ( (ch = nxtwrd(ch))==NULL) goto err2;
        if (cmpwrd("linear",ch)) {
	  rc = deflin(ch, pfi, 0, 0);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
	  v2 = *(pfi->grvals[0]);
	  v1 = *(pfi->grvals[0]+1) + v2;
	  temp = v1+((float)(pfi->dnum[0]))*v2;
	  temp=temp-360.0;
	  if (fabs(temp-v1)<0.01) pfi->wrap = 1;
        } else if (cmpwrd("levels",ch)) {
	  if (pfi->dnum[0]<1) goto err7;
	  rc = deflev (ch, rec, pfi, 0);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
        } else goto err2;
        parms->xsetup = 0 ;
      }

    } else if (cmpwrd("ydef",rec)) {
      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(mrec)) == NULL) goto err0;   /* ydimname must be mixed case version*/
      parms->ysrch = 0 ;
      ch = putncdnm(ch, &(parms->ydimname)) ;        /* mallocs and strcpys */
      ch = nxtwrd(rec) ;                             /* skip over ydef in lowcase version*/
      if ((ch = nxtwrd(ch))  == NULL) { ;
      parms->ysetup = 1 ;
      } else {
        if ( (pos = intprs(ch,&(pfi->dnum[1])))==NULL) {
	  goto err1 ;
        }
        if (*pos!=' ') goto err1;
        if ( (ch = nxtwrd(ch))==NULL) goto err2;
        if (cmpwrd("linear",ch)) {
	  rc = deflin(ch, pfi, 1, 0);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
        } else if (cmpwrd("levels",ch)) {
	  if (pfi->dnum[1]<1) goto err7;
	  rc = deflev (ch, rec, pfi, 1);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
        } else if (cmpwrd("gausr40",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  if ( (pos = intprs(ch,&i))==NULL) goto err3;
	  pfi->grvals[1] = gagaus(i,pfi->dnum[1]);
	  if (pfi->grvals[1]==NULL) goto err9;
	  pfi->abvals[1] = pfi->grvals[1];
	  pfi->ab2gr[1] = lev2gr;
	  pfi->gr2ab[1] = gr2lev;
	  pfi->linear[1] = 0;
        } else if (cmpwrd("mom32",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  if ( (pos = intprs(ch,&i))==NULL) goto err3;
	  pfi->grvals[1] = gamo32(i,pfi->dnum[1]);
	  if (pfi->grvals[1]==NULL) goto err9;
	  pfi->abvals[1] = pfi->grvals[1];
	  pfi->ab2gr[1] = lev2gr;
	  pfi->gr2ab[1] = gr2lev;
	  pfi->linear[1] = 0;
        } else if (cmpwrd("gausr30",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  if ( (pos = intprs(ch,&i))==NULL) goto err3;
	  pfi->grvals[1] = gags30(i,pfi->dnum[1]);
	  if (pfi->grvals[1]==NULL) goto err9;
	  pfi->abvals[1] = pfi->grvals[1];
	  pfi->ab2gr[1] = lev2gr;
	  pfi->gr2ab[1] = gr2lev;
	  pfi->linear[1] = 0;
        } else if (cmpwrd("gausr20",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  if ( (pos = intprs(ch,&i))==NULL) goto err3;
	  pfi->grvals[1] = gags20(i,pfi->dnum[1]);
	  if (pfi->grvals[1]==NULL) goto err9;
	  pfi->abvals[1] = pfi->grvals[1];
	  pfi->ab2gr[1] = lev2gr;
	  pfi->gr2ab[1] = gr2lev;
	  pfi->linear[1] = 0;
        } else if (cmpwrd("gausr15",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  if ( (pos = intprs(ch,&i))==NULL) goto err3;
	  pfi->grvals[1] = gags15(i,pfi->dnum[1]);
	  if (pfi->grvals[1]==NULL) goto err9;
	  pfi->abvals[1] = pfi->grvals[1];
	  pfi->ab2gr[1] = lev2gr;
	  pfi->gr2ab[1] = gr2lev;
	  pfi->linear[1] = 0;
        } else goto err2;
        parms->ysetup = 0 ;
      }

    } else if (cmpwrd("zdef",rec)) {
      if (pfi->type == 2) continue;
      if ( (ch = nxtwrd(mrec)) == NULL) goto err0; /* get mixed case version */
      parms->zsrch = 0 ;
      ch = putncdnm(ch, &(parms->zdimname)) ;
      ch = nxtwrd(rec) ;                           /* point past zdef in lowcased version */
      if ((ch = nxtwrd(ch))  == NULL) {
        parms->zsetup = 1 ;
      } else {
        if ( (pos = intprs(ch,&(pfi->dnum[2])))==NULL) {
	  goto err1 ;
        }
        if (*pos!=' ') goto err1;
        if ( (ch = nxtwrd(ch))==NULL) goto err2;
        if (cmpwrd("linear",ch)) {
	  rc = deflin(ch, pfi, 2, 0);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
        } else if (cmpwrd("levels",ch)) {
	  if (pfi->dnum[2]<1) goto err7;
	  rc = deflev (ch, rec, pfi, 2);
	  if (rc==-1) goto err8;
	  if (rc) goto err9;
        } else goto err2;
        parms->zsetup = 0 ;
      }

    } else if (cmpwrd("tdef",rec)) {
      if ( (ch = nxtwrd(mrec)) == NULL) goto err0; /* get mixed case version */
      parms->tsrch = 0 ;
      if (!strncasecmp(ch, "%nodim%", 7)) {
        parms->tdimname = (char *) 0 ;             /* we won't be using any tdimname */
	pfi->dnum[TINDEX] = 1 ;                    /* 1 time step ; be sure not to map any tdim */
      } else {
        ch = putncdnm(ch, &(parms->tdimname)) ;
      }
      ch = nxtwrd(rec) ;                           /* skip over tdef in lowcased version */
      if ((ch = nxtwrd(ch)) == NULL) {
        if (!(parms->tdimname)) {
	  vals = (float *)malloc(sizeof(float)*8);
	  if (vals==NULL) goto err8;
	  vals[7] = -999.9 ;
	  pfi->grvals[TINDEX] = vals ;
	  pfi->abvals[TINDEX] = vals ;
	  pfi->linear[TINDEX] = 1 ;
	  vals[0] = 1.0 ;
	  vals[1] = 1.0 ;
	  vals[2] = 1.0 ;
	  vals[3] = 0.0 ; /* initial hours */
	  vals[4] = 0.0 ;
	  vals[5] = 0.0 ; /* step in months */
	  vals[6] = 1.0 ; /* step in minutes */
	  parms->tsetup = 0 ;
        } else {
	  parms->tsetup = 1 ;
        }
      } else { 
        if ( (pos = intprs(ch,&(pfi->dnum[3])))==NULL) {
	  goto err1 ;
        }
	if (!(parms->tdimname)) {
	  if ((pfi->tmplat) == 0) {
	    /* non-templating, %nodim% case can only have 1 timestep */
	    if (pfi->dnum[3] != 1) {
	      gaprnt(0, "TDEF with %nodim% has timestep count != 1; resetting to 1.\n") ;
	      pfi->dnum[3] = 1 ;
	    }
	  }
	}
        if (*pos!=' ') goto err1;
        if ( (ch = nxtwrd(ch))==NULL) goto err2;
        if (cmpwrd("linear",ch)) {
	  if ( (ch = nxtwrd(ch))==NULL) goto err3;
	  tdef.yr = -1000;
	  tdef.mo = -1000;
	  tdef.dy = -1000;
	  if ( (pos = adtprs(ch,&tdef,&dt1))==NULL) goto err3;
	  if (*pos!=' ' || dt1.yr == -1000 || dt1.mo == -1000.0 ||
	      dt1.dy == -1000) goto err3;
	  if ( (ch = nxtwrd(ch))==NULL) goto err4;
	  if ( (pos = rdtprs(ch,&dt2))==NULL) goto err4;
	  v1 = (dt2.yr * 12) + dt2.mo;
	  v2 = (dt2.dy * 1440) + (dt2.hr * 60) + dt2.mn;
	  /*mf --- check if 0 dt ---mf*/
	  if ((v1 == 0) && (v2 == 0)) goto err4a ;
	  vals = (float *)malloc(sizeof(float)*8);
	  if (vals==NULL) goto err8;
	  *(vals) = dt1.yr;
	  *(vals+1) = dt1.mo;
	  *(vals+2) = dt1.dy;
	  *(vals+3) = dt1.hr;
	  *(vals+4) = dt1.mn;
	  *(vals+5) = v1;
	  *(vals+6) = v2;
	  *(vals+7) = -999.9;
	  pfi->grvals[3] = vals;
	  pfi->abvals[3] = vals;
	  pfi->linear[3] = 1;
        } else goto err2;
        parms->tsetup = 0 ;
      }

    } else if (cmpwrd("vars",rec)) {
      if ( (ch = nxtwrd(rec)) == NULL) goto err5;
      if ( (pos = intprs(ch,&(pfi->vnum)))==NULL) goto err5;
      parms->dvsrch = 0 ;
      parms->dvcount = pfi->vnum ;
      size = pfi->vnum * sizeof(struct gavar) ;
      pvar = (struct gavar *)malloc(size);
      pfi->pvar1 = pvar;
      parms->dvncnames = (char **) malloc(pfi->vnum * sizeof(char *)) ;
      parms->dvganames = (char **) malloc(pfi->vnum * sizeof(char *)) ;
      parms->dvsetup = (int *) malloc(pfi->vnum * sizeof(int)) ;
      i = 0;
      while (i<pfi->vnum) {
        if (fgets(rec,512,descr)==NULL) {
          gaprnt (0,"XDFOpen Error:  Unexpected EOF reading variables\n");
          sprintf (pout, "Was expecting %i records.  Found %i.\n", pfi->vnum, i);
          gaprnt (2,pout);
          goto retrn;
        }
	/* replace newline with null at end of record */
        for (ichar = strlen(rec) - 1 ;  ichar >= 0 ;  --ichar) {
	  if (rec[ichar] == '\n') {
	    rec[ichar] = '\0' ;
	    break ; 
	  }
        }
	/* Allow comments between VARS and ENDVARS */
        strcpy (mrec,rec);
        lowcas(rec);
	if ( (strncmp(mrec,"*",1)==0) || (strncmp(mrec,"#",1)==0) || !isalnum(*(mrec)) ) {
	  /* Parse comment if it contains attribute metadata  */
	  if (strncmp("*:attr",mrec,6)==0) {
	    rc = ddfattr (mrec, pfi);
	    if (rc == -1) goto retrn;
	    else continue;
	  }
  	  else continue; 
	}
        if (cmpwrd("endvars",rec)) {
          gaprnt (0,"XDFOpen Error:  Unexpected ENDVARS record\n");
          sprintf (pout, "Was expecting %i records.  Found %i.\n", pfi->vnum, i);
          gaprnt (2,pout);
          goto err9;
        }

	/* Get the compound variable name (ncname=>ganame). */
        pvar->longnm = NULL; 
        if ((getvnm(pvar, mrec))!=0) goto err6;

	/* copy abbrv to ganame  */
        parms->dvganames[i] = (char *) malloc( strlen(pvar->abbrv)*sizeof(char)) ;
	strcpy(parms->dvganames[i],pvar->abbrv);

	/* copy longnm to ncname if it exists, otherwise copy abbrv */
        if (pvar->longnm) {
	  parms->dvncnames[i] = (char *) malloc( strlen(pvar->longnm)*sizeof(char)) ;
	  strcpy(parms->dvncnames[i],pvar->longnm);
	} else {
	  parms->dvncnames[i] = (char *) malloc( strlen(pvar->abbrv)*sizeof(char)) ;
	  strcpy(parms->dvncnames[i],pvar->abbrv);
	}

        if ( (ch=nxtwrd(rec))==NULL) goto err6;  /* advance pointer to levels field */

        if ((ch == NULL) || (*ch == '\0')) {
	  parms->dvsetup[i] = 1 ; /* will figure out lvls, etc., in gadsdf */
        } else {
	  parms->dvsetup[i] = 0 ;
	  /* get the number of vertical levels */
	  if ( (pos=intprs(ch,&(pvar->levels)))==NULL ) goto err6;
	  if ( (ch=nxtwrd(ch))==NULL) goto err6;
	  /* parse the units field */
	  for (j=0;j<4;j++) pvar->units[j] = -999;
	  j = 0;
	  while (1) {
	    if ( (ch=intprs(ch,&(pvar->units[j])))==NULL ) goto err6;
	    while ((*ch==' ') || (*ch=='\t')) ch++;
	    if (*ch=='\0' || *ch=='\n') goto err6;
	    if (*ch!=',') break;
	    ch++;
	    while ((*ch==' ') || (*ch=='\t')) ch++;
	    if (*ch=='\0' || *ch=='\n') goto err6;
	    j++;
	    if (j>3) goto err6;
	  }
	  /* points into mixcase version where we left off in lowcased version */
	  ch = mrec + (ch - rec) ;
	  getstr (pvar->varnm,ch,127);

	  /* initialize the var_z counter for NASA GLA format */
	  pvar->var_z = 1;
	  if(pvar->units[0] == -1 && pvar->units[1] == 10 ) {
	    nzstride++;
	  }

	  /* var_t is for DRS var-t transforms */
	  pvar->var_t = 0;
	  if(pvar->units[0] == -1 && pvar->units[1] == 20 ) pvar->var_t = 1;

	  /* x-y transpose for lat/lon vice lon/lat data VERY INEFFICIENT!!! */
 	  pvar->y_x = 0;
	  if(pvar->units[0] == -1 && pvar->units[1] == 30) pvar->y_x = 1;

	  /* Non-float data types */
	  pvar->dfrm = 0;
	  if ((pvar->units[0] == -1 && pvar->units[1] == 40) && 
	      (pvar->units[2] >=  1 && pvar->units[2] <=  4)) {
	    pvar->dfrm= pvar->units[2];
	    if ( pvar->units[2] == 2 ) pvar->dfrm=2;
	    if ( pvar->units[2] == 2 && pvar->units[3] == -1) pvar->dfrm=-2;
	  }

#if GRADS_CRAY == 1
	  /* 32-bit big endian ieee to cray float */
	  if( (pvar->units[0]==-1 && pvar->units[1]==50) || crayflg ) pvar->dfrm=8;
#endif

	}
        i++; pvar++;
      }
      if (fgets(rec,512,descr)==NULL) {
        gaprnt (0,"XDFOpen Error:  Missing ENDVARS statement.\n");
        goto retrn;
      }

      /* See if record is an attribute comment, otherwise send error message */
      strcpy (mrec,rec);
      lowcas(rec);
      while (!cmpwrd("endvars",rec)) {
	if (strncmp("*:attr",mrec,6)==0) {
	  if ((ddfattr(mrec,pfi)) == -1) goto retrn;
	}
        else {
	  sprintf(pout,"Open Error:  Looking for \"endvars\", found \"%s\" instead.\n",rec);
	  gaprnt (0,pout);
	  goto err9;
	}
  	if (fgets(rec,256,descr)==NULL) {
	  gaprnt (0,"Open Error:  Missing ENDVARS statement.\n");
	  goto retrn;
	}
      }

    } else {
      /* Parse error of descriptor file */
      gaprnt (0,"XDFOpen Error:  Unknown keyword in description file\n");
      goto err9;
    }

  }
  
  err=0;
  for (i=0; i<1; i++) {
    if (flgs[i]) {
      sprintf (pout,"XDFOpen Error:  missing %s record \n", errs[i]);
      gaprnt (0,pout);
      err=1;
    }
  }
  
  if (err) goto retrn;
  
  if (pfi->type>1 && mflag) {
    if (mcnt==-1) {
      gaprnt (0,"XDFOpen Error: missing STNMAP record\n");
      err=1;
    } else if (mcnt != pfi->dnum[3]) {
      gaprnt (0,"XDFOpen Error: Inconsistent time count\n");
      sprintf (pout,"  Count in station map file = %li\n",mcnt);
      gaprnt (0,pout);
      sprintf (pout,"  Count in descriptor file = %i\n",pfi->dnum[3]);
      gaprnt (0,pout);
      err=1;
    }
  }
  
  if (err) goto retrn;
  
  /* Figure out locations of variables within a time group */
  if (pfi->vnum > 0) {
    pvar = pfi->pvar1;
  }
  /* Grid data  */
  if (pfi->type==1) {
    if (((!(parms->xsrch)) && (!(parms->xsetup))) &&
	((!(parms->ysrch)) && (!(parms->ysetup)))   ) {
      pfi->gsiz = pfi->dnum[0] * pfi->dnum[1];
    }
	
    /*mf
      add a constant xy header
      mf*/
    if (pfi->xyhdr) {
      pfi->gsiz = pfi->gsiz + pfi->xyhdr;
    }

    if (pfi->seqflg) {
      pfi->gsiz+=2;
      if (hdrb>0) hdrb+=2;
      pvar->offset = 1+hdrb;
      acum = 1+hdrb;
    } else {
      if (pfi->vnum > 0) {
	pvar->offset = hdrb;
      }
      acum = hdrb;
    }
    if (pfi->vnum > 0) {
      levs = pvar->levels;
      if (levs==0) levs=1;
      pvar->recoff = 0;
      recacm = 0;
      pvar++;
    }

    acumvz=acum;

    for (i=1; i<pfi->vnum; i++) {

      /* NASA GLA FORMAT CHECKS */
      /* upper air fields which var and z are transposed*/
      
      if( (pvar->units[0]==-1) && 
	  (pvar->units[1]==10) &&
	  (pvar->units[2]==1) ) {                 
						 
	levsua = pvar->levels;
	acum = acum + pfi->gsiz; 
	pvar->var_z = nzstride;

	/* diagnstotic fields AFTER  upper air fields which are in GrADS normal order */

      } else if( (pvar->units[0]==-1) && 
		 (pvar->units[1]==10) &&
		 (pvar->units[2]==2) ) {
	if(first) {
	  acumstride = acumstride + nzstride*levsua*pfi->gsiz;
	  acum = acumstride + (pvar->levels*pfi->gsiz) ;
	  first = 0 ;
	} else {
	  acum = acum + (levs*pfi->gsiz);
	} 

      } else if(pvar->var_t) {   /* DRS transposition of var and t */

	if(pfi->tmplat) {   /* time template, read the third unit param 
			       for the size of each chunk in a file */

	  if(pvar->units[2] != -999) {
	    acum = acum + levs*(pfi->gsiz)*(pvar->units[1]);
	  } else {
	    gaprnt (0,"Using time templat and 4-D variables, # times / file not specified\n");
	    gaprnt (0,"Defaulting to the number of times in the .ctl file\n");
	    acum = acum + levs*(pfi->gsiz)*(pfi->dnum[3]);
	  }
	} else { 
	  acum = acum + levs*(pfi->gsiz)*(pfi->dnum[3]);
	}

      } else  {                                 /* simple GrADS */

	acum = acum + (levs*pfi->gsiz);
	acumstride = acum ; 

      }

      recacm += levs;
      pvar->offset = acum;
      pvar->recoff = recacm;
      levs = pvar->levels;
      if (levs==0) levs=1;
      pvar++;

    }

    recacm += levs;

    /*mf 960514 correct for case where the last variable is a NASA UA */

    if (pfi->vnum > 0) {
      pvar--;
      if( (pvar->units[0]==-1) && 
	  (pvar->units[1]==10) &&
	  (pvar->units[2]==1) ) {
	acum = acumvz + recacm*pfi->gsiz;
      }else {					 
	acum = acum + (levs*pfi->gsiz);
      }
    }
    /*mf --------------mf*/
    /*
      time chunk header; the default is 0
    */
    if(pfi->seqflg && pfi->thdr>0) {
      pfi->thdr+=2;
    }
    pfi->tsiz = acum + pfi->thdr;

    /*mf --------------mf*/

    pfi->trecs = recacm;
    if (pfi->seqflg) pfi->tsiz-=1;
    pfi->tsiz += trlb;

    /*------------------- non grid data???? -------- */

  } else {
    if (!(parms->dvsrch)) {
      pfi->ivnum = pfi->lvnum = 0 ;
      for (i=0; i<pfi->vnum; i++) {
	if (!(parms->dvsetup[i])) /* catch rest in gadsdf */ {
	  if (pvar->levels!=0) {
	    ++(pfi->ivnum) ;
	  } else {
	    ++(pfi->lvnum) ;
	  }
	}
	pvar->offset = 0;
	pvar++;
      } /* for */
    } /* if we found dvars here */
  }

  /*mf---

  961204

  set the global calendar and check if we are trying to change with a new file...
  we do this here to set the calandar for templating

  ----mf*/

  if(mfcmn.cal365<0) {
    mfcmn.cal365=pfi->calendar;
  } else {
    if(pfi->calendar != mfcmn.cal365) {
      gaprnt(0,"Attempt to change the global calendar...\n");
      if(mfcmn.cal365) {
	gaprnt(0,
	       "The calendar is NOW 365 DAYS and you attempted to open a standard calendar file\n");
      } else {
	gaprnt(0,
	       "The calendar is NOW STANDARD and you attempted to open a 365-day calendar file\n");
      }
      goto retrn;
    }
  }

 
  /* if time series templating was specified, & the TDEF line was incomplete, */
  /* ERROR! */
  if (pfi->tmplat && parms->tsetup) {
    goto err1 ;
  }
  /* If the file name is a time series template, figure out
     which times go with which files, so we don't waste a lot
     of time later opening and closing files unnecessarily. */
  
  if (pfi->tmplat) {
    *ntsteps = pfi->dnum[3] ;
    dupstrval(pfi->name, template) ;
    pfi->fnums = (int *)malloc(sizeof(int)*pfi->dnum[3]);
    if (pfi->fnums==NULL) goto err8;
    j = 1;
    gr2t(pfi->grvals[3],1.0,&tdefi);
    ch = gafndt(pfi->name,&tdefi,&tdefi,pfi->abvals[3],NULL,1);
    if (ch==NULL) goto err8;
    dupstrval(ch, sdfname) ;
    *(pfi->fnums) = j;
    for (i=2; i<=pfi->dnum[3]; i++) {
      gr2t(pfi->grvals[3],(float)i,&tdef);
      pos = gafndt(pfi->name,&tdef,&tdefi,pfi->abvals[3],NULL,1);
      if (pos==NULL) goto err8;
      if (strcmp(ch,pos)!=0) {
	j = i;
	if (ch) {
	  free(ch);
	}
	ch = pos;
      }
      *(pfi->fnums+i-1) = j;
    }
    if (ch) {
      free(ch);
    }
    pfi->fnumc = 0;
  } else {
    dupstrval(pfi->name, sdfname) ;
  }
  
  fclose (descr);
  return(0);
  
 errm:
  gaprnt(0,"XDFopen Error: Invalid pdef record.\n");
  pfi->ppflag = 0;
  goto err9;
  
 err0:
  gaprnt(0, "XDFopen Error:  Missing or invalid dimension name.\n") ;
  goto err9;

 err1:
  gaprnt (0,"XDFopen Error:  Missing or invalid dimension size.\n");
  goto err9;
  
 err2:
  gaprnt (0,"XDFopen Error:  Missing or invalid dimension");
  gaprnt (0," scaling type\n");
  goto err9;
  
 err3:
  gaprnt (0,"XDFopen Error:  Missing or invalid dimension");
  gaprnt (0," starting value\n");
  goto err9;
  
 err4:
  gaprnt (0,"XDFopen Error:  Missing or invalid dimension");
  gaprnt (0," increment value\n");
  goto err9;

 err4a:
  gaprnt (0,"XDFopen Error:  0 time increment in tdef\n");
  gaprnt (0," use 1 for single time data\n");
  goto err9;
  
 err5:
  gaprnt (0,"XDFopen Error:  Missing or invalid variable");
  gaprnt (0," count\n");
  goto err9;
  
 err6:
  gaprnt (0,"XDFOpen Error:  Invalid variable record\n");
  goto err9;
  
 err7:
  gaprnt (0,"XDFopen Error:  Invalid number of levels\n");
  goto err9;
  
 err8:
  gaprnt (0,"XDFopen Error:  Memory allocation Error\n");
  goto retrn;
  
 err9:
  gaprnt (0,"  --> The invalid description file record is: \n");
  gaprnt (0,"  --> ");
  gaprnt (0,rec);
  gaprnt (0,"\n");
  
 retrn:
  gaprnt (0,"  The data file was not opened. \n");
  fclose (descr);
  if (mflflg) fclose(mfile);
  return(1);
  
}


char *
putncdnm(char *ch, char **dimname) {
  int lenstr, lendimname ;
    
  lenstr = strlen(ch) ;
  for (lendimname = 0 ;  (lendimname < lenstr) && (ch[lendimname] != ' ') ;
       ++lendimname) ;
  if (!(*dimname = (char *) malloc((lendimname + 1) * sizeof(char)))) {
    gaprnt(0, "Malloc err!\n") ;
    exit(13) ;
  }
  strncpy(*dimname, ch, lendimname) ;
  (*dimname)[lendimname] = '\0' ;
  for (ch += lendimname ;  (*ch == ' ') || (*ch == '\t') ;  ++ch) ;
  return(ch) ;
}

void
dupstrval(char *src, char **dest) {
  int lenstr ;
    
  lenstr = strlen(src) ;
  if (!(*dest = (char *) malloc((lenstr + 1) * sizeof(char)))) {
    gaprnt(0, "Malloc err!\n") ;
    exit(13) ;
  }
  strcpy(*dest, src) ;
  return ;
}

#ifndef STNDALN

/* Open an XDF data set by parsing the descriptor and reading the
   self-describing file for that data set and help to fill-in a gafile
   structure as need be.  Chain the gafile structure on to the list anchored
   in the gastat.                 */

int
gaxdfopen (char *args, struct gacmn *pcm) {
  struct gafile *pfi, *pfio;
  int size, rc, ntsteps, ichpos ;
  char pathname[256], *optargs, *template, *cntsteps, *fnpart, *aux, *faux ;
  char *sdfpath ;
  int i, idummy ;
  int gadxdf(char *path, struct gafile *pfi, char **template, int *ntsteps,
	     char **sdfpath, GASDFPARMS *parmsptr) ;
  int gadsdf(char *name, struct gafile *pfi, char *template, int ntsteps,
	     GASDFPARMS parms) ;
  GASDFPARMS parms ;
  int init_io_std(IO_STD **ptr) ;

  getwrd(pathname, args, 255) ;
  optargs = nxtwrd(args) ;
  gaprnt (2, "Scanning Descriptor File:  ");
  gaprnt (2, pathname);
  gaprnt (2, "\n");
#ifdef TESTING3
  if (optargs && (*optargs != '\0')) {
    gaprnt (2, "Optional args to XDFopen command are:  ") ;
    gaprnt (2, optargs) ;
    gaprnt (2, "\n") ;
  }
#endif
  pfi = getpfi();
  if (pfi == NULL) {
    gaprnt (0,"Memory Allocation Error:  On File Open\n");
    return (1);
  }
  pfi->is_a_SDF = 1 ;
  pfi->ncflg = 3;       /* set a flag for detecting xdf files that is not #ifdef'd */
  if (!init_io_std(&(pfi->sdf_ptr))) {
    gaprnt(0, "Memory Allocation Error:  On XDF File Open\n") ;
    return(1) ;
  }
  pfi->tmplat = 0 ; /* assume no templating, unless get indication on OPTIONS */
  rc = gadxdf(pathname, pfi, &template, &ntsteps, &sdfpath, &parms) ;

#ifdef TESTING
  fprintf(stderr, "Return code from gadxdf=%d.\n", rc) ;
  fprintf(stderr, "Calling xdumpfile after gadxdf.\n") ;
  xdumpfile(pfi) ;
  if (pfi->pvar1) {
    fprintf(stderr, "Calling xdumpvar on first var after gadxdf.\n") ;
    xdumpvar(pfi->pvar1) ;
  }
#endif
  if (rc) {
    frepfi (pfi, 0) ;
    return (rc) ;
  }
  if (pcm->pfi1==NULL) {
    pcm->pfi1 = pfi;
  } else {
    pfio = pcm->pfi1;
    while (pfio->pforw!=NULL) pfio = pfio->pforw;
    pfio->pforw = pfi;
  }
  pfi->pforw = NULL;
  pcm->fnum++;
  if (pcm->fnum==1) {pcm->pfid = pcm->pfi1; pcm->dfnum = 1;}
  rc = gadsdf(sdfpath, pfi, template, ntsteps, parms) ;
  if (rc) {
    sprintf(pout, "SDF file %s was not successfully opened & parsed.\n", sdfpath) ;
    gaprnt(0, pout) ;
    frepfi (pfi, 0) ;
    if (pcm->fnum <= 1) { 
      pcm->pfid = pcm->pfi1 = (struct gafile *) 0 ;
      pcm->fnum  = 0 ; 
      pcm->dfnum = 0 ;
    } else {
      pcm->fnum-- ;
      for (idummy = 1, pfi = pcm->pfi1 ; (idummy < pcm->fnum) && pfi ; ++idummy) {
	pfi = pfi->pforw ;
      }
      if (pfi) {
	pfi->pforw = (struct gafile *) 0 ;
      }
    }
    pfi = (struct gafile *) 0 ;
    return(rc) ;
  } else {
    sprintf(pout, "SDF file %s is open as file %i\n", pfi->name, pcm->fnum);
    gaprnt(2, pout);
  }
  /* If first file open, set up some default dimension
     ranges for the user */

  if (pcm->fnum==1) {
    if (pfi->type==2 || pfi->wrap) gacmd ("set lon 0 360",pcm,0);
    else {
      sprintf (pout,"set x 1 %i",pfi->dnum[0]);
      gacmd (pout,pcm,0);
    }
    if (pfi->type==2) {
      gacmd ("set lat -90 90",pcm,0);
      gacmd ("set lev 500",pcm,0);
    } else {
      sprintf (pout,"set y 1 %i",pfi->dnum[1]);
      gacmd (pout,pcm,0);
      gacmd ("set z 1",pcm,0);
    }
    gacmd ("set t 1",pcm,0);
  }

  if (pfi->ppflag) {
    sprintf (pout,"Notice: Implied interpolation for file %s\n",pathname);
    gaprnt (1,pout);
    gaprnt (1," Interpolation will be performed on any data ");
    gaprnt (1,"displayed from this file\n");
  }

  return (0);
}

/* This function takes a grid request struct, fills it from an SDF file, */
/* and returns the fgrid array with floating point values, unpacking the */
/* SDF values if need be */

#define SDFTINDEX 0
#define GXINDEX 0
#define GYINDEX 1
#define GZINDEX 2
#define GTINDEX 3
#define AONAME "add_offset"
#define SFNAME "scale_factor"
#define AONAME2 "intercept"
#define SFNAME2 "slope"
#define MVNAME "missing_value"

int
gagsdf(struct gagrid *gridptr, float fgrid[]) {
  /* This is a wrapper that determines the part of the request that is within */
  /* the bounds of the file, and makes a fake request to gafgsdf for that part */
  /* It first fills in the entire request with UNDEF values.  After gafgsdf */
  /* returns, the "good" area is copied into the real grid, and the real grid */
  /* request structure is updated for sdf_ptr (might've opened a new file if */
  /* templating) and for pfile->fnumc (same reason) */
  int gafgsdf(struct gagrid *fakegrdptr, float fakegrd[], int Xinvolved) ;
  int rgxstart, rgxstop, rgxsize, rgystart, rgystop, rgysize ;
  int rgzstart, rgzstop, rgzsize, rgtstart, rgtstop, rgtsize ;
  int gxinx, gyinx, gzinx, gtinx, ginx, indx, retcode, yxsize, iindx, jindx ;
  int lxinx, lyinx, lzinx, ltinx, gxsize, gysize, gzsize, gtsize, zyxsize ;
  int rzyxsize, ryxsize, gridsize, istart, istop, jstart, jstop, ioff, joff ;
  int *iinxptr, *jinxptr, Xinvolved, abbrvlen ;
  int dim0size, dim1size, dim2size, dim3size, dim2_3size, dim1_2_3size ;
  int *dim0inx, *dim1inx, *dim2inx, *dim3inx, iisx, jisx ;
  VAR_INFO *data_var ;
  float *fakefgrid, missval ;
  struct gagrid *fakegridptr ;
#define MIn(a, b) ((a < b)?a:b)
#define MAx(a, b) ((a > b)?a:b)

  for (data_var = gridptr->pfile->sdf_ptr->var ;  data_var ;
       data_var = data_var->next) {
    if (!strcasecmp(gridptr->pvar->abbrv, data_var->gradsabbr)) {
      break ;
    }
  }
  if (!data_var) {
    if (gridptr->pvar->longnm) {
      sprintf(pout, "Couldn't find variable %s (aliased to %s) in SDF file.\n",
	      gridptr->pvar->longnm, gridptr->pvar->abbrv) ;
      gaprnt(0, pout) ;
      return(2) ;
    } else {
      sprintf(pout, "Couldn't find variable %s in SDF file.\n", gridptr->pvar->abbrv) ;
      gaprnt(0, pout) ;
      return(2) ;
    }
  }
  switch (data_var->vartype) {
  case NC_BYTE:
    gridptr->undef = (float) data_var->missing_value.bval ;
    break ;
  case NC_SHORT:
    gridptr->undef = (float) data_var->missing_value.sval ;
    break ;
  case NC_LONG:
    gridptr->undef = (float) data_var->missing_value.lval ;
    break ;
  case NC_FLOAT:
    gridptr->undef = (float) data_var->missing_value.fval ;
    break ;
  case NC_DOUBLE:
    gridptr->undef = (float) data_var->missing_value.dval ;
    break ;
  } /* end switch */
  if (gridptr->pfile->sdf_ptr->hasDDFundef) {
    gridptr->undef = gridptr->pfile->undef ;
  } /* UNDEF stmt in DDF overrides NetCDF metadata, if any */
  Xinvolved = (gridptr->idim == GXINDEX) || (gridptr->jdim == GXINDEX) ;
  if ((gridptr->idim) >= 0) {
    if ((gridptr->jdim) >= 0) {
      gridsize = gridptr->isiz * gridptr->jsiz ;
    } else {
      gridsize = gridptr->isiz ;
    }
  } else {
    if ((gridptr->jdim) >= 0) {
      gridsize = gridptr->jsiz ;
    } else /* both invalid => 1 grid locs */ {
      gridsize = 1 ;
    }
  }
  gxsize = gridptr->dimmax[GXINDEX] - gridptr->dimmin[GXINDEX] + 1 ;
  gysize = gridptr->dimmax[GYINDEX] - gridptr->dimmin[GYINDEX] + 1 ;
  gzsize = gridptr->dimmax[GZINDEX] - gridptr->dimmin[GZINDEX] + 1 ;
  gtsize = gridptr->dimmax[GTINDEX] - gridptr->dimmin[GTINDEX] + 1 ;
  yxsize = gysize * gxsize ;
  zyxsize = gzsize * yxsize ;
  for (indx = 0 ;  indx < gridsize ;  ++indx) {
    fgrid[indx] = gridptr->undef ;
  } /* assume all missing initially; this covers out-of-bounds requests */
  if ((gridptr->idim != GXINDEX) && (gridptr->jdim != GXINDEX)) {
    rgxstart = rgxstop = MAx(gridptr->dimmin[GXINDEX], 1) ;
    /* X-dim. not involved this request */
  } else {
    if (gridptr->pfile->wrap && Xinvolved) {
      /* if longitudes wrap, there are no "outside" x locations */
      rgxstart = gridptr->dimmin[GXINDEX] ;
      rgxstop  = gridptr->dimmax[GXINDEX] ;
    } else {
      if ((gridptr->dimmin[GXINDEX] > gridptr->pfile->dnum[GXINDEX]) ||
	  (gridptr->dimmax[GXINDEX] < 1)) {
	return(0) /* all points are out of bounds */ ;
      }
      rgxstart = MAx(gridptr->dimmin[GXINDEX], 1) ;
      rgxstart = MIn(rgxstart, gridptr->pfile->dnum[GXINDEX]) ;
      rgxstop =  MIn(gridptr->dimmax[GXINDEX], gridptr->pfile->dnum[GXINDEX]) ;
      rgxstop =  MAx(rgxstop, 1) ;
    }
  }
  rgxsize = rgxstop - rgxstart + 1 ;
  if ((gridptr->idim != GYINDEX) && (gridptr->jdim != GYINDEX)) {
    rgystart = rgystop = MAx(gridptr->dimmin[GYINDEX], 1) ;
    /* Y-dim. not involved this request */
  } else {
    if ((gridptr->dimmin[GYINDEX] > gridptr->pfile->dnum[GYINDEX]) ||
	(gridptr->dimmax[GYINDEX] < 1)) {
      return(0) /* all points are out of bounds */ ;
    }
    rgystart = MAx(gridptr->dimmin[GYINDEX], 1) ;
    rgystart = MIn(rgystart, gridptr->pfile->dnum[GYINDEX]) ;
    rgystop =  MIn(gridptr->dimmax[GYINDEX], gridptr->pfile->dnum[GYINDEX]) ;
    rgystop =  MAx(rgystop, 1) ;
  }
  rgysize = rgystop - rgystart + 1 ;
  if ((gridptr->idim != GZINDEX) && (gridptr->jdim != GZINDEX)) {
    if (gridptr->pvar->levels > 0) {
      rgzstart = rgzstop = MAx(gridptr->dimmin[GZINDEX], 1) ;
    } else {
      rgzstart = rgzstop = 1 ;
    }
    /* Z-dim. not involved this request */
  } else {
    if ((gridptr->dimmin[GZINDEX] > gridptr->pfile->dnum[GZINDEX]) ||
	(gridptr->dimmax[GZINDEX] < 1)) {
      return(0) /* all points are out of bounds */ ;
    }
    rgzstart = MAx(gridptr->dimmin[GZINDEX], 1) ;
    rgzstart = MIn(rgzstart, gridptr->pfile->dnum[GZINDEX]) ;
    rgzstop =  MIn(gridptr->dimmax[GZINDEX], gridptr->pfile->dnum[GZINDEX]) ;
    rgzstop =  MAx(rgzstop, 1) ;
  }
  rgzsize = rgzstop - rgzstart + 1 ;
  if ((gridptr->idim != GTINDEX) && (gridptr->jdim != GTINDEX)) {
    rgtstart = rgtstop = MAx(gridptr->dimmin[GTINDEX], 1) ;
    /* T-dim. not involved in this request */
  } else {
    if ((gridptr->dimmin[GTINDEX] > gridptr->pfile->dnum[GTINDEX]) ||
	(gridptr->dimmax[GTINDEX] < 1)) {
      return(0) /* all points are out of bounds */ ;
    }
    rgtstart = MAx(gridptr->dimmin[GTINDEX], 1) ;
    rgtstart = MIn(rgtstart, gridptr->pfile->dnum[GTINDEX]) ;
    rgtstop =  MIn(gridptr->dimmax[GTINDEX], gridptr->pfile->dnum[GTINDEX]) ;
    rgtstop =  MAx(rgtstop, 1) ;
  }
  rgtsize = rgtstop - rgtstart + 1 ;
  switch (gridptr->idim) {
  case GXINDEX:
    istart = rgxstart ;
    istop = rgxstop ;
    /* actually, istop should be restrict. by SDF max., but it works, so no change */
    iinxptr = &gxinx ;
    break ;
  case GYINDEX:
    istart = rgystart ;
    istop = rgystop ;
    iinxptr = &gyinx ;
    break ;
  case GZINDEX:
    istart = rgzstart ;
    istop = rgzstop ;
    iinxptr = &gzinx ;
    break ;
  case GTINDEX:
    istart = rgtstart ;
    istop = rgtstop ;
    iinxptr = &gtinx ;
    break ;
  default:
    istart = istop = 0 ; iinxptr = NULL ;
    break ;
  }
  if (gridptr->dimmin[gridptr->idim] < 1) {
    ioff = 1 - gridptr->dimmin[gridptr->idim] ;
  } else {
    ioff = 0 ;
  }
  if (gridptr->pfile->wrap && (gridptr->idim == GXINDEX)) /* wrap case */ {
    ioff = 0 ; /* would otherwise be miss-set, in normal case to 1 */
  }
  switch (gridptr->jdim) {
  case GXINDEX:
    jstart = rgxstart ;
    jstop = rgxstop ;
    jinxptr = &gxinx ;
    break ;
  case GYINDEX:
    jstart = rgystart ;
    jstop = rgystop ;
    jinxptr = &gyinx ;
    break ;
  case GZINDEX:
    jstart = rgzstart ;
    jstop = rgzstop ;
    jinxptr = &gzinx ;
    break ;
  case GTINDEX:
    jstart = rgtstart ;
    jstop = rgtstop ;
    jinxptr = &gtinx ;
    break ;
  default:
    jstart = jstop = 0 ; jinxptr = NULL ;
    break ;
  }
  if (gridptr->dimmin[gridptr->jdim] < 1) {
    joff = 1 - gridptr->dimmin[gridptr->jdim] ;
  } else {
    joff = 0 ;
  }
  if (gridptr->pfile->wrap && (gridptr->jdim == GXINDEX)) /* wrap case */ {
    joff = 0 ; /* would otherwise be miss-set, in normal case to 1 */
  }
  ryxsize = rgysize * rgxsize ;
  rzyxsize = rgzsize * ryxsize ;
  if (gridsize > 0) {
    fakefgrid = (float *) malloc(sizeof(float)*gridsize) ;
    if (!fakefgrid) {
      gaprnt(0, "Memory allocation error handling SDF grid request(1).\n") ;
      return(13) ;
    }
    fakegridptr = (struct gagrid *) malloc(sizeof(struct gagrid)) ;
    if (!fakegridptr) {
      gaprnt(0, "Memory allocation error handling SDF grid request(2).\n") ;
      if (fakefgrid) {
	free(fakefgrid) ;
      }
      return(14) ;
    }
  } else /* didn't we return on gridsize == 0 already? */ {
    return(0) ;
  }
  /* no doubt, some C compiler on some platform will blow structure assignment, */
  /* so this is done the hard way, rather than "*fakegridptr = *gridptr ;" */
  fakegridptr->grid = gridptr->grid ;
  fakegridptr->pfile = gridptr->pfile ;
  fakegridptr->undef = gridptr->undef ;
  fakegridptr->rmin = gridptr->rmin ;
  fakegridptr->rmax = gridptr->rmax ;
  fakegridptr->isiz = gridptr->isiz ;
  if ((gridptr->idim) < 0) fakegridptr->isiz = 1 ;
  fakegridptr->jsiz = gridptr->jsiz ;
  if ((gridptr->jdim) < 0) fakegridptr->jsiz = 1 ;
  fakegridptr->idim = gridptr->idim ;
  fakegridptr->jdim = gridptr->jdim ;
  /* only two (at most!) of these should really vary now */
  fakegridptr->dimmin[GXINDEX] = rgxstart ;
  fakegridptr->dimmax[GXINDEX] = rgxstop ;
  fakegridptr->dimmin[GYINDEX] = rgystart ;
  fakegridptr->dimmax[GYINDEX] = rgystop ;
  fakegridptr->dimmin[GZINDEX] = rgzstart ;
  fakegridptr->dimmax[GZINDEX] = rgzstop ;
  fakegridptr->dimmin[GTINDEX] = rgtstart ;
  fakegridptr->dimmax[GTINDEX] = rgtstop ;
  fakegridptr->pvar = gridptr->pvar ;
  fakegridptr->exprsn = gridptr->exprsn ;
  fakegridptr->alocf = gridptr->alocf ;
  fakegridptr->igrab = gridptr->igrab ;
  fakegridptr->jgrab = gridptr->jgrab ;
  fakegridptr->iabgr = gridptr->iabgr ;
  fakegridptr->jabgr = gridptr->jabgr ;
  fakegridptr->ivals = gridptr->ivals ;
  fakegridptr->jvals = gridptr->jvals ;
  fakegridptr->ilinr = gridptr->ilinr ;
  fakegridptr->jlinr = gridptr->jlinr ;
  retcode = gafgsdf(fakegridptr, fakefgrid, Xinvolved) ;
  if (retcode == 0) {
    for (gxinx = rgxstart, lxinx = 0 ;  gxinx <= rgxstop ;
	 ++gxinx, ++lxinx) {
      for (gyinx = rgystart, lyinx = 0 ;  gyinx <= rgystop ;
	   ++gyinx, ++lyinx) {
	for (gzinx = rgzstart, lzinx = 0 ;  gzinx <= rgzstop ;
	     ++gzinx, ++lzinx) {
	  for (gtinx = rgtstart, ltinx = 0 ;  gtinx <= rgtstop ;
	       ++gtinx, ++ltinx) {
	    if (!jinxptr) {
	      if (!iinxptr) {
		ginx = 0 ;
	      } else {
		ginx = (*iinxptr) - istart + ioff ;
	      }
	    } else /* jinxptr is good */ {
	      if (!iinxptr) {
		ginx = (*jinxptr) - jstart + joff ;
	      } else /* both are good */ {
	      }
	    }
	    ginx = (gtinx - gridptr->dimmin[GTINDEX]) * zyxsize +
	      (gzinx - gridptr->dimmin[GZINDEX]) * yxsize +
	      (gyinx - gridptr->dimmin[GYINDEX]) * gxsize +
	      (gxinx - gridptr->dimmin[GXINDEX]) ;
	    /* doesn't this calculation make the t-z-y-x assumption? */
	    indx = ltinx * rzyxsize + lzinx * ryxsize +
	      lyinx * rgxsize + lxinx ;
	    fgrid[ginx] = fakefgrid[indx] ;
	  } /* time */
	} /* z */
      } /* y */
    } /* x */
  } /* if there's any point in copying over the results */
  if (fakefgrid) {
    free(fakefgrid) ;
  }
  if (fakegridptr) {
    free(fakegridptr) ;
  }
  return(retcode) ;
}

/* This is the fake grid request handler for SDF files.  It is wrapped by */
/* gagsdf, which passes a fake grid request to this that is within the */
/* file's bounds */
int
gafgsdf(struct gagrid *gridptr, float fgrid[], int Xinvolved) {
  long *start, *count, gridcnt ;
  int is4d, ispacked, abbrvlen, /* whichdim[4], */ gridinx ;
  int xstart, ystart, zstart, tstart, xstop, ystop, zstop, tstop ;
  int xincr, yincr, zincr, tincr, xinx, yinx, zinx, tinx ;
  int gxinx, gyinx, gzinx, gtinx, ztsize, yztsize ;
  int gxstart, gxstop, gxincr, gtstart, gtstop, gtincr, grinx, inx ;
  int gystart, gystop, gyincr, gzstart, gzstop, gzincr ;
  int xindex, yindex, zindex, tindex, yxsize, zyxsize, mininx, maxinx ;
  int timeindex, tcnt, zcnt, ycnt, xcnt ;
  int xdimindx, ydimindx, zdimindx, tdimindx, tcount, starttime, newtime ;
  int willwrap, littlex, bigx, sdfxcount, usingFV=0, wasmiss ;
  int fillwithmiss, alltimesinthisfile, alltimesin1file ;
  float *fdata, fmiss, myao, mysf, fFillValue ;
  short *sdata, smiss, sFillValue ;
  double *ddata, dFillValue, dmiss ;

  struct attrib_list *aoattr, *sfattr, *missvalattr, *FVattr ;
  VAR_INFO *data_var ;
  union att_val ao, sf, junk ;
  nc_type unpktype, pktype ;
  struct attrib_list *find_att(struct attrib_list *first_att, char *attname) ;
  int are_data_packed(VAR_INFO *in_var, union att_val *scale,
		      union att_val *offset, nc_type *unpktype,
		      nc_type *pktype) ;
  int sdfwrap(VAR_INFO **dvar_ptr, struct attrib_list *missvalattr, int ispacked,
	      int is4d, float ao, float sf, int tdimindx, int tindex,
	      int zdimindx, int zindex, int ydimindx, int yindex, int xdimindx,
	      int xindex, struct gagrid *gridptr, float *fgrid,
	      nc_type pktype, nc_type unpktype, int sdfxcount, int usingFV) ;
  int gaopsdf(int timeindex, struct gagrid *gridptr, VAR_INFO **data_var_ptr) ;
  void init_start_count(long **start, long **count, int ndims) ;
  int fequal(float op1, float op2, float delta) ;
  int dequal(double op1, double op2, double delta) ;

  /* Search for data_var based on max. 15 char match on gridptr->pvar->abbrv */
  /* Fill start and count based on gridptr->dimmin and gridptr->dimmax and is4d */
  /* Call read_variable_data(gridptr->pfile->sdf_ptr->cdfid, data_var, start, */
  /*                                                                   count) */
  /* Check data_var->vartype:  NC_SHORT => ispacked=1, NC_FLOAT => ispacked=0 */
  /* If ispacked, unpack into grid; else copy into grid. */
  /* Addenda to above: if (ispacked || (pktype != FLOAT)), treat as packed */

  /*    abbrvlen = (int) strlen(gridptr->pvar->abbrv) ; */
  /* netCDF name may be longer */
  fillwithmiss = 0 ;
  for (data_var = gridptr->pfile->sdf_ptr->var ;  data_var ;
       data_var = data_var->next) {
    if (!strcasecmp(gridptr->pvar->abbrv, data_var->gradsabbr)) {
      break ;
    }
  }
  if (!data_var) {
    sprintf(pout, "Couldn't find variable %s in SDF file.\n", gridptr->pvar->abbrv) ;
    gaprnt(0, pout) ;
    return(2) ;
  }
  init_start_count(&start, &count, data_var->nvardims) ;
  /* Here's the rub:  if this is an XDFopen-ed file, and that DDF had an UNDEF */
  /* statement, we don't want to look for it in an attribute value.  However, */
  /* I don't know how to tell this origin info at this point; it was in the */
  /* parms structure during data discovery phase, (isxdf and needundef */
  /* components), but I don't see any way to access that here.  Hoop, 2002/03/13  */
  missvalattr = (struct attrib_list *) 0 ;
  if (gridptr->pfile->sdf_ptr->hasDDFundef) {
    fmiss = gridptr->pfile->undef ;
  } else {
    missvalattr = find_att(data_var->first_vattr, MVNAME) ; /* ok if not found? */
    if (!missvalattr) {
      missvalattr = find_att(data_var->first_vattr, "_FillValue") ;
      usingFV = 1 ; /* don't need to make two checks if using this one */
    }
  }
  ispacked = are_data_packed(data_var, &sf, &ao, &unpktype, &pktype) ;
  if (pktype == NC_FLOAT) {
    if (!(gridptr->pfile->sdf_ptr->hasDDFundef)) {
      if (missvalattr) {
	fdata = (float *) missvalattr->data ;
	fmiss = *fdata ;
      } else {
	fmiss = FILL_FLOAT ;
      }
    }
  } else if (pktype == NC_DOUBLE) {
    if (!(gridptr->pfile->sdf_ptr->hasDDFundef)) {
      if (missvalattr) {
	ddata = (double *) missvalattr->data ;
	dmiss = *ddata ;
      } else {
	dmiss = FILL_DOUBLE ;
      }
    }
  }
  if ((pktype != NC_FLOAT) &&(pktype != NC_DOUBLE)) ispacked = 1 ;
  if (ispacked && (pktype != NC_SHORT)) /* bail for now */ {
    gaprnt(0, "SDF data variable has unsupported packed data type.\n") ;
    return(6) ;
  }
  if (ispacked && (pktype == unpktype)) {
    /* trouble is, this call doesn't happen in are_data_packed if pktype=unpktype */
    /* Another trouble is that we don't want to do this if sf or ao are present */
    if (!(sfattr = find_att(data_var->first_vattr, SFNAME))) {
      if (!(sfattr = find_att(data_var->first_vattr, SFNAME2))) {
	set_default_scale_offset(unpktype, &sf, &junk) ;
      }
    }
    if (!(aoattr = find_att(data_var->first_vattr, AONAME))) {
      if (!(aoattr = find_att(data_var->first_vattr, AONAME2))) {
	set_default_scale_offset(unpktype, &junk, &ao) ;
      }
    }
  }
  if (ispacked) /* figure myao, mysf */ {
    switch (unpktype) {
    case NC_SHORT:
      myao = (float) ao.sval ;
      mysf = (float) sf.sval ;
      break ;
    case NC_LONG:
      myao = (float) ao.lval ;
      mysf = (float) sf.lval ;
      break ;
    case NC_FLOAT:
      myao = ao.fval ;
      mysf = sf.fval ;
      break ;
    case NC_DOUBLE:
      myao = (float) ao.dval ;
      mysf = (float) sf.dval ;
      break ;
    default:
      gaprnt(0, "SDF data variable has unsupported unpacked data type.\n") ;
      break ;
    } /* end switch */
  }
  tdimindx = data_var->dimidmap[0] ;
  tindex = data_var->dimmap[0] ;
  zdimindx = data_var->dimidmap[1] ;
  zindex = data_var->dimmap[1] ;
  ydimindx = data_var->dimidmap[2] ;
  yindex = data_var->dimmap[2] ;
  xdimindx = data_var->dimidmap[3] ;
  xindex = data_var->dimmap[3] ;
  is4d = (zindex != -1) ? 1 : 0 ;
  if (Xinvolved) {
    willwrap = 1 ;
    littlex = gridptr->dimmin[GXINDEX] ;
    bigx = gridptr->dimmax[GXINDEX] ;
    sdfxcount = gridptr->pfile->sdf_ptr->dimsiz[xdimindx] ;
    if ((littlex <= sdfxcount) && (bigx <= sdfxcount)) {
      if ((littlex > 0) && (bigx > 0)) {
	willwrap = 0 ;
      }
    }
  } else {
    willwrap = 0 ;
  }
  if ((gridptr->pfile->wrap && Xinvolved) && (willwrap)) {
    return(sdfwrap(&data_var, missvalattr, ispacked, is4d, myao, mysf,
		   tdimindx, tindex, zdimindx, zindex, ydimindx, yindex,
		   xdimindx, xindex, gridptr, fgrid, pktype, unpktype,
		   sdfxcount, usingFV)) ;
  } else {
    if (!ispacked) /* just copy */ {
      if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
	/* need to check for _FillValue as well as missing_value */
	FVattr = find_att(data_var->first_vattr, "_FillValue") ;
	if (pktype == NC_FLOAT) {
	  if (FVattr) {
	    fdata = (float *) FVattr->data ;
	    fFillValue = *fdata ;
	  } else {
	    fFillValue = FILL_FLOAT ;
	  }
	} else /* must be double, right? */ {
	  if (FVattr) {
	    ddata = (double *) FVattr-> data ;
	    dFillValue = *ddata ;
	  } else {
	    dFillValue = FILL_DOUBLE ;
	  }
	} /* is double, I guess */
      } /* !usingFV */
    } else /* must unpack */ {
      if ((!missvalattr) && (pktype != unpktype)) {
	smiss = (int) (((gridptr->undef - myao) / mysf) + 0.5) ;
      } else {
	if ((pktype == unpktype) && (!missvalattr)) {
	  smiss = FILL_SHORT ;
	} else {
	  sdata = (short *) missvalattr->data ;
	  smiss = *sdata ;
	}
      }
      if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
	FVattr = find_att(data_var->first_vattr, "_FillValue") ;
	if (FVattr) {
	  sdata = (short *) FVattr->data ;
	  sFillValue = *sdata ;
	} else {
	  sFillValue = FILL_SHORT ;
	}
      } /* !using FV */
    } /* is it packed? */
    start[xindex] = gridptr->dimmin[GXINDEX] - 1 ;  /* dimmin be 1-based */
    if (gridptr->pfile->yrflg) {
      maxinx = gridptr->pfile->sdf_ptr->dimsiz[ydimindx]
	- gridptr->dimmin[GYINDEX] ;
      mininx = gridptr->pfile->sdf_ptr->dimsiz[ydimindx]
	- gridptr->dimmax[GYINDEX] ;
      start[yindex] = mininx ;
    } else {
      start[yindex] = gridptr->dimmin[GYINDEX] - 1 ;
    }
    count[yindex] = gridptr->dimmax[GYINDEX] - gridptr->dimmin[GYINDEX] + 1 ;
    if (count[yindex] > gridptr->pfile->sdf_ptr->dimsiz[ydimindx]) {
      count[yindex] = gridptr->pfile->sdf_ptr->dimsiz[ydimindx] ;
    }
    count[xindex] = gridptr->dimmax[GXINDEX] - gridptr->dimmin[GXINDEX] + 1 ;
    if (count[xindex] > gridptr->pfile->sdf_ptr->dimsiz[xdimindx]) {
      count[xindex] = gridptr->pfile->sdf_ptr->dimsiz[xdimindx] ;
    }
    gxstart = xstart = 0 ;
    gxstop = xstop = count[xindex] ;
    gxincr = xincr = 1 ;
    gystart = 0 ;
    gystop = count[yindex] ;
    gyincr = 1 ;
    if (gridptr->pfile->yrflg) {
      ystart = gystop - 1 ;
      ystop = gystart - 1 ;
      yincr = -1 ;
    } else {
      ystart = gystart ;
      ystop = gystop ;
      yincr = 1 ;
    }
    gridcnt = count[xindex] * count[yindex] ;
    if (is4d) {
      if (gridptr->pfile->zrflg) {
	/* Should determine z dim index empirically */
	maxinx = gridptr->pfile->sdf_ptr->dimsiz[zdimindx]
	  - gridptr->dimmin[GZINDEX] ;
	mininx = gridptr->pfile->sdf_ptr->dimsiz[zdimindx]
	  - gridptr->dimmax[GZINDEX] ;
	start[zindex] = mininx ;
      } else {
	start[zindex] = gridptr->dimmin[GZINDEX] - 1 ;
      }
      count[zindex] = gridptr->dimmax[GZINDEX] - gridptr->dimmin[GZINDEX]
	+ 1 ;
      if (count[zindex] > gridptr->pfile->sdf_ptr->dimsiz[zdimindx]) {
	count[zindex] = gridptr->pfile->sdf_ptr->dimsiz[zdimindx] ;
      }
      gridcnt *= count[zindex] ;
      gzstart = 0 ;
      gzstop = count[zindex] ;
      gzincr = 1 ;
      if (gridptr->pfile->zrflg) {
	zstart = gzstop - 1 ;
	zstop = gzstart - 1 ;
	zincr = -1 ;
      } else {
	zstart = gzstart ;
	zstop = gzstop ;
	zincr = 1 ;
      }
    } else {
      gzstart = zstart = 0 ;
      gzstop = zstop = 1 ;
      gzincr = zincr = 1 ;
    }
    starttime = gridptr->dimmin[GTINDEX]  ;
    tcount = gridptr->dimmax[GTINDEX] - starttime + 1 ;
    if (tindex != -1) {
      count[tindex] = 1 ; /* read each time step separately for templating */
    }
    gtstart = tstart = 0 ;
    gtstop = tstop = tcount ;
    gtincr = tincr = 1 ;
    yxsize = count[yindex] * count[xindex] ;
    zyxsize = (gzstop - gzstart) * yxsize ;
    gridcnt *= tcount ; /*???*/
#ifdef TESTING
    fprintf(stderr, "Xloop runs from %d to %d step %d (%d to %d step %d).\n",
	    gxstart, gxstop, gxincr, xstart, xstop, xincr) ;
    fprintf(stderr, "Yloop runs from %d to %d step %d (%d to %d step %d).\n",
	    gystart, gystop, gyincr, ystart, ystop, yincr) ;
    fprintf(stderr, "Zloop runs from %d to %d step %d (%d to %d step %d).\n",
	    gzstart, gzstop, gzincr, zstart, zstop, zincr) ;
    fprintf(stderr, "Tloop runs from %d to %d step %d (%d to %d step %d).\n",
	    gtstart, gtstop, gtincr, tstart, tstop, tincr) ;
#endif
    /* experiment to increase performance when not templating Hoop 2K/11/22 */
    alltimesinthisfile = 0 ;
    alltimesin1file = 0 ;
    if (gridptr->pfile->tmplat) {
      if ((*(gridptr->pfile->fnums + starttime - 1)) == gridptr->pfile->fnumc) {
	/* this time slice starts in the current file, so let's see if */
	/* it ends in the same file */
	if ((*(gridptr->pfile->fnums + starttime - 1 + tstop - tstart - 1)) ==
	    gridptr->pfile->fnumc) /* ends in same file */ {
	  alltimesinthisfile = 1 ;
	  alltimesin1file = 1 ;
	}
      } else /* first time not in current file */ {
	if ((*(gridptr->pfile->fnums + starttime - 1)) ==
	    (*(gridptr->pfile->fnums + starttime - 1 + tstop - tstart - 1))) {
	  alltimesin1file = 1 ;
	}
      } /* is first time in current file */
    } /* if templating */
    if ((!(gridptr->pfile->tmplat)) || alltimesinthisfile) {
      if (tindex != -1) {
	start[tindex] = starttime - 1 ;
	count[tindex] = tstop - tstart ;
      } /* if we have a valid tindex => we have a time dim. */
      if (gridptr->pfile->tmplat) {
	if ((gridptr->pfile->fnums[0]) != (gridptr->pfile->fnumc)) {
	  /* if we are not on the first file, we still need to call gaopsdf to */
	  /* adulterate the starttime to be one relative to the current file */
	  /* -Hoop, 2001/04/14 */
	  newtime = gaopsdf(starttime, gridptr, &data_var) ;
	  if (newtime == -99999) /* bad surprise */ {
	    gaprnt(0, "Bad time index in SDF file.\n") ;
	    return(1) ; /* bad time index */
	  } /* bad surprise */
	  if (newtime == -88888) /* bad file, bad surprise */ {
	    for (grinx = 0 ;  grinx < gridcnt ;  ++grinx) {
	      fgrid[grinx] = gridptr->undef ;
	    }
	    return(0) ;
	  } /* bad file, bad surprise */
	  if (tindex != -1) {
	    start[tindex] = newtime - 1 ;
	  }
	} /* if not 1st file, thus need new starttime */
      } /* if templating */
      if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid,
			      data_var, start, count)) {
	gaprnt(0, "Failure reading SDF data.  #1\n") ;
	return(3) ;
      }
    } /* end if not templating, read all times at once */ else {
      if (alltimesin1file) {
	if (tindex != -1) {
	  start[tindex] = starttime - 1 ;
	  count[tindex] = tstop - tstart ;
	} /* if tindex is valid => we have a time dim. */
	newtime = gaopsdf(starttime, gridptr, &data_var) ;
	if (newtime == -99999) {
	  gaprnt(0, "Bad time index in SDF file.\n") ;
	  return(1) ; /* bad time index */
	}
	if (newtime == -88888) /* bad file */ {
	  for (grinx = 0 ;  grinx < gridcnt ;  ++grinx) {
	    fgrid[grinx] = gridptr->undef ;
	  }
	  return(0) ;
	}  /* if bad file */
	if (tindex != -1) {
	  start[tindex] = newtime - 1 ;
	}
	if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid,
				data_var, start, count)) {
	  gaprnt(0, "Failure reading SDF data.  #2\n") ;
	  return(3) ;
	}
      } /* still do all in one read, but after gaopsdf */
    } /* templating, not all in this file */
    for (timeindex = starttime, gtinx = gtstart, tinx = tstart ;
	 (gtinx < gtstop) && (tinx < tstop) ;
	 gtinx += gtincr, tinx += tincr, timeindex += tincr) {
      newtime = timeindex ;
      if (gridptr->pfile->tmplat) {
	if ((!alltimesinthisfile) && (!alltimesin1file)) {
	  newtime = gaopsdf(timeindex, gridptr, &data_var) ;
	  if (newtime == -99999) {
	    gaprnt(0, "Bad time index in SDF file.\n") ;
	    return(1) ; /* bad time index */
	  }
	  if (newtime == -88888) /* bad file */ {
	    for (grinx = 0 ;  grinx < gridcnt ;  ++grinx) {
	      fgrid[grinx] = gridptr->undef ;
	    }
	    return(0) ;
	  }  /* if bad file */
	} /* if not alltimesinthisfile */
	if (tindex != -1) {
	  start[tindex] = newtime - 1 ;
	}
      } /* if templating in use */
#ifdef TESTING
      fprintf(stderr,
	      "read_variable_data(%d, %s, [%d, %d, %d, %d], [%d, %d, %d, %d])\n",
	      gridptr->pfile->sdf_ptr->cdfid, data_var->varnam, start[0], start[1],
	      start[2], start[3], count[0], count[1], count[2], count[3]) ;
#endif
      /* experiment to increase performance when not templating Hoop 2K/11/22 */
      if (gridptr->pfile->tmplat && (!alltimesinthisfile) &&
	  (!alltimesin1file)) {
	/* no need to read per timestep if not templating (or all times in one file); */
	/* all read above */
	if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid, data_var,
				start, count)) {
	  gaprnt(0, "Failure reading SDF data.  #3\n") ;
	  return(3) ;
	}
      } /* end if templating and not all in one file */
      if (!ispacked) /* just copy */ {
	if (pktype == NC_DOUBLE) {
	  ddata = (double *) data_var->data ;
	} else {
	  fdata = (float *) data_var->data ;
	}
      } else /* must unpack */ {
	sdata = (short *) data_var->data ;
      } /* if unpacking needed */
      for (gzinx = gzstart, zinx = zstart ;
	   (gzinx < gzstop) && ((zincr > 0)?(zinx < zstop):(zinx > zstop)) ;
	   gzinx += gzincr, zinx += zincr) {
	for (gyinx = gystart, yinx = ystart ;
	     (gyinx < gystop) && ((yincr > 0)?(yinx < ystop):(yinx > ystop)) ;
	     gyinx += gyincr, yinx += yincr) {
	  for (gxinx = gxstart, xinx = xstart ;
	       (gxinx < gxstop) && (xinx < xstop) ;
	       gxinx += gxincr, xinx += xincr) {
	    grinx = (gtinx * zyxsize) + (gzinx * yxsize) +
	      (gyinx * count[xindex]) + gxinx ;
	    xcnt = xinx - xstart ;
	    if (gridptr->pfile->yrflg) {
	      ycnt = yinx - ystop - 1 ;
	    } else {
	      ycnt = yinx - ystart ;
	    }
	    if (is4d) {
	      if (gridptr->pfile->zrflg) {
		zcnt = zinx - zstop - 1 ;
	      } else {
		zcnt = zinx - zstart ;
	      }
	    } else {
	      zcnt = 1 ;
	    }
	    tcnt = tinx - tstart ;
	    if (is4d) {
	      inx = (zcnt * yxsize) + (ycnt * count[xindex]) + xcnt ;
	    } else {
	      inx = (ycnt * count[xindex]) + xcnt ;
	    }
	    /* experiment to increase performance when not templating Hoop 2K/11/22 */
	    if ((!(gridptr->pfile->tmplat)) || alltimesinthisfile
		|| alltimesin1file) {
	      inx += (tinx * zyxsize) ;
	    }
	    if (ispacked) {
	      /* handle missing */
	      wasmiss = 0 ;
	      if (sdata[inx] == smiss) {
		wasmiss = 1 ;
	      } else if ((!usingFV)&&(!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
		/* check FV too */
		if (sdata[inx] == sFillValue) {
		  wasmiss = 1 ;
		}
	      }
	      if (!wasmiss) {
		fgrid[grinx] = (mysf * ((float) sdata[inx]))
		  + myao ;
	      } else {
		fgrid[grinx] = gridptr->undef ;
	      }
	    } else {
	      /* May want to swap missing values */
	      /* Do want to.  -Hoop, 2K/07/25 */
	      if (pktype == NC_DOUBLE) {
		wasmiss = 0 ;
		if (dequal(ddata[inx], dmiss, (double)1.0e-5)) {
		  wasmiss = 1 ;
		}
		if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
		  if (dequal(ddata[inx], dFillValue, (double)1.0e-5)) {
		    wasmiss = 1 ;
		  }
		}
		if (!wasmiss) {
		  fgrid[grinx] = (float) ddata[inx] ;
		} else {
		  fgrid[grinx] = gridptr->undef ;
		}
	      } else {
		wasmiss = 0 ;
		if (fequal(fdata[inx], fmiss, 1.0e-5)) {
		  wasmiss = 1 ;
		}
		if ((!usingFV)&&(!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
		  if (fequal(fdata[inx], fFillValue, 1.0e-5)) {
		    wasmiss = 1 ;
		  }
		}
		if (!wasmiss) {
		  fgrid[grinx] = fdata[inx] ;
		} else {
		  fgrid[grinx] = gridptr->undef ;
		}
	      }
	    } /* end if packed */
	  } /* end for x indexing */
	} /* end for y indexing */
      } /* end for z indexing */
    } /* end for time indexing */
    return(0) ;
  } /* end if not wrapped data */
}

/* below changed 1998/04/20 to buffer in all longitudes of a grid and pick */
/* through the buffering to achieve wrapping effect  -Hoop */
int
sdfwrap(VAR_INFO **data_var_ptr, struct attrib_list *missvalattr, int ispacked,
        int is4d, float ao, float sf, int tdimindx, int tindex,
	int zdimindx, int zindex, int ydimindx, int yindex, int xdimindx,
	int xindex, struct gagrid *gridptr, float *fgrid, nc_type pktype,
	nc_type unpktype, int sdfxcount, int usingFV) {
  long start[4] = {0, 0, 0, 0}, count[4] = {1, 1, 1, 1}, gridcnt, yxsize ;
  long zyxsize, xsize ;
  float *fdata, fmiss, *ftemp, fFillValue ;
  short *sdata, smiss, *stemp, sFillValue ;
  double *ddata, dmiss, *dtemp, dFillValue ;
  struct attrib_list *FVattr ;
  VAR_INFO *data_var = *data_var_ptr ;
  int gridinx, xstart, ystart, zstart, tstart, xstop, ystop, zstop, tstop ;
  int xincr, yincr, zincr, tincr, xinx, yinx, zinx, tinx, gxinx, gyinx ;
  int gzinx, gtinx, ztsize, yztsize, gxstart, gxstop, gxincr, gystart ;
  int gystop, gyincr, gzstart, gzstop, gzincr, mininx, maxinx, xact ;
  int xreqmin, xreqmax, xreq, xcount, xpos, gtstart, gtstop, gtincr ;
  int inx, grinx, starttime, newtime, tcount, timeindex, gyxsize, gzyxsize ;
  int tcnt, zcnt, ycnt, xcnt, wasmiss ;
  int fillwithmiss ; /* under orders from gaopsdf */
  int alltimesinthisfile, alltimesin1file ;
  int gaopsdf(int timeindex, struct gagrid *gridptr, VAR_INFO **data_var_ptr) ;
  struct attrib_list *find_att(struct attrib_list *first_att, char *attname) ;
  int fequal(float op1, float op2, float delta) ;
  int dequal(double op1, double op2, double delta) ;

  fillwithmiss = 0 ;
  xcount = gridptr->pfile->dnum[GXINDEX] ;
  xreqmin = gridptr->dimmin[GXINDEX] ;
  xreqmax = gridptr->dimmax[GXINDEX] ;
  if (gridptr->pfile->yrflg) {
    maxinx = gridptr->pfile->sdf_ptr->dimsiz[ydimindx]
      - gridptr->dimmin[GYINDEX] ;
    mininx = gridptr->pfile->sdf_ptr->dimsiz[ydimindx]
      - gridptr->dimmax[GYINDEX] ;
    start[yindex] = mininx ;
  } else {
    start[yindex] = gridptr->dimmin[GYINDEX] - 1 ;
  }
  count[yindex] = gridptr->dimmax[GYINDEX] - gridptr->dimmin[GYINDEX] + 1 ;
  if (count[yindex] > gridptr->pfile->sdf_ptr->dimsiz[ydimindx]) {
    count[yindex] = gridptr->pfile->sdf_ptr->dimsiz[ydimindx] ;
  }
  start[xindex] = 0 ;
  count[xindex] = sdfxcount ;
  xsize = gridptr->dimmax[GXINDEX] - gridptr->dimmin[GXINDEX] + 1 ;
  gystart = 0 ;
  gystop = count[yindex] ;
  gyincr = 1 ;
  if (gridptr->pfile->yrflg) {
    ystart = gystop - 1 ;
    ystop = gystart - 1 ;
    yincr = -1 ;
  } else {
    ystart = gystart ;
    ystop = gystop ;
    yincr = 1 ;
  }
  gridcnt = count[xindex] * count[yindex] ;
  if (is4d) {
    if (gridptr->pfile->zrflg) {
      /* Should determine z dim index empirically */
      maxinx = gridptr->pfile->sdf_ptr->dimsiz[zdimindx]
	- gridptr->dimmin[GZINDEX] ;
      mininx = gridptr->pfile->sdf_ptr->dimsiz[zdimindx]
	- gridptr->dimmax[GZINDEX] ;
      start[zindex] = mininx ;
    } else {
      start[zindex] = gridptr->dimmin[GZINDEX] - 1 ;
    }
    count[zindex] = gridptr->dimmax[GZINDEX] - gridptr->dimmin[GZINDEX] + 1 ;
    if (count[zindex] > gridptr->pfile->sdf_ptr->dimsiz[zdimindx]) {
      count[zindex] = gridptr->pfile->sdf_ptr->dimsiz[zdimindx] ;
    }
    gridcnt *= count[zindex] ;
    gzstart = 0 ;
    gzstop = count[zindex] ;
    gzincr = 1 ;
    if (gridptr->pfile->zrflg) {
      zstart = gzstop - 1 ;
      zstop = gzstart - 1 ;
      zincr = -1 ;
    } else {
      zstart = gzstart ;
      zstop = gzstop ;
      zincr = 1 ;
    }
  } else {
    gzstart = zstart = 0 ;
    gzstop = zstop = 1 ;
    gzincr = zincr = 1 ;
  }
  starttime = gridptr->dimmin[GTINDEX] ;
  tcount = gridptr->dimmax[GTINDEX] - starttime + 1 ;
  if (tindex != -1) {
    count[tindex] = 1 ; /* read each time step separately for templating */
  }
  gtstart = tstart = 0 ;
  gtstop = tstop = tcount ;
  gtincr = tincr = 1 ;
  yxsize = count[yindex] * count[xindex] ;
  gyxsize = count[yindex] * xsize ; /*output array has full xdim */
  zyxsize = (gzstop - gzstart) * yxsize ;
  gzyxsize = (gzstop - gzstart) * gyxsize ;
  gridcnt *= tcount ; /*???*/
  if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
    /* need to check for _FillValue as well as missing_value */
    FVattr = find_att((*data_var_ptr)->first_vattr, "_FillValue") ;
  }
  if (!ispacked) {
    if (pktype == NC_FLOAT) {
      if (missvalattr) {
	fdata = (float *) missvalattr->data ;
	fmiss = *fdata ;
      } else {
	fmiss = FILL_FLOAT ;
      }
      if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
	if (FVattr) {
	  fdata = (float *) FVattr->data ;
	  fFillValue = *fdata ;
	} else {
	  fFillValue = FILL_FLOAT ;
	}
      } /* !usingFV */
    } else if (pktype == NC_DOUBLE) {
      if (missvalattr) {
	ddata = (double *) missvalattr->data ;
	dmiss = *ddata ;
      } else {
	dmiss = FILL_DOUBLE ;
      }
      if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
	if (FVattr) {
	  ddata = (double *) FVattr->data ;
	  dFillValue = *ddata ;
	} else {
	  dFillValue = FILL_DOUBLE ;
	}
      } /* !usingFV */
      /* else not yet a supported unpacked type */
    }
  } else {
    if ((!missvalattr) && (pktype != unpktype)) {
      smiss = (int) (((gridptr->undef - ao) / sf) + 0.5) ;
    } else {
      if ((!missvalattr) && (pktype == unpktype)) {
	smiss = FILL_SHORT ;
      } else {
	sdata = (short *) missvalattr->data ;
	smiss = *sdata ;
      }
    }
    if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))) {
      if (FVattr) {
	sdata = (short *) FVattr->data ;
	sFillValue = *sdata ;
      } else {
	sFillValue = FILL_SHORT ;
      }
    } /* !usingFV */
  } /* ispacked */
  alltimesinthisfile = 0 ;
  alltimesin1file = 0 ;
  if (gridptr->pfile->tmplat) {
    if ((*(gridptr->pfile->fnums + starttime - 1)) == gridptr->pfile->fnumc) {
      /* this time slice starts in the current file, so let's see if */
      /* it ends in the same file */
      if ((*(gridptr->pfile->fnums + starttime - 1 + tstop - tstart - 1)) ==
	  gridptr->pfile->fnumc) /* ends in same file */ {
	alltimesinthisfile = 1 ;
	alltimesin1file = 1 ;
      }
    } else /* first time not in current file */ {
      if ((*(gridptr->pfile->fnums + starttime - 1)) ==
	  (*(gridptr->pfile->fnums + starttime - 1 + tstop - tstart - 1))) {
	alltimesin1file = 1 ;
      }
    } /* is first time in current file */
  } /* if templating */
  if ((!(gridptr->pfile->tmplat)) || alltimesinthisfile) {
    if (tindex != -1) {
      start[tindex] = starttime - 1 ;
      count[tindex] = tstop - tstart ;
    } /* if tindex is valid => we have a time dim. */
    if (gridptr->pfile->tmplat) {
      if ((gridptr->pfile->fnums[0]) != (gridptr->pfile->fnumc)) {
	/* if we are not on the first file, we still need to call gaopsdf to */
	/* adulterate the starttime to be one relative to the current file */
	/* -Hoop, 2001/04/14 */
	newtime = gaopsdf(starttime, gridptr, data_var_ptr) ;
	if (newtime == -99999) /* bad surprise */ {
	  gaprnt(0, "Bad time index in SDF file.\n") ;
	  return(1) ; /* bad time index */
	} /* bad surprise */
	if (newtime == -88888) /* bad file, bad surprise */ {
	  for (grinx = 0 ;  grinx < gridcnt ;  ++grinx) {
	    fgrid[grinx] = gridptr->undef ;
	  }
	  return(0) ;
	} /* bad file, bad surprise */
	if (tindex != -1) {
	  start[tindex] = newtime - 1 ;
	}
      } /* if not 1st file, thus need new starttime */
    } /* if templating */
    if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid,
			    (*data_var_ptr), start, count)) {
      gaprnt(0, "Failure reading SDF data.  #4\n") ;
      return(3) ;
    }
  } /* end if not templating or allin1, read all times at once */ else {
    if (alltimesin1file) {
      if (tindex != -1) {
	start[tindex] = starttime - 1 ;
	count[tindex] = tstop - tstart ;
      } /* if tindex is valid => we have a time dim. */
      newtime = gaopsdf(starttime, gridptr, data_var_ptr) ;
      if (newtime == -99999) {
	gaprnt(0, "Bad time index in SDF file.\n") ;
	return(1) ; /* bad time index */
      }
      if (newtime == -88888) /* bad file */ {
	for (grinx = 0 ;  grinx < gridcnt ;  ++grinx) {
	  fgrid[grinx] = gridptr->undef ;
	}
	return(0) ;
      }  /* if bad file */
      data_var = *data_var_ptr ;
      if (tindex != -1) {
	start[tindex] = newtime - 1 ;
      }
      if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid,
			      (*data_var_ptr), start, count)) {
	gaprnt(0, "Failure reading SDF data.  #5\n") ;
	return(3) ;
      }
    } /* still do all in one read, but after gaopsdf */
  } /* templating, not all in this file */
  for (timeindex = starttime, gtinx = gtstart, tinx = tstart ;
       (gtinx < gtstop) && (tinx < tstop) ;
       gtinx += gtincr, tinx += tincr, timeindex += tincr) {
    newtime = timeindex ;
    if (gridptr->pfile->tmplat) {
      if ((!alltimesinthisfile) && (!alltimesin1file)) {
	newtime = gaopsdf(timeindex, gridptr, data_var_ptr) ;
	if (newtime == -99999) {
	  gaprnt(0, "Bad time index in SDF file.\n") ;
	  return(1) ;  /* bad time index */
	}
	if (newtime == -88888) /* bad file */ {
	  fillwithmiss = 1 ;
	} /* if bad file */
	data_var = *data_var_ptr ;
      }
    } /* if templating in use */
    if (!fillwithmiss) {
      if (tindex != -1) {
	start[tindex] = newtime - 1 ;
      }
    }
#ifdef TESTING
    fprintf(stderr,
	    "read_variable_data(%d, %s, [%ld, %ld, %ld, %ld], [%ld, %ld, %ld, %ld])\n",
	    gridptr->pfile->sdf_ptr->cdfid, (*data_var_ptr)->varnam, start[0], start[1],
	    start[2], start[3], count[0], count[1], count[2], count[3]) ;
#endif
    if (!fillwithmiss) {
      /* experiment to increase performance when not templating Hoop 2K/11/22 */
      if (gridptr->pfile->tmplat && (!alltimesinthisfile) &&
	  (!alltimesin1file)) {
	/* no need to read per time step if not templating or all times in one file; */
	/* all read above */
	if (!read_variable_data(gridptr->pfile->sdf_ptr->cdfid,
	                        (*data_var_ptr), start, count)) {
	  gaprnt(0, "Failure reading SDF data.  #6\n") ;
	  return(3) ;
	}
      } /* end if templating and not all in one file */
      if (!ispacked) {
	if (pktype == NC_DOUBLE) {
	  ddata = (double *) (*data_var_ptr)->data ;
	} else {
	  fdata = (float *) (*data_var_ptr)->data ;
	}
      } else /* must unpack */ {
	sdata = (short *) (*data_var_ptr)->data ;
      } /* is it packed? */
    } /* only do above if not fillwithmiss */
    for (gzinx = gzstart, zinx = zstart ;
	 (gzinx < gzstop) && ((zincr > 0)?(zinx < zstop):(zinx > zstop)) ;
	 gzinx += gzincr, zinx += zincr) {
      for (gyinx = gystart, yinx = ystart ;
	   (gyinx < gystop) && ((yincr > 0)?(yinx < ystop):(yinx > ystop)) ;
	   gyinx += gyincr, yinx += yincr) {
	for (xreq = xreqmin, xpos = 0 ;  xreq <= xreqmax ;  ++xreq, ++xpos) {
	  xact = xreq ;
	  while (xact < 1) { xact += xcount ; }
	  while (xact > xcount) { xact -= xcount ; }
	  grinx = (gtinx * gzyxsize) + (gzinx * gyxsize) +
	    (gyinx * xsize) + xpos ;
	  if (gridptr->pfile->yrflg) {
	    ycnt = yinx - ystop - 1 ;
	  } else {
	    ycnt = yinx - ystart ;
	  }
	  if (is4d) {
	    if (gridptr->pfile->zrflg) {
	      zcnt = zinx - zstop - 1 ;
	    } else {
	      zcnt = zinx - zstart ;
	    }
	  } else {
	    zcnt = 1 ;
	  }
	  tcnt = tinx - tstart ;
	  if (is4d) {
	    inx = (zcnt * yxsize) + (ycnt * sdfxcount) + xact - 1 ;
	  } else {
	    inx = (ycnt * sdfxcount) + xact - 1 ;
	  }
	  /* experiment to increase performance when not templating Hoop 2K/11/22 */
	  if ((!(gridptr->pfile->tmplat)) || alltimesinthisfile
	      || alltimesin1file) {
	    inx += (tinx * zyxsize) ;
	  }
#ifdef TESTING2
	  fprintf(stderr, "grinx=%d, inx=%d.\n", grinx, inx) ;
#endif
	  if (fillwithmiss) {
	    fgrid[grinx] = gridptr->undef ;
	  } else {
	    if (ispacked) {
	      /* handle missing */
	      wasmiss = 0 ;
	      if (sdata[inx] == smiss) {
		wasmiss = 1 ;
	      } else if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))){
		if (sdata[inx] == sFillValue) {
		  wasmiss = 1 ;
		}
	      }
	      if (!wasmiss) {
		fgrid[grinx] = (sf * ((float) sdata[inx])) + ao ;
	      } else {
		fgrid[grinx] = gridptr->undef ;
	      }
	    } else {
	      /* may wish to swap missing values */
	      /* Do want to.  -Hoop, 2K/07/25 */
	      if (pktype == NC_DOUBLE) {
		wasmiss = 0 ;
		if (dequal(ddata[inx], dmiss, (double)1.0e-5)) {
		  wasmiss = 1 ;
		} else if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))){
		  if (dequal(ddata[inx], dFillValue, (double)1.0e-5)) {
		    wasmiss = 1 ;
		  }
		}
		if (!wasmiss) {
		  fgrid[grinx] = (float) ddata[inx] ;
		} else {
		  fgrid[grinx] = gridptr->undef ;
		}
	      } else if (pktype == NC_FLOAT) {
		wasmiss = 0 ;
		if (fequal(fdata[inx], fmiss, 1.0e-5)) {
		  wasmiss = 1 ;
		} else if ((!usingFV) && (!(gridptr->pfile->sdf_ptr->hasDDFundef))){
		  if(fequal(fdata[inx], fFillValue, 1.0e-5)) {
		    wasmiss = 1 ;
		  }
		}
		if (!wasmiss) {
		  fgrid[grinx] = fdata[inx] ;
		} else {
		  fgrid[grinx] = gridptr->undef ;
		}
		/* else using unsupported (not)packed type */
	      }
	    } /* end if packed */
	  } /* end if fillwithmiss */
	} /* for x if wrapped */
      } /* end for y indexing */
    } /* end for z indexing */
  } /* end for time indexing */
  return(0) ;
}

int
convtype(void *srcptr, nc_type srctype, void *desptr, nc_type destype,
         int srcindex, int desindex) {
  short *ssrcptr, *sdesptr ;
  long *lsrcptr, *ldesptr ;
  float *fsrcptr, *fdesptr ;
  double *dsrcptr, *ddesptr ;
    
  switch (srctype) {
  case NC_SHORT:
    ssrcptr = (short *) srcptr ;
    switch (destype) {
    case NC_SHORT:  /* stupid, but... */
      sdesptr = (short *) desptr ;
      sdesptr[desindex] = (short) (ssrcptr[srcindex]) ;
      break ;
    case NC_LONG:
      ldesptr = (long *) desptr ;
      ldesptr[desindex] = (long) (ssrcptr[srcindex]) ;
      break ;
    case NC_FLOAT:
      fdesptr = (float *) desptr ;
      fdesptr[desindex] = (float) (ssrcptr[srcindex]) ;
      break ;
    case NC_DOUBLE:
      ddesptr = (double *) desptr ;
      ddesptr[desindex] = (double) (ssrcptr[srcindex]) ;
      break ;
    default:
      return(0) ;  /* inappropriate type for conversion */
      break ;
    } /* end destype switch */
    break ;
  case NC_LONG:
    lsrcptr = (long *) srcptr ;
    switch (destype) {
    case NC_SHORT:
      sdesptr = (short *) desptr ;
      sdesptr[desindex] = (short) (lsrcptr[srcindex]) ;
      break ;
    case NC_LONG:  /* stupid, but... */
      ldesptr = (long *) desptr ;
      ldesptr[desindex] = (long) (lsrcptr[srcindex]) ;
      break ;
    case NC_FLOAT:
      fdesptr = (float *) desptr ;
      fdesptr[desindex] = (float) (lsrcptr[srcindex]) ;
      break ;
    case NC_DOUBLE:
      ddesptr = (double *) desptr ;
      ddesptr[desindex] = (double) (lsrcptr[srcindex]) ;
      break ;
    default:
      return(0) ; /* inappropriate type for conversion */
      break ;
    } /* end destype switch */
    break ;
  case NC_FLOAT:
    fsrcptr = (float *) srcptr ;
    switch (destype) {
    case NC_SHORT:
      sdesptr = (short *) desptr ;
      sdesptr[desindex] = (short) (fsrcptr[srcindex]) ;
      break ;
    case NC_LONG:
      ldesptr = (long *) desptr ;
      ldesptr[desindex] = (long) (fsrcptr[srcindex]) ;
      break ;
    case NC_FLOAT:  /* stupid, but... */
      fdesptr = (float *) desptr ;
      fdesptr[desindex] = (float) (fsrcptr[srcindex]) ;
      break ;
    case NC_DOUBLE:
      ddesptr = (double *) desptr ;
      ddesptr[desindex] = (double) (fsrcptr[srcindex]) ;
      break ;
    default:
      return(0) ; /* inappropriate type for conversion */
      break ;
    } /* end destype switch */
    break ;
  case NC_DOUBLE:
    dsrcptr = (double *) srcptr ;
    switch (destype) {
    case NC_SHORT:
      sdesptr = (short *) desptr ;
      sdesptr[desindex] = (short) (dsrcptr[srcindex]) ;
      break ;
    case NC_LONG:
      ldesptr = (long *) desptr ;
      ldesptr[desindex] = (long) (dsrcptr[srcindex]) ;
      break ;
    case NC_FLOAT:
      fdesptr = (float *) desptr ;
      fdesptr[desindex] = (float) (dsrcptr[srcindex]) ;
      break ;
    case NC_DOUBLE:  /* stupid, but... */
      ddesptr = (double *) desptr ;
      ddesptr[desindex] = (double) (dsrcptr[srcindex]) ;
      break ;
    default:
      return(0) ; /* inappropriate type for conversion */
      break ;
    } /* end destype switch */
    break ;
  default:
    return(0) ; /* inappropriate type for conversion */
    break ;
  } /* end srctype switch */
  return(1) ; /* conversion successful */
  /* NOTREACHED */
}

#include "gasdf_std_time.h"
/* Old RCS ID: ReadNetCDF.c,v 1.1 1995/05/02 20:23:12 jac Exp jac $ */
/* Revision 1.1  1995/05/02  20:23:12  jac (Julia Collins) */
/* Initial revision */

/* open and read a netcdf file */
/* print variable and dimension information to standard output */

#define True		1
#define False		0

int
print_dim_info (std_ptr, dim, all)
     IO_STD *std_ptr;
     int dim;
     int all;		/* whether to print all values. If False, */
			/* only the first and last values are shown */
{
  VAR_INFO *var = NULL;
  union att_val dim_val;
  int i;
  int is_time = False;
  char tstring[128];
  utUnit unit;

  int  decode_time ();
  void set_data_to_type ();
  void adjust_data_type ();
  VAR_INFO *find_var ();

  /* print dim info if it exists */
  if (dim >= 0)
    {
      if ((var = find_var (std_ptr, std_ptr->dimnam[dim])) == NULL)
	return Failure;
      if (read_one_dimension (std_ptr, var, dim) != Success)
	return Failure;

      /* print the dimension name */
      printf ("%s\n", var->varnam);

      if (!strcmp (var->varnam, dims[TIME_IX]))
	{
	  is_time = True;
	  if (std_ptr->time_type == COOP) 
	    get_ud_time_unit (var, &unit);
	}

      /* print the data values */
      if (all)
	{
	  for (i = 0; i < std_ptr->dimsiz[dim]; i++)
	    {
	      set_data_to_type (var->vartype, i, var->data, &dim_val);
	      if (is_time)
		{
		  decode_time (dim_val.dval, std_ptr->time_type, var, tstring, &unit);
		  printf ("%s\n", tstring);
		}
	      else
		{
		  adjust_data_type (var->vartype, NC_FLOAT, &dim_val);
		  printf ("%.2f\n", dim_val.fval);
		}
	    }
	}
      else
	{
	  /* print first value */
	  set_data_to_type (var->vartype, 0, var->data, &dim_val);
	  if (is_time)
	    {
	      decode_time (dim_val.dval, std_ptr->time_type, var, tstring, &unit);
	      printf ("%s\n", tstring);
	    }
	  else
	    {
	      adjust_data_type (var->vartype, NC_FLOAT, &dim_val);
	      printf ("%.2f\n", dim_val.fval);
	    }

	  /* print last value */
	  set_data_to_type (var->vartype, std_ptr->dimsiz[dim] - 1, 
			    var->data, &dim_val);
	  if (is_time)
	    {
	      decode_time (dim_val.dval, std_ptr->time_type, var, tstring, &unit);
	      printf ("%s\n", tstring);
	    }
	  else
	    {
	      adjust_data_type (var->vartype, NC_FLOAT, &dim_val);
	      printf ("%.2f\n", dim_val.fval);
	    }
	}
      printf ("END\n");
    }

  return Success;
}

int
decode_time (tval, time_type, var, tstring, unit)
     double 	  tval;		/* value to decode */
     int 	  time_type;	/* whether time is formatted according to "old" CDC */
     /* standards or according to udunits		    */
     VAR_INFO *var;
     char 	 *tstring;
     utUnit   *unit;
{
  int yr, mo, da, hr, min;
  double sec;
  struct attrib_list *delta;
  int pix;
  char delta_t_str[128];

  struct attrib_list *find_att ();
  int decode_ud_time() ;
  int decode_standard_time() ;
  void        set_default_time_components ();

  /* get delta_t */
  delta = find_att (var->first_vattr, time_atts[DELTA_T_IX]);
  ((char *) delta->data)[delta->len] = '\0';

  /* get delta_t values */
  if (decode_delta_t ((char *) delta->data, &yr, &mo, &da, &hr,
		      &min, &sec) != Success)
    pix = -1;
  else if (get_period (yr, mo, da, hr, &pix) != Success)
    pix = -1;

  if (time_type == CDC)
    {
      if (decode_standard_time (tval, &yr, &mo, &da, 
				&hr, &min, &sec) != Success)
	return Failure;
    }
  else
    {
      if (decode_ud_time (unit, tval, &yr, &mo, &da, &hr, &min, &sec) != Success)
	return Failure;
    }

  /* now format the string */
  set_default_time_components (pix, &yr, &mo, &da, &hr, &min, &sec);
  encode_time (yr, mo, da, hr, min, (int) sec, tstring);

  return Success;
}

int
get_period (year, month, day, hour, pix)
     int         year;
     int         month;
     int         day;
     int         hour;
     int        *pix;
{
  if ((year != MISSING) && (year > 0))
    *pix = PYEARS;
  else if ((month != MISSING) && (month > 0))
    {
      /* this can be months or seasons */
      if (month % MONTHS_PER_SEASON)
	/* month is multiple of size of season, so assume seasonal file */
	*pix = PMONTHS;
      else
	*pix = PSEASONS;
    }
  else if ((day != MISSING) && (day > 0))
    {
      /* This can be days or pentads */
      if (day % DAYS_PER_PENTAD)
	*pix = PDAYS;
      else
	*pix = PPENTADS;
    }
  else if ((hour != MISSING) && (hour > 0))
    *pix = PHOURS;
  else
    {
      *pix = MISSING;
      return Failure;
    }

  return Success;
}

/* set any missing components to a default beginning value */
void
set_default_time_components (pix, yr, mo, day, hour, min, sec)
     int         pix;
     int        *yr;
     int        *mo;
     int        *day;
     int        *hour;
     int        *min;
     double     *sec;
{
  if (pix < 0)
    return;

  switch (pix)
    {
    case PMONTHS:
    case PSEASONS:
      if (*mo < 0)
	*mo = 1;
      *day = MISSING;
      *hour = MISSING;
      *min = MISSING;
      *sec = (double) MISSING;
      break;

    case PDAYS:
    case PPENTADS:
      if (*day < 0)
	*day = 1;
      *hour = MISSING;
      *min = MISSING;
      *sec = (double) MISSING;
      break;

    case PHOURS:
      if (*hour < 0)
	*hour = 0;
      *min = MISSING;
      *sec = (double) MISSING;
      break;

    default:
      break;
    }
  return;
}

int
encode_time (yr, mo, da, hr, min, sec, tstring)
     int 	yr;
     int 	mo;
     int 	da;
     int 	hr;
     int 	min;
     int 	sec;
     char   *tstring;
{
  static char *month[13] = {" ", "Jan", "Feb", "Mar", "Apr",
			    "May", "June", "July", "Aug",
			    "Sep", "Oct", "Nov", "Dec" };
  char tstr[32];

  strcpy (tstring, " ");
  if (mo != MISSING)
    {
      sprintf (tstring, "%s ", month[mo]);
    }
  if (da != MISSING)
    {
      sprintf (tstr, "%d ", da);
      strcat (tstring, tstr);
    }
  if (hr != MISSING)
    {
      sprintf (tstr, "%.2d", hr);
      strcat (tstring, tstr);
      if (min != MISSING)
	{
	  sprintf (tstr, ":%.2d", min);
	  strcat (tstring, tstr);
	  if (sec != MISSING)
	    {
	      sprintf (tstr, "%.2d ", sec);
	      strcat (tstring, tstr);
	    }
	}
    }
  if (yr != MISSING)
    {
      sprintf (tstr, "%d", yr);
      strcat (tstring, tstr);
    }
 
  return Success;
}

/* get the udunit structure for time */
get_ud_time_unit (time, unit)
     VAR_INFO   *time;		/* time variable information */
     utUnit 	   *unit;
{
  struct attrib_list *units_str;
  struct attrib_list *find_att ();

  /* get units string */
  if ((units_str = find_att (time->first_vattr, 
			     time_atts[T_UNITS_IX])) == NULL)
    return Failure;

  /* scan the units */
  if (utScan ((char *) units_str->data, unit))
    return Failure;

  return Success;
}

/* use the udunits library to decode a time value */
int
decode_ud_time (unit, time_val, yr, mo, da, hr, min, sec)
     utUnit     *unit;		/* time unit information */
     double      time_val;		/* input time value */
     int        *yr;			/* (returned) decoded year */
     int        *mo;			/* (returned) decoded month */
     int        *da;			/* (returned) decoded day */
     int        *hr;			/* (returned) decoded hour */
     int        *min;		/* (returned) decoded minute */
     double     *sec;		/* (returned) decoded second */
{

  /* convert the time to integer components */
  if (utCalendar (time_val, unit, yr, mo, da, hr, min, (float *) sec))
    return Failure;

  return Success;
}

/* Strip the given number of characters from the string and return the
   new length.  If the number of characters to strip is less than
   or equal to zero, or if the strip length is greater than the
   string length, return Failure.  Otherwise, return Success. */
int
strip_char (strip_num, str1, int_len)
     int         strip_num;		/* Number of characters to strip. */
     char       *str1;		/* (input and output) String */
     int        *int_len;		/* (input and output) String length */
{
  int         slen;

  slen = strlen (str1);
  if (strip_num <= 0)
    return Failure;
  slen -= strip_num;
  if (slen < 0)
    return Failure;
  *int_len = slen;
  str1[slen] = '\0';

  return Success;
}

/* Decode standard time.  Return Success if OK, Failure if error. */
int
decode_standard_time (time_val, year, month, day, hour, minn, sec)
     double      time_val;		/* Time value to be decoded. */
     int        *year;		/* (returned) year */
     int        *month;		/* (returned) month */
     int        *day;		/* (returned) day */
     int        *hour;		/* (returned) hour */
     int        *minn;		/* (returned) minute */
     double     *sec;		/* (returned) second */
{
  char        str1[20];
  int         i,
    slen,
    int_len;

  /* Make time value into character string. */
  sprintf (str1, "%f", time_val);

  /* Find decimal point. */
  slen = strlen (str1);
  for (i = 0; i < slen; i++)
    {
      if (str1[i] == '.')
	{
	  int_len = i;
	  break;
	}
    }
  if (int_len == 0)
    {
      return Failure;
    }

  /* Get second. */
  if (int_len <= 2)
    {
      sscanf (str1, "%lf", sec);
      int_len = 0;
    }
  else
    {
      sscanf (&str1[int_len - 2], "%lf", sec);
      str1[int_len] = '\0';
      (void) strip_char (2, str1, &int_len);
    }

  /* Get minute. */
  *minn = MISSING;
  if (int_len > 0)
    {
      if (int_len <= 2)
	{
	  sscanf (str1, "%d", minn);
	  int_len = 0;
	}
      else
	{
	  sscanf (&str1[int_len - 2], "%d", minn);
	  str1[int_len] = '\0';
	  (void) strip_char (2, str1, &int_len);
	}
    }

  /* Get hour. */
  *hour = MISSING;
  if (int_len > 0)
    {
      if (int_len <= 2)
	{
	  sscanf (str1, "%d", hour);
	  int_len = 0;
	}
      else
	{
	  sscanf (&str1[int_len - 2], "%d", hour);
	  str1[int_len] = '\0';
	  (void) strip_char (2, str1, &int_len);
	}
    }

  /* Get day. */
  *day = MISSING;
  if (int_len > 0)
    {
      if (int_len <= 2)
	{
	  sscanf (str1, "%d", day);
	  int_len = 0;
	}
      else
	{
	  sscanf (&str1[int_len - 2], "%d", day);
	  str1[int_len] = '\0';
	  (void) strip_char (2, str1, &int_len);
	}
    }

  /* Get month. */
  *month = MISSING;
  if (int_len > 0)
    {
      if (int_len <= 2)
	{
	  sscanf (str1, "%d", month);
	  int_len = 0;
	}
      else
	{
	  sscanf (&str1[int_len - 2], "%d", month);
	  str1[int_len] = '\0';
	  (void) strip_char (2, str1, &int_len);
	}
    }

  /* Get year.  A year of 0000 or 9999 defaults to missing. */
  *year = MISSING;
  if (int_len > 0)
    sscanf (str1, "%d", year);
  if ((*year == 0) || (*year == 9999))
    *year = MISSING;

  /* All OK. */
  return Success;
}


void
adjust_data_type (old_type, new_type, val)
     nc_type     old_type;		/* current data type */
     nc_type     new_type;		/* type to cast data TO */
     union att_val *val;		/* current values, updated and returned */

{
  union att_val save_val;

  switch (new_type)
    {
    case NC_BYTE:
      switch (old_type)
	{
	case NC_SHORT:
	  save_val.sval = val->sval;
	  if (val->sval == SMISS)
	    val->bval = BMISS;
	  else if (val->sval == SFILL)
	    val->bval = BFILL;
	  else
	    val->bval = (char) save_val.sval;
	  break;
	case NC_LONG:
	  save_val.lval = val->lval;
	  if (val->lval == LMISS)
	    val->bval = BMISS;
	  else if (val->lval == LFILL)
	    val->bval = BFILL;
	  else
	    val->bval = (char) save_val.lval;
	  break;
	case NC_FLOAT:
	  save_val.fval = val->fval;
	  if (dbl_equal (val->fval, FMISS))
	    val->bval = BMISS;
	  else if (dbl_equal (val->fval, FFILL))
	    val->bval = BFILL;
	  else
	    val->bval = (char) save_val.fval;
	  break;
	case NC_DOUBLE:
	  save_val.dval = val->dval;
	  if (dbl_equal (val->dval, DMISS))
	    val->bval = BMISS;
	  else if (dbl_equal (val->dval, DFILL))
	    val->bval = BFILL;
	  else
	    val->bval = (char) save_val.dval;
	  break;
	default:
	  break;
	}
      break;
    case NC_SHORT:
      switch (old_type)
	{
	case NC_BYTE:
	  save_val.bval = val->bval;
	  if (val->bval == BMISS)
	    val->sval = SMISS;
	  else if (val->bval == BFILL)
	    val->sval = SFILL;
	  else
	    val->sval = (short) save_val.bval;
	  break;
	case NC_LONG:
	  save_val.lval = val->lval;
	  if (val->lval == LMISS)
	    val->sval = SMISS;
	  else if (val->lval == LFILL)
	    val->sval = SFILL;
	  else
	    val->sval = (short) save_val.lval;
	  break;
	case NC_FLOAT:
	  save_val.fval = val->fval;
	  if (dbl_equal (val->fval, FMISS))
	    val->sval = SMISS;
	  else if (dbl_equal (val->fval, FFILL))
	    val->sval = SFILL;
	  else
	    val->sval = (short) save_val.fval;
	  break;
	case NC_DOUBLE:
	  save_val.dval = val->dval;
	  if (dbl_equal (val->dval, DMISS))
	    val->sval = SMISS;
	  else if (dbl_equal (val->dval, DFILL))
	    val->sval = SFILL;
	  else
	    val->sval = (short) save_val.dval;
	  break;
	default:
	  break;
	}
      break;
    case NC_LONG:
      switch (old_type)
	{
	case NC_SHORT:
	  save_val.sval = val->sval;
	  if (val->sval == SMISS)
	    val->lval = LMISS;
	  else if (val->sval == SFILL)
	    val->lval = LFILL;
	  else
	    val->lval = (long) save_val.sval;
	  break;
	case NC_BYTE:
	  save_val.bval = val->bval;
	  if (val->bval == BMISS)
	    val->lval = LMISS;
	  else if (val->bval == BFILL)
	    val->lval = LFILL;
	  else
	    val->lval = (long) save_val.bval;
	  break;
	case NC_FLOAT:
	  save_val.fval = val->fval;
	  if (dbl_equal (val->fval, FMISS))
	    val->lval = LMISS;
	  else if (dbl_equal (val->fval, FFILL))
	    val->lval = LFILL;
	  else
	    val->lval = (long) save_val.fval;
	  break;
	case NC_DOUBLE:
	  save_val.dval = val->dval;
	  if (dbl_equal (val->dval, DMISS))
	    val->lval = LMISS;
	  else if (dbl_equal (val->dval, DFILL))
	    val->lval = LFILL;
	  else
	    val->lval = (long) save_val.dval;
	  break;
	default:
	  break;
	}
      break;
    case NC_FLOAT:
      switch (old_type)
	{
	case NC_SHORT:
	  save_val.sval = val->sval;
	  if (val->sval == SMISS)
	    val->fval = FMISS;
	  else if (val->sval == SFILL)
	    val->fval = FFILL;
	  else
	    val->fval = (float) save_val.sval;
	  break;
	case NC_LONG:
	  save_val.lval = val->lval;
	  if (val->lval == LMISS)
	    val->fval = FMISS;
	  else if (val->lval == LFILL)
	    val->fval = FFILL;
	  else
	    val->fval = (float) save_val.lval;
	  break;
	case NC_BYTE:
	  save_val.bval = val->bval;
	  if (val->bval == BMISS)
	    val->fval = FMISS;
	  else if (val->bval == BFILL)
	    val->fval = FFILL;
	  else
	    val->fval = (float) save_val.bval;
	  break;
	case NC_DOUBLE:
	  save_val.dval = val->dval;
	  if (dbl_equal (val->dval, DMISS))
	    val->fval = FMISS;
	  else if (dbl_equal (val->dval, DFILL))
	    val->fval = FFILL;
	  else
	    val->fval = (float) save_val.dval;
	  break;
	default:
	  break;
	}
      break;
    case NC_DOUBLE:
      switch (old_type)
	{
	case NC_SHORT:
	  save_val.sval = val->sval;
	  if (val->sval == SMISS)
	    val->dval = DMISS;
	  else if (val->sval == SFILL)
	    val->dval = DFILL;
	  else
	    val->dval = (double) save_val.sval;
	  break;
	case NC_LONG:
	  save_val.lval = val->lval;
	  if (val->lval == LMISS)
	    val->dval = DMISS;
	  else if (val->lval == LFILL)
	    val->dval = DFILL;
	  else
	    val->dval = (double) save_val.lval;
	  break;
	case NC_FLOAT:
	  save_val.fval = val->fval;
	  if (dbl_equal (val->fval, FMISS))
	    val->dval = DMISS;
	  else if (dbl_equal (val->fval, FFILL))
	    val->dval = DFILL;
	  else
	    val->dval = (double) save_val.fval;
	  break;
	case NC_BYTE:
	  save_val.bval = val->bval;
	  if (val->bval == BMISS)
	    val->dval = DMISS;
	  else if (val->bval == BFILL)
	    val->dval = DFILL;
	  else
	    val->dval = (double) save_val.bval;
	  break;
	default:
	  break;
	}
      break;
    default:
      break;
    }

  return;
}

/* cast void data to correct type */
void
set_data_to_type (type, ix, in_data, out_data)
     nc_type     type;		/* data type */
     int         ix;			/* if data is greater than one item long,
					 * index into data array 	 */
     void       *in_data;		/* data to be cast */
     union att_val *out_data;	/* output data (returned) */

{

  switch (type)
    {
    case NC_BYTE:
      out_data->bval = ((char *) in_data)[ix];
      break;
    case NC_SHORT:
      out_data->sval = ((short *) in_data)[ix];
      break;
    case NC_LONG:
      out_data->lval = ((long *) in_data)[ix];
      break;
    case NC_FLOAT:
      out_data->fval = ((float *) in_data)[ix];
      break;
    case NC_DOUBLE:
      out_data->dval = ((double *) in_data)[ix];
      break;
    default:
      break;
    }

  return;
}

/* initialize a netCDF standard file structure */
int
init_io_std (std_ptr)
     IO_STD    **std_ptr;		/* pointer to netCDF data structure */
{
  int         init_dim_info ();
  void        free_io_std ();

  if ((*std_ptr) != NULL)
    free_io_std (std_ptr);

  if (((*std_ptr) = (IO_STD *) malloc (sizeof (IO_STD))) == NULL) {
#if USEHDF == 1
    printf ("Could not allocate memory for netCDF/HDF-SDS structure.\n");
#else
    printf ("Could not allocate memory for netCDF structure.\n") ;
#endif
    return Failure;
  }

  /* initialize contents of structure */
  (*std_ptr)->cdfid = -1;
  (*std_ptr)->ndims = 0;
  (*std_ptr)->nvars = 0;
  (*std_ptr)->ngatts = 0;
  (*std_ptr)->recdim = -1;
  (*std_ptr)->time_type = CDC;
  (*std_ptr)->hasDDFundef = 0 ;

  (*std_ptr)->first_gattr = NULL;

  /* don't create variable list quite yet */
  (*std_ptr)->var = NULL;

  /* intialize dimension information */
  if (init_dim_info ((*std_ptr)->dimids, (*std_ptr)->dimnam,
		     (*std_ptr)->dimsiz) != Success)
    return Failure;

  return Success;
}

/* copy a netCDF standard file structure */
int
copy_io_std (IO_STD **std_ptr2, IO_STD *std_ptr1)
     /* pointers to netCDF data structure */
{
  int indx ;
  int         init_dim_info ();
  int         copy_attr_list() ;
  int         copy_var_list() ;
  void        free_io_std ();

  if ((*std_ptr2) != NULL)
    free_io_std (std_ptr2);

  if (((*std_ptr2) = (IO_STD *) malloc (sizeof (IO_STD))) == NULL) {
#if USEHDF == 1
    printf ("Could not allocate memory for netCDF/HDF-SDS structure.\n");
#else
    printf ("Could not allocate memory for netCDF structure.\n") ;
#endif
    return Failure;
  }

  /* initialize contents of structure */
  (*std_ptr2)->cdfid = std_ptr1->cdfid ;
  (*std_ptr2)->ndims = std_ptr1->ndims ;
  (*std_ptr2)->nvars = std_ptr1->nvars ;
  (*std_ptr2)->ngatts = std_ptr1->ngatts ;
  (*std_ptr2)->recdim = std_ptr1->recdim ;
  (*std_ptr2)->time_type = std_ptr1->time_type ;
  if (copy_attr_list(&((*std_ptr2)->first_gattr), std_ptr1->first_gattr) ==
      Failure) {
    return Failure ;
  }
  /* don't create variable list quite yet */
  (*std_ptr2)->var = NULL; /* copy the linked list.... */

  /* initialize dimension information */
  for (indx = 0 ;  indx < MAX_NC_DIMS ;  ++indx) {
    (*std_ptr2)->dimids[indx] = std_ptr1->dimids[indx] ; /* cp the list.... */
    strcpy((*std_ptr2)->dimnam[indx], std_ptr1->dimnam[indx]) ;
    (*std_ptr2)->dimsiz[indx] = std_ptr1->dimsiz[indx] ;
  } /* end for all dims */
  
  if (copy_var_list(&((*std_ptr2)->var), std_ptr1->var) == Failure) {
    return Failure ;
  }

  return Success;
}

int
copy_var_list(VAR_INFO **newvarlistptr, VAR_INFO *oldvarlist) {
  int indx ;
  char *charptr1, *charptr2 ;
  short *shortptr1, *shortptr2 ;
  long *longptr1, *longptr2 ;
  float *floatptr1, *floatptr2 ;
  double *dblptr1, *dblptr2 ;
  VAR_INFO **lclnewvarlistptr ;
  int copy_attr_list() ;

  if (oldvarlist == (VAR_INFO *) NULL) {
    return Failure ;
  }
  lclnewvarlistptr = newvarlistptr ;
  while (oldvarlist != (VAR_INFO *) NULL) {
    if (((*lclnewvarlistptr) = (VAR_INFO *)malloc(sizeof(VAR_INFO))) ==
	(VAR_INFO *) NULL) {
      return Failure ;
    }
    (*lclnewvarlistptr)->varid = oldvarlist->varid ;
    strcpy((*lclnewvarlistptr)->varnam, oldvarlist->varnam) ;
    strcpy((*lclnewvarlistptr)->gradsabbr, oldvarlist->gradsabbr) ;
    (*lclnewvarlistptr)->vartype = oldvarlist->vartype ;
    (*lclnewvarlistptr)->nvardims = oldvarlist->nvardims ;
    for (indx = 0 ;  indx < oldvarlist->nvardims ;  ++indx) {
      (*lclnewvarlistptr)->vardimid[indx] = oldvarlist->vardimid[indx] ;
    }
    for (indx = 0 ; indx < 4 ;  ++indx) {
      (*lclnewvarlistptr)->dimmap[indx] = oldvarlist->dimmap[indx] ;
      (*lclnewvarlistptr)->dimidmap[indx] = oldvarlist->dimidmap[indx] ;
    }
    (*lclnewvarlistptr)->nvatts = oldvarlist->nvatts ;
    if (oldvarlist->nvatts > 0) {
      if (copy_attr_list(&((*lclnewvarlistptr)->first_vattr),
			 oldvarlist->first_vattr) == Failure) {
	return Failure ;
      }
    } else {
      (*lclnewvarlistptr)->first_vattr = (struct attrib_list *) NULL ;
    }
    /* forget about messing with data member of struct */
    oldvarlist = oldvarlist->next ;
    if (oldvarlist != (VAR_INFO *) NULL) {
      lclnewvarlistptr = &((*lclnewvarlistptr)->next) ;
    }
    /* following added by jma to fix redhat linux problem */
    else sprintf(pout, " ") ;
  } /* end while there's still a list cell to copy */
  return Success ;
}

int
copy_attr_list(struct attrib_list **first_list1,
               struct attrib_list *first_list2) {
  struct attrib_list *this_struct_ptr, *new_struct_ptr ;
  int indx ;
  char *charptr1, *charptr2 ;
  short *shortptr1, *shortptr2 ;
  long *longptr1, *longptr2 ;
  float *floatptr1, *floatptr2 ;
  double *dblptr1, *dblptr2 ;

  if (first_list2 == (struct attrib_list*)NULL) {
    /*        return Failure ; */
    *first_list1 == (struct attrib_list*)NULL;
    return Success ;
  }
  if ((*first_list1 = 
       (struct attrib_list *) malloc(sizeof(struct attrib_list))) ==
      (struct attrib_list *) NULL) {
    return Failure ;
  }
  for(this_struct_ptr = first_list2, new_struct_ptr =  *first_list1;
      this_struct_ptr != (struct attrib_list *)NULL ;
      this_struct_ptr = this_struct_ptr->next) {
    new_struct_ptr->next = this_struct_ptr->next ;
    new_struct_ptr->name = strdup(this_struct_ptr->name) ;
    new_struct_ptr->type = this_struct_ptr->type ;
    new_struct_ptr->len = this_struct_ptr->len ;
    if ((new_struct_ptr->data =
	 (void *) malloc((size_t)(new_struct_ptr->len *
				  nctypelen(new_struct_ptr->type))))
	== (void *) NULL) {
      return Failure ;
    }
    switch (new_struct_ptr->type) {
    case NC_BYTE:
    case NC_CHAR:
      charptr1 = (char *) new_struct_ptr->data ;
      charptr2 = (char *) this_struct_ptr->data ;
      break ;
    case NC_SHORT:
      shortptr1 = (short *) new_struct_ptr->data ;
      shortptr2 = (short *) this_struct_ptr->data ;
      break ;
    case NC_LONG:
      longptr1 = (long *) new_struct_ptr->data ;
      longptr2 = (long *) this_struct_ptr->data ;
      break ;
    case NC_FLOAT:
      floatptr1 = (float *) new_struct_ptr->data ;
      floatptr2 = (float *) this_struct_ptr->data ;
      break ;
    case NC_DOUBLE:
      dblptr1 = (double *) new_struct_ptr->data ;
      dblptr2 = (double *) this_struct_ptr->data ;
      break ;
    } /* esac */
    for (indx = 0 ;  indx < new_struct_ptr->len ;  ++indx) {
      switch (new_struct_ptr->type) {
      case NC_BYTE:
      case NC_CHAR:
	charptr1[indx] = charptr2[indx] ;
	break ;
      case NC_SHORT:
	shortptr1[indx] = shortptr2[indx] ;
	break ;
      case NC_LONG:
	longptr1[indx] = longptr2[indx] ;
	break ;
      case NC_FLOAT:
	floatptr1[indx] = floatptr2[indx] ;
	break ;
      case NC_DOUBLE:
	dblptr1[indx] = dblptr2[indx] ;
	break ;
      } /* esac */
    } /* end for */
    if (this_struct_ptr->next != (struct attrib_list *)NULL) {
      if ((new_struct_ptr->next =
	   (struct attrib_list *) malloc(sizeof(struct attrib_list)))
	  == (struct attrib_list *)NULL) {
	return Failure ;
      } /* if malloc failure */
    } /* if there's more list to do, malloc next cell */
  } /* while linked list isn't over */
  return Success ;
}


/* initialize dimension information */
int
init_dim_info (dimids, dimnam, dimsiz)
     int        *dimids;		/* array of dimension IDs   */
     char        dimnam[MAX_NC_DIMS][MAX_NC_NAME + 1];	/* array of dimension
							 * names */
     long       *dimsiz;		/* array of dimension sizes */
{
  int         i;

  /* set all dimension information to bogus values */
  for (i = 0; i < MAX_NC_DIMS; i++)
    {
      dimids[i] = -1;
      dimnam[i][0] = '\0';
      dimsiz[i] = -1;
    }

  return Success;
}

/* initialize a variable structure */
int
init_var_info (var)
     VAR_INFO  **var;		/* variable data structure */
{
  int         i;

  void        free_var_info ();

  if (*var != NULL)
    free_var_info (var);

  /* get memory */
  if ((*var = (VAR_INFO *) malloc (sizeof (VAR_INFO))) == NULL)
    {
      printf ("Could not allocate memory for variable information.\n");
      return Failure;
    }

  /* initialize contents to bogus values */
  (*var)->next = NULL;
  (*var)->varid = -1;
  (*var)->varnam[0] = '\0';
  (*var)->gradsabbr[0] = '\0' ;
  (*var)->vartype = -1;
  (*var)->nvardims = 0;
  (*var)->nvatts = 0;

  for (i = 0; i < MAX_VAR_DIMS; i++)
    (*var)->vardimid[i] = -1;
  for (i = 0 ;  i < 4 ;  ++i) {
    (*var)->dimmap[i] = -1 ;
    (*var)->dimidmap[i] = -1 ;
  }

  (*var)->first_vattr = NULL;
  (*var)->data = NULL;
  (*var)->dimmap[0] = (*var)->dimmap[1] = (*var)->dimmap[2] = 
    (*var)->dimmap[3] = -1 ;
  (*var)->dimidmap[0] = (*var)->dimidmap[1] = (*var)->dimidmap[2] =
    (*var)->dimidmap[3] = -1 ;
  return Success;
}

/* free a netCDF standard file structure */
void
free_io_std (std_ptr)
     IO_STD    **std_ptr;
{
  void        free_var_info ();
  int         free_netcdf_att_list ();

  if (*std_ptr != NULL)
    {
      /* if the variable list exists, free it */
      if ((*std_ptr)->var != NULL)
	free_var_info (&((*std_ptr)->var));

      /* free the global attributes if they have been allocated */
      if (((*std_ptr)->first_gattr != NULL) && ((*std_ptr)->ngatts > 0)) {
	free_netcdf_att_list (&((*std_ptr)->first_gattr));
      }

      /* now free the IO_STD structure itself */
      if (*std_ptr) {
        free (*std_ptr);
      }
      *std_ptr = NULL;
    }

  return;
}

/* free a variable structure */
void
free_var_info (var)
     VAR_INFO  **var;
{
  void        free_var_info ();
  int	      free_netcdf_att_list ();

  /* go through list to the end and free all variable structures */
  if ((*var)->next != NULL)
    free_var_info (&((*var)->next));

  if (((*var)->first_vattr != NULL) && ((*var)->nvatts > 0)) {
    free_netcdf_att_list (&((*var)->first_vattr));
  }

  /* if data space has been allocated, free it */
  if ((*var)->data != NULL) {
    free ((*var)->data);
  }

  /* now free the variable structure itself */
  if (*var) {
    free (*var);
  }
  *var = NULL;

  return;
}

/* Free a netCDF attribute list. */
int
free_netcdf_att_list (first_attr)
     struct attrib_list **first_attr;	/* First attribute in list. */
{
  struct attrib_list *temp_attr,
    *save_attr;

  temp_attr = *first_attr;
  while (temp_attr != NULL) {
    save_attr = temp_attr->next;
    if (temp_attr->data != NULL) {
      free (temp_attr->data);
    }
    free (temp_attr);
    temp_attr = save_attr;
  }
  *first_attr = NULL;
  return Success;
}

/* open and read the contents of a netCDF file 		*/
/* std_ptr should already be initialized by init_io_std */
int
read_io_std (path, std_ptr)
     char       *path;		/* file pathname 		 */
     IO_STD     *std_ptr;		/* data structure to be filled  */
{
  int         inq_netcdf (),
    open_netcdf (),
    close_netcdf (),
    read_atts (),
    read_dims (),
    read_vars ();
  void        handle_error ();
  int         set_time_type ();

  if ((path == NULL) || (strlen (path) == 0))
    return Failure;

  if (open_netcdf (path, 0, &(std_ptr->cdfid)) != Success)
    {
#if USEHDF == 1
      printf ("%s does not exist or is not a netCDF/HDF-SDS file.\n", path);
#else
      printf ("%s does not exist or is not a netCDF file.\n", path) ;
#endif
      return Failure;
    }

  /* Get general information.  If error, return. */
  if (inq_netcdf (std_ptr->cdfid, &(std_ptr->ndims), &(std_ptr->nvars),
		  &(std_ptr->ngatts), &(std_ptr->recdim)) != Success)
    {
      (void) close_netcdf (std_ptr->cdfid);
      return Failure;
    }
  if (std_ptr->ndims > MAX_NC_DIMS) {
    std_ptr->ndims = MAX_NC_DIMS ;
    fprintf(stderr, "Only first %d dimensions processed; library limit.\n",
            MAX_NC_DIMS) ;
  }
  /* Create the global attribute list. */
  if (read_atts (std_ptr->cdfid, NC_GLOBAL, std_ptr->ngatts,
		 &(std_ptr->first_gattr)) != Success)
    {
      (void) close_netcdf (std_ptr->cdfid);
      return Failure;
    }

  /* get dimension information */
  if (read_dims (std_ptr) != Success)
    {
      (void) close_netcdf (std_ptr->cdfid);
      return Failure;
    }

  /* inquire about variable(s) */
  if (read_vars (std_ptr->cdfid, std_ptr->nvars, &(std_ptr->var)) != Success)
    {
      (void) close_netcdf (std_ptr->cdfid);
      return Failure;
    }

  /* determine if new or old units are being used */
  if (set_time_type (std_ptr) != Success)
    ;
  /*    return Failure; */

  /* set up standard tables according to time unit being used */
  if (init_standard_arrays (std_ptr->time_type) != Success)
    ;
  /*    return Failure; */

  return Success;
}

int
init_standard_arrays (time_type)
     int         time_type;
{
  if (time_type == CDC)
    {
      dims = cdc_dims;
      vars = cdc_vars;
      var_type = cdc_var_type;
      var_atts = cdc_var_atts;
      var_atts_type = cdc_var_atts_type;
      var_atts_val = cdc_var_atts_val;
      obs_atts_val = cdc_obs_atts_val;
      vatts_abbrev = cdc_vatts_abbrev;
      time_atts = cdc_time_atts;
      time_atts_val = cdc_time_atts_val;
      latlon_atts = cdc_latlon_atts;
      num_reqd_vatts = NUM_REQD_VATTS;
      num_reqd_vars = NUM_REQD_VARS;
      num_reqd_dims = NUM_REQD_DIMS;
    }
  else
    {
      dims = coop_dims;
      vars = coop_vars;
      var_type = coop_var_type;
      var_atts = coop_var_atts;
      var_atts_type = coop_var_atts_type;
      var_atts_val = coop_var_atts_val;
      obs_atts_val = coop_obs_atts_val;
      vatts_abbrev = coop_vatts_abbrev;
      time_atts = coop_time_atts;
      time_atts_val = coop_time_atts_val;
      latlon_atts = coop_latlon_atts;
      num_reqd_vatts = NUM_REQD_COOP_VATTS;
      num_reqd_vars = NUM_REQD_COOP_VARS;
      num_reqd_dims = NUM_REQD_COOP_DIMS;
    }

  return Success;
}

int
set_time_type (in_ptr)
     IO_STD     *in_ptr;
{
  VAR_INFO *time = NULL, *lclvar;
  char *ch ;
  utUnit timeunit ;
  struct attrib_list *units;
  struct attrib_list *find_att ();
  VAR_INFO *find_var ();

  /* the name of the time variable and its units attribute is the same */
  /*for both the cdc and cooperative standards.  Since the "vars" and  */
  /* "time_atts" arrays are not yet initialized, use the cdc variable  */
  /* and attributes definitions */
  time = find_var (in_ptr, cdc_vars[TIME_IX]);
  if (!time) {
    /* Apply COARDSian heuristics on units to find a time-type coordvar */
    /* If that fails, complain and return failure */
    for (lclvar = in_ptr->var ;  lclvar ;  lclvar = lclvar->next) {
      if ((lclvar->nvardims) != 1) continue ;
      units = find_att(lclvar->first_vattr, cdc_time_atts[T_UNITS_IX]) ;
      if (!units) continue ;
      ch = (char *) malloc(units->len + 1) ;
      strncpy(ch, (char *) units->data, units->len) ;
      ch[units->len] = '\0' ;
      if (utScan(ch, &timeunit)) {
	if (ch) {
	  free(ch) ;
	}
	continue ;
      }
      if (ch) {
	free(ch) ;
      }
      if (utIsTime(&timeunit)) {
	time = lclvar ;
	break ;
      }
    } /* end for */
  } /* end if !time */
  if (!time) /* still no time; give up */ {
    return Failure ;
  }
  if ((units = find_att (time->first_vattr, cdc_time_atts[T_UNITS_IX])) 
      == NULL)
    return Failure;

  if (!strncasecmp ("yyyy", (char *) units->data, 4))
    /* it's the old style */
    in_ptr->time_type = CDC;
  else
    in_ptr->time_type = COOP;

  return Success;
}

/* return an attribute structure, given the name of the attribute */
struct attrib_list *
find_att (first_att, attname)
     struct attrib_list *first_att;	/* attribute list to search */
     char       *attname;		/* attribute to find */
{
  static struct attrib_list *temp = NULL;

  temp = first_att;
  while (temp != NULL) {
    if (!strcmp (attname, temp->name)) break;
    temp = temp->next;
  }
  return (struct attrib_list *) temp;
}

/* Open the netCDF pathname for input or output. Return <0 if error;
   else return 0. */
int
open_netcdf (pathname, cflag, cdfid)
     char       *pathname;		/* file to open */
     int         cflag;		/* for output, clobber flag (NC_CLOBBER,NC_NOCLOBBER) */
     int        *cdfid;		/* (returned) netCDF id */
{
#if USEHDF ==1
  int oldncopts ;      /* to save and restore */
  oldncopts = ncopts ;
  ncopts = 0;   /* Turn off automatic error handling. */
  /* Open input file */
  *cdfid = ncopen (pathname, NC_NOWRITE); 
  if (*cdfid == -1) {
    ncopts = oldncopts ;
    return Failure;
  }
  ncopts = oldncopts ;
#else
  int error_code ; /* version 3 NetCDF API error handling */
  error_code = NC_NOERR ;
  /* Open input file */
  error_code = nc_open(pathname, NC_NOWRITE, cdfid) ;
  if (error_code != NC_NOERR) {
    fprintf(stderr, "nc_open failure:\n%s\n", nc_strerror(error_code)) ;
    return(Failure) ;
  }
#endif

  return Success;
}


/* Close the netCDF file.  Return <0 if error; else return 0. */
int
close_netcdf (cdfid)
     int         cdfid;		/* netCDF id */
{
  int oldncopts ;     /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  if (ncclose (cdfid) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  ncopts = oldncopts ;
  return Success;
}


/* Inquire about the netCDF file.  Return <0 if error; else return 0. */
int
inq_netcdf (cdfid, ndims, nvars, ngatts, recdim)
     int         cdfid;		/* netCDF id */
     int        *ndims;		/* (returned) number of dimensions */
     int        *nvars;		/* (returned) number of variables */
     int        *ngatts;		/* (returned) number of global attributes */
     int        *recdim;		/* (returned) record dimension, if any */
{
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  if (ncinquire (cdfid, ndims, nvars, ngatts, recdim) == -1) {
    /* Possible errors include NC_EBADID (invalid netCDF id), which could
     * mean the netCDF id is bad or the file is closed. */
    ncopts = oldncopts ;
    return Failure;
  }

  ncopts = oldncopts ;
  return Success;
}

/* Inquire about a netCDF variable.  Return <0 if error; else return 0. */
int
inq_netcdf_var (cdfid, varid, varname, vartype, nvardims, vardims, natts)
     int         cdfid;		/* netCDF id */
     int         varid;		/* variable id */
     char       *varname;		/* (returned) variable name */
     nc_type    *vartype;

     /* (returned) variable data type */
     int        *nvardims;		/* (returned) number of dimensions */
     int        *vardims;		/* (returned) array of dimension numbers */
     int        *natts;		/* (returned) number of attributes */
{
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  /* Inquire about the variable. */
  if (ncvarinq (cdfid, varid, varname, vartype, nvardims,
		vardims, natts) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  ncopts = oldncopts ;
  return Success;
}

void
init_att (new_att, msg)
     struct attrib_list **new_att;	/* attribute to create and initialize */
     char       *msg;		/* error message string */
{
  if ((*new_att = (struct attrib_list *) malloc (sizeof (struct attrib_list)))
      == NULL)
    return;

  /* initialize all attribute components */
  (*new_att)->next = NULL;
  (*new_att)->name = NULL;
  (*new_att)->type = NC_UNSPECIFIED;
  (*new_att)->len = 0;
  (*new_att)->data = NULL;

  return;
}

/* read attribute information for a file or variable */
int
read_atts (cdfid, varid, natts, first_attr)
     int         cdfid;		/* netCDF file ID */
     int         varid;		/* variable ID or NC_GLOBAL for global
				 * attribute read 			 */
     int         natts;		/* number of attributes to retrieve */
     struct attrib_list **first_attr;/* first attribute in linked list */
{
  int         i;
  struct attrib_list *curr,
    *prev;
  char        name[MAX_NC_NAME + 1];

  int         get_netcdf_attname (),
    get_netcdf_att_info ();
  int         free_netcdf_att_list ();
  void        init_att ();

  curr = prev = NULL;

  /* first make sure nothing is already in the list */
  if (*first_attr != NULL)
    free_netcdf_att_list (first_attr);

  /* loop on all attributes */
  for (i = 0; i < natts; i++) {
    /* allocate and initialize attribute space */
    init_att (&curr, "read_atts");

    /* update pointers */
    if (*first_attr == NULL)
      *first_attr = curr;
    else
      prev->next = curr;

    curr->next = NULL;
    prev = curr;

    /* get attribute name */
    if (get_netcdf_attname (cdfid, varid, i, name) != Success)
      return Failure;
    copy_char_str (&(curr->name), name);

    /* now get attribute information */
    if (get_netcdf_att_info (cdfid, varid, curr->name,
			     &(curr->type), &(curr->len), &(curr->data))
	!= Success)
      return Failure;
  }
  return Success;
}

/* Get attribute name.  Return <0 if error; else return 0. */
int
get_netcdf_attname (cdfid, varid, attnum, name)
     int         cdfid;		/* netcdf id */
     int         varid;		/* variable id */
     int         attnum;		/* attribute number */
     char       *name;		/* (returned) attribute name */
{
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  if (ncattname (cdfid, varid, attnum, name) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  /* All OK. */
  ncopts = oldncopts ;
  return Success;
}


/* Get attribute information.  If error, return <0; else, return 0. */
int
get_netcdf_att_info (cdfid, varid, aname, atype, alen, adata)
     int         cdfid;		/* netcdf id */
     int         varid;		/* variable id */
     char       *aname;		/* attribute name */
     nc_type    *atype;		/* (returned) attribute type */
     int        *alen;		/* (returned) attribute length */
     void      **adata;		/* (returned) attribute data */
{
  int oldncopts ; /* to save and restore */
  char       *char_ptr;

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  if (ncattinq (cdfid, varid, aname, atype, alen) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  /* Allocate space for values. */
  if ((*atype == NC_BYTE) || (*atype == NC_CHAR))  {
    *adata = (char *) malloc (sizeof (char) * (*alen + 1));
  }  else if (*atype == NC_SHORT)  {
    *adata = (short *) malloc (sizeof (short) * *alen);
  }  else if (*atype == NC_LONG)  {
    *adata = (long *) malloc (sizeof (long) * *alen);
  }  else if (*atype == NC_FLOAT)   {
    *adata = (float *) malloc (sizeof (float) * *alen);
  }  else if (*atype == NC_DOUBLE) {
    *adata = (double *) malloc (sizeof (double) * *alen);
  }  else {
    ncopts = oldncopts ;
    return Failure;
  }

  if (*adata == NULL) {
    ncopts = oldncopts ;
    return Failure;
  }

  /* Retrieve values. */
  if (ncattget (cdfid, varid, aname, (void *) (*adata)) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  /* If character, set last byte to null. */
  if (*atype == NC_CHAR)  {
    char_ptr = (char *) *adata;
    char_ptr[*alen] = '\0';
  }

  /* All OK. */
  ncopts = oldncopts ;
  return Success;
}

/* read all dimensions in a file */
int
read_dims (std_ptr)
     IO_STD     *std_ptr;		/* pointer to netCDF data structure */
{
  int         i;
  int         inq_netcdf_dim ();
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  for (i = 0; i < std_ptr->ndims; i++) {
    std_ptr->dimids[i] = i;
    if (inq_netcdf_dim (std_ptr->cdfid, std_ptr->dimids[i],
			std_ptr->dimnam[i], &(std_ptr->dimsiz[i])) != Success) {
      ncopts = oldncopts ;
      return Failure;
    }
  }

  ncopts = oldncopts ;
  return Success;
}

/* Inquire about a netCDF variable.  Return <0 if error; else return 0. */
int
inq_netcdf_dim (cdfid, dimid, dimname, dimsize)
     int         cdfid;		/* netCDF id */
     int         dimid;		/* dimension id */
     char       *dimname;		/* (returned) dimension name */
     long       *dimsize;		/* (returned) dimension size */
{
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  /* Inquire about the dimension. */
  if (ncdiminq (cdfid, dimid, dimname, (long *) dimsize) == -1) {
    /* Possible errors include NC_EBADID (invalid netCDF id), which could
     * mean the netCDF id is bad or the file is closed. */
    ncopts = oldncopts ;
    return Failure;
  }
  
  ncopts = oldncopts ;
  return Success;
}

/* inquire about variable(s).  Note that the actual data aren't	 */
/* read here, but is read via a call to read_variable_data	 */
int
read_vars (cdfid, nvars, var)
     int         cdfid;		/* netCDF file ID 			 */
     int         nvars;		/* number of variables in the file 	 */
     VAR_INFO  **var;		/* pointer to first variable (not
				 * initialized, will be filled and returned)	 */
{
  int         i;
  int oldncopts ; /* to save and restore */
  VAR_INFO   *curr_var = NULL,
    *prev_var = NULL;

  int         init_var_info (),
    inq_netcdf_var (),
    read_atts ();
  void        handle_error ();

  prev_var = NULL;
  oldncopts = ncopts ;

  /* loop through all variables and get the information for each */
  for (i = 0; i < nvars; i++)  {

    /* initialize the variable pointer */
    curr_var = NULL;
    if (init_var_info (&curr_var) != Success) {
      ncopts = oldncopts ;
      return Failure;
    }

    /* update pointers */
    if (*var == NULL)    {
      *var = curr_var;
      prev_var = curr_var;
    }    else    {
      prev_var->next = curr_var;
      prev_var = prev_var->next;
    }

    curr_var->next = NULL;
    curr_var->varid = i;

    /* inquire about the variable information */
    if (inq_netcdf_var (cdfid, i, curr_var->varnam, &(curr_var->vartype),
			&(curr_var->nvardims), curr_var->vardimid, &(curr_var->nvatts))
	!= Success) {
      ncopts = oldncopts ;
      return Failure;
    }

    /* get variable attribute information */
    if (read_atts (cdfid, curr_var->varid, curr_var->nvatts,
		   &(curr_var->first_vattr)) != Success) {
      if (close_netcdf (cdfid) != Success) {
        ncopts = oldncopts ;
        return Failure;
      }
    }

  }

  ncopts = oldncopts ;
  return Success;

}

int
get_additional_dimension_ix (ndims, dimids, timedim, latdim, londim)
     int         ndims;
     int        *dimids;
     int         timedim;
     int         latdim;
     int         londim;
{
  int         dim_ix = -1;
  int         i;

  for (i = 0; i < ndims; i++)  {
    if ((dimids[i] != timedim) &&
	(dimids[i] != latdim) &&
	(dimids[i] != londim))    {
      dim_ix = i;
      break;
    }
  }

  return dim_ix;
}

/* find a dimension id, given the dimension name */
int
find_dim (std_ptr, name)
     IO_STD     *std_ptr;		/* pointer to netCDF file information */
     char       *name;		/* name of dimension to find.	      */
{
  int         dim = -1;
  int         i;

  for (i = 0; i < std_ptr->ndims; i++)
    {
      if (!strcmp (std_ptr->dimnam[i], name))
	{
	  dim = std_ptr->dimids[i];
	  break;
	}
    }

  return dim;
}

/* find the index in the dimension id array, given the dimension id */
int
find_dimix (dimids, ndims, dim)
     int         dimids[];		/* array of dimension ids to search */
     int         ndims;		/* number of dimensions in list */
     int         dim;		/* dimension id to find */
{
  int         dimix = -1;
  int         i;

  for (i = 0; i < ndims; i++)
    {
      if (dimids[i] == dim)
	{
	  dimix = i;
	  break;
	}
    }

  return dimix;
}

int
read_one_dimension (in_ptr, var, dimid)
     IO_STD     *in_ptr;
     VAR_INFO   *var;
     int         dimid;		/* dimension to read */
{
  long        *start ;
  long        *count ;

  void        init_start_count ();

  /* set start and count to read coordinate variable values */
  init_start_count (&start, &count, var->nvardims) ;
  count[0] = in_ptr->dimsiz[dimid] ; /* traditional unidata coord. var. defn. */

  if (read_variable_data (in_ptr->cdfid, var, start, count) != Success)
    return Failure;

  return Success;
}

/* initialize start and count arrays */
void
init_start_count (start, count, ndims)
     long       **start;
     long       **count;
     int        ndims ;

{
  int         i ;
  
  if (!((*start) = (long *) malloc(sizeof(long) * ndims))) {
    fprintf(stderr, "Memory allocation error!\n") ;
    exit(13) ;
  }
  if (!((*count) = (long *) malloc(sizeof(long) * ndims))) {
    fprintf(stderr, "Memory allocation error!\n") ;
    exit(13) ;
  }
  for (i = 0 ;  i < ndims ;  i++) {
    (*start)[i] = 0 ;
    (*count)[i] = 1 ;
  }

  return ;
}

/* read variable data */
int
read_variable_data (cdfid, var, start, count)
     int         cdfid;		/* netCDF ID */
     VAR_INFO   *var;		/* pointer to variable structure */
     long       *start;		/* array of start indices */
     long       *count;		/* array of frame counts for each variable
				 * dimension */
{

  int         read_netcdf_data ();
  int         alloc_variable_data ();

  if (alloc_variable_data (var, count) != Success)
    return Failure;

  if (read_netcdf_data (cdfid, var->varid, start, count, var->data)
      != Success)
    return Failure;

  return Success;
}

/* return size of hyperslab */
int
get_hyperslab_size (count, ndims)
     long       *count;		/* array of hyperslab edge counts */
     int         ndims;

{
  int         size;
  int         i;

  size = 1;
  for (i = 0; i < ndims; i++)
    size *= count[i];

  return size;
}

int
alloc_variable_data (var, count)
     VAR_INFO   *var;		/* variable structure which needs memory */
     long       *count;		/* array of frame counts for each var
				 * dimension */
{
  int         malloc_len;
  int         alloc_data_array ();

  /* get rid of any old memory */
  if (var->data != NULL)
    free (var->data);

  /* figure out how much space we need */
  malloc_len = get_hyperslab_size (count, var->nvardims);

  /* now allocate the data array */
  if (alloc_data_array (malloc_len, var->vartype, &(var->data)) != Success)
    return Failure;

  return Success;
}

/* Read data from a variable in a netCDF input file.  Return <0 if error;
   else return 0. */
int
read_netcdf_data (cdfid, varid, start, count, data_array)
     int         cdfid;		/* netCDF id */
     int         varid;		/* variable id */
     long       *start;		/* hyperslab corner */
     long       *count;		/* hyperslab edges */
     void       *data_array;		/* (returned) hyperslab of data values */
{
  int         rcode;
  int oldncopts ; /* to save and restore */

  oldncopts = ncopts ;
  /* Turn off automatic error handling. */
  ncopts = 0;

  /* Read the data. */

  if (ncvarget (cdfid, varid, (long *) start, (long *) count, data_array) == -1) {
    ncopts = oldncopts ;
    return Failure;
  }

  ncopts = oldncopts ;
  return Success;
}

/* Allocate one data array.  If OK, return Success.  If error, return Failure.*/
int
alloc_data_array (malloc_len, datatype, data_array)
     int         malloc_len;		/* data array length */
     nc_type     datatype;		/* data type */
     void      **data_array;		/* (returned) data array pointer */

{
  char        str[256];

  /* Allocate data array. */
  switch (datatype)
    {
    case (NC_BYTE):
      *data_array = (void *) malloc (sizeof (char) * malloc_len);
      break;
    case (NC_SHORT):
      *data_array = (void *) malloc (sizeof (short) * malloc_len);
      break;
    case (NC_LONG):
      *data_array = (void *) malloc (sizeof (long) * malloc_len);
      break;
    case (NC_FLOAT):
      *data_array = (void *) malloc (sizeof (float) * malloc_len);
      break;
    case (NC_DOUBLE):
      *data_array = (void *) malloc (sizeof (double) * malloc_len);
      break;
    default:
      return Failure;
    };

  if (*data_array == NULL)
    return Failure;

  /* All OK. */
  return Success;
}

/* find a variable pointer, given the variable name */
VAR_INFO   *
find_var (std_ptr, var_name)
     IO_STD     *std_ptr;
     char       *var_name;
{
  int         i;
  static VAR_INFO *found = NULL;
  VAR_INFO   *curr_var;

  found = NULL;
  curr_var = std_ptr->var;

  for (i = 0; i < std_ptr->nvars; i++)
    {
      if (curr_var == NULL)
	break;

      if (!strcmp (var_name, curr_var->varnam))
	{
	  found = curr_var;
	  break;
	}
      curr_var = curr_var->next;
    }

  return (VAR_INFO *) found;
}

/* Check if two single precision values are equal.  If they are within */
/* 1/10000000 of each other they are considered equal and 1 is */
/* returned.  Else 0 is returned. */
int
flt_equal(f1, f2)
     float f1, f2;
{
  float ftemp, ftarg1 = -0.0000001, ftarg2 = 0.0000001, flarge, af1, af2;
  double      dtemp;
  int         iscale, i;

  /* First check if the two numbers are exactly equal. */
  if (f1 == f2) {
    return 1;
  }
  /* Next, check if their significant digits are within the specified range. */
  af1 = f1;
  af2 = f2;
  if (af1 < 0) {
    af1 *= -1.0 ;
  }
  if (af2 < 0) {
    af2 *= -1.0 ;
  }
  if (af1 >= af2) {
    flarge = af1;
  } else {
    flarge = af2;
  }
  /* If the larger number is less than zero, return. */
  if (flarge < 1) {
    return 0;
  }
  /* Otherwise, check for significant digits. */
  iscale = 1;
  for (i = 0; i <= 6; i++) {
    dtemp = pow(10.0, (double) i);
    if (flarge < (float) dtemp) {
      break;
    } else {
      iscale *= 10;
    }
  }
  ftarg1 *= (float) iscale;
  ftarg2 *= (float) iscale;
  ftemp = f1 - f2;
  if ((ftemp >= ftarg1) && (ftemp <= ftarg2)) {
    return 1;
  } else {
    return 0;
  }
}

/* Check if two double precision values are equal.  If they are within
   1/10000000 of each other they are considered equal and
   True is returned.  Otherwise False is returned. */
int
dbl_equal (d1, d2)
     double      d1,
  d2;
{
  double      dtemp,
    dtarg1 = -0.0000001,
    dtarg2 = 0.0000001;

  /* First check if the two numbers are exactly equal. */
  if (d1 == d2)
    return Failure;

  /* Next, check if they are within the specified range. */
  dtemp = d1 - d2;
  if ((dtemp >= dtarg1) && (dtemp <= dtarg2))
    return Failure;
  else
    return Success;
}

int
decode_delta_t (delta_t_str, year, month, day, hour, minn, sec)
     char       *delta_t_str;
     int        *year;
     int        *month;
     int        *day;
     int        *hour;
     int        *minn;
     int        *sec;
{
  int         year_mark = 4,
    month_mark = 7,
    day_mark = 10,
    hour_mark = 13,
    minute_mark = 16,
    second_mark = 19;
  int         delta_t_len;
  char        temp_str[100];

  *year = *month = *day = *hour = *minn = *sec = MISSING;

  delta_t_len = strlen (delta_t_str);
  if ((delta_t_len > day_mark) && (delta_t_str[day_mark] != ' '))
    return Failure;
  if ((delta_t_len > hour_mark) && (delta_t_str[hour_mark] != ':'))
    return Failure;
  if ((delta_t_len > minute_mark) && (delta_t_str[minute_mark] != ':'))
    {
      return Failure;
    }

  /* Get year. */
  strcpy (temp_str, delta_t_str);
  temp_str[year_mark] = '\0';
  sscanf (temp_str, "%d", year);

  /* Get month. */
  strcpy (temp_str, &delta_t_str[year_mark + 1]);
  temp_str[month_mark - year_mark - 1] = '\0';
  sscanf (temp_str, "%d", month);

  /* Get day. */
  strcpy (temp_str, &delta_t_str[month_mark + 1]);
  temp_str[day_mark - month_mark - 1] = '\0';
  sscanf (temp_str, "%d", day);

  /* Get other fields if present. */
  if (delta_t_len > day_mark)
    {

      /* Get hour. */
      strcpy (temp_str, &delta_t_str[day_mark + 1]);
      temp_str[hour_mark - day_mark - 1] = '\0';
      sscanf (temp_str, "%d", hour);

      /* Get minute. */
      strcpy (temp_str, &delta_t_str[hour_mark + 1]);
      temp_str[minute_mark - hour_mark - 1] = '\0';
      sscanf (temp_str, "%d", minn);

      /* Get second. */
      strcpy (temp_str, &delta_t_str[minute_mark + 1]);
      temp_str[second_mark - minute_mark - 1] = '\0';
      sscanf (temp_str, "%d", sec);

    }
  else
    *hour = *minn = *sec = MISSING;

  return Success;
}

/* Copy character strings in read structure. */
copy_char_str (dest, source)
     char      **dest;
     char       *source;
{
  int         malloc_len;
  
  /* Free existing string. */
  if (*dest != NULL)
    free (*dest);
  *dest = NULL;
	    
  /* If source string exists, allocate corresponding dest string and copy
   * source. */
  if (source != NULL) {
    malloc_len = strlen (source) + 1;
    *dest = (char *) malloc (sizeof (char) * malloc_len);
    if (*dest == NULL)
      return Failure;
    strcpy (*dest, source);
  }
  return Success;
}

/* see if variable data are packed. */
/* Hoop, 2000/02/01 short-circuit to "not-packed" if sf&ao are default valued */
int
are_data_packed (in_var, scale, offset, converted_type, input_type)
     VAR_INFO   *in_var;		        /* input variable structure      */
     union att_val *scale;		/* scale value, cast to type     */
     union att_val *offset;		/* offset value, cast to type    */
     nc_type    *converted_type;	        /* unpacked data type (returned) */
     nc_type    *input_type;		/* packed data type (returned)   */

{
  int         convert = 0, dfltsf_ao = 0 ;
  struct attrib_list *scale_att, *offset_att;
  union att_val junk;
  void        set_data_to_type();

  /* initialize types */
  *input_type = in_var->vartype;
  *converted_type = NC_UNSPECIFIED;

  /* get scale and offset attributes */
  scale_att = find_att(in_var->first_vattr, SFNAME) ;
  if (!scale_att) {
    scale_att = find_att(in_var->first_vattr, SFNAME2) ;
  }
  offset_att = find_att(in_var->first_vattr, AONAME) ;
  if (!offset_att) {
    offset_att = find_att(in_var->first_vattr, AONAME2) ;
  }

  if (scale_att == NULL && offset_att == NULL) {
    /* scale and offset do not exist; assume data are unpacked */
    *converted_type = *input_type;
    convert = 0;
  } else {
    if (scale_att != NULL) {
      *converted_type = scale_att->type;
      set_data_to_type(scale_att->type, 0, scale_att->data, scale);
    }
    if (offset_att != NULL) {
      *converted_type = offset_att->type;
      set_data_to_type(offset_att->type, 0, offset_att->data, offset);
    }

    if (scale_att == NULL) {
      set_default_scale_offset(*converted_type, scale, &junk);
    }
    if (offset_att == NULL) {
      set_default_scale_offset(*converted_type, &junk, offset);
    }
    switch (*converted_type) {
    case NC_BYTE:
      if (scale->bval != B_SCALE || offset->bval != B_OFFSET) {
	convert = 1;
      } else {
	dfltsf_ao = 1 ;
      }
      break;
    case NC_SHORT:
      if (scale->sval != S_SCALE || offset->sval != S_OFFSET) {
	convert = 1;
      } else {
	dfltsf_ao = 1 ;
      }
      break;
    case NC_LONG:
      if (scale->lval != L_SCALE || offset->lval != L_OFFSET) {
	convert = 1;
      } else {
	dfltsf_ao = 1 ;
      }
      break;
    case NC_FLOAT:
      if (!flt_equal(scale->fval, F_SCALE) ||
	  !flt_equal(offset->fval, F_OFFSET)) {
	convert = 1;
      } else {
	dfltsf_ao = 1 ;
      }
      break;
    case NC_DOUBLE:
      if (!dbl_equal(scale->dval, D_SCALE) ||
	  !dbl_equal(offset->dval, D_OFFSET)) {
	convert = 1;
      } else {
	dfltsf_ao = 1 ;
      }
      break;
    default:
      break;
    } /* end switch */

    /* also check to see if type conversion is necessary */
    if (*converted_type != *input_type) {
      if (dfltsf_ao == 1) {
	convert = 0 ;
      } else {
	convert = 1;
      }
    }
  } /* end else (either scale or offset or both exist in else ) */

  return(convert) ;
}

int
set_default_scale_offset (type, scale, offset)
     nc_type     type;		/* scale and offset data type */
     union att_val *scale;		/* pointer to scale data */
     union att_val *offset;		/* pointer to offset data */

{
  switch (type)
    {
    case NC_BYTE:
      scale->bval = B_SCALE;
      offset->bval = B_OFFSET;
      break;
    case NC_SHORT:
      scale->sval = S_SCALE;
      offset->sval = S_OFFSET;
      break;
    case NC_LONG:
      scale->lval = L_SCALE;
      offset->lval = L_OFFSET;
      break;
    case NC_FLOAT:
      scale->fval = F_SCALE;
      offset->fval = F_OFFSET;
      break;
    case NC_DOUBLE:
      scale->dval = D_SCALE;
      offset->dval = D_OFFSET;
      break;
    default:
      break;
    }
  return Success;
}

#ifdef TESTING
void
xdumpreq(struct gagrid *gridptr) {
  void xdumpfile(struct gafile *fileptr) ;
  void xdumpvar(struct gavar *varptr) ;
    
  fprintf(stderr, "grid request address=0x%X;\n", gridptr) ;
  fprintf(stderr, "grid=0x%X; undef=%E; rmin=%E; rmax=%E;\n",
	  gridptr->grid, gridptr->undef, gridptr->rmin, gridptr->rmax) ;
  fprintf(stderr, "isiz=%d; jsiz=%d; idim=%d; jdim=%d;\n",
	  gridptr->isiz, gridptr->jsiz, gridptr->idim, gridptr->jdim) ;
  fprintf(stderr, "dimmin: %d; %d; %d; %d;\n", gridptr->dimmin[0],
	  gridptr->dimmin[1], gridptr->dimmin[2], gridptr->dimmin[3]) ;
  fprintf(stderr, "dimmax: %d; %d; %d; %d;\n", gridptr->dimmax[0],
	  gridptr->dimmax[1], gridptr->dimmax[2], gridptr->dimmax[3]) ;
  if (gridptr->exprsn) {
    fprintf(stderr, "exprsn=%s;\n", gridptr->exprsn) ;
  } else {
    fprintf(stderr, "exprsn is null;\n") ;
  }
  fprintf(stderr, "alocf=%d;\n", gridptr->alocf) ;
  fprintf(stderr, "igrab=0x%X; jgrab=0x%X; iabgr=0x%X; jabgr=0x%X;\n",
	  gridptr->igrab, gridptr->jgrab, gridptr->iabgr, gridptr->jabgr) ;
  fprintf(stderr, "ivals=0x%X; jvals=0x%X; iavals=0x%X; javals=0x%X;\n",
	  gridptr->ivals, gridptr->jvals, gridptr->iavals, gridptr->javals) ;
  fprintf(stderr, "ilinr=%d; jlinr=%d;\n", gridptr->ilinr, gridptr->jlinr) ;
  fprintf(stderr, "Calling xdumpfile from xdumpreq.\n") ;
  xdumpfile(gridptr->pfile) ;
  fprintf(stderr, "Calling xdumpvar from xdumpreq.\n") ;
  xdumpvar(gridptr->pvar) ;
}

void
xdumpfile(struct gafile *fileptr) {
  int varinx ;

  fprintf(stderr, "======== start of gafile structure info dump ============\n");
  fprintf(stderr, "file address=0x%X;\n", fileptr) ;
  fprintf(stderr, "pforw=0x%X; infile=0x%X; type=%d; undef=%E;\n",
	  fileptr->pforw, fileptr->infile, fileptr->type, fileptr->undef) ;
  if (fileptr->name) {
    fprintf(stderr, "name=%s;\n", fileptr->name) ;
  } else {
    fprintf(stderr, "name is null.\n") ;
  }
  if (fileptr->dnam) {
    fprintf(stderr, "dnam=%s;\n", fileptr->dnam) ;
  } else {
    fprintf(stderr, "dnam is null.\n") ;
  }
  if (fileptr->mnam) {
    fprintf(stderr, "mnam=%s;\n", fileptr->mnam) ;
  } else {
    fprintf(stderr, "mnam is null.\n") ;
  }
  if (fileptr->title) {
    fprintf(stderr, "title=%s;\n", fileptr->title) ;
  } else {
    fprintf(stderr, "title is null.\n") ;
  }
  fprintf(stderr, "ulow=%E; uhi=%E;\n", fileptr->ulow, fileptr->uhi) ;
  fprintf(stderr, "rbuf=0x%X; pbuf=0x%X; bbuf=0x%X;\n", fileptr->rbuf,
	  fileptr->pbuf, fileptr->bbuf) ;
  fprintf(stderr, "bswap=%d; mtype=%d; tstrt=0x%X; tcnt=0x%X;\n",
	  fileptr->bswap, fileptr->mtype, fileptr->tstrt, fileptr->tcnt) ;
  fprintf(stderr, "stcnt=%d; stpos=%d; mfile=0x%X;\n", fileptr->stcnt,
	  fileptr->stpos, fileptr->mfile) ;
  fprintf(stderr, "dnum: %d; %d; %d; %d;\n", fileptr->dnum[0],
	  fileptr->dnum[1], fileptr->dnum[2], fileptr->dnum[3]) ;
  fprintf(stderr, "tlpflg=%d; tlpst=%d; vnum=%d; ivnum=%d; lvnum=%d;\n",
	  fileptr->tlpflg, fileptr->vnum, fileptr->ivnum, fileptr->lvnum) ;
  for (varinx = 0 ;  varinx < fileptr->vnum ;  ++varinx) {
    fprintf(stderr, "var #%d=0x%X;\n", varinx, &(fileptr->pvar1[varinx])) ;
  }
  fprintf(stderr, "gsiz=%d; tsiz=%d; trecs=%d; fhdr=%d;\n",
	  fileptr->gsiz, fileptr->tsiz, fileptr->trecs, fileptr->fhdr) ;
  fprintf(stderr, "wrap=%d; seqflg=%d; yrflg=%d; zrflg=%d;\n",
	  fileptr->wrap, fileptr->seqflg, fileptr->yrflg, fileptr->zrflg) ;
  fprintf(stderr, "ppflag=%d; ppwrot=%d; ppisiz=%d; ppjsiz=%d;\n",
	  fileptr->ppflag, fileptr->ppwrot, fileptr->ppisiz, fileptr->ppjsiz) ;
  fprintf(stderr, "ppi=0x%X; ppf[0]=0x%X; ppf[1]=0x%X;\n", fileptr->ppi,
	  fileptr->ppf[0], fileptr->ppf[1]) ;
  fprintf(stderr, "gr2ab[0]=0x%X; ab2gr[0]=0x%X; grvals[0]=0x%X; abvals[0]=0x%X;\n",
	  fileptr->gr2ab[0], fileptr->ab2gr[0], fileptr->grvals[0], fileptr->abvals[0]) ;
  fprintf(stderr, "linear: %d; %d; %d; %d;\n", fileptr->linear[0],
	  fileptr->linear[1], fileptr->linear[2], fileptr->linear[3]) ;
  fprintf(stderr, "dimoff: %d; %d; %d; %d;\n", fileptr->dimoff[0],
	  fileptr->dimoff[1], fileptr->dimoff[2], fileptr->dimoff[3]) ;
  fprintf(stderr, "climo=%d; cysiz=%d; idxflg=%d, grbgrd=%d;\n",
	  fileptr->climo, fileptr->cysiz, fileptr->idxflg, fileptr->grbgrd) ;
  fprintf(stderr, "pindx=0x%X; tmplat=%d; fnums=0x%X; fnumc=%d;\n",
	  fileptr->pindx, fileptr->tmplat, fileptr->fnums, fileptr->fnumc) ;
  fprintf(stderr, "errcnt=%d; errflg=%d;\n", fileptr->errcnt, fileptr->errflg) ;
  fprintf(stderr, "======== end of gafile structure info dump ============\n");
}

void
xdumpvar(struct gavar *varptr) {

  fprintf(stderr, "var. address=0x%X;\n", varptr) ;
  if (varptr->varnm) {
    fprintf(stderr, "varnm=%s;\n", varptr->varnm) ;
  } else {
    fprintf(stderr, "varnm is null.\n") ;
  }
  if (varptr->abbrv) {
    fprintf(stderr, "abbrv=%s;\n", varptr->abbrv) ;
  } else {
    fprintf(stderr, "abbrv is null.\n") ;
  }
  fprintf(stderr, "units: %d; %d; %d; %d;\n", varptr->units[0],
	  varptr->units[1], varptr->units[2], varptr->units[3]) ;
  fprintf(stderr, "offset=%d; recoff=%d; levels=%d;\n", varptr->offset,
	  varptr->recoff, varptr->levels) ;
}
#endif

/* function to attempt a linear definition of a dimension.  Returns 1 */
/* if successful, 0 if not linearizable, and <0 if an error occurs */

int
trydeflin(struct gafile *pfi, VAR_INFO *coord, int GrADSdimnum, int isX,
          int revflag) {
  float *deltas, coordvals[2], *vals, firstcoordval ;
  int islin, deltaidx ;
  int fequal(float op1, float op2, float tolerance) ;
  int convtype(void *srcptr, nc_type srctype, void *desptr, nc_type destype,
	       int srcindex, int desindex) ;

  if (pfi->dnum[GrADSdimnum] < 2) {
    /* WRONG!        return(0) ; *//* Use levels */ /* gaddes code doesn't do that */
    if (!convtype(coord->data, coord->vartype, (void *) &(coordvals[0]),
		  NC_FLOAT, 0, 0)) {
      gaprnt(0, "Couldn't convert coordinate value to float.\n") ;
      return(-1) ;
    }
    firstcoordval = coordvals[0] ;
    /* Ok, now we emulate deflin code */
    if (!(vals = (float *) malloc(sizeof(float) * 6))) {
      gaprnt(0, "Memory allocation error eval. lin. coord. for SDF.\n") ;
      return(-1) ;
    }
    vals[0] = 1.0 ;
    vals[1] = 0.0 ;
    vals[2] = -999.9 ;
    vals[3] = 1.0 ;
    vals[4] = 0.0 ;
    vals[5] = -999.9 ;
    pfi->grvals[GrADSdimnum] = vals ;
    pfi->abvals[GrADSdimnum] = vals + 3 ;
    pfi->ab2gr[GrADSdimnum] = liconv ;
    pfi->gr2ab[GrADSdimnum] = liconv ;
    pfi->linear[GrADSdimnum] = 1 ;
    if (isX) /* a coordinate of extent one CANNOT wrap the globe */ {
      pfi->wrap = 0 ;
    }
    return(1) ;
  }
  deltas = (float *) malloc(sizeof(float)*(pfi->dnum[GrADSdimnum] - 1)) ;
  if (!deltas) {
    gaprnt(0, "Memory allocation error in trydeflin.\n") ;
    return(-1) ;
  }
  if (!revflag) {
    if (!convtype(coord->data, coord->vartype, (void *) &(coordvals[0]),
		  NC_FLOAT, 0, 0)) {
      gaprnt(0, "Couldn't convert coordinate value to float.\n") ;
      return(-1) ;
    }
  } else {
    if (!convtype(coord->data, coord->vartype, (void *) &(coordvals[0]),
		  NC_FLOAT, pfi->dnum[GrADSdimnum] - 1, 0)) {
      gaprnt(0, "Couldn't convert coordinate value to float.\n") ;
      return(-1) ;
    }
  }
  firstcoordval = coordvals[0] ;
  for (deltaidx = 1 ;  deltaidx < pfi->dnum[GrADSdimnum] ;  ++deltaidx) {
    if (!revflag) {
      if (!convtype(coord->data, coord->vartype, (void *) &(coordvals[0]),
		    NC_FLOAT, deltaidx, 1)) {
	gaprnt(0, "Couldn't convert coordinate value to float.\n") ;
	return(-1) ;
      }
    } else {
      if (!convtype(coord->data, coord->vartype, (void *) &(coordvals[0]),
		    NC_FLOAT, (pfi->dnum[GrADSdimnum] - 1) - deltaidx,
		    1)) {
	gaprnt(0, "Couldn't convert coordinate value to float.\n") ;
	return(-1) ;
      }
    }
    deltas[deltaidx - 1] = coordvals[1] - coordvals[0] ;
    if (isX) {
      if (coordvals[1] < coordvals[0]) {
	deltas[deltaidx - 1] = (360.0 + coordvals[1]) - coordvals[0] ;
      }
    } /* longitudes can wrap around Greenwich and yet be linear */
    coordvals[0] = coordvals[1] ;
  } /* end for */
  islin = 1 ;  /* assume coordinate is linear for now */
  for (deltaidx = 1 ;  deltaidx < (pfi->dnum[GrADSdimnum] - 1) ;  ++deltaidx) {
    if (!fequal(deltas[deltaidx - 1], deltas[deltaidx],
		((float)fabs(deltas[deltaidx])) / 1000.0)) {
      islin = 0 ;
      break ;
    }
  } /* end for */
  if (!islin) {
    return(0) ; /* use levels */
  }
  /* Ok, now we emulate deflin code */
  if (!(vals = (float *) malloc(sizeof(float) * 6))) {
    gaprnt(0, "Memory allocation error eval. lin. coord. for SDF.\n") ;
    return(-1) ;
  }
  vals[0] = deltas[0] ;
  vals[1] = firstcoordval - deltas[0] ;
  vals[2] = -999.9 ;
  vals[3] = 1.0 / deltas[0] ;
  vals[4] = -1.0 * ((firstcoordval - deltas[0]) / deltas[0]) ;
  vals[5] = -999.9 ;
  pfi->grvals[GrADSdimnum] = vals ;
  pfi->abvals[GrADSdimnum] = vals + 3 ;
  pfi->ab2gr[GrADSdimnum] = liconv ;
  pfi->gr2ab[GrADSdimnum] = liconv ;
  pfi->linear[GrADSdimnum] = 1 ;
  if (isX) /* does it wrap the globe? */ {
    /* fabs & fmod take and return doubles, hence the casts */
    if (fequal((float) fabs(fmod((double)(coordvals[1] + deltas[0] - firstcoordval ),
				 (double) 360.0)),
	       (double) 0.0, ((float) fabs((double) deltas[0])) / 2.0)) {
      pfi->wrap = 1 ;
    } else {
      pfi->wrap = 0 ;
    }
  }
  return(1) ;
}

int
fequal(float op1, float op2, float tolerance) {
  /*mf ---- added casts to be consistent with ANSI --- */
  if (fabs((double)op1 - (double)op2) <= (double)tolerance) {
    return(1) ;
  } else {
    return(0) ;
  }
}

int
dequal(double op1, double op2, double tolerance) {
  if (fabs(op1 - op2) <= tolerance) {
    return(1) ;
  } else {
    return(0) ;
  }
}

#endif

#endif 
